Ext.define('MyDashBoard.view.AddExternalMetrics', {
	 extend: 'Ext.container.Container',
	 //extend: 'Ext.window.Window',
     alias: 'widget.addexternalmetrics',
	 requires: ['utilities.CustomGrid','utilities.ScrollCombo','utilities.CommonPanel'],
	 layout: {
        type: 'vbox',
        align: 'stretch'
    },
	flex:1,
	
	//padding:'0 0 0 0',
	cls:'myDashboardwindow',
	ui:'newPopupWindow widgetOptionsWindowHeader',
	closeAction : 'destroy',
	//dataFieldsComboIdArr : [],
	widgetID : '',
	widgetType : '',
	id: 'externalMetricsView',
	dataFieldsComboIdArr : [],
	widgetSettingsJsonArr : [],
	isKpi:false,
	Kpicount: 0,
	totalKpiCount:0,
	kpiBlckId:null,

	initComponent : function()
	{
		var widgetPreviewDimensions={};
		widgetPreviewDimensions['activityChart']=[343 , 248];
		widgetPreviewDimensions['areaChart']=[343,248];
		widgetPreviewDimensions['BarChart']=[427,248];
		widgetPreviewDimensions['combinationChart']=[427,248];
		widgetPreviewDimensions['CombinedTimelineChart']=[427,248];
		widgetPreviewDimensions['ddTable']=[427,248];
		widgetPreviewDimensions['dialChart']=[259,248];
		widgetPreviewDimensions['digitalChart']=[259,248];
		widgetPreviewDimensions['geomap']=[427,248];
		widgetPreviewDimensions['health']=[343,248];
		widgetPreviewDimensions['heatMapChart']=[424,248];
		widgetPreviewDimensions['liveMeasuresBox']=[343,248];
		widgetPreviewDimensions['networkhealth']=[427,248];
		widgetPreviewDimensions['news']=[427,248];
		widgetPreviewDimensions['pieChart']=[343,248];
		widgetPreviewDimensions['servicehealth']=[427,248];
		widgetPreviewDimensions['table']=[427,248];
		widgetPreviewDimensions['tierhealth']=[427,248];
		widgetPreviewDimensions['TimelineChart']=[427,248];
		widgetPreviewDimensions['TopNAnalysis']=[339,203];
		widgetPreviewDimensions['TopologyWidget']=[427,248];
		widgetPreviewDimensions['TrendGraph']=[427,248];
		widgetPreviewDimensions['vmAlarmsWidget']=[427,248];
		widgetPreviewDimensions['weather']=[343,248];

		this.widgetPreviewDimensions=widgetPreviewDimensions;

		this.createExternalWidgetConfigLayout();
		this.callParent();
	},
	createExternalWidgetConfigLayout : function()
	{
		var meExtIntWidgetPopup=this;
		var miscBottomPanlObj={
			xtype:'fieldset',
		
			//title: 'Configure Metrics',
			ui:'newFieldSetHeader',
			//style:{'border':'blue 1px solid'},
			collapsible: false,
			style:{"box-shadow":"none","background":"none"},
			layout : {
								type : 'hbox',
								align:'stretch'
							},
			padding:'0 10 10 10',
			bodyPadding:'0 0 0 0',
			margin:'0 0  0  0',
			defaults: {
				labelAlign: 'top',
				labelSeparator:''
			},
			items:{
		xtype: 'panel',
		layout : {
			type : 'column',
			align:'stretch',
			pack:'start'
		},
		flex:1,
		margin : '0 10px 0 10px',
		defaults: {
			labelAlign: 'top',
			labelSeparator:''
		},
		id : 'widgetChartAttrsCont',
		name : 'widgetChartAttrsCont',
		width:100,
		//margin:10,
		defaults: {
				labelAlign: 'top',
				margin: '10 10 0px 0px',
				labelSeparator:''
			},
		}
		};
		var isChart=false;
		var widgetPreviewTitle='';
		var widgetPnlObj=Ext.getCmp(meExtIntWidgetPopup.widgetID);
		if(!Ext.isEmpty(widgetPnlObj))
		{
			isChart=widgetPnlObj.isChart;
			isTopNChart=widgetPnlObj.isTopNChart;
			widgetPreviewTitle=widgetPnlObj.title;
		}
		var previewContainerHeight=280;
		if(meExtIntWidgetPopup.widgetType!=null && (meExtIntWidgetPopup.widgetType=='dialChart' || meExtIntWidgetPopup.widgetType=='digitalChart'))
		{
			previewContainerHeight=200;
		}
		var isWidgetConfigured=false;
		if(meExtIntWidgetPopup!=null && meExtIntWidgetPopup.action=='editWidget')
		{
				isWidgetConfigured=true;
		}
		var portletWidth=400;
		var portletHeight=250;
		var portletDims=this.widgetPreviewDimensions[meExtIntWidgetPopup.widgetType];
		if(!Ext.isEmpty(portletDims))
		{
			portletWidth=portletDims[0];
			portletHeight=portletDims[1];
		}
			
		this.items={
			 xtype: 'form',
			 layout:{
				type:'vbox',
				align:'stretch'
			 },
			 id : 'externalWidgetConfigForm',
			 name : 'externalWidgetConfigForm',
			 itemId: 'externalConfigForm',
			 cls:'form',
			 //height:250,
			 flex:1,
			 //style:{'border':'blue 1px solid'},
			 fullscreen: true, 
			 scroll:true,
			 autoScroll:true,
			 border:false,
			 padding:'0 0',
			 items : {
						xtype: 'panel', 
						id: 'configSettings',
						cls:'configSettingsWindow',
						flex:1,
						scroll:true,
						autoScroll:true,
						//height:500,
						//style:{'border':'red 1px solid'},
						border:true,
						bodyPadding:'10 10 0 10',
						//scroll:true,
						//autoScroll:true,
						layout : {
							type : 'vbox',
							align:'stretch'
						},
						//hidden: true,
						defaults: {
							labelAlign: 'top',
							labelSeparator:''
						},				
						margin:'0 0 0 0',
						items: [
						{
							xtype:'panel',
							//height:230,
							//style:{'border':'#000 1px solid'},
							margin:'0 0 0 0',
							padding:'0 0 10 0',
							layout : {
								type : 'hbox',
								pack:'center',
							},
							items: [
								{
									xtype:'previewcontiner',
									margin:'4 20 4 10',
									width: portletWidth,
									height  : portletHeight,
									isConfigured : isWidgetConfigured,
									items:[{
									xtype: 'portlet',
									flex:1,
									width: portletWidth - 23,
									height  : portletHeight - 23,
									id: meExtIntWidgetPopup.widgetID+'_previewImage',
									title : widgetPreviewTitle,
									ui : 'newGraphPanel',
									cls:'previewImage',	
									margin:'0 0 0 0',
									isChart : isChart,
									isTopNChart : false,
									showMoreDataOption : false,
									isPreviewMode : true
								}]
								},
								
								{
									//TODO
									xtype: 'container',
									width: 350,
									//flex:1,
									//height: 280,
									cls:'widget_config_form',
									layout: {
										type: 'column'
									},
									id: 'controllerSetting',
									disabledCls:'my-disabled-panel',
									disabled : (meExtIntWidgetPopup.action=='addWidget'?true:false),
									//hidden: true,
									defaults: {
										labelAlign: 'top',
										columnWidth : 1,
										labelSeparator:''
										
									},				
									margin:'0 0 0 0',
									padding:'0 0 0 0'
								}
							]
						},
						miscBottomPanlObj
					]
				},
			  listeners : {
				'afterrender': function()
				 {
					/*if(reCreateLayout)
					{
						meExtIntWidgetPopup.loadPopupData(true);
					}*/
				 }
			 }
			}
	},
	onRender : function () {
		var meExternalWidgetFormObj=this;
	var widgetType=this.widgetType;
	var widgetID=this.widgetID;

	var thisWidgetID = widgetID;
	if(this.isKpi)
	{
		thisWidgetID = this.kpiBlckId+'_'+thisWidgetID;
	}
	else
	{
		thisWidgetID = this.widgetID;
	}

	var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
	//var addExternalMetrics = this.getAddexternalmetrics();
	var addExternalMetrics =  Ext.getCmp('externalMetricsView');
	var paramsForRestURL='DSNName='+encodeURIComponent('')+'&action=loadWidgetOptions'+'&widgetId='+encodeURIComponent(thisWidgetID)+'&dashboardName='+encodeURIComponent(dashboardName)+'&selectedWidgetType='+encodeURIComponent(widgetType);
	var widgetConfigPopupObj=myDashApp.getController("WidgetConfigurationController").getWidgetConfigurationWindowObj();
	Ext.Ajax.request({
			url : '/final/servlet/com.eg.RESTIntegrationController',
			method : 'POST',
			params : paramsForRestURL,
			scope : this,
			success : function(response) {

					var jsonText = response.responseText;
					if (jsonText != null && jsonText != '') 
					{
						var jsonData=Ext.decode(jsonText);
						var widgetChartAttrsContObj=Ext.getCmp('widgetChartAttrsCont');
						if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('widgetAttrsJson'))
						{
							var widgetAttrsOptions=jsonData['widgetAttrsJson']['widgetAttrsOptions'];

							var widgetSettingsOptions=jsonData['widgetAttrsJson']['widgetSettingsOptions'];
							var selectedWidgetAttrValsJson=jsonData['widgetAttrsJson']['selectedWidgetAttrValsJson'];
							var dataFieldsOpts=[];
							var dataSourceFldsArr=[];
							if(jsonData.hasOwnProperty('dataFieldsOpts'))
							{
								dataFieldsOpts=jsonData['dataFieldsOpts'];
							}
							if(jsonData.hasOwnProperty('dataSourceFldsArr'))
							{
								dataSourceFldsArr=jsonData['dataSourceFldsArr'];
							}
							if(!Ext.isEmpty(widgetSettingsOptions))
							{
								meExternalWidgetFormObj.widgetSettingsJsonArr=widgetSettingsOptions;
								var controllerSettingObj=Ext.getCmp('controllerSetting');
								controllerSettingObj.add(widgetConfigPopupObj.createSettingsCtrls(widgetSettingsOptions));

								if(widgetType == 'digitalChart')
								{
									var templateIcon = '/final/images/'+strSkin+'/listViewWidgetDefault.png';
									templateIcon=jsonData['widgetAttrsJson']['selectedImg'];
									if(Ext.isEmpty(templateIcon))
									{
										templateIcon = '/final/images/'+strSkin+'/listViewWidgetDefault.png';
									}
									if(templateIcon!=null && templateIcon!="")
									{
										if(templateIcon.indexOf(":")>0 && templateIcon.startsWith("Default"))
										{
											templateIcon = templateIcon.substring(templateIcon.indexOf(":")+1);
											var digitalChartImgCont=Ext.getCmp('digitalChartImgCont');
											
											digitalChartImgCont.iconClass=templateIcon;
											if(templateIcon.indexOf('_')>-1)
											{
												templateIcon = templateIcon.substring(0,templateIcon.lastIndexOf('_')+1)+'32';
											}
											digitalChartImgCont.update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><div id="dashboardImageIcon"  class= "'+templateIcon+'" width="32px" height="32px" border="0px"/><div class="settingOver"></div></div>');
											digitalChartImgCont.doComponentLayout();
											Ext.defer(function(){

												digitalChartImgCont.setImageTriggerEvents(digitalChartImgCont);
												},100);
											//digitalChartImgCont.setImageTriggerEvents(digitalChartImgCont);
										}
										else
										{
											var digitalChartImgCont=Ext.getCmp('digitalChartImgCont');
											if(!Ext.isEmpty(digitalChartImgCont))
											{
												digitalChartImgCont.update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="dashboardImageIcon"  src="'+templateIcon+'" width="100%" height="100%" border="0px"/><div class="settingOver"></div></div>');
												digitalChartImgCont.doComponentLayout();
												//Ext.getCmp('customImgcont').update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault"><div style="width:32px;height:32px;overflow:hidden;position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;"><img id="dashboardImageIcon"  src="'+templateIcon+'"  style="position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;" border="0px"/><div class="settingOver"></div></div>');
												Ext.defer(function(){

												digitalChartImgCont.setImageTriggerEvents(digitalChartImgCont);
												},100);
											}
										}
									}
								}
							}
							if(!Ext.isEmpty(widgetAttrsOptions))
							{
								widgetChartAttrsContObj.removeAll();
								var fieldsComboArr=[];
								var firstWidgetAttr=dataFieldsOpts[0];
								var defaultDataFieldVal="";
								if(!Ext.isEmpty(firstWidgetAttr) && firstWidgetAttr.hasOwnProperty('valueField'))
								{
									defaultDataFieldVal=firstWidgetAttr['valueField'];
								}
								var widgetAtrrsComboIds=[];
								for(var widA in widgetAttrsOptions)
								{
									var widAttrOpt=widgetAttrsOptions[widA];
									var dispLbl=widAttrOpt['displayField'];
									var valLbl=widAttrOpt['valueField'];
									var UI_Control=widAttrOpt['UI_Control'];
									
									var selectedDataField='';
									if(!Ext.isEmpty(widAttrOpt) && widAttrOpt.hasOwnProperty('selectedVal'))
									{
										selectedDataField=widAttrOpt['selectedVal'];
									}
									else
									{
										selectedDataField=defaultDataFieldVal;
										if(valLbl!=null && valLbl=='Measure_Data')
										{
											selectedDataField = 'type';
										}
										if(valLbl!=null && valLbl=='Data_Source')
										{
											selectedDataField = '-1';
										}
									}

									widgetAtrrsComboIds.push(valLbl);
									if(UI_Control!=null && UI_Control=='combo')
									{
										if(valLbl!=null && valLbl=='Data_Source')
										{
											fieldsComboArr.push({
											xtype: 'combo',
											width: 280,
											margin:10,
											cls: 'dropdown',
											fieldLabel: dispLbl,
											id: valLbl,
											name: valLbl,
											store: Ext.create('Ext.data.Store', {
												fields: ['displayField', 'valueField'],
												data: dataSourceFldsArr
											}),
											editable: false,
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											value : selectedDataField
										});
										}
										else if(valLbl!=null && valLbl=='Measure_Data')
										{
											fieldsComboArr.push({
											xtype : 'combo',
											cls: 'dropdown',
											fieldLabel: dispLbl,
											id: valLbl,
											name: valLbl,
											width: 280,
											margin:10,
											store: Ext.create('Ext.data.Store', {
											fields: ['displayField', 'valueField'],
											data: [
												{displayField: 'Please choose aggregate type', valueField: 'type'},
												{displayField: 'Sum', valueField: 'Sum'},
												{displayField: 'Average', valueField: 'Average'},
												{displayField: 'Count', valueField: 'Count'},
												{displayField: 'Minimum', valueField: 'Minimum'},
												{displayField: 'Maximum', valueField: 'Maximum'},
												]
											}),
											editable: false,
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											value : selectedDataField
											});
										}
										else
										{
											var combDataArr=[];
											if(widAttrOpt!=null && widAttrOpt.hasOwnProperty('options'))
											{
												combDataArr=widAttrOpt['options'];
											}
											if(Ext.isEmpty(combDataArr))
											{
												combDataArr=dataFieldsOpts;
											}
										fieldsComboArr.push({
											xtype : 'combo',
											cls: 'dropdown',
											fieldLabel: dispLbl,
											id: valLbl,
											name: valLbl,
											width: 280,
											margin:10,
											store: Ext.create('Ext.data.Store', {
												fields: ['displayField', 'valueField'],
												data: combDataArr
											}),
											editable: false,
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											value : selectedDataField
										});
										}
									}
									else if(UI_Control!=null && UI_Control=='multiselect')
									{
										var combDataArr=[];
										if(widAttrOpt!=null && widAttrOpt.hasOwnProperty('options'))
										{
											combDataArr=widAttrOpt['options'];
										}
										if(Ext.isEmpty(combDataArr))
										{
											combDataArr=dataFieldsOpts;
										}
										fieldsComboArr.push(
										{
											xtype:'container',
											items:[{
												xtype:'box',
												margin: '0 0 0px 15px',
												padding:'0 0 3px 0',
												html: '<span class="newFont_normal12">'+dispLbl+'</span>',
												//html:'test'
												
											},{
														xtype : 'multiselect',
														width: 280,
														height :95,
														//margin: 10,
														margin: '0 0 0px 15px',
														border : 1,
														autoScroll : true,
														scroll : true,
														displayField : 'displayField',
														//labelAlign : 'left',
														baseCls: 'egmultiselect',
														multiSelect : true,
														//fieldLabel: dispLbl,
														id : valLbl,
														name : valLbl,
														store :  Ext.create('Ext.data.Store', {
															fields: ['displayField', 'valueField'],
															data: combDataArr
														}),
														value : selectedDataField,
														
														valueField : 'valueField',
														queryMode : 'local'

										}]
										}
										);
									}
								}
								/*if(Ext.isEmpty(fieldsComboArr)) 
								{
									var useExternalData = Ext.getCmp('useExternalData');
									useExternalData.Disable();
								}*/
								if(widgetType!=null && (widgetType=='TimelineChart' || widgetType=='areaChart'))
								{
									if(fieldsComboArr!=null && fieldsComboArr.length==4)
									{
										var fldsCombArr=[];
										var comboItemsArr = [];
										comboItemsArr.push(fieldsComboArr[0]);
										comboItemsArr.push(fieldsComboArr[1]);
										var comboCont = {
												xtype : 'container',
												layout : {
														type : 'vbox',
														align : 'strecth'
												},
												margin :'25 0 0 0',
												items : comboItemsArr
										};
										fldsCombArr.push(comboCont);
										fldsCombArr.push(fieldsComboArr[2]);
										fldsCombArr.push(fieldsComboArr[3]);
										widgetChartAttrsContObj.add(fldsCombArr);
									}
									else
									{
										widgetChartAttrsContObj.add(fieldsComboArr);
									}
								}
								else
								{
									widgetChartAttrsContObj.add(fieldsComboArr);
								}
								widgetChartAttrsContObj.show();
								//Ext.getCmp('addRestWidget').show();
							}
							//addExternalMetrics.dataFieldsComboIdArr=widgetAtrrsComboIds;
							this.dataFieldsComboIdArr=widgetAtrrsComboIds;
						}
					}
			}
	});
Ext.getCmp('doneButton').enable();
	this.callParent();
	}
});
