Ext.define('MyDashBoard.view.AddHealthSummaryWidget', {
    extend: 'Ext.window.Window',
    alias: 'widget.addhealthsummarywidget',
    requires: ['Ext.ux.form.MultiSelect', 'utilities.Multiselector', 'MyDashBoard.view.ComparisonTable', 'utilities.CustomGrid', 'utilities.TimeLine', 'utilities.ScrollCombo'],
    title: servicehealthAddMetricsTitle,
    width: 750,
    modal: true,
	border:false,
	frame:true,
    autoShow: false,
	ghost:false,
	padding:'10 0 0 0',
	autoScroll:true,
	tableGridDataObj : null,
	topNGridDataObj : null,
	selectedTopNTest : '-1',
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	cls:'myDashboardwindow',
	ui:'newPopupWindow newplainHeader',
	isFluidWindowConfigPopup : false,
    height: 250,
    blockId: null,
    blckType: null,
    closeAction: 'destroy',
    isAggregationDisabled: true,
    initComponent: function () {
        var blockType = '';
        var thisBlockId = this.blockId;
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
		this.suspendEvents(true);
        this.createCommonBlockLayout(this.isAggregationDisabled);
		this.resumeEvents();
        this.buttonAlign = 'center';
        this.callParent();
    },
    onRender: function () {
        var thisBlockId = this.blockId;
        var blockType = '';
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
        this.loadDefaultDataForCommonLayout(blockType, thisBlockId);
        this.callParent();
    },
    setBlockId: function (blockId) {
        this.blockId = blockId;
    },
    checkspecialCharacterForMetric: function (dispMVal) {
        var splChar = ":~!@#$%^&*+={}[]|\\;\"\<>,";
        for (var i = 0; i < obj_val.length; i++) {
            var check_char = splChar.indexOf(obj_val.charAt(i))
            if (check_char >= 0) {
                return true;
            }
        }
    },
    loadDefaultDataForCommonLayout: function (blockType, thisBlockId) {
        var mePopup = this;
        var metricsFormPanelObj = this.getComponent('healthsummaryconfigForm');
        var metricsForm = metricsFormPanelObj.getForm();
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
        var thisWind = new Ext.LoadMask(this.getEl(), {
            msg: "Loading .."
        });
        thisWind.show();
        Ext.Ajax.request({
            url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
            method: 'POST',
            params: 'comesFrom=myDashboard&action=loadHealthSummaryConfigPopup&profileName=' + profileName + '&blockId=' + thisBlockId +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
               if (jsonText != null && jsonText != '') {
					thisWind.hide();
					var jsonData = Ext.decode(jsonText);
					var configuredData = jsonData['configuredDetails'];
					this.suspendEvents(true);
					Ext.suspendLayouts();
					var viewTypeCombo = metricsForm.findField('viewTypeCombo');
					var selectedViewType = configuredData['selectedViewType'];
					var defaultSelectedViewType = '';
					if(Ext.isEmpty(selectedViewType)){
						defaultSelectedViewType = "Zone";
					}
					var viewTypeComboObj=Ext.getCmp('viewTypeCombo');
					if(!Ext.isEmpty(viewTypeComboObj))
					{
						viewTypeComboObj.setValue(selectedViewType);
					}
					else
					{
						viewTypeComboObj.setValue("-1");
					}
					var viewTypeValueCombo =  metricsForm.findField('viewTypeValueCombo');
					viewTypeValueCombo.getStore().removeAll();
					var viewTypeValueComboStore = viewTypeValueCombo.getStore();

					if(defaultSelectedViewType == "Zone"){
						iAjax.request({
							 url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
							method: 'POST',
							params: 'comesFrom=myDashboard&action=initDefaultZoneHealthSummaryConfigPopup&profileName=' + profileName + '&selectedViewType=' + defaultSelectedViewType +'&viewByTypeChange=true&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
							scope: this,
							success : function(response) {
								var newjsonText = response.responseText;
								if (newjsonText != null && newjsonText != '') {
									var newjsonData = Ext.decode(newjsonText);
									var list =  newjsonData['configuredDetails']['viewByType'];
									var value =  newjsonData['configuredDetails']['selectedTypeValue'];
									var defaultHealthFor = 'Zone';
									var defaultMsg = '';
									
									if(!Ext.isEmpty(viewTypeValueComboStore))
									{
										viewTypeValueComboStore.removeAll();
										viewTypeValueCombo.suspendEvents(false);
										viewTypeValueComboStore.loadRawData(list);
										if (defaultMsg != null && defaultMsg != '') {
											viewTypeValueComboStore.insert(0, {
												displayField : defaultMsg,
												valueField : '-1'
											});
											viewTypeValueCombo.setValue(value);
										} else {
											var valueAssigned = false;
											for ( var listCounter = 0; listCounter < list.length; listCounter++) {
												if (list[listCounter].valueField == value && value != "" && value != null) {
													viewTypeValueCombo.setValue(value);
													valueAssigned = true;
												}
											}
											if (!valueAssigned) {
												//viewTypeValueCombo.setValue(list[0].valueField);
												viewTypeComboObj.setValue(defaultHealthFor);
											}
										}
										viewTypeValueCombo.resumeEvents();
									}
								
									viewTypeValueCombo.setFieldLabel(metricsForm.findField('viewTypeCombo').getRawValue());
									newjsonData=null;
									delete newjsonData;
								}
								newjsonText=null;
								delete newjsonText;
							}
						});

					}else if(configuredData['viewByType']!=null)
						viewTypeValueComboStore.loadRawData(configuredData['viewByType']);
					else{
						viewTypeValueComboStore.insert(0,{
							displayField:notApplicable,
							valueField: '-1'
						});
						viewTypeValueCombo.setValue('-1');
				   }
					var selectedViewTypeValue = configuredData['selectedTypeValue'];
					var viewTypeValComboObj=Ext.getCmp('viewTypeValueCombo');
					if(!Ext.isEmpty(viewTypeValComboObj) && selectedViewTypeValue!=null && selectedViewTypeValue!="")
					{
						viewTypeValComboObj.setValue(selectedViewTypeValue);
					}
					else
					{
						viewTypeValComboObj.setValue("-1");
					}
					this.resumeEvents();
					Ext.resumeLayouts(true);
				}
			},
            failure: function () {

            }
        });
    },
    createCommonBlockLayout: function (isAggregationDisabled) {
		var blkId=this.blockId;
        this.items = [{
            xtype: 'form',
            itemId: 'healthsummaryconfigForm',
            buttonAlign: 'center',
            defaults: {
               // boddyPadding: '0 0 0 10',
                margin : '0 20 0 10'
            },
            buttons: [{
                text:addDispBtn,
                id: 'addBlockConfig',
                name: 'addBlockConfig',
                cls: 'buttonNew'
            }],
			items:[
			{
				xtype:'fieldset',
				title: mapConfigurationMsg,
				collapsible: false,
				style:{"box-shadow":"none","background":"none"},
				layout:'hbox',
				margin:'0 20 5 10',
				defaults: {
					labelAlign: 'top',
					labelSeparator:''
				},
				items: [
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel: screenLabelsObj['HealthForLbl'],
						id: 'viewTypeCombo',
						name: 'viewTypeCombo',
						emptyText: 'Zone',
						width: 280,
						margin:'5 10 10 10',
						store: Ext.create('Ext.data.Store', {
						fields: ['displayField','valueField'],
						data: [{'displayField':'Zone','valueField' : 'Zone'},{'displayField':'Segment','valueField' : 'Segment'},{'displayField':'Service','valueField' : 'Service'},{'displayField':'Component Type','valueField' : 'Component'}]
					}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel: 'Zone',
						id: 'viewTypeValueCombo',
						name: 'viewTypeValueCombo',
						emptyText: 'Select a Zone',
						margin:'5 10 10 0',
						//height: 123,
						width: 280,
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField', 'valueField'],
							data: []
						}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
					}
				]
			}
			]
		}]
	}
})

