Ext.define('MyDashBoard.view.AddHealthWidget', {
    extend: 'Ext.window.Window',
    alias: 'widget.addhealthwidget',
    requires: ['Ext.ux.form.MultiSelect', 'utilities.Multiselector', 'MyDashBoard.view.ComparisonTable', 'utilities.CustomGrid', 'utilities.TimeLine', 'utilities.ScrollCombo'],
    title: healthAddMetricsTitle,
    width: 950,
    modal: true,
	border:false,
	frame:true,
    autoShow: false,
	ghost:false,
	padding:0,
	autoScroll:true,
	tableGridDataObj : null,
	topNGridDataObj : null,
	selectedTopNTest : '-1',
	/*header:{
		height:32,
		padding:'0 10',
		margin:0,
		//style:{'border-bottom':'#2b2b2b 1px solid !important'}
	},*/
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	cls:'myDashboardwindow',
	ui:'newPopupWindow newplainHeader',
//	suspendLayout : true,
	isFluidWindowConfigPopup : false,
    height: 550,
    blockId: null,
    blckType: null,
    closeAction: 'destroy',
    isAggregationDisabled: true,
    initComponent: function () {
        var blockType = '';
        var thisBlockId = this.blockId;
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
		this.suspendEvents(true);
        this.createCommonBlockLayout(this.isAggregationDisabled);
		this.resumeEvents();
        this.buttonAlign = 'center';
        this.callParent();
    },
    onRender: function () {
        var thisBlockId = this.blockId;
        var blockType = '';
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
        this.loadDefaultDataForCommonLayout(blockType, thisBlockId);
        this.callParent();
    },
    setBlockId: function (blockId) {
        this.blockId = blockId;
    },
    checkspecialCharacterForMetric: function (dispMVal) {
        var splChar = ":~!@#$%^&*+={}[]|\\;\"\<>,";
        for (var i = 0; i < obj_val.length; i++) {
            var check_char = splChar.indexOf(obj_val.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
    },
    loadDefaultDataForCommonLayout: function (blockType, thisBlockId) {
        var mePopup = this;
        var metricsFormPanelObj = this.getComponent('healthconfigForm');
        var metricsForm = metricsFormPanelObj.getForm();
		var editViewPage='dashboardLayout2';
		if(this.isFluidWindowConfigPopup)
		{
			editViewPage='fluidDashLayout';
		}
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
        //var profileName = Ext.getCmp(editViewPage).profileName;
        var thisWind = new Ext.LoadMask(this.getEl(), {
            msg: "Loading .."
        });
        thisWind.show();
        Ext.Ajax.request({
            url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
            method: 'POST',
            params: 'comesFrom=myDashboard&action=loadHealthConfigPopup&profileName=' + profileName + '&blockId=' + thisBlockId +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
               if (jsonText != null && jsonText != '') {
					thisWind.hide();
                    var jsonData = Ext.decode(jsonText);
					this.suspendEvents(true);
					Ext.suspendLayouts();

					var compTypeCombo = metricsForm.findField('compTypeCombo');
					compTypeCombo.getStore().removeAll();
					compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
					var compTypeStore = compTypeCombo.getStore();
					compTypeStore.loadRawData(jsonData['comptypes']);
					compTypeStore.insert(0,{
						displayField:jsonData['screenLabels']['reporter.common.Please choose a Component Type'],
						valueField: '-1'
					});
					compTypeCombo.setValue('-1');

					var compCombo = metricsForm.findField('componentCombo');
					compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
					var compComboStore = compCombo.getStore();
					compComboStore.removeAll();
					compComboStore.insert(0,{
						displayField:notApplicable,
						valueField: '-1'
					});
					compCombo.setValue('-1');

					var testCombo = metricsForm.findField('testCombo');
					testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
					var testComboStore = testCombo.getStore();
					testComboStore.removeAll();
					testComboStore.insert(0,{
						displayField:notApplicable,
						valueField: '-1'
					});
					testCombo.setValue('-1');

					var measuresCombo =  metricsForm.findField('measureCombo');
					//metricsForm.findField('measureLbl').setText(jsonData['screenLabels']['monitor.measures.Measures']);
					var measuresComboStore = measuresCombo.getStore();
					measuresComboStore.removeAll();
					measuresComboStore.insert(0,{
						displayField:notApplicable,
						valueField: '-1'
					});
					measuresCombo.setValue('-1');

					var descriptorCombo =  metricsForm.findField('descriptorCombo');
					descriptorCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
					var descriptorComboStore = descriptorCombo.getStore();
					descriptorComboStore.removeAll();
					descriptorComboStore.insert(0,{
						displayField:notApplicable,
						valueField: '-1'
					});
					descriptorCombo.setValue('-1');

					var configuredData = jsonData['configuredDetails'];
					var gridData = configuredData['gridData'];
					var configTableGrid = Ext.getCmp('configTableGrid');
					configTableGrid.suspendEvents(true);
					var gridStore = configTableGrid.getStore();
					gridStore.add(gridData);
					configTableGrid.show();
					configTableGrid.resumeEvents();
					configTableGrid.doComponentLayout();

					this.resumeEvents();
					Ext.resumeLayouts(true);
                }
            },
            failure: function () {

            }
        });
    },
    createCommonBlockLayout: function (isAggregationDisabled) {
		var blkId=this.blockId;
        this.items = [{
            xtype: 'form',
            itemId: 'healthconfigForm',
            buttonAlign: 'center',
            defaults: {
               // boddyPadding: '0 0 0 10',
                margin : '0 20 0 10'
            },
            buttons: [{
                text:addDispBtn,
                id: 'addBlockConfig',
                name: 'addBlockConfig',
                cls: 'buttonNew'
            }],
			items:[
			{
				xtype: 'container',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					margin: '0 10 0px 0px',
					labelSeparator:''
				},
				items: [
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel: 'Component Type',
						id: 'compTypeCombo',
						name: 'compTypeCombo',
						width: 280,
						margin:'5 0 10 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField', 'valueField'],
							data: []
						}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel: 'Component',
						id: 'componentCombo',
						name: 'componentCombo',
						width: 280,
						margin:'5 0 10 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField', 'valueField'],
							data: []
						}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					}
				]
			},
			{
				xtype:'fieldset',
				title: 'Pick Key Metrics',
				collapsible: false,
				style:{"box-shadow":"none","background":"none"},
				layout:'hbox',
				margin:'0 20 5 20',
				defaults: {
					labelAlign: 'top',
					labelSeparator:''
				},
				items: [
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel: 'Test',
						id: 'testCombo',
						name: 'testCombo',
						width: 280,
						margin:'5 10 10 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField', 'valueField'],
							data: []
						}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					},
					{
						xtype: 'container',
						margin:'5 10 5 0',
						items: [
							{
								xtype: 'label',
								text: 'Measure',
								id:'measureLbl',
								name:'measureLbl',
								cls:'formLabelDivFont',
							},
							{
								xtype: 'multiselect',
								id: 'measureCombo',
								name: 'measureCombo',
								labelAlign:'top',
								margin:'3 0 0 0',
								// baseCls: 'egmultiselect',
								border: true,
								bodyPadding: 0,
								multiSelect: true,
								scroll: false,
								autoScroll: false,
								//	anchorSize: { width : 250 },
								//	minWidth :240,
								//width : 280,
								height: 130,
								//layout: 'fit',
								listConfig: {
									simpleSelect: true,
									itemTpl: new Ext.XTemplate(

										'<tpl for=".">',
										'<div id="{valueField}" style="text-align:left;border:0px solid red">{displayField}</div>',
										'</tpl>'

									),
									listeners: {

										itemdblclick: function (thisItems, record, item, index, e, eOpts) {
											var me = this;
											var meMCombo = this;
											var selection = thisItems.getSelectionModel().getSelection();
											for (var i = 0; i < selection.length; i++) {
												mySelectionHeaders = selection[i].data.displayField;
												mySelectionHeadersd = selection[i].data.valueField;
												var editor = new Ext.Editor({
													updateEl: true,
													completeOnEnter: true,
													shadow: false,
													border: false,
													width: 230,
													ignoreNoChange: true,
													field: {
														xtype: 'textfield',
														cls : 'headerTextEdit',
														height: 26,
														width: 230
													},
													listeners: {
														'beforecomplete': function (meEdtr, value, startValue, eOpts) {
															if (value == null || value == '' || value == '-1') {
																//	meEdtr.setValue(startValue);
																meEdtr.cancelEdit(false);
																Ext.Msg.show({
																	title: myDashboardAlertLbl,
																	msg: measureEmptyMsg,
																	buttons: Ext.MessageBox.OK,
																	icon: Ext.MessageBox.WARNING
																});
																return false;
															} else if (me.store.find('displayField', value, 0, false, true, true) != -1) {
																meEdtr.cancelEdit(false);
																Ext.Msg.show({
																	title: myDashboardAlertLbl,
																	msg: measureNameAlreadyExists,
																	buttons: Ext.MessageBox.OK,
																	icon: Ext.MessageBox.WARNING
																});
																return false;

															} else if (myDashApp.getController("Main").checkSpecialCharacter(value)) {
																meEdtr.cancelEdit(false);
																Ext.Msg.show({
																	title: myDashboardAlertLbl,
																	msg: measureSplCharacterAlertMsg,
																	buttons: Ext.MessageBox.OK,
																	icon: Ext.MessageBox.WARNING
																});
																return;
															}
														},
														'complete': function (meEdtr, value, startValue, eOpts) {

															me.store.suspendEvents();
															me.store.remove(record);
															me.store.insert(index,{
																'displayField': this.getValue(),
																'valueField': mySelectionHeadersd
															});
														  //  me.store.remove(selection[i], true);
															me.refresh();
															me.store.resumeEvents();
														}
													}
												});
											}
											if (mySelectionHeadersd != "-1" || mySelectionHeadersd != "")
											{
											   var el = Ext.get(mySelectionHeadersd); // The element to 'edit'
													editor.startEdit(el, el.getValue());
											   // var el = Ext.get(record.get('valueField')); // The element to 'edit'
												//editor.startEdit(el, Ext.get(mySelectionHeadersd).getValue());
											}
										}
									}
								},
								width: 280,
								displayField: 'displayField',
								valueField: 'valueField',
								store: Ext.create('Ext.data.Store', {
									fields: ['valueField', 'displayField'],
									data: []
								})
						}]
                    },
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel: 'Descriptor',
						id: 'descriptorCombo',
						name: 'descriptorCombo',
						margin:'5 10 10 0',
						//height: 123,
						width: 250,
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField', 'valueField'],
							data: []
						}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
					}
				]
			}
			]
		},
		{
			xtype: 'comparisontable',
			isAggregationDisabled: isAggregationDisabled,
			isCombinationChart : true,
			blockId : blkId
		}]
	}
})