Ext.define('MyDashBoard.view.AddMetrics', {
    extend: 'Ext.window.Window',
    alias: 'widget.addmetrics',
    requires: ['Ext.ux.form.MultiSelect', 'utilities.Multiselector', 'MyDashBoard.view.ComparisonTable', 'utilities.CustomGrid', 'utilities.TimeLine', 'utilities.ScrollCombo'],
    title: addMetricsTitle,
    width: 950,
	width:strSkin == "Light"?970:950,
    modal: true,
	border:false,
	frame:true,
    autoShow: false,
	ghost:false,
	padding:0,
	autoScroll:true,
	tableGridDataObj : null,
	topNGridDataObj : null,
	selectedTopNTest : '-1',
	lblwidth : 100,
	legendDisplayStr : legendDisplayLbl,
	/*header:{
		height:32,
		padding:'0 10',
		margin:0,
		//style:{'border-bottom':'#2b2b2b 1px solid !important'}
	},*/
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	//cls:'myDashboardwindow_new',
	cls:'myDashboardwindow',
	ui:'newPopupWindow newplainHeader',
	bodyPadding:0,
//	suspendLayout : true,
	isFluidWindowConfigPopup : false,
    //height: 580,
    height: 540,
    blockId: null,
    blckType: null,
    //closeAction: 'destroy',
	isChartSplineOpts: true,
    isSetStateColorOpts: true,
    isAggregationDisabled: true,
    modified: false,
	configPopupJson : null,
    isMeasureBoxHeight:82,
    initComponent: function () {
        var blockType = '';
        var thisBlockId = this.blockId;
		var isCombinationChart=true;
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
		if (this.blckType != null && (this.blckType == 'pieChart' || this.blckType == 'activityChart'))
		{
			this.isMeasureBoxHeight=85;
		}

        if (this.blckType != null && (this.blckType == 'table' || this.blckType == 'BarChart' || this.blckType == 'pieChart' || this.blckType == 'activityChart')) {
          this.isAggregationDisabled = false;
        }
		else if (this.blckType != null && this.blckType=='combinationChart')
		{
			isCombinationChart=false;
		}
		else if (this.blckType != null && this.blckType=='TimelineChart' || this.blckType=='TrendGraph')
		{
			this.isChartSplineOpts=false;
		}

		if(this.blckType != null && this.blckType == 'table')
		{
			isSetStateColorOpts=false;
		}

		if(this.blckType != null && this.blckType == 'BarChart')
		{
			this.width=(strSkin == "Light")?1220:1100;
		}
		var componentarr = new Array();
		var descriptorarr = new Array();
		var descriptlblarr = new Array();
		
		var componentfield =  {
						 xtype: 'scrollcombo',
						 id: 'componentCombo',
						 width: 280,
                         name: 'componentCombo',
						 cls: 'dropdown',
						 hidden: true,
						 emptyText: 'Please choose a component',
						 store: Ext.create('Ext.data.Store', {
                                    fields: ['displayField', 'valueField','editedCompName'],
                                    data: []
                                }),
                         editable: false,
                         displayField: 'displayField',
                         valueField: 'valueField',
                         queryMode: 'local',
						 listeners : {
							'select' : function(combo)
							{
								myDashApp.getController("Main").loadDescriptors();
							}
						}
						};
		var descriptorfield =  {
						 xtype: 'scrollcombo',
						 id: 'descriptorCombo',
                         name: 'descriptorCombo',
						 margin:'0 0 0 10',
						 width: 280,
						 cls: 'dropdown',
						 hidden: true,
						 store: Ext.create('Ext.data.Store', {
                                    fields: ['displayField', 'valueField'],
                                    data: []
                                }),
                         editable: false,
                         displayField: 'displayField',
                         valueField: 'valueField',
                         queryMode: 'local'
						};

var compmultiselectcont ={
							xtype:'container',
							layout:{type:'vbox',align:'stretch'},
							width : 280,
							cls:'darkbox',
							//height:145,
							height:125,
							id:'compTypeBOX',
							items:[{
								xtype:'trigger',
								margin : '10',
								id : 'componentSearchTextBox',
								name : 'componentSearchTextBox',
								width : 228,
								
								cls: 'whitedropdown_search',
								emptyText : 'Search Component(s)',
								componentStore : null,
								hidden : true,
							listeners :
							{
								'change' : function(triggerField, newValue, oldValue, eOpts) {
									var me = this;
									var compntStore = me.componentStore;
									if(compntStore==null)
									{
										me.componentStore = this.up('form').getForm().findField('componentCombo').getStore();
										compntStore = me.componentStore;
									}
									if(newValue=="*")
									{
										compntStore.clearFilter();
									}
									else
									{
										if(newValue.lastIndexOf("*")==(newValue.length-1))
										{
											newValue = newValue.substr(0,(newValue.length-1));
										}
										compntStore.clearFilter();
										if (newValue) {
											var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
											compntStore.filter({
												filterFn: function(record) {
													return matcher.test(record.get('displayField')) ;
												}
											});
										}
									 triggerField.focus();
									}
								 }
							}
						},{
                                xtype: 'multiselect',
                                id: 'componentCombo',
                                baseCls: 'egmultiselect',
                                name: 'componentCombo',
                                //  fieldLabel:'Component',
                                multiSelect: true,
								
								height:82,
								
								//cls: 'multiselectwidth',
                                hidden: true,
                              
                               
                                store: Ext.create('Ext.data.Store', {
                                    fields: ['displayField', 'valueField','editedCompName'],
                                    data: []
                                }),
                                editable: false,
                                displayField: 'displayField',
                                valueField: 'valueField',
                                queryMode: 'local',
                                listConfig: {
                                    id: 'componentListC',
                                   // simpleSelect: true,
                                    itemTpl: new Ext.XTemplate(
                                        '<tpl for=".">',
                                        '<div id="{valueField}"  style="text-align:left">{displayField}</div>',
                                        '</tpl>'
                                    ),
                                    listeners: {
                                        itemdblclick: function (thisItems, record, item, index, e, eOpts) {
                                            var me = this
                                            var selection = thisItems.getSelectionModel().getSelection();
                                            for (var i = 0; i < selection.length; i++) {

                                                mySelectionHeaders = selection[i].data.displayField;
                                                mySelectionHeadersd = selection[i].data.valueField;

                                                var editor = new Ext.Editor({
                                                    updateEl: true,
                                                    shadow: false,
                                                    border: false,
													completeOnEnter : true,
													cancelOnEsc : true,
                                                    width: 230,
                                                    field: {
                                                        xtype: 'textfield',
														cls : 'headerTextEdit',
                                                        height: 26,
                                                        width: 230
                                                    },
                                                    ignoreNoChange: true,
                                                    listeners: {
                                                        'beforecomplete': function (meEdtr, value, startValue, eOpts) {
                                                            if (value == null || value == '' || value == '-1') {
                                                                meEdtr.setValue(startValue);
                                                                Ext.Msg.show({
                                                                    title: myDashboardAlertLbl,
                                                                    msg: componentEmptyMsg,
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.WARNING
                                                                });
                                                                return false;
                                                            } else if (me.store.find('displayField', value, 0, false, true, true) != -1) {
                                                                meEdtr.cancelEdit(false);
                                                                Ext.Msg.show({
                                                                    title: myDashboardAlertLbl,
                                                                    msg: compNameAlreadyExists,
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.WARNING
                                                                });
                                                                return false;

                                                            } else if (myDashApp.getController("Main").checkSpecialCharacter(value)) {
                                                                Ext.Msg.show({
                                                                    title: myDashboardAlertLbl,
                                                                    msg: compnameSpecialCharacterAlert,
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.WARNING
                                                                });
                                                                return;
                                                            }
                                                        },
                                                        'complete': function (meEdtr, value, startValue, eOpts) {
                                                            /*me.store.suspendEvents();
															
                                                            me.store.insert(index, {
                                                                'displayField': this.getValue(),
                                                                'valueField': mySelectionHeadersd
                                                            });
                                                            me.store.remove(selection[i], true);
                                                            me.store.resumeEvents();*/
															me.store.suspendEvents();
															me.store.remove(record);
															me.store.insert(index,{
																'displayField': this.getValue(),
																'valueField': mySelectionHeadersd
															});
																
															me.refresh();
														   me.store.resumeEvents();

                                                        }

                                                    }
                                                });

                                               
                                              
                                            }
											 if (mySelectionHeadersd != "-1") {
                                                     var el = Ext.get(mySelectionHeadersd); // The element to 'edit'
                                                    editor.startEdit(el, el.getValue());
                                                }
                                        }
                                    }
                                }


                            }]

							};

var compexpandsel =  {
                                xtype: 'button',
                                iconCls: 'iconMultiselectExpand',
                                hidden: true,
                                id: 'componentExpandSelector',
                                margin: '20 0 5 7',
                                listeners: {
                                    afterrender: function () {
                                        Ext.create('Ext.tip.ToolTip', {
                                            target: this.id,
                                            anchor: 'top',
                                            cls: 'yellowTip',
                                            trackMouse: true,
                                            html: componentDispLbl
                                        });
                                    }
                                },
                                //tooltip : '<b>Component</b>',
                                style: {
                                    background: 'none',
                                    border: '0px'
                                }
                            };

		var descriptlbl = {
                                xtype: 'label',
                                id: 'descriptorComboLbl',
                                name: 'descriptorComboLbl',
                                hidden: true,
								margin:'0 0 0 10',
                           };

      var descriptsearchbox = {
								xtype:'trigger',
								margin:'3 0 0 10',
								id : 'descriptorSearchTextBox',
								name : 'descriptorSearchTextBox',
								width : 250,
								cls: 'whitedropdown_search',
								emptyText : 'Search Descriptor(s)',
								descriptorStore : null,
								hidden :true,
								listeners :
								{
									'change' : function(triggerField, newValue, oldValue, eOpts) {
										var me = this;
										var descripStore = me.descriptorStore;
										if(descripStore==null)
										{
											me.descriptorStore = this.up('form').getForm().findField('descriptorCombo').getStore();
											descripStore=me.descriptorStore;
										}
										if(newValue=="*")
										{
											descripStore.clearFilter();
										}
										else
										{
											if(newValue.lastIndexOf("*")==(newValue.length-1))
											{
												newValue = newValue.substr(0,(newValue.length-1));
											}
											descripStore.clearFilter();
											if (newValue) {
												var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
												descripStore.filter({
													filterFn: function(record) {
														return matcher.test(record.get('displayField')) ;
													}
												});
											}
										 triggerField.focus();
										}
									 }
								}
							};

var descmultselcont = {
                                    xtype: 'multiselect',
                                    //   title: 'Descriptors',
                                    id: 'descriptorCombo',
                                    name: 'descriptorCombo',
                                    margin: '3 0 10 10',
                                    baseCls: 'egmultiselect',
                                    multiSelect: true,
                                    //height: 122,
                                    height: 100,
                                    width: 250,
                                    store: Ext.create('Ext.data.Store', {
                                        fields: ['displayField', 'valueField','editedDescName'],
                                        data: []
                                    }),
                                    listConfig: {
                                        id: 'descriptorListC',
                                        simpleSelect: true
                                    },
                                    scroll: true,
                                    editable: false,
                                    displayField: 'displayField',
                                    valueField: 'valueField',
                                    queryMode: 'local',
                                    hidden: true
                        };



		var descexpandsel = {
                                    xtype: 'container',
                                    margin: '50% 5px 0 5px',
                                    //cls : 'iconBg',
                                    items: [{
                                        xtype: 'button',
                                        iconCls: 'iconMultiselectExpand',
                                        hidden: true,
                                        id: 'descExpandSelector',
										listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: toolDescriptor
																});
															}
														},
                                        //tooltip: '<b>Descriptor</b>',
                                        style: {
                                            background: 'none',
                                            border: '0px'
                                        }
                                    }]
                                };


		if (this.blckType != null && this.blckType=='pieChart' || this.blckType=='activityChart' )
		{
			componentarr.push(componentfield);
		}
		else
		{
			componentarr.push(compmultiselectcont);
			componentarr.push(compexpandsel);
		}
		descriptorarr.push(descmultselcont);
		descriptorarr.push(descexpandsel);
		descriptlblarr.push(descriptlbl);
		descriptlblarr.push(descriptsearchbox);
		
		if (this.blckType != null && this.blckType == 'table')
		{
			this.lblwidth =45;
			this.legendDisplayStr = displayLbl;
		}
		this.suspendEvents(true);
        this.createCommonBlockLayout(this.isChartSplineOpts,this.isAggregationDisabled,isCombinationChart,componentarr,descriptorarr,descriptlblarr,this.isMeasureBoxHeight);
		this.resumeEvents();
        this.buttonAlign = 'center';
        this.callParent();
    },
    onRender: function () {
        var thisBlockId = this.blockId;
        var blockType = '';
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
        this.loadDefaultDataForCommonLayout(blockType, thisBlockId);
        this.callParent();
    },
    setBlockId: function (blockId) {
        this.blockId = blockId;
    },
    checkspecialCharacterForMetric: function (dispMVal) {
        var splChar = ":~!@#$%^&*+={}[]|\\;\"\<>,";
        for (var i = 0; i < obj_val.length; i++) {
            var check_char = splChar.indexOf(obj_val.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
    },
    loadDefaultDataForCommonLayout: function (blockType, thisBlockId) {
        var mePopup = this;
        var metricsFormPanelObj = this.getComponent('configForm');
        var metricsForm = metricsFormPanelObj.getForm();
		var editViewPage='dashboardLayoutObj';
	/*	if(this.isFluidWindowConfigPopup)
		{
			editViewPage='fluidDashLayout';
		}*/
        var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
        var thisWind = new Ext.LoadMask(this.getEl(), {
            msg: "Loading .."
        });
        thisWind.show();
        Ext.Ajax.request({
            url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
            method: 'POST',
            params: 'comesFrom=myDashboard&action=loadConfigPopup&profileName=' + profileName + '&blockId=' + thisBlockId +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
                if (jsonText != null && jsonText != '') {
					thisWind.hide();
                    var jsonData = Ext.decode(jsonText);
					this.suspendEvents(true);
					Ext.suspendLayouts();
                    var configuredData = jsonData['configuredDetails'];
                    var isTopNChart = false;
					var showDescriptors = configuredData['showDescriptors'];
					if(showDescriptors==null || showDescriptors=="undefined" || showDescriptors=="")
						showDescriptors="yes";

					var showDescOpt=metricsForm.findField('showDescOpt');
					showDescOpt.suspendEvents(false);
					if(showDescriptors!=null && showDescriptors=="yes")
					{
						showDescOpt.setValue(true);
					}
					showDescOpt.resumeEvents();
					showDescOpt.show();
					showDescOpt=null;
					delete showDescOpt;
					
					
					if (blockType != null &&  blockType == 'pieChart' || blockType == 'activityChart') 
					{
						var showServers = configuredData['showServers'];
						if(showServers==null || showServers=="undefined" || showServers=="")
							showServers="no";
						var showServersOpt=metricsForm.findField('showServersOpt');
						showServersOpt.suspendEvents(false);
						if(showServers!=null && showServers=="yes")
						{
							showServersOpt.setValue(true);
						}
						showServersOpt.resumeEvents();
						showServersOpt.show();
						showServersOpt=null;
						delete showServersOpt;
					}else{
						var showServers = configuredData['showServers'];
						if(showServers==null || showServers=="undefined" || showServers=="")
							showServers="yes";
						var showServersOpt=metricsForm.findField('showServersOpt');
						showServersOpt.suspendEvents(false);
						if(showServers!=null && showServers=="yes")
						{
							showServersOpt.setValue(true);
						}
						showServersOpt.resumeEvents();
						showServersOpt.show();
						showServersOpt=null;
						delete showServersOpt;
					}	
					/* begin code for show metrics in legennd */
					if (blockType != null && (blockType != 'table' && blockType != 'BarChart')) {
						if (blockType != null && blockType == 'heatMapChart')
						{
							var showMetrics = configuredData['showMetrics'];
							if(showMetrics==null || showMetrics=="undefined" || showMetrics=="")
								showMetrics="yes";
							var showMetricsOpt=metricsForm.findField('showMetricsOpt');
							showMetricsOpt.suspendEvents(false);
							if(showMetrics!=null && showMetrics=="yes")
							{
								showMetricsOpt.setValue(true);
							}
							showMetricsOpt.setDisabled(true);
							showMetricsOpt.resumeEvents();
							showMetricsOpt.show();
							showMetricsOpt=null;
							delete showMetricsOpt; 
						} 
						else if (blockType != null &&  (blockType == 'pieChart' || blockType == 'activityChart')) 
						{
							var showMetrics = configuredData['showMetrics'];
							if(showMetrics==null || showMetrics=="undefined" || showMetrics=="")
								showMetrics="no";
							var showMetricsOpt=metricsForm.findField('showMetricsOpt');
							showMetricsOpt.suspendEvents(false);
							if(showMetrics!=null && showMetrics=="yes")
							{
								showMetricsOpt.setValue(true);
							}
							showMetricsOpt.resumeEvents();
							showMetricsOpt.show();
							showMetricsOpt=null;
							delete showMetricsOpt; 
						}
						else
						{
						
							var showMetrics = configuredData['showMetrics'];
							if(showMetrics==null || showMetrics=="undefined" || showMetrics=="")
								showMetrics="yes";
							var showMetricsOpt=metricsForm.findField('showMetricsOpt');
							showMetricsOpt.suspendEvents(false);
							if(showMetrics!=null && showMetrics=="yes")
							{
								showMetricsOpt.setValue(true);
							}
							showMetricsOpt.resumeEvents();
							showMetricsOpt.show();
							showMetricsOpt=null;
							delete showMetricsOpt; 
						}
					}
					/* end code for show metrics in legend */

				/* begin code for show distribution as percentage in pie chart */
			   if (blockType != null &&  (blockType == 'pieChart' || blockType == 'activityChart')) {				   

				   var showDistprcnt = configuredData['showDistprcnt'];
						if(showDistprcnt==null || showDistprcnt=="undefined" || showDistprcnt=="")
							showDistprcnt="yes";
						var showDistprcntOpt=metricsForm.findField('showDistprcntOpt');
						showDistprcntOpt.suspendEvents(false);						
						showDistprcntOpt.setValue({
							showDistributionAsPct : showDistprcnt
						});						
						showDistprcntOpt.resumeEvents();
						showDistprcntOpt.show();
						showDistprcntOpt=null;
						delete showDistprcntOpt; 

					var showLegendStyleVal = configuredData['showLegendStyle'];
					if(showLegendStyleVal==null || showLegendStyleVal=="undefined" || showLegendStyleVal=="")
							showLegendStyleVal="none";

						/*var showLegendStyleOpt=metricsForm.findField('showLegendStyleOpt');
						showLegendStyleOpt.suspendEvents(false);
						showLegendStyleOpt.setValue({
							showLegendStyle : showLegendStyleVal
						});
						showLegendStyleOpt.resumeEvents();
						showLegendStyleOpt.show();
						showLegendStyleOpt=null;
						delete showLegendStyleOpt; */
			   }
			   /* ended code for show distribution as percentage in pie chart */
                    if (blockType != null && (blockType == 'BarChart' || blockType == 'table')) {
                        var topNChart = configuredData['isTopNChart'];
                        if (topNChart != null && topNChart == 'true') {
							isTopNChart = true;
							this.configPopupJson=jsonData;
                            var showTopNOptObj = metricsForm.findField('showTopNOpt');
							showTopNOptObj.suspendEvents(false);
                            showTopNOptObj.setValue({
                                topN: 'yes'
                            });
                            showTopNOptObj.show();
							showTopNOptObj.resumeEvents();
							showTopNOptObj=null;
							delete showTopNOptObj;
                        } else {
                            var showTopNOptObj = metricsForm.findField('showTopNOpt');
							showTopNOptObj.suspendEvents(false);
                            showTopNOptObj.setValue({
                                topN: 'no'
                            });
							showTopNOptObj.resumeEvents();
                            showTopNOptObj.show();
							showTopNOptObj=null;
							delete showTopNOptObj;
						//	metricsForm.findField('showDescOpt').hide();
                        }
						if(blockType == 'BarChart')
						{
							var viewType = configuredData['viewType'];
							if(Ext.isEmpty(viewType)) {
								viewType='vertical';
							}
							var viewTypeOptObj = metricsForm.findField('viewTypeOpt');
							viewTypeOptObj.suspendEvents(false);
                       					viewTypeOptObj.setValue({
				                         ViewType: viewType
				                         });
				                        viewTypeOptObj.show();
							viewTypeOptObj.resumeEvents();
							viewTypeOptObj=null;
							delete viewTypeOptObj;

							if(!isTopNChart)
							{
								var StackedChart = configuredData['StackedChart'];
								var stackedChart="no";
								if (!Ext.isEmpty(StackedChart) && StackedChart.toLowerCase() == 'yes') {
									stackedChart="yes";
								}

								var StackedChart = metricsForm.findField('StackedChart');
								StackedChart.isLoadedFirstTime=true;
								StackedChart.suspendEvents(false);
								StackedChart.setValue({
									stacked: stackedChart
								});
								StackedChart.resumeEvents();
								StackedChart.show();
								StackedChart=null;
								delete StackedChart;
							}
						}
                    }
					else if (blockType != null && (blockType == 'areaChart'  || blockType == 'BarChart'))
					{
						var StackedChart = configuredData['StackedChart'];
						var stackedChart="no";
                        if (StackedChart != null && StackedChart == 'yes') {
							stackedChart="yes";
						}

						var StackedChart = metricsForm.findField('StackedChart');
						StackedChart.suspendEvents(false);
						StackedChart.setValue({
							stacked: stackedChart
						});
						StackedChart.resumeEvents();
						StackedChart.show();
						StackedChart=null;
						delete StackedChart;
					}

					if (blockType != null && (blockType == 'TimelineChart' || blockType == 'TrendGraph'))
					{
						var splineGraphTypeVal = configuredData['splineGraphType'];
						var chartSplineTypeObj=Ext.getCmp('chartSplineOpts');
						if(!Ext.isEmpty(chartSplineTypeObj))
						{
							chartSplineTypeObj.setValue(splineGraphTypeVal);
						}
						else
						{
							chartSplineTypeObj.setValue("line");
						}
					}

                    var testCombo = metricsForm.findField('testCombo');
					testCombo.suspendEvents(true);
                    testCombo.getStore().loadRawData(jsonData['tests']);
                    testCombo.setValue('-1');
                    testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
                    testCombo.show();
					testCombo.resumeEvents();

					if (blockType != null && (blockType == 'areaChart' || blockType == 'TimelineChart' || blockType == 'combinationChart' || blockType == 'TrendGraph'))
					{
						var showChartSummary = configuredData['showChartSummary'];
						var ChartSummaryVal="no";
                        if (showChartSummary != null && showChartSummary == 'yes') {
							ChartSummaryVal="yes";
						}

						var showChartSummaryData = metricsForm.findField('showChartSummaryData');
						showChartSummaryData.suspendEvents(false);
						showChartSummaryData.setValue({
							ChartSummary: ChartSummaryVal
						});
						showChartSummaryData.resumeEvents();
						showChartSummaryData.show();
						showChartSummaryData=null;
						delete showChartSummaryData;
					}
                   var topNComponentCombo = metricsForm.findField('topNComponentCombo');
					var compCombo = metricsForm.findField('componentCombo');
					var measureCombo = metricsForm.findField('measureCombo');
					Ext.getCmp('measureComboLbl').setText(jsonData['screenLabels']['monitor.measures.Measures']);
					var topNMeasureCombo = metricsForm.findField('topNMeasureCombo');
                    topNMeasureCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Column for TopN']);
					var notApplicable = jsonData['screenLabels']['monitor.common.Not Applicable'];
                    if (blockType != null && (blockType == 'BarChart' || blockType == 'table')) {
                        if (isTopNChart) {
//                            Ext.getCmp("er_mode").hide();
                            Ext.getCmp("topnContainer").show();
                            testCombo.setValue(configuredData['selectedTest']);
							
							/*if(blockType=='table')
							{
								var topNcompTypeCombo = metricsForm.findField('topNcompTypeCombo');
								topNcompTypeCombo.suspendEvents(true);
								topNcompTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);								
								var topNCompTypeStore = topNcompTypeCombo.getStore();
								topNCompTypeStore.removeAll();
								topNCompTypeStore.insert(0,{
									displayField: notApplicable,
									valueField: '-1'
								});
								topNcompTypeCombo.setValue('-1');
								topNcompTypeCombo.resumeEvents();

								var topNComponentCombo = metricsForm.findField('topNComponentCombo');
								topNComponentCombo.suspendEvents(true);
								Ext.getCmp('topNComponentComboLbl').setText(jsonData['screenLabels']['monitor.common.Component']);
								var topNComponentComboStore = topNComponentCombo.getStore();
								topNComponentComboStore.removeAll();
								topNComponentComboStore.insert(0,{
									displayField: notApplicable,
									valueField: '-1'
								});
								topNComponentCombo.setValue('-1');
								topNComponentCombo.resumeEvents();

								var topNMeasureComboStore=topNMeasureCombo.getStore();
								topNMeasureCombo.suspendEvents(true);
	                            topNMeasureComboStore.loadRawData(configuredData['measureListJson']['measureOpts']);
	                            topNMeasureCombo.setValue(configuredData['selectedMeasure']);
								topNMeasureComboStore.insert(0, {
									displayField: measureAlertMsg,
									valueField: '-1'
								});
								topNMeasureCombo.resumeEvents();
 
								
							}
							else
							{*/
								var weightedAverageOpt=metricsForm.findField('weightedAverageOpt');
								weightedAverageOpt.suspendEvents(true);
								var weightedAverage=configuredData['weightedAverage'];
								if(weightedAverage==null || weightedAverage=="" || weightedAverage=="undefined")
									weightedAverage="yes";
									weightedAverageOpt.setValue({
									weightedAverage : weightedAverage
								});
								weightedAverageOpt.show();
								weightedAverageOpt.resumeEvents();
								topNComponentCombo = metricsForm.findField('componentCombo');
		                        var measureSingleCombo = metricsForm.findField('measureSingleCombo');
								measureSingleCombo.suspendEvents(true);
		                        measureSingleCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Measures']);
	                            measureSingleCombo.getStore().loadRawData(configuredData['measureListJson']['measureOpts']);
	                            measureSingleCombo.setValue(configuredData['selectedMeasure']);
							

								measureCombo.getStore().loadRawData(configuredData['measureListJson']['measureOpts']);
								measureCombo.setValue(configuredData['selectedMeasure']);
								measureSingleCombo.resumeEvents();

								var compTypeJson = configuredData['measureListJson']['compTypeOpts'];
								if (!Ext.isEmpty(compTypeJson)) {
									var topNcompTypeCombo = metricsForm.findField('topNcompTypeCombo');
									topNcompTypeCombo.suspendEvents(true);
									var topNCompTypeStore = topNcompTypeCombo.getStore();
									topNCompTypeStore.removeAll();
									topNcompTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
									topNCompTypeStore.loadRawData(configuredData['measureListJson']['compTypeOpts']);
									topNcompTypeCombo.setValue(configuredData['selectedCompType']);
									topNcompTypeCombo.resumeEvents();

									Ext.getCmp('componentComboLbl').setText(jsonData['screenLabels']['monitor.common.Component']);
									var topNCompListJson = configuredData['compsJson']['compOptsJson'];
									topNComponentCombo.suspendEvents(true);
									if(!Ext.isEmpty(topNCompListJson) && topNCompListJson[0]['valueField']!="-1"){
										var topNComponentComboStore = topNComponentCombo.getStore();
										topNComponentComboStore.removeAll();

										topNComponentComboStore.loadRawData(topNCompListJson);
										/*topNComponentComboStore.insert(0, {
											displayField: allServers,
											valueField: 'allServers'
										});*/
										topNComponentCombo.setValue(configuredData['selectedComps']);
									} else if (!Ext.isEmpty(topNCompListJson)) {
										topNComponentCombo.getStore().loadRawData(topNCompListJson);
										topNComponentCombo.setValue(configuredData['selectedComps']);
									}
									topNComponentCombo.resumeEvents();
								} else {
									var topNcompTypeCombo = metricsForm.findField('topNcompTypeCombo');
									topNcompTypeCombo.suspendEvents(true);
									var topNCompTypeStore = topNcompTypeCombo.getStore();
									topNCompTypeStore.removeAll();
									topNcompTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
									topNcompTypeCombo.insert(0, {
										displayField: notApplicable,
										valueField: '-1'
									});
									topNcompTypeCombo.setValue('-1');
									topNcompTypeCombo.resumeEvents();


									var topNComponentCombo = metricsForm.findField('componentCombo');
									topNComponentCombo.suspendEvents(true);
									Ext.getCmp('componentComboLbl').setText(jsonData['screenLabels']['monitor.common.Component']);
									var topNComponentComboStore = topNComponentCombo.getStore();
									topNComponentComboStore.removeAll();
									topNComponentComboStore.insert(0, {
										displayField: notApplicable,
										valueField: '-1'
									});
									topNComponentCombo.setValue('-1');
									topNComponentCombo.resumeEvents();
								}
								//}
							
                        } else {

                            Ext.getCmp("topnContainer").hide();
							 var topNMeasureCombo = metricsForm.findField('topNMeasureCombo');
							 topNMeasureCombo.suspendEvents(true);
                            var topNMeasureComboStore = topNMeasureCombo.getStore();
                            topNMeasureComboStore.removeAll();
                            topNMeasureComboStore.insert(0, {
                                displayField: measureAlertMsg,
                                valueField: '-1'
                            });
							 topNMeasureCombo.setValue('-1');
							 topNMeasureCombo.resumeEvents();
							
                            var measureSingleCombo = metricsForm.findField('measureSingleCombo');
							measureSingleCombo.suspendEvents(true);
                            measureSingleCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Measures']);
                            var measureSingleComboStore = measureSingleCombo.getStore();
                            measureSingleComboStore.removeAll();
                            measureSingleComboStore.insert(0, {
                                displayField: measureAlertMsg,
                                valueField: '-1'
                            });
                            measureSingleCombo.setValue('-1');
							measureSingleCombo.resumeEvents();
                          //  metricsForm.findField('showTopNOpt').setValue({
                          //      topN: 'no'
                         //   });


                            var topNcompTypeCombo = metricsForm.findField('topNcompTypeCombo');
							topNcompTypeCombo.suspendEvents(true);
                            var topNCompTypeStore = topNcompTypeCombo.getStore();
                            topNCompTypeStore.removeAll();
                            topNcompTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
                            topNCompTypeStore.insert(0, {
                                displayField: notApplicable,
                                valueField: '-1'
                            });
                            topNcompTypeCombo.setValue('-1');
							topNcompTypeCombo.resumeEvents();


							topNComponentCombo.suspendEvents(true);
                            Ext.getCmp('topNComponentComboLbl').setText(jsonData['screenLabels']['monitor.common.Component']);
                            var topNComponentComboStore = topNComponentCombo.getStore();
                            topNComponentComboStore.removeAll();
                            topNComponentComboStore.insert(0, {
                                displayField: notApplicable,
                                valueField: '-1'
                            });
                            topNComponentCombo.setValue('-1');
							topNComponentCombo.resumeEvents();
                        }
                    }
					else
					{
						var measureComboStore = measureCombo.getStore();
						measureCombo.suspendEvents(true);
						measureComboStore.removeAll();
						measureComboStore.insert(0, {
							displayField: notApplicable,
							valueField: '-1'
						});
						measureCombo.setValue('-1');
						measureCombo.resumeEvents();
					}

					if (blockType != null && (blockType == 'BarChart' || blockType == 'table' || blockType == 'heatMapChart' || blockType == 'pieChart' || blockType == 'activityChart'))
					{
						var aggOptions = metricsForm.findField('aggOptions');
						aggOptions.suspendEvents(true);
						metricsForm.findField('showAggOpt').setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Aggregate Descriptors']);
						aggOptions.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Aggrgeate Function']);
						aggOptions.getStore().loadRawData(configuredData['aggFunctionOptions']);
						aggOptions.setValue('avg');
						aggOptions.resumeEvents();
					}


                    var compTypeCombo = metricsForm.findField('compTypeCombo');
                    var topNcompTypeCombo = metricsForm.findField('topNcompTypeCombo');
					compTypeCombo.suspendEvents(true);
                    compTypeCombo.getStore().removeAll();
                    compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
                     compTypeCombo.getStore().insert(0, {
                        displayField: notApplicable,
                        valueField: '-1'
                    });
                    compTypeCombo.setValue('-1');
                   
					compTypeCombo.resumeEvents();
                    var descriptorCombo = metricsForm.findField('descriptorCombo');
					descriptorCombo.suspendEvents(true);
                    Ext.getCmp('descriptorComboLbl').setText(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
                    var descriptorComboStore = descriptorCombo.getStore();
                    descriptorComboStore.removeAll();
                    descriptorComboStore.insert(0, {
                        displayField: notApplicable,
                        valueField: '-1'
                    });
                    descriptorCombo.setValue('-1');
					descriptorCombo.resumeEvents();                     
                    if (!isTopNChart) {
                        Ext.getCmp('measureComboLbl').show();
                        Ext.getCmp('metricSearchBoxCont').show();
                      //  measureCombo.show();
                        compTypeCombo.show();
                        Ext.getCmp('componentComboLbl').show();
						if(blockType != null && blockType=='pieChart' || blockType=='activityChart')
						{
								compCombo.suspendEvents(true);
								var compComboCombStore = compCombo.getStore();
								compComboCombStore.removeAll();
								compComboCombStore.insert(0, {
									displayField: notApplicable,
									valueField: '-1'
								});
								compCombo.setValue('-1');
								compCombo.resumeEvents();    
						}
						else
						{
                        Ext.getCmp('componentSearchTextBox').show();
						}
                        Ext.getCmp('topNComponentComboLbl').hide();
                        Ext.getCmp('topnComponentSearchTextBox').hide();
                        topNComponentCombo.hide();
                        compCombo.show();
                        
						if(blockType != null && blockType!='pieChart' && blockType!='activityChart')
						{
							   Ext.getCmp('descriptorSearchTextBox').show();
							   Ext.getCmp('descExpandSelector').show();
							   Ext.getCmp('descriptorComboLbl').show();
						   Ext.getCmp('componentExpandSelector').show();
						}
						else // if pie chart show label only
						{
							Ext.getCmp('descriptorComboLbl').show();
						}
                        Ext.getCmp('topNCompExpandSelector').hide();
                        descriptorCombo.show();
                        Ext.getCmp('addBlockConfig').show();
                        topNcompTypeCombo.hide();
						if (blockType == 'table') {
/*							var showThresholdOpt = metricsForm.findField('showThresholdOpt');
							var showThreshold = configuredData['showThreshold'];
							if (showThreshold == null || showThreshold != 'yes')
								showThreshold = 'no';

							showThresholdOpt.setValue({
								Thrsholds: showThreshold
							});
							showThresholdOpt.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Show Thresholds']);
							showThresholdOpt.show();*/

							var showValuesOpt=metricsForm.findField('showValuesOpt');
							showValuesOpt.suspendEvents(true);
							var showValues=configuredData['showValues'];
							if(showValues==null || showValues=="" || showValues=="undefined")
								showValues="yes";

							showValuesOpt.setValue({
								showValues : showValues
							});
							showValuesOpt.show();
							showValuesOpt.resumeEvents();

							var aggOptions = metricsForm.findField('aggOptions');
							aggOptions.suspendEvents(true);
							metricsForm.findField('showAggOpt').setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Aggregate Descriptors']);
							aggOptions.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Aggrgeate Function']);
							aggOptions.getStore().loadRawData(configuredData['aggFunctionOptions']);
							aggOptions.setValue('avg');
							aggOptions.resumeEvents();
							if(blockType != null &&blockType == 'table')
							{
								var setStateColorOnVal = configuredData['SetStateColorOn'];
								var setStateColorOnObj=Ext.getCmp('setStateColorOnOpts');
								setStateColorOnObj.show()
								if(!Ext.isEmpty(setStateColorOnObj))
								{
									if(setStateColorOnVal==null || setStateColorOnVal=="" || setStateColorOnVal=="undefined")
									{
										setStateColorOnVal=  'None';
									}
									setStateColorOnObj.setValue(setStateColorOnVal);
								}
								else
								{
									chartSplineTypeObj.setValue("None");
								}
							}
						}
							var weightedAverageOpt=metricsForm.findField('weightedAverageOpt');
							weightedAverageOpt.setValue({
								weightedAverage : 'no'
							});
                    } else {
						Ext.getCmp('topnComponentSearchTextBox').hide();
						var showValuesOpt=metricsForm.findField('showValuesOpt');
						showValuesOpt.setValue({
								showValues : 'no'
							});
						/*if (blockType == 'table') {
                        compTypeCombo.hide();
                        Ext.getCmp('topNComponentComboLbl').show();
                        Ext.getCmp('topnComponentSearchTextBox').show();
                        Ext.getCmp('topNCompExpandSelector').show();
                        topNcompTypeCombo.show();
                        topNComponentCombo.show();
						}
						else
						{*/
						Ext.getCmp('weightedAverageOpt').show();
							topNcompTypeCombo.show();
							Ext.getCmp('componentComboLbl').show();
							Ext.getCmp('componentSearchTextBox').show();
							Ext.getCmp('topNComponentComboLbl').hide();
							Ext.getCmp('topnComponentSearchTextBox').hide();
							topNComponentCombo.hide();
							compCombo.show();
							Ext.getCmp('descriptorComboLbl').show();
							Ext.getCmp('descriptorSearchTextBox').show();
							Ext.getCmp('componentExpandSelector').show();
							Ext.getCmp('descExpandSelector').show();
							Ext.getCmp('topNCompExpandSelector').hide();
							descriptorCombo.show();
							//Ext.getCmp('addBlockConfig').show();
						//}
                    }
                   
					if(blockType == 'CombinedTimelineChart' || blockType == 'TimelineChart' || blockType=='areaChart' || blockType=='table' || blockType == 'combinationChart'|| blockType == 'BarChart' || blockType == 'TrendGraph' || blockType == 'pieChart' || blockType == 'activityChart') {
						Ext.getCmp('excludeDesc').show();
						var excludeDescVal = configuredData['excludedDescriptors'];
						var excludeDesc = metricsForm.findField('excludeDesc');
						if (!Ext.isEmpty(excludeDescVal)) {	
							excludeDesc.setValue(excludeDescVal);
						}else{
							excludeDesc.setValue("");
						}
					}                   
					
					if(blockType == 'CombinedTimelineChart' || blockType == 'TimelineChart' || blockType == 'combinationChart' || blockType == 'BarChart' || blockType == 'table' || blockType=='areaChart' || blockType == 'TrendGraph') {
                        Ext.getCmp("er_mode").hide();
                        var timelineComboObj = metricsForm.findField('er_timeline');
						if(blockType == 'TrendGraph')
						{
							timelineComboObj.getStore().loadRawData(jsonData['timelinedetails']['timeline']);
							var selectedTimeline = configuredData['timeline'];
							timelineComboObj.setValue(selectedTimeline);

							var trendGrpDuration = configuredData['trendGrpDuration'];
							if (trendGrpDuration!=null && trendGrpDuration!='' && !Ext.isEmpty(trendGrpDuration))
							{
								var durationLabel = trendGrpDuration['monitor.dashboard.Duration'];
								var selectedDuration = trendGrpDuration['selectedDuration'];
								var durationObj = Ext.getCmp('period');
								durationObj.setFieldLabel(durationLabel);
								durationObj.getStore().loadRawData(jsonData['timelinedetails']['period']);
								durationObj.setValue(selectedDuration);
							}
							var GraphCombo = configuredData['GraphCombo'];
							if (GraphCombo!=null && GraphCombo!=undefined && GraphCombo!='')
							{
								var graphComboVal = GraphCombo['trendGraph'];
								var selectedGraph = GraphCombo['selectedGraph'];
								var graphObj = Ext.getCmp('trendGraphOpts');
								graphObj.getStore().loadRawData(graphComboVal);
								graphObj.setValue(selectedGraph);
							}
						}
						else
						{
							timelineComboObj.getStore().loadRawData(jsonData['timelineJson']);
							var selectedTimeline = configuredData['timeline'];
							timelineComboObj.setValue(selectedTimeline);
						}


                        var startdateObj = metricsForm.findField('er_stdate');
                        var enddateObj = metricsForm.findField('er_enddate');
                        var startHourObj = metricsForm.findField('er_sthr');
                        var endHourObj = metricsForm.findField('er_endhr');
                        var startMinObj = metricsForm.findField('er_stmin');
                        var endMinObj = metricsForm.findField('er_endmin');
			var timeLineSwitchObj = Ext.getCmp('timeLineSwitch');
					
						if(blockType == 'TrendGraph')
						{
							startdateObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartDate']);
							startdateObj.dataArray = jsonData['timelinedetails']['timelineSelections']['startDateInMgrDateFormat'];
							enddateObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndDate']);
							enddateObj.dataArray = jsonData['timelinedetails']['timelineSelections']['endDateInMgrDateFormat'];
							startHourObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartHour']);
							startHourObj.dataArray = jsonData['timelinedetails']['timelineSelections']['startHrInMgrDate'];
							endHourObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndHour']);
							endHourObj.dataArray = jsonData['timelinedetails']['timelineSelections']['endHourInMgrDate'];
							stmin = jsonData['timelinedetails']['timelineSelections'].startMinInMgrDate;
							enmin = jsonData['timelinedetails']['timelineSelections'].endMinInMgrDate;
							startMinObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartMin']);
							endMinObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndMin']);
							mgr_stmin = jsonData['timelinedetails']['timelineSelections'].startMinInMgrDate;
							mgr_enmin = jsonData['timelinedetails']['timelineSelections'].endMinInMgrDate;
							if (displayTimeline) {
								var timelineContObj=Ext.getCmp('timelineMyObj');
								if(blockType!='table' && blockType!='BarChart')
								{
									timeLineSwitchObj.show();
									timelineContObj.show();
								}
								else if(isTopNChart)
								{
									timeLineSwitchObj.show();
									timelineContObj.show();
								}
								if (selectedTimeline != null && selectedTimeline == 'Any') {
									timelineContObj.selectedMgrStMin=mgr_stmin;
									timelineContObj.selectedMgrEndMin=mgr_enmin;
									timelineContObj.selectedStMinForDisplay=jsonData['timelinedetails']['timelineSelections']['selectedStartMin'];
									timelineContObj.selectedEndminForDisplay=jsonData['timelinedetails']['timelineSelections']['selectedEndMin'];
									
									timelineComboObj.fireEvent('select', timelineComboObj);
								}
								Ext.getCmp('er_stmin').show();
								Ext.getCmp('er_endmin').show();
							}
						}
						else
						{
							startdateObj.setValue(configuredData['startDateForDisplay']);
							startdateObj.dataArray = configuredData['startDate'];
							enddateObj.setValue(configuredData['endDateForDisplay']);
							enddateObj.dataArray = configuredData['endDate'];
							startHourObj.setValue(configuredData['startHourForDisplay']);
							startHourObj.dataArray = configuredData['startHour'];
							endHourObj.setValue(configuredData['endHourForDisplay']);
							endHourObj.dataArray = configuredData['endHour'];
							stmin = configuredData.startMinForDisplay;
							enmin = configuredData.endMinForDisplay;
							startMinObj.setValue(configuredData['startMinForDisplay']);
							endMinObj.setValue(configuredData['endMinForDisplay']);
							mgr_stmin = configuredData.strMin;
							mgr_enmin = configuredData.endMin;
							if (displayTimeline) {
								var timelineContObj=Ext.getCmp('timelineMyObj');
								if(blockType!='table' && blockType!='BarChart')
								{
									timeLineSwitchObj.show();
									timelineContObj.show();
								}
								else if(isTopNChart)
								{
									timeLineSwitchObj.show();
									timelineContObj.show();
								}
								if (selectedTimeline != null && selectedTimeline == 'Any') {
									timelineContObj.selectedMgrStMin=mgr_stmin;
									timelineContObj.selectedMgrEndMin=mgr_enmin;
									timelineContObj.selectedStMinForDisplay=configuredData['startMinForDisplay'];
									timelineContObj.selectedEndminForDisplay=configuredData['endMinForDisplay'];
									
									timelineComboObj.fireEvent('select', timelineComboObj);
								}
								Ext.getCmp('er_stmin').show();
								Ext.getCmp('er_endmin').show();
							}
						}
                    }
                    //if (!isTopNChart || (blockType == 'table' && isTopNChart)) {
						if (!isTopNChart) {
                        var gridData = configuredData['gridData'];
                        if (!Ext.isEmpty(gridData)) {
							this.modified=true;
/*							if((blockType == 'table' && isTopNChart) || blockType == 'CombinedTimelineChart' || blockType == 'TimelineChart' || blockType=='areaChart')
							{
								 Ext.getCmp('timelineMyObj').show();
							}*/
                            var configTableGrid = Ext.getCmp('configTableGrid');
							configTableGrid.suspendEvents(true);
							if(blockType == 'table')
							{
								if(isTopNChart)
								{
									this.topNGridDataObj=gridData;
									this.selectedTopNTest=configuredData['selectedTest'];
								}
								else
								{
									this.tableGridDataObj=gridData;
								}
							}
                            var gridStore = configTableGrid.getStore();
                            gridStore.add(gridData);
                            configTableGrid.show();
							configTableGrid.resumeEvents();
	                        configTableGrid.doComponentLayout();
                        } else {
                            Ext.getCmp('configTableGrid').show();
                        }
                    }
					this.resumeEvents();
					Ext.resumeLayouts(true);
                }
            },
            failure: function () {

            }
        });
    },
    createCommonBlockLayout: function (isChartSplineOpts,isAggregationDisabled,isCombinationChart,componentarr,descriptorarr,descriptlblarr,isMeasureBoxHeight) {
		var stackedCtrlLbl=showStackedAreaLbl;
		if(this.blckType!=null && this.blckType == 'BarChart')
		{
			stackedCtrlLbl=showStackedBarLbl;
		}
        this.items = [{
            xtype: 'form',
            itemId: 'configForm',
            //	hidden : true,
            buttonAlign: 'center',
            defaults: {
               // boddyPadding: '0 0 0 10',
                margin : '0 20 0 10'
            },
            buttons: [{
                text:addDispBtn,
                id: 'addBlockConfig',
                name: 'addBlockConfig',
	            cls: 'buttonNew',
				padding:'0 10 0 10',
                hidden: true
            }, {
                text: updateDispBtn,
                id: 'updateTopN',
                name: 'updateTopN',
				cls: 'buttonNew',
				padding:'0 10 0 10',
                hidden: true
            }],
            items: [{
                    xtype: 'container',
					 margin : '10 20 0 10',
                    layout: { type : 'hbox', align : 'stretch' },
                    items: [{
                        xtype: 'container',
						flex : 1,
						 layout: { type : 'column'},
                        items: [{
                            xtype: 'radiogroup',
                            //width: 200,
                            width: 150,
                            columns: 2,
                            //labelAlign: 'left',
							labelAlign: 'top',
                            //      height: 20,
							labelWidth:70,
							labelSeparator:'',
                            fieldLabel: showTopNLbl,
                            id: 'showTopNOpt',
                            name: 'showTopNOpt',
                            hidden: true,
                            items: [{
                                boxLabel: 'Yes',
                                name: 'topN',
                                inputValue: 'yes',
                                cls: 'radiobt'
                            }, {
                                boxLabel: 'No',
                                name: 'topN',
                                inputValue: 'no',
                                cls: 'radiobt'
                            }]
                        },
						{
                            xtype: 'radiogroup',
                           // width: 250,
                            width: 150,
							labelWidth:110,
                            columns: 2,
                            //labelAlign: 'left',
							labelAlign: 'top',
							labelSeparator:'',
                            //height: 20,
                            fieldLabel: weightedAverageLbl,
                            id: 'weightedAverageOpt',
                            name: 'weightedAverageOpt',
                            hidden: true,
                            items: [{
                                boxLabel: 'Yes',
                                name: 'weightedAverage',
                                inputValue: 'yes',
                                cls: 'radiobt'
                            }, {
                                boxLabel: 'No',
                                name: 'weightedAverage',
                                inputValue: 'no',
                                cls: 'radiobt'
                            }]
                        },
						{
                            xtype: 'radiogroup',
                           // width: 250,
                            width: 150,
							labelWidth:90,
                            columns: 2,
                           // labelAlign: 'left',
							 labelAlign: 'top',
							labelSeparator:'',
                            //height: 20,
                            fieldLabel: showValuesLbl,
                            id: 'showValuesOpt',
                            name: 'showValuesOpt',
                            hidden: true,
                            items: [{
                                boxLabel: 'Yes',
                                name: 'showValues',
                                inputValue: 'yes',
                                cls: 'radiobt'
                            }, {
                                boxLabel: 'No',
                                name: 'showValues',
                                inputValue: 'no',
                                cls: 'radiobt'
                            }]
                        },
						{
                            xtype: 'radiogroup',
                            width: 350,
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
							//flex:1,
                            columns: 'auto',
							defaults:{
								padding:'0 5 0 5',
							},
                            //labelAlign: 'left',
							labelAlign: 'top',
							labelWidth:75,
                            //height: 20,
							labelSeparator:'',
                            fieldLabel: showLegendStyleLbl,
                            id: 'showLegendStyleOpt',
                            name: 'showLegendStyleOpt',
							activeItem:0,
                            hidden: true,
                            items: [{
                                boxLabel: 'None',
                                name: 'showLegendStyle',
                                inputValue: 'none',
                                cls: 'radiobt'
                            },{
                                boxLabel: 'Horizontal',
                                name: 'showLegendStyle',
                                inputValue: 'horizontal',
                                cls: 'radiobt'
                            }, {
                                boxLabel: 'Vertical',
                                name: 'showLegendStyle',
                                inputValue: 'vertical',
                                cls: 'radiobt'
                            }]
                        },{
                            xtype: 'radiogroup',
                            //width:270,
                            width:170,
			    margin:'0 30 0 0',
							labelWidth:70,
                            columns: 2,
                            //labelAlign: 'left',
							 labelAlign: 'top',
                            //height: 20,
                            fieldLabel: 'View Type',
                            id: 'viewTypeOpt',
                            name: 'viewTypeOpt',
                            hidden: true,
							style:{'border':'0px solid red !important'},
                            items: [{
                                boxLabel: 'Vertical',
                                name: 'ViewType',
                                inputValue: 'vertical',
                                cls: 'radiobt',
                            }, {
                                boxLabel: 'Horizontal',
                                name: 'ViewType',
                                inputValue: 'horizontal',
                                cls: 'radiobt'
                            }]
                        },{
                            xtype: 'checkboxgroup',
							//width:this.blckType!=null && (this.blckType =="pieChart"|| this.blckType =="BarChart")? 290 : 425,
							//width:this.blckType!=null && (this.blckType =="table"||this.blckType =="table"||this.blckType =="pieChart"|| this.blckType =="BarChart")? 200 :325,
							width:this.blckType!=null && (this.blckType =="table"||this.blckType =="table"|| this.blckType =="BarChart")? 200 :270,
							layout: {
								type: 'hbox',
							},
							//flex:1,
							defaults:{
								padding:'0 5 0 5',
								margin:'-2 10 0 5',
							},
							labelWidth:this.lblwidth,
                            labelAlign: 'top',
							//labelAlign:this.blckType!=null && this.blckType =="heatMapChart"? 'left' : 'top',
							labelSeparator:'',
							fieldLabel : this.legendDisplayStr,
							//columns:this.blckType!=null && (this.blckType =="pieChart"|| this.blckType =="BarChart")? 2 : 3,
							columns:this.blckType!=null && (this.blckType =="BarChart")? 2 : 3,
                          //  hidden: true,
                            items: [{
                                boxLabel: 'Descriptors',
                                id: 'showDescOpt',
								name: 'showDescOpt',
								hidden : true,
                                inputValue: 'yes',
								cls : 'checkbt'
                            },
							{
                                boxLabel: 'Servers',
                                id: 'showServersOpt',
								name: 'showServersOpt',
								hidden : true,
                                inputValue: 'yes',
								cls : 'checkbt'
                            },
							{
                                boxLabel: 'Metrics',   //added for displaying Metric name in Legend  
                                id: 'showMetricsOpt',
								name: 'showMetricsOpt',
								hidden : true,
                                inputValue: 'yes',
								cls : 'checkbt',
								disabled:false
                            }
							]
                        },
						{
                            xtype: 'radiogroup',
                           // width: 250,
                            width: 170,
							labelWidth:110,
                            columns: 2,
                            //labelAlign: 'left',
							 labelAlign: 'top',
                           // height: 30,
							labelSeparator:'',
                            fieldLabel: 'Show Distribution As Pct(%)',
                            id: 'showDistprcntOpt',
                            name: 'showDistprcntOpt',
                            hidden: true,
                            items: [{
                                boxLabel: 'Yes',
                                name: 'showDistributionAsPct',
                                inputValue: 'yes',
                                cls: 'radiobt'
                            }, {
                                boxLabel: 'No',
                                name: 'showDistributionAsPct',
                                inputValue: 'no',
                                cls: 'radiobt'
                            }]
                        },
						{
                            xtype: 'checkboxgroup',
                           //width: 320,
                            width: 130,
                            column: 2,
							labelWidth:110,
                            //labelAlign: 'left',
							labelAlign: 'top',
							labelSeparator:'',
							id: 'StackedChart',
							name: 'StackedChart',
							fieldLabel : stackedCtrlLbl,
                            hidden: true,
                            items: [{
                                boxLabel: 'Yes',
                                id: 'stacked',
								name: 'stacked',
							//	hidden : true,
                                inputValue: 'yes',
								cls : 'checkbt'
                            }]
                        },
						{
                            xtype: 'checkboxgroup',
                            width: 130,
                            column: 2,
							//labelWidth:110,
                           // labelAlign: 'right',
							labelAlign: 'top',
							labelSeparator:'',
							id: 'showChartSummaryData',
							name: 'showChartSummaryData',
							fieldLabel :showChartSummaryLbl,
							hidden: true,
                            items: [{
                                boxLabel: 'Yes',
                                id: 'ChartSummary',
								name: 'ChartSummary',
							//	hidden : true,
                                inputValue: 'yes',
								cls : 'checkbt'
                            }]
                        },
				{
					xtype: 'scrollcombo',
					id: 'chartSplineOpts',
					name: 'chartSplineOpts',
					hidden : isChartSplineOpts,
					selectOnTab: true,
					editable : false,
					labelAlign: 'top',
					width: 120,
					margin:'0 30 0 0',
					//labelSeparator:'',
					fieldLabel :'Chart Type',
					displayField: 'displayField',
                    valueField: 'valueField',
					store: Ext.create('Ext.data.Store', {
						fields: ['displayField','valueField'],
						data: [{'displayField':'Line','valueField' : 'line'},{'displayField':'Column','valueField' : 'column'}]
					}),
					lazyRender: true,
 					editable:false,
					queryMode: 'local',
					value :'line'
				},
						{
							xtype:'textareafield',
							//width: 150,
							width: 220,
							fieldLabel:excludeDescriptorLbl,
							cls: 'text-area excludeDescriptor_textareafield',
							labelWidth:130,
							labelAlign: 'top',
							id:'excludeDesc',
							emptyText:excludeDescriptorEmptLbl,
							hidden : true,
							autoScroll:true,
							cols:this.blckType!=null && (this.blckType =="BarChart")? 35 :45,
							//cols:45,
							minHeight:50,
							rows:1,
						},
					{
						xtype: 'scrollcombo',
						id: 'setStateColorOnOpts',
						name: 'setStateColorOnOpts',
						//hidden : isSetStateColorOpts,
						hidden : true,
						selectOnTab: true,
						editable : false,
						labelAlign: 'top',
						width: 125,
						margin:'1 30 0 20',
						//labelSeparator:'',
						fieldLabel :applyStateColorLbl,
						displayField: 'displayField',
	                 			valueField: 'valueField',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: [{'displayField':'None','valueField' : 'None'},{'displayField':'Background','valueField' : 'Background'},{'displayField':'Font','valueField' : 'Font'}]
						}),
						lazyRender: true,
	 					editable:false,
						queryMode: 'local',
						value :'None'
					},
					{
							xtype : 'switchfield',
							name: 'timeLineSwitch',
							id: 'timeLineSwitch',
							fieldLabel: 'Timeline',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'4 0 0 40',
						//	columns: 2,
							width :100,
							labelWidth:40,
							//labelAlign: 'top',
							vertical: false,
							checked:false,
							hidden : true,

							listeners: {
								change: function() {
									var checked = Ext.getCmp('timeLineSwitch').getValue();
									if(checked)
									{
									Ext.getCmp('timeline_box').show();
									}
									else
									{
									Ext.getCmp('timeline_box').hide();
									}
								},
							}
						},
						/*******-----ss-----*******/
						/**{
							xtype:'panel',
							width: 60,
							html : 'Time_Line',9/13/2017
							margin : '0 0 0 50',
						},
						{
							xtype: 'button',
							margin: '0 0 0 2',
							height:20,
							//width:16,
							//id: 'btn_'+filter.id,
							cls: 'infobutton',
							iconCls: 'big_infoIcon',
							//bottom:0,
							infoToolTip: function(btn) {
								var me = this;
								var tooltip = Ext.create("Ext.tip.ToolTip", {
									anchor: "top",
									shadow: true,
									anchorOffset: 500,
									//mouseOffset: [0, 0],
									target: btn.id,
									cls: "moreoptionstooltip",
									listeners: {
										hide: function(tooltip) {
											if (!Ext.isEmpty(tooltip)) {
												Ext.destroy(tooltip);
											}
										},
										render: function(a) {
											Ext.EventManager.onWindowResize(function(b, c) {
												a.hide();
											});
										},
									},
									getTargetXY: function() {
										var x = btn.el.getXY()[0];
										var y = btn.el.getXY()[1];
										return [x - tooltip.anchorOffset - 10, btn.getHeight() + y];
									},
									autoHide: false,
									anchorToTarget: true,
									width: '600px',
									height: 100,
									padding: "10 2 10 10",
									//style: 'text-align:left',
									html: 'Hi',
									
								});
								return tooltip;
							},
							handler: function(btn) {
								btn.infoToolTip(btn).show();				
							},
							
						}**/
						/*******-----ss-----*******/
						]
                    }]
                },
				{
					xtype:'container',
					layout: {
			                        type: 'vbox',
			                        align: 'center',
			                        pack: 'center'
			                },
					cls: 'timeline_box',
					items:[
						{
					xtype: 'container',
					layout: {
						type:'hbox'
					},
					id: 'timeline_box',
					hidden: true,
					defaults: {
					labelAlign: 'top',					
					},				
					margin:'10 0 0 20',
					padding:'10 5 7 5',
					items: [{
					xtype: 'timeline',				
					id: 'timelineMyObj',					
					name: 'timelineMyObj',
					width: 700,
					//margin:'0 0 0 10',
					margin:'0 0 0 10',
					hidden: true,					
					addDurationCombo : this.blckType!=null && (this.blckType =="TrendGraph")? true :false,
					gtype : this.blckType!=null && (this.blckType =="TrendGraph")? 'trend' :'',
					hideMinutes : false,
					layout: 'hbox'

					},
					{
						xtype: 'scrollcombo',
						id: 'trendGraphOpts',
						name: 'trendGraphOpts',
						hidden : this.blckType!=null && (this.blckType =="TrendGraph")? false :true,
						selectOnTab: true,
						editable : false,
						labelAlign: 'top',
						width: 120,
						margin:'0 0 0 0',
						//labelSeparator:'',
						fieldLabel :'Statistics',
						displayField: 'displayField',
						valueField: 'valueField',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: [{'displayField':'Min/Max','valueField' : 'Min/Max'},{'displayField':'Avg','valueField' : 'avg'},{'displayField':'Sum','valueField' : 'sum'}]
						}),
						lazyRender: true,
						editable:false,
						queryMode: 'local',
						value :'Min/Max'
					}

					]
					},
							
					]
				},
				
				
			
				{
                    xtype: 'container',
                    layout: 'hbox',
                    defaults: {
                        labelAlign: 'top',
                        margin: '0 10 0px 0px',
						labelSeparator:''
                    },
                    items: [{
                        xtype: 'container',
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
                        items: [{
                            xtype: 'scrollcombo',
                            id: 'testCombo',
                            name: 'testCombo',
                            cls: 'dropdown',
                            fieldLabel: 'Test',
			    margin:'5 0 10 0',
                            width: 280,
                            store: Ext.create('Ext.data.Store', {
                                fields: ['displayField', 'valueField'],
                                data: []
                            }),
                            editable: false,
                            hidden: true,
                            displayField: 'displayField',
                            valueField: 'valueField',
                            queryMode: 'local',
                            enableKeyEvents: true,
                            keyTypVal: '',
                            lastKeyNavTime: 0,
                            listeners: {
                                keyup: function (combo, event) {
                                    var key = combo.keyTypVal;
                                    if ((new Date().getTime() - parseInt(combo.lastKeyNavTime)) > 3000) {
                                        key = '&nbsp';
                                    }
                                    key = key + String.fromCharCode(event.getKey());
                                    boundList = combo.getPicker(),
                                    store = boundList.getStore(),
                                    record = store.findRecord(combo.displayField, key);

                                    if (record) {
                                        combo.keyTypVal = key;
                                        boundList.highlightItem(boundList.getNode(record));
                                        combo.lastKeyNavTime = new Date().getTime();
                                        Ext.fly(boundList.getNode(record).scrollIntoView(this, true, false, true));
                                        //	combo.showScroll(boundList.getNode(record));
                                    }

                                },
                                select: function (combo, records, eOpts) {

                                    combo.keyTypVal = '';

                                }
                            }
                        }, {
                            xtype: 'label',
                            id: 'measureComboLbl',
                            name: 'measureComboLbl',
			    margin:'10 0 5 0',
                            hidden: true
                        },
			{
				xtype:'container',
				layout:{type:'vbox',align:'stretch'},
				width : 280,
				cls:'darkbox',
				//height:145,
				height:125,
				id:'metricSearchBoxCont',
				items:[{
					xtype:'trigger',
					margin : '10',
					id : 'metricsSearchTextBox',
					name : 'metricsSearchTextBox',
					width : 228,
									
					cls: 'whitedropdown_search',
					emptyText : 'Search Metric(s)',
					metComboStore : null,
				//	hidden : true,
					listeners :
					{
						'change' : function(triggerField, newValue, oldValue, eOpts) {
							var me = this;
							var metStore = me.metComboStore;
							if(metStore==null)
							{
								me.metricComboStore = this.up('form').getForm().findField('measureCombo').getStore();
								metStore = me.metricComboStore;
							}
							if(newValue=="*")
							{
								metStore.clearFilter();
							}
							else
							{
								if(newValue.lastIndexOf("*")==(newValue.length-1))
								{
									newValue = newValue.substr(0,(newValue.length-1));
								}
								metStore.clearFilter();
								if (newValue) {
									var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
									metStore.filter({
										filterFn: function(record) {
											return matcher.test(record.get('displayField')) ;
										}
									});
								}
							 triggerField.focus();
							}
						 }
					}
				},
				{
					xtype: 'multiselect',
					id: 'measureCombo',
					name: 'measureCombo',
					margin: '0 0 0 0',
					//		ddReorder : true,
					//hidden: true,
					baseCls: 'egmultiselect',
					border: true,
					bodyPadding: 0,
					multiSelect: true,
					scroll: false,
					autoScroll: false,
					//	anchorSize: { width : 250 },
					//	minWidth :240,
					//width : 280,
					//height: 130,
					height: isMeasureBoxHeight,
					layout: 'fit',
					listConfig: {
						simpleSelect: true,
						itemTpl: new Ext.XTemplate(

						'<tpl for=".">',
						'<div id="{valueField}" style="text-align:left;border:0px solid red">{displayField}</div>',
						'</tpl>'

					),
					listeners: {

							itemdblclick: function (thisItems, record, item, index, e, eOpts) {
								var me = this;
								var meMCombo = this;
								var selection = thisItems.getSelectionModel().getSelection();
								for (var i = 0; i < selection.length; i++) {
									mySelectionHeaders = selection[i].data.displayField;
									mySelectionHeadersd = selection[i].data.valueField;
									var editor = new Ext.Editor({
										updateEl: true,
										completeOnEnter: true,
										shadow: false,
										border: false,
										width: 230,
										ignoreNoChange: true,
										field: {
											xtype: 'textfield',
											cls : 'headerTextEdit',
											height: 26,
											width: 230
										},
										listeners: {
											'beforecomplete': function (meEdtr, value, startValue, eOpts) {
												if (value == null || value == '' || value == '-1') {
													//	meEdtr.setValue(startValue);
													meEdtr.cancelEdit(false);
													Ext.Msg.show({
														title: myDashboardAlertLbl,
														msg: measureEmptyMsg,
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return false;
												} else if (me.store.find('displayField', value, 0, false, true, true) != -1) {
													meEdtr.cancelEdit(false);
													Ext.Msg.show({
														title: myDashboardAlertLbl,
														msg: measureNameAlreadyExists,
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return false;

												} else if (myDashApp.getController("Main").checkSpecialCharacter(value)) {
													meEdtr.cancelEdit(false);
													Ext.Msg.show({
														title: myDashboardAlertLbl,
														msg: measureSplCharacterAlertMsg,
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return;
												}
											},
											'complete': function (meEdtr, value, startValue, eOpts) {
														
												me.store.suspendEvents();
												me.store.remove(record);
												me.store.insert(index,{
													'displayField': this.getValue(),
													'valueField': mySelectionHeadersd
												});
											  //  me.store.remove(selection[i], true);
												me.refresh();
												me.store.resumeEvents();
											}
										}
									});
								}
												
								 if (mySelectionHeadersd != "-1" || mySelectionHeadersd != "") {
												
									   var el = Ext.get(mySelectionHeadersd); // The element to 'edit'
											editor.startEdit(el, el.getValue());
									   // var el = Ext.get(record.get('valueField')); // The element to 'edit'
										//editor.startEdit(el, Ext.get(mySelectionHeadersd).getValue());
									}
											
								}
							}
						},
						width: 280,
						displayField: 'displayField',
						valueField: 'valueField',
						store: Ext.create('Ext.data.Store', {
							fields: ['valueField', 'displayField','editedMeasName'],
							data: []
						})

					}]
				}]
                    }, {
                        xtype: 'container',
						id : 'column2_cont',
						name : 'column2_cont',
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
                        items: [{
                            xtype: 'scrollcombo',
                            id: 'measureSingleCombo',
                            name: 'measureSingleCombo',
                            cls: 'dropdown',
                            fieldLabel: 'Measure',
                            width: 280,
							margin:'5 0 20 10',
                            store: Ext.create('Ext.data.Store', {
                                fields: ['displayField', 'valueField'],
                                data: []
                            }),
                            editable: false,
                            displayField: 'displayField',
                            valueField: 'valueField',
                            queryMode: 'local',
                            hidden: true
                        }, {
                            xtype: 'scrollcombo',
                            cls: 'dropdown',
                            fieldLabel: 'Component Type',
                            id: 'compTypeCombo',
                            name: 'compTypeCombo',
                            hidden: true,
                            width: 280,
			    margin:'5 0 20 10',
                            store: Ext.create('Ext.data.Store', {
                                fields: ['displayField', 'valueField'],
                                data: []
                            }),
                            editable: false,
                            displayField: 'displayField',
                            valueField: 'valueField',
                            queryMode: 'local'
                        },

						{
                            xtype: 'label',
                            id: 'componentComboLbl',
                            name: 'componentComboLbl',
							margin:'0px 10px 0px 10px',
							text:'Components', 
                            hidden: true
							
                        },
						{
                            xtype: 'container',
							layout:{type:'fit',align:'stretch',pack:'start'},
                            //cls: 'multiselectwidth', //*---DIRTY FIX for width---
                            width: 280,
							//height:145,
							id:'compcontner',
                            defaults: {
                                labelAlign: 'top',
								labelSeparator:'',
								align:'top',
                            },
                          
                            margin: '5 0 0 10',	
							items: componentarr
                        }]
                    }, {
                        xtype: 'container',
						
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
                        items: [{
                                xtype: 'scrollcombo',
                                cls: 'dropdown',
                                fieldLabel: 'Component Type',
                                id: 'topNcompTypeCombo',
                                name: 'topNcompTypeCombo',
                                hidden: true,
                                width: 280,
								margin:'5 0 30 10',
                                store: Ext.create('Ext.data.Store', {
                                    fields: ['displayField', 'valueField'],
                                    data: []
                                }),
                                editable: false,
                                displayField: 'displayField',
                                valueField: 'valueField',
                                queryMode: 'local'
                            }, {
                                xtype: 'label',
                                id: 'topNComponentComboLbl',
								labelStyle: 'font-weight:bold;',
                                name: 'topNComponentComboLbl',
								margin : '10 0 5 0',
                                hidden: true
                            },{
								xtype:'container',
								layout:{type:'hbox',align:'stretch'},
								items:[
									{
										xtype:'container',
										cls:'darkbox',
										layout:{type:'vbox',align:'stretch'},
										width : 248,
										hidden : true,
										id:'topNComponentBOX',
										items:[{
								xtype:'trigger',
								margin : '10',
								id : 'topnComponentSearchTextBox',
								name : 'topnComponentSearchTextBox',
								width : 280,
								cls: 'whitedropdown_search',
								emptyText : 'Search Component(s)',
								componentStore : null,
								hidden : true,
								listeners :
								{
									'change' : function(triggerField, newValue, oldValue, eOpts) {
										var me = this;
										var compntStore = me.componentStore;
										if(compntStore==null)
										{
											me.componentStore = this.up('form').getForm().findField('topNComponentCombo').getStore();
											compntStore = me.componentStore;
										}
										if(newValue=="*")
										{
											compntStore.clearFilter();
										}
										else
										{
											if(newValue.lastIndexOf("*")==(newValue.length-1))
											{
												newValue = newValue.substr(0,(newValue.length-1));
											}
											compntStore.clearFilter();
											if (newValue) {
												var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
												compntStore.filter({
													filterFn: function(record) {
														return matcher.test(record.get('displayField')) ;
													}
												});
											}
										 triggerField.focus();
										}
									 }
								}
						
							},
							{
                                xtype: 'container',
                                defaults: {
                                    labelAlign: 'top',
									labelSeparator:''
                                },
                                layout: 'hbox',
								
                                id: 'topnContainer',
                                name: 'topnContainer',
                                items: [{
								margin: '0',
                                    xtype: 'multiselect',
                                    id: 'topNComponentCombo',
                                    baseCls: 'egmultiselect',
                                    name: 'topNComponentCombo',
                                    //  fieldLabel:'Component',
                                    multiSelect: true,
                                    hidden: true,
                                   	height:117,
                                    
                                   
                                    store: Ext.create('Ext.data.Store', {
                                        fields: ['displayField', 'valueField'],
                                        data: []
                                    }),
                                    editable: false,
                                    displayField: 'displayField',
                                    valueField: 'valueField',
                                    queryMode: 'local',
                                    listConfig: {
                                        simpleSelect: true,
                                        id: 'topNComponentComboC',
                                        name: 'topNComponentComboC',
                                        itemTpl: new Ext.XTemplate(
                                            '<tpl for=".">',
                                            '<div id="{valueField}"  style="text-align:left">{displayField}</div>',
                                            '</tpl>'
                                        ),
                                        listeners: {}
                                    }
                                }]
									}	
								]
							},
							 {
                                    xtype: 'button',
                                    iconCls: 'iconMultiselectExpand',
                                    id: 'topNCompExpandSelector',
                                    //tooltip : '<b>Component</b>',
                                    listeners: {
                                        afterrender: function () {
                                            Ext.create('Ext.tip.ToolTip', {
                                                target: this.id,
                                                anchor: 'top',
                                                cls: 'yellowTip',
                                                trackMouse: true,
                                                html: 'Component'
                                            });
                                        }
                                    },
                                    margin: '20% 5px 0 5px',
                                    hidden: true,
                                    style: {
                                        background: 'none',
                                        border: '0px'
                                    }
                                }]
                            },{
                                xtype: 'radiogroup',
                                width: 270,
                                column: 2,
                                labelAlign: 'left',
                                labelWidth: 135,
                                height: 20,
								margin: '25 0 -49 0',
                                fieldLabel: 'Aggregate Descriptors',
                                id: 'showAggOpt',
                                name: 'showAggOpt',
                                hidden: true,
                                items: [{
                                    boxLabel: 'Yes',
                                    name: 'showAgg',
                                    inputValue: 'yes',
                                    cls: 'radiobt'
                                }, {
                                    boxLabel: 'No',
                                    name: 'showAgg',
                                    inputValue: 'no',
                                    cls: 'radiobt'
                                }]
                            }, {
                                xtype: 'scrollcombo',
                                cls: 'dropdown',
                                fieldLabel: 'Aggregate Function',
                                id: 'aggOptions',
                                name: 'aggOptions',
								labelAlign: 'left',
                                labelWidth: 140,
                                hidden: true,
                                width: 280,
								margin: '67 0 0 0',
                                store: Ext.create('Ext.data.Store', {
                                    fields: ['displayField', 'valueField'],
                                    data: []
                                }),
                                editable: false,
                                displayField: 'displayField',
                                valueField: 'valueField',
                                queryMode: 'local',
                                hidden: true
                            }, 
							{
								xtype: 'container',
								id:'check_con',
								margin:'64 0 0 0',
								defaults: {
									labelAlign: 'top',
									labelSeparator:''
								},
									items: descriptlblarr
							},
							{
                                xtype: 'container',
								id : 'descriptormainCont',
								width:315,
                                defaults: {
                                    labelAlign: 'top',
									labelSeparator:''
                                },
								margin:'0 0 5 0',
								layout:{
									type:'hbox',
									align:'stretch',
								},
								items: descriptorarr
                            }

                        ]
                    },
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel: 'TopN Column Measure',
						id: 'topNMeasureCombo',
						name: 'topNMeasureCombo',
						hidden: true,
						width: 280,
						margin:'5 0 10 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField', 'valueField'],
							data: []
						}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					}]

                }

            ]
        }, {

            xtype: 'comparisontable',
            isAggregationDisabled: isAggregationDisabled,
            isCombinationChart: isCombinationChart,
            hidden: true
        }]
    },
	listeners : {
		'close' : function() {
			if(!Ext.isEmpty(Ext.getCmp('componentExpandSelectorView'))){
				Ext.getCmp('componentExpandSelectorView').close();
			}
			if(!Ext.isEmpty(Ext.getCmp('topNCompExpandSelectorView'))){
				Ext.getCmp('topNCompExpandSelectorView').close();
			}
			if(!Ext.isEmpty(Ext.getCmp('descExpandSelectorView'))){
				Ext.getCmp('descExpandSelectorView').close();
			}
		}
	}
})