Ext.define('MyDashBoard.view.AddDialMetrics', {
    extend: 'Ext.window.Window',
    alias: 'widget.adddialmetrics',
    requires: ['Ext.ux.form.MultiSelect','utilities.Multiselector', 'MyDashBoard.view.ComparisonTable','utilities.CustomGrid','utilities.TimeLine','utilities.ScrollCombo'],
    title: addMetricsTitle,
    width: 940,
	modal : true,
	autoShow : false,
    layout:{type:'vbox',align:'stretch'},
    height: 600,
	blockId : null,
	closeAction : 'destroy',
	initComponent : function()
	{
		this.buttonAlign = 'center';
		this.callParent();
	},
    items: [{
        xtype: 'form',
			itemId : 'dialConfigForm',
		//	hidden : true,
			buttonAlign: 'center',
        defaults: {
            padding: '3',
            margin: 3
        },
        buttons: [
		{
		    text : updateDispBtn,
			id : 'updateDialConfig',
			name : 'updateDialConfig',
            cls: 'button20'
//			hidden : true
        }
			],
        items: [{
                xtype: 'container',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    margin: '0 10 0px 0px'
                },
                items: [{
                        xtype: 'container',
                        defaults: {
                            labelAlign: 'top'
                        },
                        items: [
							{
                        xtype: 'scrollcombo',
						cls: 'dropdown',
                        fieldLabel: 'Component Type',
						id : 'dialCompTypeCombo',
						name : 'dialCompTypeCombo',
					//	hidden : true,
                        width: 280,
						store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
                    },
					{
						xtype: 'scrollcombo',
						id: 'measureSingleCombo',
						name: 'measureSingleCombo',
						cls: 'dropdown',
						fieldLabel: 'Measure',
						width: 280,
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
				//		hidden : true
					},
											{
							xtype : 'label',
							id : 'measuresMultiComboLbl',
							name : 'measuresMultiComboLbl',
							width : 200,
							height : 22,
							hidden : true,
						},
						{
                            xtype: 'multiselect',
                         //   title: 'Descriptors',
                            margin: '4px 0px 0px 0px',
                            id: 'measureMultiCombo',
                            name: 'measureMultiCombo',
							baseCls: 'egmultiselect',
                            multiSelect: true,
                            height: 135,
                            width: 200,
							labelAlign : 'top',
                            store: Ext.create('Ext.data.Store', {
                                fields: ['displayField','valueField'],
                                data: []
                            }),
							scroll : true,
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							value : notApplicable,
							hidden : true,
							listConfig:{
							simpleSelect: true,
							}
						}
						
					]
				},{
                    xtype: 'container',
					defaults: {
                        labelAlign: 'top'
                    },
                    items: [				
					{
                        xtype: 'scrollcombo',      
						cls: 'dropdown',
                        id: 'dialComponentCombo',
						fieldLabel : 'Component',
				//		baseCls: 'egmultiselect',
                        name: 'dialComponentCombo',
                      //  fieldLabel:'Component',
               //         multiSelect: true,
				//		hidden : true,
               //         height: 180,
                        width: 280,
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
                    },
						{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel : 'Descriptor',
					 //   title: 'Descriptors',
						id: 'dialDescriptorCombo',
						name: 'dialDescriptorCombo',
			//			margin : '5 0 0 0',
				//		height: 232,
						width: 280,
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						scroll : true,
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
			//			hidden : true
							}
					]
                },
				 {
                    xtype: 'container',
                    defaults: {
                        labelAlign: 'top'
                    },
                    items: [
							{
                        xtype: 'scrollcombo',
                        id: 'testCombo',
                        name: 'testCombo',
						cls: 'dropdown',
                        fieldLabel: 'Test',
                        width: 280,
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
			//			hidden : true,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					/*	enableKeyEvents: true,
						keyTypVal : '',
						lastKeyNavTime : 0,
						listeners: {
							keyup: function(combo, event) {
								var key = combo.keyTypVal;
								if((new Date().getTime()-parseInt(combo.lastKeyNavTime))>3000)
								{
									key = '';
								}
								key = key + String.fromCharCode(event.getKey());								
									boundList = combo.getPicker(),
									store = boundList.getStore(),
									record = store.findRecord(combo.displayField, key);

								if (record) {
									combo.keyTypVal = key;
									boundList.highlightItem(boundList.getNode(record));
									combo.lastKeyNavTime = new Date().getTime();
									Ext.fly(boundList.getNode(record).scrollIntoView());
								}
								
							},
							select : function(combo, records, eOpts) {

								combo.keyTypVal = '';

							}
						}*/
                    },
					{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				fieldLabel : 'Graph Type',
			 //   title: 'Descriptors',
				id: 'graphTypeCombo',
				name: 'graphTypeCombo',
	//			margin : '5 0 0 0',
		//		height: 232,
				width: 280,
				store: Ext.create('Ext.data.Store', {
					fields: ['displayField','valueField'],
					data: []
				}),
				scroll : true,
				editable:false,
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden : true
					}

					
						]
                }
            ]

            }

        ]
    }]
	,
	 onRender : function () {
			var mePopup = this;
			//myDashboardMask.show();
			var thisWind =new Ext.LoadMask(this.getEl(), {
							msg : "Loading .."
						});
			thisWind.show();
			var thisBlockId = mePopup.blockId;	
			var metricsFormPanelObj = this.getComponent('dialConfigForm');
			var metricsForm = metricsFormPanelObj.getForm();
			var profileName = Ext.getCmp('dashboardLayout').profileName;

			var blockType = '';
			
			if(thisBlockId!=null)
			{
				blockType = thisBlockId.substr(0,thisBlockId.indexOf("_"));
			}

			if(blockType!=null && blockType=='pieChart')
			{
				metricsForm.findField('measureMultiCombo').show();
				Ext.getCmp('measuresMultiComboLbl').show();
				metricsForm.findField('measureSingleCombo').hide();
			}
			

				Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params: 'comesFrom=myDashboard&action=loadDialConfigPopup&profileName='+profileName+'&blockId='+thisBlockId+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						thisWind.hide();
						var compTypeCombo = metricsForm.findField('dialCompTypeCombo');

						var dialConfigDetails = jsonData['configDetails'];

						var selectedCompType = '';
						var selectedComp = '';
						var selectedTest = '';
						var selectedMeasure = '';
						var selectedDescriptor = '';
						var selectedGraphType='';
						if(!Ext.isEmpty(dialConfigDetails))
						{
							selectedCompType = dialConfigDetails['selectedCompType'];
							selectedComp = dialConfigDetails['selectedComp'];
							if((selectedCompType!=null && selectedCompType!="undefined" && selectedCompType!="" && selectedCompType!="-1") && (selectedComp!=null && selectedComp!="undefined" && selectedComp!='' && selectedComp!="-1"))
							{
								selectedComp = selectedCompType+":"+selectedComp;
							}
							selectedTest = dialConfigDetails['selectedTest'];
							selectedMeasure = dialConfigDetails['selectedMeasure'];
							selectedDescriptor = dialConfigDetails['selectedDescriptor'];
							selectedGraphType = dialConfigDetails['selectedGraphType'];
						}
						compTypeCombo.getStore().removeAll();
						compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
						var compTypeStore = compTypeCombo.getStore();
						compTypeStore.loadRawData(jsonData['comptypes']);
						compTypeStore.insert(0,{
							displayField:jsonData['screenLabels']['reporter.common.Please choose a Component Type'],
							valueField: '-1'
						});
						if(selectedCompType!=null && selectedCompType!='')
						{
							compTypeCombo.setValue(selectedCompType);
							compTypeCombo.fireEvent('select',compTypeCombo);
						}
						else
						{
							compTypeCombo.setValue('-1');
						}

						var compCombo = metricsForm.findField('dialComponentCombo');
						compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
						var compComboStore = compCombo.getStore();
						compComboStore.removeAll();

							var meDialPopup = this;

						if(selectedComp!=null && selectedComp!='')
						{
							compCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(compCombo,selectedComp);  }, this, {
									single: true,
									delay: 100
								});
						}
						else
						{	
							compComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							compCombo.setValue('-1');
						}
						var testCombo = metricsForm.findField('testCombo');
						testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
						var testComboStore = testCombo.getStore();
						testComboStore.removeAll();
						if(selectedTest!=null && selectedTest!='')
						{
								testCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(testCombo,selectedTest);  }, this, {
									single: true,
									delay: 100
								});
						}
						else
						{
							testComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							testCombo.setValue('-1');
						}
						if(blockType!=null && blockType=='pieChart')
						{
							var measureMultiCombo =  metricsForm.findField('measureMultiCombo');
							Ext.getCmp('measuresMultiComboLbl').setText(jsonData['screenLabels']['monitor.measures.Measures']);
							var measureMultiComboStore = measureMultiCombo.getStore();
							measureMultiComboStore.removeAll();
							if(selectedMeasure!=null && selectedMeasure!='')
							{
									measureMultiComboStore.on('load', function(){ meDialPopup.fireComboSelection(measureMultiCombo,selectedMeasure);  }, this, {
										single: true,
										delay: 100
									});
							}
							else
							{
								measureMultiComboStore.insert(0,{
									displayField:notApplicable,
									valueField: '-1'
								});
								measureMultiCombo.setValue('-1');
							}
						}
						else
						{
							var ddMeasuresCombo =  metricsForm.findField('measureSingleCombo');
							ddMeasuresCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Measures']);
							var ddMeasuresComboStore = ddMeasuresCombo.getStore();
							ddMeasuresComboStore.removeAll();
							if(selectedMeasure!=null && selectedMeasure!='')
							{
									ddMeasuresCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(ddMeasuresCombo,selectedMeasure);  }, this, {
										single: true,
										delay: 100
									});
							}
							else
							{
								ddMeasuresComboStore.insert(0,{
									displayField:notApplicable,
									valueField: '-1'
								});
								ddMeasuresCombo.setValue('-1');
							}
						}
						var dialDescriptorCombo = metricsForm.findField('dialDescriptorCombo');
						dialDescriptorCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
						if(selectedDescriptor!=null && selectedDescriptor!="")
						{
								dialDescriptorCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(dialDescriptorCombo,selectedDescriptor);  }, this, {
									single: true,
									delay: 100
								});
						}
						else
						{
							var dialDescriptorComboStore = dialDescriptorCombo.getStore();
							dialDescriptorComboStore.removeAll();
							dialDescriptorComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							dialDescriptorCombo.setValue('-1');
						}
						if(blockType!=null && blockType=='dialChart')
						{
							var graphTypeCombo = metricsForm.findField('graphTypeCombo');
							graphTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Graph Type']);
							graphTypeCombo.getStore().loadRawData(dialConfigDetails['graphOpts']);
							console.log(selectedGraphType);
							if(selectedGraphType!=null && selectedGraphType!="")
							{
									graphTypeCombo.setValue(selectedGraphType);
							}							
							graphTypeCombo.show();
						}

					}
						
				},
				failure : function()
				{

				}
			});
		
			this.callParent();
		},
		setBlockId : function(blockId)
		{
			this.blockId = blockId;
		},
		checkspecialCharacterForMetric : function(dispMVal)
		{
			var splChar =":~!@#$%^&*+={}[]|\\;\"\<>,";
			for(var i=0; i<obj_val.length; i++)
			{
				var check_char = splChar.indexOf(obj_val.charAt(i))
				//Returns value 1 if the special character listed in splChar is found
				if(check_char >= 0)
				{
					return true;
				}
			}
		},
		fireComboSelection : function(comboObj,selectedValue)
		{
			console.log(selectedValue);
			comboObj.setValue(selectedValue);
			comboObj.fireEvent('select',comboObj);
		}
	}
)