Ext.define('MyDashBoard.view.ColorPickerWindow',{
	extend:'Ext.container.Container',
	alias:'widget.colorpickerwindow',
	cls:'colorPickerWindow',
	bodyStyle: {
        'background': '#535353'
    },
    defaults: {
        cls: 'dragTools'
    },
	floating:true,
	
	header:false,
	resizable:false,
	shadow:false,
	width:97,
	height : 80,
	html:'<div class="colorpalletnodge" style="left:50px;"></div>',
	closeAction : 'hide',
	padding:'8 8',
	border:true,
	dashBoardAction : '',
	profileName : '',
	blockId : '',
	selectedGaugeColor : null,
	listeners : {
		'beforeshow' : function(winObj)
		{
			
		},
		'render' : function(win)
		{	
			var colorsArray=[];
			splitedColors=ColorPickerColors.split(',');
			for(var col in splitedColors)
			{
				colorsArray.push(splitedColors[col]);
			}

			if(!colorsArray.includes(this.selectedGaugeColor))
			{
				this.selectedGaugeColor = '2E6FB7';
			}

			if(Ext.isEmpty(this.selectedGaugeColor) && !Ext.isEmpty(splitedColors))
			{
				this.selectedGaugeColor=splitedColors[0];
			}
			if(this.selectedGaugeColor!=null && this.selectedGaugeColor.indexOf("#")==0)
			{
				this.selectedGaugeColor=this.selectedGaugeColor.substring(1);
			}
			blockId = this.blockId;
			var cPanlObj=Ext.getCmp(win.blockId);
			var winDOM = win.getEl();
			win.mon(winDOM, {
				mouseout: function() {
					cPanlObj.isTopNComboInProgress=false;
					win.hide();
				},
				mouseover:function(){
					cPanlObj.isTopNComboInProgress=true;
					win.show();
				}
			});
			var bgArr=[];
			bgArr.push({
				xtype : 'colorpicker',
				//colors:defaultColors,
				colors:colorsArray,
				width : 80,
				value: this.selectedGaugeColor,
				listeners : {
					select: function(picker, color, suppressEvent) {
						myDashApp.getController("Main").setColor(blockId,color);
					}
				}
			});								
			this.add(bgArr);
		}
	}
});