var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
        clicksToEdit: 1
    });

Ext.define('MyDashBoard.view.ComparisonTable',{
	extend:'Ext.grid.Panel',
	requires:['Ext.selection.CellModel','Ext.selection.CheckboxModel'],
	alias:'widget.comparisontable',
	id : 'configTableGrid',
	name : 'configTableGrid',
	layout:{type:'vbox',align:'stretch'},
	cls:'configTableGrid',
	ui: 'newGridPanel mydashboard_grid',
	style:{'border-top':'0px solid gray !important'},
	margin:'0 0 0 0',
	flex:1,
	height:125,
	autoScroll:true,
	header:false,
	//scroll : true,
	isAggregationDisabled : false,
	isCombinationChart : false,
	needToHideMeasure : false,
	blockId : null,
	//width:'100%',
	viewConfig: {
		deferEmptyText: false
	},
	emptyText : '<div style="width:100%; display:table"><div style="display:table-cell; vertical-align:middle; text-align:center;"><a href="javascript:void(0)"  onClick="javascript:openConfigureTab();" ><span class=""><img src="/final/images/'+strSkin+'/configureMetricsIcon.png" style="vertical-align:middle;"></span><span class="" style="margin-left:5px; border-bottom:1px solid #999; font-size:14px; padding:1px 0px;">'+screenLabelsObj['ConfigureMetrics']+'</span></a></div></div>',
			//emptyText : '<table width="100%" height="10px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><div styel="margin:10px auto">'+noConfigAvailableMsg+'</div></td></tr></table>',
	//emptyText : '<table width="98%" height="70" style="margin-top:30px"><tr><td align="center"><div class="alert22"/></td></tr><tr><td align="center"><div>'+noConfigAvailableMsg+'</div></td></tr></table>',  
	initComponent : function()
	{
		this.selModel =  new Ext.selection.CheckboxModel({
				checkOnly: true,
				headerWidth:26,
				injectCheckbox: 0
			});
		this.getStore().removeAll();
		var isAggregationDisabled = this.isAggregationDisabled;
		var isCombinationChart = this.isCombinationChart;
		var needToHideMeasure = this.needToHideMeasure;
		if(!needToHideMeasure)
		{
			this.plugins=  [cellEditing];
		}

		if(needToHideMeasure)
		{
			this.emptyText='<table width="100%" height="10px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><div styel="margin:10px auto">'+noConfigAvailableMsg+'</div></td></tr></table>';
		}

		this.columns = [

            {
				text: compDispLbl, 
				flex: 1, 
				dataIndex: 'component',
				editor: {
				    allowBlank: false
				}
			},
			{
				text: testDispLbl, 
				flex: 1, 
				dataIndex: 'test'
			},
			{
				text: measDispLbl, 
				flex: 1, 
				dataIndex: 'measure',
				hidden : needToHideMeasure,
				editor: {
				    allowBlank: false
				}
			},
			{
				text: descDispLbl, 
				flex: 1, 
				dataIndex: 'descriptor',
				editor: {
				    allowBlank: false
				}
			},
			{
				text: aggEnabledLbl, 
				flex: 1, 
				dataIndex: 'isAggregationEnabled',
				hidden : isAggregationDisabled
			},
			{
				text: aggFuncLbl, 
				flex: 1, 
				dataIndex: 'aggFunction',
				hidden : isAggregationDisabled,
				field: {
					xtype: 'scrollcombo',
					editable : false,
					//typeAhead: true,
					//triggerAction: 'all',
					selectOnTab: true,
					displayField: 'displayField',
                    valueField: 'valueField',
					store : Ext.create('Ext.data.Store', {
                                fields: ['displayField', 'valueField'],
						data: [{'displayField' : 'Avg', 'valueField' : 'Avg'},{'displayField' : 'Max','valueField' : 'Max'},{'displayField' : 'Min','valueField' : 'Min'},{'displayField' : 'Sum','valueField' : 'Sum'}]
					}),
					lazyRender: true
				}	
			},
			{
				text: chartTypeLbl, 
				flex: 1, 
				dataIndex: 'chartType',
				hidden : isCombinationChart,
				field: {
					xtype: 'scrollcombo',
					editable : false,
					//typeAhead: true,
					//triggerAction: 'all',
					selectOnTab: true,
					displayField: 'displayField',
                    valueField: 'valueField',
					/*store: [
						['line','spline'],
						['column','column'],
					//	['Sun or Shade','Sun or Shade'],
					//	['Mostly Sunny','Mostly Sunny'],
					//	['Sunny','Sunny']
					],*/
					store : Ext.create('Ext.data.Store', {
                                fields: ['displayField', 'valueField'],
						data: [{'displayField' : 'line', 'valueField' : 'line'},{'displayField' : 'column','valueField' : 'column'},{'displayField' : 'Area','valueField' : 'Area'}]
					}),
					lazyRender: true
					//listClass: 'x-combo-list-small'
				}
			},
			{
			header: '<div class="iconDeleteAll" style="margin:0px auto 0px auto" data-qclass="yellowTip" data-qtip="'+toolDeleteAll+'"></div>',
            xtype: 'actioncolumn',
			enableColumnHide:false,
			menuDisabled:true,
			renderer: function(value, metaData) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+toolDelete+'"';
								return value;
							},
			//tooltip: 'Remove All',
            width:36,
            sortable: false,
            items: [{
                iconCls: 'iconDelete',
				
                //tooltip: 'Delete',
                handler: function(grid, rowIndex, colIndex) {
					var rec = grid.getStore().getAt(rowIndex);
                    grid.store.remove(rec); 
					Ext.getCmp('doneButton').enable();

					var gridRecsCnt=grid.getStore().getCount();
					if(gridRecsCnt==0)
					{
						var controllerSettingObj=Ext.getCmp('controllerSetting');
						if(!Ext.isEmpty(controllerSettingObj))
						{
							controllerSettingObj.setDisabled(true);
						}
					}
                }
            }],
			listeners:{
				'headerclick':function( ct, column, e, t, eOpts ){
					var thisGrid = this.up('grid'),
					thisGridStore = thisGrid.getStore(),
					thisGridSelections = thisGrid.getSelectionModel(),
					noOfrecords = thisGridStore.getCount();
					if ( noOfrecords > 0 )
								{
									var selection = thisGridSelections.getSelection();
									if(selection.length==0)
									{
										 Ext.Msg.show({
											title: myDashboardAlertLbl,
											msg: noConfigSelectedAlertMsg,
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
										});
										return;
									}
									Ext.Msg.show({
										title:myDashboardAlertLbl,
										msg:metricsDeleteAlertMsg,
										buttons: Ext.Msg.YESNO,
										icon: Ext.Msg.QUESTION,
										fn:function(buttonId)
										{
											if(buttonId =="yes")
											{

													var chkTotal = (thisGrid.selModel.selected.getCount() === thisGrid.getStore().getCount());
													if(chkTotal){
													thisGridStore.remove(selection);
													}else{
													for (var i=0; i< selection.length ; i++ )
													{
														thisGridStore.remove(selection[i]);
													}
													}
													thisGrid.selModel.toggleUiHeader();
													Ext.getCmp('doneButton').enable();

													var gridRecsCnt=thisGridStore.getCount();
													if(gridRecsCnt==0)
													{
														var controllerSettingObj=Ext.getCmp('controllerSetting');
														if(!Ext.isEmpty(controllerSettingObj))
														{
															controllerSettingObj.setDisabled(true);
														}
													}
											}
										}
									});
								}
								else
								{
									 Ext.Msg.show({
										title: 'Alert',
										msg: noConfigAvailableMsg,
										buttons: Ext.MessageBox.OK,
										icon: Ext.MessageBox.WARNING
									});
									return;
								}
					


				}
			}
        }
        ];
		this.callParent();
	},
	listeners:{
		render: function()
		{
			var blkId=this.blockId;
			var meCompGrid=this;
			this.on('validateedit',function(editor, e1,eOpts) {
			if(e1.field=='component')
			{
				var editor = editor.getEditor(e1.record, e1.column);
				var edv = editor.getValue();
				if(edv=='')
				{
					Ext.Msg.show({
						title: myDashboardAlertLbl,
						msg: componentEmptyMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				else if (meCompGrid.checkSpecialCharacter(edv)) {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : editNameAlertMsgForHyphen,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				else if((edv!=null && edv!=e1.originalValue) && (e1.grid.store.find('component', edv, 0, false, true, true)!=-1))
				{
					Ext.Msg.show({
						title: myDashboardAlertLbl,
						msg: 'component name already exists',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					
					return false;
				}

			}
			else if(e1.field=='measure')
			{
				var editor = editor.getEditor(e1.record, e1.column);
				var edv = editor.getValue();
				if(edv=='')
				{
					Ext.Msg.show({
						title: myDashboardAlertLbl,
						msg: componentEmptyMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				else if (meCompGrid.checkSpecialCharacter(edv)) {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : editNameAlertMsgForHyphen,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return false;
				}
				else if((edv!=null && edv!=e1.originalValue) && (e1.grid.store.find('measure', edv, 0, false, true, true)!=-1))
				{
					Ext.Msg.show({
						title: myDashboardAlertLbl,
						msg: 'Measure name already exists',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					
					return false;
				}
			}
			else if(e1.field=='descriptor')
			{
				var editor = editor.getEditor(e1.record, e1.column);
				var edv = editor.getValue();
				if(edv=='')
				{
					Ext.Msg.show({
						title: myDashboardAlertLbl,
						msg: componentEmptyMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				else if (meCompGrid.checkSpecialCharacter(edv)) {
					Ext.Msg.show({
						title : myDashboardAlertLbl,
						msg : editNameAlertMsgForHyphen,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
					return false;
				}
				else if((edv!=null && edv!=e1.originalValue) && (e1.grid.store.find('descriptor', edv, 0, false, true, true)!=-1))
				{
					Ext.Msg.show({
						title: myDashboardAlertLbl,
						msg: 'descriptor name already exists',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					
					return false;
				}
			}
		});
		this.on('beforeedit', function(editor, e) {
			if(e.field=='aggFunction')
			{
				var isAggEnbled = e.record.data['isAggregationEnabled'];
				if(isAggEnbled == 'No')
				{
					return false;
				}
			}
			else if(e.field=='descriptor')
			{
				var descripVal = e.record.data['descriptor'];
				if(descripVal == 'All Descriptors')
				{
					return false;
				}
			}
		});
		this.on('edit', function(editor, e) {
				// commit the changes right after editing finished
			if(e.field=='component')
			{
				if(e.value=='')
				{
					Ext.Msg.show({
						title: myDashboardAlertLbl,
						msg: componentEmptyMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
				var editedRecord_descHidVal = e.record.data['descriptorHidVal'];
				var editedCompHidVal=editedRecord_descHidVal.substring(0,editedRecord_descHidVal.indexOf("|"));
				if(blkId!=null && blkId.indexOf('health')>-1)
				{
					 if(editedCompHidVal!=null && (editedCompHidVal.lastIndexOf("-")>-1 && (editedCompHidVal.lastIndexOf("-")>editedCompHidVal.indexOf("$"))))
					 {
						editedCompHidVal=editedCompHidVal.substring(0,editedCompHidVal.lastIndexOf("-"));
					 }
				}
				else
				{
				if(editedCompHidVal!=null && editedCompHidVal.indexOf("!HYPEN!")>-1)
				{
					editedCompHidVal=editedCompHidVal.substring(0,editedCompHidVal.indexOf("!HYPEN!"));
					}
				}
				var editedStr=e.value;
				 e.grid.getStore().each(function(record1) {
					 var descriptorHidVal = record1.data['descriptorHidVal'];
					 var compHidVal=descriptorHidVal.substring(0,descriptorHidVal.indexOf("|"));
					 var descripVal='';
					 if(blkId!=null && blkId.indexOf('health')>-1)
					 {
						 if(compHidVal!=null && (compHidVal.lastIndexOf("-")>-1 && (compHidVal.lastIndexOf("-")>compHidVal.indexOf("$"))))
						 {
							descripVal=compHidVal.substring(compHidVal.lastIndexOf("-"),compHidVal.length);
							compHidVal=compHidVal.substring(0,compHidVal.lastIndexOf("-"));
						 }
					 }
					 else
					 {
					 if(compHidVal!=null && compHidVal.indexOf("!HYPEN!")>-1)
					 {
						descripVal=compHidVal.substring(compHidVal.indexOf("!HYPEN!"),compHidVal.length);
						compHidVal=compHidVal.substring(0,compHidVal.indexOf("!HYPEN!"));
						 }
					 }
					 if(compHidVal!=null && compHidVal.indexOf("|underscore|")>-1)
					 {
						 descripVal=compHidVal.substring(compHidVal.indexOf("|underscore|"),compHidVal.length);
						 compHidVal=compHidVal.substring(0,compHidVal.indexOf("|underscore|"));
					 }
					 if(compHidVal!=null && compHidVal==editedCompHidVal)
					 {
						 var editedDescriptHidVal=editedStr;
						 if(!Ext.isEmpty(descripVal))
						 {
							 editedDescriptHidVal=editedDescriptHidVal+descripVal;	
						 }
						 var modifiedDescriptorHidVal = descriptorHidVal.substring(0,descriptorHidVal.indexOf("$")+1)+editedDescriptHidVal+descriptorHidVal.substring(descriptorHidVal.indexOf("|"));
						record1.data['descriptorHidVal'] = modifiedDescriptorHidVal;
						record1.data['component']=editedStr;
						record1.data['componentDisplayName']=descriptorHidVal.substring(0,descriptorHidVal.indexOf("$")+1)+editedStr;
					}
				});
				e.grid.getStore().sync();
				e.grid.getView().refresh();
				Ext.getCmp('doneButton').enable();
			}
			else if(e.field=='chartType')
			{
				var descriptorHidVal = e.record.data['descriptorHidVal'];
				var compWithDisplay = descriptorHidVal.substring(0,descriptorHidVal.indexOf("|")+1);
				var measDisplay = descriptorHidVal.substring(descriptorHidVal.indexOf("|")+1);
				var testMeasure = measDisplay.substring(measDisplay.indexOf("$")+1);
				var descriptorVal=testMeasure.substring(testMeasure.indexOf("$")+1);
				testMeasure=testMeasure.substring(0,testMeasure.indexOf("$"));	
				measDisplay=measDisplay.substring(0,measDisplay.indexOf("$"));
				if(testMeasure!=null && testMeasure.indexOf("~^~")>0)
					testMeasure=testMeasure.substring(0,testMeasure.indexOf("~^~"));

				var modifiedDescriptorHidVal=compWithDisplay+measDisplay+"$"+testMeasure+"~^~"+e.value+"$"+descriptorVal;
				e.record.data['descriptorHidVal'] = modifiedDescriptorHidVal;
				Ext.getCmp('doneButton').enable();
			}
			else if(e.field=='aggFunction')
			{
				var descriptorHidVal = e.record.data['descriptorHidVal'];
				var aggVal=e.record.data['aggFunction'];
				var measuresHidVal= e.record.data['measuresHidVal'];
				if(measuresHidVal!=null && measuresHidVal.indexOf("|HASH|")>0){
				var measureVal=measuresHidVal.substring(0,measuresHidVal.indexOf("(")+1);
				var testVal=measuresHidVal.substring(measuresHidVal.indexOf(")"));
				var testdisp=testVal.substring(0,testVal.indexOf("|HASH|")+6);
				var modifiedMeasuresHidVal=measureVal+aggVal+testdisp+aggVal;
				e.record.data['measuresHidVal'] = modifiedMeasuresHidVal;
				}
				
				if(descriptorHidVal!=null && descriptorHidVal.indexOf("|HASH|")>0){
				
				var serverVal=descriptorHidVal.substring(0,descriptorHidVal.indexOf("(")+1);
				var descriptorVal=descriptorHidVal.substring(descriptorHidVal.indexOf(")"));
				var measDisplay = descriptorVal.substring(descriptorVal.indexOf("|HASH|")+6);
				var desVal=descriptorVal.substring(0,descriptorVal.indexOf("|HASH|")+6);
				var testMeasure = measDisplay.substring(measDisplay.indexOf("$"));
				var modifiedDescriptorHidVal=serverVal+aggVal+desVal+aggVal+testMeasure;
				e.record.data['descriptorHidVal'] = modifiedDescriptorHidVal;
				}
				Ext.getCmp('doneButton').enable();
			}
			else if(e.field=='measure')
			{
				var editedRecord_descHidVal = e.record.data['descriptorHidVal'];
				var editedTestMeasureWithDisplay = editedRecord_descHidVal.substring(editedRecord_descHidVal.indexOf("|")+1,editedRecord_descHidVal.length);
				var editedMeasDispName=editedTestMeasureWithDisplay.substring(0,editedTestMeasureWithDisplay.indexOf("$"));
				var measuresHidVal = e.record.data['measuresHidVal'];
				var editedStr=e.value;
				 e.grid.getStore().each(function(record1) {
					 var descriptorHidVal = record1.data['descriptorHidVal'];
					 var testMeasureWithDisplay = descriptorHidVal.substring(descriptorHidVal.indexOf("|")+1,descriptorHidVal.length);
					 var measDispName=testMeasureWithDisplay.substring(0,testMeasureWithDisplay.indexOf("$"));
					 var testMeasWithDescriptor=testMeasureWithDisplay.substring(testMeasureWithDisplay.indexOf("$")+1,testMeasureWithDisplay.length);
					 var internalTestMeas=testMeasWithDescriptor.substring(0,testMeasWithDescriptor.indexOf("$"));
					 var descpVal=testMeasWithDescriptor.substring(testMeasWithDescriptor.indexOf("$")+1,testMeasWithDescriptor.length);
					
					 if(measDispName!=null && measDispName==editedMeasDispName)
					 {
						 var compWithDisplay = descriptorHidVal.substring(0,descriptorHidVal.indexOf("|"));
						 var modifiedMeasureHidVal = editedStr+"$"+internalTestMeas;
						 var modifiedDescriptorHidVal= compWithDisplay+"|"+modifiedMeasureHidVal+"$"+descpVal;
						record1.data['descriptorHidVal'] = modifiedDescriptorHidVal;
						record1.data['measure']=editedStr;
						record1.data['measuresHidVal']=modifiedMeasureHidVal;
					}
				});
				e.grid.getStore().sync();
				e.grid.getView().refresh();
				Ext.getCmp('doneButton').enable();
			}
			else if(e.field=='descriptor')
			{
				var editedRecord_descHidVal = e.record.data['descriptorHidVal'];
				 var testMeasureWithDisplay = editedRecord_descHidVal.substring(editedRecord_descHidVal.indexOf("|")+1,editedRecord_descHidVal.length);
				 var testMeasWithDescriptor=testMeasureWithDisplay.substring(testMeasureWithDisplay.indexOf("$")+1,testMeasureWithDisplay.length);				 
				 var editedDesc=testMeasWithDescriptor.substring(testMeasWithDescriptor.indexOf("$")+1,testMeasWithDescriptor.length);
				 var editedStr=e.value;
				 e.grid.getStore().each(function(record1) {
					 var descriptorHidVal = record1.data['descriptorHidVal'];
					 var testMeasureWithDisplay = descriptorHidVal.substring(descriptorHidVal.indexOf("|")+1,descriptorHidVal.length);
					 var measDispName=testMeasureWithDisplay.substring(0,testMeasureWithDisplay.indexOf("$"));
					 var testMeasWithDescriptor=testMeasureWithDisplay.substring(testMeasureWithDisplay.indexOf("$")+1,testMeasureWithDisplay.length);
					 var internalTestMeas=testMeasWithDescriptor.substring(0,testMeasWithDescriptor.indexOf("$"));
					 var descpVal=testMeasWithDescriptor.substring(testMeasWithDescriptor.indexOf("$")+1,testMeasWithDescriptor.length);
					
					 if(descpVal!=null && descpVal==editedDesc)
					 {
						 var compWithDisplay = descriptorHidVal.substring(0,descriptorHidVal.indexOf("|"));
						 var dispCompName=compWithDisplay;
						 var compInternalDispName=compWithDisplay;
						
						 if(blkId!=null && blkId.indexOf('health')>-1)
						 {
							 if(compWithDisplay!=null && compWithDisplay.lastIndexOf("-")>-1)
							 {
								compWithDisplay=compWithDisplay.substring(0,compWithDisplay.lastIndexOf("-"))+"-"+editedStr;
								
								 if(dispCompName!=null && dispCompName.indexOf("$")>0)
								 {
									dispCompName=dispCompName.substring(dispCompName.indexOf("$")+1,dispCompName.lastIndexOf("-"));//+"-"+editedStr;
								 }
							 }
							 if(compWithDisplay!=null && compWithDisplay.indexOf("|underscore|")>-1)
							 {
								 compDispName=compWithDisplay.substring(0,compWithDisplay.indexOf("|underscore|"))+"_"+editedStr;
								 if(dispCompName!=null && dispCompName.indexOf("$")>0)
								 {
									dispCompName=dispCompName.substring(dispCompName.indexOf("$")+1,dispCompName.indexOf("|underscore|"));//+"_"+editedStr;
								 }
							 }
						 }
						 else
						 {
							 if(compWithDisplay!=null && compWithDisplay.indexOf("!HYPEN!")>-1)
							 {
								compWithDisplay=compWithDisplay.substring(0,compWithDisplay.indexOf("!HYPEN!"))+"!HYPEN!"+editedStr;
								
								 if(dispCompName!=null && dispCompName.indexOf("$")>0)
								 {
									dispCompName=dispCompName.substring(dispCompName.indexOf("$")+1,dispCompName.indexOf("!HYPEN!"));//+"-"+editedStr;
								 }
							 }
							 if(compWithDisplay!=null && compWithDisplay.indexOf("|underscore|")>-1)
							 {
								 compDispName=compWithDisplay.substring(0,compWithDisplay.indexOf("|underscore|"))+"_"+editedStr;
								 if(dispCompName!=null && dispCompName.indexOf("$")>0)
								 {
									dispCompName=dispCompName.substring(dispCompName.indexOf("$")+1,dispCompName.indexOf("|underscore|"));//+"_"+editedStr;
								 }
							 }
						 }
						 var modifiedDescriptorHidVal= compWithDisplay+descriptorHidVal.substring(descriptorHidVal.indexOf("|"),descriptorHidVal.length);
					
						record1.data['descriptorHidVal'] = modifiedDescriptorHidVal;
						record1.set('component', dispCompName);
						record1.data['descriptor']=editedStr;
						record1.data['descriptorDisplayName']=descpVal+"!^!"+editedStr;
					}
				});
				e.grid.getStore().sync();
				e.grid.getView().refresh();
				Ext.getCmp('doneButton').enable();
			}
			
			});
		
		}
	},
/*	dockedItems:[
	{
		xtype:'toolbar',
		ui:'footer',
		layout:{
			pack: 'center'
		},
		padding:'5 0 5 0',
		dock:'bottom',
		items:[
		{
			xtype:'button',
			text:updateDispBtn,
			id : 'updateBlockConfig',
			name : 'updateBlockConfig',
			cls: 'buttonNew',
			padding:'0 10 0 10',
		}
		]
	}
	],*/
	title: selectionsLbl,
	//width:200,
	//plugins: [cellEditing],
	store:Ext.create('Ext.data.ArrayStore',{
		fields: [
            {name: 'component',type : 'string'},
            {name: 'test', type: 'string'},
            {name: 'measure', type: 'string'},
            {name: 'descriptor', type: 'string'},
            {name: 'measuresHidVal', type: 'string'},
            {name: 'descriptorHidVal', type: 'string'},
            {name: 'componentsHidVal', type: 'string'},
            {name: 'isAggregationEnabled', type: 'string'},
            {name: 'aggFunction', type: 'string'},
            {name: 'hidVal', type: 'string'},
            {name: 'chartType', type: 'string'},
            {name: 'descriptorDisplayName', type: 'string'},

         ],
		data:[]
	}),
	selModel: {
         selType: 'cellmodel'
    },
	checkSpecialCharacter : function(dashboardName) {
		var splChar = "$-";
		for ( var i = 0; i < dashboardName.length; i++) {
			check_char = splChar.indexOf(dashboardName.charAt(i))
			// Returns value 1 if the special character listed
			// in splChar is found
			if (check_char >= 0) {
				return true;
    }
		}
		return false;
	}
})