Ext.define('MyDashBoard.view.ConfigTemplateWindow',{
	extend:'Ext.window.Window',
	alias:'widget.configtemplatewindow',
	width:700,
	scroll:true,
	resizable:false,
	autoScroll : true,
	/*header:{
		height:33,
		padding:'0 10',
		margin:0
	},*/
	ghost:false,
	cls:'myDashboardwindow',
	ui:'newPopupWindow widgetOptionsWindowHeader',
	bodyPadding:0,
    frame:true,
	padding:0,
	border:false,
	modal:true,
	title:'Layout Settings',
	layout:'fit',
	flex:1,
	id : 'configtemplatewindowObj',
	tools:[
			{
			xtype : 'button',
			iconCls : 'iconHelp',
			listeners: {
			afterrender: function () {
			Ext.create('Ext.tip.ToolTip', {
			target: this.id,
			anchor: 'top',
			cls: 'yellowTip',										
			trackMouse: true,
			html: 'Help'
			});
			}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 1 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}],
	closeAction : 'destroy',
	dashBoardAction : '',
	profileName : '',
	items:[
		{
			xtype:'form',
			layout:'anchor',
			itemId : 'addDashboardForm',
			name:'layoutConfig',
			bodyPadding:10,
			autoScroll : true,
			defaults:{
				labelSeparator:'',
				labelAlign:'top',
				width:250,
				labelStyle: 'font-weight: bold;',
				defaults:{
					labelSeparator:'',
				labelAlign:'top',
				width:250,
				
				labelStyle: 'font-weight: bold;'
				}
			},
			items:[
				{
					xtype:'textfield',
					id : 'dashbrdNam',
					name:'dashbrdNam',
					cls: 'textbox',
					fieldLabel:'Dashboard Name'
				},
				{
					xtype:'label',
					id : 'dashboardnamelbl',
					name:'dashboardnamelbl',
				    margin:'5 0 10 0',
					fieldLabel:'Dashboard Name',
					hidden : true
				},
				{
					xtype:'textareafield',
					cls: 'text-area',
					id : 'dashbrdDescription',
					name:'dashbrdDescription',
					width : 660,
					height:100,
					margin:'10 0 5 0',
					fieldLabel:descriptionDispLbl
				},
				{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:660,
					id:'combocontainer',
					name:'combocontainer',
					margin:'0 0 10 0',
					items:[
					{
						xtype:'textfield',
						id:'refreshFreqTxtBox',
						name:'refreshFreqTxtBox',
						cls: 'textbox',
						width:185,
						margin:'3 20 0 0',
						value : 60,
						fieldLabel:refreshTxtBoxLbl
					},
					{
					xtype:'scrollcombo',
					id:'infraTypeCombo',
					name:'infraTypeCombo',
						width:185,
						margin:'3 20 0 0',
					value:'Components',
					cls: 'dropdown',
					fieldLabel:'Type',
					editable:false,
					displayField:'displayField',
					valueField: 'valueField',
					store:Ext.create('Ext.data.Store',{
						fields:['valueField','displayField'],
						data:[]
					}),
					queryMode: 'local'
				},
				{
					xtype:'scrollcombo',
					id:'subInfraTypeCombo',
					name:'subInfraTypeCombo',
						width:120,
						margin:'3 20 0 0',
					value:'',
					cls: 'dropdown',
					fieldLabel:'',
					editable:false,
					displayField:'displayField',
					valueField: 'valueField',
					store:Ext.create('Ext.data.Store',{
						fields:['valueField','displayField'],
						data:[]
					}),
					queryMode: 'local',
					hidden : true
				},{
					xtype:'scrollcombo',
					id:'sharingCombo',
					name:'sharingCombo',
						width:100,
						margin:'3 8 0 0',
					value:'Private',
					cls: 'dropdown',
					fieldLabel:'Sharing',
					editable:false,
					displayField:'displayField',
					valueField: 'valueField',
					store:Ext.create('Ext.data.Store',{
						fields:['valueField','displayField'],
						data:[]
					}),
					queryMode: 'local'
					},{
						xtype: 'checkboxgroup',
						width: 220,
						margin:'29 5 0 0',
						labelWidth:this.lblwidth,
						name: 'sharededitCnt',
						labelAlign: 'left',
						items: [{
							boxLabel:allowRWShar,
							id: 'sharededit',
							hidden: true,
							name: 'sharededit',
							inputValue: 'yes',
							cls : 'checkbt',
							listeners: {
								'change': function (record, checked, opts) {
									if(Ext.getCmp('sharededit').checked==true){
									Ext.getCmp('sharededitselectCont').show();
									var storeData = Ext.getCmp('customSharedUsersObj').toField.store.getRange();
									if(storeData.length>0){
											Ext.getCmp('sharededitselect').getStore().loadData(storeData);
										}else{
											valJson = [];
											item={};
											item ["displayField"] = "Not Applicable";
											item ["valueField"] = "-1";
											valJson.push(item);
											Ext.getCmp('sharededitselect').getStore().loadRawData(valJson);
											Ext.getCmp('sharededitselect').setValue("-1");
										}
									}else{
										Ext.getCmp('sharededitselectCont').hide();
										Ext.getCmp('sharededitselect').getStore().remove();
										Ext.getCmp('sharededitselect').getStore().load();
									}
								}
							}
						}]
					}]
				},
					
				
			{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:660,
				items:[
				{
                            xtype: 'itemselector',
							cls:'itemselector',
                            id :'customSharedUsersObj',
                            name :'customSharedUsersObj',
							hidden : true,							
							buttons: ['add', 'remove'],
							buttonsText: {
									add: toolGrant,
									remove: toolRevoke
								},
							imagePath: '/final/images/',
                            multiSelect: true,
							margin:'3 10 0 0',
							height: 170,
							width: 400,
							scroll : true,
							toTitle:selectedUserslbl,
							fromTitle:availableUsersLbl,
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
						   store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							queryMode: 'local',
							  moveRec: function(add, recs) {
									var me = this,
										fromField = me.fromField,
										toField   = me.toField,
										fromStore = add ? fromField.store : toField.store,
										toStore   = add ? toField.store   : fromField.store;


									if(add==true)
									{
										if(fromField.store.getCount()==0)
										{
											Ext.Msg.show({
											title: myDashboardAlertLbl,
											msg: availableUserAlertLbl,
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
											 });
											return;
										}
									}
									else
									{
										if(toField.store.getCount()==0)
										{
											Ext.Msg.show({
											title: myDashboardAlertLbl,
											msg: selectedUserAlertLbl,
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
											 });
											return;
										}
									}

									fromStore.suspendEvents();
									toStore.suspendEvents();
									fromStore.remove(recs);
									toStore.add(recs);
									fromStore.resumeEvents();
									toStore.resumeEvents();

									fromField.boundList.refresh();
									toField.boundList.refresh();

									me.syncValue();
							},
							listeners: {
								'change': function () {
									var storeData = Ext.getCmp('customSharedUsersObj').toField.store.getRange();
									if(storeData.length>0){
										Ext.getCmp('sharededit').show();
									}
									if(Ext.getCmp('sharededit').checked==true && storeData.length>0){
										Ext.getCmp('sharededitselect').getStore().loadData(storeData);
									}else{
										valJson = [];
										item={};
										item ["displayField"] = "Not Applicable";
										item ["valueField"] = "-1";
										valJson.push(item);
										Ext.getCmp('sharededitselect').getStore().loadRawData(valJson);
										Ext.getCmp('sharededitselect').setValue("-1");
									}
								}
							}


                        },
						{
							xtype:'fieldcontainer',
							id: 'sharededitselectCont',
							layout:'vbox',
							hidden:true,
							margin:'6 10 0 0',
							width:260,
							fieldLabel: rwShareAvailUser,
							labelAlign:'top',
							labelSeparator:' ',
							height:'100%',
							items:[								
						   {
							xtype: 'multiselect',
							id: 'sharededitselect',
							name: 'sharededitselect',
									margin:'0 10 0 0',
							baseCls: 'egmultiselect',
							border: true,
							bodyPadding: 0,
							multiSelect: true,
							scroll: false,
							autoScroll: false,
							style:{'border':'1px solid red'},
							height: 146,
							layout: 'fit',
							width: 240,
							displayField: 'displayField',
							valueField: 'valueField',
							store: Ext.create('Ext.data.Store', {
								fields: ['valueField', 'displayField'],
								data: []
							}),
							queryMode: 'local'
								}]
							}]
			}
			], dockedItems: [{
                        xtype: 'toolbar',
                        ui: 'footer',
                        layout: {
                            pack: 'center'
                        },
                        buttonAlign: 'center',
                        dock: 'bottom',
						margin : '0 0 5 0',
                        items: [

                            {
                                xtype: 'button',
                              	cls:'button20',
								margin : '0 0 5 0',
								padding:'0 5',
                                text: '',
								id : 'createDashboardBtn',
								name : 'createDashboardBtn'
								
                            }						
                        ]
                    }
                ]
		}
	]
	
});