var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit: 1
});

Ext.define('MyDashBoard.view.DSNListGrid', {
    extend: 'Ext.grid.Panel',
    requires: ['Ext.selection.CellModel', 'Ext.selection.CheckboxModel'],
    alias: 'widget.dsnlistgrid',
    id: 'dsnListGrid',
    name: 'dsnListGrid',
    ui: 'newGridPanel2',
    flex: 1,
    autoScroll: true,
    selectedDataSource: '',
	enableCtxMenu: false,  // turn off header context menu
    enableColumnMove: false,  // turn off column reorder drag drop
    enableColumnResize: false,  // turn off column resize for whole grid
    viewConfig: {
        forceFit: true,
        flex: 1,
        deferEmptyText: false
    },
    layout: {
        type: "vbox",
        align: "stretch"
    },
    emptyText: '<table width="100%" height="385px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div styel="margin:10px auto">' + screenLabelsObj['No Data Source Available'] + '</div></td></tr></table>',
    initComponent: function() {
        this.columns = [{
                text: '<span class="newFont_bold14">'+screenLabelsObj['Data Source Name']+'</span>',
                dataIndex: 'datasourcename',
                flex: 1,
                cls: 'newFont_bold14',
				sortable: false,
                editor: {
                    allowBlank: false
                }

            },
            {
                text: '<span class="newFont_bold14">'+screenLabelsObj['Type']+'</span>',
                dataIndex: 'integrationType',
                cls: 'newFont_bold14',
				sortable: false,
                editor: {
                    allowBlank: false
                }

            },
            {
                xtype: 'actioncolumn',
                enableColumnHide: false,
                cls: 'newFont_normal13',
                menuDisabled: true,
                renderer: function(value, metaData) {
                    metaData.tdAttr = 'data-qclass=yellowTip data-qtip='+editSettingsLbl;
                    return value;
                },
                width: 55,
                sortable: false,
                items: [{
                    iconCls: 'iconModify',
                    handler: function(grid, rowIndex, colIndex) {
                        var rec = grid.getStore().getAt(rowIndex);
                        var dsnName = rec.data.datasourcename;
                        var dsnSettingspopupObj = Ext.getCmp('dsnSettingspopup');
                        var thisWind = new Ext.LoadMask(dsnSettingspopupObj.getEl(), {
                            msg: "Loading..."
                        });
                        thisWind.show();
						//var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
                        var paramsForRestURL = 'action=editDSN&dsnName=' + encodeURIComponent(dsnName);
                        Ext.Ajax.request({
                            url: '/final/servlet/com.eg.RESTIntegrationController',
                            method: 'POST',
                            params: paramsForRestURL,
                            scope: this,
                            success: function(response) {
                                var jsonText = response.responseText;
                                if (jsonText != null && jsonText != '') {
                                    var jsonData = Ext.decode(jsonText);
                                    var fileUploadForm = Ext.getCmp('fileUploadForm');
                                    var headerRowObj = Ext.getCmp('headerRowCsv');
                                    var rowSelector = Ext.getCmp('rowSelectorCsv');
                                    var saveCsv = Ext.getCmp('saveCsv');
                                    var csvExcelConfigCont = Ext.getCmp('csvExcelConfigCont');
                                    var dsnConfigCont = Ext.getCmp('dsnConfigCont');
                                    var restdsnname = Ext.getCmp('restdsnname');
                                    restdsnname.hide();
                                    var tabPanelBox = Ext.getCmp('tabPanelBox');
                                    var addNewDS = Ext.getCmp('tabPanelBox');
                                    addNewDS.hide();
                                    var activeTab = tabPanelBox.getActiveTab();
                                    var integrationType = activeTab.id;
                                    var dsnListContObj = Ext.getCmp('dsnListCont');
                                    var addNewDSObj = Ext.getCmp('addNewDS');
                                    var sqlContObj = Ext.getCmp('sqlContainer');
                                    var sqlContainerObj1 = Ext.getCmp('sqlAttrContainer1');
                                    var sqlContainerObj2 = Ext.getCmp('sqlAttrContainer2');
                                    //var dsnSettingspopupObj = Ext.getCmp('dsnSettingspopup');

                                    var selectedDSN = jsonData['editDsn']['selectedDSN'];
                                    var integrationType = jsonData['editDsn']['integrationType'];
                                    var selectedDataFields = jsonData['editDsn']['selectedDataFields'];
                                    if (selectedDSN != null && selectedDSN != -1) {
                                        restdsnname.setValue(selectedDSN);
                                    }
                                    restdsnname.show();
                                    restdsnname.setReadOnly(true);
                                    var tabPanelBox = Ext.getCmp('tabPanelBox');
                                    var activeTab = tabPanelBox.getActiveTab();
                                    var integrationObj = activeTab; 
                                    dsnListContObj.hide();
                                    dsnConfigCont.show();
                                    if (integrationType == 'SQL') {
										var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
										var activeTab =  tabPanelBoxobj.setActiveTab(1); 
										var integrationType = activeTab.id;
                                        sqlContObj.show();
                                        Ext.getCmp('dbType').setValue(jsonData['editDsn']['dbType']);
										var dataGridTitleObj=Ext.get('DataGridTitle');
										if(!Ext.isEmpty(dataGridTitleObj))
										{
											dataGridTitleObj.dom.innerHTML=dsnName+" "+screenLabelsObj['DataPreviewLbl'];
										}
                                        var sqlAttrArray = jsonData['editDsn']['sqlDbAttributes']['sqlAttrArray'];
                                        var fieldsComboArr = [];
                                        var fieldsComboIdArr = [];
                                        for (var widA in sqlAttrArray) {
                                            var sqlAttrOpt = sqlAttrArray[widA];
                                            var dispLbl = sqlAttrOpt['displayField'];
                                            var valLbl = sqlAttrOpt['valueField'];
                                            var UI_Control = sqlAttrOpt['UI_Control'];
                                            var val = jsonData['editDsn'][valLbl];
                                            if (UI_Control != 'button') {
                                                fieldsComboIdArr.push(valLbl);
                                            }
                                            if (valLbl == 'password') {
                                                fieldsComboArr.push({
                                                    xtype: UI_Control,
                                                    fieldLabel: dispLbl,
                                                    id: valLbl,
													cls: 'textbox',
													labelWidth: 150,
													width:400,
													margin:'0 0 17 10',
													inputType : 'password',
													name: valLbl,
													value : val
                                                });
                                            } else if (valLbl == 'test') {
                                                fieldsComboArr.push({
                                                    xtype: UI_Control,
                                                    text: dispLbl,
                                                    id: valLbl,
													name: valLbl,
													cls: 'textbox',
													layout: {
														type:'column'
													},
													margin:'0 0 10 0',
													cls:'button20 restBgButton',
													style: {
														'float': 'right',
														'height': '21px'
													},
                                                });
                                            } 
											else if(valLbl=='sqlquery')
											{
												fieldsComboArr.push({
																	xtype : UI_Control,
																	fieldLabel: dispLbl,
																	labelWidth: 100,
																	margin:'0 0 0 40',
																	height: 220,
																	id: valLbl,
																	name: valLbl,
																	width : 350,
																	cls: 'text-area',
																	value : val

																});
											}
											else if(valLbl=='database')
												{
													fieldsComboArr.push({
																		xtype : UI_Control,
																		fieldLabel: dispLbl,
																		id: valLbl,
																		name: valLbl,
																		layout: {
																			type:'column'
																		},
																		style: {
																			'float': 'left'
																		},
																		labelWidth: 150,
																		margin:'0 0 17 10',
																		width : 290,
																		value: val,
																		cls: 'textbox'

																	});
												}
											
											else {
                                                fieldsComboArr.push({
                                                    xtype: UI_Control,
                                                    fieldLabel: dispLbl,
                                                    id: valLbl,
													labelWidth: 150,
													cls: 'textbox',
													margin:'0 0 17 10',
                                                    tdCls: 'newFont_normal13',
                                                    name: valLbl,
                                                    width: 400,
                                                    value: val
                                                });
                                            }
                                        }

                                        var total_len = fieldsComboArr.length;
                                        var left_side = fieldsComboArr.splice(0, 6);
                                        var right_side = fieldsComboArr.splice(left_side, total_len);
                                        sqlContainerObj1.removeAll();
                                        sqlContainerObj1.add(left_side);
                                        sqlContainerObj2.removeAll();
                                        sqlContainerObj2.add(right_side);
                                        sqlContainerObj1.show();
                                        sqlContainerObj2.show();
                                        dsnSettingspopupObj.sqlDbTypeFieldsIdArr = fieldsComboIdArr;
                                        Ext.getCmp('executeQuery').show();

                                        var gridCols = jsonData['editDsn']['sqlDataGrid']['gridCols'];
                                        var gridData = jsonData['editDsn']['sqlDataGrid']['gridData'];
                                        var dataTypeMapping = jsonData['editDsn']['sqlDataGrid']['dataTypeMapping'];
										dsnSettingspopupObj.dataTypeMapping=dataTypeMapping;
                                        var colsArr = [];
                                        var fields2Store = [];
                                        var filtersArr = [];
                                        var widthForEachColumn = 105;
                                        for (var colVal in gridCols) {
                                            var colName = gridCols[colVal].toString();
                                            fields2Store.push({
                                                name: colName,
                                                type: 'string'
                                            });
                                            colsArr
                                                .push(
												{
                                                    header: "<span class='newFont_normal11  DsWrapText'  data-qtip='" + colName + "' style='display:block;'><label class='dsCustomCheckBox' style=' margin: -2px 7px 0 0px;display: block;float: left;width:16px'><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='" + colName + "'><span class='labelCheckBOx'></span></label>" + colName + "</span>",
                                                    dataIndex: colName,
                                                    sortable: false,                                                    
                                                    tdCls: 'DsWrapText',
                                                    cls: 'x-grid-checkheader-editor',
                                                    listeners: {
                                                        headerclick: function(ct, column, e, t, eOpts) {
                                                        }
                                                    },
                                                    renderer: function(value, metaData, record, row, col, store, gridView) {
														var value = '<span class="newFont_normal11 DsWrapText" data-qtip="' + value + '">' + value + '</span>';
                                                        return value;
                                                    }

                                                });

                                        }
										var storeVal1 = Ext.create('Ext.data.Store', {
                                            fields: fields2Store,
                                            data: gridData


                                        });

                                        var gridObj = Ext.getCmp('sqlData_grid');
                                        gridObj.getStore().removeAll();
                                        gridObj.reconfigure(storeVal1, colsArr);
                                        gridObj.show();
										gridObj.view.fireEvent('resize',gridObj.view);
										Ext.getCmp('restdsnname').hide();
										Ext.getCmp('DsintegrateText').hide();
										Ext.getCmp('csvExcelConfigCont').hide();
										Ext.getCmp('csvExcelConfigCont1').hide();
										Ext.getCmp('containerid').hide();
										Ext.getCmp('sqlPreviewBox').show();
										var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
										var activeTab =  tabPanelBoxobj.setActiveTab(1); 
										var integrationType = activeTab.id;
                                        var inputElements = document.getElementsByClassName('messageCheckbox');
                                        var selectedDataFieldsArr = selectedDataFields.split(',');
                                        for (var i = 0; inputElements[i]; ++i) {
                                            var index = selectedDataFieldsArr.indexOf(inputElements[i].value);
                                            if (index > -1) {
                                                inputElements[i].checked = true;
                                            }
                                        }
										

                                    } else if (integrationType == 'CSV' || integrationType == 'EXCEL') {
                                      
										var gridCols = jsonData['editDsn']['csvGrid']['gridJson']['gridCols'];
                                        var gridData = jsonData['editDsn']['csvGrid']['gridJson']['gridData'];
                                        var colsArr = [];
                                        var fields2Store = [];
                                        var filtersArr = [];
                                        var widthForEachColumn = 105;

										dsnListContObj.hide();
										 var DsintegrateTextobj= Ext.getCmp('DsintegrateText');
										 DsintegrateTextobj.show();
										  var tabPanelBoxobj= Ext.getCmp('tabPanelBox');
										 tabPanelBoxobj.show();
										 
										
										  if (integrationType == 'CSV') {
											   var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
												var activeTab =  tabPanelBoxobj.setActiveTab(3); 
												var integrationType = activeTab.id;
												var fileUploadFormobj= Ext.getCmp('fileUploadForm');
												fileUploadFormobj.show();
												tabPanelBoxobj.setActiveTab(3);
												var csvRowPanelCountobj= Ext.getCmp('csvRowPanelCount');
												csvRowPanelCountobj.show();
												var rowSelectorCsvobj= Ext.getCmp('rowSelectorCsv');
												rowSelectorCsvobj.hide();
												var csvExcelConfigContobj= Ext.getCmp('csvExcelConfigCont');
												csvExcelConfigContobj.hide();
												var csvExcelConfigCont1obj= Ext.getCmp('csvExcelConfigCont1');
												csvExcelConfigCont1obj.hide();
												var csvSaveButtonobj= Ext.getCmp('csvSaveButton');
												csvSaveButtonobj.show();
												var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
												
										  }
										   if (integrationType == 'EXCEL') {
												var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
												var activeTab =  tabPanelBoxobj.setActiveTab(2);
												var integrationType = activeTab.id;
												var fileUploadFormExcelobj= Ext.getCmp('fileUploadFormExcel');
												fileUploadFormExcelobj.show();
												fileUploadFormExcelobj.setWidth(366);
												tabPanelBoxobj.setActiveTab(2);
												var excelRowPanelCountObj= Ext.getCmp('excelRowPanelCount');
												excelRowPanelCountObj.show();
												var rowSelectorExcelObj= Ext.getCmp('rowSelectorExcel');
												rowSelectorExcelObj.hide();
												var csvExcelConfigContobj= Ext.getCmp('csvExcelConfigCont');
												csvExcelConfigContobj.hide();
												var csvExcelConfigCont1Obj= Ext.getCmp('csvExcelConfigCont1');
												csvExcelConfigCont1Obj.show();
												var fileupload_gridExcelObj = Ext.getCmp('fileupload_gridExcel');
												fileupload_gridExcelObj.show();
												var ExcelSaveButtonobj= Ext.getCmp('ExcelSaveButton');
												ExcelSaveButtonobj.show();
												
										 }
                                        saveCsv.show();
                                        for (var colVal in gridCols) {
                                            var colName = gridCols[colVal].toString();
                                            fields2Store.push({
                                                name: colName,
                                                type: 'string'
                                            });
                                            colsArr
                                                .push({
                                                    header: "<span class='newFont_normal11  DsWrapText' style='display:block; ' data-qtip='" + colName + "'><label class='dsCustomCheckBox' style='margin: -2px 7px 0 0px;display: block;float: left;width:16px'><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='" + colName + "'   ><span class='labelCheckBOx'></span></label>" + colName + "</span>",
                                                    dataIndex: colName,
                                                    sortable: false,
                                                    tdCls: 'newFont_normal11',
                                                    //tdCls : 'gridCellWrap',
                                                    cls: 'x-grid-checkheader-editor',
                                                    listeners: {
                                                        headerclick: function(ct, column, e, t, eOpts) {
                                                        }
                                                    },
                                                    renderer: function(value, metaData, record, row, col, store, gridView) {
														var value = '<span class="newFont_normal11 DsWrapText" data-qtip="' + value + '">' + value + '</span>';
                                                        return value;
                                                    }

                                                });

                                        }
                                        for (var colVal in colsArr) {
                                            var v = colsArr[colVal];
                                        }
										if (integrationType == 'CSV') {
											 var gridObj = Ext.getCmp('fileupload_gridCsv');
                                        gridObj.getStore().removeAll();
					
										}
										if (integrationType == 'EXCEL') {
											var gridObj = Ext.getCmp('fileupload_gridExcel');
											gridObj.getStore().removeAll();
											var csvExcelConfigCont1Obj= Ext.getCmp('csvExcelConfigCont1').hide();
										 
										
										}
                                       

                                        var storeVal1 = Ext.create('Ext.data.Store', {
                                            fields: fields2Store,
                                            data: gridData


                                        });
                                        gridObj.reconfigure(storeVal1, colsArr);
                                        gridObj.show();
										gridObj.view.fireEvent('resize',gridObj.view);
                                        var inputElements = document.getElementsByClassName('messageCheckbox');
                                        var selectedDataFieldsArr = selectedDataFields.split(',');
                                        for (var i = 0; inputElements[i]; ++i) {
                                            var index = selectedDataFieldsArr.indexOf(inputElements[i].value);
                                            if (index > -1) {
                                                inputElements[i].checked = true;
                                            }
                                        }
										var dataTypeMapping = jsonData['editDsn']['csvGrid']['gridJson']['dataTypeMapping'];
									   dsnSettingspopupObj.dataTypeMapping=dataTypeMapping;
                                    } else if (integrationType == 'REST') {
										
										var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
										var activeTab =  tabPanelBoxobj.setActiveTab(0); 
										var integrationType = activeTab.id;
                                        var restdsnname = Ext.getCmp('restdsnname');
                                        restdsnname.hide();
                                        var DsintegrateText = Ext.getCmp('DsintegrateText');
                                        DsintegrateText.hide();
                                        var csvExcelConfigCont1 = Ext.getCmp('csvExcelConfigCont1');
                                        csvExcelConfigCont1.hide();
										 var tabPanelBox = Ext.getCmp('tabPanelBox');
										var activeTab = tabPanelBox.setActiveTab(0);
										var integrationObj = activeTab;
                                        var addNewDS = Ext.getCmp('addNewDS');
                                        addNewDS.hide();
                                        var restDashMainPnl = Ext.getCmp('dsnSettingspopup');
                                        var urltextbox = Ext.getCmp('urltextbox');
                                        var restHttpMethod = Ext.getCmp('restHttpMethod');
                                        var tabPanelBoxobj = Ext.getCmp('tabPanelBox');
                                        var addNewDSobj = Ext.getCmp('addNewDS');
                                        tabPanelBoxobj.hide();
                                        addNewDSobj.hide();
                                        urltextbox.setValue(jsonData['editDsn']['restWS_URL']);
                                        restHttpMethod.setValue(jsonData['editDsn']['httpMethod']);
                                        var configuredHeaders = jsonData['editDsn']['configuredHeaders'];
                                        var configuredBodyUrlEncoded = jsonData['editDsn']['configuredBodyUrlEncoded'];
                                        var rawJsonBodyData = jsonData['editDsn']['rawJsonBody'];
                                        var dataFieldParentNode = jsonData['editDsn']['dataFieldParentNode'];
                                        if (!Ext.isEmpty(configuredHeaders)) {
                                            var viewTypeOptObj = Ext.getCmp('Header_Required');
                                            viewTypeOptObj.suspendEvents(false);
                                            var gridObj = Ext.getCmp('header_grid');
                                            var gridStore = gridObj.getStore();
                                            gridStore.removeAll();
                                            gridStore.add(configuredHeaders);
                                            gridObj.doLayout();
											Ext.getCmp('key').show();
											Ext.getCmp('value').show();
											Ext.getCmp('addHeader').show();
											Ext.getCmp('header_grid').show();
                                        } else {
                                            var viewTypeOptObj = Ext.getCmp('Header_Required');
                                            viewTypeOptObj.suspendEvents(false);
											Ext.getCmp('key').hide();
											Ext.getCmp('value').hide();
											Ext.getCmp('addHeader').hide();
											Ext.getCmp('header_grid').hide();
                                            var gridObj = Ext.getCmp('header_grid');
                                            var gridStore = gridObj.getStore();
                                            gridStore.removeAll();
                                        }
                                        if (jsonData['editDsn']['httpMethod'] != "" && jsonData['editDsn']['httpMethod'] == "POST") {
                                            var body_type = Ext.getCmp('body_type');
                                            body_type.show();
                                            var body_typeObj = body_type.getChecked();
                                            var body_name = jsonData['editDsn']['selectedBodyType'];
                                            if (body_name != null && body_name == "x-www-form-urlencoded") {

                                                var bodyTypeObj = Ext.getCmp('body_type');
                                                bodyTypeObj.suspendEvents(false);
                                                bodyTypeObj.setValue({
                                                    body_name: body_name
                                                });
                                                bodyTypeObj.show();
                                                bodyTypeObj.resumeEvents();
                                                bodyTypeObj = null;
                                                delete bodyTypeObj;

                                                Ext.getCmp('rawJsonBody').hide();
                                                Ext.getCmp('body_urlencoded_key').show();
                                                Ext.getCmp('body_urlencoded_value').show();
                                                Ext.getCmp('addBody_urlencoded').show();
                                                Ext.getCmp('bodyUrlEncodedGrid').show();
                                                if (configuredBodyUrlEncoded != null) {
                                                    var gridObj = Ext.getCmp('bodyUrlEncodedGrid');
                                                    var gridStore = gridObj.getStore();
                                                    gridStore.removeAll();
                                                    gridStore.add(configuredBodyUrlEncoded);
                                                    gridObj.doLayout();
                                                }
                                            } else {
                                                var bodyTypeObj = Ext.getCmp('body_type');
                                                bodyTypeObj.suspendEvents(false);
                                                bodyTypeObj.setValue({
                                                    body_name: body_name
                                                });
                                                bodyTypeObj.show();
                                                bodyTypeObj.resumeEvents();
                                                bodyTypeObj = null;
                                                delete bodyTypeObj;
                                                var rawJsonBody = Ext.getCmp('rawJsonBody');
                                                rawJsonBody.show();
                                                if (rawJsonBodyData != null && rawJsonBodyData != "") {
                                                    var rawJsonBodyVal = JSON.stringify(rawJsonBodyData, undefined, 2);
                                                    rawJsonBody.setValue(rawJsonBodyVal);
                                                }
                                                Ext.getCmp('body_urlencoded_key').hide();
                                                Ext.getCmp('body_urlencoded_value').hide();
                                                Ext.getCmp('addBody_urlencoded').hide();
                                                Ext.getCmp('bodyUrlEncodedGrid').hide();
                                            }

                                        } else {
                                            Ext.getCmp('body_type').hide();
                                            Ext.getCmp('body_urlencoded_key').hide();
                                            Ext.getCmp('body_urlencoded_value').hide();
                                            Ext.getCmp('addBody_urlencoded').hide();
                                            Ext.getCmp('bodyUrlEncodedGrid').hide();
                                            var rawJsonBody = Ext.getCmp('rawJsonBody');
                                            rawJsonBody.reset();
                                            rawJsonBody.hide();
                                            var gridObj = Ext.getCmp('bodyUrlEncodedGrid');
                                            var gridStore = gridObj.getStore();
                                            gridStore.removeAll();
                                        }
                                        var rootNode = {};
                                        rootNode["expanded"] = "true";
                                        rootNode["children"] = jsonData['editDsn']['jsonkeys']['restTree'];
                                        restDashMainPnl.remove('restTreePnl');
                                        Ext.EventManager.removeAll('restTreePnl');
                                        restDashMainPnl.remove('restfieldmappingpnl');
                                        Ext.EventManager.removeAll('restfieldmappingpnl');
                                        var contArr = new Array();
                                        contArr.push({
                                            xtype: 'treescrollPanel',
                                            rootVisible: false,
                                            flex: 1,
                                            ui: 'newTreePanelWithLines',
                                            id: 'treeP',
                                            store: Ext.create('Ext.data.TreeStore', {
                                                root: rootNode
                                            }),
                                            restTreeNodeData: jsonData['editDsn']['jsonkeys']['restTreeNodeData'],
                                            restTreeNodeFields: jsonData['editDsn']['jsonkeys']['resTreeNodefields'],
                                            listeners: {
                                                afterrender: function() {
                                                    var record = this.getStore().getNodeById(dataFieldParentNode);
                                                    this.getSelectionModel().select(record)
                                                },
                                                select: function(node, record, index, eOpts) {
                                                    var fldsArr = [];
                                                    var saveField = Ext.getCmp('saveFldsBtn');
                                                    var restGridData = jsonData['editDsn']['jsonkeys']['restGrid'][record.raw.jPath];
                                                    var gridCols = restGridData['gridCols'];
                                                    var gridData = restGridData['gridData'];
                                                    var colsArr = [];
                                                    var fields2Store = [];
                                                    var filtersArr = [];
                                                    for (var colVal in gridCols) {
                                                        var colName = gridCols[colVal].toString();
                                                        fields2Store.push({
                                                            name: colName,
                                                            type: 'string'
                                                        });
                                                        colsArr
                                                            .push({
                                                                header: "<span class='newFont_normal11  DsWrapText' style='display:block ;' data-qtip='" + colName + "'><label class='dsCustomCheckBox' style=' margin: -2px 7px 0 0px;display: block;float: left;width:16px' ><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='" + colName + "' ><span class='labelCheckBOx'></span></label>" + colName + "</span>",
                                                                dataIndex: colName,
                                                                sortable: false,
                                                                
                                                                tdCls: 'DsWrapText',
                                                                cls: 'x-grid-checkheader-editor',
                                                                renderer: function(value, metaData, record, row, col, store, gridView) {
																	var value = '<span class="newFont_normal11 DsWrapText" data-qtip="' + value + '">' + value + '</span>';
                                                                    return value;
                                                                }

                                                            });
                                                    }
                                                    var gridObj = Ext.getCmp('restDataGrid');
                                                    gridObj.getStore().removeAll();
                                                    var storeVal1 = Ext.create('Ext.data.Store', {
                                                        fields: fields2Store,
                                                        data: gridData
                                                    });
                                                    gridObj.reconfigure(storeVal1, colsArr);
                                                    gridObj.dataFieldParentNode = record.raw.jPath;
                                                    gridObj.show();
													gridObj.view.refresh();
													Ext.getCmp('dsnConfigCont').hide();
													Ext.getCmp('csvExcelConfigCont').hide();
													Ext.getCmp('containerid').hide();
													
                                                }
                                            }

                                        });
                                        contArr.push({
                                            xtype: 'RESTDataGrid',
                                            flex: 2.35,
                                            padding: 0,
                                            margin: 0,
											cls:'restGridPreview',
                                            id: 'restDataGrid',
                                            hidden: false
                                        });
                                        restDashMainPnl.add(
                                       {
												xtype: 'panel',
                                                title: '<span class="font_bold11" style="text-transform:uppercase;">Data Field Configuration</span>',
                                                autoScroll: true,
                                                layout: {
                                                    type: 'hbox',
													align:'stretch'
                                                },
                                                margin: '0 20 0 20',
                                                id: 'restTreePnl',
                                                ui: 'newTreePanelWithLines hideFolder DsTreePanel',
                                                cls: 'x-tree-arrows',
                                                name: 'restTreePnl',
												flex:1,
												items :	contArr,
												dockedItems: [{
														xtype: 'toolbar',
														dock: 'bottom',
														items: ['->',{
                                                            xtype: 'button',
                                                            id: 'saveFldsBtn',
                                                            name: 'saveFldsBtn',
                                                            margin: '20 0 0 0',
															style:{'border':'none'},
															padding:0,	
                                                            width: 106,
                                                            height: 27,

                                                            text: '<span class="newFont_normal14" style="color:#ffffff;line-height:24px;">Save</span>',
                                                            tooltip: 'click here to Add',
                                                            cls: 'button20 restBgButton',
                                                        },'->']
												}]
													
												} );

                                        if (dataFieldParentNode != null) {
                                            var restGrid = jsonData['editDsn']['jsonkeys'];
                                            if (restGrid.hasOwnProperty('restGrid') && jsonData['editDsn']['jsonkeys']['restGrid'].hasOwnProperty(dataFieldParentNode)) {
                                                var fldsArr = [];
                                                var saveField = Ext.getCmp('saveFldsBtn');
                                                var restGridData = jsonData['editDsn']['jsonkeys']['restGrid'][dataFieldParentNode];
                                                var gridCols = restGridData['gridCols'];
                                                var gridData = restGridData['gridData'];
                                                var colsArr = [];
                                                var fields2Store = [];
                                                var filtersArr = [];
                                                for (var colVal in gridCols) {
                                                    var colName = gridCols[colVal].toString();
                                                    fields2Store.push({
                                                        name: colName,
                                                        type: 'string'
                                                    });
                                                    colsArr
                                                        .push({
                                                            header: "<span class='newFont_normal11  DsWrapText' data-qtip='" + colName + "' style='display:block;'><label class='dsCustomCheckBox' style=' margin: -2px 7px 0 0px;display: block;float: left;width:16px'   ><input id='checkbox' type='checkbox' name='header' class='messageCheckbox' value='" + colName + "' ><span class='labelCheckBOx'></span></label>" + colName + "</span>",
                                                            dataIndex: colName,
                                                            
                                                            sortable: false,
                                                            tdCls: 'DsWrapText',
                                                            cls: 'x-grid-checkheader-editor',
                                                            renderer: function(value, metaData, record, row, col, store, gridView) {
																var value = '<span class="newFont_normal11 DsWrapText" data-qtip="' + value + '">' + value + '</span>';
                                                                return value;
                                                            }

                                                        });
                                                }
                                                var gridObj = Ext.getCmp('restDataGrid');
                                                gridObj.getStore().removeAll();
                                                var storeVal1 = Ext.create('Ext.data.Store', {
                                                    fields: fields2Store,
                                                    data: gridData
                                                });
                                                gridObj.reconfigure(storeVal1, colsArr);
                                                gridObj.dataFieldParentNode = dataFieldParentNode;
                                                gridObj.show();
												 gridObj.view.fireEvent('resize',gridObj.view);
												var restPreviewBtnObj=Ext.getCmp('restPreviewBtnBox').show();

                                                var inputElements = document.getElementsByClassName('messageCheckbox');
                                                var selectedDataFieldsArr = jsonData['editDsn']['selectedDataFields'].split(',');
                                                for (var i = 0; inputElements[i]; ++i) {
                                                    var index = selectedDataFieldsArr.indexOf(inputElements[i].value);
                                                    if (index > -1) {
                                                        inputElements[i].checked = true;
                                                    }
                                                }
                                            }
                                        }
                                        
                                        var rest_output_window = Ext.getCmp('restfieldmappingpnl');
                                        if (!Ext.isEmpty(rest_output_window)) {
                                            rest_output_window.show();
                                        }
                                    } else {}

                                }
                                thisWind.hide();
                            }
                        });
                    }
                }],
                listeners: {
                    'headerclick': function(ct, column, e, t, eOpts) {

                    }
                }
            },
            {
                
                xtype: 'actioncolumn',
                enableColumnHide: false,
                menuDisabled: true,
                renderer: function(value, metaData) {
                    metaData.tdAttr = 'data-qclass=yellowTip data-qtip="' + toolDelete + '"'; 
                    return value;
                },
                width: 55,
                sortable: false,
                items: [{
                    iconCls: 'iconDelete',
                    handler: function(grid, rowIndex, colIndex) {
                        var rec = grid.getStore().getAt(rowIndex);
                        var dsnName = rec.data.datasourcename;
                        var dstFilepath = Ext.getCmp('FILE_0_dstFile').getValue();
                      //  var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
                        var paramsForCSV = 'DSNName=' + encodeURIComponent(dsnName) + '&action=deleteDSN' + '&dstFilepath=' + encodeURIComponent(dstFilepath);
                        Ext.Msg.show({
                            title: myDashboardAlertLbl,
                            msg: 'Are you sure want to delete this data source?',
                            buttons: Ext.Msg.YESNO,
                            width: 300,
                            icon: 'iconConfirmation',
                            fn: function(buttonId) {
                                if (buttonId == "yes") {
                                    Ext.Ajax.request({
                                        url: '/final/servlet/com.eg.RESTIntegrationController',
                                        method: 'POST',
                                        params: paramsForCSV,
                                        scope: this,
                                        success: function(response) {
                                        /*    var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=showMyDashboard&profileName=" + dashboardName;
                                            this.goToPage(viewUrl, 'showMyDashboard');*/
                                        },
                                        failure: function(response) {}
                                    });
                                    grid.store.remove(rec);
                                }
                            }
                        });

                    }
                }],
                listeners: {
                    'headerclick': function(ct, column, e, t, eOpts) {
                        
                    }
                }
            }
        ];
		 this.store= Ext.create('Ext.data.Store', {
        fields: [{
                name: 'datasourcename',
                type: 'string'
            },
            {
                name: 'integrationType',
                type: 'string'
            },
            // {name: 'selected'},
        ],
        data: []
    });
        this.callParent();
    }
    //plugins: [cellEditing],
   
});

function useDataSource(ds) {
    var inputElements = document.getElementsByClassName('myWidgetTableBtn_add');
    var dstFilepath = Ext.getCmp('FILE_0_dstFile').getValue();
    var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
    var widgetId = Ext.getCmp('dsnSettingspopup');
    var dsnName = ds;
    var paramsForRestURL = 'action=useDSN&dashboardName=' + encodeURIComponent(dashboardName) + '&dsnName=' + encodeURIComponent(dsnName);
    Ext.Msg.show({
        title: myDashboardAlertLbl,
        msg: 'Are you sure want to use this data source?',
        buttons: Ext.Msg.YESNO,
        width: 300,
        icon: 'iconConfirmation',
        fn: function(buttonId) {
            if (buttonId == "yes") {
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.RESTIntegrationController',
                    method: 'POST',
                    params: paramsForRestURL,
                    scope: this,
                    success: function(response) {
                        var jsonText = response.responseText;
                        if (jsonText != null && jsonText != '') {
                            var jsonData = Ext.decode(jsonText);
                            var dsnListObj = Ext.getCmp('dsnListGrid_id');
                            var dsnListStore = dsnListObj.getStore();
                            dsnListStore.removeAll();
                            dsnListStore.add(jsonData['dsnOpts']['dsnOptsArr']);
                            var viewUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=showMyDashboard&profileName=" + dashboardName;
                            this.goToPage(viewUrl, 'showMyDashboard');
                        }
                    }
                });
            }
        }
    });
}