Ext.define('MyDashBoard.view.DashBoardLayout', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.dashboardLayout',
	requires:['MyDashBoard.view.DragToolbarItems','utilities.gridstackPanel'],
	border:false,
	frame:false,
	//suspendLayout:true,
	bodyPadding:'0 0 0 0',
	margin:'10px 0px 10px 5px',
	padding: 0,
	cls:'dummyCLASS',
    id: 'dashboardLayoutObj',
    autoScroll: true,
	//scroll:true,
    // manageHeight: true,
	profileName : '',
	mode : 'edit',
	isSharedDashboard : false,
	isOneClickDashboard : false,
	isPredefinedLayout : false,
	isPublishedProfile : "false",
	isHomePage : "false",
	topChartIDMap : {},
    initComponent: function () {
        var me = this;
        this.layout = {
            type: 'fit',
			//manageOverflow:0,
			//reserveScrollbar:true
        };
		me.items = {
			xtype : 'gridstackpanel',
			id : 'gridstackpanelObj',
			name : 'gridstackpanelObj',
			padding:'0px 5px 1px 0px',
			margin:'0px 0px 0px 0px',
			listeners:{
				boxready:function(){
					
					//var isPublishedDashboard=(this.isPublishedProfile!=null && this.isPublishedProfile=='true');
					if(!Ext.isEmpty(me) && (!isPublishedDashboard && !isTvMode && !isMonitorHome && !isComponentDashboard && !isConsolidatedDashboard))
					{
						var isSharedDashboard=me.isSharedDashboard;
						var isAllowedToEditSharedDashboard=false;
						if(publicJson['myDashboardConfigDetails']['isAllowedToEditSharedDashboard']==true)
						{
							isAllowedToEditSharedDashboard=true;
						}
						
						var isOneClick=me.IsOneClickDashboard;
						var dashboarConfigToolsObj=Ext.getCmp('dashboarConfigTools');
						dashboarConfigToolsObj.clearManagedListeners();

						dashboardToolsArr=dashboarConfigToolsObj.items.items;
						var enabledDashSettingsButton=[];
						var isHidePnlSettings=true;
						var disableIcon=false;
						var itemsLen=dashboardToolsArr.length;
						var itmCntr=0;
						for(var p in dashboardToolsArr)
						{
							var pnl=dashboardToolsArr[p];
							isHidePnlSettings=true;
							disableIcon=false;
							itmCntr++;	
							if(pnl!=null && (pnl.hasOwnProperty('buttonId') &&  pnl.buttonId.indexOf('tbsettingseperator')>-1))
							{
								pnl.hide();
								continue;
							}
							if(!isSharedDashboard || (isSharedDashboard && isAllowedToEditSharedDashboard))
							{
								if(isAllowedToEditSharedDashboard)
								{
									if(pnl.buttonId!=null && (pnl.buttonId=='Change Background'))
									{
										pnl.show();
										isHidePnlSettings=false;
									}
								}
								else
								{
									if(pnl.buttonId!=null && (pnl.buttonId=='Modify Dashboard' || pnl.buttonId=='Change Background' || pnl.buttonId=='Clone Dashboard' || pnl.buttonId=='Delete Dashboard'))
									{
										pnl.show();
										isHidePnlSettings=false;
									}
								}
								
								if(pnl.buttonId=='Widgets_Gallery')
								{
									pnl.show();
									isHidePnlSettings=false;
								}
								else if((pnl.buttonId=='AddWidget_New')  || pnl.buttonId=='custom_layouts')
								{
									pnl.show();
									isHidePnlSettings=false;
								}
								else if(pnl.buttonId=='Publish Dashboard' || (itmCntr<itemsLen && pnl.buttonId=='tbsettingseperator'))
								{
									isHidePnlSettings=false;
								}
							}	
							if(pnl.itemId!=null && pnl.itemId=='setAsHomeDashIcon')
							{
								isHidePnlSettings=false;
								if(me.isHomePage!=null && me.isHomePage=="true")
								{
									disableIcon=true;
								}
							}
							if(isHidePnlSettings)
							{
								pnl.hide();
							}
							else
							{
								if(pnl!=null && (pnl.hasOwnProperty('buttonId') &&  pnl.buttonId.indexOf('tbsettingseperator')==-1))
								{
									enabledDashSettingsButton.push(pnl.id);
								}
								pnl.show();
							}
							if(disableIcon)
							{
								pnl.setDisabled(true);
							}
							else{
								pnl.setDisabled(false);
							}
						}
						if(enabledDashSettingsButton!=null && enabledDashSettingsButton.length>0)
						{
							for(var b in enabledDashSettingsButton)
							{
								var dashSet=enabledDashSettingsButton[b];
								var tbSepObj=Ext.getCmp(dashSet+'_tbsettingseperator');
								if(!Ext.isEmpty(tbSepObj))
								{
									tbSepObj.show();
								}
							}
						}
					}
				}
			},
			portlet: function(obj,action,widgetTitle,imgIcon,imgIcon) {
				if ($('#noData')) {
					$('#noData').remove();
				}
				var me = this,
					blockID = obj.id,
					renderToID = obj.id + '_inner',
					width = Ext.get(renderToID).getWidth(),
					height = Ext.get(renderToID).getHeight();


				var showComboValue = false;
				var isConfiguredValue = false;
			
				if(action != null && action == 'addWidget')
				{
					isConfiguredValue = false;
					
					if(blockID.indexOf('ddTable')>-1)
					{
						showComboValue = false;
					}

				}else if(action != null && action == 'loadWidget')
				{
					var configWidgets = [];
					var myDashboardConfigDetails=publicJson['myDashboardConfigDetails'];
					if(myDashboardConfigDetails!=null && myDashboardConfigDetails.hasOwnProperty('configuredWidgetsID'))
					{
						configWidgets=myDashboardConfigDetails['configuredWidgetsID'];
					}
					//configWidgets=publicJson['myDashboardConfigDetails']['configIds'];
					
					if(configWidgets != null)
					{	
						if(configWidgets.indexOf(blockID) > -1)
						{
							isConfiguredValue = true;
							if(blockID.indexOf('ddTable')>-1 )
							{					
								showComboValue = true;
							}
						}else{
							isConfiguredValue = false;
							showComboValue = false;
						}
					}
				
				}
				var isSharedDashboard=false;
				if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('isSharedDashboard'))
				{
					if(publicJson['myDashboardConfigDetails']['isSharedDashboard'] == "true")
						isSharedDashboard=true;
				}
				 var isOneClickDashboard='false';
				 var oneClickDashboard=false;
				if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('IsOneClickDashboard'))
				{
					if(publicJson['myDashboardConfigDetails']['IsOneClickDashboard'] == "yes")
					{
						isOneClickDashboard='true';
						oneClickDashboard=true;
					}
				}

				var portlet = Ext.create('MyDashBoard.view.Portlet', {
					closeAction: 'destroy',
					title: obj.widgetType,
					renderTo: renderToID,
					relationTo: obj.id,
					id: blockID,
					width: width,
					height: height,
					action : action,
					title : widgetTitle,
					isSharedDashboard : isSharedDashboard,
					isSharedDashboardresize : isSharedDashboard,
					showCombo:showComboValue,
					isConfigured: isConfiguredValue,
					isChart : showLegandPanelForWidgetsVal,
					isTopNChart : obj.isTopNWidget,
					createLayoutOnStartup : showLegandPanelForWidgetsVal,
					isLastWidget : obj.isLastWidget,
					widgetDetails:obj,
					isExternalDataSourceWidget : obj.isExternalDataSourceWidget
				});

	

				 if (action != null && action == 'addWidget' && (blockID!=null && blockID.indexOf("Widget_")!=0)) {
					var me = this;
					var widgetBtnArr = new Array();
					widgetBtnArr.push({
						xtype: 'button',
						baseCls: 'configButton',
						action: 'configme',
						flex: 1,
						html: '<div style="text-align:center;cursor:pointer"><span><img class="' + imgIcon + ' "src="/final/images/clear.png" /></span></br><span>' + widgetTitle + '</span></div>',
						handler: function() {
							//myDashApp.getController("Main").fluidWindowModifyClick(this);
							myDashApp.getController("WidgetConfigurationController").openWidgetConfigurationWindow(this,blockID,'addWidget');
							//myDashApp.getController("WidgetConfigurationController").showWidgetOptionsWindow(this,blockID);
						}
					});

					
					if (imgIcon == 'widget_textWidget')
					{
						var widgetTextWidgetCloseBtn	= Ext.create('Ext.container.Container', {
							flex : false,
							width: 0,
							height: 0,
							id: 'TextWidgetClose' + maxBarChartId,
							style: {
								'position': 'relative !important',
								'top': '0px',
								'width': '16px !important',
								'height': '16px !important',
								'right': '5px',
								'background': 'transparent',
								'border': 'none',
								'z-index': 9
							},
							items : [{
								xtype: 'button',
										scale: 'small',
							id: 'close3223223',
							icon: '../images/' + strSkin + '/window_close.png',
							layout: 'hbox',
											flex:false,
											layout : {
								type : 'vbox',
								align : 'stretch',
								pack : 'right'
							},
							style: {
								'position': 'absolute !important',
								'top': '0px',
								'width': '16px !important',
								'height': '16px !important',
								'right': '5px',
								'background': 'transparent',
								'border': 'none'
							},
							listeners: {
								click: function(e) {
									
									Ext.MessageBox.confirm(
										'Confirm', 'Are you sure want to delete ?', callbackFunction);

									function callbackFunction(btn) {
										if (btn == 'yes') {
											var textWidgetCloseBtn = e.up("panel");
											var gridStackObj = myDashApp.getController("Main").getGridstackpanel();
											gridStackObj._removeWidget(textWidgetCloseBtn.id);
										} else {}
									};
								},
								afterrender: function(e) {
									console.log("e===>", e);
								}

							}
						}],
					 
						
					});
					portlet.add(widgetTextWidgetCloseBtn);
					}
					portlet.add(widgetBtnArr);
				}
				return portlet;
			},
			getResizePositions : function(event)
			{
				var profName = me.profileName;
				var isSharedDashboard = me.isSharedDashboard;
				var meGridstackPnl=this;
				if((!isSharedDashboard || isAnonymousUserAccess ||  publicJson['myDashboardConfigDetails']['isAllwoedtoEditSharedDashboard']==true))
				{
					Ext.defer(function(){
                        var cPanlId=event.target.id;						
						if(cPanlId!=null && cPanlId.indexOf("_outer")>-1) // To avoid ID Conflict without outer gridstack widget & ExtJS Panel
						{
							cPanlId=cPanlId.substring(0,cPanlId.indexOf("_outer"));
						}
                       var pnlPositions = meGridstackPnl._serializationStr();
					   var adjWidth=$('#'+cPanlId+'_inner').outerWidth(true);
					   var adjHeight=$('#'+cPanlId+'_inner').outerHeight(true);
                        meGridstackPnl.resizeFn(cPanlId, pnlPositions, adjWidth, adjHeight);
					},200);
				}
			},
			getDragPositions: function()
			{
				var profName = me.profileName;
				var isSharedDashboard = me.isSharedDashboard;
				var meGridstackPnl=this;
				if(!isAnonymousUserAccess && (!isSharedDashboard || publicJson['myDashboardConfigDetails']['isAllwoedtoEditSharedDashboard']==true))
				{
						 Ext.defer(function(){
							   var pnlPositions = meGridstackPnl._serializationStr();
								myDashApp.getController("Main").saveFluidDashboardWindowResizeConfig(profName, pnlPositions);
							},200);
				}
			},
			resizeFn: function(cPanlId, pnlPositions, adjWidth, adjHeight)
			{
				//var me = this;
				// Condition to handle resize the grid inside the rowBody JTM grid
				if(!Ext.isEmpty(insideGrid.Grid)){
					if(insideGrid.Grid.parentGridId == cPanlId){
						Ext.defer(function(){
						insideGrid.Grid.setWidth($('#'+cPanlId+' .x-grid-table').width() - 43);
						},200);
					}
				}
				var blkType = '';
				if (cPanlId != null && cPanlId != "undefined") {
					if (cPanlId.indexOf("_") > 0) {
						blkType = cPanlId.substr(0, cPanlId.indexOf("_"));
					} else {
						blkType = cPanlId;
					}
				}
				var panlObj = Ext.getCmp(cPanlId);
				if(blkType!=null && (blkType=='BarChart' || blkType=='TrendGraph' || blkType=='TimelineChart' || blkType=='CombinedTimelineChart' || blkType=='areaChart' || blkType=='combinationChart' || blkType=='pieChart' || blkType=='activityChart' || blkType=='incidentssummary'))
				{
					if (panlObj!=null && panlObj.isInitialResizeCompleted == false) {
						return;
					}
				}
				panlObj.isWidgetResizeInProgress=false;
				var scrWidVal = (Ext.getBody().getViewSize().width - 40);
				var WidInPxl = (adjWidth / scrWidVal);
				WidInPxl = Ext.util.Format.round(WidInPxl, 2);
				var scrHeightVal = (Ext.getBody().getViewSize().height - 25);
				var heightInPxl = (adjHeight / scrHeightVal);
				heightInPxl = Ext.util.Format.round(heightInPxl, 2);
				switch (blkType) {
					case 'KpiWidget':
						if (panlObj.kpiChartData != null) {
							var kpiData = panlObj.kpiChartData;
							for(var count in kpiData)
							{
								var measDataObj=kpiData[count];
								if(!Ext.isEmpty(measDataObj))
								{
									var chartType = measDataObj.chartType;
									var chartId = measDataObj.chartId;
									var errorMsg = measDataObj['errorMsg'];

									if(errorMsg == "-") 
									{
										var panelWidth =  $('#'+panlObj.id)[0].offsetWidth-40;
										var totalChartsCount = Object.keys(kpiData).length;
										var chartWidth = panelWidth/totalChartsCount;

										if(chartType=='dialChart')
										{
											var chartOuterPnl = Ext.getCmp(cPanlId +'_'+chartId);
											var chartInnerPnlObj = Ext.getCmp(cPanlId +'_'+chartId+'_chart');									
											if (chartInnerPnlObj.highChartObj != null) {

												var chartPnlWidth = chartOuterPnl.getWidth();
												if(chartInnerPnlObj.highChartObj.hasOwnProperty('full_guage') && chartInnerPnlObj.highChartObj.full_guage==true)
												{
													var hCHart = chartInnerPnlObj.highChartObj.highchart.chart;
													var renderTo = hCHart.renderTo;
													var chart = jQuery('#'+renderTo).highcharts();	
														chartOuterPnl.dialHeight=$('#'+panlObj.id)[0].offsetHeight-20;
														chartOuterPnl.dialWidth=$('#'+panlObj.id)[0].offsetWidth-20;
														chart.setSize(
															chartPnlWidth-20,
															$('#'+panlObj.id)[0].offsetHeight-60,
															true
														); 
													chart.redraw();
												}
												else
												{
													var hCHart = chartInnerPnlObj.highChartObj.highchart.chart;
													var renderTo = hCHart.renderTo;
													var chart = jQuery('#'+renderTo).highcharts();	
														chartOuterPnl.dialHeight=$('#'+panlObj.id)[0].offsetHeight-20;
														chartOuterPnl.dialWidth=$('#'+panlObj.id)[0].offsetWidth-20;
														
														chart.setSize(
															chartPnlWidth-20,
															$('#'+panlObj.id)[0].offsetHeight-60,
															true
														); 
														chart.redraw();
												}
											}
											else if(!isHighchartForGauge)
											{

												var chartOuterPnl = Ext.getCmp(cPanlId +'_'+chartId);
												var chartInnerPnlObj = Ext.getCmp(cPanlId +'_'+chartId+'_chart');
								
												var pwidth =chartWidth-20;
												var pheigth = panlObj.getHeight();
												if(pwidth < pheigth)
												{
													pheigth = pwidth-10;
												}
												if(!Ext.isEmpty(chartInnerPnlObj) && chartInnerPnlObj.hasOwnProperty('renderGauge'))
												{													
													chartInnerPnlObj.renderGauge(pwidth,pheigth -50);
												}
												
											}
										}
									}	
								}
							}
							//TODO
							panlObj.refreshData();
							
						}
						break;
					case 'ScatterPlot':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
							if (hCHart.container) {
								hCHart.width = adjWidth;
								hCHart.height = adjHeight;
							}
							hCHart.width = adjWidth;
							var scatterHeightVal =  panlObj.scatterHeight;
							if(adjHeight>scatterHeightVal)
							{
								scatterHeightVal=adjHeight-40;
							}
							hCHart.height = adjHeight- 45;
							hCHart.width = adjWidth-30;
							panlObj.scatterHeight=adjHeight- 45;
							panlObj.highChartObj.drawChart();
						}
						break;
					case 'incidentssummary' :
					if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
							if (hCHart.container) {
								hCHart.width = adjWidth;
								hCHart.height = adjHeight;
							}
							hCHart.width = adjWidth;
								
							hCHart.width = adjWidth-15;
							//hCHart.width = adjWidth-53;
							hCHart.height = adjHeight - 55;
							//hCHart.height = adjHeight - 35;
								
							panlObj.highChartObj.drawChart();
						}
						break;
					case 'dialChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
							if(panlObj.highChartObj.hasOwnProperty('full_guage') && panlObj.highChartObj.full_guage==true)
							{
								//var newVal='<div style="text-align:center;padding-top:10px"><span style="font-weight:bold;font-family:LucidaGrandeRegular;font-size:15px;color:#ddcc2f;cursor:pointer">888</span></div>" ';
								var chart = jQuery('#'+renderTo).highcharts();		
								Ext.defer(function(){												
									panlObj.dialHeight=$('#'+panlObj.id)[0].offsetHeight-40;
									panlObj.dialWidth=$('#'+panlObj.id)[0].offsetWidth-35;
									chart.setSize(
										$('#'+panlObj.id)[0].offsetWidth-35, 
										$('#'+panlObj.id)[0].offsetHeight-40,
										true
									); 
								},200);
							}
							else
							{
								if (hCHart.container) {
									hCHart.width = adjWidth - 10;
									hCHart.height = adjHeight - 20;
								}
								hCHart.width = adjWidth - 200;
								hCHart.height = adjHeight - 20;
								Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 10);
								Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 10);
								Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 10);
								Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 10);
								var chart = jQuery('#'+renderTo).highcharts();
								Ext.defer(function(){
									panlObj.dialHeight=$('#'+panlObj.id)[0].offsetHeight-20;
									panlObj.dialWidth=$('#'+panlObj.id)[0].offsetWidth-20;
									chart.setSize(
										$('#'+panlObj.id)[0].offsetWidth-20, 
										$('#'+panlObj.id)[0].offsetHeight-20,
										true
									); 
								},200);
							}
						}
						else if(!isHighchartForGauge)
						{
								Ext.defer(function(){
									var pwidth = panlObj.getWidth();
									var pheigth = panlObj.getHeight() - 35;
									if(pwidth < pheigth)
									{
										pheigth = pwidth-10;
									}
									if(!Ext.isEmpty(panlObj.items.items[0]) && panlObj.items.items[0].hasOwnProperty('renderGauge'))
									{
										panlObj.items.items[0].renderGauge(pwidth,pheigth);
									}
								},200);
						}
						break;
					case 'TopNGaugeChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery('#'+renderTo).outerWidth();
							var height = jQuery('#'+renderTo).outerHeight();
							if(panlObj.highChartObj.hasOwnProperty('full_guage') && panlObj.highChartObj.full_guage==true)
							{
								var chart = jQuery('#'+renderTo).highcharts();
								Ext.defer(function(){
									panlObj.dialHeight=$('#'+panlObj.id)[0].offsetHeight-40;
									panlObj.dialWidth=$('#'+panlObj.id)[0].offsetWidth-35;
									chart.setSize(
										$('#'+panlObj.id)[0].offsetWidth-35, 
										$('#'+panlObj.id)[0].offsetHeight-40,
										true
									); 
								},200);
							}
							else
							{
								if (hCHart.container) {
									hCHart.width = adjWidth - 20;
									hCHart.height = adjHeight - 20;
								}
								var chart = jQuery('#'+renderTo).highcharts();
								Ext.defer(function(){
									panlObj.dialHeight=$('#'+panlObj.id)[0].offsetHeight-20;
									panlObj.dialWidth=$('#'+panlObj.id)[0].offsetWidth-20;
									chart.setSize(
										$('#'+panlObj.id)[0].offsetWidth-20, 
										$('#'+panlObj.id)[0].offsetHeight-20,
										true
									); 
								},200);
							}
						}
						else if(!isHighchartForGauge)
						{
								Ext.defer(function(){
									var pwidth = panlObj.getWidth();
									var chartObj = Ext.getCmp(cPanlId+ '_chart');
									var pheigth = panlObj.getHeight()-70;
									pwidth=pwidth-20;
									if(pwidth < pheigth)
									{
										pheigth = pwidth-10;
									}
																		
									if(!Ext.isEmpty(chartObj) && !Ext.isEmpty(document.getElementById(cPanlId+"_Gauge")))
									{
										chartObj.renderGauge(pwidth,pheigth);
									}
								},200);
						}
						break;
					case 'BarChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
							if (hCHart.container) {
								hCHart.width = adjWidth;
								hCHart.height = adjHeight;
							}
							hCHart.width = adjWidth;
							if(panlObj.isTopNChart)
							{
								if(panlObj.chartType == 'column')
								{
									//hCHart.height = adjHeight - 30;
									hCHart.height = adjHeight - 55;
									
								}else{
									var barHeightVal =  panlObj.barHeight;
									if(adjHeight>barHeightVal)
									{
										//barHeightVal=adjHeight-30;
										barHeightVal=adjHeight-50;
									}
									hCHart.height = barHeightVal;
									//hCHart.height = barHeightVal-25;
									//hCHart.height = adjHeight - 40;
									//hCHart.width = adjWidth-25;
									hCHart.width = adjWidth-54;
								}
							}
							else
							{
								if(panlObj.chartType == 'column')
								{
									hCHart.width = adjWidth-15;
									//hCHart.width = adjWidth-53;
									hCHart.height = adjHeight - 55;
									//hCHart.height = adjHeight - 35;
								}else{
									var barHeightVal =  panlObj.barHeight;
									if(adjHeight>barHeightVal)
									{
										barHeightVal=adjHeight-30;
									}
									hCHart.height = barHeightVal- 25;
									//hCHart.width = adjWidth-25;
									hCHart.width = adjWidth-30;
								}
							}
							//console.log("Gridster_adjHeight",adjHeight)
							//Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight);
							//Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight);
							//Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight);
							//Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight);
							panlObj.highChartObj.drawChart();
							//panlObj.doComponentLayout();
						}
						break;
					case 'ddTable':
						if (panlObj.highChartObj != null) {
								
							if(panlObj.chartType == 'Time Line' || panlObj.chartType == 'Area')
							{
								var hCHart = panlObj.highChartObj.highchart.chart;
								var renderTo = hCHart.renderTo;
								var width = jQuery(renderTo).outerWidth();
								var height = jQuery(renderTo).outerHeight();
								hCHart.width = adjWidth-15;
							
								if(panlObj.isCurrentValAvail)
								{
									Ext.defer(function(){
										myDashApp.getController("Main").loadSummaryDetailsForDD(panlObj.id,panlObj,panlObj.chartData,panlObj.hideLegend,false);
										var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ cPanlId).getHeight();
										hCHart.height = ChartPnlHeight;
										panlObj.highChartObj.drawChart();
									},200);
								}else{
									panlObj.highChartObj.drawChart();
								}
								hCHart.width = adjWidth-15;
							}
							else if (panlObj.chartType == 'Bar Chart')
							{
								var hCHart = panlObj.highChartObj.highchart.chart;
								var renderTo = hCHart.renderTo;
								var width = jQuery(renderTo).outerWidth();
								var height = jQuery(renderTo).outerHeight();
								if (hCHart.container) {
									hCHart.width = adjWidth;
									hCHart.height = adjHeight;
								}
								hCHart.width = adjWidth;
								
								if(panlObj.isTopNChart)
								{
									if(panlObj.viewType == 'column')
									{
										hCHart.height = adjHeight - 55;
										
									}else{
										var barHeightVal =  panlObj.barHeight;
										if(adjHeight>barHeightVal)
										{
											barHeightVal=adjHeight-50;
										}
										
										hCHart.height = barHeightVal;
										hCHart.width = adjWidth-54;
									}
								}
								else
								{
									if(panlObj.viewType == 'column')
									{
										hCHart.width = adjWidth-70;
										hCHart.height = adjHeight-75;

									}else{
										var barHeightVal =  panlObj.barHeight;
										if(adjHeight>barHeightVal)
										{
											barHeightVal=adjHeight-30;
										}
										hCHart.height = barHeightVal-35;
										hCHart.width = adjWidth-60;
									}
								}
								panlObj.highChartObj.drawChart();
							}
						}
						else
						{
							if(panlObj.chartType == 'Table')
							{
								isResize = true;
								var grid = Ext.getCmp(cPanlId+'_Grid');
								if(!Ext.isEmpty(grid))
								{
									var heightOfOneRow = 21;
									var heightForTable = (adjHeight / heightOfOneRow);
									var strHeightForTable = heightForTable.toString();
									var gSize ='';

									if(strHeightForTable.indexOf('.')>-1)
									{
										 gSize = strHeightForTable.split('.')[0];
									}else{
										gSize = heightForTable;

									}
									gSize = parseInt(gSize);
									grid.getStore().pageSize = gSize;
									grid.store.load();
									grid.getView().refresh();
								}
							}
						}
						break;
					case 'TimelineChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
						//	if (hCHart.container) {
								hCHart.width = adjWidth;
								//hCHart.height = adjHeight-25;
								if(panlObj.isCurrentValAvail)
								{
									Ext.defer(function(){
										myDashApp.getController("Main").loadSummaryDetails(panlObj.id,panlObj,panlObj.chartData,panlObj.hideLegend);
										var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ cPanlId).getHeight();
										hCHart.height = ChartPnlHeight;
										panlObj.highChartObj.drawChart();
									},200);
								}else{
							//	hCHart.height = adjHeight-25;
									panlObj.highChartObj.drawChart();
								}
						//	}
							hCHart.width = adjWidth;
						/*	Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 70);*/
							//panlObj.highChartObj.drawChart();
						}
						break;
					case 'TrendGraph':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
						//	if (hCHart.container) {
								hCHart.width = adjWidth;
								//hCHart.height = adjHeight-25;
								if(panlObj.isCurrentValAvail)
								{
									Ext.defer(function(){
										myDashApp.getController("Main").loadSummaryDetails(panlObj.id,panlObj,panlObj.chartData,panlObj.hideLegend);
										var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ cPanlId).getHeight();
										hCHart.height = ChartPnlHeight;
										panlObj.highChartObj.drawChart();
									},200);
								}else{
								//	hCHart.height = adjHeight-25;
									panlObj.highChartObj.drawChart();
								}
						//	}
							hCHart.width = adjWidth;
						/*	Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 70);*/
							//panlObj.highChartObj.drawChart();
						}
						break;
					case 'areaChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
						//	if (hCHart.container) {
								hCHart.width = adjWidth-15;
								//hCHart.height = adjHeight-25;
								if(panlObj.isCurrentValAvail)
								{
									Ext.defer(function(){
										myDashApp.getController("Main").loadSummaryDetails(panlObj.id,panlObj,panlObj.chartData,panlObj.hideLegend);
										var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ cPanlId).getHeight();
										hCHart.height = ChartPnlHeight;
										panlObj.highChartObj.drawChart();
									},200);
									//hCHart.height = adjHeight-75;
								}else{
							//	hCHart.height = adjHeight-35;
									panlObj.highChartObj.drawChart();
								}
						//	}
						//	hCHart.width = adjWidth;
							//hCHart.height = adjHeight;
						/*	Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 70);*/
							//panlObj.highChartObj.drawChart();
						}
						break;
					case 'combinationChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
						//	if (hCHart.container) {
								hCHart.width = adjWidth;
								//hCHart.height = adjHeight-25;
								if(panlObj.isCurrentValAvail)
								{
									//hCHart.height = adjHeight-75;
									Ext.defer(function(){
										myDashApp.getController("Main").loadSummaryDetails(panlObj.id,panlObj,panlObj.chartData,panlObj.hideLegend);
										var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ cPanlId).getHeight();
										hCHart.height = ChartPnlHeight;
										panlObj.highChartObj.drawChart();
									},200);
								}else{
								//hCHart.height = adjHeight-25;
									panlObj.highChartObj.drawChart();
								}
						//	}
						//	hCHart.width = adjWidth;
			/*					Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 70);
							Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 70);*/
							
						}
						break;
					case 'CombinedTimelineChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
							if (hCHart.container) {
								hCHart.width = adjWidth;
								hCHart.height = adjHeight;
							}
							//hCHart.width = adjWidth
							hCHart.width = adjWidth-15;
							//hCHart.height = adjHeight - 30;
							hCHart.height = adjHeight - 35;
							Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight);
							Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight);
							Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight);
							Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight);
							panlObj.highChartObj.drawChart();
						}
						break;
					case 'pieChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
							var ChartPnlWidth = Ext.getCmp('ChartPnl_'+ cPanlId).getWidth();
							if (hCHart.container) {
								//hCHart.width = adjWidth;
								hCHart.width = ChartPnlWidth;
								hCHart.height = adjHeight;
							}
							//hCHart.width = adjWidth;
							hCHart.width = ChartPnlWidth;
							//hCHart.height = adjHeight - 30;
							hCHart.height = adjHeight - 38;	
							Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight);
							Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight);
							Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight);
							Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight);
							panlObj.highChartObj.drawChart();
						}
						break;
					case 'activityChart':
						if (panlObj.highChartObj != null) {
							var hCHart = panlObj.highChartObj;
								Ext.defer(function(){
									getChartForActivityChart('ChartPnl_'+panlObj.id, $('#'+panlObj.id)[0].offsetHeight-20,$('#'+panlObj.id)[0].offsetWidth-20,panlObj.activeData);
								},200);
							}
						break;
					case 'servicehealth':
						if (panlObj.highChartObj != null) {
						Ext.defer(function(){

							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;

							var width=Ext.getCmp(panlObj.id+'healthPieChartDiv').getWidth();
							var height=Ext.getCmp(panlObj.id+'healthPieChartDiv').getHeight();
							if (hCHart.container) {
								hCHart.width = adjWidth;
								hCHart.height = adjHeight;
							}
							hCHart.width = adjWidth;
							if(panlObj.hasOwnProperty('isInfraHealth') && panlObj.isInfraHealth==true)
							{
								var width=Ext.getCmp(panlObj.id+'healthPieChartDiv').getWidth();
								var height=Ext.getCmp(panlObj.id+'healthPieChartDiv').getHeight();

								hCHart.height = height;
								hCHart.width = width;
							}
							else
							{
								hCHart.height = adjHeight-30;
							}
							panlObj.highChartObj.drawChart();
							},200);
						}
						break;
						case 'networkhealth':
						if (panlObj.highChartObj != null) {
							Ext.defer(function(){
							var hCHart = panlObj.highChartObj.highchart.chart;
							var renderTo = hCHart.renderTo;
							var width = jQuery(renderTo).outerWidth();
							var height = jQuery(renderTo).outerHeight();
							/*if (hCHart.container) {
								hCHart.width = adjWidth;
								hCHart.height = adjHeight;
							}*/
							//hCHart.width = adjWidth-140;
							//hCHart.height = adjHeight - 20;
							hCHart.width = adjWidth;
							if(panlObj.hasOwnProperty('isnetworkHealth') && panlObj.isnetworkHealth==true)
							{
								adjHeight=(adjHeight/2)-5;
								adjWidth=(adjWidth/2)-5;
								hCHart.height = adjHeight;
								hCHart.width = adjWidth;
								//adjHeight=adjHeight-40;
							}
						//	Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight);
						//	Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight);
						//	Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight);
						//	Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight);
							
							panlObj.highChartObj.drawChart();
							},500);
						}
						break;
						case 'table':
							isResize = true;
							var grid = Ext.getCmp(cPanlId+'_Grid');
							if(!Ext.isEmpty(grid))
							{
								grid.store.filters.clear();
								var searchTextBoxObj=Ext.getCmp('searchTable_'+cPanlId);
								
								if(searchTextBoxObj != null)
								{
									searchTextBoxObj.disable();
									var searchValue = searchTextBoxObj.value ;
									if(searchValue != '')
									{
										searchTextBoxObj.reset();	
									}
								}
								var heightOfOneRow = 21;
								var heightForTable = (adjHeight / heightOfOneRow);
								var strHeightForTable = heightForTable.toString();
								var gSize ='';

								if(strHeightForTable.indexOf('.')>-1)
								{
									 gSize = strHeightForTable.split('.')[0];
								}else{
									gSize = heightForTable;

								}
								gSize = parseInt(gSize);
								grid.getStore().pageSize = gSize;
								grid.store.load();
								grid.getView().refresh();
							}
						break;
						/*case 'ddTable':
							isResize = true;
							var grid = Ext.getCmp(cPanlId+'_Grid');
							if(!Ext.isEmpty(grid))
							{
								var heightOfOneRow = 21;
								var heightForTable = (adjHeight / heightOfOneRow);
								var strHeightForTable = heightForTable.toString();
								var gSize ='';

								if(strHeightForTable.indexOf('.')>-1)
								{
									 gSize = strHeightForTable.split('.')[0];
								}else{
									gSize = heightForTable;

								}
								gSize = parseInt(gSize);
								grid.getStore().pageSize = gSize;
								grid.store.load();
								grid.getView().refresh();
							}
						break;*/
						case 'mapwidget':
							isResize = true;
							var profileName = Ext.getCmp('dashboardLayoutObj').profileName;	
							myDashApp.getController("Main").loadDataForBlock(panlObj, profileName, cPanlId,false);
							break;
						
						case 'proactivealerts':
							if (panlObj.highChartObj != null) {
								Ext.defer(function(){
									var hCHart = panlObj.highChartObj.highchart.chart;
									var renderTo = hCHart.renderTo;
									var width = jQuery(renderTo).outerWidth();
									var height = jQuery(renderTo).outerHeight();
									var ChartPnlWidth = Ext.getCmp('proActiveChart-'+ cPanlId).getWidth();
									if (hCHart.container) {
										hCHart.width = ChartPnlWidth;
										hCHart.height = adjHeight;
									}
									ChartPnlWidth = ChartPnlWidth;
									hCHart.width = ChartPnlWidth;						

									var chartHeightValue = adjHeight - 110; 
									hCHart.height = chartHeightValue;

									
									panlObj.highChartObj.drawChart();
								},200);
							}
						break;
						case 'currentalarms':
							if (panlObj.isPaginationNeeded)
							{	
								isResize = true;
								var grid = Ext.getCmp('CurrentAlarms_Grid');
								if(!Ext.isEmpty(grid))
								{
									var configPanlHeight = panlObj.getHeight()-125;
									if (panlObj.alarmSummaryEnabled)
									{	
										configPanlHeight = configPanlHeight/2;
									}
									grid.store.filters.clear();
									var heightOfOneRow = 21;
									var heightForTable = (adjHeight / heightOfOneRow);
									var strHeightForTable = heightForTable.toString();
									var gSize ='';

									if(strHeightForTable.indexOf('.')>-1)
									{
										 gSize = strHeightForTable.split('.')[0];
									}else{
										gSize = heightForTable;

									}
									gSize = parseInt(gSize);
									grid.getStore().pageSize = gSize;
									grid.store.load();

									grid.getView().emptyText = '<div style="height:'+configPanlHeight+'px;"><table width="100%" height="100%" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><div styel="margin:10px auto">'+noAlarmFoundMsg+'</div></td></tr></table></div>';
									grid.getView().refresh();
								}
							}
						break;
					delete elementObj1;
				}
				var profName = me.profileName;
				var isSharedDashboard = me.isSharedDashboard;
				if(!isAnonymousUserAccess && (!isSharedDashboard || publicJson['myDashboardConfigDetails']['isAllwoedtoEditSharedDashboard']==true))
				{
					myDashApp.getController("Main").saveFluidDashboardWindowResizeConfig(profName, pnlPositions);
				}
			}
	
		}
		
		this.callParent();
	},
	listeners : {
		'afterrender' : function(dashboardLayoutObj)
		{
			var myDashMainPanelObj = Ext.getCmp('myDashMainPanel');
			if(!isTvMode)
			{
				myDashMainPanelObj.header.clearManagedListeners();
			}
				
			/*	if((!isPublishedDashboard && !isMonitorHome && !isComponentDashboard && !isConsolidatedDashboard) && (isSharedDashboard==false || isAllowedToEditSharedDashboard))
				{
					var isOneClick=dashboardLayoutObj.IsOneClickDashboard;
					if(myDashMainPanelObj.header){
						var dashboarConfigToolsObj=Ext.getCmp('dashboarConfigTools');
						dashboarConfigToolsObj.clearManagedListeners();

						dashboardToolsArr=dashboarConfigToolsObj.items.items;
						var isHidePnlSettings=true;
						var disableIcon=false;
						for(var p in dashboardToolsArr)
						{
							var pnl=dashboardToolsArr[p];
							isHidePnlSettings=true;
							disableIcon=false;
							if(isSharedDashboard && isAllowedToEditSharedDashboard)
							{
								if(pnl.buttonId!=null && (pnl.buttonId=='Modify Dashboard' || pnl.buttonId=='Clone Dashboard' || pnl.buttonId=='Delete Dashboard'))
								{
									pnl.hide();
									continue;
								}
							}
							if(isOneClick)
							{								
								
									if(pnl.buttonId=='Publish Dashboard')
									{
										if(dashboardLayoutObj.isPublishedProfile=="true")
										{
											isHidePnlSettings=false;
										//	disableIcon=true;
										}
									}
									else if(pnl.itemId!=null && pnl.itemId=='setAsHomeDashIcon')
									{
										if(dashboardLayoutObj.isHomePage!=null && dashboardLayoutObj.isHomePage=="true")
										{
											isHidePnlSettings=false;
											disableIcon=true;
										}
									}
								//}
							}
							else
							{
								//console.log("pnl.buttonId ",pnl.buttonId);
								
									//console.log("pnl.buttonId ",pnl.buttonId);
									if(pnl.buttonId=='Publish Dashboard')
									{
										
										if(dashboardLayoutObj.isPublishedProfile=="true")
										{
											isHidePnlSettings=false;
										//	disableIcon=true;
										}
									}
									else if(pnl.itemId!=null && pnl.itemId=='setAsHomeDashIcon')
									{
										if(dashboardLayoutObj.isHomePage!=null && dashboardLayoutObj.isHomePage=="true")
										{
											isHidePnlSettings=false;
											disableIcon=true;
										}
									}
							//	}
							}
							if(isHidePnlSettings)
							{
								pnl.hide();
							}
							else
							{
								pnl.show();
							}
							if(disableIcon)
							{
								pnl.setDisabled(true);
							}
							else{
								pnl.setDisabled(false);
							}
						}
						myDashMainPanelObj.header.mon(myDashMainPanelObj.header.el,'mouseenter',function(){
						
							for(var p in dashboardToolsArr)
							{
								var pnl=dashboardToolsArr[p];
								if(isSharedDashboard && isAllowedToEditSharedDashboard)
								{
									if(pnl.buttonId!=null && (pnl.buttonId=='Modify Dashboard' || pnl.buttonId=='Clone Dashboard' || pnl.buttonId=='Delete Dashboard'))
									{
										pnl.hide();
										continue;
									}
								}
								if(isOneClick)
								{
									if(pnl.itemId!=null)
									{
										if(pnl.itemId=='GraphicalWidgetGallery')
										{
											pnl.hide();
										}
										else
										{
										
											pnl.show(true);
										}
									}
									else
									{
										
										pnl.show(true);
									}
								}
								else
								{
								
									pnl.show();
									
								}
							}
						},myDashMainPanelObj.header);
						var isHidePnlSettings1=true;
						myDashMainPanelObj.header.mon(myDashMainPanelObj.header.el,'mouseleave',function(){
							for(var p in dashboardToolsArr)
							{
								var pnl=dashboardToolsArr[p];
								isHidePnlSettings1=true;
								if(isSharedDashboard && isAllowedToEditSharedDashboard)
								{
									if(pnl.buttonId!=null && (pnl.buttonId=='Modify Dashboard' || pnl.buttonId=='Clone Dashboard' || pnl.buttonId=='Delete Dashboard'))
									{
										pnl.hide();
										continue;
									}
								}
								if(isOneClick)
								{								
								
										if(pnl.buttonId=='Publish Dashboard')
										{
											if(dashboardLayoutObj.isPublishedProfile=="true")
												isHidePnlSettings1=false;
										}
										else if(pnl.itemId!=null && pnl.itemId=='setAsHomeDashIcon')
										{
											if(dashboardLayoutObj.isHomePage=="true")
												isHidePnlSettings1=false;
										}
									//}
								}
								else
								{
								
										if(pnl.buttonId=='Publish Dashboard')
										{
										//	console.log("dashboardLayoutObj.isPublishedProfile ",dashboardLayoutObj.isPublishedProfile);
											if(dashboardLayoutObj.isPublishedProfile=="true")
												isHidePnlSettings1=false;
										}
										else if(pnl.itemId!=null && pnl.itemId=='setAsHomeDashIcon')
										{
											if(dashboardLayoutObj.isHomePage=="true")
												isHidePnlSettings1=false;
										}
								//	}
								}
								if(isHidePnlSettings1)
								{
									pnl.hide();
								}
							}
						},myDashMainPanelObj.header);
						dashboarConfigToolsObj.doComponentLayout();
						dashboarConfigToolsObj=null;
						delete dashboarConfigToolsObj;
						myDashMainPanelObj=null;
						delete myDashMainPanelObj;
					}
					
				}
				else if(!isPublishedDashboard && !isMonitorHome && !isComponentDashboard && !isConsolidatedDashboard)
				{
					var dashboarConfigToolsObj=Ext.getCmp('dashboarConfigTools');
					dashboarConfigToolsObj.clearManagedListeners();

					dashboardToolsArr=dashboarConfigToolsObj.items.items;
					var isHidePnlSettings=true;
					for(var p in dashboardToolsArr)
					{
						var pnl=dashboardToolsArr[p];
						isHidePnlSettings=true;

						if(pnl.itemId!=null && pnl.itemId=='setAsHomeDashIcon')
						{
							if(dashboardLayoutObj.isHomePage!=null && dashboardLayoutObj.isHomePage=="true")
							{
								isHidePnlSettings=true;
							}
							else
							{
								isHidePnlSettings=false;
							}
						}
						
						if(isHidePnlSettings)
						{
							pnl.hide();
						}
						else
						{
							pnl.show();
						}
					}
				}
			}*/
		}
	}
	
});