// Private Toolbar for MydashBoard
Ext.define('MyDashBoard.view.DashBoardTools', {
    extend: 'Ext.toolbar.Toolbar',
    alias: 'widget.dashboardtools',
	id: 'dashSettingsToolbarObj',
	selectedListPageOption : showDashboardListInGridView?'gridlistview':'tilesview',
    items: [
	{
		xtype: 'button',
		margin: '0 5 0 0',
		padding: 0,
		cls: '',
		id: 'addDashboard',
        buttonId: 'addDashboard',
		width: 26,
		overCls: 'btn-transparent',
		pressedCls: '',
		height: 26,
		scale : 'large',
		style: {
                    background: 'none',
                    border: '0px'
                },
		icon: '../images/'+strSkin+'/addButton.png', 
		listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: addDashLbl
								});
							}
						},
						action:'addNew'
	},	
	{	
		xtype: 'tbseparator',
		id:'tabseperator'
	},
	{
		xtype: 'container',
		margin: '0 5px 0 5px',
		itemId: 'homeBtnContainer',
		cls: 'iconBg',
		//disabled: true,
		items: [{
			xtype: 'button',
			iconCls: 'dashboardHomeNew',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: homeTooltipLbl
					});
				}
			},
			//tooltip: homeTooltipLbl,
			id: 'homeBtn',
			style: {
				background: 'none',
				border: '0px'
			}
		}]
	},

	{
		xtype: 'button',
		id:'otherUsersDashListView',
		margin:0,
		padding:0,
		cls:'iconOtherUsersDashListView',
		style:{'border':'0px !important'},
		hidden:hideShowOtherUsersDBList,
		listeners: {
			'afterrender':function(){
				if(!Ext.isEmpty(listViewMode) && listViewMode=='otherUsersDashListView')
				{
					//this.up('toolbar').selectedListPageOption='otherUsersDashListView';
				}
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: screenLabelsObj['usersDBtooltip']
				});
			},
			click: function (btn) {
				//this.up('toolbar').selectedListPageOption='otherUsersDashListView';
				var listPageUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=loadOtherUsersMyDashboardListPage&listViewMode=otherUsersDashListView";
				myDashApp.getController("Main").goToPage(listPageUrl, 'loadOtherUsersMyDashboardListPage');
				
				btn.removeCls('iconOtherUsersDashListView');
				btn.addCls('iconOtherUsersDashListViewSelect');
				Ext.getCmp('GridViewButId').removeCls('iconCompGridviewSelect');
				Ext.getCmp('GridViewButId').addCls('iconCompGridview');
				Ext.getCmp('listViewButId').removeCls('iconCompListviewSelectNew');
				Ext.getCmp('listViewButId').addCls('iconCompListviewNew');
			}
		}
	},

	/*----------------------*/
	{
		xtype: 'button',
		id:'listViewButId',
		cls:'iconCompListviewSelectNew',
		margin:'0 5 0 0',
		padding:0,
		style:{'border':'0px !important'},
		listeners: {
			'afterrender':function(){
				if(!Ext.isEmpty(listViewMode) && listViewMode=='tilesview')
				{
					this.up('toolbar').selectedListPageOption='tilesview';
				}
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'List View'
				});
			},
			click: function (btn) {
				Ext.getCmp('custom_layouts').defaultState();
				this.up('toolbar').selectedListPageOption='tilesview';
				var listPageUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=loadMyDashboardListPage&listViewMode=tilesview";
				myDashApp.getController("Main").goToPage(listPageUrl, 'loadMyDashboardListPage');
				btn.removeCls('iconCompListviewNew');
				btn.addCls('iconCompListviewSelectNew');
				Ext.getCmp('GridViewButId').removeCls('iconCompGridviewSelect');
				Ext.getCmp('GridViewButId').addCls('iconCompGridview');


				Ext.getCmp('otherUsersDashListView').removeCls('iconOtherUsersDashListViewSelect');
				Ext.getCmp('otherUsersDashListView').addCls('iconOtherUsersDashListView');
			}
		}
	},
	{
		xtype: 'button',
		id:'GridViewButId',
		margin:'0 0 0 0',
		cls:'iconCompGridview',
		style:{'border':'0px !important'},
		listeners: {
			'afterrender':function(){
				if(!Ext.isEmpty(listViewMode) && listViewMode=='gridlistview')
				{
					this.up('toolbar').selectedListPageOption='gridlistview';
					this.removeCls('iconCompGridview');
					this.addCls('iconCompGridviewSelect');
					Ext.getCmp('listViewButId').removeCls('iconCompListviewSelectNew');
					Ext.getCmp('listViewButId').addCls('iconCompListviewNew');
				}
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: screenLabelsObj['gridlisttooltip']
				});
			},
			click: function (btn) {
				Ext.getCmp('custom_layouts').defaultState();
				this.up('toolbar').selectedListPageOption='gridlistview';
				var listPageUrl = "/final/servlet/com.eg.EgMonitorRequestDispatcher?comesFrom=myDashboard&action=loadMyDashboardListPage&listViewMode=gridlistview";
				myDashApp.getController("Main").goToPage(listPageUrl, 'loadMyDashboardListPage');
				btn.removeCls('iconCompGridview');
				btn.addCls('iconCompGridviewSelect');
				Ext.getCmp('listViewButId').removeCls('iconCompListviewSelectNew');
				Ext.getCmp('listViewButId').addCls('iconCompListviewNew');

				Ext.getCmp('otherUsersDashListView').removeCls('iconOtherUsersDashListViewSelect');
				Ext.getCmp('otherUsersDashListView').addCls('iconOtherUsersDashListView');
			}
		}
	},
	/*----------------------*/

	//{xtype: 'tbseparator'},
	{
		xtype: 'container',
		margin: '0 5px 0 0px',
		itemId: 'listBtnContainer',
		cls: 'iconBg',
		//disabled: true,
		items: [{
			xtype: 'button',
			iconCls: 'dashboardListNew',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: screenLabelsObj['tilelisttooltip']
					});
				}
			},
			//tooltip: homeTooltipLbl,
			id: 'listBtn',
			style: {
				background: 'none',
				border: '0px'
			}
		}]
	},
	//{xtype: 'tbseparator'}, 
	{
		xtype: 'container',
		margin: '0 5px 0 0px',
		itemId: 'viewBtnContainer',
		cls: 'iconBg',
		hidden : true,
		//disabled: true,
		items: [{
			xtype: 'button',
			iconCls: 'dashboard_view',
			id: 'viewbt',
			//tooltip: viewLbl,               
			style: {
				background: 'none',
				border: '0px'
			}
		}]
	}, //{xtype: 'tbseparator'}, 
	{
		xtype: 'container',
	   margin: '0 0px 0 0px',
		id: 'help',
		hidden : disableMydashboardPopout,
		//cls: 'iconBg',
		items: [{
			xtype: 'button',
			//html:'<a href="javascript:void(0)" class="indexTopLink"><div class="iconHelpIndex" style="float:left"></div></a>',
			iconCls: 'dashboard_help',              
			style: {
				background: 'none',
				border: '0px'
			},
			listeners: {
				'click': function () {
					HelpWin();
				},
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: helpTooltip
					});
				}
			}
		}]
	},
	{
		xtype: 'container',
	   margin: '0 0px 0 0px',
		id: 'popOutBtn',
		hidden : true,
		//cls: 'iconBg',
		items: [{
			xtype: 'button',
			//html:'<a href="javascript:void(0)" class="indexTopLink"><div class="iconHelpIndex" style="float:left"></div></a>',
			iconCls: 'dashboardFullscreenNew',              
			style: {
				background: 'none',
				border: '0px'
			},
			listeners: {
				'click': function () {

					var defaultAction = publicJson['action'];
					if (defaultAction != null && defaultAction == 'showMyDashboard'){
					   var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
					   var viewUrl = "/final/monitor/MyDashboard.jsp?isNewWindow=true&comesFrom=myDashboard&action=showMyDashboard&profileName="
							+ encodeURIComponent(profileName);
					   openNewView(viewUrl);
					}
					/*else if (defaultAction != null && defaultAction == "loadMyDashboardConfig") {
						var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
						var viewUrl = "/final/monitor/MyDashboard.jsp?isNewWindow=true&comesFrom=myDashboard&action=loadMyDashboardConfig&profileName=" + encodeURIComponent(profileName);
						 openNewView(viewUrl);
					}*/
				},
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: popoutTooltip
					});
				}
			}
		}]
	}
    ]
});