Ext.define('MyDashBoard.view.DashboardGeneralSettings', {
    extend: 'Ext.container.Container',
    alias: 'widget.dashboardgeneralsettings',
	requires: ['Ext.ux.CustomSpinner', 'utilities.CustomRadio','MyDashBoard.view.PreDefinedLayouts'],
    bodyStyle: {
        'background': 'none'
    },
	//ui:'chart-controllers',
    defaults: {
        cls: 'dashboardHeaderIcons',
		margin:'0 2 0 2'

    },
	layout : {
		type : 'hbox',
		align : 'stretch'
	},
	isPublishedDashboard : 'false',
	isHomeDashboard : 'false',
    items: [
	
	{
        xtype: 'button',
        width: 120,
		height:30,
		padding: '5 0 5 0',
		cls:'newAddWidgetBnt',
		border:0,
		style:{'background':'none'},
		html:'<div class="newFont_normal15 addWigetClr">'+screenLabelsObj['Add a Widget']+'</div>',
        overCls: 'buttonOver',
		buttonId: 'AddWidget_New',
		id: 'AddWidget_New',
		icon: '../images/'+strSkin+'/newConfigAddIcon.png', // icons can also be specified inline
    },
    	//layout setting button
	{
		xtype: 'button',
		margin: 0,
		padding: 0,
		toggleGroup: true,
		enableToggle: true,
		buttonId: 'custom_layouts',
		id: 'custom_layouts',
		buttonId: 'custom_layouts', 
		iconCls: 'iconDashboardLayoutSettings',
		overCls: 'buttonOver myDashboard dashboardLayoutSettingsOver',
		pressedCls: 'buttonPressedDashboard',
		defaultState: function () {
			var btn = this;
			btn.setText('');
			if (btn.pressed) {
				btn.toggle(false);
				btn.fireEvent('mouseout',btn);
			}else{
				Ext.destroy(Ext.getCmp('layout_window'));
			}

			},
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: 'Layouts'
					});
				},
				click: function (btn) {
					
					if(btn.pressed){
						Ext.create('MyDashBoard.view.PreDefinedLayouts',{
							width: Ext.getBody().getViewSize().width - 16,
							y: btn.el.getY() + 30
						}).show();
					}else{
						Ext.destroy(Ext.getCmp('layout_window'));
					}
					
				},
				mouseover: function (btn) {
					btn.setText("<span class='newFont_normal14' style='margin: 0 5px ; color:#ffffff;'>Layout</span>");
				},
				mouseout: function (btn) {
					if (btn.pressed) {
						btn.setText("<span class='newFont_normal14' style='margin: 0 5px ; color:#ffffff;'>Layout</span>");
					} else {
						btn.setText("");
						btn.removeCls('buttonOver');
					}
				}
			}
	},
	{
		xtype: 'tbseparator',
		width: 2,
		height: 30,
		margin: 0,
		id: 'customLayoutButton_tbsettingseperator',
		buttonId: 'tbsettingseperator',
		cls: 'myDashboardFloatingMenuSeperator',
	},
	{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: 'modifyButton_tbsettingseperator',
		buttonId: 'Modify Dashboard_tbsettingseperator',
		cls:'myDashboardFloatingMenuSeperator',
	},
	
	{
		xtype: 'button',
		//width: 20,
		//height:30,
		margin: 0,
		padding:0,
		iconCls: 'iconOneClickHeaderSettings',
		overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		buttonId: 'Modify Dashboard',
		id : 'modifyButton',
		toggleGroup :true,
		enableToggle: true,
		name : 'modifyButton',
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		listeners: {
				afterrender: function () {
				/*Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: editSettingsLbl
				});*/
			},
			 mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+toolModify+"</div>");
				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+toolModify+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
		}
	},
	{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: 'BgGroundButton_tbsettingseperator',
		buttonId: 'Change Background_tbsettingseperator',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
		xtype: 'button',
        //width: 20,
		//height:25,
		margin: 0,
		padding: 0,
		defaultState : function() {
			var btn = this;
			btn.setText('');


		},
		overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		id : 'BgGroundButton',
		buttonId: 'Change Background',
		toggleGroup :true,
		enableToggle: true,
		hidden : isLightTheme,
		iconCls: 'iconOneClickHeaderGraph',
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		listeners: {
			afterrender: function () {
				/*Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: changeBgrndLbl
				});*/
			},
			
			 mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Change']+"</div>");
				},
				
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Change']+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
		}
	},
	{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: '',
		buttonId: 'cloneButton_tbsettingseperator',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
		xtype: 'button',
		margin: 0,
		padding: 0,
		overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		id : 'cloneButton',
		buttonId: 'Clone Dashboard',
		iconCls: 'iconOneClickHeaderClone',
		toggleGroup :true,
		enableToggle: true,
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		listeners: {
			afterrender: function () {
				/*Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'Clone'
				});*/
			},
				
			mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Clone']+"</div>");
				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Clone']+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
		}
	},
	{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: 'deleteButton_tbsettingseperator',
		buttonId: 'Delete Dashboard_tbsettingseperator',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
		xtype: 'button',
		margin: 0,
		padding: 0,
		id : 'deleteButton',
		overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		buttonId: 'Delete Dashboard',
		iconCls: 'iconOneClickHeaderDelete',
		toggleGroup :true,
		enableToggle: true,
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		listeners: {
			afterrender: function () {
				/*Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: toolDelete
				});*/
			},

				
			 mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+toolDelete+"</div>");

				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+toolDelete+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
		}
	},
	{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: 'publishButton_tbsettingseperator',
		buttonId: 'Publish Dashboard_tbsettingseperator',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
		xtype: 'button',
		margin: 0,
		padding: 0,
		id:'publishButton',
		overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		buttonId: 'Publish Dashboard',
		iconCls: 'iconOneClickHeaderPublished',
		toggleGroup :true,
		enableToggle: true,
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		listeners: {
			afterrender: function () {
				/*Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'Publish'
				});*/
			},
			
			mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+publishLbl+"</div>");
				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+publishLbl+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
		}
	},
	{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: 'setAsDefaultButton_tbsettingseperator',
		buttonId: 'SetAsDefault_tbsettingseperator',
		cls:'myDashboardFloatingMenuSeperator',
	},
	{
        xtype: 'button',
		margin: 0,
		padding: 0,
        overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		id: 'setAsDefaultButton',
        buttonId: 'SetAsDefault',
		itemId: 'setAsHomeDashIcon',
        iconCls: 'iconOneClickHeaderSetusDefault',
		toggleGroup :true,
		enableToggle: true,
		defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}
		},
        listeners: {
            afterrender: function () {
                /*Ext.create('Ext.tip.ToolTip', {
                    target: this.id,
                    anchor: 'top',
                    cls: 'yellowTip',
                    trackMouse: true,
                    html: setAsHomeLbl
                });*/
            },
			
			mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Set As Default']+"</div>");
				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Set As Default']+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
        }
    }
	/*,{
        xtype: 'button',
		margin: 0,
		padding: 0,
		
        overCls: 'buttonOver myDashboard',
		pressedCls: 'buttonPressedDashboard',
		id: 'dataSource',
        buttonId: 'dsnSettings',
		itemId: 'dsnSettings',
        iconCls: 'iconOneClickDataSource',
		toggleGroup :true,
		enableToggle: true,
		hidden : false,
        defaultState : function() {
			var btn = this;
			btn.setText('');
			if (btn.pressed)
			{
				//alert(btn.pressed);
				btn.toggle(false);
				btn.removeCls('buttonOver');
			}

		},
		 listeners: {
            afterrender: function () {
               
            },
			mouseover: function(btn) {
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Data Source']+"</div>");
				},
				mouseout: function(btn ){
					if (btn.pressed)
					{
					
				
					btn.setText("<div class='newFont_normal15' style='margin: -2px 5px 0 ; color:#ffffff;'>"+screenLabelsObj['Data Source']+"</div>");
					}
					else{
							btn.setText("");
							btn.removeCls('buttonOver');
					}
				}
        }

    },{
		xtype:'tbseparator',
		width: 2,
		height: 30,
		margin:0,
		id: '',
		buttonId: 'tbsettingseperator',
		cls:'myDashboardFloatingMenuSeperator',
	}*/
	
	]
});
