Ext.define('MyDashBoard.view.DashboardGroundGadget', {
    extend: 'Ext.window.Window',
    alias: 'widget.dashbggadgetwindow',
    id: 'dashboardbgWin',
    title: 'Dashboard Background',
    defaults: {
        cls: 'dragTools'

    },
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    farme: true,
	border:false,
    padding: 0,
	cls:'myDashboardwindow',
	ui:'newPopupWindow ',
	bodyPadding:0,
    resizable: false,
	
   /* header: {
        height: 33,
        padding: '0 10',
        margin: 0,
        style: {
            //'border-bottom': '#2b2b2b 1px solid !important'
        }
    },*/
    ghost: false,
    bodyStyle: {
        'background': 'none'
    },
    modal: true,
	width:strSkin == "Light" ? 384 : 384,
	height:strSkin == "Light" ? 290:290,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    closeAction: 'destroy',
    dashBoardAction: '',
    profileName: '',
    items: [{
        xtype: 'container',
        itemId: 'paletteContainer',
        padding: '22 0 20 12',
	margin:0,
        //style : 'border:2px solid red',
        height: 168,
        scroll: false,
        autoScroll: false,
        //layout : 'fit',
        layout: {
            type: 'column',
            align: 'strech'
        }
    }, {

    }, {
        xtype: 'container',
		cls:'windowOrBorder',
        html: '<div style="margin-top:-16px"><span class="windowOrBg">OR</span></div>',
    }, {
        xtype: 'form',
        id: 'bgImageUploadForm',
        padding: '0 20 10 20 ',
        //style : 'border:2px solid red',
        //layout : { type : 'vb',align : 'stretch'},
        items: [

            {
                xtype: 'container',
                layout: {
                    type: 'hbox',
                    align: 'stretch'
                },
                items: [{
					xtype:'container',
					width:300,
					items:[{
					xtype:'label',
					text:'Upload Your Own',
					margin:'0 0 5 0'
				},{xtype: 'container',
				padding:'5 5 5 5',
				cls:'fileuploadCon',
				layout: {
                    type: 'hbox'
                },
				items:[{
                    xtype: 'filefield',
                    cls: 'fileupload',
					 buttonOnly: true,
                    id: 'FILE_0',
                    name: 'FILE_0',
                    cls: 'fileupload',
					margin:'0 10 0 0',
                    labelAlign: 'top',
                    labelSeparator: ' ',
           
                    msgTarget: 'side',
                    allowBlank: false,
					hideLabel: true,
					listeners: {
						'change': function(fb, v){
							var el = Ext.get('fileuploadPath');
							el.update(v);
							Ext.getCmp('uploadBtn').show();
						}
					},
                    buttonText: 'Choose File'
                },{
					xtype:'container',
					 width:197,
					margin:'3 0 0 0',
					html:'No file chosen',
					id:'fileuploadPath'
				}]}]
				}, {
                    xtype: 'hidden',
                    id: 'FILE_0_dstFile',
                    name: 'FILE_0_dstFile',
                    value: 'manager/tomcat/webapps/final/images/mydashboard-textures/'
                }, {
                    xtype: 'container',
                    margin: '20 0 0 10',
                    id: 'uploadBtnContainer',

                    items: [{
                        xtype: 'button',
                        cls: 'button20',
						hidden:true,
						padding:'0 5 0 5',
                        margin:'0 0 0 0',
                        id: 'uploadBtn',
                        text: 'Apply'
                            //width: 80
                    }]
                }]
            }

        ]
    }],
    listeners: {
        'render': function () {
            this.loadBgPalette();
        },
		'close':function(win){
						Ext.getCmp('BgGroundButton').defaultState();
                      
                  }
    },
    loadBgPalette: function () {
		var me = this;
        var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
        var paramsForSave = "action=getDashboardBgs&profileName=" + encodeURIComponent(profileName);
        Ext.Ajax.request({
            url: '/final/servlet/com.eg.egMyDashboardController',
            method: 'POST',
            params: paramsForSave,
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
                if (jsonText != null && jsonText != '') {
                    var jsonData = Ext.decode(jsonText);
                    var bgArr = [];
                    var dashboardBgs = jsonData['dashboardBgs'];
                    if (!Ext.isEmpty(dashboardBgs)) {
                        for (var bg in dashboardBgs) {
                            bgArr.push({
                                xtype: 'container',
								cls:'containerNormal',
                                margin: '0 8 12 8',
								/*removeMe:function(){
									Ext.getCmp(this.id).destroy();
								},*/
								overCls:'containerOver',
                                border: true,
								/*items: [{
									xtype: 'button',
									style:{'position':'absolute','bottom':'5px','right':'5px'},
									iconCls:'iconDelete',
									cls: 'dragTools',
									tooltip:'Remove',
									handler: function () {
										this.findParentByType('container').removeMe();
									}
								}],*/
                                imageId: 'bgrnd1',
                                width: 56,
                                height: 56,
                                html: '<div class="bgrnd"><a href="javascript:void(0);" onclick="javascript:changeDashBg(\'' + dashboardBgs[bg] + '\')")"><img src="/final/images/mydashboard-textures/' + dashboardBgs[bg] + '"  style="padding:2px;vertical-align:middle;display:inline-block" width="50" height="50" /></a></div>'

                            });
                        }
                    }
                    var paletteContr = this.getComponent('paletteContainer');
                    paletteContr.removeAll();
                    paletteContr.add(bgArr);
                    paletteContr.doComponentLayout();
                    paletteContr = null;
                    delete paletteContr;
                }
            },
            failure: function (response, opts) {

            }
        });
    }
});