Ext.define('MyDashBoard.view.GeoMapControls', {
    extend: 'Ext.container.Container',
    alias: 'widget.geomapcontrols',
    autoDestroy: true,
    //margin: '0 10 0 0',
    padding: 0,
    width: 350,
    border: false,
    layout: {
        type: "hbox"
    },
    id: 'geomapHeaderID',
	geoPnlId : '',
	mapTitle : 'GeoMap',
    initComponent : function()
	{
		var meC=this;
		meC.items= [{
            xtype: 'label',
            cls: "b_label",
			id : meC.geoPnlId+'_Header',
            text: meC.mapTitle,
			 margin: '2 0 0 0',
			listeners :
			{
					'afterrender': function(){
						var me =this;
						var dragedColHeader =me;//Ext.get(me.header.id+'_hd-textEl');
								
						me.on('dblclick', function(e,target){
								//Ext.get(me.header.id+'_hd-textEl').setVisible(false)

								$('#'+me.id).css({"text-overflow":"clip"});

										var layerheader = me.getWidth() - 90;
										var edtrText=dragedColHeader.dom.innerHTML;
										var editedblck=me.id;
										var timelineTxt='';
										if(editedblck!=null && editedblck.lastIndexOf("_")>0)
										{
											editedblck=editedblck.substring(0,editedblck.lastIndexOf("_"));
										}
										var widgetTitleEditor = new Ext.Editor({
										width: 150,
										alignment: 'tl',
										floating: false,
										shadow: false,
										updateEl: true,
										ignoreNOChange: true,
										completeOnEnter: true,
										cancelOnEsc: true,
										field: {
											xtype: 'textfield',
											cls: 'headerTextEdit'
										},
										listeners: {
											'beforecomplete': function (meEdtr, value, startValue, eOpts) {
												if (value == null || value == '') {
													meEdtr.setValue(startValue);
													Ext.Msg.show({
														title: myDashboardAlertLbl,
														msg: emptyHeadrMsg,
														buttons: Ext.MessageBox.OK,
														icon: Ext.MessageBox.WARNING
													});
													return false;
												}
											},
											'complete': function (meEdtr, value, startValue, eOpts) {
											
												var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
												Ext.Ajax.request({
													url: '/final/servlet/com.eg.egMyDashboardController',
													method: 'POST',
													params: '&action=rename&profileName=' + encodeURIComponent(profileName) + '&key=' + me.id + '_Title&value=' + encodeURIComponent(value),
													success: function (response) {
														var jsonText = response.responseText;
														if (jsonText != null && jsonText != '') {
															var jsonData = Ext.decode(jsonText);
														if(editedblck!=null && (editedblck=="TimelineChart" || editedblck=="CombinedTimelineChart"))
														{
															if(timelineTxt!=null && timelineTxt!="")
															{
																dragedColHeader.dom.innerHTML=value+" - "+timelineTxt;
														}
													}
													}
												}
												});
													$('.editor_layer').remove();
													$('#'+me.id).css({"text-overflow":"ellipsis"});
											}
										}
									});
									var el = Ext.get(me.id+'_hd-textEl');
									widgetTitleEditor.startEdit(el,edtrText);
									$("#"+me.id).append('<div class="editor_layer" style="position:absolute;top:0px;height:50px;width:'+layerheader+'px">---</div>');
														$( "#dashboardLayoutObj-body" ).scroll(function() {
														if(!Ext.isEmpty(widgetTitleEditor)){
															widgetTitleEditor.cancelEdit(false);
														}
														$('.editor_layer').remove();
												 });

							}, me, {
								 delegate: '#'+me.id+'_hd-textEl'
							});
							widgetTitleEditor = null;
					}
			}
        },
        {
            xtype: 'button',
            margin: '0 5',
            cls: 'infobutton',
            infoToolTip: function(btn) {
                var me = this;
                var tooltip = Ext.create("Ext.tip.ToolTip", {
                    anchor: "top",
					shadow: true,
                    anchorOffset: 25,
                    mouseOffset: [0, 0],
                    target: btn.id,
                    cls: "moreoptionstooltip",
                    listeners: {
                        hide: function(tooltip) {
                            if (!Ext.isEmpty(tooltip)) {
                                Ext.destroy(tooltip);
                            }
                        },
                        render: function(a) {
                            Ext.EventManager.onWindowResize(function(b, c) {
                                a.hide();
                            });
                        }
                    },
                    getTargetXY: function() {
                        var x = btn.el.getXY()[0];
                        var y = btn.el.getXY()[1];
                        return [x - tooltip.anchorOffset - 12, btn.getHeight() + y];
                    },
                    autoHide: false,
                    anchorToTarget: true,
                    width: 210,
                    padding: "10 2 10 10",
                    style: 'text-align:left',
                    html: "<div class='t_b'><div class='t_h'>How to read?</div> <ol><li>Showing response time and hits for world</li></ol></div>"
                });
				return tooltip;
            },
            handler: function(btn) {
                btn.infoToolTip(btn).show();				
            },
			iconCls: 'big_infoIcon'
        },{
            xtype: 'button',
            margin: '0 0',
			padding:0,
            cls: 'geoDrilldown',
			//text:'World',
			//iconCls:'geoDrilldownIcon',
			//text:'<span style="float:left">Countries</span><div class="geoDrilldownIcon"></div>',
			text:'<span style="float:left" class="geoDrilldownLink">Countries</span><div class="geoDrilldownArrow"></div>',
			id: 'world_icon_'+meC.geoPnlId,
			style:{'background':'none'},
            handler: function(btn) {
				try
				{
					var countryComboObj = Ext.getCmp('countryComboId_'+meC.geoPnlId);
					countryComboObj.setValue("World");
					myDashApp.getController("Main").loadCountryMap(countryComboObj,meC.geoPnlId);
				}
				catch (e)
				{
				}
                
            },
			hidden:true,
			//iconCls: 'big_infoIcon'
        },
		{
            xtype: 'button',
			padding:0,
			margin:'0 0 0 -3px',
            cls: 'geoDrilldown',
			//iconCls:'geoDrilldownIcon',
			//text:'<span style="float:left">States</span><div class="geoDrilldownIcon"></div>',
			text:'<span style="float:left" class="geoDrilldownLink">States</span><div class="geoDrilldownArrow"></div>',
			id: 'region_icon_'+meC.geoPnlId,
            //cls: 'stateIcon_GOOD',
			style:{'background':'none'},
            handler: function(btn) {
               try
				{
					var regionComboObj = Ext.getCmp('regionComboId_'+meC.geoPnlId);
					regionComboObj.setValue("AllRegion");
					myDashApp.getController("Main").loadCountryMap(regionComboObj,meC.geoPnlId);
				}
				catch (e)
				{
				}			
            },
			hidden:true
			//iconCls: 'big_infoIcon'
        },
		{
            xtype: 'label',
			padding:0,
			cls:'geoDrilldownLabel',
			//iconCls:'geoDrilldownIcon',
			//text:'<span style="float:left">States</span><div class="geoDrilldownIcon"></div>',
			//text:'<span style="text-decoration:none;float:left" class="geoDrilldownLink">Region</span><div class="geoDrilldownArrow"></div>',
			text:'Region',
			id: 'region_label_'+meC.geoPnlId,
            		//cls: 'stateIcon_GOOD',
			style:{'top':'3px !important'},
            		hidden:true
			//iconCls: 'big_infoIcon'
        },
		{
            xtype: 'label',
			padding:0,
			cls:'geoDrilldownLabel',
			//iconCls:'geoDrilldownIcon',
			//text:'<span style="float:left">States</span><div class="geoDrilldownIcon"></div>',
			//text:'<span style="text-decoration:none;float:left" class="geoDrilldownLink">Region</span><div class="geoDrilldownArrow"></div>',
			text:'Region',
			id: 'city_icon_'+meC.geoPnlId,
            //cls: 'stateIcon_GOOD',
			style:{'top':'3px !important'},
            hidden:true
			//iconCls: 'big_infoIcon'
        },
		 {
            xtype: 'combo',
            cls: 'dropdown',
            width: 115,
			id : 'compCombo_'+meC.geoPnlId,
			itemId:'compCombo_'+meC.geoPnlId,
            value: "",
            margin: '0 10 0 0',
            store: Ext.create('Ext.data.Store', {
				fields: ['displayField','valueField'],
				data: []
			}),
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			geoPnlId : meC.geoPnlId,
			listeners : {
				'select' : function(meObj)
				{
					myDashApp.getController("Main").loadCountryMap(meObj,meObj.geoPnlId);
				//	var configPanl = Ext.getCmp(meObj.geoPnlId);
				//	var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
					//myDashApp.getController("Main").loadDataForBlock(configPanl,profileName,meObj.geoPnlId,false);
				}
			}
        },
		 {
            xtype: 'combo',
            cls: 'dropdown',
            width: 115,
			id : 'countryComboId_'+meC.geoPnlId,
			itemId:'countryComboId_'+meC.geoPnlId,
            value: "",
            margin: '0 10 0 0',
			store: Ext.create('Ext.data.Store', {
						fields: ['name','value'],
						data: []
			}),
			displayField: 'name',
			valueField: 'value',
			queryMode: 'local',
			geoPnlId : meC.geoPnlId,
			filterViewName : 'Geo_Country_View',
			listeners : {
				'select' : function(meObj)
				{
					//var configPanl = Ext.getCmp(meObj.geoPnlId);
					//var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
				//	configPanl.filterViewName='Geo_Country_View';
					myDashApp.getController("Main").loadCountryMap(meObj,meObj.geoPnlId);
					//myDashApp.getController("Main").loadDataForBlock(configPanl,profileName,meObj.geoPnlId,false);
				}
			}
        },
		 {
            xtype: 'combo',
            cls: 'dropdown',
            width: 115,
			id : 'regionComboId_'+meC.geoPnlId,
			itemId:'regionComboId_'+meC.geoPnlId,
            value: "",
            margin: '0 10 0 0',
            store: Ext.create('Ext.data.Store', {
						fields: ['name','value'],
						data: []
			}),
			displayField: 'name',
			valueField: 'value',
			queryMode: 'local',
			geoPnlId : meC.geoPnlId,
			filterViewName : 'Geo_Region_View',
			listeners : {
				'select' : function(meObj)
				{
				//	var configPanl = Ext.getCmp(meObj.geoPnlId);
				//	var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
				//	configPanl.filterViewName='Geo_Region_View';
					//myDashApp.getController("Main").loadDataForBlock(configPanl,profileName,meObj.geoPnlId,false);
					myDashApp.getController("Main").loadCountryMap(meObj,meObj.geoPnlId);
				}
			}
        }];

		this.callParent();
	}
})