Ext.define('MyDashBoard.view.GraphPaletteWindow',{
	extend:'Ext.container.Container',
	alias:'widget.graphpalettewindow',
	cls:'graphpalettewindow',
	bodyStyle: {
        'background': '#535353'
    },
    defaults: {
        cls: 'dragTools'
    },
	floating:true,
	
	header:false,
	resizable:false,
	shadow:false,
	width:230,
	height : 150,
	autoScroll:true,
	html:'<div class="colorpalletnodge"></div>',
	//style:{'overflow':'auto !important'},
	layout:{ type : 'vbox',align : 'stretch'},
	closeAction : 'hide',
	padding:'8 0 0 0',
	border:true,
	dashBoardAction : '',
	profileName : '',
	blockId : '',
	selectedGraphPalette : null,
	listeners : {

		'beforeshow' : function(winObj)
		{
			if(winObj.selectedGraphPalette!=null && winObj.selectedGraphPalette!="")
			{
				 var butObj=Ext.getCmp(winObj.selectedGraphPalette+"_Btn");
				if(!Ext.isEmpty(butObj))
				{
					 butObj.toggle(true);
				}
			}
		},
		'render' : function(win)
		{
			var cPanlObj=Ext.getCmp(win.blockId);
			var winDOM = win.getEl();
			win.mon(winDOM, {
				mouseout: function() {
					cPanlObj.isTopNComboInProgress=false;
					win.hide();
				},
				mouseover:function(){
					cPanlObj.isTopNComboInProgress=true;
					win.show();
				}
			});
			var paramsForSave = "action=getGraphPalettes";
			var meWind=this;
			Ext.Ajax.request({
					url : '/final/servlet/com.eg.egMyDashboardController',
					method : 'POST',
					params : paramsForSave,
					scope : this,
					//windowObj : meWind,
					success : function(response) {
						
						var jsonText=response.responseText;
						if(jsonText!=null && jsonText!='')
						{
							var jsonData=Ext.decode(jsonText);
							var bgArr=[];
							var palettes=jsonData['palettes'];

							if(!Ext.isEmpty(palettes))
							{
								
								for(var palette in palettes)
								{
									var paletteObj=palettes[palette];
									var paletteDispname=paletteObj['paletteDispname'];
									var paletteColors=paletteObj['paletteColors'];
									paletteColors.length = 10;
									var paletteDiv='';
									for(var col in paletteColors)
									{
										paletteDiv=paletteDiv+'<div style="float:left;width:12px;height:12px;margin:1px 0px 0px 1px;border:1px solid #2c2c2c;background-color:'+paletteColors[col]+'"></div>';
									}
									var isPaletteSelected=false;
									if(this.selectedGraphPalette!=null && this.selectedGraphPalette==palette)
									{
										isPaletteSelected=true;
									}

									bgArr.push({
										xtype : 'button',
										overCls : 'labelOver',
										cls:'labelNormal',
										enableToggle:true,
										pressedCls:'labelSelect',
										toggleGroup:'selectName',
										imageId : palette,
										pressed : isPaletteSelected,
										id:palette+ '_Btn',
										width : 215,
										html : paletteDiv+"<div style='float:right;'class='paletteName'>"+paletteDispname+"</div>",
										listeners : {
											'render' : function(c)
											{
												c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
											}

										}

									});
								}
								//this.suspendEvents(true);
								
								this.add(bgArr);
								//this.resumeEvents();
								//this.doComponentLayout();

							}
						}
					},
				failure : function(response, opts) {
					
				}
			  });
		}
	}
});