var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
        clicksToEdit: 1
    });

Ext.define('MyDashBoard.view.GridComparisonTable',{
	extend:'Ext.grid.Panel',
	requires:['Ext.selection.CellModel','Ext.selection.CheckboxModel'],
	alias:'widget.gridcomparisontable',
	id : 'gconfigTableGrid',
	name : 'gconfigTableGrid',
	layout:{type:'vbox',align:'stretch'},
	//cls:'gridSkin',
	ui: 'newGridPanel configTableGrid vmAlerts mydashboard_grid',
	margin:'0 10 0 0',
	autoScroll:true,
	isAggregationDisabled : false,
	isCombinationChart : false,
	autoExpandColumn: 'VmName',
	width:'100%',
	viewConfig: {
		deferEmptyText: false
	},
	emptyText : '<table width="100%" height="10px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div styel="margin:10px auto">'+noConfigAvailableMsg+'</div></td></tr></table>',
	initComponent : function()
	{
		this.selModel =  new Ext.selection.CheckboxModel({
				checkOnly: true,
				width: 50,
				injectCheckbox: 0
			});
		this.getStore().removeAll();
		var isAggregationDisabled = this.isAggregationDisabled;
		var isCombinationChart = this.isCombinationChart;

		this.columns = [

            {
				text: 'VM',
				flex: 2,
				dataIndex: 'VmName',
				renderer: function(value, metaData) {
					return'<div data-qtip="' + value + '">'+ value + '</div>';
				}
			},
			{
				text: compDispLbl,
				flex: 1,
				dataIndex: 'ComponentName'
			},
			{
				text: componentTypeLbl,
				flex: 1,
				dataIndex: 'ComponentType'
			},{
				text: 'hiddenVal',
				flex: 1,
				dataIndex: 'hiddenVal',
				hidden:true
			},
			{
				header: '<div class="iconDeleteAll" style="margin:3px auto 0px auto" data-qclass="yellowTip" data-qtip="'+toolDeleteAll+'"></div>',
				xtype: 'actioncolumn',
				enableColumnHide:false,
				menuDisabled:true,
				renderer: function(value, metaData) {
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+toolDelete+'"';
					return value;
				},
	            	width:36,
		        sortable: false,
			    items: [{
				    iconCls: 'iconDelete',
	                handler: function(grid, rowIndex, colIndex) {
						var rec = grid.getStore().getAt(rowIndex);
			            grid.store.remove(rec);
						Ext.getCmp('doneButton').enable();
				    }
				}],
				listeners:{
					'headerclick':function( ct, column, e, t, eOpts ){
						var thisGrid = this.up('grid'),
						thisGridStore = thisGrid.getStore(),
						thisGridSelections = thisGrid.getSelectionModel(),
						noOfrecords = thisGridStore.getCount();
						if ( noOfrecords > 0 )
						{
							var selection = thisGridSelections.getSelection();
							if(selection.length==0)
							{
								 Ext.Msg.show({
									title: myDashboardAlertLbl,
									msg: noConfigSelectedAlertMsg,
									buttons: Ext.MessageBox.OK,
									icon: Ext.MessageBox.WARNING
								});
								return;
							}
							Ext.Msg.show({
								title:myDashboardAlertLbl,
								msg:metricsDeleteAlertMsg,
								buttons: Ext.Msg.YESNO,
								icon: Ext.Msg.QUESTION,
								fn:function(buttonId)
								{
									if(buttonId =="yes")
									{

											var chkTotal = (thisGrid.selModel.selected.getCount() === thisGrid.getStore().getCount());
											if(chkTotal){
											thisGridStore.remove(selection);
											}else{
											for (var i=0; i< selection.length ; i++ )
											{
												thisGridStore.remove(selection[i]);
											}
											}
											thisGrid.selModel.toggleUiHeader();
											Ext.getCmp('doneButton').enable();


									}
								}
							});
						}
						else
						{
							 Ext.Msg.show({
								title: 'Alert',
								msg: noConfigAvailableMsg,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
							return;
						}
					}
				}
			}
        ];
		this.callParent();
	},
	/*dockedItems:[
	{
		xtype:'toolbar',
		ui:'footer',
		layout:{
        pack: 'center'
    },
		dock:'bottom',
		items:[
		{
			xtype:'button',
			text:updateDispBtn,
			id : 'UpdateVMBlockConfig',
			name : 'UpdateVMBlockConfig',
			 cls: 'button20',
			padding:'0 5'
		}
		]
	}
	],*/
	title: selectionsLbl,
	plugins: [cellEditing],
	store:Ext.create('Ext.data.ArrayStore',{
		fields: [
            {name: 'VmName',type : 'string'},
            {name: 'ComponentName', type: 'string'},
            {name: 'ComponentType', type: 'string'},
            {name: 'hiddenVal', type: 'string'}
            ],
		data:[]
	}),
	selModel: {
            selType: 'cellmodel'
        }
})