/*----
		This layout is mixed of gridster ,Ext.js and jquery UI
		Changes have been done in the core gridster.js for Drag position
		Dont update the core file GRIDSTER
----*/
/*--TODO dynamically--*/
Ext.define('MyDashBoard.view.Gridster', {
    extend: 'Ext.Component',
 
    id: 'gridsterLayout',
	outerheight:null,
	//suspendLayout:true,
    alias: 'widget.gridster',
	settingWidth : 1024,
	closeAction:'destory',
	deafault_widget_base_dimensions : [130,130],
	default_margins : [3,3],
	panelObj:function(config){
		config = config || {};
		var panel = Ext.create('MyDashBoard.view.Portlet',config);
		return panel;
	},
    createGridsterTags: function() {
		var w = window,
			d = document,
			e = d.documentElement,
			g = d.getElementsByTagName('body')[0],
			x = w.innerWidth || e.clientWidth || g.clientWidth,
			y = w.innerHeight || e.clientHeight || g.clientHeight;
        html = '<div class="gridster"><ul class="gridsterul" style="width:'+(x-30)+'px !important;border:0px solid red;margin-left:5px !important">' +
            '</ul></div>';
        return html;
    },
	listeners:{
		boxready:function(){
			if ($('#dashboardLayoutObj-body')[0].scrollHeight > $('#dashboardLayoutObj-body').innerHeight())
			{
				Ext.Element.select('.removeLineForTvMode').show();
				//Ext.getCmp('iconAutomaticScrollRun').show();
				//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
			}
			else
			{
				Ext.getCmp('iconAutomaticScrollRun').hide();
				Ext.Element.select('.removeLineForTvMode').hide();
				Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
			}
		}
	},

    createGridsterObj: function() {
		var meGridster = this;
        gridSter = $(".gridster > ul.gridsterul").gridster({
            widget_margins: this.default_margins,
            widget_selector: '.gridster > ul.gridsterul > li',
		//	extra_rows: 0,
			//max_size_x: 170,
		//	max_size_y: 170,
		//	extra_cols: 0,
			//min_cols:1,
			//container_width:x,
			//max_cols:5,
            // widget_base_dimensions: [250, 250],
            widget_base_dimensions: this.deafault_widget_base_dimensions,
            autogenerate_stylesheet: true,
            avoid_overlapped_widgets: true,
            serialize_params: function($w, wgd) {
                return {
                    size_x: wgd.size_x,
                    size_y: wgd.size_y,
                    col: wgd.col,
                    row: wgd.row,
                    id: $w[0].id,
                    widthVal: $w.width(),
                    heightVal: $w.height()
                };
            },
            draggable: {

                start: function(e, ui, $widget) {


                },
                drag: function(e, ui, $widget) {
					 //-- condition to hide the title editor
                    if(!Ext.isEmpty(widgetTitleEditor)){
						widgetTitleEditor.cancelEdit(false);
						$('.editor_layer').remove();
					}

                },
                stop: function(e, ui, $widget) {
					
                    var newpos = this.serialize($widget)[0];
					var dashboardLayoutObj=Ext.getCmp('dashboardLayoutObj');
                    var profName = dashboardLayoutObj.profileName;
                    var isSharedDashboard = dashboardLayoutObj.isSharedDashboard;
		    if(!isAnonymousUserAccess && (!isSharedDashboard || publicJson['myDashboardConfigDetails']['isAllwoedtoEditSharedDashboard']==true))
					{
	                    var pnlPositions = meGridster.getAllPanelPositions();
		                myDashApp.getController("Main").saveFluidDashboardWindowResizeConfig(profName, pnlPositions);
					}
					dashboardLayoutObj=null;
					delete dashboardLayoutObj;
                }
            },
            resize: {
                enabled: true,
				min_size: [1, 1],
                start: function(e, ui, $widget) {
					var widgetPnlObj=Ext.getCmp($widget[0].getAttribute('widgetname'));
					if (!Ext.isEmpty(widgetPnlObj) && widgetPnlObj.blockType == 'pieChart') {
						gridSter.resize_min_size_x=3;
						gridSter.resize_min_size_y=3;
					}else{
						gridSter.resize_min_size_x=1;
						gridSter.resize_min_size_y=1;
					}
					if (!Ext.isEmpty(widgetPnlObj)) {
						widgetPnlObj.isWidgetResizeInProgress=true;
					}
				},
                resize: function(e, ui, $widget) {
					var widgetPnlObj=Ext.getCmp($widget[0].getAttribute('widgetname'));
                    if (!Ext.isEmpty(widgetPnlObj)) {
                        widgetPnlObj.setSize($widget.width(), $widget.height());
						widgetPnlObj.isWidgetResizeInProgress=true;
                    }
					var outerHeight = $('#dashboardLayoutObj-body').outerHeight(true);
					var container_height = $('#dashboardLayoutObj-body')[0].scrollHeight;
					var heightCon = $('#dashboardLayoutObj-body').height()
					$('iframe').css('pointer-events','none');
					var gettingTotalRow;
					var arr=new Array();
					$('.gridster > ul.gridsterul > li[data-row]').val(function(){
						gettingTotalRow = [$(this).attr('data-row')];
						arr.push(gettingTotalRow);
					});
					$('.gridster > ul.gridsterul > li:last-child[data-row]').val(function(){
						arr.sort(function (a, b) {return a - b});
						var gettingMaxRow = arr[arr.length-1];
						var gettingDragRow = [$(this).attr('data-row')];
						if (gettingMaxRow == Number(gettingDragRow))
						{
							if(ui.pointer.top > outerHeight -10 ){
								$('.gridster').after('<div class="getScrollDiv" style="height:2px";position:relative;background:#000000;display:block;"></div>');
								$("#dashboardLayoutObj-body").scrollTo(ui.position.top, ui.position.left);
							}
						}
					});
                },
                stop: function(e, ui, $widget) {
					$(".getScrollDiv").remove();
					$('iframe').css('pointer-events','auto');
					$('li.gw_s').unbind();
					this.outerheight = $('#dashboardLayoutObj-body').outerHeight(true);
					var widgetPnlObj=Ext.getCmp($widget[0].getAttribute('widgetname'));
                    if (!Ext.isEmpty(widgetPnlObj)) {
                        widgetPnlObj.suspendLayouts();
                        widgetPnlObj.setSize($widget.width(), $widget.height());
                        var cPanlId = $widget[0].getAttribute('widgetname');
                       var pnlPositions = meGridster.getAllPanelPositions();
                        meGridster.resizeFn(cPanlId, pnlPositions, $widget.width(), $widget.height());
                        widgetPnlObj.resumeLayouts(true);
						widgetPnlObj.isWidgetResizeInProgress=false;
                    }


                }
            },

        }).data('gridster');
		var xDim=this.deafault_widget_base_dimensions[0];
		this.maxCols=(x-50)/xDim;
		if(isNaN(this.maxCols))
		{
			this.maxCols=7;
		}
		this.maxCols=Math.ceil(this.maxCols,0);
		$('li.gw_s').unbind();
		$('li.gw_s > .x-panel').unbind();
        return gridSter;
    },
    getAllPanelPositions: function() {
        var gridsterObj = $(".gridster > ul.gridsterul");
        var gridster = gridsterObj.gridster().data('gridster');
        var pnlPositionsArr = gridster.serialize();
	//	console.log("pnlPositionsArr---->",JSON.stringify(pnlPositionsArr));
        var posQryStr = '';
        var scrWidVal = (Ext.getBody().getViewSize().width - 40);
        var scrHeightVal = (Ext.getBody().getViewSize().height - 25);
        for (var arrCtr in pnlPositionsArr) {
            var pnlPosObj = pnlPositionsArr[arrCtr];
            var colPos = pnlPosObj['col'];
            var rowPos = pnlPosObj['row'];
            var size_x = pnlPosObj['size_x'];
            var size_y = pnlPosObj['size_y'];
            var widthVal = pnlPosObj['widthVal'];
            var heightVal = pnlPosObj['heightVal'];
            var blkId = pnlPosObj['id'];
            posQryStr += "|" + blkId + ":" + colPos + "," + rowPos + "," + size_x + "," + size_y + "," + widthVal + "," + heightVal;
        }
        if (posQryStr != null && posQryStr.indexOf("|") == 0)
            posQryStr = posQryStr.substring(1);

		gridsterObj=null;
		gridster=null;
		delete gridster;
		delete gridsterObj;
        return posQryStr;
    },
    resizeFn: function(cPanlId, pnlPositions, adjWidth, adjHeight) {
		var me = this;
		// Condition to handle resize the grid inside the rowBody JTM grid
		if(!Ext.isEmpty(insideGrid.Grid)){
			if(insideGrid.Grid.parentGridId == cPanlId){
				Ext.defer(function(){
				insideGrid.Grid.setWidth($('#'+cPanlId+' .x-grid-table').width() - 43);
				},200);
			}
		}
        var blkType = '';
        if (cPanlId != null && cPanlId != "undefined") {
            if (cPanlId.indexOf("_") > 0) {
                blkType = cPanlId.substr(0, cPanlId.indexOf("_"));
            } else {
                blkType = cPanlId;
            }
        }
        var panlObj = Ext.getCmp(cPanlId);
		if(blkType!=null && (blkType=='BarChart' || blkType=='TimelineChart' || blkType=='CombinedTimelineChart' || blkType=='areaChart' || blkType=='combinationChart' || blkType=='pieChart'))
		{
			if (panlObj!=null && panlObj.isInitialResizeCompleted == false) {
				return;
			}
		}
		var scrWidVal = (Ext.getBody().getViewSize().width - 40);
		var WidInPxl = (adjWidth / scrWidVal);
		WidInPxl = Ext.util.Format.round(WidInPxl, 2);
		var scrHeightVal = (Ext.getBody().getViewSize().height - 25);
		var heightInPxl = (adjHeight / scrHeightVal);
		heightInPxl = Ext.util.Format.round(heightInPxl, 2);
		switch (blkType) {
			case 'dialChart':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
					if (hCHart.container) {
						hCHart.width = adjWidth - 10;
						hCHart.height = adjHeight - 20;
					}
					hCHart.width = adjWidth - 200;
					hCHart.height = adjHeight - 20;
					Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 10);
					Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 10);
					Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 10);
					Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 10);
					var chart = jQuery('#'+renderTo).highcharts();
					Ext.defer(function(){
						chart.setSize(
							$('#'+panlObj.id)[0].offsetWidth, 
							$('#'+panlObj.id)[0].offsetHeight,
							true
						); 
					},200);
				}
				break;
			case 'TopNGaugeChart':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery('#'+renderTo).outerWidth();
					var height = jQuery('#'+renderTo).outerHeight();
					if (hCHart.container) {
						hCHart.width = adjWidth - 10;
						hCHart.height = adjHeight - 20;
					}
					var chart = jQuery('#'+renderTo).highcharts();
					Ext.defer(function(){
						chart.setSize(
							$('#'+panlObj.id)[0].offsetWidth, 
							$('#'+panlObj.id)[0].offsetHeight,
							true
						); 
					},200);
				}
				break;
			case 'BarChart':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
					if (hCHart.container) {
						hCHart.width = adjWidth;
						hCHart.height = adjHeight;
					}
					hCHart.width = adjWidth;
					if(panlObj.isTopNChart)
					{
						if(panlObj.chartType == 'column')
						{
							hCHart.height = adjHeight - 30;
						}else{
							var barHeightVal =  panlObj.barHeight;
							if(adjHeight>barHeightVal)
							{
								barHeightVal=adjHeight-30;
							}
							hCHart.height = barHeightVal;
							//hCHart.height = adjHeight - 40;
							hCHart.width = adjWidth-25;
						}
					}
					else
					{
						if(panlObj.chartType == 'column')
						{
							//hCHart.height = adjHeight - 50;
							hCHart.height = adjHeight - 35;
						}else{
							var barHeightVal =  panlObj.barHeight;
							if(adjHeight>barHeightVal)
							{
								barHeightVal=adjHeight-30;
							}
							hCHart.height = barHeightVal- 25;
							hCHart.width = adjWidth-25;
						}
					}
					//console.log("Gridster_adjHeight",adjHeight)
					//Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight);
					//Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight);
					//Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight);
					//Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight);
					panlObj.highChartObj.drawChart();
					//panlObj.doComponentLayout();
				}
				break;
			case 'TimelineChart':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
				//	if (hCHart.container) {
						hCHart.width = adjWidth;
						//hCHart.height = adjHeight-25;
						if(panlObj.isCurrentValAvail)
						{
							Ext.defer(function(){
								myDashApp.getController("Main").loadSummaryDetails(panlObj.id,panlObj,panlObj.chartData,panlObj.hideLegend);
								var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ cPanlId).getHeight();
								hCHart.height = ChartPnlHeight;
								panlObj.highChartObj.drawChart();
							},200);
						}else{
						hCHart.height = adjHeight-25;
							panlObj.highChartObj.drawChart();
						}
				//	}
					hCHart.width = adjWidth;
				/*	Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 70);*/
					//panlObj.highChartObj.drawChart();
				}
				break;
			case 'areaChart':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
				//	if (hCHart.container) {
						hCHart.width = adjWidth;
						//hCHart.height = adjHeight-25;
						if(panlObj.isCurrentValAvail)
						{
							Ext.defer(function(){
								myDashApp.getController("Main").loadSummaryDetails(panlObj.id,panlObj,panlObj.chartData,panlObj.hideLegend);
								var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ cPanlId).getHeight();
								hCHart.height = ChartPnlHeight;
								panlObj.highChartObj.drawChart();
							},200);
							//hCHart.height = adjHeight-75;
						}else{
						hCHart.height = adjHeight-25;
							panlObj.highChartObj.drawChart();
						}
				//	}
				//	hCHart.width = adjWidth;
					//hCHart.height = adjHeight;
				/*	Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 70);*/
					//panlObj.highChartObj.drawChart();
				}
				break;
			case 'combinationChart':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
				//	if (hCHart.container) {
						hCHart.width = adjWidth;
						//hCHart.height = adjHeight-25;
						if(panlObj.isCurrentValAvail)
						{
							//hCHart.height = adjHeight-75;
							Ext.defer(function(){
								myDashApp.getController("Main").loadSummaryDetails(panlObj.id,panlObj,panlObj.chartData,panlObj.hideLegend);
								var ChartPnlHeight = Ext.getCmp('ChartPnl_'+ cPanlId).getHeight();
								hCHart.height = ChartPnlHeight;
								panlObj.highChartObj.drawChart();
							},200);
						}else{
						hCHart.height = adjHeight-25;
							panlObj.highChartObj.drawChart();
						}
				//	}
				//	hCHart.width = adjWidth;
/*					Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight - 70);
					Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight - 70);*/
					
				}
				break;
			case 'CombinedTimelineChart':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
					if (hCHart.container) {
						hCHart.width = adjWidth;
						hCHart.height = adjHeight;
					}
					hCHart.width = adjWidth;
					hCHart.height = adjHeight - 30;
					Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight);
					panlObj.highChartObj.drawChart();
				}
				break;
			case 'pieChart':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
					var ChartPnlWidth = Ext.getCmp('ChartPnl_'+ cPanlId).getWidth();
					if (hCHart.container) {
						//hCHart.width = adjWidth;
						hCHart.width = ChartPnlWidth;
						hCHart.height = adjHeight;
					}
					//hCHart.width = adjWidth;
					hCHart.width = ChartPnlWidth;
					//hCHart.height = adjHeight - 30;
					hCHart.height = adjHeight - 38;
					Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight);
					panlObj.highChartObj.drawChart();
				}
				break;
			case 'servicehealth':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
					if (hCHart.container) {
						hCHart.width = adjWidth;
						hCHart.height = adjHeight;
					}
					hCHart.width = adjWidth;
					if(panlObj.hasOwnProperty('isInfraHealth') && panlObj.isInfraHealth==true)
					{
						hCHart.height = (adjHeight/2)-5;
					}
					else
					{
						hCHart.height = adjHeight-30;
					}
					panlObj.highChartObj.drawChart();
				}
				break;
				case 'networkhealth':
				if (panlObj.highChartObj != null) {
					var hCHart = panlObj.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
					if (hCHart.container) {
						hCHart.width = adjWidth;
						hCHart.height = adjHeight;
					}
					//hCHart.width = adjWidth-140;
					//hCHart.height = adjHeight - 20;
					hCHart.width = adjWidth;
					if(panlObj.hasOwnProperty('isnetworkHealth') && panlObj.isnetworkHealth==true)
					{
						hCHart.height = (adjHeight/2)-5;
						hCHart.width = (adjWidth/2)-5;
					}
					Ext.select('#' + panlObj.id + ' .timelineDiv').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' .timelineDiv > div').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' > .highcharts-container').setHeight(adjHeight);
					Ext.select('#' + panlObj.id + ' .highcharts-container > svg').setHeight(adjHeight);
					panlObj.highChartObj.drawChart();
				}
				break;
				case 'table':
					isResize = true;
					var grid = Ext.getCmp(cPanlId+'_Grid');
					if(!Ext.isEmpty(grid))
					{
						grid.store.filters.clear();
						var searchTextBoxObj=Ext.getCmp('searchTable_'+cPanlId);
						
						if(searchTextBoxObj != null)
						{
							searchTextBoxObj.disable();
							var searchValue = searchTextBoxObj.value ;
							if(searchValue != '')
							{
								searchTextBoxObj.reset();	
							}
						}
						var heightOfOneRow = 21;
						var heightForTable = (adjHeight / heightOfOneRow);
						var strHeightForTable = heightForTable.toString();
						var gSize ='';

						if(strHeightForTable.indexOf('.')>-1)
						{
							 gSize = strHeightForTable.split('.')[0];
						}else{
							gSize = heightForTable;

						}
						gSize = parseInt(gSize);
						grid.getStore().pageSize = gSize;
						grid.store.load();
						grid.getView().refresh();
					}
				break;
				case 'mapwidget':
					isResize = true;
					var profileName = Ext.getCmp('dashboardLayoutObj').profileName;	
					myDashApp.getController("Main").loadDataForBlock(panlObj, profileName, cPanlId,false);
					break;
            delete elementObj1;
        }
		var dashboardLayoutObj=Ext.getCmp('dashboardLayoutObj');
        var profName = dashboardLayoutObj.profileName;
		var isSharedDashboard = dashboardLayoutObj.isSharedDashboard;
		if(!isAnonymousUserAccess && (!isSharedDashboard || publicJson['myDashboardConfigDetails']['isAllwoedtoEditSharedDashboard']==true))
		{
			myDashApp.getController("Main").saveFluidDashboardWindowResizeConfig(profName, pnlPositions);
		}
		dashboardLayoutObj=null;
		delete dashboardLayoutObj;
    },
    addGridsterWidget: function(widgetName, widgetContent, widgetImgsrc, widgetTitle, id, sizeX, sizeY, colPos, rowPos, action,isTopNWidget) {
        var me = this;
		var gridsterObj = $(".gridster > ul.gridsterul"),
            gridster = gridsterObj.gridster().data('gridster');

		if(sizeX>this.maxCols)
		{
			sizeX=this.maxCols;
		}
		if(colPos>this.maxCols)
		{
			colPos=this.maxCols;
		}
		if((sizeX+colPos)>this.maxCols)
		{
			sizeX=(this.maxCols-colPos);
		}
        var widgetBtnArr = new Array();
        if (action != null && action == 'addWidget') {
            widgetBtnArr.push({
                xtype: 'button',
                baseCls: 'configButton',
                action: 'configme',
                flex: 1,
                html: '<div style="text-align:center;cursor:pointer"><span><img class="' + widgetImgsrc + ' "src="/final/images/clear.png" /></span></br><span>' + widgetTitle + '</span></div>',
                handler: function() {
                    myDashApp.getController("Main").fluidWindowModifyClick(this);
                }
            });
        }

		var showComboValue = false;
		var isConfiguredValue = false;
	
		if(action != null && action == 'addWidget')
		{
			isConfiguredValue = false;
			
			if(id.indexOf('ddTable')>-1)
			{
				showComboValue = false;
			}

		}else if(action != null && action == 'loadWidget')
		{
			var configWidgets = publicJson['myDashboardConfigDetails']['configIds'];
			
			if(configWidgets != null)
			{	
				if(configWidgets.indexOf(id) > -1)
				{
					isConfiguredValue = true;
					if(id.indexOf('ddTable')>-1 )
					{					
						showComboValue = true;
					}
				}else{
					isConfiguredValue = false;
					showComboValue = false;
				}
			}
		
		}
		var isSharedDashboard=false;
		if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('isSharedDashboard'))
		{
			if(publicJson['myDashboardConfigDetails']['isSharedDashboard'] == "true")
				isSharedDashboard=true;
		}
		 var isOneClickDashboard='false';
		 var oneClickDashboard=false;
		if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('IsOneClickDashboard'))
		{
			if(publicJson['myDashboardConfigDetails']['IsOneClickDashboard'] == "yes")
			{
				isOneClickDashboard='true';
				oneClickDashboard=true;
			}
		}
        switch (widgetName) {
            case 'table':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'table'
                };

                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
				
              //  Ext.suspendLayouts();
			   
               me.panelObj({
                    title: oneClickDashboard?'':tabluarViewTitle,
                    action: action,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: isConfiguredValue,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
					itemType: isOneClickDashboard,
                    renderTo: widgetConfig.widgetId,
					isTopNChart : isTopNWidget
                });

                /*  panel.el.highlight("ff0000", {
                      attr: "backgroundColor",
                      endColor: "ffffff",
                      easing: 'easeIn',
                      duration: 1000
                  });*/
				//$('#'+widgetConfig.widgetId).focus();
				
             //   Ext.resumeLayouts(true);
                //	$('#'+widgetConfig.widgetId).attr({"data-col":colPos, "data-row":rowPos, "data-sizex":sizeX, "data-sizey":sizeY});
                keepGoing = false;
                break;

            case 'ddTable':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'ddTable'
                };

                gridster.add_widget('<li tabindex="-1"  class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
            //    Ext.suspendLayouts();
               me.panelObj({
                    title: oneClickDashboard?'':ddTableTitle,
                    action: action,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: isConfiguredValue,
					showCombo:showComboValue, 
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
            //    Ext.resumeLayouts(true);
                //$('#'+widgetConfig.widgetId).attr({"data-col":colPos, "data-row":rowPos, "data-sizex":sizeX, "data-sizey":sizeY});
                keepGoing = false;
                break;

            case 'currentalarms':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'currentalarms'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
            //    Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':alertsTitle,
                    action: action,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: true,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
             //   Ext.resumeLayouts(true);
                //$('#'+widgetConfig.widgetId).attr({"data-col":colPos, "data-row":rowPos, "data-sizex":sizeX, "data-sizey":sizeY});
                keepGoing = false;
                break;
			 case 'vmAlarmsWidget':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'vmAlarmsWidget'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
            //    Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':vmAlarmsTitle,
                    action: action,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: isConfiguredValue,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
             //   Ext.resumeLayouts(true);
                //$('#'+widgetConfig.widgetId).attr({"data-col":colPos, "data-row":rowPos, "data-sizex":sizeX, "data-sizey":sizeY});
                keepGoing = false;
              break;
            case 'liveMeasuresBox':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'liveMeasuresBox'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
             //   Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':liveMeasTitle,
                    action: action,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: isConfiguredValue,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
           //     Ext.resumeLayouts(true);
                //$('#'+widgetConfig.widgetId).attr({"data-col":colPos, "data-row":rowPos, "data-sizex":sizeX, "data-sizey":sizeY});
                keepGoing = false;
                break;

				case 'TopNDigitalChart':

                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'TopNDigitalChart'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
             //   Ext.suspendLayouts();

               me.panelObj({
                    title: oneClickDashboard?'':digitalChartTitle,
                    action: action,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: isConfiguredValue,
                    bodyPadding: '10 10 10 10',
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId,
                    items: widgetBtnArr
                        /*	listeners:{
								afterrender:function(c){
									if(action!=null && action=='addWidget')
									{
										$({countNum: 5656 - 50}).animate({countNum: 5656}, {
											  duration: 2000,
											  easing:'linear',
											  step: function() {
												// What todo on every count
												$('#'+c.id+' .count').html(Math.floor(this.countNum));
												//console.log(Math.floor(this.countNum));
											  },
											  complete: function() {
												console.log('finished');
											  }
											});
									}
								}
							}*/

                });
				//$('#'+widgetConfig.widgetId).focus();

             //   Ext.resumeLayouts(true);

                keepGoing = false;
                break;

            case 'digitalChart':

                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'digitalChart'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
             //   Ext.suspendLayouts();

                me.panelObj({
                    title: oneClickDashboard?'':digitalChartTitle,
                    action: action,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: isConfiguredValue,
                    bodyPadding: '10 10 10 10',
                    renderTo: widgetConfig.widgetId,
					isSharedDashboard : isSharedDashboard,
                    items: widgetBtnArr
                        /*	listeners:{
								afterrender:function(c){
									if(action!=null && action=='addWidget')
									{
										$({countNum: 5656 - 50}).animate({countNum: 5656}, {
											  duration: 2000,
											  easing:'linear',
											  step: function() {
												// What todo on every count
												$('#'+c.id+' .count').html(Math.floor(this.countNum));
												//console.log(Math.floor(this.countNum));
											  },
											  complete: function() {
												console.log('finished');
											  }
											});
									}
								}
							}*/

                });
				//$('#'+widgetConfig.widgetId).focus();

             //   Ext.resumeLayouts(true);

                keepGoing = false;
                break;

            case 'BarChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'BarChart'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
            //    Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':barChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: id,
					isConfigured: isConfiguredValue,
					items: widgetBtnArr,
					widgetBtnArr : widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
					//isChart : true,
					isChart : showLegandPanelForWidgetsVal,
					//createLayoutOnStartup : true,
					createLayoutOnStartup : showLegandPanelForWidgetsVal,
                    renderTo: widgetConfig.widgetId,					
					isTopNChart : isTopNWidget
                });
				//$('#'+widgetConfig.widgetId).focus();
				
            //    Ext.resumeLayouts(true);

                keepGoing = false;
                break;

			case 'TopNGaugeChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'TopNGaugeChart'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
             //   Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':guageChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: id,
					isConfigured: isConfiguredValue,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();

            //    Ext.resumeLayouts(true);

                keepGoing = false;
           break;
            case 'dialChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'dialChart'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
             //   Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':guageChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: id,
					isConfigured: isConfiguredValue,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();

            //    Ext.resumeLayouts(true);

                keepGoing = false;
                break;

            case 'pieChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'pieChart',
                };
                gridster.add_widget('<li tabindex="-1"  class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
				
                //Adding Table content
            //    Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':pieChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: id,
					isConfigured: isConfiguredValue,
					items: widgetBtnArr,
					widgetBtnArr : widgetBtnArr,
					//isChart : true,
					isChart : showLegandPanelForWidgetsVal,
					//createLayoutOnStartup : true,
					createLayoutOnStartup : showLegandPanelForWidgetsVal,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
           //     Ext.resumeLayouts(true);

                keepGoing = false;
                break;

            case 'TimelineChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'TimelineChart'
                };
                gridster.add_widget('<li tabindex="-1"  class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
           //     Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':timeLineChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: id,
					isConfigured: isConfiguredValue,
					items: widgetBtnArr,
					widgetBtnArr : widgetBtnArr,
					//isChart : true,
					isChart : showLegandPanelForWidgetsVal,
					//createLayoutOnStartup : true,
					createLayoutOnStartup : showLegandPanelForWidgetsVal,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
			
            //    Ext.resumeLayouts(true);

                keepGoing = false;
                break;

            case 'areaChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'areaChart'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
           //     Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':areaChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: id,
					isConfigured: isConfiguredValue,
					items: widgetBtnArr,
					widgetBtnArr : widgetBtnArr,
					//isChart : true,
					isChart : showLegandPanelForWidgetsVal,
					//createLayoutOnStartup : true,
					createLayoutOnStartup : showLegandPanelForWidgetsVal,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
			
           //     Ext.resumeLayouts(true);

                keepGoing = false;
                break;
            case 'combinationChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'combinationChart'
                };
				//console.log("sizeX",sizeX);
				//console.log("sizeY####", sizeY);
				//console.log("colPos####", colPos);
				//console.log("maxCols####", maxCols);
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
         //       Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':combinationChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: id,
					isConfigured: isConfiguredValue,
					items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
					//isChart : true,
					isChart : showLegandPanelForWidgetsVal,
					widgetBtnArr : widgetBtnArr,
					//createLayoutOnStartup : true,
					createLayoutOnStartup : showLegandPanelForWidgetsVal,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
			
          //      Ext.resumeLayouts(true);

                keepGoing = false;
                break;
            case 'CombinedTimelineChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'CombinedTimelineChart'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
          //      Ext.suspendLayouts();
               me.panelObj({
                    title: oneClickDashboard?'':lineChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: isConfiguredValue,
                    action: action,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
					//isChart : true,
					isChart : showLegandPanelForWidgetsVal,
					//createLayoutOnStartup : true,
					createLayoutOnStartup : showLegandPanelForWidgetsVal,
					widgetBtnArr : widgetBtnArr,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
          //      Ext.resumeLayouts(true);

                keepGoing = false;
                break;

            case 'tierhealth':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'tierhealth'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
         //       Ext.suspendLayouts();
               me.panelObj({
                    title: oneClickDashboard?'':tierHealthTitle,
                    action: action,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: true,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
			
         //       Ext.resumeLayouts(true);
                keepGoing = false;
                break;

            case 'servicehealth':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'servicehealth'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
         //       Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':healthPieChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: true,
                    action: action,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
           //     Ext.resumeLayouts(true);

                keepGoing = false;
                break;
		case 'networkhealth':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'networkhealth'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
         //       Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':networkhealthPieChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: true,
                    action: action,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
           //     Ext.resumeLayouts(true);

                keepGoing = false;
                break;
            case 'weather':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'weather'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w no_resize"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
         //       Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':weatherTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: true,
                    action: action,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
           //     Ext.resumeLayouts(true);

                keepGoing = false;
                break;

            case 'news':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'news'
                };
                gridster.add_widget('<li tabindex="-1"  class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
           //     Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':newsTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: true,
					action: action,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
           //     Ext.resumeLayouts(true);

                keepGoing = false;
                break;
			case 'heatMapChart':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'heatMapChart'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
            //    Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':heatMapChartTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: id,
					isConfigured: isConfiguredValue,
                    items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
             //   Ext.resumeLayouts(true);

                keepGoing = false;
                break;
				case 'mapwidget':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'mapwidget'
                };
                gridster.add_widget('<li tabindex="-1" id="' + widgetConfig.widgetId + '"  class="gs_w" widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
         //       Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':MapsTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: true,
                    action: action,
                    items: widgetBtnArr,
					isSharedDashboardresize : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
				
           //     Ext.resumeLayouts(true);

                keepGoing = false;
                break;
			case 'health':
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: id + "_widget",
                    widget_name: 'health'
                };
                gridster.add_widget('<li tabindex="-1" id="' + widgetConfig.widgetId + '"  class="gs_w" widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
         //       Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':healthTitle,
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    id: id,
					isConfigured: true,
                    action: action,
                    items: widgetBtnArr,
					isSharedDashboardresize : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
           //     Ext.resumeLayouts(true);
                keepGoing = false;
                break;
            default:
				var dashboardLayoutObj=Ext.getCmp('dashboardLayoutObj');
                var profName = dashboardLayoutObj.profileName;
				var emptyBlkId=id;
                var widgetConfig = {
                    col: colPos,
                    row: rowPos,
                    size_x: sizeX,
                    size_y: sizeY,
                    widgetId: emptyBlkId + "_widget",
                    widget_name: 'unconfiguredwidget'
                };
                gridster.add_widget('<li tabindex="-1" class="gs_w"  id="' + widgetConfig.widgetId + '"  widgetname="' + id + '"/>', sizeX, sizeY, colPos, rowPos);
                //Adding Table content
            //    Ext.suspendLayouts();
                me.panelObj({
                    title: oneClickDashboard?'':'UnconfiguredWidget',
                    width: $('#' + widgetConfig.widgetId).width(),
                    height: $('#' + widgetConfig.widgetId).height(),
                    action: action,
                    id: emptyBlkId,
             //       items: widgetBtnArr,
					isSharedDashboard : isSharedDashboard,
                    renderTo: widgetConfig.widgetId
                });
				//$('#'+widgetConfig.widgetId).focus();
             //   Ext.resumeLayouts(true);
           //     alert('SOME PROBLEM WITH DATA');
                keepGoing = false;
                break;


        }

        //$(".gridster > ul").width($('#dashboardLayoutObj-body').width());
        $(".gridster > ul.gridsterul > li").draggable({
            cursorAt: {
                top: 0,
                left: 0
            },
            handle:'.x-panel-header-text-container, .x-panel-header-text-container span, li label',
            scroll: true,
            iframeFix: true,
            containment: "#dashboardLayoutObj-body"
        }); //GRT FIX
		
	/*	$( "gridster > ul.gridsterul > li" ).resizable({
		 // maxWidth: 300
		});*/
		
        //Ext.select('.gridsterpanel').scroll('b', Ext.get(widgetConfig.widgetId).getHeight(), true);
		gridster=null;
		delete gridster;
		gridsterObj=null;
		delete gridsterObj;
    },
    initComponent: function() {
		
		this.deafault_widget_base_dimensions =[170,170],
		increasebyPixel = 2,
			w = window,
			d = document,
			e = d.documentElement,
			g = d.getElementsByTagName('body')[0],
			x = w.innerWidth || e.clientWidth || g.clientWidth,
			y = w.innerHeight || e.clientHeight || g.clientHeight;
		var calculatedBaseDimensionX=x*0.10485;
		var calculatedBaseDimensionY=y*0.1500;//3732;

		if(isNaN(calculatedBaseDimensionX))
		{
			calculatedBaseDimensionX=130;
		}
		calculatedBaseDimensionX=Ext.util.Format.round(calculatedBaseDimensionX,0);
		if(isNaN(calculatedBaseDimensionY))
		{
			calculatedBaseDimensionY=240;
		}
		calculatedBaseDimensionY=Ext.util.Format.round(calculatedBaseDimensionY, 0);
		var xMargin=3;

/*
		if (x <= 1024){
			calculatedBaseDimensionX=x*0.0972; // 70 dimension/720px=0.0972
			xMargin=x*0.0052777777777778; // 3.9 margin/720px=0052777777777778
		}
		else if (x <=1300){
			xMargin=2;
		}
		else if (x <=1399){
			xMargin=2.5;
		}
		else
		{
			xMargin=x*0.0021961932650073;
			xMargin=Ext.util.Format.round(xMargin, 0);
		}
*/

		if (Ext.isChrome)
		{
			calculatedBaseDimensionX=((x-12)/9)-10;
			xMargin=4;
		}
		else
		{
			calculatedBaseDimensionX=((x-20)/9)-10;
			xMargin=4;
		}

		this.deafault_widget_base_dimensions=[calculatedBaseDimensionX,calculatedBaseDimensionY];
		this.default_margins=[xMargin,xMargin];

		this.settingWidth = parseInt(x - 45);
		$("#gridsterpanel").empty();
		$("#gridsterpanel").append(this.createGridsterTags);
		var gridsterObj=this.createGridsterObj();
		gridsterObj=null;
		delete gridsterObj;
		this.callParent();

    }
});