Ext.define('MyDashBoard.view.HealthWidgetPopupWindow',{
	extend:'Ext.window.Window',
	alias:'widget.healthwidgetpopupwindow',
	title:'',
	resizable:false,
	/*header:{
		height:32,
		padding:'0 10',
		style:{'border-width':'0px 0px 0px 0px !important'},
		margin:0
	},*/
	cls:'myDashboardwindow',
	ui:'newPopupWindow  newplainHeader',
	bodyPadding:0,
	ghost:false,
    frame:true,
	padding:0,
	border:false,
	modal:true,
	height:strSkin == "Light" ? 530 : 530,
	width:strSkin == "Light" ? 818 : 798,
	layout:'fit',
	closeAction : 'destroy',
	dashBoardAction : '',
	profileName : '',
	HealthPopUpData:'',
	isHideProblemAnalyticsTab:false,
	compName:'',
	componentType:'',
	blockId:'',
	initComponent: function () {
        var HealthPopUpData = this.HealthPopUpData;
		var profileName = this.profileName;
		var blockId = this.blockId;
		var compName = this.compName;
		var componentType = this.componentType;
		var isHideProblemAnalyticsTab = this.isHideProblemAnalyticsTab;
		this.suspendEvents(true);
		this.createCommonBlockLayout(profileName,blockId,compName,componentType,HealthPopUpData,isHideProblemAnalyticsTab);
		this.resumeEvents();
        this.callParent();
    },
	createCommonBlockLayout: function (profileName,blockId,compName,componentType,HealthPopUpDataforKeyMetrics,isHideProblemAnalyticsTab) {
		this.items = [
		{
			xtype : 'tabpanel',
			layout: {
					type: 'vbox',
					align:'stretch'
			},
			tabBar: {
				dock: 'top',
				layout: {
					pack: 'start'
				}
			},
			frame:false,
			border:false,
			padding:0,
			defaults:{
				padding:'0 0 0 0',
			},
			ui:'hwTabPanel',
			listeners: {
				'tabchange': function( tabPanel, newCard, oldCard, eOpts ) {
					var tabPanelId = tabPanel.getActiveTab().id;
					var selectedTab ='';
					if(tabPanelId!=null && tabPanelId=='problemAnalytics_'+blockId)
					{
						selectedTab = 'ProblemAnalytics';
					}
					else if(tabPanelId!=null && tabPanelId=='keyMetrics_'+blockId)
					{
						selectedTab = 'KeyMetrics';
					}
					var profileName=publicJson['myDashboardConfigDetails']['profileName'];
					var paramsForData = "comesFrom=myDashboard&action=loadHealthPopup&profileName=" + encodeURIComponent(profileName)+"&blockId="+blockId+"&selectedComp="+compName+"&selectedTab="+selectedTab+"&compType="+componentType;
					if (isAnonymousUserAccess) {
						paramsForData = paramsForData + '&anonymousUser=true';
					}
					Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
						method : 'POST',
						params: paramsForData,
						scope:this,
						success: function(response)
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							var HealthPopUpData = jsonData['HealthPopUpData'];
							var errorMesg = HealthPopUpData['errorMsg'];
							if(errorMesg!=null && errorMesg=="-")
							{
								if(newCard.title=='Problem Analytics')
								{
									var ProblemAnalyticsData = HealthPopUpData['ProblemAnalyticsData'];
									if(ProblemAnalyticsData!=null && !Ext.isEmpty(ProblemAnalyticsData))
									{
										var AlertsCntData = ProblemAnalyticsData['AlertsCntData'];
										Ext.getCmp('alertCntView_container_'+blockId).show();
										Ext.getCmp('alertCntView_'+blockId).update(AlertsCntData);
										Ext.getCmp('alertsGrid_'+blockId).show();
										Ext.getCmp('alertsGrid_'+blockId).getStore().loadData(ProblemAnalyticsData['gridData']);
										Ext.getCmp('alertsGrid_'+blockId).view.refresh();
									}
								}
								else
								{
									Ext.getCmp('dataViewID_'+blockId).update(HealthPopUpData);
								}
							}
							else
							{
								if(newCard.title=='Problem Analytics')
								{
									Ext.getCmp('alertCntView_container_'+blockId).hide();
									if(Ext.isEmpty(Ext.getCmp('error_con'))){
									Ext.getCmp(newCard.id).add({xtype:'container', flex:1, id:'error_con', html:'<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" ><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>' + errorMesg	+ '!</div></td></tr></table>'});
									}
									Ext.getCmp('alertsGrid_'+blockId).hide();

								}
								else
								{
									Ext.getCmp('dataViewID_'+blockId).update('<table border="0" cellspacing="0" cellpadding="0" width="100%" height="90px"><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>' + errorMesg
									+ '!</div></td></tr></table>');
								}
							}
						}
					});
				}
			},
			items : [{
				title: 'KPI',
				id:'keyMetrics_'+blockId,
				autoScroll:true,
				scroll:true,
				items : {
					xtype : 'panel',
					margin:'10 0 0 10',
					layout:{type:'vbox',align:'stretch'},
					items : [
						{
							xtype : 'dataview',
							id:'dataViewID_'+blockId,
							scroll : true,
							layout : 'fit',
							flex : 1,
							store : Ext.data.Store({
								fields : [{ name:'errorMsg', type:'string'},{ name:'KeyMetricsData', type:'array'},{ name:'Measure', type:'string'},{ name:'unit', type:'string'},{ name:'descriptor', type:'string'},{ name:'MeasureState', type:'string'},{ name:'layerURL', type:'string'},{ name:'BgColorcls', type:'string'},{ name:'stateIconcls', type:'string'},{name:'Title',type:'string'},{name:'MeasureValue',type:'string'}],
								data : [HealthPopUpDataforKeyMetrics]
							}),
							tpl : new Ext.XTemplate(
								'<tpl for=".">',
								'<tpl if="errorMsg.trim() === \'-\'">',
									'<tpl for="KeyMetricsData">',
										'<tpl for=".">',
										'<div class="hwKeyMetricsWidth {BgColorcls}">',
											'<table  cellpadding="0" cellspacing="0" border="0px">',
												'<thead>',
													'<tr>',
														'<th colspan="3" >',
															'<tpl if="!Ext.isEmpty(descriptor)">',
																'<div data-qclass=\'yellowTip\' data-qtip="{Measure} {{descriptor}}" >',
																	'<tpl if="layerURL.trim() === \'-\'">',
																		'<span style="font-size: 12px;color:#ffffff">{Measure} {{descriptor}}</span>',
																	'<tpl else>',
																		'<a href=\'javascript:wayToLayerModel("{layerURL}")\'> {Measure} {{descriptor}} </a>',
																	'</tpl>',
																'</div>',
															'<tpl else>',
																'<div data-qclass=\'yellowTip\' data-qtip="{Measure}">',
																	'<tpl if="layerURL.trim() === \'-\'">',
																		'<span style="font-size: 12px;color:#ffffff">{Measure}</span>',
																	'<tpl else>',
																		'<a href=\'javascript:wayToLayerModel("{layerURL}")\'>{Measure}</a>',
																	'</tpl>',
																'</div>',
															'</tpl>',
														'</th>',
													'</tr>',
												'</thead>',
												'<tbody>',
													'<tr>',
														'<tpl if="layerURL.trim() === \'-\'">',
															'<td style="height:100%;vertical-align:middle;align:center;width:30px" ><img src="/final/images/spacer.gif" class="{stateIconcls}" /></td>',
															'<td style="height:100%;vertical-align:middle;width:80px" align="left" ><div class="measureStateText"><span style="font-size:12px;color:#ffffff">{MeasureState}</span> </div></td>',
															'<td style="height:100%;vertical-align:middle;align:left" ><div class="measureValueText"><span style="font-size: 12px;color:#ffffff">{MeasureValue}</span><br/>',
															'<tpl if="!Ext.isEmpty(unit)">',
																'<span class="unitValue">',
																'<span style="font-size: 12px;color:#ffffff">({unit})</span></span>',
															'</tpl>',
															'</div></td>',
														'<tpl else>',
															'<td style="height:100%;vertical-align:middle;align:center;width:30px" ><a href=\'javascript:wayToLayerModel("{layerURL}")\'><img src="/final/images/spacer.gif" class="{stateIconcls}" /></a></td>',
															'<td style="height:100%;vertical-align:middle;width:80px" align="left" ><div class="measureStateText"><a href=\'javascript:wayToLayerModel("{layerURL}")\'>{MeasureState} </a></div></td>',
															'<td style="height:100%;vertical-align:middle;align:left" ><div class="measureValueText"><a href=\'javascript:wayToLayerModel("{layerURL}")\'><span style="font-size:12px;">{MeasureValue}</span><br/>',
															'<tpl if="!Ext.isEmpty(unit)">',
																'<span class="unitValue">({unit})</span>',
															'</tpl>',
															'</a></div></td>',
														'</tpl>',
													'</tr>',
												'</tbody>',
											'</table>',
										'</div>',
									'</tpl>',
									'</tpl>',
									'<tpl else>',
										'<tpl for=".">',
											'<div style="height:350px">',
												'<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">',
													'<tr>',
														'<td align="center" valign="middle" class="msgFont">',
															'<div class="iconInformation"></div>',
															'<div>{errorMsg}!</div>',
														'</td>',
													'</tr>',
												'</table>',
											'</div>',
										'</tpl>',
									'</tpl>',
								'</tpl>'
							),
							autoScroll : true,
							deferEmptyText:true,
							itemSelector : 'div.x-data-bar',
							emptyText : 'No Measures available'
						}
					]
				}
			},
			{
				title: 'Problem Analytics',
				id:'problemAnalytics_'+blockId,
				layout:{
					type:'vbox',
					align:'stretch',
				},
				hidden: isHideProblemAnalyticsTab,
				items : [
				{
						xtype:'container',
						cls:'hwProblemAnalyticsBg',
						id:'alertCntView_container_'+blockId,
						hidden:true,
						layout:{
							type:'vbox',
							align:'stretch',
						},
						items:[
						{
							xtype:'container',
							html:'<p style="padding:8px 5px 5px 10px">Summary</p>',
						},
						{

							xtype: 'dataview',
							id:'alertCntView_'+blockId,
							fields : [{ name:'stateBg', type:'string'},{ name:'stateSymbol', type:'string'},{ name:'state', type:'string'},{ name:'value', type:'number'}],
							data:[								
							],
							padding:'0 0 10 10',
							emptyText : 'No data',
							tpl: new Ext.XTemplate(
									'<tpl for=".">',
											'<table  border="0px" class="hwProblemAnalyticsStateTableBg">',
												'<tr>',
													'<td class="{stateBg}" style="width:40px;height:40px;"><img src="/final/images/clear.png" class="{stateSymbol}" style="margin-top:12px"></td>',
													'<td class="summaryStateText" align="left">{state}</td>',
													'<td class="summaryStateValue">{value}</td>',
												'</tr>',
											'</table>',
									'</tpl>'
							),
						}
					]
				},
				{
					xtype:'grid',
					id:'alertsGrid_'+blockId,
					autoScroll:true,
					scroll:true,
					margin:10,
					flex:1,
					layout:{
						type:'fit',
						align:'stretch',
					},
					hideHeaders: true,
					border:false,
					frame:false,
					cls :'gridSkin noShadow',
					style:{'border-width':'0px !important','box-shadow':'none !important'},
					store : Ext.data.Store({
						fields : ['STATE','ALERT_DESC','StartTime','layermodelLink','measureGrpUrl','ddUrl','mouseOverAckDiv'],
						data : []
					}),
					columns: [
						{
							width:35,
							style:{
								'text-overflow':'none',
								'padding-right':'0px'
							},
							dataIndex: 'STATE',
							renderer : function(value, metaData, record, row, col, store, gridView) {
									var mouseOverAckDiv = record.get('mouseOverAckDiv');
									if(!Ext.isEmpty(mouseOverAckDiv))
									{
										return '<div data-qtip="' + mouseOverAckDiv + '" data-qclass="gridCellTooltip alarmTip"><img style="vertical-align:middle;display:inline-block;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="'+ record.get('STATE')+'" border="0px" /></div>';
									}
									else
									{
										return '<div><img style="vertical-align:middle;display:inline-block;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="'+ record.get('STATE')+'" border="0px" /></div>';
									}
							}
						},
						{
							flex: 1,
							dataIndex: 'ALERT_DESC',
							renderer : function(value, metaData, record, row, col, store, gridView) {
								var layerModelUrl=record.get('layermodelLink');
								layerModelUrl=decodeURI(layerModelUrl);

								if(!isAnonymousUserAccess && layerModelUrl!="-")
								{
									return '<div data-qtip="' + value + '"><a href=\'javascript:wayToLayerModel("' + layerModelUrl + '")\'>' + value + '</a></div>';
								}
								else
								{
									return '<div data-qtip="' + value + '">' + value + '</div>';
								}
							}
						},
						{
							width:150,
							dataIndex: 'StartTime',
							renderer : function(value, metaData, record, row, col, store, gridView) {
								return '<div data-qtip="' + value + '">' + value + '</div>';
							}
						},
						{
							dataIndex: 'measureGrpUrl',
							width:30,
							renderer : function(value, metaData, record, row, col, store, gridView) {
								var measGrpUrl=record.get('measureGrpUrl');
								measGrpUrl=decodeURI(measGrpUrl);
								var measureUrl=measGrpUrl.substring(0,measGrpUrl.indexOf("?"));
								var measUrlParams=measGrpUrl.substring(measGrpUrl.indexOf("?")+1);

								if(measUrlParams.indexOf("\\")>0)
								{
									measUrlParams=measUrlParams.replace("\\","\\\\");
									measGrpUrl=measureUrl+"?"+measUrlParams;
								}
								if(!isAnonymousUserAccess &&measGrpUrl!="-")
								{
									return '<span><a href=\'javascript:loadcomponentMeasureTabset("' + measGrpUrl + '")\'><img style="vertical-align:middle;display:inline-block;margin-right:5px" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconLineChart" /></a></span>';
								}
								else
								{
									return "";
								}
							}
						},
						{
							width:30,
							dataIndex: 'ddUrl',
							renderer : function(value, metaData, record, row, col, store, gridView) {
								var ddUrl=record.get('ddUrl');
								ddUrl=decodeURI(ddUrl);
								var detailUrl=ddUrl.substring(0,ddUrl.indexOf("?"));
								var ddUrlParams=ddUrl.substring(ddUrl.indexOf("?")+1);

								if(ddUrlParams.indexOf("\\")>0)
								{
									ddUrlParams=ddUrlParams.replace("\\","\\\\");
									ddUrl=detailUrl+"?"+ddUrlParams;
								}
								
								if(!isAnonymousUserAccess && ddUrl!="-")
								{
									return '<span><a href=\'javascript:loadcomponentMeasureTabset("' + ddUrl + '")\'><img style="vertical-align:middle;display:inline-block;margin-right:5px" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconDiagnosis" /></a></span>';
								}
								else
								{
									return "";
								}
							}
						}
					]
				}]
			}]
		}]
	},
	listeners : {
		'close' :  function()
		{
			isHealthPopupOpened=false;
		}
	}
});