/*	Combination of Highchart and Ext js Template
		Include the script : script src="https://code.highcharts.com/modules/heatmap.js
		Heat map circle is modfied in the heatmap.js
*/
// jquery plugin to find scroll inside div
(function($) {
    $.fn.has_scrollbar = function() {
        var divnode = this.get(0);
        if (divnode.scrollHeight > divnode.clientHeight) {
            return true;
        }
    }
})(jQuery);
Ext.define('MyDashBoard.view.HeatMapPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.heatmappanel',
    bodyPadding: 0,
    layout: {
        type: 'hbox',
        align: 'stretch',
        pack: 'center'
    },
    title: 'Heatmap',
    flex: 1,
    ui: 'heatmappanel',
    heatmapWidth: 70,
    heatmapHeight: 70,
    heatmapRows: 10,
    heatmapCols: 10,
    cellDim: function(total, cells) {
        var me = this;
        return Math.floor(total / cells)
    },
    rowHeight: function() {
        var me = this;
        return me.cellDim(me.heatmapHeight, me.heatmapRows)
    },
    colWidth: function() {
        var me = this;
        return me.cellDim(me.heatmapWidth, me.heatmapCols)
    },
    heatMapSVG: function(selector, data) {
        var me = this;
		var cursor = 'pointer';
		var enableClick = true;
		if(isPublishedDashboard)
		{
			cursor = 'default';
			enableClick = false;
		}

        var chart = d3.select(selector)
            .append("svg")
            .attr("class", "chart")
            .attr("width", me.colWidth() * me.heatmapCols)
            .attr("height", me.rowHeight() * me.heatmapRows)
            .append("g")
            .attr("transform", "translate(67,3) rotate(90)");
        var circle = chart.selectAll("circle").data(data);
        circle.enter().append("circle")
            .attr("cx", function(d, i) {
                return Math.floor(i / me.heatmapRows) * me.colWidth();
            })
            .attr("cy", function(d, i) {
                return i % me.heatmapRows * me.rowHeight();
            })
            .attr("r", 2.5)
            .style("fill", function(d) {
                return '#ffffff'
            })
            .transition()
            .duration(200)
            .style("fill", function(d) {
                return d.colorx;
            })
	    .attr("data-qclass","heatmap_tooltip")	
	    .attr("data-qtip", function(d){
		if (strSkin=='Dark')
		{
			return '<div class="heatmap_tooltip_inner"><span style="color:'+d.colorx+'; border:none !important; padding:5px 5px" >'+d.toolTipVal+'</b></span></div>';
		}
		else
		{
			return '<div class="heatmap_tooltip_inner"><span style="color:'+d.colorx+'; border:1px solid '+d.colorx+'; padding:5px 5px" >'+d.toolTipVal+'</b></span></div>';
		}
	    })
            .style("cursor", cursor)
            .attr("class", 'heatmap');
        circle.on("click", function(d, i) {
			if(enableClick){
				if (d3.event.defaultPrevented) return;
				if (!Ext.isEmpty(d.graphLayerModelDrillDownURL)) {
					goToLayerModel(d.graphLayerModelDrillDownURL);
				}
			}
        });
        circle.exit().remove();
    },
    updateheatMapSVG: function(data) {
        d3.selectAll("heatmap").data(data)
            .style("fill", function(d) {
                return '#ffffff'
            })
            .transition()
            .duration(200)
            .style({
                "fill": function(d) {
                    return d.colorx
                }
            });
    },
    data: [],
    updateData: function(data) {
        var me = this; //,chartObj = $('#'+me.id+'-heatmap').highcharts();
        //if(!Ext.isEmpty(chartObj)){
        //me.heatChart(me.id+'-heatmap', data);
       // console.log('data-> upsd-> ', data);
        me.updateheatMapSVG(me.data[0].heatmapchart)
        me.heatMapTemplate().update(me.data[0].heatmapdata);
        //}
    },
    heatMapTemplate: function() {
        var me = this,
            template = {};
        console.log(Ext.isEmpty(me.data))
        if (Ext.isEmpty(me.data)) {
            template = new Ext.Template('No Data Available');
        } else {
			if(!isPublishedDashboard)
			{
				template = new Ext.XTemplate(
					'<tpl for=".">',
					'<ul style="display: table;margin-right: auto;margin-left: auto;top: 50%;bottom: 50%;margin: auto; position: inherit; width:100%;" class="ullist">',
					'<tpl if="thershold">',
					'<tpl for="thershold">',
					'<li style="display: table-cell;list-style-type: none;margin: 10px;vertical-align: middle;"  class="itemselect">',
					'<div>{state}</div>',
					'</li>',
					'</tpl>',
					'</tpl>',
					'<tpl for="heatmapdata">',
					'<li  style="display: inline-block;list-style-type: none;vertical-align: middle;margin: 10px;max-width:80px;min-width:120px" >',
					'<div style="text-align: center;">',
					'<div><span data-qtip="{datavalue}%" class="font_r_l_21">{datavalue}</span><span  class="font_r_l_15">%</span></div>',
					'<tpl if="MeasureLayerURL != \'-\'">',
					'<div style="color:{colors};margin:0px auto;font-size:12px;" data-qtip="{name}"><a href="javascript:void(0);" onclick="javascript:goToLayerModel(\'{MeasureLayerURL}\');" style="color:{colors}; text-overflow: ellipsis;overflow: hidden;display: block;">{name}</a></div>',
					'<tpl else>',
					'<div style="color:{colors};margin:0px auto;font-size:12px;" data-qtip="{name}" style="color:{colors};">{name}</a></div>',
					'</tpl>',
					'<div class="font_r_l_10"  style="text-aliagn:center" data-qtip="{MeasureValue}">({MeasureValue})</div>',
					'<tpl if="MeasCompName != \'-\'">',
					'<div class="font_r_l_10"  style="text-aliagn:center" data-qtip="{MeasCompName}">{MeasCompName}</div>',
					'</tpl>',
					'</li>',
					'</tpl>',
					'</ul>',
					'</tpl>',

					{

						loadUrl: function(value) {
							var decodeURI = decodeURIComponent(value);
							return "goToLayerModel('" + decodeURI + "')";
						}
					}
				);
			}else{
				template = new Ext.XTemplate(
					'<tpl for=".">',
					'<ul style="display: table;margin-right: auto;margin-left: auto;top: 50%;bottom: 50%;margin: auto; position: inherit; width:100%;" class="ullist">',
					'<tpl if="thershold">',
					'<tpl for="thershold">',
					'<li style="display: table-cell;list-style-type: none;margin: 10px;vertical-align: middle;"  class="itemselect">',
					'<div>{state}</div>',
					'</li>',
					'</tpl>',
					'</tpl>',
					'<tpl for="heatmapdata">',
					'<li  style="display: inline-block;list-style-type: none;vertical-align: middle;margin: 10px;max-width:80px;min-width:120px" >',
					'<div style="text-align: center;">',
					'<div><span data-qtip="{datavalue}%" class="font_r_l_21">{datavalue}</span><span  class="font_r_l_15">%</span></div>',
					'<tpl if="MeasureLayerURL != \'-\'">',
					'<div style="color:{colors};margin:0px auto;font-size:12px;" data-qtip="{name}"><span style="color:{colors};">{name}</span></div>',
					'<tpl else>',
					'<div style="color:{colors};margin:0px auto;font-size:12px;" data-qtip="{name}" style="color:{colors};">{name}</a></div>',
					'</tpl>',
					'<div class="font_r_l_10"  style="text-aliagn:center" data-qtip="{MeasureValue}">({MeasureValue})</div>',
					'<tpl if="MeasCompName != \'-\'">',
					'<div class="font_r_l_10"  style="text-aliagn:center" data-qtip="{MeasCompName}">{MeasCompName}</div>',
					'</tpl>',
					'</li>',
					'</tpl>',
					'</ul>',
					'</tpl>',

					{

						loadUrl: function(value) {
							var decodeURI = decodeURIComponent(value);
							return "goToLayerModel('" + decodeURI + "')";
						}
					}
				);
			}

        }
        var heatmapObj = Ext.create('Ext.view.View', {
            flex: 1,
            itemSelector: "li.itemselect",
            autoScroll: true,
            cls: 'viewcon',
            listeners: {
                resize: function() {
					//@ updating the center position of UL tag
                    if ($('#' + me.id + ' .viewcon').has_scrollbar()) {
                        $('#' + me.id + ' .ullist').css({
                            'position': 'relative',
                            'top': '0'
                        });
                    } else {
                        $('#' + me.id + ' .ullist').css({
                            'position': 'inherit',
                            'top': '50%'
                        });
                    }
                },
                viewready: function() {

                    //@updating the template

                    var heatID = me.id + 'heatID';
                    if (!Ext.isEmpty(Ext.get(heatID))) {
                        me.heatMapSVG("#" + heatID, me.data[0].heatmapchart);
                    }

                }
            },
            data: me.data,
            tpl: template
        });

        return heatmapObj;
    },

    initComponent: function() {
        var me = this,heatID = me.id + 'heatID';
        me.items = [{
            xtype: 'container',
            width: 71,
            margin: '0 10 0 10',
            html: '<div id= "' + heatID + '" style="width:71px;height:78px;vertical-align: middle;position: absolute;top: 0;bottom: 0;margin: auto;right:0"></div>'
        }, {
            xtype: me.heatMapTemplate(),
            flex: 1
        }]
        me.callParent();
    }
});