Ext.define('MyDashBoard.view.IconLibrary', {
	alias: 'widget.iconLibrary',
	extend: 'Ext.window.Window',
	height: 330,
	width: 715,
	autoScroll: false,
	scroll: false,
	closeAction: 'destroy',
	resizable: false,

	ghost: false,
	//cls:'myDashboardwindow',
	cls: 'iconLibraryWindow',
	ui: 'newPopupWindow   newplainHeader_border',
	bodyPadding: 0,
	id: 'iconLibWindow',
	frame: false,
	padding: 0,
	bodyPadding: 0,
	margin: 0,
	border: 0,
	modal: true,
	title: iconLLibraryLbl,
	from: '',
	windowId: '',
	custUploadPath: '',
	profileName: '',
	defaultClass: '',
	widgetID: '',
	widgetType: '',
	layout: {
		type: 'border',
		align: 'stretch'
	},
	/*listeners: {
				show:function(e){
					var dom = Ext.dom.Query.select('.x-mask');
					var el = Ext.fly(dom[0]);
					el.addCls('background_modal');
				}
			},*/
	initComponent: function () {

		var mee = this;
		var defaultIconSelectionSize = 32;
		if (mee.from != null && mee.from == 'digitialChartWidget') {
			defaultIconSelectionSize = 48;
		}

		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egMyDashboardController?action=loadIconLibData',
			method: 'GET',
			timeout: 60000,
			//params:{id:1},
			headers: {
				'Content-Type': 'application/json'
			},
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var Usericon2 = Ext.define('Usericon', {
					extend: 'Ext.data.Model',
					fields: [{
							name: "title",
							type: "string"
						},
						{
							name: "imageSrc",
							type: "string"
						},
						{
							name: "group",
							type: "string"
						},
						{
							name: "tag",
							type: "array"
						},
						{
							name: "size",
							type: "array"
						}
					]
				});

				var TemplateStore2 = Ext.create('Ext.data.Store', {
					model: Usericon2,
					data: jsonData.root[1].icons
				});

				var Treestore = Ext.create('Ext.data.TreeStore', {
					autoLoad: true,
					fields: [{
						name: 'text',
						type: 'string'
					}],
					root: {
						expanded: false,
						children: jsonData.root[0].children
					}
				})

				var updateData = {
					"size": defaultIconSelectionSize
				};

				function loadTemplte(updateData) {
					//console.log('updateData--->',updateData);
					var imageTpl = new Ext.XTemplate(
						'<tpl for=".">',
						'<div style="float:left;margin:6px" class="iconLibraryImageBorder">',
						'<tpl for="size">',
						'<tpl if="this.returnSize(values,' + updateData.size + ')">',
						'<div class="{' + updateData.size + '}" data-qtip="{parent.title}"></div>',
						'</tpl>',
						'</tpl>',
						'<tpl if="this.returnIMG(imageSrc)">',
						'<img src="{imageSrc}" class="customImg" style="display:none" data-qtip="{title}" />',
						'</tpl>',
						'</div>',
						'</tpl><div style="clear:both"></div>', {
							disableFormats: true,
							returnIMG: function (imageSrc) {
								if (imageSrc == "none") {
									return false;
								} else {
									return imageSrc;
								}
							},
							returnSize: function (size, number) {
								if (size == "none") {
									return false;
								} else {
									for (var i in size) {
										if (number == i) {
											return size[i]
										}
									}
								}
							}
						}
					);
					return imageTpl;
				}
				mee.add([{
					region: 'west',
					//width:150,
					split: true,
					layout: 'fit',
					defaults: {
						margin: 0,
						cls: 'font_text'
					},
					items: [{
						width: 112,
						//height: 150,
						store: Treestore,
						rootVisible: false,
						activeItem: 1,
						xtype: 'treepanel',
						columnLines: false,
						useArrows: true,
						id: 'iconLibTree',
						cls: 'iconLibraryTreeDesign',
						listeners: {
							itemclick: function (tp, record, item, index, e, eOpts) {
								defaultCustomSelected = false;
								var dataString = record.data.text;
								//console.log('dataString--->',dataString);
								TemplateStore2.suspendEvents();
								TemplateStore2.clearFilter();
								TemplateStore2.resumeEvents();
								TemplateStore2.filterBy(function (rec) {
									if (rec.data.group === dataString || dataString === "ALL") {
										if (rec.data.imageSrc == "none") {
											return true;
										}
									}
								});
								// Custom images show and hide
								if (dataString === "custom") {
									Ext.getCmp('slider').disable(true);
									Ext.getCmp('searchIcon').disable(true);
									Ext.select('.customImg').show();
								} else {
									Ext.getCmp('slider').enable(true);
									Ext.getCmp('searchIcon').enable(true);
									Ext.select('.customImg').hide();
								}
								TemplateStore2.sort();
							}
						},
						dockedItems: [{
							xtype: 'toolbar',
							dock: 'bottom',
							hidden: false,
							padding: '4 5 4 10',
							items: [{
									xtype: 'container',
									html: '<div class="mouse" id="istamImgId">' + customLbl + '</div>',
									listeners: {
										afterrender: function () {
											defaultCustomSelected = false;
											Ext.get('istamImgId').on('click', function () {
												TemplateStore2.filterBy(function (rec) {
													if (rec.data.group === "custom") {
														return true;
													}
												});
												Ext.getCmp('slider').disable(true);
												//Ext.getCmp('searchIcon').disable(true);
												Ext.select('.customImg').show();
												defaultCustomSelected = true;
											});
										}
									}

								}, '->',
								{
									xtype: 'button',
									iconCls: 'iconLibraryPlus',
									style: {
										'background': 'none',
										'border': '0px'
									},
									handler: function () {
										var imgUploadWindow = Ext.create('Ext.window.Window', {
											width: strSkin == "Light" ? 410 : 400,
											height: 120,
											id: mee.windowId,
											frame: true,
											border: true,
											modal: true,
											closable: true,
											ghost: false,
											padding: 0,
											title: changeImageLbl,
											cls: 'myDashboardwindow',
											/*listeners: {
											show:function(e){
												var dom = Ext.dom.Query.select('.x-mask');
												var el = Ext.fly(dom[0]);
												el.addCls('background_modal');
											}
											},*/
											header: {
												height: 32,
												padding: '0 10',
												margin: 0,
											},
											layout: {
												type: 'hbox',
												align: 'center'
											},
											bodyPadding: 10,
											items: [{
												xtype: 'form',
												id: 'fileUploadFormId',
												items: [{
													xtype: 'container',
													layout: {
														type: 'hbox',
														align: 'stretch'
													},
													items: [{
														xtype: 'container',
														width: 300,
														items: [{
																xtype: 'label',
																text: uploadYourOwnLbl,
																margin: '0 0 5 0'
															},
															{
																xtype: 'container',
																padding: '5 5 5 5',
																cls: 'fileuploadCon',
																layout: {
																	type: 'hbox'
																},
																items: [{
																	xtype: 'filefield',
																	buttonOnly: true,
																	id: 'FILE_1',
																	name: 'FILE_1',
																	cls: 'fileupload',
																	margin: '0 10 0 0',
																	labelAlign: 'top',
																	labelSeparator: ' ',

																	msgTarget: 'side',
																	allowBlank: false,
																	hideLabel: true,
																	listeners: {
																		'change': function (fb, v) {
																			var el = Ext.get('imgUploadPath');
																			el.update(v);
																			Ext.getCmp('imgUploadBtn').show();
																		}
																	},
																	buttonText: chooseFileLbl
																}, {
																	xtype: 'container',
																	width: 197,
																	margin: '5 0 0 0',
																	html: noFileChosenLbl,
																	id: 'imgUploadPath'
																}]
															}
														]
													}, {
														xtype: 'hidden',
														id: 'FILE_1_dstFile',
														name: 'FILE_1_dstFile',
														value: mee.custUploadPath
													}, {
														xtype: 'container',
														margin: '22 0 0 10',
														id: 'uploadBtnContainer',
														items: [{
															xtype: 'button',
															cls: 'button20',
															//hidden:true,
															padding: '0 5 0 5',
															margin: '0 0 0 0',
															id: 'imgUploadBtn',
															text: uploadLbl,
															handler: function () {
																if (mee.from == 'dashboardList') {
																	myDashApp.getController("Main").uploadIconImage(mee.profileName, true);
																} else if (mee.from == 'dashboardUpload') {
																	myDashApp.getController("Main").uploadIconImage(mee.profileName, false);
																} else if (mee.from == 'digitialChartWidget') {
																	myDashApp.getController("Main").uploadDigitalIconImage(mee.profileName, false);
																}
															}
														}]
													}]
												}]
											}],
											closeAction: 'destroy',
										}).show();
										imgUploadWindow.on('close', function () {
											imgUploadWindow.destroy();
											imgUploadWindow = 'closed';
										});
									}
								}
							]
						}]
					}]
				}, {
					region: 'center',
					xtype: 'container',
					collapsible: true,
					layout: 'fit',
					scroll: false,
					border: false,
					autoScroll: false,
					margin: 0,
					items: [{
						xtype: 'dataview',
						store: TemplateStore2,
						id: 'iconViewContainer',
						scroll: false,
						autoScroll: true,
						itemSelector: 'div.iconLibraryImageBorder',
						clickEvent: function () {
							alert('calling');
						},
						tpl: loadTemplte(updateData),
						listeners: {
							refresh: function () {
								if (Ext.select('.iconLibraryImageBorder')) {
									Ext.select('.iconLibraryImageBorder').on({
										'click': function (event, target) {
											if (defaultCustomSelected) {
												var imgname = target.getAttribute('src');
												mee.defaultClass = imgname;
											} else {
												var classname = target.getAttribute('Class');
												mee.defaultClass = classname;
											}

										}
									})
								}
							}
						}
					}]
				}]);

				mee.addDocked({
					xtype: 'toolbar',
					dock: 'bottom',
					height: 55,
					padding: '10 10 10 15',
					items: [{
						xtype: 'trigger',
						id: 'searchIcon',
						name: 'searchIcon',
						labelWidth: 40,
						fieldLabel: '',
						width: 150,
						cls: 'whitedropdown_search',
						emptyText: searchDispLbl,
						hidden: false,

						listeners: {
							change: function (trig, newVal, oldVal, eOpts) {
								searchvalue = trig.getValue();
								pattern = new RegExp(searchvalue, 'gi');

								TemplateStore2.suspendEvents();
								TemplateStore2.clearFilter();
								TemplateStore2.resumeEvents();

								TemplateStore2.filterBy(function (record, id) {
									var array = record.get('tag');

									for (var i = 0; i < array.length; i++) {
										//console.log(array[i]["query"]);
										if ((pattern.test(array[i]["query"]))) {
											return true;
										} else {
											var searchString = newVal;
											Ext.getCmp('iconViewContainer').emptyText = '<table style="height:230px;width:530px;display:table;"><tr><td align="center" vertical-align="middle"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">' + noImgLbl + ' ' + searchString + ' ' + searchLbl + ' !</div></div></td></tr></table>';
										}
									}
								});
								TemplateStore2.sort();
								Ext.getCmp('iconViewContainer').refresh();


								$(".customImg").show();
								if (searchvalue == "" || searchvalue == null) {
									$(".customImg").hide()
								}
							}
						},
						onTextFieldChange: function (triggerField, newValue, oldValue, eOpts) {
							alert('eeeeee');
						}
					}, '->', {
						xtype: 'container',
						padding: 0,
						width: 256,
						//	style:{'border':'1px solid green'},
						layout: 'vbox',
						items: [{
							xtype: 'slider',
							width: 240,
							value: defaultIconSelectionSize,
							//	style:{'border':'1px solid blue'},
							ui: 'iconLibSlider',
							height: 16,
							id: 'slider',
							margin: '0 7 0 7',
							increment: 16,
							minValue: 16,
							maxValue: 64,
							hideLabel: true,
							listeners: {
								change: function (slider, newValue, thumb, eOpts) {
									var CreateFn;
									switch (newValue) {
										case 16:
											updateData.size = "16";
											CreateFn = loadTemplte(updateData)
											break;

										case 32:
											updateData.size = "32";
											CreateFn = loadTemplte(updateData)
											break;

										case 48:
											updateData.size = "48";
											CreateFn = loadTemplte(updateData)
											break;

										case 64:
											updateData.size = "64";
											CreateFn = loadTemplte(updateData)
											break;
									}
									Ext.apply(Ext.getCmp('iconViewContainer'), {
										tpl: CreateFn
									});
									Ext.getCmp('iconViewContainer').refresh();
								},
							},
							tipText: function (increment) {
								return Ext.String.format('<b>{0}x{0}</b>', increment.value);
							}
						}, {
							xtype: 'container',
							margin: '5 0 0 3',
							html: '<div style="border:0px solid red;width:250px;"><div style="float:left;width:18%;">' + SLbl + '</div><div style="float:left;width:30%;" align="center">' + MLbl + '</div><div style="float:left;width:34%;" align="center">' + LLbl + '</div><div style="float:left;width:18%;padding-right:0px" align="right">' + XLLbl + '</div></div>',
						}]
					}, '->', {
						xtype: 'button',
						cls: 'buttonNewBig',
						text: closeLbl,
						padding: '0 10 0 10',
						margin: '0 10 0 0',
						handler: function () {
							this.up('window').close();
						}
					}, {
						xtype: 'button',
						cls: 'buttonNewBig',
						id: 'selectIconBtn',
						text: selectLbl,
						padding: '0 10 0 10',
						handler: function () {
							myDashApp.getController("Main").uploadDefaultImage(mee.profileName, mee.from, mee.defaultClass);
						}
					}]
				});
			},
			failure: function (response) {
				Ext.Msg.alert('Status', 'Request Failed.');

			}
		});
		mee.callParent();
	}
});