var tip;
Ext.define('MyDashBoard.view.KpiConfigurationWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.kpiConfigurationWindow',
    title: '',
    requires: [
        'MyDashBoard.view.Portlet',
        'MyDashBoard.view.KpiPreviewContainer',
        'MyDashBoard.view.KpiConfigListWidget'
    ],
    width: 990,
    maxHeight: Ext.getBody().getViewSize().height - 10,
    height: 544,
    ui: 'newPopupWindow widgetOptionsWindowHeader',
    cls: 'myDashboardwindow kpiWidgetWindow',
    id: 'kpiConfigurationWindow',
	maskCls: 'windowModal',
    defaultArrayData: null,
    configItemArrayData: null,
    initialItemArrayData: null,
    configData: null,
    header: {
        height: 50,
        layout: 'hbox',
        padding: '0 10',
        margin: 0,
        cls: ''
    },

    scroll: false,
    autoScroll: false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    widgetID: '',
    blockId: '',
    widgetType: '',
    showConfigurationTab: false,
    isAggregationDisabled: true,
    widgetSettingsJsonArr: null,
    tableGridDataObj: null,
    isTopNWidget: false,
    frame: true,
    padding: 0,
    bodyPadding: '0',
    margin: 0,
    resizable: false,
    border: false,
    modal: true,
    ghost: false,
    blckType: null,
    closeAction: 'destroy',
    isExternalDataSourceWidget: false,
    count: 0,
    isConfigured: false,
    chartCount: 0,
    configuredChartsCount: 0,
    initComponent: function () {
        var widgetOptionsWindowObj = Ext.getCmp('widgetOptionsWindow');
		

        if (!Ext.isEmpty(widgetOptionsWindowObj)) {
            widgetOptionsWindowObj.close();
        }
        this.createConfigLayout();
        this.callParent(this);
    },

    onRender: function () {
        this.getConfigData();
        this.callParent();
    },
   
    getConfigData: function () {

        var win = this;
        blockId = win.blockId;
     
        var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
        var paramsForSave = '&action=loadBlockData&profileName=' + dashLayoutObj.profileName + '&blockId=' + blockId;
        
        var kpiWidgetsContinerObj = Ext.getCmp('kpiConfigBox');
     
        var thisWind = new Ext.LoadMask(Ext.get('kpiConfigurationWindow'), {
            msg: "Loading...",
            maskCls: "emptyCls"
        });
        thisWind.show();
      
        iAjax.request({
            url: '/final/servlet/com.eg.egMyDashboardController',
            method: 'POST',
            params: paramsForSave,
            scope: this,
            success: function (response) {

                var jsonText = response.responseText;
                if (jsonText != null && jsonText != '') {
                    var jsonData = Ext.decode(jsonText);
                    var kpiChartcount = 5;

                    if (!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('kpiChartcount')) {
                        kpiChartcount = jsonData.kpiChartcount;
                    }
                    win.configData = jsonData;
                    win.chartCount = kpiChartcount;

                    var kpiNumberSelection = Ext.getCmp('kpiNumberSelection');
                    var kpiConfigBoxObj = Ext.getCmp('kpiConfigBox');
                    var KpiCount = kpiChartcount;

                    kpiNumberSelection.setValue(KpiCount);

                    if (!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('kpiChartData')) {
                        var errorMsg = jsonData.errorMsg;

                        if (errorMsg == '-') {
                            var configuredData = jsonData.kpiChartData;

                            var totalChartsCount = Object.keys(configuredData).length;
                            win.configuredChartsCount = totalChartsCount;
                        } else {
                            win.configuredChartsCount = 0;
                        }
                    }

                    var configItemArray = new Array();
                    var isWidgetConfigured = false;
                
                    for (i = 1; i <= KpiCount; i++) {

                        var chartData = '';
                        var errorMsg = jsonData.errorMsg;
                        if (errorMsg == 'Widget not configured') {
                            isWidgetConfigured = false;
                        } else {

                            if (!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('kpiChartData')) {
                                chartData = jsonData.kpiChartData[i];
                            }
                            if (Ext.isEmpty(chartData)) {
                                isWidgetConfigured = false;
                            } else {
                                isWidgetConfigured = true;
                            }

                        }

						var isExternalDataSourceWidget = false;
						if(isWidgetConfigured)
						{
							if (!Ext.isEmpty(jsonData) && chartData['useExternalData'] != null && !Ext.isEmpty(chartData['useExternalData'])) 
							{
								if(chartData['useExternalData']=='yes')
								{
									isExternalDataSourceWidget = true;
								}
							}
						}

                        configItemArray.push({
                            xtype: 'Kpiconfiglistwidget',
                            id: 'Widget' + i,
                            innerWidgetId: i,
                            isConfigured: isWidgetConfigured,
                            chatTypeName: '',
                            kpiBlckId: blockId,
                            data: chartData,
							isExternalDataSourceWidget:isExternalDataSourceWidget

                        });
                    }

                    win.defaultArrayData = configItemArray;
                    kpiConfigBoxObj.removeAll();
                    win.configItemArrayData = configItemArray;
                    win.initialItemArrayData = configItemArray;

                    kpiConfigBoxObj.add(configItemArray);
                    kpiConfigBoxObj.doLayout();
                    thisWind.hide();
                }
            }
        });
    },

    createConfigLayout: function (reCreateLayout, jsonData) {
        var mePopup = this;
       
		mePopup.items = mePopup.createConfigurationWindowLayout();

		mePopup.dockedItems = [{
			xtype: 'toolbar',
			dock: 'bottom',
			cls: 'egFooterNewConfigWin',
			height: 60,
			items: [
				'->', '->',
				{
					xtype: 'button',
					buttonAlign: 'right',
					id: 'kpiDoneButton',
					text: screenLabelsObj['DoneButtonLabel'],
					margin: '0 20 0 0',
					padding: '5 15 5 15',
					cls: 'newConfigWinBtn newFont_normal14',
				}
			]
		}];
    },

    createConfigurationWindowLayout: function () {
        var meWidgetConfigObj = this;
        var widgetType = '';
        var meItemsArr = [];
        var thisWidgetID = this.widgetID;

        var isCombinationChart = true;
        if (thisWidgetID != null) {
            widgetType = thisWidgetID.substr(0, thisWidgetID.indexOf("_"));
        }
        var widgetCtrlsArr = [];

        var miscPanelCtrlsArr = [];
        var miscBottomPanlObj = {};

        var isChart = false;
        var isTopNChart = false;
        var widgetPreviewTitle = '';
        var widgetPnlObj = Ext.getCmp(thisWidgetID);
        if (!Ext.isEmpty(widgetPnlObj)) {
            isChart = widgetPnlObj.isChart;
            isTopNChart = widgetPnlObj.isTopNChart;
            widgetPreviewTitle = widgetPnlObj.title;
        }
        var previewContainerHeight = 280;
        var isWidgetConfigured = false;
        if (meWidgetConfigObj != null && meWidgetConfigObj.action == 'editWidget') {
            isWidgetConfigured = true;
        }
        var kpiBlckId = meWidgetConfigObj.blockId;
        var portletWidth = 970;
        var portletHeight = 200;

        miscPanelCtrlsArr.push({
            xtype: 'panel',
            id: 'configSettings',
            cls: 'configSettingsWindow',
            flex: 1,
            border: true,
            padding: '10 0 10 0',
            scroll: true,
            autoScroll: true,
            layout: {
                type: 'vbox',
                align: 'stretch'
            },
            defaults: {
                labelAlign: 'top',
                labelSeparator: ''
            },
            margin: '0 0 0 0',
            items: [{
                    xtype: 'panel',
                    margin: '0 0 0 0',
                    padding: '0 0 10 0',
                    layout: {
                        type: 'vbox',
                        pack: 'center',
                    },
                    items: [

                        {
                            xtype: 'container',
                            width: '100%',
                            flex: 1,
                            layout: {
                                type: 'hbox',
                                align: 'stretch'
                            },
                            items: [
                                {
                                    xtype: 'container',
                                    flex: 1,
                                    layout: {
                                        type: 'hbox',
                                        pack: 'end',
                                        align: 'stretch'
                                    },
                                    width: '100%',
                                    items: [{
                                        xtype: 'numberfield',
                                        fieldLabel: 'Add Elements',
                                        labelWidth: 86,
                                        cls: 'kpiNumberSelection',
                                        id: 'kpiNumberSelection',
                                        labelSeparator: '',
                                        editable: false,
                                        labelCls: 'newFont_normal13 kpiNumberSelectionLabel',
                                        width: 129,
                                        margin: '5 10 5 0',
                                        value: 5,
                                        minValue: 3,
                                        maxValue: 5,
										disabled:false,
                                        listeners: {
                                            change: function (field, newVal, oldVal) {
                                                var kpiNumberSelectionObj = Ext.getCmp('kpiNumberSelection');

												kpiNumberSelectionObj.setDisabled(true);
                                                var me = this;

                                                var assetNumIndex = me.getValue();
                                                var kpiConfigBox = Ext.getCmp('kpiConfigBox');
                                                var widgetLength = kpiConfigBox.items.length;

                                                if (oldVal < newVal) {
                                                   
                                                    var value = newVal;
                                                    var isThisWidgetConfigured = false;

                                                    for (i = 1; i <= meWidgetConfigObj.chartCount; i++) {

                                                        var chartData = '';
                                                        var jsonData = meWidgetConfigObj.configData;

                                                        var errorMsg = jsonData.errorMsg;
                                                        if (errorMsg == 'Widget not configured') {
                                                            isThisWidgetConfigured = false;
                                                        } else {

                                                            if (!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('kpiChartData')) {
                                                                chartData = jsonData.kpiChartData[i];
                                                            }
                                                            if (Ext.isEmpty(chartData)) {
                                                                isThisWidgetConfigured = false;
                                                            } else {

                                                                var blockId = meWidgetConfigObj.blockId;
                                                                var chartID = chartData.chartId;

                                                                var chartCount = chartID.substring(chartID.indexOf("_") + 1);

                                                                if (value == chartCount) {
                                                                    isThisWidgetConfigured = true;
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                    }
                                            
                                                    if (isThisWidgetConfigured) {

														var isExternalDataSourceWidget = false;

														if (!Ext.isEmpty(chartData) && chartData['useExternalData'] != null && !Ext.isEmpty(chartData['useExternalData'])) 
														{
															if(chartData['useExternalData']=='yes')
															{
																isExternalDataSourceWidget = true;
															}
														}

                                                        meWidgetConfigObj.configItemArrayData.push({
                                                            xtype: 'Kpiconfiglistwidget',
                                                            id: 'Widget' + value,
                                                            innerWidgetId: value,
                                                            isConfigured: isThisWidgetConfigured,
                                                            chatTypeName: '',
                                                            kpiBlckId: blockId,
                                                            data: chartData,
															isExternalDataSourceWidget: isExternalDataSourceWidget
                                                        });

                                                        kpiConfigBox.removeAll();
                                                        kpiConfigBox.add(meWidgetConfigObj.configItemArrayData);
                                                        kpiConfigBox.doLayout();

                                                    } else {
                                                        for (i = oldVal + 1; i < oldVal + 2; i++) {

                                                            meWidgetConfigObj.configItemArrayData.push({
                                                                xtype: 'Kpiconfiglistwidget',
                                                                id: 'Widget' + i,
                                                                innerWidgetId: i,
                                                                isConfigured: false,
                                                                chatTypeName: '',
                                                                kpiBlckId: kpiBlckId,
																isExternalDataSourceWidget:false
                                                            });

                                                            kpiConfigBox.doLayout();
                                                        }
                                                        kpiConfigBox.removeAll();

                                                        kpiConfigBox.add(meWidgetConfigObj.configItemArrayData);

                                                        kpiConfigBox.doLayout();
                                                    }
			
                                                } else {
                                                    if (widgetLength > 1) {
                                                        meWidgetConfigObj.configItemArrayData.pop();
                                                    }

                                                    kpiConfigBox.removeAll();
                                                    kpiConfigBox.add(meWidgetConfigObj.configItemArrayData);
                                                    kpiConfigBox.doLayout();
                                                }
                                                meWidgetConfigObj.defaultArrayData = meWidgetConfigObj.configItemArrayData;
												
						Ext.defer(function(){
							var kpiNumberSelectionObj = Ext.getCmp('kpiNumberSelection');
							if(!Ext.isEmpty(kpiNumberSelectionObj))
							{
								kpiNumberSelectionObj.setDisabled(false);
							}
						},1500);
													
                                            }
                                        }
                                    }]
                                }
                            ]
                        },
                        {
                            xtype: 'kpipreviewcontiner',
                            margin: '4 20 4 10',
                            width: portletWidth,
                            id: 'kpiWidgetsContiner',
                            height: portletHeight-20,
                            isConfigured: isWidgetConfigured,
                            items: [{
                                xtype: 'portlet',
                                width: portletWidth - 23,
                                height: portletHeight - 42,
                                id: thisWidgetID + '_previewImage',
                                title: widgetPreviewTitle,
                                ui: 'newGraphPanel kpi',
                                cls: 'previewImage',
                                margin: '0 0 0 0',
                                padding: '0 0 0 0',
                                isChart: isChart,
                                isTopNChart: isTopNChart,
                                showMoreDataOption: false,
                                isPreviewMode: true,
                                layout: {
                                    type: 'hbox',
                                    pack: 'center',
                                },
                                items: [{
                                    xtype: 'panel',
                                    flex: 1,
                                    margin: '0px 0px',
                                    padding: 0,
                                    items: [{
                                        xtype: 'container',
                                        flex: 1,
                                        id: 'kpiConfigBox',
                                        cls: 'kpiConfigBox',
                                        layout: {
                                            type: 'hbox',
                                            pack: 'center',
                                            align: 'stretch',
                                        },
                                        margin: 0,
                                        padding: 0,
                                        items: []
                                    }]
                                }]
                            }]
                        }
                    ]
                },
                miscBottomPanlObj
            ],
			listeners:{
				show: function(win)
				{

					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						
						var el = Ext.fly(dom[dom.length-1]);
						
						el.addCls('windowModal');
					}
				},
				hide: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[dom.length-1]);
						el.removeCls('windowModal');
					}
				}	
			},
        });
        return {
            xtype: 'form',
            layout: {
                type: 'vbox',
                align: 'stretch'
            },
            id: 'widgetConfigForm',
            name: 'widgetConfigForm',
            itemId: 'configForm',
            cls: 'form',
            flex: 1,
            fullscreen: true,
            scroll: true,
            autoScroll: true,
            border: false,
            padding: '0 0',
            items: miscPanelCtrlsArr,
            listeners: {
                'afterrender': function () {
                }
            }
        };
    },


});