Ext.define('MyDashBoard.view.LiveMeasuresConfigPopup', {
    extend: 'Ext.window.Window',
    alias: 'widget.meauresconfigpopup',
    requires: ['Ext.ux.form.MultiSelect','utilities.Multiselector', 'MyDashBoard.view.ComparisonTable','utilities.CustomGrid','utilities.TimeLine','utilities.ScrollCombo'],
    title:addMetricsTitle,
    width: 940,
	modal : true,
	autoShow : false,
    layout:{type:'vbox',align:'stretch'},
	/*header:{
		height:32,
		padding:'0 10',
		margin:0
	},*/
	cls:'myDashboardwindow',
	ui:'newPopupWindow newplainHeader',
	bodyPadding:0,
	frame:true,
	border:false,
    height: 600,
	blockId : null,
	blckType : '',
	isFluidWindowConfigPopup : false,
	closeAction : 'destroy',
	initComponent : function()
	{
		this.buttonAlign = 'center';
		var thisBlockId = this.blockId;	
		if(thisBlockId!=null)
		{
			this.blckType = thisBlockId.substr(0,thisBlockId.indexOf("_"));
		}
		var blockType = this.blckType;
		/*if(blockType!=null && blockType=="LiveMeasuresBox")
		{*/
			this.createLayoutForLiveMeasBox();
	/*	}
		else if(blockType!=null && blockType=="groupMeasuresBox")
		{
			this.createLayoutForGroupMeasureBox();
		}*/
		this.callParent();
	},
	loadDefaultData : function(jsonData,blockType)
	{
		var metricsFormPanelObj = this.getComponent('liveMeasConfigForm');
		var metricsForm = metricsFormPanelObj.getForm();
		var compTypeCombo = metricsForm.findField('dialCompTypeCombo');
		var areaConfigDetails = jsonData['configDetails'];
		var selectedCompType = '';
		var selectedComp = '';
		var selectedTest = '';
		var selectedMeasure = '';
		var selectedDescriptor = '';
		var selectedGraphType='';
		if(!Ext.isEmpty(areaConfigDetails))
		{
			selectedCompType = areaConfigDetails['selectedCompType'];
			selectedComp = areaConfigDetails['selectedComp'];
			if((selectedCompType!=null && selectedCompType!="undefined" && selectedCompType!="" && selectedCompType!="-1") && (selectedComp!=null && selectedComp!="undefined" && selectedComp!='' && selectedComp!="-1"))
			{
				selectedComp = selectedCompType+":"+selectedComp;
			}
			selectedTest = areaConfigDetails['selectedTest'];
			selectedMeasure = areaConfigDetails['selectedMeasure'];
			selectedDescriptor = areaConfigDetails['selectedDescriptor'];
		}
		compTypeCombo.getStore().removeAll();
		compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
		var compTypeStore = compTypeCombo.getStore();
		compTypeStore.loadRawData(jsonData['comptypes']);
		compTypeStore.insert(0,{
			displayField:jsonData['screenLabels']['reporter.common.Please choose a Component Type'],
			valueField: '-1'
		});
		if(selectedCompType!=null && selectedCompType!='')
		{
			compTypeCombo.setValue(selectedCompType);
			compTypeCombo.fireEvent('select',compTypeCombo);
		}
		else
		{
			compTypeCombo.setValue('-1');
		}

		var compCombo = metricsForm.findField('dialComponentCombo');
		compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
		var compComboStore = compCombo.getStore();
		compComboStore.removeAll();

		var meDialPopup = this;

		if(selectedComp!=null && selectedComp!='')
		{
			compCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(compCombo,selectedComp);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{	
			compComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			compCombo.setValue('-1');
		}
		var testCombo = metricsForm.findField('testCombo');
		testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
		var testComboStore = testCombo.getStore();
		testComboStore.removeAll();
		if(selectedTest!=null && selectedTest!='')
		{
				testCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(testCombo,selectedTest);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{
			testComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			testCombo.setValue('-1');
		}
	
		var ddMeasuresCombo =  metricsForm.findField('measureMultiCombo');
		Ext.getCmp('measureComboLbl').setText(jsonData['screenLabels']['monitor.measures.Measures']);
		var ddMeasuresComboStore = ddMeasuresCombo.getStore();
		ddMeasuresComboStore.removeAll();
		if(selectedMeasure!=null && selectedMeasure!='')
		{
				ddMeasuresCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(ddMeasuresCombo,selectedMeasure);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{
			ddMeasuresComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			ddMeasuresCombo.setValue('-1');
		}
		var dialDescriptorCombo = metricsForm.findField('dialDescriptorCombo');
		dialDescriptorCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
		if(selectedDescriptor!=null && selectedDescriptor!="")
		{
				dialDescriptorCombo.getStore().on('load', function(){ meDialPopup.fireComboSelection(dialDescriptorCombo,selectedDescriptor);  }, this, {
					single: true,
					delay: 100
				});
		}
		else
		{
			var dialDescriptorComboStore = dialDescriptorCombo.getStore();
			dialDescriptorComboStore.removeAll();
			dialDescriptorComboStore.insert(0,{
				displayField:notApplicable,
				valueField: '-1'
			});
			dialDescriptorCombo.setValue('-1');
		}

	/*	var startdateObj = metricsForm.findField('er_stdate');
		var enddateObj = metricsForm.findField('er_enddate');
		var startHourObj = metricsForm.findField('er_sthr');
		var endHourObj = metricsForm.findField('er_endhr');

		startdateObj.setFieldLabel(fromLbl);
		enddateObj.setFieldLabel(toLbl);
		startHourObj.setFieldLabel(hrsLbl);
		endHourObj.setFieldLabel(hrsLbl);
		var configuredData = jsonData['configuredDetails'];
		var configDetails = jsonData['configDetails'];
		Ext.getCmp("er_mode").hide();
		var timelineComboObj = metricsForm.findField('er_timeline');
		timelineComboObj.getStore().loadRawData(jsonData['timelineJson']);
		timelineComboObj.setValue(configDetails['timeline']);
		startdateObj.setValue(configDetails['startDateForDisplay']);
		startdateObj.dataArray = configDetails['startDate'];
		enddateObj.setValue(configDetails['endDateForDisplay']);
		enddateObj.dataArray = configDetails['endDate'];
		startHourObj.setValue(configDetails['startHourForDisplay']);
		startHourObj.dataArray = configDetails['startHour'];
		endHourObj.setValue(configDetails['endHourForDisplay']);
		endHourObj.dataArray = configDetails['endHour'];
		stmin = configDetails.startMinForDisplay;
		enmin = configDetails.endMinForDisplay;
		mgr_stmin = configDetails.startmin;
		mgr_enmin = configDetails.endmin;*/
	},
	 onRender : function () {
			var mePopup = this;
			//myDashboardMask.show();
			var thisWind =new Ext.LoadMask(this.getEl(), {
							msg : "Loading .."
						});
			thisWind.show();
			var thisBlockId = mePopup.blockId;	
			var editViewPage='dashboardLayout2';
			if(this.isFluidWindowConfigPopup)
			{
				editViewPage='fluidDashLayout';
			}
			var profileName = Ext.getCmp(editViewPage).profileName;

			var blockType = this.blckType;
			
			if(thisBlockId!=null)
			{
				blockType = thisBlockId.substr(0,thisBlockId.indexOf("_"));
			}

				Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params: 'comesFrom=myDashboard&action=loadDialConfigPopup&profileName='+profileName+'&blockId='+thisBlockId+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						thisWind.hide();
						mePopup.loadDefaultData(jsonData,blockType);
					}	
				},
				failure : function()
				{

				}
			});
			this.callParent();
		},
		createLayoutForLiveMeasBox :function()
		{
			   this.items =  [{
        xtype: 'form',
			itemId : 'liveMeasConfigForm',
			buttonAlign: 'center',
        defaults: {
            padding: '3',
            margin: 3,
			labelSeparator:''
        },
        buttons: [
		{
		    text : updateDispBtn,
			id : 'configUpdateBtn',
			name : 'configUpdateBtn',
            cls: 'button20'
        }
			],
        items: [/* {
					xtype: 'container',

					flex: 1,
					layout:'hbox',
					items:[
						{	
							xtype:'container',
					items: [
						{
							xtype:'timeline',
							id:'timelineMyObj',
							name:'timelineMyObj',
							layout:'hbox',
							margin: '10 0 0 10'

						}
					]
				}]
			},*/{
                xtype: 'container',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                   margin: '5 0 0 10',
				   labelSeparator:''
                },
                items: [{
                        xtype: 'container',
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
                        items: [
							{
                        xtype: 'scrollcombo',
						cls: 'dropdown',
						margin: '0 0 15 0',
                        fieldLabel: 'Component Type',
						labelSeparator:'',
						id : 'dialCompTypeCombo',
						name : 'dialCompTypeCombo',
                        width: 280,
						store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
                    },
					{
							xtype : 'label',
							id : 'measureComboLbl',
							 margin: '0px 0px 0px 5px',
							name : 'measureComboLbl'
					},
					{
						xtype: 'multiselect',
						 margin: '10 0 0 0',
						id: 'measureMultiCombo',
						name: 'measureMultiCombo',
						cls: 'dropdown',
//						fieldLabel: 'Measure',
						width: 280,
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						baseCls: 'egmultiselect',
						border: true,
						bodyPadding:0,
						multiSelect: true,
						labelAlign : 'top',
						scroll : false,
						autoScroll : false,
						width : 280,
						height: 180,
						layout: 'fit',
						listConfig :
						{
							simpleSelect : true
						}
					}]
				},{
                    xtype: 'container',
					defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
                    items: [				
					{
                        xtype: 'scrollcombo',      
						cls: 'dropdown',
                        id: 'dialComponentCombo',
						fieldLabel : 'Component',
                        name: 'dialComponentCombo',
						margin:'0 0 0 10',
                        width: 280,
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
                    },
						{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						fieldLabel : 'Descriptor',
						id: 'dialDescriptorCombo',
						name: 'dialDescriptorCombo',
						width: 280,
						margin:'20 0 0 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: []
						}),
						scroll : true,
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
							}
					]
                },
				 {
                    xtype: 'container',
                    defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
                    items: [
							{
                        xtype: 'scrollcombo',
                        id: 'testCombo',
                        name: 'testCombo',
						cls: 'dropdown',
                        fieldLabel: 'Test',
                        width: 280,
						margin:'0 0 0 10',
                        store: Ext.create('Ext.data.Store', {
                            fields: ['displayField','valueField'],
                            data: []
                        }),
						editable:false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
                    }]
                }
            ]

            }

        ]
    }]
		},
		setBlockId : function(blockId)
		{
			this.blockId = blockId;
		},
		checkspecialCharacterForMetric : function(dispMVal)
		{
			var splChar =":~!@#$%^&*+={}[]|\\;\"\<>,";
			for(var i=0; i<obj_val.length; i++)
			{
				var check_char = splChar.indexOf(obj_val.charAt(i))
				//Returns value 1 if the special character listed in splChar is found
				if(check_char >= 0)
				{
					return true;
				}
			}
		},
		fireComboSelection : function(comboObj,selectedValue)
		{
			comboObj.setValue(selectedValue);
			comboObj.fireEvent('select',comboObj);
		}
	}
)