try
{
	var centerMap = new google.maps.LatLng(40.3780, 10.4359);

	Ext.define('MyDashBoard.view.LocationsMap',{
		extend:'Ext.ux.GMapPanel',
		alias:'widget.locationsmap',
		blockId:null,
		autoDestroy:true,
		mapData:null,
		border:false,
		style:{'border':'1px solid red !important'},
		cls: 'datapanel1',
		align:'center',
		gmapType: 'map',
		xtype: 'gmappanel',
		markers:null,
		mapOptions: {
			center: centerMap,
			minZoom:1,
			zoom: 1,
			maxZoom:5,
			draggable: true,
			scrollwheel: true,
			navigationControl: true,
			mapTypeControl:false,
			zoomControl: true,
			zoomControlOptions: {
				position: google.maps.ControlPosition.LEFT_BOTTOM
			},
			scaleControl: false,
			streetViewControl: false,

			panControl: false,
			panControlOptions:{
				position: google.maps.ControlPosition.LEFT_TOP
			},
			disableDoubleClickZoom:false,
			drawingControl: false,
			fullscreenControl:true,
			mapTypeId: MY_MAPTYPE_ID
		},
		setMapMarkers:function(markersArray){
			this.mapData = [];
			this.mapData = markersArray;
			this.fireEvent('mark',this);
		},
		clearMapMarkers:function(){
			return this.fireEvent('clearmark',this);
		},
		initialize:function(markersArray) {
		},
		setMarkers : function(map, locations) {
			var bounds = new google.maps.LatLngBounds();
			for (var i = 0; i < locations.length; i++)
			{
					var beach = locations[i];
					var coords = new google.maps.LatLng(beach[1], beach[2]);
					var contentString = '<div id="content">'+
						'Info Window Test:' +  beach[0] +
						'</div>';
					var infowindow = new google.maps.InfoWindow({content: contentString});
					var markerImage = new google.maps.MarkerImage
					(
						"http://www.alawar.com/games_img/games/sky-bubbles/sky-bubbles-deluxe-logosmall.gif"
					);
					var marker = new google.maps.Marker({
						position: coords,
						map: map,
						icon: markerImage,
						title: beach[0],
						zIndex: beach[3]
					});
					google.maps.event.addListener(marker, 'click',
						function (infowindow, marker) {
							return function () {
								infowindow.open(map, marker);
							};
						}(infowindow, marker)
					);
					bounds.extend(coords);
			}
		},
		initComponent:function(){
			//google.maps.visualRefresh = true;
			var me  = this;
			me.callParent();
			me.initialize();
		}
	});
}
catch (e)
{
	var meBlockId=this.blockId;
	Ext.define('MyDashBoard.view.LocationsMap',{
		extend:'Ext.panel.Panel',
		autoDestroy:true,
		layout:{type:'vbox',align:'stretch',pack:'center'},
		mapData:null,
		border:false,
		style:{'border':'0px solid blue'},
		cls: 'datapanel1',
		align:'center',
		id:meBlockId+'_errMapIds',
		flex:1,
		width:530,
		height: 350,
		markers:null
	});

}