// Override the mask into the panel
Ext.override(Ext.Component,
{
    setLoading : function(load, targetEl) {
        var me = this,config;
        if (me.rendered){
            Ext.destroy(me.loadMask);
            me.loadMask = null;
            if (load !== false && !me.collapsed) {
                if (Ext.isObject(load)) {
                    config = Ext.apply({}, load);
                } else if (Ext.isString(load)) {
                    config = {msg: load};
                } else {
                    config = {};
                }
				
            if (targetEl){
				me.loadMask = new Ext.LoadMask(me.getTargetEl(), config);
				}else{
				me.loadMask = new Ext.LoadMask(me.el, config);
				}
				me.loadMask.show();
            }
        }
        return me.loadMask;
    }
});
var i = 0;
var j = 0;
var k = 0;
Ext.define('headerbutton', {
    extend: 'Ext.AbstractPlugin',
    alias: 'plugin.headericons',
    iconCls: '',
    init: function(panel) {
        this.panel = panel;
        this.callParent();
        panel.on('render', this.onHeaderIcons, this);
    },
    onHeaderIcons: function() {
        this.header = this.panel.getHeader();
	if(!Ext.isEmpty(this.header))
	{
		this.header.insert(0, this.headerButtons);
	}
    }
});
var dbStore = Ext.create('Ext.data.Store', {
    fields: ['valueField', 'displayField'],
    data: []
});
Ext.define('MyDashBoard.view.Main', {
    extend: 'Ext.panel.Panel',
    //	title:'MY DASHBOARD',
    //baseCls:'egbaseLayout',
    //cls: 'balckouterpanel dashboard_title',
    //bodyCls:'outerMainLayoutbody',
	ui:'newOuterPanel',
    layout: {
        type: "fit",
        align: "stretch"
    },
    frame: true,
    requires: [
		'MyDashBoard.view.AddedTemplateViews',
        'MyDashBoard.view.DashBoardLayout',
        'MyDashBoard.view.FluidDashBoardLayout',
        'MyDashBoard.view.FluidViewDashBoardLayout',
        'MyDashBoard.view.ViewDashBoardLayout',
        'MyDashBoard.view.Columns',
        'MyDashBoard.view.ViewColumns',
        'utilities.CustomGrid',
        'MyDashBoard.view.ViewPortalPanel',
        'MyDashBoard.view.DashBoardTools',
        'utilities.Utilities',
        'utilities.CheckCombobox',
        'MyDashBoard.view.DashboardGeneralSettings', 
		'MyDashBoard.view.Portlet',
		'MyDashBoard.view.SummaryWidget',
		'MyDashBoard.view.VMAlarmsWidgetConfigPopup',
		'MyDashBoard.view.ListView',
		'MyDashBoard.view.LocationsMap',
		'MyDashBoard.view.LocationsMapContainer',
		'MyDashBoard.view.HeatMapPanel',
		'Ext.ux.GMapPanel',
		'utilities.BorderPanelLayout',
		'utilities.Toggleswitch',
		'MyDashBoard.view.GeoMapControls',
		'MyDashBoard.view.GeoPanel',
		'MyDashBoard.view.PreDefinedLayouts'
    ],
    alias: 'widget.main',
    id: 'myDashMainPanel',
    border: false,
    margin: '8 8 0 8',
    padding: 0,
    flex: 1,
	bodyPadding:0,
    autoScroll: false,
    frame: false,
    scroll: false,
    header: {
        height: 39,
		margin:0,
		cls:publishedDashboard ? 'publishedDashboard':'',
        padding: '0 10 0 0',
    },
    initComponent: function() {


		var toolsArr=[];
		toolsArr.push(	{
           xtype: 'container',
		   width:450,
			   hidden:true,
			style:{"text-align":"right","line-height": "0"},
           id: 'timeUpdate',
		 },{
            xtype: 'component',
            padding: '0 5',
            id: 'today',
            listeners: {
                render: function() {
                    if (!isMonitorHome && !disableMydashboardPopout) {
                        var timer = Ext.TaskManager.start({
                            run: function() {
                                var mgrtime = egClock1();
                                Ext.getCmp('today').update('<span style="color:#a3a3a3;font-size:11px;padding-left:10px;">' + mgrtime + '</span>');
                            },
                            interval: 1000,
                            scope: this
                        });
                        delete timer;
                    }
                }
            }
        });
		if(!isComponentDashboard && !isConsolidatedDashboard && !publishedDashboard)
		{
			toolsArr.push({
				xtype:'container',
				height:30,
				items:[{
					xtype:'trigger',
					id : 'searchMyDashboard',
					name : 'searchMyDashboard',
					labelWidth:40,
					margin: '4px 10px 0px 0px',
					fieldLabel:'',
					//cls: 'whitedropdown_search',
					cls: 'whitedropdown_search', 
					//cls : strSkin == "Dark" ? 'whitedropdown_search' : 'dark_dropdown_search',
					emptyText:searchDashLbl,
					//hidden : true,
					listeners: {
						 change: function(trig,newVal,oldVal,eOpts) {
							 var dashSettingsToolbarObj=Ext.getCmp('dashSettingsToolbarObj');
							 if(dashSettingsToolbarObj!=null && dashSettingsToolbarObj.selectedListPageOption=='gridlistview')
							 {
								 trig.onTextFieldChange(trig,newVal,oldVal,eOpts,true);
							 }
							 else
							 {
								trig.onTextFieldChange(trig,newVal,oldVal,eOpts,false);
								$('.textView').highlight(newVal);
							 }
						 }
					 },
					onTextFieldChange : function(triggerField, newValue, oldValue, eOpts,isGridView)
					{
						var dataViewId = null;
						if(isGridView)
						{
							dataViewId=Ext.getCmp('dashboardListPageView');
						}
						else
						{
							dataViewId=Ext.getCmp('dataViewId');
						}
						var myDashboardSharingGridId = Ext.getCmp('myDashboardSharingGrid');

						if(!Ext.isEmpty(dataViewId))
						{
							if(newValue=="*")
							{
								dataViewId.store.clearFilter();
							}
							else
							{
								if(newValue.lastIndexOf("*")==(newValue.length-1))
								{
									newValue = newValue.substr(0,(newValue.length-1));
								}
								dataViewId.store.suspendEvents(true); // This is used for good performance
								dataViewId.store.clearFilter();
								dataViewId.store.resumeEvents(); // This is used for good performance
								if (newValue) {
									var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
									dataViewId.store.filter({
										filterFn: function(record) {
											if(isGridView)
											{
												return matcher.test(record.get('COLUMN_0'));
											}
											else
											{
												var dashboardName = record.get('dashboardName');
												var match= matcher.test(dashboardName) ;
												if(!match)
												{
													var searchString =newValue;
													dataViewId.emptyText = '<table width="100%" height="480px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><div styel="margin:10px auto">'+dataViewNoDashboardExistMsg +' '+searchString+'</div></td></tr></table>';
												}
												return match;
											}
										}
									});
								}
								triggerField.focus();
							}
						}
						else if(!Ext.isEmpty(myDashboardSharingGridId))
						{
							if(newValue=="*")
							{
								myDashboardSharingGridId.store.clearFilter();
							}
							else
							{
								if(newValue.lastIndexOf("*")==(newValue.length-1))
								{
									newValue = newValue.substr(0,(newValue.length-1));
								}
								myDashboardSharingGridId.store.suspendEvents(true); // This is used for good performance
								myDashboardSharingGridId.store.clearFilter();
								myDashboardSharingGridId.store.resumeEvents(); // This is used for good performance
								if (newValue) {
									var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
									myDashboardSharingGridId.store.filter({
										filterFn: function(record) {
											var dashboardName = record.get('COLUMN_0');
											var dashboardOwner = record.get('COLUMN_1');
											var dashboardDescription = record.get('COLUMN_2');
											var findIn = dashboardName + dashboardOwner + dashboardDescription;
											var match= matcher.test(findIn) ;
											if(!match)
											{
												var searchString =newValue;
												var gridView= myDashboardSharingGridId.getView();
												gridView.emptyText = '<table  height="99%" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconExclamation"></div><div style="margin:10px auto">'+dataViewNoDashboardExistMsg +' '+searchString+'</div></td></tr></table>';
												//gridView.emptyText = '<div style="height:99%; float: left;overflow: hidden; margin: 0 auto;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">'+WidgetNotConfigMsg+'</div></div></div>';
											}
											return match;
										}
									});
								}
								triggerField.focus();
							}
						}
						Ext.getCmp('selectAllDashboards').setValue(false);
					}

			}]
			});
		}
	/*	if(isComponentDashboard)
		{
			toolsArr.push({
				xtype: 'scrollcombo',
				id: 'componentList',
				name: 'componentList',
				width: 350,
				labelStyle:'padding:3px 0px 0px;text-align:right',
				labelWidth:130,
				labelAlign: 'left',
				dock: 'right',
				margin: '0 10 0 10',
				cls: 'dropdown',
				listConfig: {
					cls: 'blklist'
				},
				fieldLabel : 'Component Name ',
				editable: false,
				displayField: 'displayField',
				valueField: 'valueField',
				store: Ext.create('Ext.data.Store', {
				fields: ['valueField', 'displayField'],
				data: []}),
				queryMode: 'local',
				hidden : true
			});
		}*/
		if(isComponentDashboard || isConsolidatedDashboard)
		{
			toolsArr.push({
				xtype: 'combo',
				id: 'templatesList',
				name: 'templatesList',
				width: 300,
				labelStyle:'padding:3px 0px 0px;text-align:right',
				labelWidth:130,
				labelAlign: 'left',
				dock: 'right',
				margin: '0 10 0 10',
				//cls: 'dropdown',
				ui:'dropdownNoBorder',
				listConfig: {
					cls: 'blklist'
				},
				labelSeparator: ':' ,
				fieldLabel : 'Templates',
				editable: false,
				displayField: 'displayField',
				valueField: 'valueField',
				store: dbStore,
				queryMode: 'local',
				hidden : true
			});
		}
		if(!isComponentDashboard && !isConsolidatedDashboard && !isMonitorHome)
		{
			toolsArr.push({
				xtype: 'dashboardtools',
				hidden: isMonitorHome
			});
			toolsArr.push({
				xtype: 'utilitiestool',
				hidden: isMonitorHome
			});
		}
		var backBtnObj=Ext.getCmp('backBtnObj');
		if(!Ext.isEmpty(backBtnObj))
		{
			this.tools.remove(backBtnObj);
		}
		if(isComponentDashboard || isConsolidatedDashboard)
		{
			toolsArr.push({
				xtype : 'button',
				margin:'4 4 0 8',
				iconCls:'iconBack',
				text : 'Back',
				action : 'back',
				cls:'backbutton',
				id : 'backBtnObj',
				name : 'backBtnObj',
				handler : function()
				{
					window.history.go(-1);
				}
			});

			this.plugins=[{
                ptype: "headericons",
				height:39,
                headerButtons: [
				{
					xtype:'label',
					padding:'0px 0px 0px 10px',
					id : 'DashboardPanelTitle',
					name : 'DashboardPanelTitle',
					//html: '<div class="newFont_bold13">Monitoring Dashboard -&nbsp;</div>',
					//id:'panelTitle',
				//	text:'Application Dashboard ',
					//padding:'0px 0px 0px 0px',
					//width:168
				},
				{
					xtype:'combo',
					//cls:'dropdown',
					//ui:'eg_dropdown',
					ui:'dropdownNoBorder',
					hidden:true,
					itemId:'componentsDropDown',
				//	labelStyle:'padding:0px 0px 0px;text-align:left',
					id: 'componentsDropDown',
					width:200,
					labelWidth:70,
					editable:false,
					labelSeparator: '' ,
					fieldLabel:'',
					labelAlign:'left',
					displayField:'displayField',
					valueField:'valueField',
					queryMode:'local',
					store:Ext.create('Ext.data.Store',{
						fields:['state','valueField', 'displayField']
					}),
					margin:'0px 0 0 0px',
					tpl: Ext.create('Ext.XTemplate',
						//'<ul style="display:inline-block;white-space:nowrap">',
						'<ul style="white-space:nowrap">',
						'<tpl for=".">',
							'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{displayField}</li>',
						'</tpl>',
						'</ul>'
					)
				},
			/*	{
					xtype: 'header',
					name: 'componentsDropDown_label',
					id: 'componentsDropDown_label',
					fieldLabel: '',
					margin:'0 0 0 4px',
					value: '',
					compOptsList : null,
					selectedComponent : '',
					componentState : '',
					width:500,
					height : 39
				},
				{
					xtype:'label',
					padding:'3px 0px 0px 10px',
					html: '<div class="font_bold13">Application Dashboard</div>',
					//id:'panelTitle',
				//	text:'Application Dashboard ',
					//padding:'0px 0px 0px 0px',
					//width:168
				
					field : {
						xtype:'scrollcombo',
						cls:'dropdown',
						hidden:true,
						itemId:'componentsDropDown',
						labelStyle:'padding:2px 0px 0px;text-align:right',
						id: 'componentsDropDown',
						style:{background:'red',border:'1px'},
						width:240,
						labelWidth:70,
						editable:false,
						 labelSeparator: '' ,
						fieldLabel:'',
						labelAlign:'left',
						displayField:'displayField',
						valueField:'valueField',
						queryMode:'local',
						store:Ext.create('Ext.data.Store',{
							fields:['state','valueField', 'displayField']
						}),
						margin:'0 0 0 4px',
						tpl: Ext.create('Ext.XTemplate',
							//'<ul style="display:inline-block;white-space:nowrap">',
							'<ul style="white-space:nowrap">',
							'<tpl for=".">',
								'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{displayField}</li>',
							'</tpl>',
							'</ul>'
						)
					}
				},*/
				/*{
					xtype: 'scrollcombo',
					id: 'templatesList',
					name: 'templatesList',
					width: 280,
					labelStyle:'text-align:left',
					labelWidth:50,
					 labelSeparator: '' ,
					labelAlign: 'left',
					dock: 'right',
					margin: '0 0 0 4px',
					cls: 'dropdown',
					listConfig: {
						cls: 'blklist'
					},
					fieldLabel : 'Template',
					editable: false,
					displayField: 'displayField',
					valueField: 'valueField',
					store: dbStore,
					queryMode: 'local',
					hidden : true
				},*/
				{
				
					xtype : 'container',
					id : 'dashboardHeaderName',
					name : 'dashboardHeaderName',
					hidden : true
				}]
			}];
		}
        else if (!publishedDashboard && !isMonitorHome && !isTvMode) {
			this.plugins= [{
                ptype: "headericons",
				height:39,
                headerButtons: [{
                    xtype: 'image',
                    src: defaultLogoImg,
                    hidden: disableMydashboardPopout,
                }, {
				
					xtype : 'container',
					id : 'dashboardHeaderName',
					name : 'dashboardHeaderName',
					hidden : !isComponentDashboard
			},{
					xtype:'container',
					cls:'myDashboardsList_con',
					padding: '0 0',
				
					height:38,
					 margin: '0 10 0 0',
					items:[{
                    xtype: 'scrollcombo',
                    id: 'myDashboardsList',
                    name: 'myDashboardsList',
                    width: 200,
                    margin: '8 10 0 10',
					
                    ui:'transparent-dropdown',
                    listConfig: {
                        cls: 'blklist',
			minWidth:220
		              },
                    editable: false,
                    displayField: 'displayField',
                    valueField: 'valueField',
					pickerOffset :[-10,8],
                    store: dbStore,
                    queryMode: 'local',
                    tpl: new Ext.XTemplate(
                        '<ul >',
                        '<tpl for=".">',
                        '<tpl if="this.shouldShowSHeader(valueField)"><li class="heading"><h3>'+screenLabelsObj['Shared']+'</h3><li></tpl>',
                        '<tpl if="this.shouldShowPHeader(valueField)"><li class="heading"><h3>'+screenLabelsObj['Personal']+'</h3><li></tpl>',
                        '<li class="x-boundlist-item">{displayField}<li>',
                        '</tpl>',
                        '</ul>', {
                            shouldShowSHeader: function(key) {
                                if (key.indexOf('USRSEP') >= 0 && k <= 0) {
                                    k++;
                                    i++;
                                    return true;
                                } else {
                                    i++;
                                }
                                if (i >= dbStore.getCount()) {
                                    i = 0;
                                    k = 0;
                                }
                            },
                            shouldShowPHeader: function(key) {
                                if (key.indexOf('USRSEP') < 0 && j <= 0) {
                                    j++;

                                    return true;
                                } else {
                                    j++;
                                }
                                if (j >= dbStore.getCount()) {
                                    j = 0;
                                }
                            }
                        }
                    )
                }]
				},
				{
					xtype: 'container',
					dock: 'top',
					//id:'gridSkin_tools', //No need the 2 ids, should be delete.
					ui:'footer',
					id : 'listPageHeaderMenu',
					///flex : 1,
					height:39,
					layout:'hbox',
					//style:{'padding':'4px 0px 4px 0px !important'},
					hidden : true,
					items : [
						{
							xtype:'checkbox',
							boxLabel  : '',
							//cls:'checkbt-dark',
							cls : strSkin == "Dark" ? 'checkbt' : 'checkbt-dark',
							margin:'10px 2px 8px 0px',
							name      : 'selectAllDashboards',
							inputValue: 'selectAll',
							id        : 'selectAllDashboards',
							hidden :false,
						},{
							xtype: 'button',
							width: 16,
							height:16,
							padding:0,
							margin:'11 0 8 0',
							overCls: 'buttonOver',
							id: 'DeleteListOfDashboards',
							iconCls: 'iconDelete',
							style : {'border':'0px !important','background':'transparent;'},
							hidden:true,
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: toolDelete
									});
								}
							}
						},{
							xtype:'tbseparator',
							id:'deleteAllSeparator',
							hidden:true,
							height:22,
							margin:'8px 5px 0px 4px',
						},{
							xtype: 'container',
							margin:'0px 0px 0 0px',
							padding:'12 10 0 3',
							html: '<div class="bigHeaderFont" style="color:#ffffff;">'+availDashboardMsg+' </div>',
						},
					/*{
						xtype:'button',
						cls:'button20',
						text:addDashboardBtn,
						listeners: {
											afterrender: function () {
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													cls: 'yellowTip',
													trackMouse: true,
													html: addDashLbl
												});
											}
										},
						action:'addDashBoard'
					},
					{
						xtype:'button',
						cls:'button20',
						text:'Add One Click Dashboard',
						listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: addDashLbl
								});
							}
						},
						action:'addOneClickDashBoard'
					}*/{
						xtype:'button',
						cls:'buttonNew',
						margin:'5px 0 6px 5px',
						iconCls:'iconAddDashboardPlus',
						padding:'2px 2px',
						text:'Add New',
						id:'addNewBtn',
						hidden: hideShowAddDashboardBtn,
						listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: addDashLbl
								});
							}
						},
						action:'addNew'
					},{
						xtype:'button',
						cls:'buttonNew',
						margin:'5px 0 6px 5px',
						iconCls:'iconOneClickDataSource',
						padding:'2px 2px',
						text:'Data Source',
						id:'addDataSourceBtn',
						hidden: hideShowAddDashboardBtn,
						listeners: {
							afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: "Data Source",
								});
							}
						},
						action:'AddDataSource'
					}
					]
				},
				{
					xtype: 'dashboardgeneralsettings',
					id: 'dashboarConfigTools',
					name: 'dashboarConfigTools',
					hidden : isComponentDashboard
				}]
			}];
		}
		this.tools=[];
		this.tools=toolsArr;
		this.callParent();
	}

});

/* Ext.create('Ext.container.Container', {
				floating:true,
				cls:'guide',
				x:200,
				y:45,
				shadow:true,
				shadowOffset:true,
				autoShow:true,
				html: '<div style="position:relative;"><div class="arrow-upX"></div><div class="arrow-upY"></div><div class="titlex">ADD A WIDGET</div><div class="contentx">Start personalising your dashboard by adding a widget</div></div>'
			});*/




/*  Script for automatic scroll options start here   */

/*var scrolldelay;

function pageScroll(){

	var getMainBody = Ext.getCmp('dashboardLayoutObj').body;

		var divGridsterHeight=0;

		divGridsterHeight = $('.gs_w').height()+5;

		getMainBody.scrollBy(0, divGridsterHeight);

		scrolldelay = setTimeout('pageScroll()', 3000);
		if($('#dashboardLayoutObj-body').scrollTop()+$('#dashboardLayoutObj-body').innerHeight() >= $('#dashboardLayoutObj-body')[0].scrollHeight)
		{
			if (window.parent.tvModePlayAction!=undefined && window.parent.tvModePlayAction=='pause')
			{
				stopScroll();
				setTimeout('startTvModePlayAction()',3000);
			}
			else
			{
				clearTimeout(scrolldelay);
				scrolldelay=setTimeout('beforeContinueScroll()',3000);
			}
		}
}

function startTvModePlayAction(){
	jumpScroll();
	window.parent.startTvModePlayAction();
}

function beforeContinueScroll(){
	var pane=Ext.getCmp('dashboardLayoutObj');
	if (!Ext.isEmpty(pane))
	{
		$('#dashboardLayoutObj-body').scrollTop(0);
		scrolldelay = setTimeout('pageScroll()',3000);
	}
}

function stopScroll(){
	clearTimeout(scrolldelay);
}

function jumpScroll(){
	var pane=Ext.getCmp('dashboardLayoutObj');
	if (!Ext.isEmpty(pane))
	{
		clearTimeout(scrolldelay);
		$('#dashboardLayoutObj-body').scrollTop(0); // horizontal and vertical scroll targets
	}
}

	scrolldelay = null;
	delete scrolldelay;
*/
/*  Script for automatic scroll options  end here   */


