Ext.define('MyDashBoard.view.MapWidgetConfiguration', {
    extend: 'Ext.window.Window',
    alias: 'widget.mapwidgetconfiguration',
	id:'mapwidgetsconfiguration',

    width: 620,
	height:400,
    modal: true,
	//border:false,
	
	frame:true,
    autoShow: false,
	ghost:false,
	padding:0,
	autoScroll:true,
	scroll:true,
	lblwidth : 100,
	//legendDisplayStr : legendDisplayLbl,
	/*header:{
		height:32,
		padding:'0 10',
		margin:0
	},*/
    layout: {
        type: 'vbox',
        align: 'stretch',
    },
    cls:'myDashboardwindow',
	ui:'newPopupWindow  newplainHeader',
	bodyPadding:0,
	style:{ 'border-style':'none'},
	blockId : null,
	blckType : '',
	isFluidWindowConfigPopup : false,
	closeAction : 'destroy',
	initComponent : function()
	{
		var me=this;
		me.buttonAlign = 'center';
		var blockType = '';
        me.thisBlockId = me.blockId;
        if (me.thisBlockId != null) {
            blockType = me.thisBlockId.substr(0, me.thisBlockId.indexOf("_"));
        }
		me.dockedItems = [{
			xtype: 'toolbar',
			dock: 'top',
			hidden:false,
			id:'dockedItems',
			cls:'rumHeader',
			items:[{
				xtype:'container',
				margin:0,
				padding:'5 0 5 10',
				hidden:false,
				layout: {
					type: 'hbox',
					align: 'center',
				},
				items:[
				{
					xtype: 'scrollcombo',
					id : me.blockId+'_categoryCombo',
					name : me.blockId+'_categoryCombo',
					cls: 'dropdown',
					fieldLabel:'Category:',
					labelAlign:'left',
					width: 220,
					labelWidth:70,
					labelSeparator:'',
					margin:'0 20 0 10',
					store: Ext.create('Ext.data.Store', {
						fields: ['displayField','valueField'],
						data: []
					}),
					editable:false,
					hidden : true,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					listeners :{
						'select': function()
						{
							me.loadMetricsForCategory();
						}

					}
				}]
			}]

		},{
			xtype: 'toolbar',
			dock: 'bottom',
			height:50,
			cls:'egFooter',
			items: ['->',{
				xtype:'button',
				handler: function()
				{
					myDashApp.getController("Main").updateMapWidgetSettingsWindow(this.up('window'));
				},
				cls:'buttonNewBig',
				padding:'0 6 0 6',
				text:'Update'
			},'->']
		}];
		me.items = {
					xtype : 'container',
					id :'mapWidgetMetricsCont_'+me.blockId
		};
		me.suspendEvents(true);
		me.resumeEvents();
		me.callParent();
	},
	loadMetricsForCategory : function()
		{
			var mePopup = this;
			var thisWind =new Ext.LoadMask(this.getEl(), {
				msg : "Loading .."
			});
			thisWind.show();
			var URL='';
			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
			var mapWidgetMetricsCont=Ext.getCmp('mapWidgetMetricsCont_'+mePopup.blockId);
			mapWidgetMetricsCont.removeAll();

			var selectedCategory=mePopup.selectedCategory;//categoryObj.getValue();
			URL = '/final/servlet/com.eg.egMyDashboardController?action=loadMapWidgetSettings&profileName='+encodeURIComponent(profileName)+'&blockId='+mePopup.blockId+'&category='+encodeURIComponent(selectedCategory);
			
			Ext.Ajax.request({
				url : URL,
				method : 'GET',
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						var categoryComboHide = jsonData['categoryComboHide'];
						var measuresVal = jsonData['measuresArr'];
						if(measuresVal!=null && measuresVal!=undefined && !Ext.isEmpty(measuresVal))
						{
							var measuresArr = [];
							for(var i=0;i<measuresVal.length;i++)
							{
								var measures = measuresVal[i];
								measuresArr.push(
								{
									boxLabel: measures['displayField'],
									id: 'mapMeasures_'+i,
									inputValue: measures['valueField']+':'+measures['displayField'],
									cls : 'checkbt',
									checked: measures['checked'],
									disabled:measures['disabled']
								});
							}
							mapWidgetMetricsCont.add({
								xtype:'container',
								padding:0,
								margin:0,
								layout: {
									type: 'vbox',
									align: 'stretch',
								},
								items:[
									{
												xtype:'container',
												padding:10,
												margin:'0 10 10 10',
												layout: {
													type: 'fit',
													align: 'center',
													pack:'center',
												},
												items:[
												{
													xtype: 'checkboxgroup',
													id:mePopup.blockId+'_mapMeasuresCheckBox',
													name:mePopup.blockId+'_mapMeasuresCheckBox',
													labelAlign: 'left',
													labelSeparator:'',
													width: '100%',
													//fieldWidth:260,
													columnWidth:280,
													vertical:true,
													columns:2,
													items:measuresArr
												}]
									}]
							});
						}
						thisWind.hide();
					}
				}
			});
		},
	listeners:
	{
		afterrender : function (w) 
		{
			var mePopup = this;
			var thisWind =new Ext.LoadMask(this.getEl(), {
				msg : "Loading .."
			});
			thisWind.show();
			var URL='';
			var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
			var selectedCategory=mePopup.selectedCategory;
			URL = '/final/servlet/com.eg.egMyDashboardController?action=loadMapWidgetSettings&profileName='+profileName+'&blockId='+mePopup.blockId+'&category='+encodeURIComponent(selectedCategory);
			var mapWidgetMetricsCont=Ext.getCmp('mapWidgetMetricsCont_'+mePopup.blockId);
			Ext.Ajax.request({
				url : URL,
				method : 'GET',
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						var measuresVal = jsonData['measuresArr'];
						if(measuresVal!=null && measuresVal!=undefined && !Ext.isEmpty(measuresVal))
						{
							var measuresArr = [];
							for(var i=0;i<measuresVal.length;i++)
							{
								var measures = measuresVal[i];
								measuresArr.push(
								{
									boxLabel: measures['displayField'],
									id: 'mapMeasures_'+i,
									inputValue: measures['valueField']+':'+measures['displayField'],
									cls : 'checkbt',
									checked: measures['checked'],
									disabled:measures['disabled']
								});
							}
							mapWidgetMetricsCont.add({
								xtype:'container',
								padding:0,
								margin:0,
								layout: {
									type: 'vbox',
									align: 'stretch',
								},
								items:[
									{
												xtype:'container',
												padding:10,
												margin:'0 10 10 10',
												layout: {
													type: 'fit',
													align: 'center',
													pack:'center',
												},
												items:[
												{
													xtype: 'checkboxgroup',
													id:mePopup.blockId+'_mapMeasuresCheckBox',
													name:mePopup.blockId+'_mapMeasuresCheckBox',
													labelAlign: 'left',
													labelSeparator:'',
													width: '100%',
													//fieldWidth:260,
													columnWidth:280,
													vertical:true,
													columns:2,
													items:measuresArr
												}]
									}]
							});
						}
						thisWind.hide();
					}
				}
			});
		}
	}
});
