Ext.define('MyDashBoard.view.OneClickWidgetConfiguration', {
    extend: 'Ext.window.Window',
    alias: 'widget.oneclickwidgetconfiguration',
    requires: ['Ext.ux.form.ItemSelector','utilities.ScrollCombo','utilities.TimeLine'],
    title: MetricDDTitle,
	width:strSkin == "Light"?740:720,
    modal: true,
	border:false,
	frame:false,
    autoShow: false,
	ghost:false,
	padding:'0 0 0 0',
	bodyPadding:0,
	autoScroll:true,
	scroll:true,
	lblwidth : 100,
	legendDisplayStr : legendDisplayLbl,
    layout: {
        type: 'hbox',
        align: 'center'
    },
    cls:'myDashboardwindow',
	ui:'newPopupWindow  ',
	bodyPadding:0,
	blockId : null,
	blckType: null,
	isFluidWindowConfigPopup : false,
	closeAction : 'destroy',
	initComponent : function()
	{
		this.buttonAlign = 'center';
		var blockType = '';
        var thisBlockId = this.blockId;
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
		if (blockType != null && blockType == 'table')
		{
			this.lblwidth =45;
			this.legendDisplayStr = displayLbl;
		}
		else if (blockType != null && blockType == 'BarChart')
		{
			this.width = (strSkin == "Light")?770:750;
		}
		this.createCommonBlockLayout();
		this.suspendEvents(true);
		this.resumeEvents();
		this.callParent();
	},
	 onRender : function () {
		var mePopup = this;
		var thisWind =new Ext.LoadMask(this.getEl(), {
							msg : "Loading .."
					});
		thisWind.show();
		var thisBlockId = mePopup.blockId;
		if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
		var metricsFormPanelObj = this.getComponent('oneClickConfigForm');
		var metricsForm = metricsFormPanelObj.getForm();
		var editViewPage='dashboardLayout2';
		if(this.isFluidWindowConfigPopup)
		{
			editViewPage='fluidDashLayout';
		}
        var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params: 'comesFrom=myDashboard&action=loadoneclickWidgetConfigPopup&profileName='+profileName+'&blockId='+thisBlockId+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						oneClickWidgetJson = jsonData;
						this.setTitle(oneClickWidgetJson['oneclickWidgetConfigDetails']['titleForWidget']);
						metricsForm.findField('serverdescripCombo').getStore().loadData(jsonData['oneclickWidgetConfigDetails']['serverDescripCombo']);
						metricsForm.findField('serverdescripCombo').setValue(jsonData['oneclickWidgetConfigDetails']['serverDescripComboValue']);
						if(!Ext.isEmpty(jsonData['oneclickWidgetConfigDetails']['componentsObj'])){
							var compObj = metricsForm.findField('oneClickcompObj');
							compObj.getStore().removeAll();
							compObj.getStore().loadRawData(jsonData['oneclickWidgetConfigDetails']['componentsObj']);
							compObj.setValue(jsonData['oneclickWidgetConfigDetails']['componentsObjSelected']);
						}
						if(!Ext.isEmpty(jsonData['oneclickWidgetConfigDetails']['showValueOpt']) && jsonData['oneclickWidgetConfigDetails']['showValueOpt']=='true'){
							if(jsonData['oneclickWidgetConfigDetails']['showValues']=='Yes'){
								metricsForm.findField('showValuesOpt').setValue(({showValues:'yes'}));
							}else{
								metricsForm.findField('showValuesOpt').setValue(({showValues:'no'}));
							}
							metricsForm.findField('showValuesOpt').show();
						}
						var isTopN = false;
						isTopN = (oneClickWidgetJson['oneclickWidgetConfigDetails']['isTopNChart']);
						if(blockType == 'TopNGaugeChart' || blockType =='activityChart' || blockType =='pieChart' || blockType =='heatMapChart' || blockType == 'ddTable' || blockType == 'liveMeasuresBox' || blockType == 'health' || blockType == 'TopNDigitalChart')
						{
							metricsForm.findField('legendCheckboxgroup').hide();
						}

						if(blockType == 'activityChart' || blockType == 'pieChart')
						{
							var showDistprcnt = jsonData['oneclickWidgetConfigDetails']['showDistprcnt'];
							var showDistprcntOpt = metricsForm.findField('showDistprcntOpt');

							if(showDistprcnt=='Yes'){
								showDistprcntOpt.setValue(({showDistributionAsPct:'Yes'}));
							}else{
								showDistprcntOpt.setValue(({showDistributionAsPct:'No'}));
							}				
							showDistprcntOpt.show();
						}

						if(blockType == 'TrendGraph')
						{
							var selGraphValue = jsonData['oneclickWidgetConfigDetails']['selGraphVal'];
							metricsForm.findField('trendGraphOpts').setValue(selGraphValue);
							metricsForm.findField('trendGraphOpts').show();

						}


						var LegendDisp = (oneClickWidgetJson['oneclickWidgetConfigDetails']['showLegendForPie']);
						if(LegendDisp != null && LegendDisp=='true')
						{
							metricsForm.findField('legendCheckboxgroup').show();
						}
						if(blockType == 'CombinedTimelineChart' || blockType == 'TimelineChart' || blockType == 'combinationChart' || blockType == 'BarChart' || blockType == 'table' || blockType=='areaChart' || blockType=='TrendGraph') {
							Ext.getCmp("er_mode").hide();
							var configuredData = jsonData['oneclickWidgetConfigDetails'];
							var timelineComboObj = metricsForm.findField('er_timeline');
							if(blockType == 'TrendGraph')
							{
								timelineComboObj.getStore().loadRawData(jsonData['timelinedetails']['timeline']);
								var selectedTimeline = configuredData['timeline'];
								timelineComboObj.setValue(selectedTimeline);
								var trendGrpDuration = configuredData['trendGrpDuration'];
								if (trendGrpDuration!=null && trendGrpDuration!='' && !Ext.isEmpty(trendGrpDuration))
								{
									var durationLabel = trendGrpDuration['monitor.dashboard.Duration'];
									var selectedDuration = trendGrpDuration['selectedDuration'];
									//var durationComboVal = trendGrpDuration['trendGrpDurationArr'];
									var durationObj = Ext.getCmp('period');
									durationObj.setFieldLabel(durationLabel);
									durationObj.getStore().loadRawData(jsonData['timelinedetails']['period']);
									durationObj.setValue(selectedDuration);
								}
							}
							timelineComboObj.getStore().loadRawData(configuredData['timelinedetails']);
							var selectedTimeline = configuredData['timeline'];
							timelineComboObj.setValue(selectedTimeline);

							var startdateObj = metricsForm.findField('er_stdate');
							var enddateObj = metricsForm.findField('er_enddate');
							var startHourObj = metricsForm.findField('er_sthr');
							var endHourObj = metricsForm.findField('er_endhr');
							var startMinObj = metricsForm.findField('er_stmin');
							var endMinObj = metricsForm.findField('er_endmin');

							startdateObj.setValue(configuredData['startDateForDisplay']);
							startdateObj.dataArray = configuredData['startDate'];
							enddateObj.setValue(configuredData['endDateForDisplay']);
							enddateObj.dataArray = configuredData['endDate'];
							startHourObj.setValue(configuredData['startHourForDisplay']);
							startHourObj.dataArray = configuredData['startHour'];
							endHourObj.setValue(configuredData['endHourForDisplay']);
							endHourObj.dataArray = configuredData['endHour'];
							stmin = configuredData.startMinForDisplay;
							enmin = configuredData.endMinForDisplay;
							startMinObj.setValue(configuredData['startMinForDisplay']);
							endMinObj.setValue(configuredData['endMinForDisplay']);
							mgr_stmin = configuredData.strMin;
							mgr_enmin = configuredData.endMin;
							var isTopNChart=false;
							if(oneClickWidgetJson['oneclickWidgetConfigDetails']['isTopNChart']=='true'){
								isTopNChart = true;
							}

							else if (blockType != null && blockType == 'areaChart')
							{
								var StackedChart = configuredData['StackedChart'];
								var stackedChart="No";
								if (StackedChart != null && StackedChart == 'Yes') {
									stackedChart="Yes";
								}

								var StackedChart = metricsForm.findField('StackedChart');
								StackedChart.suspendEvents(false);
			
								var val = {exp : stackedChart};
								StackedChart.setValue(val);
								StackedChart.resumeEvents();
								StackedChart.show();
								StackedChart=null;
								delete StackedChart;
							}

							if(blockType == 'BarChart')
							{
								var viewType = configuredData['viewType'];
								if(Ext.isEmpty(viewType)) {
									viewType='vertical';
								}
								var viewTypeOptObj = metricsForm.findField('viewTypeOpt');
								viewTypeOptObj.suspendEvents(false);
									viewTypeOptObj.setValue({
									ViewType: viewType
									 });
								viewTypeOptObj.show();
								viewTypeOptObj.resumeEvents();
								viewTypeOptObj=null;
								delete viewTypeOptObj;
							}

							if (displayTimeline) {
								var timelineContObj=Ext.getCmp('timelineMyObj');
								if(blockType!='table' && blockType!='BarChart')
								{
									timelineContObj.show();
								}
								else if(isTopNChart)
								{
									timelineContObj.show();
								}
								if (selectedTimeline != null && selectedTimeline == 'Any') {
									timelineContObj.selectedMgrStMin=mgr_stmin;
									timelineContObj.selectedMgrEndMin=mgr_enmin;
									timelineContObj.selectedStMinForDisplay=configuredData['startMinForDisplay'];
									timelineContObj.selectedEndminForDisplay=configuredData['endMinForDisplay'];

									timelineComboObj.fireEvent('select', timelineComboObj);
								}
								Ext.getCmp('er_stmin').show();
								Ext.getCmp('er_endmin').show();
							}
							
							if(blockType == 'TimelineChart' || blockType == 'combinationChart' || blockType=='areaChart' || blockType=='TrendGraph') 
							{
								var showChartSummaryData = metricsForm.findField('showChartSummaryData');
								showChartSummaryData.show();

								var showChartSummary = jsonData['oneclickWidgetConfigDetails']['showChartSummary'];
								
								var summaryOpt=metricsForm.findField('summary');
								summaryOpt.suspendEvents(false);
								if(showChartSummary!=null && showChartSummary=="Yes")
								{
									summaryOpt.setValue(true);
								}
								summaryOpt.resumeEvents();
								showDescOpt=null;
								delete showDescOpt;
							}
							
						}
						thisWind.hide();


						var showDescriptors = jsonData['oneclickWidgetConfigDetails']['showDescriptors'];
						if(showDescriptors==null || showDescriptors=="undefined" || showDescriptors=="")
							showDescriptors="yes";

						var showDescOpt=metricsForm.findField('showDescOpt');
						showDescOpt.suspendEvents(false);
						if(showDescriptors!=null && showDescriptors=="yes")
						{
							showDescOpt.setValue(true);
						}
						showDescOpt.resumeEvents();
						showDescOpt.show();
						showDescOpt=null;
						delete showDescOpt;

						var showServers = jsonData['oneclickWidgetConfigDetails']['showServers'];
						if(showServers==null || showServers=="undefined" || showServers=="")
							showServers="yes";
						var showServersOpt=metricsForm.findField('showServersOpt');
						showServersOpt.suspendEvents(false);
						if(showServers!=null && showServers=="yes")
						{
							showServersOpt.setValue(true);
						}
						showServersOpt.resumeEvents();
						showServersOpt.show();
						showServersOpt=null;
						delete showServersOpt;

						if (blockType != null && (blockType != 'table' && blockType != 'BarChart' && blockType != 'TopNDigitalChart')) {
							 var showMetrics = jsonData['oneclickWidgetConfigDetails']['showMetrics'];
							if(showMetrics==null || showMetrics=="undefined" || showMetrics=="")
								showMetrics="yes";
							var showMetricsOpt=metricsForm.findField('showMetricsOpt');
							showMetricsOpt.suspendEvents(false);
							if(showMetrics!=null && showMetrics=="yes")
							{
								showMetricsOpt.setValue(true);
							}
							showMetricsOpt.resumeEvents();
							showMetricsOpt.show();
							showMetricsOpt=null;
							delete showMetricsOpt;
						}else{
							metricsForm.findField('showMetricsOpt').hide();
						}
					}
				},
				failure : function()
				{

				}
			});
			this.callParent();
		},
		setBlockId : function(blockId)
		{
			this.blockId = blockId;
		},
		checkspecialCharacterForMetric : function(dispMVal)
		{
			var splChar =":~!@#$%^&*+={}[]|\\;\"\<>,";
			for(var i=0; i<obj_val.length; i++)
			{
				var check_char = splChar.indexOf(obj_val.charAt(i))
				//Returns value 1 if the special character listed in splChar is found
				if(check_char >= 0)
				{
					return true;
				}
			}
		},
		createCommonBlockLayout: function(){

			var stackedCtrlLbl=showStackedAreaLbl;
			if(this.blckType!=null && this.blckType == 'BarChart')
			{
				stackedCtrlLbl=showStackedBarLbl;
			}
			this.items= [
				{
					xtype: 'form',
					itemId : 'oneClickConfigForm',
					padding:0,
					margin:0,
					buttonAlign: 'center',
					defaults: {
						padding: '0',
						margin: '0 10 0 10',
					},
					buttons: [{
						text: updateDispBtn,
						id : 'oneClickBlockConfig',
						name : 'oneClickBlockConfig',
						cls: 'buttonNew',
						padding:'0 10 0 10',
					}],
					items: [
						{
							xtype: 'radiogroup',
							width: 200,
							labelWidth:84,
							labelSeparator:'',
							labelAlign: 'left',
							layout:'column',
							style: {
								'float':'left'
							},
							margin: '6 10 0 10',
							fieldLabel: showValuesLbl,
							id: 'showValuesOpt',
							name: 'showValuesOpt',
							hidden: true,
							defaults : {
								margin: '3 0 0 0'
							},
							items: [
								{
									boxLabel: 'Yes',
									name: 'showValues',
									inputValue: 'yes',
									columnWidth: .5,
									cls: 'radiobt'
								}, {
									boxLabel: 'No',
									name: 'showValues',
									inputValue: 'no',
									columnWidth: .5,
									cls: 'radiobt'
								}
							]
						},{xtype: 'container',
							layout: { type : 'hbox', align : 'stretch' },
								items:[{
							xtype: 'checkboxgroup',
							width:this.blckType!=null && (this.blckType =="table" || this.blckType =="BarChart")? 275 : 340,
							layout:'column',
							margin: '7 0 5 0',
							labelSeparator:'',
							labelWidth:85,
							id:'legendCheckboxgroup',
							labelAlign: 'left',
							fieldLabel : this.legendDisplayStr,
							items: [
								{
									boxLabel: 'Descriptors',
									id: 'showDescOpt',
									name: 'showDescOpt',
									inputValue: 'yes',
									 width:95,
									cls : 'checkbt'
						},
						{
									boxLabel: 'Servers',
									id: 'showServersOpt',
									name: 'showServersOpt',
									inputValue: 'yes',
									 width:70,
									cls : 'checkbt'
								},
								{
									boxLabel: 'Metrics',
									id: 'showMetricsOpt',
									name: 'showMetricsOpt',
									inputValue: 'yes',
									 width:65,
									cls : 'checkbt'
								}
							]
						},{
                            xtype: 'radiogroup',
                            width:240,
							labelWidth:60,
							margin: '6 10 5 0',
                            labelAlign: 'left',
                            fieldLabel: viewTypeLbl,
                            id: 'viewTypeOpt',
							labelStyle:'margin: 3px 0 0 0', 
                            name: 'viewTypeOpt',
                            hidden: true,
							defaults : {
								margin: '3 0 0 0'
							},
                            items: [{
                                boxLabel: 'Vertical',
                                name: 'ViewType',
                                inputValue: 'Vertical',
                                cls: 'radiobt',
								width: 70
                            }, {
                                boxLabel: 'Horizontal',
                                name: 'ViewType',
                                inputValue: 'Horizontal',
                                cls: 'radiobt',
								width: 85
                            }]
                        },{
								xtype: 'radiogroup',
								id: 'StackedChart',
								name: 'StackedChart',
								fieldLabel : stackedCtrlLbl,
								width:205,
								labelWidth:92,
								margin: '6 0 5 0',
								hidden: true,
								labelSeparator:'',
								labelStyle:'margin: 1px 0 0 0;margin-right:0', 
								defaults:{
									columnWidth:100,
										margin: '3 0 0 0'
								},
								items: [
									{ boxLabel:'Yes', inputValue:'Yes',name: 'exp',checked: true, cls:'radiobt' },
									{ boxLabel: 'No', inputValue:'No',name: 'exp', checked: false,cls:'radiobt'}]
							},{
							xtype: 'checkboxgroup',
							width: 150,
							layout:'column',
							margin: '3 10 0 10',
							height:22,
							labelWidth:90,
							labelSeparator:'',
							labelAlign: 'left',
							labelStyle:'margin: 3px 0 0 0', 
							id: 'showChartSummaryData',
							name: 'showChartSummaryData',
							fieldLabel : showChartSummaryLbl,
							hidden: true,
							defaults:{
								columnWidth:120,
							},
							items: [{
								boxLabel: 'Yes',
								id: 'summary',
								name: 'summary',
								inputValue: 'Yes',
								cls : 'checkbt'
							}]
						},
						{
                            xtype: 'radiogroup',
                            width: 275,
							labelWidth:160,
                            columns: 2,
							labelAlign: 'left',
							margin: '6 10 0 0',
							labelSeparator:'',
							labelStyle:'margin: 2px 0 0 0',
                            fieldLabel: distributionLbl,
                            id: 'showDistprcntOpt',
                            name: 'showDistprcntOpt',
                            hidden: true,
							defaults:{
										margin: '2 0 0 0'
								},
                            items: [{
                                boxLabel: 'Yes',
                                name: 'showDistributionAsPct',
                                inputValue: 'Yes',
                                cls: 'radiobt'
                            }, {
                                boxLabel: 'No',
                                name: 'showDistributionAsPct',
                                inputValue: 'No',
                                cls: 'radiobt'
                            }]
                        },{
						xtype: 'scrollcombo',
						id: 'trendGraphOpts',
						name: 'trendGraphOpts',
						hidden : true,
						selectOnTab: true,
						editable : false,
						//labelAlign: 'top',
						labelWidth: 70,
						width: 150,
						margin:'8 0 0 0',
						fieldLabel :statisticsLbl,
						displayField: 'displayField',
						valueField: 'valueField',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField','valueField'],
							data: [{'displayField':minMaxLbl,'valueField' : 'MinMax'},{'displayField':avgLbl,'valueField' : 'Avg'},{'displayField':sumLbl,'valueField' : 'Sum'}]
						}),
						lazyRender: true,
						editable:false,
						queryMode: 'local',
						value :'MinMax'
					}]
					},{
							xtype: 'container',
							layout: 'hbox',
							defaults: {
								labelAlign: 'top',
							},
							margin:'6 0 0 0',
							items: [
								{
									xtype: 'timeline',
									cls:'timeline_left',
									id: 'timelineMyObj',
									name: 'timelineMyObj',
									margin:'0 0 0 0',
									width: 700,
									hidden: true,
									hideMinutes : false,
									addDurationCombo : this.blckType!=null && (this.blckType =="TrendGraph")? true :false,
									gtype : this.blckType!=null && (this.blckType =="TrendGraph")? 'trend' :'',
									layout: 'hbox'
								}
							]
						},
						{
							xtype: 'container',
							margin: '0 10 0 10',
							layout: 'hbox',
							defaults: {
								labelAlign: 'top',
								labelSeparator:'',
							},
							items: [
								{
									xtype: 'container',
									defaults: {
										labelAlign: 'top',
										labelSeparator:''
									},
									items: [
										{
											xtype: 'scrollcombo',
											id : 'serverdescripCombo',
											name : 'serverdescripCombo',
											cls: 'dropdown',
											fieldLabel: selectType,
											width: 160,
											labelSeparator:'',
											margin:'0 10 10 0',
											store: Ext.create('Ext.data.Store', {
												fields: ['displayField','valueField'],
												data: []
											}),
											editable:false,
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											value : notApplicable,
										},{
											xtype: 'label',
											id: 'Component',
											text: componentsLbl,
											hidden: true
										}
									]
								},{
									xtype: 'container',
									layout: 'hbox',
									padding:0,
									margin:0,
									defaults: {
										labelAlign: 'top',
										labelSeparator:''
									},
									items: [
										{
											xtype: 'scrollcombo',
											id : 'compTypeCombo',
											name : 'compTypeCombo',
											cls: 'dropdown',
											labelAlign: 'top',
											labelSeparator:'',
											fieldLabel: compType,
											width: 240,
											margin:'0 10 10 0',
											store: Ext.create('Ext.data.Store', {
												fields: ['displayField','valueField'],
												data: []
											}),
											editable:false,
											hidden : true,
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											value : notApplicable,
										},{
											xtype: 'scrollcombo',
											id : 'compListCombo',
											name : 'compListCombo',
											cls: 'dropdown',
											labelAlign: 'top',
											labelSeparator:'',
											fieldLabel: componentDispLbl,
											width: 240,
											margin:'0 10 10 0',
											store: Ext.create('Ext.data.Store', {
												fields: ['displayField','valueField'],
												data: []
											}),
											editable:false,
											hidden : true,
											displayField: 'displayField',
											valueField: 'valueField',
											queryMode: 'local',
											value : notApplicable,
										}
									]
								}
							]
						},
						{
							xtype: 'itemselector',
							cls:'itemselector',
							id :'oneClickcompObj',
							name :'oneClickcompObj',
							buttons: ['add', 'remove'],
							buttonsText: {
								add: toolGrant,
								remove: toolRevoke
							},
							imagePath: '/final/images/',
							multiSelect: true,
							margin:'0 10 10 10',
							height: 280,
							width: 720,
							scroll : true,
							toTitle:managedItem1,
							fromTitle:unManagedItem1,
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							})
						},

					]
				}
			]
		}
	})