Ext.define('MyDashBoard.view.OpenAlertAlarms', {
    extend: 'Ext.container.Container',
    alias: 'widget.openalertalarms',
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    initComponent: function() {
        var me = this;
        var blockId = me.blockID;

        me.items = [{
				xtype: 'container',
				items: [{
					xtype: 'panel',
					margin: '5 0 0 0',
					height: 92,
					id: 'openAlertAlarmChartUIView1' + blockId,
					listeners: {
					},
					flex: 1,

					items: [{
							xtype: 'container',
							height: 82,
							style: {
								'background': strSkin == 'Light' ? '#f9f9f9' : '#333333',
								'border': strSkin == 'Light' ? '1px solid #e6e6e6' : '#e6e6e6',
								'display': 'flex',
								'align-items': 'center',
								'justfiy-content': 'center;'
							},
							layout: {
								type: 'hbox',
								align: 'center',
								pack: 'center'
							},
							flex: 1,
							items: [{
									xtype: 'container',
									id: 'alertAlarmCountView1',			   
									margin: '5 0 0 0',
									flex: 1,
									tpl: [
										'<div style="padding: 0 0 0 10px;" height:60px;>',
										'<div style="width: 100%">',
										'<tpl for="bar">',
										'<span style="background:{color};width:{width}%;display:inline-block;height:38px;font-size:50px;margin: 5px 0 0; "></span>',
										'</tpl>',
										'</div></div>',
									],
									data: {},
									flex: 1
								},	
								{
									xtype: 'container',
									cls :'newLineRight',
									id: 'alertAlarmtTotalCountView1',
									tpl : [
										'<tpl for=".">',
										'<div style="height:60px;display:flex;align-items:center;justify-content:center;"><div>',
										'<p style="font-size:50px;line-height:1;vertical-align:top;margin:0px 5px 0 0;">{totalAlarmValue}</p>',
										'</div><div style="margin:0px 20px 0 0;"><p>Total</p><p>Open Alerts</p></div></div>',
										'</tpl>',
									],
									data: {},
								},
								{
									xtype: 'container',
									layout: {
										align: 'center',
										pack: 'center'
									},
									id: 'alertCountView1',
									tpl: [                                             
										'<div style="">',
										'<tpl for="alarmCount">',
										'<div style="height:60px;display:flex;align-items:center;justify-content:center;">',
										'<div  style="padding:0 20px;align-items:center;justify-content:center;"  class="newLineRight">',
										'<p style="font-size:22px;line-height:1;text-align: center;vertical-align:top;margin:0px 0px 0 0;">{value}</p>',
										'<div style="margin:0px 0 0;"><span style="width:6px;height:6px;background:{color};margin:4px 5px 1px 0;display:inline-block;position:absolute;"></span>',
										'<span style="padding-left: 11px;">{name}</span><p></div></div>',
										'</tpl>',
										'</div>',
									],
									 data: {},
							}]
						}]
					}]
				}, 
                {
                    xtype: 'container',
                    items: [{
                        xtype: 'panel',
                        margin: '10 0 10 0',
                        id: 'openAlertAlarmChartUIView2' + blockId,
                        flex: 1,
                        items: [{
							xtype: 'container',
							height: 82,
							style: {
								'background': strSkin == 'Light' ? '#f9f9f9' : '#333333',
								'border': strSkin == 'Light' ? '1px solid #e6e6e6' : '#e6e6e6',
								'display': 'flex',
								'align-items': 'center',
								'justfiy-content': 'center;'
							},
							layout: {
								type: 'hbox',
								align: 'center',
								pack: 'center'
							},
							flex: 1,
							items: [{
									xtype: 'container',
									id: 'alertAlarmCountView2',
									margin: '5 0 0 0',
									flex: 1,
									tpl: [
										'<div style="padding: 0 0 0 10px;" height:60px;>',
										'<div style="width: 100%">',
										'<tpl for="bar">',
										'<span style="background:{color};width:{width}%;display:inline-block;height:38px;font-size:50px;margin: 5px 0 0; "></span>',
										'</tpl>',
										'</div></div>',

									],
									data: {},
									flex: 1
								},
								{
									xtype: 'container',
									id: 'alertAlarmtTotalCountView2',
									tpl: [
										'<div style="height:60px;display:flex;align-items:center;justify-content:center;"><div>',
										'<p style="font-size:50px;line-height:1;vertical-align:top;margin:0px 5px 0 0;">{totalAlarmValue}</p></div>',
										'<div style="margin:0px 20px 0 0;"><p>Total</p><p>Open Alerts</p></div></div>',
									],
									data: {},
								}
							]
						},
						{
							xtype: 'container',
							flex: 1,
							layout: {
								'type' : 'vbox',
								'align' : 'stretch'
							},
							items: [
								{
								xtype: 'container',
								id: 'alertCountView2',
								flex:1,
								tpl: [
									'<div >',
									'<div style="height:60px;display:flex;align-items:center;justify-content:center;"><div style="width:100%">',
									'<tpl for="alarmCount">',	
									'<div class="newLineRight" style="padding:0 20px;align-items:center;justify-content:center; float:left; width:33.33%">',
										'<p style="font-size:22px;line-height:1;text-align: center;vertical-align:top;margin:0px 0px 0 0;">{value}</p><div style="margin:0px 0 0;text-align: center;">',
										'<span style="width:6px;height:6px;background:{color};margin:4px 5px 1px 0;display:inline-block;position:absolute;"></span>',
										'<span style="padding-left: 11px;">{name}</span><p></div></div>',
									'</tpl>',	
									'</div>',
									'</div>',
								],
								data: {},
							}]
						}]
					}]

				}],

            this.callParent();
    },
	
	updateDataForAlarms: function(chartData, alarmCountData, totalAlartsData)
	{
		Ext.getCmp('alertAlarmCountView1').update(chartData);
		Ext.getCmp('alertAlarmCountView2').update(chartData);
		Ext.getCmp('alertCountView1').update(alarmCountData);
		Ext.getCmp('alertCountView2').update(alarmCountData);
		Ext.getCmp('alertAlarmtTotalCountView1').update(totalAlartsData);
		Ext.getCmp('alertAlarmtTotalCountView2').update(totalAlartsData);
	}

});