
Ext.define('MyDashBoard.view.Portlet', {
    alias: 'widget.portlet',
	extend:'utilities.BorderPanelLayout',
    xtype: 'BorderPanel',
    padding: 0,
    bodyPadding: 10,
    margin:0,
	flex:1,
	ui:'newGraphPanel toshadow myDashWidgetPad',
    overlapHeader: false,
    border: false,
    frame: false,
    closeAction: 'destroy',
	isPreview : false,
	action : 'createWidget',
	isHighChartUpdate:'',
	isOneClickDashboard: '',
	isLegendAvail: '',
	isToggleHeader: false,
	isCurrentValAvail: false,
	isLastLoadedWidget : false,
	isLastWidget : false,
	isPreviewMode : false,
	//shadow:false,
	//draggable:false,
	showColorPicker : true,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	porletSetTitle:function(title){
		var me = this;
		if(me.rendered){
			Ext.defer(function(){
				me.setTitle(title);
				$('#'+me.id+' .x-panel-header-text').attr('data-qtip',title)
			},200);			
		}else{
			console.log(me.id)
		}
	},
	panlCntr : 0,
	nextRefreshTime : new Date().getTime(),
	lastRefreshedTime : new Date().getTime(),
    defaults: {
		 flex: 1
    },
	applyMasked : function (masked) {
		 var panel = this;
         if (!panel.loading){
         masked = true;
		 }
         else{
         masked = false;
		 }
         panel.setLoading(masked, panel.body);
    },
	refreshData:function(){
		var me = this;
		//alert('refreshKPI');
		myDashApp.getController("Main").loadDataForBlock(me, Ext.getCmp('dashboardLayoutObj').profileName, me.id,false);
	},
	popup:function(btn,x,y){	//TODO
		var me = this;
		var widgetMenuItemsArr=[];
		widgetMenuItemsArr.push({
			text: screenLabelsObj['Refresh'],
			//iconCls: 'edit'
			handler: function() {
				//alert('Item Clicked');
				//myDashApp.getController("Main").refreshWidgetOptionsWindow(this,me);
				//myDashApp.getController("Main").loadDataForBlock(me, Ext.getCmp('dashboardLayoutObj').profileName, me.id,false);
				me.refreshData();
			}
		});
		var includeEitSettings=false;
		var thisBlkId=me.id;
		if(me.isPreviewMode || isMonitorHome || isComponentDashboard || isConsolidatedDashboard || isTvMode)
		{
			includeSettingsIcon=false;
		}
		else if(!this.isOneClickDashboard && (this.blockType!=null && (this.blockType=='TopNGaugeChart' || this.blockType=='TopNDigitalChart')))
		{
			includeSettingsIcon=false;
		}
		else  if(thisBlkId!=null && thisBlkId.indexOf("_")==-1)
		{
			if(thisBlkId=='weather' || thisBlkId=='news' || thisBlkId=='userExperience') 
			{
				includeSettingsIcon=true;
			}
			else
			{
				includeSettingsIcon=false;
			}
		}
		else
		{
			includeSettingsIcon=true;
		}
		
		if(this.isOneClickDashboard && this.blockType!=null && (this.blockType=='vmAlarmsWidget' || this.blockType=='servicehealth'))
		{
			includeSettingsIcon=false;
		}
			
		if(includeSettingsIcon)
		{
			widgetMenuItemsArr.push({
				text: screenLabelsObj['Edit'],
				scale: 'small',
				//hidden : isOneClickDashboard,
				handler: function() {
					//alert('Item Clicked');
					var configWinAction='addWidget';
					if(me.isConfigured)
					{
						configWinAction='editWidget';
					}
					var widID=me.id;
					var isPredefinedLayout=Ext.getCmp('dashboardLayoutObj').isPredefinedLayout;
						
					if(isPredefinedLayout && !me.isConfigured && widID.indexOf("Widget_")==0)
					{
						var addwidgetwindownew=myDashApp.getController("Main").getAddwidgetwindow();
						if (Ext.isEmpty(addwidgetwindownew))
							addwidgetwindownew = Ext.widget('addwidgetwindownew');

						addwidgetwindownew.configureNewWidget=true;
						addwidgetwindownew.widgetID=widID;

						addwidgetwindownew.show();
						addwidgetwindownew=null;
									
						delete addwidgetwindownew;
					}
					else
					{
						myDashApp.getController("WidgetConfigurationController").openWidgetConfigurationWindow(this,widID,configWinAction);
					}
				}
			});
		}
		widgetMenuItemsArr.push({
									text: screenLabelsObj['Remove from dashboard'],
										scale: 'small',
										handler: function() {
											//var freePnlObj=this.up('panel');
											Ext.Msg.show({
												title: myDashboardAlertLbl,
												msg: deleteBlockMsg + '?',
												buttons: Ext.Msg.YESNO,
												width:300,
												icon:'iconConfirmation',
												fn: function(buttonId) {

													if (buttonId == "yes") {
														var gridStackObj=myDashApp.getController("Main").getGridstackpanel();
														gridStackObj._removeWidget(me.relationTo);
														var blockTitle = me.title;
														var blockId = me.id;
														var paramsForDeleteBlock = 'action=deleteTable&profileName=' + Ext.getCmp('dashboardLayoutObj').profileName + '&key=' + blockId;
														if(blockId=='news'){
															var newsViewObj= Ext.getCmp('news');
															if(!Ext.isEmpty(newsViewObj))
																							newsViewObj.hide();
															newsViewObj=null;
															delete newsViewObj;
														}else if(blockId=='weather'){
																var weatherViewObj= Ext.getCmp('weather');
															if(!Ext.isEmpty(weatherViewObj))
																							weatherViewObj.hide();
															weatherViewObj=null;
															delete weatherViewObj;
														}
														Ext.defer(function(){
														var gridStackObj1=Ext.getCmp('gridstackpanelObj');
														var pnlPositions=gridStackObj1._serializationStr();
														paramsForDeleteBlock=paramsForDeleteBlock+"&layoutConfig="+encodeURIComponent(pnlPositions);
														Ext.Ajax.request({
															url: '/final/servlet/com.eg.egMyDashboardController',
															method: 'POST',
															params: paramsForDeleteBlock,
															scope: this,
															success: function(response) {
																me.close();
																var configIds = publicJson['myDashboardConfigDetails']['configIds'];
																if (configIds != null && configIds.indexOf(blockId) > -1) {
																	var tempConfgIdArr = new Array();
																	for (var t = 0; t < configIds.length; t++) {
																		var blkItm = configIds[t];
																		if (blkItm != null && blkItm != blockId) {
																			tempConfgIdArr.push(blkItm)
																		}
																	}
																	var existingRefreshIntObj=refreshIntervalTaskObj[blockId];
																	refreshIntervalTaskObj[blockId]=window.clearInterval(existingRefreshIntObj);
																	existingRefreshIntObj=null;
																	delete existingRefreshIntObj;
																	publicJson['myDashboardConfigDetails']['configIds'] = tempConfgIdArr;
																	Ext.destroy(Ext.getCmp(blockId));
																}
															}
														});
														},600);
													}
												}
											});

										}
									});

		
		var menu = Ext.create('Ext.menu.Menu', {
									width:165,
									margin: '0 0 10 0',
									cls: 'iconDropDownMenu',
									floatable : true,
									floating: true,  // usually you want this set to True (default)
									renderTo:me.id+'_outer',  // usually rendered by it's containing component
									plain: true,
									shadow:false,
									listeners:{
									
										hide:function(menu){
											menu.destroy();
										}
									},
									items: widgetMenuItemsArr
								}).showAt([x,y]);
			return menu;
	},
	isSharedDashboard : false,
	isTopNComboInProgress : false,
	isAllowedToChangeTitle : false,
	blockType : '',
	showMoreDataOption : false,
	isOneClickDashboard : false,
	showCombo : false,
	isHighChartUpdate : false,
	mapLastLoadedURL : null,
	isWidgetResizeInProgress : false,
    initComponent: function() {
		var mePortlet=this;
		/*if(mePortlet.isChart)
		{
			mePortlet.renderChart(mePortlet,null,null);
		}*/
		var isPreviewMode=this.isPreviewMode;
        var thisBlkId = this.id;
		var blockType ='';
		if(thisBlkId.indexOf("_")>-1)
		{
			blockType = thisBlkId.substring(0, thisBlkId.indexOf("_"));
		}else{
			blockType =  thisBlkId;
		}
		this.blockType= blockType;
        mePortlet.toolsArr = [];
        var includeSettingsIcon = false;
		this.suspendEvents(false);
		var defaultAction = publicJson['action'];
		if (defaultAction != null && defaultAction == 'showMyDashboard') {
			this.isPreview=true;
		}
		else
		{
			this.isPreview=false;
		}
		var isOneClick = false;
		if(publicJson['myDashboardConfigDetails']['IsOneClickDashboard']!=null && publicJson['myDashboardConfigDetails']['IsOneClickDashboard']== 'yes')
		{
			isOneClick = true;
			this.isOneClickDashboard=true;
		}

		var isAllowedToEditSharedDashboard=false;
		if(publicJson['myDashboardConfigDetails']['isAllowedToEditSharedDashboard']==true)
		{
			isAllowedToEditSharedDashboard=true;
		}
		$('#'+blockType+'_header_hd').width("100%")
		if (thisBlkId != null && thisBlkId.indexOf("_") > 0 || (blockType=='currentalarms' || blockType=='tierhealth' || blockType=='proactivealerts' || blockType=='incidentssummary')) {

				if(blockType!=null && blockType=='dialChart' || blockType=='BarChart' || blockType=='TimelineChart' || blockType=='TrendGraph' || blockType=='CombinedTimelineChart' || blockType=='areaChart' || blockType=='combinationChart' || blockType=='pieChart' || blockType=='activityChart' || blockType=='proactivealerts')
				{
					this.bodyPadding=0;
				}
				//----YUVI - Published dashboard time combo start--------
				if(isPublishedDashboard && showTimelineForPublishedDashboard || (blockType=='incidentssummary'))
				{
					if(blockType!=null && (blockType=='TimelineChart' || blockType=='areaChart' || blockType=='incidentssummary'))
					{
						 mePortlet.toolsArr.push(Ext.create('Ext.form.ComboBox',{
									fieldLabel : timelineLbl,
									itemId : thisBlkId+'_timecombo',
									id : thisBlkId+'TimeLine_combo',
									style:{'display':'none'},
									height:24,
									labelStyle:'margin:-3px 0px 0px 0px',
									cls: 'dropdown',
									labelSeparator : '',
									labelWidth : 50,
									padding:0,
									width: 140,
									margin:'0 10 0 0',
									store: Ext.create('Ext.data.Store', {
										fields: ['displayField','valueField'],
										data: []
									}),
									listConfig:{
										listeners:{
											'itemclick':function(){
													this.up('panel').header.tools.forEach(function(tool,i){
														var toolId=tool.id;
													});
												mePortlet.isTopNComboInProgress=false;
											},
											'show':function(){
												mePortlet.isTopNComboInProgress=true;
											},'hide':function(){

											}
										}
									},
									editable:false,
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local',
									listeners :
									{
										'select' : function(combo) {
											mePortlet.isTopNComboInProgress=false;
											myDashApp.getController("Main").showGraphForTimelinechange(combo.getValue(),combo.up('panel'));
										}
									}


								}));
					}
				}
				//----Published dashboard time combo end--------
				if(blockType!=null && (blockType=='BarChart' || blockType=='table'))
				{
					if(mePortlet.isTopNChart || !isOneClick)
					{
						 mePortlet.toolsArr.push(Ext.create('Ext.form.ComboBox',{
									//xtype: 'scrollcombo',
									fieldLabel : showLbl,
							//		id : 'showCombo_'+new Date().getTime(),
									itemId : thisBlkId+'_combo',
									id : thisBlkId+'Barchart_combo',
									//hidden : true,
									style:{'display':'none'},
									height:24,
									labelStyle:'margin:-3px 0px 0px 0px',
									cls: 'dropdown',
									labelSeparator : '',
									labelWidth : 35,
									//padding:0,
									width: 120,
								//	flex:.5,
									margin:'0 10 0 0',
									store: Ext.create('Ext.data.Store', {
										fields: ['displayField','valueField'],
										data: []
									}),
									listConfig:{
										listeners:{
											'itemclick':function(){
													this.up('panel').header.tools.forEach(function(tool,i){
														var toolId=tool.id;
													});
												mePortlet.isTopNComboInProgress=false;
											},
											'show':function(){
												mePortlet.isTopNComboInProgress=true;
											},'hide':function(){

											}
										}
									},
									editable:false,
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode: 'local',
									listeners :
									{
										'select' : function(combo) {
										mePortlet.isTopNComboInProgress=false;
										myDashApp.getController("Main").showTopNGraph(combo.getValue(),combo.up('panel'));
										}
									}


								}));
					}
					if(!isPreviewMode && blockType=='table')
					{
						this.bodyPadding = "0 10px 10px 10px";
						 mePortlet.toolsArr.push({
							xtype:'trigger',
							id : 'searchTable_'+thisBlkId,
							name : 'searchTable_'+thisBlkId,
						//	labelWidth:40,
							//width:150,
							flex:.5,
							height:23,
							margin:'0 10 0 0',
							fieldLabel:'',
							hidden:false,
							cls: 'whitedropdown_search',
							emptyText:'Search',
							enableKeyEvents: true,
							onTriggerClick : function(event){
								 this.fireEvent("ontriggerclick",this, event);
							},
							listeners: {
								 'onTriggerClick' : function(obj) {
									  myDashApp.getController("Main").ontriggerclick(obj);
								 },
								 'keypress' : function(textfield,eventObject){
									if (eventObject.getCharCode() == Ext.EventObject.ENTER) {
										 myDashApp.getController("Main").ontriggerclick(textfield);
									}
								 }
							 },
							listConfig:{
									listeners:{
										'itemclick':function(){
												this.up('panel').header.tools.forEach(function(tool,i){
													var toolId=tool.id;
													//if(toolId!=null && (toolId!=barchartComboId && toolId!=ddTableComboId))
													{
														Ext.getCmp(toolId).hide();
													}
												});
											mePortlet.isTopNComboInProgress=false;
										},
										'show':function(){
											mePortlet.isTopNComboInProgress=true;
										},'hide':function(){
										}
									}
							 }
						});

					}
				}
				else if(!isPreviewMode && (blockType!=null && (blockType=='heatMapChart'|| blockType=='activityChart' || blockType=='pieChart' || blockType=='TopNGaugeChart' || blockType=='TopNDigitalChart' || blockType=='ddTable' || blockType=='liveMeasuresBox')))
				{
					if(blockType!=null && (blockType=='ddTable' || blockType=='liveMeasuresBox'))
					{
						 mePortlet.toolsArr.push(Ext.create('Ext.form.ComboBox', {
							//xtype: 'scrollcombo',
							fieldLabel: '',
					//		id : 'showCombo_'+new Date().getTime(),
							itemId: thisBlkId + '_combo',
							id: thisBlkId + 'dd_combo',
						//	hidden: true,
							cls: 'dropdown',
							labelSeparator: '',
							labelWidth:65,
						//	width: 230,
							margin:'0 10 0 10',
							labelStyle:'margin:3px 0px 0px 0px',
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							listConfig:{
								listeners:{
									'itemclick':function(){
										mePortlet.isTopNComboInProgress=true;
									},
									'show':function(){
										mePortlet.isTopNComboInProgress=true;
									},'hide':function(){
										
									},
									'containermouseover':function(){
										mePortlet.isTopNComboInProgress=true;
									},
									'containermouseout':function(){
										mePortlet.isTopNComboInProgress=false;
									},
								}
							},
							emptyText : descLbl,
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							emptyText:'Descriptors',
							listeners:
							{
								'select' : function(combo) {
									mePortlet.isTopNComboInProgress=false;
									myDashApp.getController("Main").showDDForSelectedDescptr(combo.getValue(), combo.up('panel'));
								}
							}

						}));
					}

					var viewDashLayoutObj = Ext.getCmp('dashboardLayoutObj');
					var paramsForData = 'action=loadBlockData&profileName=' + viewDashLayoutObj.profileName + '&blockId=' + thisBlkId + '&moreData=true';// + topN;
					mePortlet.toolsArr.push({
						xtype:'container',
						width:16,
						height:18,
						id : 'drilldownIcon_'+thisBlkId,
						name : 'drilldownIcon_'+thisBlkId,
						html : '<span class=\'iconMaximizeGray\' style="float:right;cursor:pointer;margin-right:5px;margin-top:0px" onclick="javascript:openTopNMoreOptionsPopup(\''+paramsForData+'\',\''+thisBlkId+'\');" data-qtip='+screenLabelsObj['More']+'&nbsp'+screenLabelsObj['Options']+'></span>'
					});
				}
				else if(!isPreviewMode && (blockType!=null && blockType=='TopologyWidget'))
				{
					 mePortlet.toolsArr.push(Ext.create('Ext.form.ComboBox', {
							//xtype: 'scrollcombo',
								fieldLabel : segmentLbl,
					//		id : 'showCombo_'+new Date().getTime(),
							itemId: thisBlkId + '_segmentcombo',
							id: thisBlkId + '_segmentcombo',
						//	hidden: true,
							cls: 'dropdown',
							labelSeparator: '',
							labelWidth:65,
						//	width: 230,
							margin:'0 10 0 10',
							labelStyle:'margin:3px 0px 0px 0px',
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							listConfig:{
								listeners:{
									'itemclick':function(){
										
										mePortlet.isTopNComboInProgress=false;
									},
									'show':function(){
										mePortlet.isTopNComboInProgress=true;
									},'hide':function(){

									}
								}
							},
							emptyText : descLbl,
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							emptyText:'Descriptors',
							topologyWidgetId : thisBlkId,
							listeners:
							{
								'select' : function(combo) {
									myDashApp.getController("WidgetConfigurationController").changeTopology(combo);
								}
							}

					}));
				}
				else if(!isPreviewMode && (blockType!=null && blockType=='vmAlarmsWidget'))
				{
					 mePortlet.toolsArr.push({
						xtype:'trigger',
						id : 'searchVms_'+thisBlkId,
						name : 'searchVms_'+thisBlkId,
						labelWidth:40,
						margin:'0 10 0 0',
						fieldLabel:'',
						cls: 'whitedropdown_search',
						emptyText:searchDispLbl,
						//hidden : true,
						listeners: {
							 change: {
								 fn: this.onTextFieldChange,
								 scope: this,
								 buffer: 100
							 }
						 }
					});
				}
				else if(blockType!=null && blockType=='currentalarms' || blockType=='tierhealth')
				{
					if(blockType=='currentalarms' && showAlarmSummary)
					{
						this.bodyPadding = "0 10px 10px 10px";
					}
					var profName = Ext.getCmp('dashboardLayoutObj').profileName;
					if(showComponentTypeFilter)
					{
						mePortlet.toolsArr.push({
								fieldLabel: '',
								labelAlign:'left',
								xtype: 'checkcombobox',
								width: 220,
								id:thisBlkId+'_Filter',
								name:thisBlkId+'_Filter',
								blockId : thisBlkId,
								margin:'0 0 0 0',
								editable: false,
								multiSelect:true,
							//	forceSelection:true,
								labelWidth:100,
								baseCls:'emptyCls',
								queryMode: 'local',
								labelSeparator:'',
								valueField: 'valueField',
								displayField: 'displayField',
								cls:'dropdown',
								emptyText:'Filter By Component Type',
								allText: 'All',
								stateId : profName+'_'+thisBlkId+'_stful',
								stateful : true,
								isComponentTypeFilterChanged : false,
								store:new Ext.data.Store({
												fields: ['valueField','displayField'],
												data: []
								}),
								addAllSelector: true,
								isDropDownloaded : false,
								listeners :  
								{
									'select' : function(combo) {
										Ext.defer(function(){
										myDashApp.getController("Main").loadDataForCompTypeFilter(combo);
										},500);
										
									},
									'beforedeselect' : function(combo)
									{
										if(combo.lastSelection.length==1)
										{
											combo.fireEvent('select', combo, []);
										}
									}
								},
								isLastRecord1 : function()
								{
									Ext.Msg.show({
												title : myDashboardAlertLbl,
												msg : compTypAlertMsg,
												buttons : Ext.MessageBox.OK,
												icon : Ext.MessageBox.WARNING
											});
										return;
								}
						});
					}
					else if(blockType=='currentalarms')
					{
						if(alertDistributionByServer)
						{
							mePortlet.toolsArr.push({
								xtype:'trigger',
								id : 'searchAlarms_'+thisBlkId,
								name : 'searchAlarms_'+thisBlkId,
								labelWidth:40,
								fieldLabel:'',
								cls: 'whitedropdown_search',
								emptyText:searchDispLbl,
								hidden : false,
								listeners: {
									 change: {
										 fn: this.onTextFieldChangeForAlert,
										 scope: this,
										 buffer: 100
									 }
								 }
							});
						}
						else
						{
							mePortlet.toolsArr.push({
								xtype:'trigger',
								id : 'searchAlarms_'+thisBlkId,
								name : 'searchAlarms_'+thisBlkId,
								labelWidth:40,
								fieldLabel:'',
								cls: 'whitedropdown_search',
								emptyText:searchDispLbl,
								hidden : false,
								widgetID : 	thisBlkId,
								enableKeyEvents: true,
								onTriggerClick : function(event){
									this.fireEvent("ontriggerclick",this, event);
								},
								listeners: {
									'onTriggerClick' : function(obj) {
									  myDashApp.getController("WidgetConfigurationController").onSearchTriggerclick(obj);
									 },
									 'keypress' : function(textfield,eventObject){
										if (eventObject.getCharCode() == Ext.EventObject.ENTER) {
											 myDashApp.getController("WidgetConfigurationController").onSearchTriggerclick(textfield);
										}
									 }
								 }
							});
						}
					}
				}
		}
		else
		{
			if(blockType!=null && blockType=='servicehealth')
			{
				this.bodyPadding=0;
			}
		}
		if(!this.isSharedDashboard || isAllowedToEditSharedDashboard)	
		{
			if((!isPreviewMode && !isPublishedDashboard && !isTvMode&& !isComponentDashboard && !isConsolidatedDashboard && !isMonitorHome) && thisBlkId!=null && thisBlkId.indexOf("_")>0)
			{
				var blockType = thisBlkId.substr(0,thisBlkId.indexOf("_"));
				/*if(blockType!=null && (blockType=='BarChart' || blockType=='TimelineChart' || blockType=='CombinedTimelineChart' || blockType=='areaChart' || blockType=='combinationChart' || blockType=='pieChart'))
				{
					
					//mePortlet.toolsArr.push(mePortlet.expandButton());
				}*/
				if(blockType!=null && showLegandPanelForWidgetsVal && (blockType=='BarChart' || blockType=='TimelineChart' || blockType=='TrendGraph' || blockType=='CombinedTimelineChart' || blockType=='areaChart' || blockType=='combinationChart'|| blockType=='activityChart' || blockType=='pieChart'))
				{
					mePortlet.toolsArr.push({
						xtype : 'button',
						cls:thisBlkId+'colorPalette dragTools',
						height:16,
						width:16,
						margin:'2 5 0 6',
						id: 'mybutton_'+thisBlkId,
						blockId:thisBlkId, 
						iconCls:'iconSpilitOnWidget',
						enableToggle:true,
						tooltip:legendPnlTootltip,
						handler: function(c){
							if(c.pressed == true){
								Ext.getCmp('border_'+thisBlkId).expand(false);
								c.setTooltip(legendPnlHideTootltip);
								if(blockType=='BarChart'){
									Ext.getCmp('ChartArea_'+thisBlkId).removeCls('HorzBar_panel')
								}
							}else{
								Ext.getCmp('border_'+thisBlkId).collapse();
								$('#border_'+thisBlkId+'-splitter').addClass('x-splitter-collapsed');
								if(blockType=='BarChart'){
									Ext.getCmp('ChartArea_'+thisBlkId).addCls('HorzBar_panel')
								}
								c.setTooltip(legendPnlTootltip);
							}		
						}
					 });
				}
				if(blockType!=null && (blockType=='BarChart' || blockType=='TrendGraph' || blockType=='TimelineChart' || blockType=='CombinedTimelineChart' || blockType=='areaChart' || blockType=='combinationChart' || blockType=='activityChart' || blockType=='pieChart' || blockType=='heatMapChart'))
				{
					 mePortlet.toolsArr.push({
						xtype : 'button',
						cls:'dragTools',
						height:20,
						id:thisBlkId+'colorPalette',
						width:16,
						margin:'0 3 0 0',
						iconCls:'colorTool',
						tooltip : changeGraphColorPaletteLbl,
						blockId : thisBlkId,
						handler : function()
						{
							mePortlet.isTopNComboInProgress=false;
							this.selectedGraphPalette=this.up('panel').selectedGraphPalette;
							myDashApp.getController("Main").showPaletteWindow(this);
							mePortlet.isTopNComboInProgress=true;
						}
					});
				}

				if(blockType!=null && (blockType=='dialChart' || blockType=='TopNGaugeChart'))
				{
					 mePortlet.toolsArr.push({
						xtype : 'button',
						cls:'dragTools',
						height:20,
						id:thisBlkId+'colorPicker',
						width:16,
						margin:'0 3 0 0',
						iconCls:'colorTool',
						tooltip : changeColorPickerLbl,
						blockId : thisBlkId,
						hidden  : false,
						handler : function()
						{
							mePortlet.isTopNComboInProgress=false;
							this.selectedGaugeColor=this.up('panel').selectedGaugeColor;
							myDashApp.getController("Main").showColorPickerWindow(this);
							mePortlet.isTopNComboInProgress=true;
						}
					});
				}
				if(blockType!=null && (blockType=='textWidget'))
				{
					this.ui='newGraphPanel toshadow myDashWidgetPad textWidgetDrag';
				}
				if(isOneClick == true && blockType!=null && blockType=='vmAlarmsWidget')
				{
					includeSettingsIcon=false;
				}
				else if(!isOneClick && (blockType!=null && (blockType=='TopNGaugeChart' || blockType=='TopNDigitalChart')))
				{
					includeSettingsIcon=false;
				}
				else
				{
					includeSettingsIcon=true;
				}
			}
			else if(!isPreviewMode && !isTvMode && thisBlkId!=null && (thisBlkId=='weather' || thisBlkId=='news' || thisBlkId=='userExperience') )
			{
				includeSettingsIcon=true;
			}
			if(isMonitorHome || isComponentDashboard || isConsolidatedDashboard)
			{
				includeSettingsIcon=false;
			}

			if(!isPreviewMode && !isMonitorHome && !isPublishedDashboard && !isComponentDashboard && !isConsolidatedDashboard && !isTvMode)
			{
				mePortlet.toolsArr.push({
						
						xtype:'button',
						cls:'iconbuttonclass',
						margin:'0 0 0 3',
						style: {'background':'none','border':'none'},
						//text: 'Menu', 
						icon: '../images/'+strSkin+'/menuIcon_active.png', // icons can also be specified inline
						//cls: 'x-btn-icon',
						id:thisBlkId+'menubutton',
						handler:function(btn){
							//alert(btn.el.getX(),btn.el.getY());
							mePortlet.popup(btn,btn.el.getX(),btn.el.getY());
							//TODO
						}

					});
			}
			if(!isPreviewMode && !isMonitorHome && !isComponentDashboard && !isConsolidatedDashboard && !isTvMode)
			{
				this.isAllowedToChangeTitle=true;
			}
			//this.addListener("afterrender",this.changeTitle);
		}
        this.tools =  mePortlet.toolsArr;
        //this.addListener("beforeclose",this.beforeclosefn);
		this.resumeEvents();
        this.callParent();

    },
    blkType: '',
    highChartObj: null, /*storing highchart for refresh*/
    isTopNChart: false,
    hideMaxmizeIcon: false,
    isRequestTimeoutHappened: false,
    isInitialResizeCompleted: false,
    layerModelUrl: null, // this is used for dial,digital, and pie charts
    selectedGraphPalette: null,
    selectedGaugeColor: null,
	showTopNCombo : false,
	changeTitle:function(){
		var me =this;
		var dragedColHeader =Ext.get(me.header.id+'_hd-textEl');
				
		Ext.get(me.header.id).on('dblclick', function(e,target){
				//Ext.get(me.header.id+'_hd-textEl').setVisible(false)

				$('#'+me.header.id+'_hd').css({"text-overflow":"clip"});

 						var layerheader = me.getWidth() - 90;
						var edtrText=dragedColHeader.dom.innerHTML;
						var editedblck=me.id;
						var timelineTxt='';
						if(editedblck!=null && editedblck.lastIndexOf("_")>0)
						{
							editedblck=editedblck.substring(0,editedblck.lastIndexOf("_"));
							/*if(editedblck!=null && (editedblck=="TrendGraph" || editedblck=="TimelineChart" || editedblck=="CombinedTimelineChart" || editedblck=="areaChart" || editedblck=="combinationChart"))
							{
								if(edtrText!=null && edtrText.lastIndexOf("-")>0)
								{
									timelineTxt=edtrText.substring(edtrText.lastIndexOf("-")+1);
									timelineTxt=Ext.util.Format.trim(timelineTxt);
									edtrText=edtrText.substring(0,edtrText.lastIndexOf("-"));
									edtrText=Ext.util.Format.trim(edtrText);
								}
							}*/
						}
						var widgetTitleEditor = new Ext.Editor({
						width: 150,
                        alignment: 'tl',
                        floating: false,
                        shadow: false,
                        updateEl: true,
						ignoreNOChange: true,
                        completeOnEnter: true,
                        cancelOnEsc: true,
						field: {
							xtype: 'textfield',
							cls: 'headerTextEdit'
						},
                        listeners: {
                            'beforecomplete': function (meEdtr, value, startValue, eOpts) {
                                if (value == null || value == '') {
                                    meEdtr.setValue(startValue);
                                    Ext.Msg.show({
                                        title: myDashboardAlertLbl,
                                        msg: emptyHeadrMsg,
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.WARNING
                                    });
                                    return false;
                                }
                            },
                            'complete': function (meEdtr, value, startValue, eOpts) {
								
								$('#'+me.header.id+' .x-panel-header-text').attr('data-qtip',value)
                                var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
                                Ext.Ajax.request({
                                    url: '/final/servlet/com.eg.egMyDashboardController',
                                    method: 'POST',
                                    params: '&action=rename&profileName=' + encodeURIComponent(profileName) + '&key=' + me.id + '_Title&value=' + encodeURIComponent(value),
                                    success: function (response) {
                                        var jsonText = response.responseText;
                                        if (jsonText != null && jsonText != '') {
                                            var jsonData = Ext.decode(jsonText);
										if(editedblck!=null && (editedblck=="TrendGraph" || editedblck=="TimelineChart" || editedblck=="CombinedTimelineChart"))
										{
											if(timelineTxt!=null && timelineTxt!="")
											{
												dragedColHeader.dom.innerHTML=value+" - "+timelineTxt;
                                        }
                                    }
									}
								}
                                });
									$('.editor_layer').remove();
									$('#'+me.header.id+'_hd').css({"text-overflow":"ellipsis"});
                            }
                        }
					});
					var el = Ext.get(me.header.id+'_hd-textEl');
					widgetTitleEditor.startEdit(el,edtrText);
  					$("#"+me.header.id).append('<div class="editor_layer" style="position:absolute;top:0px;height:50px;width:'+layerheader+'px">---</div>');
                                        $( "#dashboardLayoutObj-body" ).scroll(function() {
										if(!Ext.isEmpty(widgetTitleEditor)){
											widgetTitleEditor.cancelEdit(false);
										}
                                        $('.editor_layer').remove();
                                 });

			}, me, {
				 delegate: '#'+me.header.id+'_hd-textEl'
			});
			widgetTitleEditor = null;
	},
	listeners : {
		'afterrender' :  function(c)
		{
			if(c.rendered ==true)
			{
				if(c.blockType!=null && c.blockType== "textWidget")
				{
					var textHeader1 = c.getHeader().setVisible(false);
					
				}
				//TITLE 
				c.porletSetTitle = function(title){
						if(!Ext.isEmpty(c)){
							c.setTitle(title);
							$('#'+c.id+' .x-panel-header-text').attr('data-qtip',title);
						}
				};
				var isPredefinedLayout=Ext.getCmp('dashboardLayoutObj').isPredefinedLayout;
				if(c.action!=null && c.action=='loadWidget')
				{
					var profName = publicJson['myDashboardConfigDetails']['profileName'];
					profName = myDashApp.getController("Main").replaceHtmlTag(profName," &lt; ","<");
					profName = myDashApp.getController("Main").replaceHtmlTag(profName," &gt; ",">");
					var configIds = publicJson['myDashboardConfigDetails']['configIds'];
					if (configIds != null && configIds.indexOf(c.id) > -1)
					{
						myDashApp.getController("Main").loadDataForBlock(this, profName, c.id,true);
					}else{
						var configPanl=Ext.getCmp(c.id);
						configPanl.removeAll();
						if(isPredefinedLayout)
						{
							configPanl.add(myDashApp.getController("Main").configureWidget('iconOneClickHeaderAddWidget',c.id));
						}
						else
						{
							configPanl.add({
								xtype : 'panel',
								layout:{
									type:'fit',
								},
								html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+WidgetNotConfigMsg+'</div></div></div>'
							});
						}

						
						
					}
				}
				else if(isPredefinedLayout && (c.id).indexOf("Widget_")==0)
				{
					var configPanl=Ext.getCmp(c.id);
					configPanl.removeAll();
					configPanl.add(myDashApp.getController("Main").configureWidget('iconOneClickHeaderAddWidget',c.id));
				}
			}
		},
		'boxready':function(c){

			var ddSelectionContainerObj=null;
			var ddSelectionContainerObjComp=null;
			var compComboObj=null;
			var descComboObj=null;
			var ddTBar=null;
			var isShowHideDDCombos=false;
			var isShowDDComboOnly=false;
			var oneClickDashboard=false;
			if(publicJson!=null && publicJson['myDashboardConfigDetails'].hasOwnProperty('IsOneClickDashboard'))
			{
				if(publicJson['myDashboardConfigDetails']['IsOneClickDashboard'] == "yes")
				{
					oneClickDashboard=true;
				}
			}
			if(!oneClickDashboard)
			{
				if(isOneClickDashboard==true || isOneClickDashboard=="true" || isOneClickDashboard=="yes")
				{
					oneClickDashboard=true;
				}
			}
			var isPreviewMode=c.isPreviewMode;
			descComboObj = Ext.getCmp(c.id + 'dd_combo');
			if(!isPreviewMode && c.header){
				var barchartComboId=c.id+'Barchart_combo';
				var ddTableComboId=c.id+'dd_combo';
				c.tools.forEach(function(tool,i){
					var toolId=tool.id;
					var el = Ext.getCmp(toolId).el.setVisibilityMode(Ext.Element.DISPLAY);
					if(toolId!=null && (toolId==barchartComboId) )
					{
						if(c.isTopNChart)
						{

							el.hide();
						}
					}
					else
					{
						el.hide();
					}
				});
				var set_temp  = Ext.getCmp(c.id+'_header_hd');
				if(set_temp != '' && set_temp != null && set_temp != "undefined"){
					set_temp.flex = 0;
					set_temp.setWidth(c.width - 20)
				}
				c.mon(c.el,'mouseenter',function(){
					
					if(!c.isTopNComboInProgress)
					{
						c.tools.forEach(function(tool,i){
								var toolId=tool.id;
								var el = Ext.getCmp(toolId).el.setVisibilityMode(Ext.Element.DISPLAY);
							if(toolId!=null && (toolId==barchartComboId))
							{
								if(c.isTopNChart && c.showTopNCombo)
								{
									el.show();

									// widgetComboSelectionToolbarHover
									// widgetComboSelectionToolbar
								}
							}
							else if(toolId.indexOf('mybutton_') > -1)
							{
								if(c.isChart)
								{
									if(c.errorMsg=='-')
									{
										el.show();
									}
									else
									{
										el.hide();
									}
								}
							}
							else if(toolId.indexOf('dd_combo') > -1)
							{
								var ddCombo = c.showCombo;
								if(ddCombo == true)
								{
									el.show();
								}
								else{
									el.hide();
								}
								
								
							}
							else if(toolId.indexOf('segmentcombo') > -1)
							{
								var showSegCombo = c.showCombo;
								if(showSegCombo == true)
								{
									el.show();
								}
								else{
									el.hide();
								}
							}
							else if(toolId.indexOf('drilldownIcon_')>-1)
							{
								if(c.showMoreDataOption)
								{
									el.show();
								}
								else 
								{
									el.hide();
								}
							}
							else if(toolId.indexOf('searchTable')>-1)
							{
								var isPagination = c.isPaginationNeeded;
								if(isPagination == true)
								{
									
									//el.show();
									el.setVisible(true);
								}
								else{
									el.setVisible(false);
								}	
							}
							else if(toolId.indexOf('colorPicker')>-1)
							{
								if(c.showColorPicker)
								{
									var needToShow = true;
									if(!isHighchartForGauge && c.blockType=='dialChart')
									{
										needToShow = false;
									}
									if(needToShow)
									{
										el.show();
									}
								}
								else
								{
									el.hide();
								}
							}
							else if((toolId.indexOf('TimeLine_combo')>-1) && c.showTimelineCombo)
							{
								el.show();
								
							}
							else if(!isMonitorHome && !isPublishedDashboard && !isTvMode)
							{
								el.show();
							}
						});
						var set_temp  = Ext.getCmp(c.id+'_header_hd');
						if(set_temp != '' && set_temp != null && set_temp != "undefined"){
							set_temp.flex = 1;
							set_temp.setWidth("100%")
						}
					}
				});
//				},c.header);

				c.mon(c.el,'mouseleave',function(){
					
					if(!c.isTopNComboInProgress)
					{
						c.tools.forEach(function(tool,i){
							var toolId=tool.id;
							var el = Ext.getCmp(toolId).el.setVisibilityMode(Ext.Element.DISPLAY);
							if(toolId!=null && (toolId==barchartComboId))
							{
								if(c.isTopNChart)
								{
									el.hide();
								}
							}
							else if(toolId.indexOf('searchTable')>-1)
							{
								el.setVisible(false);
							}
							else if((toolId.indexOf('TimeLine_combo')>-1) && c.showTimelineCombo)
							{
								el.setVisible(false);
								
							}
							else
							{
								el.hide();
							}
						});
						var set_temp  = Ext.getCmp(c.id+'_header_hd');
						if(set_temp != '' && set_temp != null && set_temp != "undefined"){
							set_temp.flex = 0;
							set_temp.setWidth(c.width - 20)
						}
					}
					if(Ext.getCmp('border_'+c.id) != null && Ext.getCmp('border_'+c.id) != '' && Ext.getCmp('border_'+c.id) != 'undefined'){
						if((Ext.getCmp('border_'+c.id).hidden == false)){
							Ext.getCmp('border_'+c.id).collapse();
							$('#border_'+c.id+'-splitter').addClass('x-splitter-collapsed')
							Ext.getCmp('mybutton_'+c.id).setTooltip(legendPnlTootltip);
							Ext.getCmp('mybutton_'+c.id).pressed = false;
							$('#mybutton_'+c.id).removeClass('x-btn-pressed')
							if(c.blockType=='BarChart'){
								Ext.getCmp('ChartArea_'+c.id).addCls('HorzBar_panel')
							}
						}
					}
						
				
				
				});
				
//				},c.header);
			}
			if(!isPreviewMode && c.isConfigured)
			{
				refreshIntervalTaskObj[c.id]=setInterval(function() { refreshPanel(c) },dashboardRefFreq);
			}
			if(c.isAllowedToChangeTitle)
			{
				this.changeTitle(c);
			}
		}
	},
	resizeChart : function(c)
	{
		var configPanl=this;
		if (configPanl!=null && (configPanl.isWidgetResizeInProgress || configPanl.isInitialResizeCompleted == false || Ext.isEmpty(configPanl.highChartObj))) {
			configPanl.isInitialResizeCompleted = true;
			return;
		}
		switch(configPanl.blockType)
		{
			case 'pieChart' :
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					Ext.defer(function(){
						configPanl.highChartObj.highchart.chart.height=c.getHeight() - 7;
						configPanl.highChartObj.highchart.chart.width=c.getWidth() - 15;
						configPanl.highChartObj.drawChart();
					},500);
				}
				break;
			case 'activityChart' :
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					Ext.defer(function(){
						configPanl.highChartObj.height=c.getHeight() - 7;
						configPanl.highChartObj.width=c.getWidth() - 15;
					},500);
				}
				break;
			case 'BarChart':
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
				if(configPanl.isTopNChart)
				{		
					if(configPanl.chartType == 'column')
					{
						//barHeightVal= c.getHeight()-50;
						barHeightVal= c.getHeight()-7;
					}else{
						barHeightVal = configPanl.barHeight;
						if(c.getHeight()>barHeightVal)
						{
							barHeightVal =  c.getHeight();
						}
					}											
				}else{
					if(configPanl.chartType=='column')
					{
						//barHeightVal = c.getHeight()-35;
						barHeightVal = c.getHeight()-7;
					}else{
						barHeightVal =  configPanl.barHeight-25;
						if(c.getHeight()>barHeightVal)
						{
							barHeightVal =  c.getHeight();
						}
					}
				}
					Ext.defer(function(){
						//configPanl.highChartObj.highchart.chart.height=c.getHeight() - 7;
						configPanl.highChartObj.highchart.chart.height=barHeightVal;
						configPanl.highChartObj.highchart.chart.width=c.getWidth() - 15;
						configPanl.highChartObj.drawChart();
					},500);
				}
				break;
			case 'incidentssummary' :
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					barHeightVal = c.getHeight()-7;

				Ext.defer(function(){
						//configPanl.highChartObj.highchart.chart.height=c.getHeight() - 7;
						configPanl.highChartObj.highchart.chart.height=barHeightVal;
						configPanl.highChartObj.highchart.chart.width=c.getWidth() - 15;
						configPanl.highChartObj.drawChart();
					},500);
			}
			break;
			case 'areaChart' :
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					Ext.defer(function(){
					//	configPanl.highChartObj.highchart.chart.height=c.getHeight()-35;
						configPanl.highChartObj.highchart.chart.width=Math.round(c.getWidth() - 15);
						configPanl.highChartObj.drawChart();
					},500);
				}
				break;
			case 'combinationChart':
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					Ext.defer(function(){
					//	configPanl.highChartObj.highchart.chart.height=c.getHeight()-35;
						configPanl.highChartObj.highchart.chart.width=Math.round(c.getWidth() - 15);
						configPanl.highChartObj.drawChart();
					},500);
				}
				break;
			case 'TimelineChart':
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					Ext.defer(function(){
				//	configPanl.highChartObj.highchart.chart.height=c.getHeight()-35;
					configPanl.highChartObj.highchart.chart.width=Math.round(c.getWidth() - 15);
					configPanl.highChartObj.drawChart();
					},500);
				}
				break;
			case 'TrendGraph':
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					Ext.defer(function(){
				//	configPanl.highChartObj.highchart.chart.height=c.getHeight()-35;
					configPanl.highChartObj.highchart.chart.width=Math.round(c.getWidth() - 24);
					configPanl.highChartObj.drawChart();
					},500);
				}
				break;
			case 'CombinedTimelineChart':
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					Ext.defer(function(){
						configPanl.highChartObj.highchart.chart.height=Math.round(c.getHeight() - 7);
						configPanl.highChartObj.highchart.chart.width=Math.round(c.getWidth() - 15);
						configPanl.highChartObj.drawChart();
					},500)
				}
				break;
			case 'servicehealth':
				if(configPanl.highChartObj != '' && configPanl.highChartObj !=null){
					Ext.defer(function(){
						configPanl.highChartObj.highchart.chart.height=c.getHeight() - 7;
						configPanl.highChartObj.highchart.chart.width=c.getWidth() - 15;
						configPanl.highChartObj.drawChart();
					},500)
				}
			break;
			case 'dialChart':
				if (configPanl.highChartObj != null) {
					var hCHart = configPanl.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var width = jQuery(renderTo).outerWidth();
					var height = jQuery(renderTo).outerHeight();
					var adjWidth=c.getWidth();
					var adjHeight=c.getHeight();
					
					if(configPanl.highChartObj.hasOwnProperty('full_guage') && configPanl.highChartObj.full_guage==true)
					{
						Ext.defer(function(){
							configPanl.highChartObj.highchart.chart.height=c.getHeight() - 7;
							configPanl.highChartObj.highchart.chart.width=c.getWidth() - 15;
							configPanl.highChartObj.drawChart();
						},500);
					}
					else
					{
						if (hCHart.container) {
							hCHart.width = adjWidth - 20;
							hCHart.height = adjHeight - 20;
						}
						hCHart.width = adjWidth - 200;
						hCHart.height = adjHeight - 20;
						Ext.select('#' + configPanl.id + ' .timelineDiv').setHeight(adjHeight - 10);
						Ext.select('#' + configPanl.id + ' .timelineDiv > div').setHeight(adjHeight - 10);
						Ext.select('#' + configPanl.id + ' > .highcharts-container').setHeight(adjHeight - 10);
						Ext.select('#' + configPanl.id + ' .highcharts-container > svg').setHeight(adjHeight - 10);
						var chart = jQuery('#'+renderTo).highcharts();
						Ext.defer(function(){
							chart.setSize(
								$('#'+configPanl.id)[0].offsetWidth-20, 
								$('#'+configPanl.id)[0].offsetHeight-20,
								true
							); 
						},500);
					}
				}
				break;
			case 'TopNGaugeChart':
				if (configPanl.highChartObj != null) {
					var hCHart = configPanl.highChartObj.highchart.chart;
					var renderTo = hCHart.renderTo;
					var adjWidth=c.getWidth();
					var adjHeight=c.getHeight();
					var width = jQuery('#'+renderTo).outerWidth();
					var height = jQuery('#'+renderTo).outerHeight();
					if(configPanl.highChartObj.hasOwnProperty('full_guage') && configPanl.highChartObj.full_guage==true)
					{
						Ext.defer(function(){
							configPanl.highChartObj.highchart.chart.height=c.getHeight() - 7;
							configPanl.highChartObj.highchart.chart.width=c.getWidth() - 15;
							configPanl.highChartObj.drawChart();
						},500);
					}
					else
					{
						if (hCHart.container) {
							hCHart.width = adjWidth - 20;
							hCHart.height = adjHeight - 20;
						}
						var chart = jQuery('#'+renderTo).highcharts();
						Ext.defer(function(){
							chart.setSize(
								$('#'+configPanl.id)[0].offsetWidth-20, 
								$('#'+configPanl.id)[0].offsetHeight-20,
								true
							); 
						},500);
					}
				}
			break;
		}
	},
	setRefresh: function(c)
	{			
		if(!c.isConfigured)
		{
			refreshIntervalTaskObj[c.id]=setInterval(function() { refreshPanel(c) },dashboardRefFreq);
		}
	},

	onTextFieldChange: function(triggerField, newValue, oldValue, eOpts) {
        var me = this;
		var thisBlkId = this.id;
		var grid = Ext.getCmp(thisBlkId+'_Grid');
		if(!Ext.isEmpty(grid))
		{
			if(newValue=="*")
			{
				grid.store.clearFilter();
			}
			else
			{
				if(newValue.lastIndexOf("*")==(newValue.length-1))
				{
					newValue = newValue.substr(0,(newValue.length-1));
				}
				grid.store.clearFilter();
				if (newValue) {
					var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
					grid.store.filter({
						filterFn: function(record) {
							var stateNameArray = record.get('vmName').split("!*!");
							var match= matcher.test(stateNameArray[1]) ;
							if(!match)
								match= matcher.test(record.get('CompName')) ;

							return match;
						}
					});
				}
			triggerField.focus();
			}
			
		}
	},
	destoryChart :  function(){
			var me = this;
			try
			{
				if(this.isChart)
				{
					var chartParentId='ChartArea_'+me.id;
					var $chart = $('#'+chartParentId).find('div.highcharts-container');
					
					if(!Ext.isEmpty($chart)){
						var $chartObj = $($chart).parent().attr('id');
						var _highchart = $('#'+$chartObj).highcharts();
						if(_highchart){
							$('#'+$chartObj).highcharts().destroy();
						}else{
							$($chartObj).unbind();
						}
						$('#'+chartParentId  > 'svg').unbind();
						$chartObj = null;
						_highchart = null
						delete $chartObj;
						delete _highchart;
					}
					Ext.getCmp(chartParentId).removeAll();
					for (var keys in Ext.getCmp(chartParentId))
					{
						if(!Ext.getCmp(chartParentId)[keys]){
							delete Ext.getCmp(chartParentId)[keys];
						}
					}
				}
				else
				{
					var $chart = $('#'+me.id).find('div.highcharts-container');
					var gridID = Ext.getCmp(me.id);
					
					if(gridID.items.length != 0){
						if(gridID.down('grid')){
							Ext.destroy(gridID.down('grid').store);
						}
						
						for (var i =0;i< gridID.items.length;i++ )
						{
							Ext.destroy(gridID.items[i]);
						}
					
					}
					if(!Ext.isEmpty($chart)){
						$chartObj = $($chart).parent().attr('id');
						_highchart = $('#'+$chartObj).highcharts();
						if(_highchart){
							$('#'+$chartObj).highcharts().destroy();
						}else{
							$($chartObj).unbind();
						}
						$('#'+me.id  > 'svg').unbind();
						$chartObj = null;
						_highchart = null
						delete $chartObj;
						delete _highchart;
					}
					gridID.removeAll();
					for (var keys in Ext.getCmp(me.id))
					{
						if(!Ext.getCmp(me.id)[keys]){
							delete Ext.getCmp(me.id)[keys];
						}

						
					}
				}
			}
			catch (err)
			{
				console.log("error "+err);
			}
		},
		onTextFieldChangeForTable: function(triggerField, newValue, oldValue, eOpts) {
		var me = this;
		isChanged = true;
		var thisBlkId = this.id;
		var tableGrid = Ext.getCmp(thisBlkId+'_Grid');
				
		if(!Ext.isEmpty(tableGrid))
		{
			if(newValue=="*")
			{
				tableGrid.store.clearFilter();
			}
			else
			{
				if(newValue.lastIndexOf("*")==(newValue.length-1))
				{
					newValue = newValue.substr(0,(newValue.length-1));
				}
				tableGrid.store.clearFilter(true);
				if (newValue) {
					var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
					tableGrid.store.filter({
						filterFn: function(record) {
							var stateNameArray = record.get('COLUMN_0').substring(record.get('COLUMN_0').lastIndexOf('$')+1,record.get('COLUMN_0').size);
							var match= matcher.test(stateNameArray) ;
							if(!match)
							{
								tableGrid.getView().emptyText ='<table width="100%" height="100%" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div styel="margin:10px auto">'+ ''+screenLabelsObj['No data found for'] +'"'+newValue+'"</div></td></tr></table>';
							}
							return match;
						}
					});
				}else{
					tableGrid.getView().emptyText='<table width="100%" height="100%" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div styel="margin:10px auto">'+noMeasuresFoundMsg;
				}
				tableGrid.getView().refresh();
				triggerField.focus();
				
			}
		}
     },
	 hideLoadingMask : function()
	 {
		if(this.showLoadingMsg)
		{
			this.disablePanelToolBar(false);
			this.showLoadingMsg=false;
			this.setLoading(false);
			
		}
	 },
	 onTextFieldChangeForAlert: function(triggerField, newValue, oldValue, eOpts) {
        var me = this;
		var thisBlkId = this.id;
		//var grid = Ext.getCmp(thisBlkId+'_Grid');
		var grid = Ext.getCmp('CurrentAlarms_Grid');
		if(!Ext.isEmpty(grid))
		{
			if(newValue=="*")
			{
				grid.store.clearFilter();
			}
			else
			{
				if(newValue.lastIndexOf("*")==(newValue.length-1))
				{
					newValue = newValue.substr(0,(newValue.length-1));
				}
				grid.store.clearFilter();
				if (newValue) {
					var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
					grid.store.filter({
						filterFn: function(record) {
							var compNameVal ='';
							var compName = record.get('COMP_NAME');
							if(compName != '' && compName != null && compName != "undefined"){
								var alertDesc = record.get('ALERT_DESC');
								compNameVal = compName+alertDesc;
							}else{
								var stateNameArray = record.get('CompName').split("!*!");
								compNameVal = stateNameArray[1];
							}
							var match= matcher.test(compNameVal) ;
							if(!match)
							{
								grid.getView().emptyText ='<table width="100%" height="100%" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div styel="margin:10px auto">'+ ''+screenLabelsObj['No data found for'] +'"'+newValue+'"</div></td></tr></table>';
							}
							return match;
						}
					});
				}
			triggerField.focus();
			}
		}
     },
	disablePanelToolBar : function(disableTool)
	{
		this.tools.forEach(function(tool,i){
					var toolId=tool.id;
					var el = Ext.getCmp(toolId);
					if(disableTool)
						el.setDisabled(true);
					else
						el.setDisabled(false);
				});
	}

});