Ext.define('MyDashBoard.view.RESTWidgetConfigPopup', {
    extend: 'Ext.window.Window',
    alias: 'widget.restwidgetconfpopup',
    requires: ['utilities.CustomGrid','utilities.ScrollCombo','utilities.CommonPanel','MyDashBoard.view.RESTHeaderGrid','MyDashBoard.view.RESTBodyUrlEncodedGrid','MyDashBoard.view.RESTFileUploadForm','MyDashBoard.view.RestFileUploadFormExcel','MyDashBoard.view.RESTFileUploadGrid'],
    width: 780,
    modal: true,
	border:false,
	frame:false,
    autoShow: false,
	ghost:false,
	padding:'0 0 0 0',
	autoScroll:true,
	header:{
		height:50,
		padding:'0 20',
		margin:0
	},
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	autoShow : false,
	ui:'newPopupWindow   widgetOptionsWindowHeader',
    cls:'myDashboardwindow',
	height:550,
	blockId : null,
	scroll : true,
	autoScroll : true,
	isFluidWindowConfigPopup : true,
	closeAction : 'destroy',
	 id: 'restDashMainPnl',
	dataFieldsComboIdArr : [],
	initComponent : function()
	{
		this.buttonAlign = 'center';
		this.callParent();
	},
	items: [{
		xtype: 'container',
		itemId : 'restconfigForm',
		buttonAlign: 'center',
		defaults: {
			padding: '0',
			margin: '0',
		},
	/*	buttons: [{
				text: 'Add',
				id: 'restURLSubmitBtn',
				name: 'restURLSubmitBtn',
				cls: 'button20'
			}],*/
		items: [
		{
			xtype : 'commonPanel',
			title : screenLabelsObj['Data Source Configuration'],
				id : 'REST_DS_Container',
				name : 'REST_DS_Container',
				tools : [/*{
						xtype : 'button',
						id : 'saveDSNBtn',
						name : 'saveDSNBtn',
						//text : 'Create DSN'`,
						iconCls : 'iconSave',
						tooltip : 'click here to save'
					}*/],
				items : [
					{
						xtype: 'radiogroup',
						width: 450,
					//	labelAlign: 'left',
						margin : '12 0 0 10',
						labelWidth:250,
						fieldLabel: screenLabelsObj['Data Source'],
						id: 'ds_rdp_grp',
						name: 'ds_rdp_grp',
						items: [{
							boxLabel: 'New',
							name: 'ds_opt',
							inputValue: 'New',
							cls: 'radiobt',
							checked : true
						}, {
							boxLabel: screenLabelsObj['Existing'],
							name: 'ds_opt',
							inputValue: 'Existing',
							cls: 'radiobt'
						}]
					},
			{
					xtype : 'combo',
					cls: 'dropdown',
					fieldLabel: screenLabelsObj['Select a Data Source'],
					id: 'DSNCombo',
					name: 'DSNCombo',
					width: 280,
					margin:'12 0 0 10',
					store: Ext.create('Ext.data.Store', {
						fields: ['displayField', 'valueField'],
						data: []
					}),
					editable: false,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					hidden : true
			}
			/*,{
				xtype : 'button',
				id : 'addDSNBtn',
				name : 'addDSNBtn',
				text : 'ADD DSN',
				hidden : true,
				handler : function()
				{
					var RESTConfigContObj=Ext.getCmp('RESTConfigCont');
					RESTConfigContObj.show();
				}
			}*/]
		},{
				xtype : 'container',
				id : 'RESTConfigCont',
			//	title : 'Configure Data Source',
				name : 'RESTConfigCont',
				items : [
					{
						xtype : 'textfield',
						fieldLabel : screenLabelsObj['Enter DSN Name'],
						margin : '12 0 0 10',
						width : 500,
						id : 'restdsnname',
						name : 'restdsnname',
						cls: 'textbox'
					},
						{
						xtype: 'combo',
						cls: 'dropdown',
						fieldLabel: screenLabelsObj['Integration Options'],
						id: 'integration',
						name: 'integration',
						width: 280,
						margin:'12 0 0 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField', 'valueField'],
							data: [{"displayField" : screenLabelsObj['REST'],"valueField" : "REST"},{"displayField" : screenLabelsObj['SQL'],"valueField" : "SQL"},{"displayField" : screenLabelsObj['EXCEL'],"valueField" : "EXCEL"},{"displayField" : screenLabelsObj['CSV'],"valueField" : "CSV"}]
						}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						value : 'REST'
					},
						{
						xtype: 'RESTFileUploadForm',
						cls: 'fileupload',
						margin:'12 0 0 10',
						width: 280,
						//fieldLabel: 'File',
						//allowBlank: false,
						//buttonText: 'Browse',
						//name : 'fileUpload',
						id : 'fileUploadForm',
						hidden : true,
						},
							
						{
						xtype : 'container',
						id : 'rowSelector',
						margin : '10 0 0 10',
						hidden : true,
						layout: {
							type: 'hbox',
							align: 'stretch'
						},
						items : [
							{
							xtype : 'label',
								margin: '0 40 0 0',
							text: screenLabelsObj['Header Row'],
							},
							{
							xtype : 'button',
							id : 'minus',
							name : 'minus',
							//margin : '10 0 0 120',
							text : '-',
							handler: function() {
								var headerRowObj=Ext.getCmp('headerRow');
								var headerRow=headerRowObj.getValue();
								if(headerRow>0)
								{
									headerRow--;
								}
								headerRowObj.setValue(headerRow);
							}
							},
								{
							xtype: 'numberfield',
							name: 'header',
							id: 'headerRow',
							width:50,
							value: 0,
							editable: false,
							minValue: 0,
							hideTrigger: true,
							},
								{
							xtype : 'button',
							id : 'plus',
							name : 'plus',
							text : '+',
							handler: function() {
								var headerRowObj=Ext.getCmp('headerRow');
								var headerRow=headerRowObj.getValue();
								headerRowObj.setValue(headerRow+1);
							}
							}
							]
						},
						{
						xtype : 'RESTFileUploadGrid',
						fieldLabel : screenLabelsObj['Data'],
						margin : '12 0 0 10',
						id : 'fileupload_grid',
						hidden  : true
						},
						{
						xtype : 'button',
						//htype:'vbox',
						id : 'saveCsv',
						name : 'saveCsv',
						margin : '12 0 0 120',
						//buttonAlign: 'right',
						text : screenLabelsObj['Save'],
						hidden : true,
						//disabled: true,
						//iconCls : 'iconSave',
						//tooltip : 'Update Header Row'
						},
							{
						xtype : 'button',
						//htype:'vbox',
						id : 'next',
						name : 'next',
						margin : '12 0 0 10',
						text : screenLabelsObj['Next'],
						hidden : true,
						disabled: true,
						//iconCls : 'iconSave',
						//tooltip : 'Update Header Row'
						},
						{
						xtype : 'textfield',
						fieldLabel : screenLabelsObj['Enter SQL Query'],
						margin : '12 0 0 10',
						width : 500,
						id : 'sqlquery',
						name : 'sqlquery',
						hidden : true,
						cls: 'textbox'
					},
					{
						xtype : 'textfield',
						fieldLabel : screenLabelsObj['Enter REST URL'],
						margin : '12 0 0 10',
						width : 500,
						id : 'urltextbox',
						name : 'urltextbox',
						hidden : false,
						cls: 'textbox'
					},
					{
						xtype: 'combo',
						cls: 'dropdown',
						fieldLabel: screenLabelsObj['Http Method'],
						id: 'restHttpMethod',
						name: 'restHttpMethod',
						hidden : false,
						width: 280,
						margin:'12 0 0 10',
						store: Ext.create('Ext.data.Store', {
							fields: ['displayField', 'valueField'],
							data: [{"displayField" : screenLabelsObj['GET'],"valueField" : "GET"},{"displayField" : screenLabelsObj['POST'],"valueField" : "POST"}]
						}),
						editable: false,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						value : 'GET'
					},
					{
						xtype : 'textfield',
						fieldLabel : screenLabelsObj['Port No'],
						margin : '12 0 0 10',
						width : 200,
						id : 'restPortNo',
						name : 'restPortNo',
						hidden:true,
						value : 443,
						cls: 'textbox'
					},
					{
						xtype: 'radiogroup',
						width: 450,
					//	labelAlign: 'left',
						margin : '12 0 0 10',
						labelWidth:250,
						fieldLabel: screenLabelsObj['User Authentication Required'],
						hidden : false,
						id: 'User_Authentication_Required',
						name: 'User_Authentication_Required',
						items: [{
							boxLabel: screenLabelsObj['Yes'],
							name: 'usr_auth',
							inputValue: 'yes',
							cls: 'radiobt'
						}, {
							boxLabel: screenLabelsObj['No'],
							name: 'usr_auth',
							inputValue: 'no',
							cls: 'radiobt',
							checked : true
						}]
					},
					{
						xtype : 'textfield',
						fieldLabel : screenLabelsObj['User name'],
						margin : '12 0 0 10',
						width : 500,
						id : 'rest_username',
						name : 'rest_username',
						hidden : true,
						cls: 'textbox'
					},
					{
						xtype : 'textfield',
						inputType : 'password',
						fieldLabel : screenLabelsObj['Password'],
						margin : '12 0 0 10',
						width : 500,
						id : 'rest_password',
						name : 'rest_password',
						hidden : true,
						cls: 'textbox'
					},
						{
						xtype: 'radiogroup',
						width: 450,
					//	labelAlign: 'left',
						margin : '12 0 0 10',
						labelWidth:250,
						fieldLabel: screenLabelsObj['Header Required'],
						hidden : false,
						id: 'Header_Required',
						name: 'Header_Required',
						items: [{
							boxLabel: screenLabelsObj['Yes'],
							name: 'header_req',
							inputValue: 'yes',
							cls: 'radiobt',
							checked : true
						}, {
							boxLabel: screenLabelsObj['No'],
							name: 'header_req',
							inputValue: 'no',
							cls: 'radiobt'
						}]
					},
					{
						xtype : 'textfield',
						id : 'key',
						name : 'key',
						width : 500,
						margin : '12 0 0 10',
						fieldLabel : screenLabelsObj['Key'],
						hidden : false,
						disabled: false,
						cls: 'textbox'
					},
						{
						xtype : 'textfield',
						id : 'value',
						name : 'value',
						width : 500,
						margin : '12 0 0 10',
						fieldLabel : screenLabelsObj['Value'],
						hidden : false,
						disabled: false,
						cls: 'textbox'
					},{
						xtype : 'button',
						htype:'vbox',
						id : 'addHeader',
						name : 'addHeader',
						margin : '12 0 0 120',
						text : screenLabelsObj['AddHeader'],
						hidden : false,
						//disabled: true,
						//iconCls : 'iconSave',
						tooltip : screenLabelsObj['click here to Add']
					},
					{
						xtype : 'RESTHeaderGrid',
						fieldLabel : screenLabelsObj['Headers'],
						margin : '12 0 0 120',
						id : 'header_grid',
						hidden  : false
					},
					{
						xtype: 'radiogroup',
						width: 450,
					//	labelAlign: 'left',
						margin : '12 0 0 10',
						labelWidth:150,
						fieldLabel: 'Body',
						hidden : true,
						id: 'body_type',
						name: 'body_type',
						items: [{
							boxLabel: screenLabelsObj['x-www-form-urlencoded'],
							name: 'body_name',
							inputValue: 'x-www-form-urlencoded',
							cls: 'radiobt',
							checked:true
						}, {
							boxLabel: screenLabelsObj['raw'],
							name: 'body_name',
							inputValue: 'raw',
							cls: 'radiobt'
						}]
					},
						{
						xtype : 'textfield',
						id : 'body_urlencoded_key',
						name : 'body_urlencoded_key',
						width : 500,
						margin : '12 0 0 120',
						fieldLabel : screenLabelsObj['Key'],
						hidden : true,
						disabled: false,
						cls: 'textbox'
					},
						{
						xtype : 'textfield',
						id : 'body_urlencoded_value',
						name : 'body_urlencoded_value',
						width : 500,
						margin : '12 0 0 120',
						fieldLabel : screenLabelsObj['Value'],
						hidden : true,
						disabled: false,
						cls: 'textbox'
					},{
						xtype : 'button',
						htype:'vbox',
						id : 'addBody_urlencoded',
						name : 'addBody_urlencoded',
						margin : '12 0 0 120',
						text : screenLabelsObj['AddBody'],
						hidden : true,
						//disabled: true,
						//iconCls : 'iconSave',
						tooltip : screenLabelsObj['click here to Add']
					},
						{
						xtype : 'RESTBodyUrlEncodedGrid',
						fieldLabel : screenLabelsObj['x-www-form-urlencoded'],
						margin : '12 0 0 120',
						id : 'bodyUrlEncodedGrid',
						hidden  : true
					},
						{
						xtype : 'textarea',
						fieldLabel : screenLabelsObj['Body (raw Json)'],
						width : 500,
						height : 150,
						id : 'rawJsonBody',
						name : 'rawJsonBody',
						margin : '12 0 0 10',
						hidden : true,
						disabled: false
					},
						{
						xtype : 'button',
						id : 'saveDSNBtn',
						name : 'saveDSNBtn',
						margin : '12 0 0 120',
						text : screenLabelsObj['Save DSN'],
						hidden : false,
						disabled: false,
						//iconCls : 'iconSave',
						tooltip : screenLabelsObj['click here to save']
					},{
						xtype : 'button',
						htype:'vbox',
						id : 'getData',
						name : 'getData',
						margin : '12 0 0 10',
						text : screenLabelsObj['GetData'],
						hidden : false,
						disabled: true,
						//iconCls : 'iconSave',
						tooltip : screenLabelsObj['click here to GetData']
					}]
				}
			]
	}
	],

	 onRender : function () {
		var widgetId=this.blockId;
		var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
		//rest_output_window.removeAll();
		var paramsForRestURL='action=loadConfigPopupJSON&widgetId='+encodeURIComponent(widgetId)+'&dashboardName='+encodeURIComponent(dashboardName);

			Ext.Ajax.request({
					url : '/final/servlet/com.eg.RESTIntegrationController',
					method : 'POST',
					params : paramsForRestURL,
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
						if (jsonText != null && jsonText != '') {
							var jsonData=Ext.decode(jsonText);
							var dSNComboObj=Ext.getCmp('DSNCombo');
							dSNComboObj.getStore().loadRawData(jsonData['dsnOpts']['dsnOptsArr']);
							dSNComboObj.setValue(jsonData['dsnOpts']['selectedDSN']);
							var restdsnname = Ext.getCmp('restdsnname');
							var integrationObj = Ext.getCmp('integration');
							var urltextbox = Ext.getCmp('urltextbox');
							var restHttpMethod = Ext.getCmp('restHttpMethod');
							var userAuth = Ext.getCmp('User_Authentication_Required');
							var saveDSNBtn = Ext.getCmp('saveDSNBtn');
							var getData = Ext.getCmp('getData');
							var sqlquery = Ext.getCmp('sqlquery');
							var key = Ext.getCmp('key');
							var value = Ext.getCmp('value');
							var addHeader = Ext.getCmp('addHeader');
							var header_grid = Ext.getCmp('header_grid');
							var Header_Required = Ext.getCmp('Header_Required');
							var fileUploadForm = Ext.getCmp('fileUploadForm');
					
							

							var selectedDSN=jsonData['dsnOpts']['selectedDSN'];
							var integrationType=jsonData['dsnOpts']['integrationType'];
							var url=jsonData['dsnOpts']['url'];
							var configuredHeaders=jsonData['dsnOpts']['configuredHeaders'];
							var configuredBodyUrlEncoded=jsonData['dsnOpts']['configuredBodyUrlEncoded'];
							var rawJsonBodyData=jsonData['dsnOpts']['rawJsonBody'];
							
							if(selectedDSN!=null && selectedDSN!=-1)
							{
								restdsnname.setValue(selectedDSN);
							}
							integrationObj.setValue(integrationType);
							if(integrationType!=null && integrationType=="CSV")
							{
								urltextbox.hide();
								restHttpMethod.hide();
								userAuth.hide();
								saveDSNBtn.hide();
								getData.hide();
								sqlquery.hide();
								key.hide();
								value.hide();
								addHeader.hide();
								Header_Required.hide();
								header_grid.hide();
								fileUploadForm.show();
							}
							else
							{
								if(selectedDSN!=null && selectedDSN!="" && url!=null && url!="")
								{
									Ext.getCmp('getData').enable();
								}
								else
								{
									Ext.getCmp('getData').disable();
								}
								if(selectedDSN!=null && selectedDSN!=-1)
								{
								//var restdsnname=Ext.getCmp('restdsnname');
								
								urltextbox.setValue(url);
								restHttpMethod.setValue(jsonData['dsnOpts']['httpMethod']);
								}
								if(jsonData['dsnOpts']['httpMethod']!="" && jsonData['dsnOpts']['httpMethod']=="GET")
								{
									Ext.getCmp('body_type').hide();
								}
								if(configuredHeaders!=null)
								{
									var gridObj=Ext.getCmp('header_grid');
									var gridStore = gridObj.getStore();
									gridStore.removeAll();
									gridStore.add(configuredHeaders);
									gridObj.doLayout();
								}
								if(jsonData['dsnOpts']['httpMethod']!="" && jsonData['dsnOpts']['httpMethod']=="POST")
								{
									var body_type = Ext.getCmp('body_type');
									body_type.show();
									var body_typeObj = body_type.getChecked();
									var body_name = jsonData['dsnOpts']['selectedBodyType'];
									if(body_name!=null && body_name=="x-www-form-urlencoded")
									{
										
										var viewTypeOptObj = Ext.getCmp('body_type');
										viewTypeOptObj.suspendEvents(false);
													viewTypeOptObj.setValue({
													 body_name: body_name
													 });
													viewTypeOptObj.show();
										viewTypeOptObj.resumeEvents();
										viewTypeOptObj=null;
										delete viewTypeOptObj;

										Ext.getCmp('rawJsonBody').hide();
										Ext.getCmp('body_urlencoded_key').show();
										Ext.getCmp('body_urlencoded_value').show();
										Ext.getCmp('addBody_urlencoded').show();
										Ext.getCmp('bodyUrlEncodedGrid').show();
										if(configuredBodyUrlEncoded!=null)
										{
											var gridObj=Ext.getCmp('bodyUrlEncodedGrid');
											var gridStore = gridObj.getStore();
											gridStore.removeAll();
											gridStore.add(configuredBodyUrlEncoded);
											gridObj.doLayout();
										}
									}
									else 
									{
										var viewTypeOptObj = Ext.getCmp('body_type');
										viewTypeOptObj.suspendEvents(false);
													viewTypeOptObj.setValue({
													 body_name: body_name
													 });
													viewTypeOptObj.show();
										viewTypeOptObj.resumeEvents();
										viewTypeOptObj=null;
										delete viewTypeOptObj;
										var rawJsonBody = Ext.getCmp('rawJsonBody');
										rawJsonBody.show();
										if(rawJsonBodyData!=null && rawJsonBodyData!="")
										{
										var rawJsonBodyVal=JSON.stringify(rawJsonBodyData,undefined, 2);
										rawJsonBody.setValue(rawJsonBodyVal);
										}
										Ext.getCmp('body_urlencoded_key').hide();
										Ext.getCmp('body_urlencoded_value').hide();
										Ext.getCmp('addBody_urlencoded').hide();
										Ext.getCmp('bodyUrlEncodedGrid').hide();
									}
								}
							}
						}
					}
			});
			this.callParent();
		},
		setBlockId : function(blockId)
		{
			this.blockId = blockId;
		},
		checkspecialCharacterForMetric : function(dispMVal)
		{
			var splChar =":~!@#$%^&*+={}[]|\\;\"\<>,";
			for(var i=0; i<obj_val.length; i++)
			{
				var check_char = splChar.indexOf(obj_val.charAt(i))
				//Returns value 1 if the special character listed in splChar is found
				if(check_char >= 0)
				{
					return true;
				}
			}
		}
})