Ext.define('MyDashBoard.view.RESTWidgetSettings', {
    extend: 'Ext.window.Window',
    alias: 'widget.restwidgetsettings',
    requires: ['utilities.CustomGrid','utilities.ScrollCombo','utilities.CommonPanel','MyDashBoard.view.RESTHeaderGrid','MyDashBoard.view.RESTBodyUrlEncodedGrid','MyDashBoard.view.RESTFileUploadForm','MyDashBoard.view.RESTFileUploadGrid','MyDashBoard.view.RestFileUploadFormExcel'],
    width: 780,
    modal: true,
	border:false,
	frame:false,
    autoShow: false,
	ghost:false,
	padding:'0 0 0 0',
	autoScroll:true,
	header:{
		height:32,
		padding:'0 20',
		margin:0
	},
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	autoShow : false,
	ui:'newPopupWindow   widgetOptionsWindowHeader',
    cls:'myDashboardwindow',
	height:550,
	blockId : null,
	scroll : true,
	autoScroll : true,
	isFluidWindowConfigPopup : true,
	closeAction : 'destroy',
	id: 'restDashWidgetSettings',
	dataFieldsComboIdArr : [],
	initComponent : function()
	{
		this.buttonAlign = 'center';
		this.callParent();
	},
	items: [{
	xtype: 'container',
	itemId : 'restconfigForm',
	buttonAlign: 'center',
	defaults: {
		padding: '0',
		margin: '0',
	},
	items : [{
	xtype : 'panel',
	id : 'restfieldmappingpnl',
	name : 'restfieldmappingpnl',
	title : 'Widget Type Configuration',
	height : 250,
	buttonAlign: 'center',
	autoScroll:true,
	buttons: [{
			xtype  : 'button',
			id : 'addRestWidget',
			name : 'addRestWidget',
			text : 'Update',
			hidden :  true
	}],
	items : [
	{
		xtype : 'combo',
		cls: 'dropdown',
		fieldLabel: 'Widget Types',
		id: 'widgetTypeCombo',
		name: 'widgetTypeCombo',
		width: 280,
		margin:'12 0 0 10',
		store: Ext.create('Ext.data.Store', {
			fields: ['displayField', 'valueField'],
			data: []
		}),
		editable: false,
		displayField: 'displayField',
		valueField: 'valueField',
		queryMode: 'local',
		hidden : true
	},
	{
		xtype: 'container',
		id : 'widgetChartAttrsCont',
		name : 'widgetChartAttrsCont',
		hidden : true
	}

	],
	hidden : true
	
	}]
	}],

	onRender : function () {
	var widgetId=this.blockId;
	var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
	var paramsForRestURL='action=widgetSettingsOpt&widgetId='+encodeURIComponent(widgetId)+'&dashboardName='+encodeURIComponent(dashboardName);
	Ext.Ajax.request({
		url : '/final/servlet/com.eg.RESTIntegrationController',
		method : 'POST',
		params : paramsForRestURL,
		scope : this,
		success : function(response) {
			var jsonText = response.responseText;
			var jsonData = Ext.decode(jsonText);
			var widgetsOpt=jsonData['widgetOpts']['comboOpts'];
			var selectedWidgetType=jsonData['widgetOpts']['selectedWidgetType'];
			var widgetTypeComboObj=Ext.getCmp('widgetTypeCombo');
			widgetTypeComboObj.getStore().loadData(widgetsOpt);
			widgetTypeComboObj.setValue(selectedWidgetType);
			widgetTypeComboObj.show();
			var restfieldmappingpnl=Ext.getCmp('restfieldmappingpnl');
			restfieldmappingpnl.show();

			if(selectedWidgetType != '-1')
			{
				var RESTConfigContObj=Ext.getCmp('RESTConfigCont');
				var dashboardName = Ext.getCmp('dashboardLayoutObj').profileName;
				//var restDashMainPnl=Ext.getCmp('restwidgetsettings');
				var restDashMainPnl=Ext.getCmp('restDashWidgetSettings');
				var widgetId=restDashMainPnl.blockId;
				//var widgetId='RESTAPIWidget';
				var widgetType=Ext.getCmp('widgetTypeCombo').getValue();

				var paramsForRestURL='restDSNName='+encodeURIComponent('')+'&action=loadWidgetOptions'+'&widgetId='+encodeURIComponent(widgetId)+'&dashboardName='+encodeURIComponent(dashboardName)+'&selectedWidgetType='+encodeURIComponent(widgetType);

				Ext.Ajax.request({
						url : '/final/servlet/com.eg.RESTIntegrationController',
						method : 'POST',
						params : paramsForRestURL,
						scope : this,
						success : function(response) {

								var jsonText = response.responseText;
								if (jsonText != null && jsonText != '') {
									var jsonData=Ext.decode(jsonText);
									var widgetChartAttrsContObj=Ext.getCmp('widgetChartAttrsCont');
									if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('widgetAttrsJson'))
									{
										var widgetAttrsOptions=jsonData['widgetAttrsJson']['widgetAttrsOptions'];
										var selectedWidgetAttrValsJson=jsonData['widgetAttrsJson']['selectedWidgetAttrValsJson'];
										var dataFieldsOpts=[];
										if(jsonData.hasOwnProperty('dataFieldsOpts'))
										{
											dataFieldsOpts=jsonData['dataFieldsOpts'];
										}
										if(!Ext.isEmpty(widgetAttrsOptions))
										{
											widgetChartAttrsContObj.removeAll();
											var fieldsComboArr=[];
											var firstWidgetAttr=dataFieldsOpts[0];
											var defaultDataFieldVal=firstWidgetAttr['valueField'];
											var widgetAtrrsComboIds=[];
											for(var widA in widgetAttrsOptions)
											{
												var widAttrOpt=widgetAttrsOptions[widA];
												var dispLbl=widAttrOpt['displayField'];
												var valLbl=widAttrOpt['valueField'];
												var UI_Control=widAttrOpt['UI_Control'];
												var selectedDataField=widAttrOpt['selectedVal'];
												if(!Ext.isEmpty(selectedWidgetAttrValsJson) && selectedWidgetAttrValsJson.hasOwnProperty(valLbl))
												{
													//selectedDataField=selectedWidgetAttrValsJson[valLbl];
												}
												widgetAtrrsComboIds.push(valLbl);
												if(UI_Control!=null && UI_Control=='combo')
												{
													if(valLbl!=null && valLbl=='Widget_Title')
													{
														fieldsComboArr.push({
														xtype : 'combo',
														cls: 'dropdown',
														fieldLabel: dispLbl,
														id: valLbl,
														name: valLbl,
														width: 280,
														margin:'12 0 0 10',
														store: Ext.create('Ext.data.Store', {
															fields: ['displayField', 'valueField'],
															data: dataFieldsOpts
														}),
														editable: true,
														displayField: 'displayField',
														valueField: 'valueField',
														queryMode: 'local',
														value : selectedDataField
													});
													}
													else if(valLbl!=null && valLbl=='Measure_Data')
													{
														fieldsComboArr.push({
														xtype : 'combo',
														cls: 'dropdown',
														fieldLabel: dispLbl,
														id: valLbl,
														name: valLbl,
														width: 280,
														margin:'12 0 0 10',
														store: Ext.create('Ext.data.Store', {
														fields: ['displayField', 'valueField'],
														data: [
															{displayField: 'Please choose aggregate type', valueField: 'type'},
															{displayField: 'Sum', valueField: 'sum'},
															{displayField: 'Average', valueField: 'average'},
															{displayField: 'Count', valueField: 'count'},
															{displayField: 'Minimum', valueField: 'Minimum'},
															{displayField: 'Maximum', valueField: 'maximum'},
															]
														}),
														editable: false,
														displayField: 'displayField',
														valueField: 'valueField',
														queryMode: 'local',
														value : selectedDataField
														});
													}
													else
													{
													fieldsComboArr.push({
														xtype : 'combo',
														cls: 'dropdown',
														fieldLabel: dispLbl,
														id: valLbl,
														name: valLbl,
														width: 280,
														margin:'12 0 0 10',
														store: Ext.create('Ext.data.Store', {
															fields: ['displayField', 'valueField'],
															data: dataFieldsOpts
														}),
														editable: false,
														displayField: 'displayField',
														valueField: 'valueField',
														queryMode: 'local',
														value : selectedDataField
													});
													}
												}
												else if(UI_Control!=null && UI_Control=='multiselect')
												{
													fieldsComboArr.push(	{
																	xtype : 'multiselect',
																	width: 280,
																	margin:'12 0 0 10',
																	height : 100,
																//	layout : 'fit',
																	border : 0,
																	// msgTarget: 'side',
																	autoScroll : true,
																	scroll : true,
																	labelAlign : 'left',
																	// height:50,
																	baseCls : 'egmultiselect',
																	multiSelect : true,
																	// allowBlank: false,
																	fieldLabel: dispLbl,
																	id : valLbl,
																	name : valLbl,
																	// value: '',
																	store :  Ext.create('Ext.data.Store', {
																		fields: ['displayField', 'valueField'],
																		data: dataFieldsOpts
																	}),
																	value : selectedDataField,
																	displayField : 'displayField',
																	valueField : 'valueField',
																	queryMode : 'local'
													});
												}
											}
											widgetChartAttrsContObj.add(fieldsComboArr);
											widgetChartAttrsContObj.show();
											Ext.getCmp('addRestWidget').show();
										}
										restDashMainPnl.dataFieldsComboIdArr=widgetAtrrsComboIds;
									}
								}
						}
					});
			
			}
		}
	}),
	this.callParent();
	}
});