Ext.define('SummaryWidgetModel', {
    extend: 'Ext.data.Model',
    fields: [{
            name: 'state',
            type: 'string'
        },
        {
            name: 'heading',
            type: 'string'
        },
        {
            name: 'value',
            type: 'auto'
        },
        {
            name: 'legend',
            type: 'string'
        },
        {
            name: 'graphID',
            type: 'number'
        },      
        {
            name: 'layerTesturl',
            type: 'string'
        },
        {
            name: 'chartIcon',
            type: 'string'
        },
		 {
            name: 'chartImg',
            type: 'string'
        },
		{
			name : 'summaryGraphType',
			type : 'string'
		},
		{
			name : 'seriesColor',
			type : 'string'
		},
		{
            name: 'graphData'
        },
		{
            name: 'showSearchImg',
			type : 'string'
        },
		{
            name: 'toolTipText',
			type : 'string'
        }/*,
		{
            name: 'toolTipDescriptor',
			type : 'string'
        }*/
    ]
});
Ext.define('MyDashBoard.view.SummaryWidget', {
    extend: 'Ext.view.View',
    alias: 'widget.summarywidget',
    cls: 'widgetcon',
    ui: 'appflowtraffic',
    autoDestroy: true,
    chartData: null,
	chartType : 'area',
	needDDIcon : false,
	showToolTip:false,
	gridStackPnlWid : 300,
	gridStackPnlHei : 300,
	toolTipText : '',
    initComponent: function() {
        var me = this;
        me.chartID = "graph-traffic" + me.id + "";
		me.store= new Ext.create('Ext.data.Store', {
        model: 'SummaryWidgetModel',
		id : me.chartID+'_str',
        autoLoad: true,
        data: []});
		var showToolTip = me.showToolTip;
		var fontColor = me.fontColor;
		var resizeFont = me.resizeFont;
		var measureValue = me.measureValue;
		var useStateColorForFonts  = me.useStateColorForFonts ;
		var chartHeight = 25;
		if(me.chartType == "column"){
			chartHeight = 40;
		}
		if(me.needDDIcon){
			if(me.id =='dumps_summaryWidgetCont'){
					me.tpl = new Ext.XTemplate(
					'<div id="'+me.chartID+'_partpldiv" class="widgetholders" style="display: table; position: absolute; height: 70%; width: 100%;">',
					'<div style=" display: table-cell;vertical-align: middle;text-align: center;">',
					'<tpl for=".">',
					'<div style="display:inline-block;vertical-align: middle;">',
					'</div>',
					'<div class="b_box" style="display:inline-block;vertical-align: middle;">',
				'<tpl if="!Ext.isEmpty(showSearchImg)">',
					'<div class="font_r_l_31" style="text-align:center; margin-top:12px;">',
					'<span style="display:inline-block;" class="dumps"></span>',
					'{value}<span class="sap_search" style="display:inline-block;margin-left:5px; cursor:pointer" onclick="javascript:showDumpsDDPopupWindow();" data-qtip="Dump&nbsp;messages"  ></span></div>',
				'<tpl else>',
						'<div class="font_r_l_31" style="text-align:center; margin-top:12px;">',
						'<span style="display:inline-block;" class="dumps"></span>',
						'{value}</div>',
				'</tpl>',
					'<div class="font_r_l_10 legendLabel" style="text-align:center; margin-top:0px;line-height: 18px; height: 14px;">{legend}</div>',
					'<div id="' + me.chartID + '"  class="summary_graph" style="width:125px;height:35px;margin:0px auto"></div>',
					'</div>',
					'</div>',
					'</tpl>',
					'</div>'			
				 );      
			}else{
					me.tpl = new Ext.XTemplate(
					'<div id="'+me.chartID+'_partpldiv" class="widgetholders" style="display: table; position: absolute; height: 79%; width: 100%;">',
					'<div style=" display: table-cell;vertical-align: middle;text-align: center;">',
					'<tpl for=".">',
					'<div style="display:inline-block;vertical-align: middle;">',
					'<tpl if="!Ext.isEmpty(chartIcon)">',
					'<div class="font_r_l_31" style="display: table-cell;horizontal-align:left;"><img class="{chartIcon}" style="margin-right:10px;padding:2px 10px 2px 10px" src="/final/images/clear.png"/></div>',
					'<tpl elseif="!Ext.isEmpty(chartImg)">',
					'<div class="font_r_l_31 " style="display: table-cell;horizontal-align:left;"><img style="vertical-align:sub" src="{chartImg}"/></div>',
					'</tpl>',
					'</div>',
					'<div class="b_box" style="vertical-align: middle;">',
					'<div class="font_r_l_31" style="text-align:center"><a href=\'javascript:goToLayerModel("{layerTesturl}");\'>{value}</a></div>',
					'<div class="font_r_l_10 legendLabel" style="text-align:center; margin-top:0px;line-height: 18px; height: 14px;">{legend}</div>',
					'<div id="' + me.chartID + '"  class="summary_graph" style="width:50%;margin: 0 auto;height:35px;"></div>',
					'</div>',
					'</div>',
					'</tpl>',
					'</div>'
				);
			}
		}else{


		/********************* 
		  Font Resize start 
		**********************/
		var metricFontStyleObj={ 'font-color': fontColor };
		var unitFontStyleObj={ 'font-size': '12' , 'font-color': ''};
		var fontSize = (me.gridStackPnlWid * me.gridStackPnlHei)/1300;

		/*maxSize = 70,
		minSize = 30;
		var defaultSize = 35;
				
		var fontSize = (me.gridStackPnlWid * me.gridStackPnlHei)/1300;
		if (fontSize > maxSize) fontSize = maxSize;
		if (fontSize < minSize) fontSize = minSize;

		var fontLenght = 0;
		if(!Ext.isEmpty(measureValue))
		{
			fontLenght=measureValue.length;
		}
		if (fontLenght <= 7 ) 
		{
			fontSize = (me.gridStackPnlWid * me.gridStackPnlHei)/1300;
			if (fontSize > maxSize) fontSize = 70;
		}
		if (fontLenght <= 6 ) 
		{
			fontSize = (me.gridStackPnlWid * me.gridStackPnlHei)/1000;
			if (fontSize > maxSize) fontSize = 70;
		}
		if (fontLenght <= 5 ) 
		{
			fontSize = (me.gridStackPnlWid * me.gridStackPnlHei)/800;
			if (fontSize > maxSize) fontSize = 70;
		}
		if (fontLenght <= 4 ) 
		{
			fontSize = (me.gridStackPnlWid * me.gridStackPnlHei)/700;
			if (fontSize > maxSize) fontSize = 70;
		}			

		var isString = false;
		if(measureValue != null && measureValue!='')
		{
			var letters = /^[A-Za-z]+$/;
			for ( var valCount in measureValue) {
				var measName = measureValue.charAt(valCount);
				if(measName.match(letters))
				{
					  isString = true;
				}
			}
		
			if (isString)
			{
				if (fontSize>=25)
				{
					var halfFontSize=(fontSize/2);
					if(halfFontSize>35)
					{
						fontSize=35;
					}
					else if(halfFontSize>30)
					{
						fontSize=30;
					}
					else 
					{
						fontSize=25;
					}
				}								
			}
		}
		*/
		/********************* 
		  Font Resize End 
		**********************/
		var digToolTipBgColor="#cdcdcd";
		var digToolTipfontColor="#2a292a";
		if(strSkin!=null && strSkin.toLowerCase()=="dark")
		{
			digToolTipBgColor="#6a6a6a";
			digToolTipfontColor="#c6c6c6";
		}

				if(!isPublishedDashboard)
				{
					me.tpl = new Ext.XTemplate(
						'<div id="'+me.chartID+'_partpldiv" class="widgetholders" style="display: table; position: absolute; height: 100%; width: 100%;">',
						'<div style=" display: table-cell;vertical-align: middle;text-align: center;">',
						'<tpl for=".">',
						'<div style="display:inline-block;vertical-align: middle;">',
						'<tpl if="!Ext.isEmpty(chartIcon)">',
						 '<div class="font_r_l_31" style="display: table-cell;horizontal-align:left;"><img class="{chartIcon}" style="margin-right:10px;margin-bottom:0px;padding:2px 10px 2px 10px" src="/final/images/clear.png"/></div>',
						'<tpl elseif="!Ext.isEmpty(chartImg)">',
							'<div class="font_r_l_31 " style="display: table-cell;horizontal-align:left;"><img style="vertical-align:sub" src="{chartImg}"/></div>',
						'</tpl>',
						'</div>',
						'<div class="b_box" style="display:inline-block;vertical-align: middle;">',
						'<div class="dofontsize" style="text-align:center; font-size:'+fontSize+'px; line-height:'+fontSize+'px; "><a href=\'javascript:goToLayerModel("{layerTesturl}");\' data-qclass="heatmap_tooltip" data-qtip=\'<div class="heatmap_tooltip_inner"><span style="color:'+digToolTipfontColor+'; border:none !important; padding:5px 0px" ><b>{toolTipText}',
					/*	'<tpl if="!Ext.isEmpty(values.toolTipDescriptor)">',
							'\\{toolTipDescriptor}',
						'</tpl>',*/
						'</b></span></div>\' style="color:'+metricFontStyleObj['font-color']+';">{value}</a><span style="font-size:12px !important; padding-left:5px;" data-qclass="heatmap_tooltip" data-qtip=\'<div class="heatmap_tooltip_inner"><span style="color:'+digToolTipfontColor+'; border:none !important; padding:5px 0px" ><b>{toolTipText}',
						/*'<tpl if="!Ext.isEmpty(values.toolTipDescriptor)">',
							'<br/> Descriptor : {toolTipDescriptor}',
						'</tpl>',*/
						'</b></span></div>\'>{legend}</span></div>',            
						//'<div class="font_r_l_10" style="text-align:center; font-size:'+unitFontStyleObj['font-size']+'px;">{legend}</div>',
						'<div id="' + me.chartID + '"  class="summary_graph" style="width:125px;height:'+chartHeight+'px;margin:0px auto"></div>',
						'</div>',
						'</div>',
						'</tpl>',
						'</div>'
					);
				}else{
					me.tpl = new Ext.XTemplate(
						'<div id="'+me.chartID+'_partpldiv" class="widgetholders" style="display: table; position: absolute; height: 100%; width: 100%;">',
						'<div style=" display: table-cell;vertical-align: middle;text-align: center;">',
						'<tpl for=".">',
						'<div style="display:inline-block;vertical-align: middle;">',
						'<tpl if="!Ext.isEmpty(chartIcon)">',
						 '<div class="font_r_l_31" style="display: table-cell;horizontal-align:left;"><img class="{chartIcon}" style="margin-right:10px;margin-bottom:0px;padding:2px 10px 2px 10px" src="/final/images/clear.png"/></div>',
						'<tpl elseif="!Ext.isEmpty(chartImg)">',
							'<div class="font_r_l_31 " style="display: table-cell;horizontal-align:left;"><img style="vertical-align:sub" src="{chartImg}"/></div>',
						'</tpl>',
						'</div>',
						'<div class="b_box" style="display:inline-block;vertical-align: middle;">',
						'<div class=" dofontsize" style="text-align:center; font-size:'+fontSize+'px; line-height:'+fontSize+'px; "><span data-qclass="heatmap_tooltip" data-qtip=\'<div class="heatmap_tooltip_inner"><span style="color:'+digToolTipfontColor+'; border:none !important; padding:5px 0px" ><b>{toolTipText}',
					/*	'<tpl if="!Ext.isEmpty(values.toolTipDescriptor)">',
							'<br/> Descriptor :  {toolTipDescriptor}',
						'</tpl>',*/
						'</b></span></div>\'style="color:'+metricFontStyleObj['font-color']+';">{value}</span><span style="font-size:12px !important; padding-left:5px;" data-qclass="heatmap_tooltip" data-qtip=\'<div class="heatmap_tooltip_inner"><span style="color:'+digToolTipfontColor+'; border:none !important; padding:5px 0px" ><b>{toolTipText}',
					/*	'<tpl if="!Ext.isEmpty(values.toolTipDescriptor)">',
							'<br/> Descriptor :  {toolTipDescriptor}',
						'</tpl>',*/
						'</b></span></div>\'>{legend}</span></div>',            
						//'<div class="font_r_l_10" style="text-align:center; font-size:'+unitFontStyleObj['font-size']+'px;">{legend}</div>',
						'<div id="' + me.chartID + '"  class="summary_graph" style="width:125px;height:'+chartHeight+'px;margin:0px auto"></div>',
						'</div>',
						'</div>',
						'</tpl>',
						'</div>'
					);
				}
		}
		me.on('resize', me.widgetResize, me);
        me.callParent();
    },
    updateData: function(data) {
        var me = this;
        me.store.loadData(data);
        var jsonData11 = me.chartView(me.store.data.items[0].data.graphData,me.store.data.items[0].data.summaryGraphType);
        $("#" + me.chartID).highcharts(jsonData11);

    },
    padding: '5 0 5 0',
    chartView: function(data,chartType) {
        var me = this;
        var chartProp = {
            credits: {
                enabled: false
            },
            chart: {
				margin:0,
				resizeChart:false,
                type: chartType,
				renderTo:me.chartID,
                spacingBottom: 0,
                spacingTop: 0,
                spacingLeft: 0,
                spacingRight: 0,
                backgroundColor: null
            },
            exporting: {
                enabled: false
            },
            title: {
                text: ''
            },
            tooltip: {
                //enabled: false,
                enabled: this.showToolTip,
				shape: 'square',
                style: {
                    color : 'black',
                    fontFamily: 'Arial',
                    fontSize: '10px',
                }, 
				formatter: function() {
					return '' + this.y;
				}
            },
            xAxis: {
                allowDecimals: false,
                visible: false,
                minorGridLineWidth: 0,
                minorTickLength: 0,
                tickLength: 0,
			
                lineColor: 'transparent',
                labels: {
                    enabled: false
                },

            },
            yAxis: {
                minorGridLineWidth: 0,
                visible: false,
                lineColor: 'transparent',
                gridLineColor: 'transparent',
                minorTickLength: 0,
                tickLength: 0,
                labels: {
                    enabled: false
                }
            },
            plotOptions: {
                'line': {
                    marker: {
                        enabled: false,
						radius : 3,
						 fillColor: (strSkin == 'Light')?"#FFFFFF":'#828282',
						 lineWidth: null,
						 lineColor: '#d6655d', // inherit from series
                        symbol: 'circle',
                        states: {
                            hover: {
                                enabled: true,
								radius : 3,
								radiusPlus : 0,
								 fillColor: (strSkin == 'Light')?"#FFFFFF":'#828282',
								 lineWidth: null,
								 lineColor: '#e3bf6e', // inherit from series
								symbol: 'circle',
                            }
                        }
                    }
                },
				'area': {
                    marker: {
                        enabled: false,
                        symbol: 'circle',
                        states: {
                            hover: {
                                enabled: true
                            }
                        }
                    }
                },
				'column': {
				borderColor:null,
				series: {
				
				 pointPadding: 0,
            groupPadding: 0.01,
				 pointWidth: 3
        },
					
                    marker: {
                        enabled: false,
                        symbol: 'circle',
                        states: {
                            hover: {
                                enabled: false
                            }
                        }
                    }
                }
            },
            series: data
        };
		if(chartType == "column"){
			chartProp= 	Ext.apply(chartProp,{
				resize:false,
					 xAxis: {
                allowDecimals: false,
                visible: false,
                minorGridLineWidth: 0,
                minorTickLength: 0,
                tickLength: 0,
				min:0,
               lineColor: 'transparent',
                labels: {
                    enabled: false
                },

            },
            yAxis: {
                minorGridLineWidth: 0,
				
              visible: false,
                lineColor: 'transparent',
                gridLineColor: 'transparent',
                minorTickLength: 0,
                tickLength: 0,
                labels: {
                   enabled: false
                }
            }
				})
		}
		chartProp.chart.resize = false;
        return chartProp;
    },
	widgetResize:function(){
		 var me = this;
			 if(me.needDDIcon && !Ext.isEmpty($("#" + me.chartID).highcharts())){
				$("#" + me.chartID).highcharts().reflow();
			 }
			
			//var metricFontStyleObj={ 'font-color': fontColor };
		//var unitFontStyleObj={ 'font-size': '12' , 'font-color': ''};
		if ($('#'+me.id+' .dofontsize') ){
		
		var maxSize = 70,
		minSize = 30,
		defaultSize = 35;
		
		
		var fontSize = (me.getWidth() * me.getHeight())/1300;
		if (fontSize > maxSize) fontSize = maxSize;
		if (fontSize < minSize) fontSize = minSize;

		var fontLenght = 0;
		if(!Ext.isEmpty(me.measureValue))
		{
			fontLenght=me.measureValue.length;
		}
		if (fontLenght <= 7 ) 
		{
			fontSize = (me.getWidth() *  me.getHeight())/1300;
			if (fontSize > maxSize) fontSize = 70;
		}
		if (fontLenght <= 6 ) 
		{
			fontSize = (me.getWidth() *  me.getHeight())/1000;
			if (fontSize > maxSize) fontSize = 70;
		}
		if (fontLenght <= 5 ) 
		{
			fontSize = (me.getWidth() *  me.getHeight())/800;
			if (fontSize > maxSize) fontSize = 70;
		}
		if (fontLenght <= 4 ) 
		{
			fontSize = (me.getWidth() *  me.getHeight())/700;
			if (fontSize > maxSize) fontSize = 70;
		}			

		var isString = false;
		if(me.measureValue != null && me.measureValue!='')
		{
			var letters = /^[A-Za-z]+$/;
			for ( var valCount in me.measureValue) {
				var measName = me.measureValue.charAt(valCount);
				if(measName.match(letters))
				{
					  isString = true;
				}
			}
		
			if (isString)
			{
				if (fontSize>=25)
				{
					var halfFontSize=(fontSize/2);
					if(halfFontSize>35)
					{
						fontSize=35;
					}
					else if(halfFontSize>30)
					{
						fontSize=30;
					}
					else 
					{
						fontSize=25;
					}
				}								
			}
		}
		
		$('#'+me.id+' .dofontsize').css("font-size", fontSize + "px"); 
		$('#'+me.id+' .dofontsize').css("line-height", fontSize + "px");
		}
	},
    listeners: {
		
        viewready: function(cmp) {
            var me = this;
            var chartData = me.chartData;
            me.updateData(chartData);

        }
    }

});