Ext.define('MyDashBoard.view.TextEditor', {
    extend: 'Ext.container.Container',
    alias: 'widget.texteditor',
    cls: 'textWidgetDrag',
    partalID: null,
    saveData: Ext.emptyFn,
    editorObj: null,
    profileName: '',
    initComponent: function() {
        var me = this;
        var dashLayoutObj = Ext.getCmp('dashboardLayoutObj');
        me.profileName = dashLayoutObj.profileName;
        this.items = [{
            xtype: 'box',
            flex: 1,
            id: 'box' + me.partalID,
            ui: 'textWidgetContainer',
            style: {
                height: '100%'
            },
            autoScroll: true,
            listeners: {
                boxready: function(view) {
                    var editor1 = new Jodit('#' + view.id, {
                        preset: 'inline',
                        id: 'boxId' + me.partalID,
                        enter: "p",
			useSearch:false,
                        iframe: true,
						triggerChangeEvent : false,
                        iframeStyle: strSkin == 'Dark' ? 'html{margin: 0px; min-height: 110px;}body{min-height: 90px;padding:0px 25px 10px 0;background:#404040;color:#c6c6c6;position:relative;z-index:2;\										user-select:auto;margin:0px;overflow:hidden;}body:after{content:"";clear:both;display:block}p {margin:0px;}' : 'html{margin: 0px; min-height: 84px;}body{min-height: 64px;padding:0px 25px 10px 0;background:#fff;color:#1a1a1a;position:relative;z-index:2;\										user-select:auto;margin:0px;overflow:hidden;}body:after{content:"";clear:both;display:block}p {margin:0px;}',
                        popup: {
                            selection: ["bold", "underline", "italic", "ul", "ol", "font", "fontsize", "align", "brush"]
                        }
                    });
					
                    //editor.setEditorValue('Add Text Here');
                    
                        editor1.setEditorValue('Add Text Here...');
						 editor1.events.on('change', function(data) {
							var Textwid = editor1.getEditorValue();
							autoSaveText(editor1);
							
                    });
                   
                   
                    me.editorObj = editor1;                 
                    var autosave_timer = null;
                    function autoSaveText(editor1) {
                        if (autosave_timer) {
                            clearTimeout(autosave_timer);
                        }
                       autosave_timer = setTimeout(me.saveData(editor1), 400);
                    }
                }
            }
        }, {
            xtype: 'button',
            id: 'close' + me.partalID,
            icon: '../images/' + strSkin + '/window_close.png',
            style: {
                'position': 'absolute',
                'top': '0px',
                'right': '5px',
                'background': 'transparent',
                'border': 'none'
            },
            listeners: {
                click: function(e) {
                    Ext.MessageBox.confirm(
                        'Confirm', 'Are you sure want to delete ?', callbackFunction);

                    function callbackFunction(btn) {
                        if (btn == 'yes') {
                            var textWidgetCloseBtn = e.up("panel");
                            var gridStackObj = myDashApp.getController("Main").getGridstackpanel();
                            gridStackObj._removeWidget(textWidgetCloseBtn.id);
                            var paramsForDeleteBlock = 'action=deleteTable&profileName=' + me.profileName + '&key=' + me.partalID;
                            Ext.defer(function() {
                                var gridStackObj1 = Ext.getCmp('gridstackpanelObj');
                                var pnlPositions = gridStackObj1._serializationStr();
                                paramsForDeleteBlock = paramsForDeleteBlock + "&layoutConfig=" + encodeURIComponent(pnlPositions);
                                Ext.Ajax.request({
                                    url: '/final/servlet/com.eg.egMyDashboardController',
                                    method: 'POST',
                                    params: paramsForDeleteBlock,
                                    scope: this,
                                    success: function(response) {
                                        var configIds = publicJson['myDashboardConfigDetails']['configIds'];
                                        if (configIds != null && configIds.indexOf(me.partalID) > -1) {
                                            var tempConfgIdArr = new Array();
                                            for (var t = 0; t < configIds.length; t++) {
                                                var blkItm = configIds[t];
                                                if (blkItm != null && blkItm != me.partalID) {
                                                    tempConfgIdArr.push(blkItm)
                                                }
                                            }
                                            var existingRefreshIntObj = refreshIntervalTaskObj[me.partalID];
                                            refreshIntervalTaskObj[me.partalID] = window.clearInterval(existingRefreshIntObj);
                                            existingRefreshIntObj = null;
                                            delete existingRefreshIntObj;
                                            publicJson['myDashboardConfigDetails']['configIds'] = tempConfgIdArr;
                                            Ext.destroy(Ext.getCmp(me.partalID));
                                        }
                                    }
                                });
                            }, 600);
                        } else {}
                    };
                },
                afterrender: function(e) {
                   // console.log("e===>", e);
                }
            }

        }];
        this.callParent();
    },
    saveData: function(editor1) {
        var me = this;
		var edtObj = me.editorObj; //$('boxId' + me.partalID);//this.editorObj;//this.Jodit;//$('#boxId' + me.partalID);
        var textData = editor1.getEditorValue(false);
		var meC=myDashApp.getController("Main");
		textData = meC.replaceHtmlTag(textData,"<","|lt|");
		textData = meC.replaceHtmlTag(textData,">","|gt|");
		textData = meC.replaceHtmlTag(textData,"\"","|dbqt|");
		textData = meC.replaceHtmlTag(textData,",","|cma|");
		textData = meC.replaceHtmlTag(textData,":","|col|");
		textData = meC.replaceHtmlTag(textData,";","|scol|");
		textData=meC.filterEncode(textData);
        var paramsForSave = "action=saveTextWidgetData&textWidgetData=" + encodeURIComponent(textData) + "&blockId=" + encodeURIComponent(me.partalID) + "&profileName=" + encodeURIComponent(me.profileName);
		
        var gridStackObj = myDashApp.getController("WidgetConfigurationController").getGSPanel();
        var posStrVal = gridStackObj._serializationStr();
        if (posStrVal != null && posStrVal != '') {
            paramsForSave = paramsForSave + '&layoutConfig=' + encodeURIComponent(posStrVal);
        }
        var configPanl = Ext.getCmp(me.partalID);
        iAjax.request({
            url: '/final/servlet/com.eg.egMyDashboardController',
            method: 'POST',
            params: paramsForSave + '&screenWidth=' + (configPanl.getWidth() - 2) + '&screenHeight=' + (configPanl.getHeight() - 20),
            scope: this,
            success: function(response) {
                var jsonText = response.responseText;
                if (jsonText != null && jsonText != '') {
                    var jsonData = Ext.decode(jsonText);
                    configPanl.isInitialResizeCompleted = false;
                    configPanl.isHighChartUpdate = false;
                    configPanl.isConfigured = true;
                   // myDashApp.getController("Main").showLiveDataForBlock(jsonData, configPanl, me.partalID);
                    jsonData = null;
                    delete jsonData;
                }
                jsonText = null;
                delete jsonText;
            },
            failure: function(response, opts) {
                if (response.timedout) {
                    configPanl.removeAll();
                    configPanl
                        .add({
                            xtype: 'panel',
                            html: '<div><table border="0" cellspacing="0" cellpadding="0" width="98%" height="' +
                                (configPanl.getHeight() - 20) +
                                '"><tr><td  align="center" valign="middle" class="msgFont"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">' +
                                requestTimeoutMsg + '</div></td></tr></table></div>'
                        });
                    configPanl.setLoading(false);
                    configPanl.showLoadingMsg = false;
                    configPanl.doLayout();
                }
            }
        });
    }
})