Ext.define('MyDashBoard.view.TopologySettingsWindows', {
    extend: 'Ext.window.Window',
    alias: 'widget.topologysettingswindow',
    requires: ['Ext.ux.form.MultiSelect', 'utilities.Multiselector', 'MyDashBoard.view.ComparisonTable', 'utilities.CustomGrid', 'utilities.TimeLine', 'utilities.ScrollCombo'],
    title: 'Topology Configuration',
    width: 750,
    modal: true,
	border:false,
	frame:true,
    autoShow: false,
	ghost:false,
	padding:0,
	autoScroll:true,
	tableGridDataObj : null,
	topNGridDataObj : null,
	selectedTopNTest : '-1',
	/*header:{
		height:32,
		padding:'0 10',
		margin:0,
		//style:{'border-bottom':'#2b2b2b 1px solid !important'}
	},*/
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	cls:'myDashboardwindow',
//	suspendLayout : true,
	isFluidWindowConfigPopup : false,
    height: 150,
    blockId: null,
    blckType: null,
    closeAction: 'destroy',
    isAggregationDisabled: true,
    initComponent: function () {
        var blockType = '';
        var thisBlockId = this.blockId;
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
		this.suspendEvents(true);
        this.createCommonBlockLayout(this.isAggregationDisabled);
		this.resumeEvents();
        this.buttonAlign = 'center';
        this.callParent();
    },
    onRender: function () {
        var thisBlockId = this.blockId;
        var blockType = '';
        if (thisBlockId != null) {
            blockType = thisBlockId.substr(0, thisBlockId.indexOf("_"));
        }
        this.loadDefaultDataForCommonLayout(blockType, thisBlockId);
        this.callParent();
    },
    setBlockId: function (blockId) {
        this.blockId = blockId;
    },
    checkspecialCharacterForMetric: function (dispMVal) {
        var splChar = ":~!@#$%^&*+={}[]|\\;\"\<>,";
        for (var i = 0; i < obj_val.length; i++) {
            var check_char = splChar.indexOf(obj_val.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
    },
    loadDefaultDataForCommonLayout: function (blockType, thisBlockId) {
        var mePopup = this;
        var metricsFormPanelObj = this.getComponent('topologyconfigform');
        var metricsForm = metricsFormPanelObj.getForm();
		var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
        var thisWind = new Ext.LoadMask(this.getEl(), {
            msg: "Loading .."
        });
        thisWind.show();
        Ext.Ajax.request({
            url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
            method: 'POST',
            params: 'comesFrom=myDashboard&action=loadTopologyConfigPopup&profileName=' + profileName + '&blockId=' + thisBlockId +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
               if (jsonText != null && jsonText != '') {
					thisWind.hide();
					var jsonData = Ext.decode(jsonText);
					var configuredData = jsonData['configuredDetails'];
					this.suspendEvents(true);
					Ext.suspendLayouts();
					var viewTypeCombo = metricsForm.findField('viewTypeCombo');
//					viewTypeCombo.getStore().removeAll();
//					viewTypeCombo.setFieldLabel(configuredData['viewByName']);
//					var viewTypeCombo = viewTypeCombo.getStore();
//					viewTypeCombo.loadRawData(configuredData['viewByType']);
					var selectedViewType = configuredData['selectedViewType'];
					var viewTypeComboObj=Ext.getCmp('viewTypeCombo');
					if(!Ext.isEmpty(viewTypeComboObj))
					{
						viewTypeComboObj.setValue(selectedViewType);
					}
					else
					{
						viewTypeComboObj.setValue("-1");
					}
					var viewTypeValueCombo =  metricsForm.findField('viewTypeValueCombo');
					viewTypeValueCombo.getStore().removeAll();
					var viewTypeValueComboStore = viewTypeValueCombo.getStore();
					if(configuredData['viewByType']!=null)
					viewTypeValueComboStore.loadRawData(configuredData['viewByType']);
					//viewTypeValueComboStore.removeAll();
					else
				   {
					viewTypeValueComboStore.insert(0,{
						displayField:notApplicable,
						valueField: '-1'
					});
					viewTypeValueCombo.setValue('-1');
				   }
					var selectedViewTypeValue = configuredData['selectedTypeValue'];
					var viewTypeValComboObj=Ext.getCmp('viewTypeValueCombo');
					if(!Ext.isEmpty(viewTypeValComboObj) && selectedViewTypeValue!=null && selectedViewTypeValue!="")
					{
						viewTypeValComboObj.setFieldLabel(selectedViewType);
						viewTypeValComboObj.setValue(selectedViewTypeValue);
					}
					else
					{
						viewTypeValComboObj.setValue("-1");
					}
					this.resumeEvents();
					Ext.resumeLayouts(true);
				}
			},
            failure: function () {

            }
        });
    },
    createCommonBlockLayout: function (isAggregationDisabled) {
		var blkId=this.blockId;
        this.items = [{
            xtype: 'form',
            itemId: 'topologyconfigform',
            buttonAlign: 'center',
            defaults: {
               // boddyPadding: '0 0 0 10',
                margin : '0 20 0 10'
            },
            buttons: [{
                text:updateDispBtn,
                id: 'addBlockConfig',
                name: 'addBlockConfig',
                cls: 'button20'
            }],
			layout:{ type : 'hbox', align : 'stretch' },
			items:[
			
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					fieldLabel: 'Choose a Grouping',
					id: 'viewTypeCombo',
					name: 'viewTypeCombo',
					labelWidth :120,
					emptyText: 'Choose a Grouping',
					width: 300,
					margin:'25 10 10 10',
					store: Ext.create('Ext.data.Store', {
					fields: ['displayField','valueField'],
					data: [{'displayField':'Segment','valueField' : 'Segment'},{'displayField':'Service','valueField' : 'Service'}]
				}),
					editable: false,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					fieldLabel: 'Group Name',
					id: 'viewTypeValueCombo',
					name: 'viewTypeValueCombo',
					margin:'25 10 10 0',
					//height: 123,
					width: 280,
					store: Ext.create('Ext.data.Store', {
						fields: ['displayField', 'valueField'],
						data: []
					}),
					editable: false,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
				}
				
			]
		}]
	}
})

