Ext.define('MyDashBoard.view.VMAlarmsWidgetConfigPopup', {
    extend: 'Ext.window.Window',
    alias: 'widget.vmAlarmsWidgetConfigPopup',
    requires: ['Ext.ux.form.MultiSelect', 'MyDashBoard.view.GridComparisonTable','utilities.CustomGrid','utilities.ScrollCombo'],
    title: MetricDDTitle,
    width: 780,
    modal: true,
	border:false,
	frame:true,
    autoShow: false,
	ghost:false,
	padding:'0 0 0 0',
	autoScroll:true,
	/*header:{
		height:32,
		padding:'0 20',
		margin:0
	},*/
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	autoShow : false,
    cls:'myDashboardwindow',
	ui:'newPopupWindow newplainHeader',
	bodyPadding:0,
	height:450,
	blockId : null,
	isFluidWindowConfigPopup : true,
	closeAction : 'destroy',
	initComponent : function()
	{
		this.buttonAlign = 'center';
		this.callParent();
	},
	items: [{
		xtype: 'form',
		itemId : 'vmconfigForm',
		buttonAlign: 'center',
		defaults: {
			padding: '0',
			margin: '0',
		},
		buttons: [{
				text: addDispBtn,
				id: 'addVMBlockConfig',
				name: 'addVMBlockConfig',
				cls: 'button20'
			}],
		items: [{
					xtype: 'container',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						margin: '0 10 0px 0px',
						labelSeparator:'',
					},
					items: [{
						xtype: 'container',
						defaults: {
							labelAlign: 'top',
							labelSeparator:''
						},
						items: [{
							xtype: 'scrollcombo',
							id : 'vmCompTypeCombo',
							name : 'vmCompTypeCombo',
							cls: 'dropdown',
							fieldLabel: 'Component Type',
							width: 220,
							margin:'10 0 0 10',
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							value : notApplicable
						}
					]
				},
				{
					xtype: 'container',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						margin: '0 10 0px 0px',
						labelSeparator:''
					},
					items: [{
                        xtype: 'container',
                        defaults: {
                            labelAlign: 'top',
							labelSeparator:''
                        },
                        items: [
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: 'Component',
								id : 'vmcompCombo',
								name : 'vmcompCombo',
								margin:'10 0 0 10',
								width: 220,
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: []
								}),
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								value : notApplicable
							}

							]
					}]
                }, {
                    xtype: 'container',
					defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
					padding:'10 0 10 0',
                    items: [
						{
							xtype :'label',
							id : 'vmListLbl',
							name : 'vmListLbl',
							margin:'10 0 5 0',
							cls:'font_bold12',
						},
						{
                            xtype: 'multiselect',
						    margin: '5px 0px 0px 0px',
                            id: 'vmListCombo',
                            name: 'vmListCombo',
							baseCls: 'egmultiselect',
                            multiSelect: true,
                            height: 110,
                            width: 240,
                            store: Ext.create('Ext.data.Store', {
                                fields: ['displayField','valueField'],
                                data: []
                            }),
							scroll : true,
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							value : notApplicable,
							listConfig:{
							id : 'vmsList',
							name : 'vmsList',
							simpleSelect: true,
							itemTpl:new Ext.XTemplate(
								'<tpl for=".">',
									'<div id="{valueField}"  style="text-align:left">{displayField}</div>',
								'</tpl>'
							),
							listeners:{
								itemdblclick:function(thisItems, record, item, index, e, eOpts){
									var me = this
									var selection = thisItems.getSelectionModel().getSelection();
									for (var i=0; i< selection.length; i++)
									{

										mySelectionHeaders = selection[i].data.displayField;
										mySelectionHeadersd = selection[i].data.valueField;

										var editor = new Ext.Editor({
												updateEl: true,
												shadow:false,
												border:false,
												width:230,
												field: {
													xtype: 'textfield',
													height:26,
													width :230
												},
												ignoreNoChange : true,
												listeners :
												{
													'beforecomplete' : function(meEdtr,value,startValue,eOpts)
													{
														if(value==null || value==''  || value=='-1')
														{
															meEdtr.setValue(startValue);
															Ext.Msg.show({
																title: 'Alert',
																msg: componentEmptyMsg,
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
															});
															return false;
														}
														else if(me.store.find('displayField', value, 0, false, true, true)!=-1)
														{
															meEdtr.cancelEdit(false);
															Ext.Msg.show({
																title: 'Alert',
																msg: compNameAlreadyExists,
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
															});
															return false;

														}
														else if(myDashApp.getController("Main").checkSpecialCharacter(value))
														{
															Ext.Msg.show({
															title: 'Alert',
															msg: compnameSpecialCharacterAlert,
															buttons: Ext.MessageBox.OK,
															icon: Ext.MessageBox.WARNING
															 });
															return;
														}
													},
													'complete' : function(meEdtr, value, startValue, eOpts)
													{
														me.store.suspendEvents();
														me.store.insert(index,{'displayField':this.getValue(),'valueField':mySelectionHeadersd});
														me.store.remove(selection[i], true);
														me.store.resumeEvents();
													}

												}
											});
											if(mySelectionHeadersd!="-1")
											{
												var el = Ext.get(mySelectionHeadersd); // The element to 'edit'
												editor.startEdit(el,el.getValue());
											}
										
									}
								}
							}
						}
					


                        },{




            hidden: false
        }
                    ]
			}]
			}
			]
	},{
						xtype: 'gridcomparisontable',
						hidden: false
			}],

	 onRender : function () {
		var mePopup = this;
		var thisBlockId = mePopup.blockId;
		var vmFormPanelObj = this.getComponent('vmconfigForm');
		var vmConfigForm = vmFormPanelObj.getForm();
		var editViewPage='dashboardLayout2';
		if(this.isFluidWindowConfigPopup)
		{
			editViewPage='fluidDashLayout';
			
		}
        var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		var thisWind =new Ext.LoadMask(this.getEl(), {
							msg : "Loading .."
					});
		thisWind.show();

			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params: 'comesFrom=myDashboard&action=loadVMConfigPopup&profileName='+profileName+'&blockId='+thisBlockId+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						thisWind.hide();
						var compTypeCombo = vmConfigForm.findField('vmCompTypeCombo');

						var vmConfigDetails = jsonData['vmConfigDetails'];

						var selectedCompType = '';
						var selectedComp = '';
						var selectedTest = '';
						var selectedMeasure = '';
						var ddColumns = '';
						var myDashC = '';
						if(!Ext.isEmpty(vmConfigDetails))
						{
							 var gridData = vmConfigDetails['gridData'];
							 if (!Ext.isEmpty(gridData)) {

								var configTableGrid = Ext.getCmp('gconfigTableGrid');
								configTableGrid.suspendEvents(true);

								 var gridStore = configTableGrid.getStore();
								gridStore.add(gridData);
								configTableGrid.show();
								configTableGrid.resumeEvents();
								configTableGrid.doComponentLayout();




							 }

						}

						compTypeCombo.getStore().removeAll();
						compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
						var compTypeStore = compTypeCombo.getStore();
						compTypeStore.loadRawData(jsonData['comptypes']);
						compTypeStore.insert(0,{
							//displayField:jsonData['screenLabels']['reporter.common.Please choose a Component Type'],
							displayField:"Please choose a Component Type",
							valueField: '-1'
						});
						if(selectedCompType!=null && selectedCompType!='')
						{
							compTypeCombo.setValue(selectedCompType);
						}
						else
						{
							compTypeCombo.setValue('-1');
						}

						var compCombo = vmConfigForm.findField('vmcompCombo');
						compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
						var compComboStore = compCombo.getStore();
						compComboStore.removeAll();
						compComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							compCombo.setValue('-1');

						var vmListLbl=Ext.getCmp('vmListLbl');
						vmListLbl.setText(jsonData['screenLabels']['monitor.common.Vm(s)']);
						var vmDesc = vmConfigForm.findField('vmListCombo');
						var vmDescComboStore = vmDesc.getStore();
						vmDescComboStore.removeAll();

						vmDescComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							vmDesc.setValue('-1');
					}
				},
				failure : function()
				{

				}
			});
			this.callParent();
		},
		setBlockId : function(blockId)
		{
			this.blockId = blockId;
		},
		checkspecialCharacterForMetric : function(dispMVal)
		{
			var splChar =":~!@#$%^&*+={}[]|\\;\"\<>,";
			for(var i=0; i<obj_val.length; i++)
			{
				var check_char = splChar.indexOf(obj_val.charAt(i))
				//Returns value 1 if the special character listed in splChar is found
				if(check_char >= 0)
				{
					return true;
				}
			}
		}
})