Ext.define('MyDashBoard.view.ViewPortalPanel',{
	extend:'Ext.panel.Panel',
	alias:'widget.viewportalpanel',
	margin:'5px 0px',
	autoDestroy:true,
	resizable : false,
	cls: 'block1',
	bodyStyle:{'background':'#fff'},
	height:250,
	meViewPortPanel : this,
	layerModelUrl : null, // this is used for dial,digital and pie charts
	hideMaxIcon : false,
	isRequestTimeoutHappened : false,
	initComponent : function()
	{
		var thisBlkId = this.id;
		var toolsArr = new Array();
		
		if(thisBlkId!=null && thisBlkId.indexOf("_")>0)
		{
			var blockType = thisBlkId.substr(0,thisBlkId.indexOf("_"));
			if(blockType!=null && (blockType=='BarChart' || blockType=='table'))
			{
				toolsArr.push({
							xtype: 'scrollcombo',
							fieldLabel : showLbl,
					//		id : 'showCombo_'+new Date().getTime(),
							itemId : thisBlkId+'_combo',
							hidden : true,
							cls: 'dropdown',
							labelSeparator : '',
							labelWidth : 35,
							width: 120,
							margin:'0 3 0 0',
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							listeners :  
							{
								'select' : function(combo) {
								myDashApp.getController("Main").showTopNGraph(combo.getValue(),combo.up('panel'));
								}
							}

						});
			}
			else if(blockType!=null && blockType=='ddTable')
			{
				toolsArr.push({
							xtype: 'scrollcombo',
							fieldLabel : descLbl,
					//		id : 'showCombo_'+new Date().getTime(),
							itemId : thisBlkId+'_combo',
							hidden : true,
							cls: 'dropdown',
							labelSeparator : '',
							labelWidth : 60,
							width: 220,
							margin:'0 3 0 0',
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							listeners :  
							{
								'select' : function(combo) {
								myDashApp.getController("Main").showDDForSelectedDescptr(combo.getValue(),combo.up('panel'));
								}
							}

						});
			}

			
	}
			if(!this.hideMaxIcon)
			{
				toolsArr.push(
							{
							xtype : 'container',
							margin : '0 1px 0 1px',
						//	cls : 'iconBg',
							items : [
								
								{
										xtype : 'button',
										iconCls : 'iconMaximize',
										action:'maximize',
										listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Maximize'
																});
															}
														},
											
											style : {
												background : 'none',
												border : '0px'
											}
									}]
						});
			}
			this.tools = toolsArr; 
			this.callParent();
	}
});