Ext.define('MyDashBoard.view.WidgetOptionsWindow',{
extend:'Ext.window.Window',
alias:'widget.widgetOptionsWindow',
title : '',
requires: [
	'Ext.ux.form.MultiSelect', 
	'utilities.Multiselector',
	'MyDashBoard.view.ComparisonTable',
	'MyDashBoard.view.Portlet',
	'MyDashBoard.view.GridComparisonTable',
	'MyDashBoard.view.GroupSelection',
	'MyDashBoard.view.PreviewContainer'
],
//width:strSkin == "Light" ? 500 : 480,
//height:strSkin == "Light" ? 260 : 250,
width:990,
maxHeight:Ext.getBody().getViewSize().height-10,
height:544,
ui:'newPopupWindow widgetOptionsWindowHeader',
cls:'myDashboardwindow',
id:'widgetOptionsWindow',
	//store :['WidgetDataStore'],
header:{
	height:50,
	layout: 'hbox',
	padding:'0 10',
	margin:0,
	cls:'',
	// header title
	items: [{
		xtype:'label',
		id:'config-window-title',
		name:'config-window-title',
		cls:'x-window-header-text-newPopupWindow widgetOptionsWindowHeader',
		text:screenLabelsObj['WidgetConfigLbl']
	}]
},
scroll:false,
autoScroll:false,
layout:{
	type:'vbox',
	align:'stretch'
},
widgetID : '',
widgetType : '',
showConfigurationTab : false,
isAggregationDisabled: true,
widgetSettingsJsonArr : null,
tableGridDataObj : null,
isTopNWidget : false,
frame:true,
padding:0,
bodyPadding:'0',
margin:0,
resizable:false,
border:false,
modal:true,
ghost:false,
closeAction : 'destroy',
widgetPreviewDimensions : {},
isExternalDataSourceWidget : false,
isKpi: false,
Kpicount:0,
currentCount:0,
needToUpdateCount:true,
KpiDataArray:null,
kpiBlckId:null,

totalKpiCount:null,
autoAssociateComponents : false,
initComponent : function() {  
	var widgetPreviewDimensions={};
	widgetPreviewDimensions['activityChart']=[343 , 248];
	widgetPreviewDimensions['areaChart']=[343,248];
	widgetPreviewDimensions['BarChart']=[427,248];
	widgetPreviewDimensions['combinationChart']=[427,248];
	widgetPreviewDimensions['CombinedTimelineChart']=[427,248];
	widgetPreviewDimensions['ddTable']=[427,248];
	widgetPreviewDimensions['dialChart']=[259,248];
	widgetPreviewDimensions['digitalChart']=[280,238];
	widgetPreviewDimensions['geomap']=[427,248];
	widgetPreviewDimensions['health']=[343,248];
	widgetPreviewDimensions['heatMapChart']=[424,248];
	widgetPreviewDimensions['liveMeasuresBox']=[343,248];
	widgetPreviewDimensions['networkhealth']=[427,248];
	widgetPreviewDimensions['news']=[427,248];
	widgetPreviewDimensions['pieChart']=[343,248];
	widgetPreviewDimensions['servicehealth']=[427,248];
	widgetPreviewDimensions['table']=[427,248];
	widgetPreviewDimensions['tierhealth']=[427,248];
	widgetPreviewDimensions['TimelineChart']=[427,248];
	widgetPreviewDimensions['TopNAnalysis']=[339,203];
	widgetPreviewDimensions['TopologyWidget']=[427,248];
	widgetPreviewDimensions['TrendGraph']=[427,248];
	widgetPreviewDimensions['vmAlarmsWidget']=[427,248];
	widgetPreviewDimensions['weather']=[343,248];
	widgetPreviewDimensions['ScatterPlot']=[327,205];

	this.widgetPreviewDimensions=widgetPreviewDimensions;
	
	this.createConfigLayout();
	
	this.callParent(this);
},
createConfigLayout : function()
{
	return this.createConfigLayout(false);
},
createConfigLayout : function(reCreateLayout)
{
	var mePopup=this;
	if(reCreateLayout)
	{
		if(mePopup.widgetType == 'TopNAnalysis')
		{
			mePopup.isTopNWidget=true;
		}
		if(mePopup.widgetType!=null && mePopup.widgetType=='TopologyWidget')
		{
			mePopup.add(createConfigurationForTopologyWidget());
		}
		else if(mePopup.widgetType!=null && mePopup.widgetType=='vmAlarmsWidget')
		{
			mePopup.add(mePopup.createConfiguartionForVMAlertWidget());
		}
		else if(mePopup.widgetType!=null && mePopup.widgetType=='servicehealth')
		{
			mePopup.add(mePopup.createConfiguartionForServiceHealthWidget());
		}
		else
		{
			mePopup.add(mePopup.createConfigurationWindowLayout(reCreateLayout));
		}
		mePopup.doLayout();
	}
	else
	{
		if(mePopup.isExternalDataSourceWidget)
		{
			mePopup.items={
					xtype : 'addexternalmetrics',
					id : 'widgetChartAttrs',
					name : 'widgetChartAttrs',
					margin:'5 0 10 5',
					widgetID : mePopup.widgetID,
					widgetType : mePopup.widgetType,
					isKpi : mePopup.isKpi,
					Kpicount : mePopup.Kpicount,
					totalKpiCount : mePopup.totalKpiCount,
					kpiBlckId : mePopup.kpiBlckId
			};

			if(mePopup.isKpi)
			{

				Ext.defer(function(){
					var prevButtonObj = Ext.getCmp('prevButton');
					var nextButtonObj = Ext.getCmp('nextButton');
					if(mePopup.Kpicount==1)
					{
						prevButtonObj.needToDisable = true;
						prevButtonObj.setDisabled(true);
					}

					if(mePopup.Kpicount==mePopup.totalKpiCount)
					{
						nextButtonObj.needToDisable = true;
						nextButtonObj.setDisabled(true);
					}			

					if(!prevButtonObj.needToDisable)
					{
						prevButtonObj.setDisabled(false);
					}

					if(!nextButtonObj.needToDisable)
					{	
						nextButtonObj.setDisabled(false);
					}

				},800);
			}
		}
		else
		{

			var isKpiWidget = mePopup.isKpi;	
			if(mePopup.widgetType == 'TopNAnalysis')
			{
				mePopup.isTopNWidget=true;
			}
			if(mePopup.widgetType!=null && mePopup.widgetType=='TopologyWidget')
			{
				mePopup.items=mePopup.createConfigurationForTopologyWidget();
			}
			else if(mePopup.widgetType!=null && mePopup.widgetType=='vmAlarmsWidget')
			{
				mePopup.items=mePopup.createConfiguartionForVMAlertWidget();
			}
			else if(mePopup.widgetType!=null && mePopup.widgetType=='servicehealth')
			{
				mePopup.items=mePopup.createConfiguartionForServiceHealthWidget();
			}
			else
			{
				mePopup.items=mePopup.createConfigurationWindowLayout();
			}
		}
		var hideExternalIntegrationSettings=false;
		if(mePopup.widgetType == 'TopNAnalysis' ||  mePopup.widgetType=='TopologyWidget' || mePopup.widgetType=='vmAlarmsWidget' || mePopup.widgetType=='combinationChart' || mePopup.widgetType=='liveMeasuresBox' || mePopup.widgetType=='health' || mePopup.widgetType=='ddTable' || mePopup.widgetType=='TrendGraph' || mePopup.widgetType=='ScatterPlot'|| mePopup.widgetType=='servicehealth')
		{
			hideExternalIntegrationSettings=true;
		}
		mePopup.tools =[
			{
			xtype: 'toolbar',
			dock: 'top',
			items: [
			
			{
			xtype : 'switchfield',
			fieldLabel:screenLabelsObj['UseExternalDS'],
			margin:'8 54 0 50',
			style:{'z-index':'9'},
			labelWidth:180,
			inputValue: 'Yes',
			labelSeparator:'',
			labelAlign:'right',
			labelStyle: 'line-height:13px;',
			uncheckedValue:'No',
			labelSeparator :"",
			id : 'useExternalData',
			name : 'useExternalData',
			isSwitchFieldLoaded : false,
			hidden : hideExternalIntegrationSettings,
			listeners : {
				'afterrender' : function()
				{
					this.isSettingDefaultValue=true;
					this.setValue(this.up('window').isExternalDataSourceWidget);
					this.isSettingDefaultValue=false;
				}
			}
        }
			]
		}
		];
		mePopup.dockedItems = [{
			xtype: 'toolbar',
			dock: 'bottom',
			cls:'egFooterNewConfigWin',
			height: 60,
			layout : {
				type:'hbox',
				pack: mePopup.isKpi? 'center': 'end',

			},
			items: [
				
				{
					xtype : 'button',
					buttonAlign:'right',
					id:'doneButton',
					align: 'right',
					text : mePopup.isKpi? 'Finish' : screenLabelsObj['DoneButtonLabel'],
					margin:'0 20 0 0',
					padding:'5 15 5 15',

					cls : 'newConfigWinBtn newFont_normal14',
					disabled : true
				},
			
			]
		}];
	}
},
setWidgetPopupTitle : function(title)
{	var widgetPopupTitObj=Ext.getCmp('config-window-title');
	if(!Ext.isEmpty(widgetPopupTitObj))
	{
		widgetPopupTitObj.setText(title);
	}
},
createConfiguartionForVMAlertWidget : function()
{
	var thisWidgetID=this.widgetID;
		//var topoPopupCtrlsArr=[];
	var isChart=false;
	var isTopNChart=false;
	var widgetPreviewTitle='';
	var widgetPnlObj=Ext.getCmp(thisWidgetID);
	if(!Ext.isEmpty(widgetPnlObj))
	{
		isChart=widgetPnlObj.isChart;
		isTopNChart=widgetPnlObj.isTopNChart;
		widgetPreviewTitle=widgetPnlObj.title;
	}
	var vmAlertWidForm = {
								xtype: 'container',
								layout : {
									type : 'vbox'
								},
								width: 370,
								height: 300,
								cls:'',
								//hidden: true,		
								margin:'0 0 0 0',
								padding:'0 0 0 0',
					items: [{
						xtype:'container',
						cls:'b-container',
						padding:0,
						defaults:{
							margin: '10 0 10 0 ',
							labelWidth:'auto',
							labelSeparator:'',
							labelStyle: 'white-space: pre;'
						},
						items: [{
							xtype: 'scrollcombo',
							id : 'componentTypeCombo',
							name : 'componentTypeCombo',
							cls: 'dropdown',
							fieldLabel: 'Component Type',
							labelWidth:150,
							width:360,	
							store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: []
							}),
							editable:false,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							value : notApplicable
						}
					]
				},
					{
						xtype:'container',
						cls:'b-container',
						padding:0,
						defaults:{
							margin: '10 0 10 0 ',
							labelWidth:'auto',
							labelSeparator:'',
							labelStyle: 'white-space: pre;'
						},
						items:{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: 'Component',
								id : 'componentCombo',
								name : 'componentCombo',
								labelWidth:150,
								width:360,	
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: []
								}),
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								value : notApplicable
							}
							
						
                }, {
                    xtype: 'container',
					width:'100%',
					//cls:'b-container',
					defaults: {
                        labelAlign: 'top',
						labelSeparator:''
                    },
					padding:'5px 20px 5px 0',
                    items: [
						{
							xtype :'label',
							id : 'vmListLbl',
							name : 'vmListLbl',
							margin:'0 10px 5px 0px',
							cls:'x-form-item-label'
						},
						
							{
								xtype: 'multiselect',
								margin: '0px 0px 5px 0px',
								id: 'vmListCombo',
								name: 'vmListCombo',
								baseCls: 'egmultiselect',
								multiSelect: true,
								height: 110,
								width:360,
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: []
								}),
								scroll : true,
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								value : notApplicable,
								listConfig:{
								id : 'vmsList',
								name : 'vmsList',
								simpleSelect: true,
								itemTpl:new Ext.XTemplate(
									'<tpl for=".">',
										'<div id="{valueField}"  style="text-align:left">{displayField}</div>',
									'</tpl>'
								),
								listeners:{
									itemdblclick:function(thisItems, record, item, index, e, eOpts){
										var me = this
										var selection = thisItems.getSelectionModel().getSelection();
										for (var i=0; i< selection.length; i++)
										{

											mySelectionHeaders = selection[i].data.displayField;
											mySelectionHeadersd = selection[i].data.valueField;

											var editor = new Ext.Editor({
													updateEl: true,
													shadow:false,
													border:false,
													width:335,
													field: {
														xtype: 'textfield',
														height:21,
														width:335
													},
													ignoreNoChange : true,
													listeners :
													{
														'beforecomplete' : function(meEdtr,value,startValue,eOpts)
														{
															if(value==null || value==''  || value=='-1')
															{
																meEdtr.setValue(startValue);
																Ext.Msg.show({
																	title: 'Alert',
																	msg: componentEmptyMsg,
																	buttons: Ext.MessageBox.OK,
																	icon: Ext.MessageBox.WARNING
																});
																return false;
															}
															else if(me.store.find('displayField', value, 0, false, true, true)!=-1)
															{
																meEdtr.cancelEdit(false);
																Ext.Msg.show({
																	title: 'Alert',
																	msg: compNameAlreadyExists,
																	buttons: Ext.MessageBox.OK,
																	icon: Ext.MessageBox.WARNING
																});
																return false;

															}
															else if(myDashApp.getController("Main").checkSpecialCharacter(value))
															{
																Ext.Msg.show({
																title: 'Alert',
																msg: compnameSpecialCharacterAlert,
																buttons: Ext.MessageBox.OK,
																icon: Ext.MessageBox.WARNING
																 });
																return;
															}
														},
														'complete' : function(meEdtr, value, startValue, eOpts)
														{
															me.store.suspendEvents();
															me.store.insert(index,{'displayField':this.getValue(),'valueField':mySelectionHeadersd});
															me.store.remove(selection[i], true);
															me.store.resumeEvents();
														}

													}
												});
												if(mySelectionHeadersd!="-1")
												{
													var el = Ext.get(mySelectionHeadersd); // The element to 'edit'
													editor.startEdit(el,el.getValue());
												}
											
										}
									}
								}
							}
						},
						{
						xtype:'container',
						layout:{
							type:'vbox'
						},
						width:360,
						padding:0,
						defaults:{
							margin: '5 0 10 280'
						},
						items:
						{
							xtype : 'button',
							
							width:80,
							text: addDispBtn,
							id: 'addVMBlockConfig',
							name: 'addVMBlockConfig',
							cls: 'button20'
						},		
						}
                    ],

			},
				/*{
						xtype:'container',
						width:'100%',
						layout:{
							type:'vbox'
						},
						padding:0,
						defaults:{
							margin: '10 0 10 260 '
						},
						items:{
							xtype : 'button',
							width:80,
							text: addDispBtn,
							id: 'addVMBlockConfig',
							name: 'addVMBlockConfig',
							cls: 'button20'
					   }	
						}*/
							/*,{
				xtype: 'container',
				defaults: {
					labelAlign: 'top',
					labelSeparator:''
				},
				padding:'10 0 10 0',
				items : {
							xtype : 'button',
							text: addDispBtn,
							id: 'addVMBlockConfig',
							name: 'addVMBlockConfig',
							cls: 'button20'
					   }	
					}*/]
			};
			var portletWidth=400;
			var portletHeight=250;
			var portletDims=this.widgetPreviewDimensions[this.widgetType];
			if(!Ext.isEmpty(portletDims))
			{
				portletWidth=portletDims[0];
				portletHeight=portletDims[1];
			}
	return {
				xtype: 'form', 
				id : 'configForm',
				width: '100%',
				flex:1,
				modal: true,
				autoScroll:true,
				layout : {
					type : 'vbox'
				},
				//hidden: true,
				defaults: {
					labelAlign: 'top',
					labelSeparator:''
				},	
				bodyPadding:10,
				margin:'0 0 0 0',
			//	padding:'0 10',
				items: [
					{
							xtype:'panel',
							width: '100%',
							items:[{
								xtype:'container',
								width: '100%',
								//height: 100,
								layout : {
									type : 'hbox'
								},
								items: [
									{
											xtype:'previewcontiner',
											margin:'4 20 4 10',
											width: portletWidth,
											height  : portletHeight,
											items:[{
											xtype: 'portlet',
											width: portletWidth - 23,
											height  : portletHeight - 23,
											id: thisWidgetID+'_previewImage',
											title : widgetPreviewTitle,
											ui : 'newGraphPanel',
											cls:'previewImage',	
											margin:'0 0 0 0',
											padding:'0',
											isChart : isChart,
											isTopNChart : isTopNChart,
											showMoreDataOption : false,
											isPreviewMode : true
											}]
											
							},vmAlertWidForm]
						}]
					},
					{

						xtype: 'gridcomparisontable',
						margin: '0 0 0 0',
						header:false,
						hidden : false
					}]
			};

},
createConfigurationForTopologyWidget : function()
{
	var thisWidgetID = this.widgetID;
	//var topoPopupCtrlsArr=[];
	var isChart=false;
	var isTopNChart=false;
	var widgetPreviewTitle='';
	var widgetPnlObj=Ext.getCmp(thisWidgetID);
	if(!Ext.isEmpty(widgetPnlObj))
	{
		isChart=widgetPnlObj.isChart;
		isTopNChart=widgetPnlObj.isTopNChart;
		widgetPreviewTitle=widgetPnlObj.title;
	}
	
	var portletWidth=400;
	var portletHeight=250;
	var portletDims=this.widgetPreviewDimensions[this.widgetType];
	if(!Ext.isEmpty(portletDims))
	{
		portletWidth=portletDims[0];
		portletHeight=portletDims[1];
	}
	return [{
		xtype:'panel',
		width: '100%',
		margin:10,
		layout : {
			type : 'hbox'
		},
		items: [
			{
				xtype:'previewcontiner',
				margin:'4 20 4 10',
				width: portletWidth,
				height  : portletHeight,
				items:[
				{
				xtype: 'portlet',
				width: portletWidth - 23,
				height  : portletHeight - 23,
				id: thisWidgetID+'_previewImage',
				title : widgetPreviewTitle,
					ui : 'newGraphPanel',
				cls:'previewImage',	
				margin:'0 0 0 0',
				padding:'0',
				isChart : isChart,
				isTopNChart : isTopNChart,
				showMoreDataOption : false,
				isPreviewMode : true
				}	
				]
				
			},
			{
				 xtype: 'form',
				 id: 'topologyconfigform',
						buttonAlign: 'center',
						defaults: {
						   // boddyPadding: '0 0 0 10',
							margin : '0 20 0 10'
						},
						layout:{ type : 'vbox', align : 'stretch' },
						items:[
						{
						xtype:'container',
						cls:'b-container',
						padding:0,
						defaults:{
							margin: '10 20 10 0 ',
							labelWidth:'auto',
							labelStyle: 'white-space: pre;'
						},
						items:{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: 'Choose a Grouping',
								id: 'viewTypeCombo',
								labelSeparator:"",
								name: 'viewTypeCombo',
								labelWidth :120,
								emptyText: 'Choose a Grouping',
								width: 300,
								store: Ext.create('Ext.data.Store', {
								fields: ['displayField','valueField'],
								data: [{'displayField':'Segment','valueField' : 'Segment'},{'displayField':'Service','valueField' : 'Service'}]
							}),
								editable: false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							}
						},{
								xtype:'container',
								cls:'b-container',
								padding:0,
								defaults:{
									margin: '10 20 10 0 ',
									labelWidth:'auto',
									labelStyle: 'white-space: pre;'
								},
								items:{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										labelSeparator:"",
										fieldLabel: 'Group Name',
										id: 'viewTypeValueCombo',
										name: 'viewTypeValueCombo',
										labelWidth :120,
										//height: 123,
										//width: 280,
										width: 300,
										store: Ext.create('Ext.data.Store', {
											fields: ['displayField', 'valueField'],
											data: []
										}),
										editable: false,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										widgetID : thisWidgetID,
										listeners : {
											'select': function(cmbObj)
											{
												 Ext.getCmp('doneButton').enable();
												myDashApp.getController("WidgetConfigurationController").showWidgetPreview(cmbObj.widgetID);
											}
										}
									}
								}
							
							
						]
				}
			]
	}];
},
loadDefaultDataForTopologyWidgetPopup: function ()
{
	var mePopup = this;
	var metricsFormPanelObj = Ext.getCmp('topologyconfigform');
	var metricsForm = metricsFormPanelObj.getForm();
	var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
	var thisWind = new Ext.LoadMask(this.getEl(), {
		msg: "Loading .."
	});
	thisWind.show();
	Ext.Ajax.request({
		url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
		method: 'POST',
		params: 'comesFrom=myDashboard&action=loadTopologyConfigPopup&profileName=' + profileName + '&blockId=' + mePopup.widgetID +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
		scope: this,
		success: function (response) {
			var jsonText = response.responseText;
		   if (jsonText != null && jsonText != '') {
				thisWind.hide();
				var jsonData = Ext.decode(jsonText);
				var configuredData = jsonData['configuredDetails'];
				mePopup.setWidgetPopupTitle(configTitle[mePopup.widgetType]+" "+addMetricsTitle);
				this.suspendEvents(true);
				Ext.suspendLayouts();
				var viewTypeCombo = metricsForm.findField('viewTypeCombo');
//					viewTypeCombo.getStore().removeAll();
//					viewTypeCombo.setFieldLabel(configuredData['viewByName']);
//					var viewTypeCombo = viewTypeCombo.getStore();
//					viewTypeCombo.loadRawData(configuredData['viewByType']);
				var selectedViewType = configuredData['selectedViewType'];
				var viewTypeComboObj=Ext.getCmp('viewTypeCombo');
				if(!Ext.isEmpty(viewTypeComboObj))
				{
					viewTypeComboObj.setValue(selectedViewType);
				}
				else
				{
					viewTypeComboObj.setValue("-1");
				}
				var viewTypeValueCombo =  metricsForm.findField('viewTypeValueCombo');
				viewTypeValueCombo.getStore().removeAll();
				var viewTypeValueComboStore = viewTypeValueCombo.getStore();
				if(configuredData['viewByType']!=null)
				viewTypeValueComboStore.loadRawData(configuredData['viewByType']);
				//viewTypeValueComboStore.removeAll();
				else
			   {
				viewTypeValueComboStore.insert(0,{
					displayField:notApplicable,
					valueField: '-1'
				});
				viewTypeValueCombo.setValue('-1');
			   }
				var selectedViewTypeValue = configuredData['selectedTypeValue'];
				var viewTypeValComboObj=Ext.getCmp('viewTypeValueCombo');
				if(!Ext.isEmpty(viewTypeValComboObj) && selectedViewTypeValue!=null && selectedViewTypeValue!="")
				{
					viewTypeValComboObj.setFieldLabel(selectedViewType);
					viewTypeValComboObj.setValue(selectedViewTypeValue);
				}
				else
				{
					viewTypeValComboObj.setValue("-1");
				}
				this.resumeEvents();
				Ext.resumeLayouts(true);

				 Ext.getCmp('doneButton').enable();

				
			}
		},
		failure: function () {

		}
	});
 },
loadDefaultDataforVMAlertsWidget : function()
{
	 var mePopup = this;
		var thisBlockId = mePopup.widgetID;
		var vmFormPanelObj = Ext.getCmp('configForm');
		var vmConfigForm = vmFormPanelObj.getForm();
		var editViewPage='dashboardLayout2';
		if(this.isFluidWindowConfigPopup)
		{
			editViewPage='fluidDashLayout';
			
		}
        var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
		var thisWind =new Ext.LoadMask(this.getEl(), {
							msg : "Loading .."
					});
		thisWind.show();

			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgMonitorRequestDispatcher',
				method : 'POST',
				params: 'comesFrom=myDashboard&action=loadVMConfigPopup&profileName='+profileName+'&blockId='+thisBlockId+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					if(jsonText!=null && jsonText!='')
					{
						var jsonData = Ext.decode(jsonText);
						thisWind.hide();
						mePopup.setWidgetPopupTitle(configTitle[mePopup.widgetType]+" "+addMetricsTitle);
						var compTypeCombo = vmConfigForm.findField('componentTypeCombo');

						var vmConfigDetails = jsonData['vmConfigDetails'];

						var selectedCompType = '';
						var selectedComp = '';
						var selectedTest = '';
						var selectedMeasure = '';
						var ddColumns = '';
						var myDashC = '';
						if(!Ext.isEmpty(vmConfigDetails))
						{
							 var gridData = vmConfigDetails['gridData'];
							 if (!Ext.isEmpty(gridData)) {

								var configTableGrid = Ext.getCmp('gconfigTableGrid');
								configTableGrid.suspendEvents(true);

								 var gridStore = configTableGrid.getStore();
								gridStore.add(gridData);
								configTableGrid.show();
								configTableGrid.resumeEvents();
								configTableGrid.doComponentLayout();
							 }
						}

						compTypeCombo.getStore().removeAll();
						compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
						var compTypeStore = compTypeCombo.getStore();
						compTypeStore.loadRawData(jsonData['comptypes']);
						compTypeStore.insert(0,{
							//displayField:jsonData['screenLabels']['reporter.common.Please choose a Component Type'],
							displayField:"Please choose a Component Type",
							valueField: '-1'
						});
						if(selectedCompType!=null && selectedCompType!='')
						{
							compTypeCombo.setValue(selectedCompType);
						}
						else
						{
							compTypeCombo.setValue('-1');
						}

						var compCombo = vmConfigForm.findField('componentCombo');
						compCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
						var compComboStore = compCombo.getStore();
						compComboStore.removeAll();
						compComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							compCombo.setValue('-1');

						var vmListLbl=Ext.getCmp('vmListLbl');
						vmListLbl.setText(jsonData['screenLabels']['monitor.common.Vm(s)']);
						var vmDesc = vmConfigForm.findField('vmListCombo');
						var vmDescComboStore = vmDesc.getStore();
						vmDescComboStore.removeAll();

						vmDescComboStore.insert(0,{
								displayField:notApplicable,
								valueField: '-1'
							});
							vmDesc.setValue('-1');
					}
				},
				failure : function()
				{

				}
			});
},

loadDefaultDataforServiceHealthWidget : function()
{
	 Ext.getCmp('doneButton').enable();
	 var mePopup = this;
	 	var gridContainerObj = Ext.getCmp('gridContainer');
	    var metricsFormPanelObj = this.getComponent('configForm');
        var metricsForm = metricsFormPanelObj.getForm();
		var editViewPage='dashboardLayoutObj';
        var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
        var thisWind = new Ext.LoadMask(this.getEl(), {
            msg: "Loading .."
        });
        thisWind.show();
        Ext.Ajax.request({
            url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
            method: 'POST',
            params: 'comesFrom=myDashboard&action=loadDataHealthConfigPopup&profileName=' + profileName + '&blockId=' + mePopup.widgetID  +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
                if (jsonText != null && jsonText != '') {
					thisWind.hide();
                    var jsonData = Ext.decode(jsonText);
					this.suspendEvents(true);
					Ext.suspendLayouts();
                    var configuredData = jsonData['configuredDetails'];
					var categoryType = '';
					var groupOption = '';

					mePopup.setWidgetPopupTitle(infrastructureHealthChartTitle+" "+addMetricsTitle);

					if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('categoryCombo') && configuredData.hasOwnProperty('selectedCategory')) 
					{
						var categoryOptsObj = metricsForm.findField('categoryOpts');
						categoryOptsObj.suspendEvents(true);
						categoryOptsObj.getStore().loadRawData(configuredData['categoryCombo']);
						categoryOptsObj.setValue(configuredData['selectedCategory']);
						categoryOptsObj.resumeEvents();
						categoryType = configuredData['selectedCategory'];
					}

					if(categoryType == 'Components')
					{	
						var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
						enableLegendOptObj.isDefault=true;
						enableLegendOptObj.show();	
						var showLegends = configuredData['showLegends'];
						if(showLegends!=null && showLegends=="yes")
						{
							enableLegendOptObj.setValue(true);
						}
						else
						{
							enableLegendOptObj.setValue(false);
						}
						enableLegendOptObj.isDefault=false;

						gridContainerObj.hide();
						var legandCheckBoxObj = metricsForm.findField('legandCheckBox');
						var showDescOptObj = metricsForm.findField('showDescOpt');
						showDescOptObj.suspendEvents(false);
						showDescOptObj.setValue(true);
						showDescOptObj.resumeEvents();
						legandCheckBoxObj.hide();
						if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('comptypes') && configuredData.hasOwnProperty('selectedCompType'))
						{
							var selectedCompType = configuredData['selectedCompType'];
							var healthCenterCompTypeComboObj = metricsForm.findField('healthCenterCompTypeCombo');
							healthCenterCompTypeComboObj.suspendEvents(true);	
							healthCenterCompTypeComboObj.getStore().loadRawData(jsonData['comptypes']);
							if(selectedCompType == null || selectedCompType == '' || selectedCompType == '-1')
							{
								var compTypeStore = healthCenterCompTypeComboObj.getStore();
								compTypeStore.insert(0,{
									displayField:compTypAlertMsg,
									valueField: '-1'
								});
								healthCenterCompTypeComboObj.setValue('-1');
							}
							else
							{
								var compTypeStore = healthCenterCompTypeComboObj.getStore();
								compTypeStore.insert(0,{
									displayField:compTypAlertMsg,
									valueField: '-1'
								});
								healthCenterCompTypeComboObj.setValue(selectedCompType);
							}
							healthCenterCompTypeComboObj.resumeEvents();
							healthCenterCompTypeComboObj.show();
						}

						if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('selectedComponents') && configuredData.hasOwnProperty('selectedCompType'))
						{
							var myDashC = myDashApp.getController("WidgetConfigurationController").loadComponentItems(categoryOptsObj,configuredData['selectedCompType'],configuredData['selectedComponents']);
						}
					}
					else if(categoryType == 'vms|desktop|users')
					{	
						var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
						enableLegendOptObj.hide();
						var legandCheckBoxObj = metricsForm.findField('legandCheckBox');
						legandCheckBoxObj.show();
						
						var showServersOptObj = metricsForm.findField('showServersOpt');
						showServersOptObj.suspendEvents(false);
						var showServers = configuredData['showServers'];
						if(showServers!=null && showServers=="yes")
						{
							showServersOptObj.setValue(true);
						}
						else
						{
							showServersOptObj.setValue(false);
						}
						showServersOptObj.resumeEvents();

						var showDescOptObj = metricsForm.findField('showDescOpt');
						showDescOptObj.suspendEvents(false);
						var showDescriptors = configuredData['showDescriptors'];
						if(showDescriptors!=null && showDescriptors=="yes")
						{
							showDescOptObj.setValue(true);
						}
						else
						{
							showDescOptObj.setValue(false);
						}
						showDescOptObj.resumeEvents();

						/*if(showServers!="yes" && showDescriptors!="yes")
						{
							showDescOptObj.suspendEvents(false);
							showDescOptObj.setValue(true);
							showDescOptObj.resumeEvents();
						}*/
						if(!Ext.isEmpty(jsonData) && jsonData.hasOwnProperty('comptypes') && configuredData.hasOwnProperty('selectedCompType'))
						{
							var selectedCompType = configuredData['selectedCompType'];
							var healthCenterCompTypeComboObj = metricsForm.findField('healthCenterCompTypeCombo');
							healthCenterCompTypeComboObj.suspendEvents(true);	
							healthCenterCompTypeComboObj.getStore().loadRawData(jsonData['comptypes']);
							if(selectedCompType == null || selectedCompType == '' || selectedCompType == '-1')
							{
								var compTypeStore = healthCenterCompTypeComboObj.getStore();
								compTypeStore.insert(0,{
									displayField:compTypAlertMsg,
									valueField: '-1'
								});
								healthCenterCompTypeComboObj.setValue('-1');
							}
							else
							{
								var compTypeStore = healthCenterCompTypeComboObj.getStore();
								compTypeStore.insert(0,{
									displayField:compTypAlertMsg,
									valueField: '-1'
								});
								healthCenterCompTypeComboObj.setValue(selectedCompType);
							}
							healthCenterCompTypeComboObj.resumeEvents();
							healthCenterCompTypeComboObj.show();

							if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('selectedComponents') && configuredData.hasOwnProperty('selectedCompType'))
							{

								healthCenterCompTypeComboObj.vmData = configuredData;
								var myDashC = myDashApp.getController("WidgetConfigurationController").loadComponentItems(categoryOptsObj,configuredData['selectedCompType'],configuredData['selectedComponents']);
							}

						}

						if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('selectedComponents') && configuredData.hasOwnProperty('selectedCompType'))
						{
							var myDashC = myDashApp.getController("WidgetConfigurationController").loadComponentItems(categoryOptsObj,configuredData['selectedCompType'],configuredData['selectedComponents']);
						}
					}
					else if(categoryType == 'Descriptors')
					{
						var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
						enableLegendOptObj.hide();
						gridContainerObj.show();
						var legandCheckBoxObj = metricsForm.findField('legandCheckBox');
						legandCheckBoxObj.show();

						var showServersOptObj = metricsForm.findField('showServersOpt');
						showServersOptObj.suspendEvents(false);
						var showServers = configuredData['showServers'];
						if(showServers!=null && showServers=="yes")
						{
							showServersOptObj.setValue(true);
						}
						else
						{
							showServersOptObj.setValue(false);
						}
						showServersOptObj.resumeEvents();

						var showDescOptObj = metricsForm.findField('showDescOpt');
						showDescOptObj.suspendEvents(false);
						var showDescriptors = configuredData['showDescriptors'];
						if(showDescriptors!=null && showDescriptors=="yes")
						{
							showDescOptObj.setValue(true);
						}
						else
						{
							showDescOptObj.setValue(false);
						}
						showDescOptObj.resumeEvents();

						/*if(showServers!="yes" && showDescriptors!="yes")
						{
							showDescOptObj.suspendEvents(false);
							showDescOptObj.setValue(true);
							showDescOptObj.resumeEvents();
						}*/
						
						var categoryOptsObj = metricsForm.findField('categoryOpts');
						var myDashC = myDashApp.getController("WidgetConfigurationController").changeCategoryOptionCombo(categoryOptsObj);
						
						if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('gridData') && !Ext.isEmpty(configuredData['gridData'])) 
						{

						 var configTableGrid = Ext.getCmp('configTableGrid');
							configTableGrid.suspendEvents(true);
							
                            var gridStore = configTableGrid.getStore();
                            gridStore.add(configuredData['gridData']);
                            configTableGrid.show();
							configTableGrid.resumeEvents();
	                        configTableGrid.doComponentLayout();
						}
						else
						{
							 var configTableGrid = Ext.getCmp('configTableGrid');
							configTableGrid.suspendEvents(true);
							
                            var gridStore = configTableGrid.getStore();
							gridStore.removeAll();
                            configTableGrid.show();
							configTableGrid.resumeEvents();
	                        configTableGrid.doComponentLayout();

						}
					}
					else if(categoryType == 'Zone' || categoryType == 'Segment' || categoryType == 'Service')
					{
						var enableLegendOptObj = metricsForm.findField('enableLegendOpt');
						enableLegendOptObj.isDefault=true;
						enableLegendOptObj.show();

						var showLegends = configuredData['showLegends'];
						if(showLegends!=null && showLegends=="yes")
						{
							enableLegendOptObj.setValue(true);
						}
						else
						{
							enableLegendOptObj.setValue(false);
						}
						
						enableLegendOptObj.isDefault=false;

						gridContainerObj.hide();
						var legandCheckBoxObj = metricsForm.findField('legandCheckBox');
						/*var showDescOptObj = metricsForm.findField('showDescOpt');
						showDescOptObj.setValue(true);
						showDescOptObj.resumeEvents();*/
						legandCheckBoxObj.hide();

						if(!Ext.isEmpty(configuredData) && configuredData.hasOwnProperty('selectedComponents'))
						{			
							var categoryOptsObj = metricsForm.findField('categoryOpts');
							var myDashC = myDashApp.getController("WidgetConfigurationController").loadGroupedItems(categoryOptsObj,configuredData['selectedComponents']);
						}
						else
						{
							var categoryOptsObj = metricsForm.findField('categoryOpts');
							var myDashC = myDashApp.getController("WidgetConfigurationController").loadGroupedItems(categoryOptsObj,'-1');
						}
					}
					this.resumeEvents();
					Ext.resumeLayouts(true);
                }
            },
            failure: function () {

            }
        });

},

loadSampleSnippet : function()
{
	return loadSampleSnippet(false);
},
loadSampleSnippet:function(reloadOnExternalDataSrcChange)
{
	var blockTypeName = this.widgetType;
	var widgetID=this.widgetID;
	var showPreview=true;
	if(reloadOnExternalDataSrcChange)
	{
		var useExternalDataObj=Ext.getCmp('useExternalData');
		if(!Ext.isEmpty(useExternalDataObj))
		{
			if(this.isExternalDataSourceWidget && useExternalDataObj.getValue()==false)
			{
					showPreview =false;
			}
			else if(!this.isExternalDataSourceWidget && useExternalDataObj.getValue()==true) 
			{
					showPreview =false;
			}
		}
	}
	if(showPreview && (this.action=='editWidget' && (blockTypeName!=null && (blockTypeName!='TopologyWidget' && blockTypeName!='vmAlarmsWidget'))))
	{
		//Ext.defer(function(){
		myDashApp.getController("WidgetConfigurationController").showWidgetPreviewAtPopupStartUp(widgetID,this.isExternalDataSourceWidget);
		//},100);
	}
	else
	{
		if(blockTypeName!=null && blockTypeName=='servicehealth')
		{
			blockTypeName='serviceHealth';
		}
		this.setDefaultWidgetPreviewImage(blockTypeName,widgetID);
	}
},
setDefaultWidgetPreviewImage : function(blockTypeName,widgetID)
{
	if(blockTypeName!=null && blockTypeName.indexOf("Widget")>0)
	 {
		blockTypeName=blockTypeName.substring(0,blockTypeName.indexOf("Widget"));
	 }
	Ext.getCmp(widgetID+"_previewImage").add({
		xtype : 'container',
		width:'100%',
		flex:1,
		layout:{
			type:'vbox',
			align:'stretch'
		},
		items:[
		{
			xtype:'imagecomponent',
			cls : 'samplePreviewImage',
			autoEl:'div',
			flex:1,
			src: '../images/'+strSkin+'/widget_sample_images/widget_'+blockTypeName+'.png'
		}
		],
		style:{"text-align": "center"}
		});
},
 onRender: function () {
	this.loadPopupData();
	this.callParent();
},
loadPopupData : function()
{
	return loadPopupData(false);
},
loadPopupData : function(reloadData)
{
	if(this.isExternalDataSourceWidget && !reloadData)
		return;

	if(reloadData)
	{
		this.loadSampleSnippet(reloadData);
	}
	if(this.widgetType!=null && this.widgetType=='TopologyWidget')
	{
		this.loadDefaultDataForTopologyWidgetPopup();
	}
	else if(this.widgetType!=null && this.widgetType=='vmAlarmsWidget')
	{
		this.loadDefaultDataforVMAlertsWidget();
	}
	else if(this.widgetType!=null && this.widgetType=='servicehealth')
	{
		this.loadDefaultDataforServiceHealthWidget();
	}
	else
	{
		this.loadDefaultDataforWidgetConfigurationWindow();
	}
},
createSettingsCtrls : function(settingsArrJson)
{
	var settingsCtrlsArr=[];
	if(!Ext.isEmpty(settingsArrJson))
	{
		var isHidden = false;

		if(!isHighchartForGauge && this.widgetType == 'dialChart')
		{
			isHidden=true;
		}
		for(var setObj in  settingsArrJson)
		{
			var settingOptObj=settingsArrJson[setObj];
			var item = this.createFilterItem(settingOptObj);
			if(!Ext.isEmpty(item)){
				settingsCtrlsArr.push(
					{
						xtype:'container',
						cls:'b-container',
						padding:0,
						defaults:{
							margin: '10 20 5 0 ',
							labelWidth:'auto',
							labelStyle: 'white-space: pre;'
						},
						items:item,
						hidden:isHidden
					}
				);
				/*settingsCtrlsArr.push({
										xtype:'tbseparator',
										height:1,
										ui:'vertical-seperator'
									});*/
			}
		}
	}
	return settingsCtrlsArr;
},
createFilterItem : function(filter){
		var item=null;
		switch(filter.ControlType){
			case "combo": item=this.createCombo(filter);
							break;
			case "Checkbox": item=this.createCheckBoxfield(filter);
							break;
			case "colorpalette": item=this.createColorPalette(filter);
							break;
			case "ColorPicker": item=this.createColorCombo(filter);
							break;
			case "Switch": item=this.createSwitchfield(filter);
							break;
			case "ImageIcon": item=this.createImageIconfield(filter);
							break;
			case "ToggleBtnSelector": item=this.createToggleBtnSelector(filter);
							break;
		}
		return item;
},
createToggleBtnSelector : function(filter)
{
	var mePopup=this;
var widgetID = this.widgetID;
	var isDisabled=false;
	var radioType='';
	var isHidden=false;

	if(filter.internalName!=null && filter.internalName == "SummaryGraphType")
	{
		radioType='icon';
		comboWidth=195;
		//filter.displayName = "Chart Type:";
		if(filter.selHistoricalView!=null && filter.selHistoricalView == "false")
		{
			isDisabled=true;
		}else{
			isDisabled=false;
		}
	}
	else if(filter.internalName!=null && filter.internalName == "ColorPicker")
	{
		radioType='color';
		if(!isHighchartForGauge && this.widgetType == 'dialChart')
		{
			isHidden=true;
		}
	}
	return {
			xtype : 'groupselection',
			id:filter.internalName,
			fieldLabel:filter.displayName,
			name:filter.internalName,
			widgetID : widgetID,
			radioType : radioType,
			hidden:isHidden,
			//margin:'8 0 5 0',
			labelAlign:'left',
			//labelWidth:80,
			//width : 195,
			disabled : isDisabled,
			items : filter['filOptions'],
			listeners : {
				'change' : function(switchFldObj)
				{
					if(myDashApp.getController("WidgetConfigurationController").validateWidgetConfiguration(switchFldObj.widgetID)==false)
					{
						return false;
					}
					else
					{
						Ext.getCmp('doneButton').enable();
						myDashApp.getController("WidgetConfigurationController").showWidgetPreview(switchFldObj.widgetID);
					}
				}
			}
	};
},
createColorPalette : function(filter)
{
	var mePopup=this;

	var colorPaletteStore = Ext.create('Ext.data.Store',{
			fields:['displayColor','displayField','valueField'],
			/*proxy:{
				type: 'memory',
				reader: {
					type: 'json',
					root:'filOptions'
				}
			},*/
			data:filter['filOptions']
		});
			var widgetID = this.widgetID;
	return {
				xtype:'combo',
				editable : false,
				flex:1,
				store:new Ext.data.Store({
									fields: ['displayField', 'valueField','displayColor'],
									data: [] }),
				cls: 'dropdown colorPalette',
				displayField:'displayField',
				valueField:'valueField',
				displayColor: 'displayColor',
				//trigerAction:'all',
				labelAlign:'left',
				//labelWidth:80,
				labelSeparator:'',
				margin :  '10 20 10 0',
				typeAhead: false,
				fieldLabel:screenLabelsObj['ColorPalette'],
				//value:filter.selectedValue,
				//itemId:filter.internalName,
				queryMode:'local',
				id:filter.internalName,
				name:filter.internalName,
				widgetID : widgetID,
				//value : filter.selectedValue,
				displayTpl: Ext.create('Ext.XTemplate', [
							'<tpl for=".">',
								'<div>',
									'<tpl for="displayColor">',
										'<tpl for="colorCode">',
											'<span style="padding:4px 4px;background:{value};margin:3px 1px 0px 0px;border:1px solid #2c2c2c;"></span>',
										'</tpl>',
									'</tpl>',
								//	'<span style="margin-left:10px;padding:0px">{displayField}</span>',
									'<input type="text" id="PaletteId" style="display:none" value={valueField} />',
								'</div>',
							'</tpl>'
					]),
				listConfig: {
							// Custom rendering template for each item
							cls:'colorpalette-view',
							itemTpl:new Ext.XTemplate(
								'<tpl for=".">',
									'<tpl for="displayColor">',
										'<tpl for="colorCode">',
											'<span style="padding:4px 4px;background:{value};margin:2px 1px 2px 0px;float:left;border:1px solid #2c2c2c"></span>',
										'</tpl>',
									'</tpl>',
									'<div style="clear:both"></div>',
								'</tpl>'
							)

								
						},
				fieldSubTpl: [
							'<div class="{hiddenDataCls}" role="presentation"></div>',
								'<ul><li id="{id}" type="{type}" ',
									'<tpl if="size">size="{size}" </tpl>',
									'<tpl if="tabIdx">tabIndex="{tabIdx}" </tpl>',
									'<div class="{fieldCls} {typeCls}" autocomplete="off"></div>',
									'<div class="{clearCls}" role="presentation"></div>',
								'</li></ul>',
							{
								compiled: true,
								disableFormats: true
							}
						],
						setRawValue: function(value) {
							var me = this;
							value = Ext.value(value, '');
							me.rawValue = value;
							if (me.inputEl) {
								me.inputEl.dom.innerHTML = value;
							}
							return value;
						},
						listeners : 
						{
							'afterrender' : function(cmbObj)
							{
								cmbObj.getStore().loadRawData(filter['filOptions']);
								cmbObj.setValue(filter.selectedValue);
								cmbObj.setEditable(false);
							},
							'beforeselect' : function(cmbObj)
							{
								myDashApp.getController("WidgetConfigurationController").validateWidgetConfiguration(cmbObj.widgetID);
							},
							'select' : function(cmbObj)
							{
								 Ext.getCmp('doneButton').enable();
								myDashApp.getController("WidgetConfigurationController").showWidgetPreview(cmbObj.widgetID);
							}
						}
			};
},
createImageIconfield : function(filter)
{
	var mePopupWindow=this;
	var imgIconVal = '';
	var imgHtml = '';
	var isDisabled=false;
	
	if((filter.showIconStatus!=null && filter.showIconStatus == 'no'))
	{
		isDisabled=true;
	}			
	if(filter.enableImg!=null && filter.enableImg == 'false')
	{
		isDisabled=true;
	}			
	if(filter.selectedImg!=null)
	{
		imgIconVal=filter.selectedImg;
	}
	
	if(imgIconVal!=null && imgIconVal!="")
	{
		if(imgIconVal.indexOf(":")>0 && imgIconVal.startsWith("Default"))
		{
			imgIconVal = imgIconVal.substring(imgIconVal.indexOf(":")+1);
							
			if(imgIconVal.indexOf('_')>-1)
			{
				imgIconVal = imgIconVal.substring(0,imgIconVal.lastIndexOf('_')+1)+'32';
			}
			imgHtml= '<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><div id="digitalChartImgIcon"  class= "'+imgIconVal+'" width="32px" height="32px" border="0px"/><div class="settingOver"></div></div>';
		}
		else
		{			
			imgIconVal = '/final/images/icon-library/'+loginUser+'/'+imgIconVal;				
			imgHtml='<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="digitalChartImgIcon"  src="'+imgIconVal+'" width="100%" height="100%" border="0px"/><div class="settingOver"></div></div>';				
		}
	}
	else
	{
//alert(imgIconVal);
		imgIconVal = '/final/images/'+strSkin+'/listViewWidgetDefaultSmall.png';
		imgHtml='<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="digitalChartImgIcon"  src= "'+imgIconVal+'" width="32px" height="32px" border="0px"/><div id="settingOver" class="settingOver"></div></div>';
	}

	//var templateIcon = '/final/images/'+strSkin+'/listViewWidgetDefault.png';
	var ImgIconVal ={
		xtype: 'container',
		id : filter.internalName,
		name : filter.internalName,
		//margin:'0 10 15',
		width:42,
		height:42,
		disabled : isDisabled,
		//html:imgHtml,
		listeners:{
			afterrender:function(cmp){
				//this.setImageTriggerEvents(cmp);
			}
		},
		setImageTriggerEvents : function(cmp)
		{
			Ext.get(cmp.el).select('.userDefinedImgDefault').on('mouseenter',function(){
				var isIconEnabled=Ext.getCmp('ShowIcon').getValue();
				if(isIconEnabled!=null && isIconEnabled==true)
				{
					Ext.get(cmp.el).select('.settingOver').update('<div class="userDefinedImgDefaultOver" style="display:block;padding:5px;"><table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><a href="javascript:void(0)" id="customChangeImg"><span style="width:20px;height:20px;display:inline-block" class="iconOneClickImgDefaultChange"></span><br/></a></td></tr></table></div>');
					Ext.get(cmp.el).select('#customChangeImg').on('click',function(){
							var imgUploadWindow = Ext.create('MyDashBoard.view.IconLibrary',{
							from:'digitialChartWidget',
							windowId:'windowId',
							custUploadPath:'manager/tomcat/webapps/final/images/icon-library/'+loginUser+'/',
							profileName:'',
							widgetID:mePopupWindow.widgetID,
							widgetType:mePopupWindow.widgetType
						}).show();
					imgUploadWindow.on('close', function() {
					imgUploadWindow.destroy();
					imgUploadWindow = 'closed';
					});
						},Ext.get('customChangeImg'));
				}
				});
				Ext.get(cmp.el).select('.settingOver').on('mouseleave',function(){
					Ext.get(cmp.el).select('.settingOver').update('');
				});
		}
	}
var ourterImgCon = 	{
			xtype: 'container',
			margin:'10 20 10 0',
			layout:{
				type:'column'
			},
			items:[
			{
				xtype:'label',
				cls:'x-form-item-label',
				margin:'12 10 0 0',
				text:screenLabelsObj['ChooseIconLbl']
			},
			ImgIconVal
			]
	}
	return ourterImgCon;

},
createSwitchfield : function(filter)
{
	var marginValue='10 0 0 10';
	var widthValue=400;
	var isEnabled = false;
	var isDisabled = false;
	var isHidden = false;
	var widgetID=this.widgetID;
	if(filter.displayName!=null && filter.displayName == 'ChartSummaryEnabled')
	{
		filter.displayName = 'Enable History View';
	}
	else if(filter.displayName!=null && filter.displayName == 'UseStateColorForFonts')
	{
		filter.displayName = 'Apply State Color For Font';
	}
	else if(filter.displayName!=null && filter.displayName == 'UseStateColorForBackground')
	{
		filter.displayName = 'Apply State Color For Background';
	}
	else if(filter.displayName!=null && filter.displayName == 'enableChartSummary')
	{
		filter.displayName = 'Enable History View';
	}
/*	if(filter.displayName!=null && filter.displayName == 'ResizeFont')
	{
		filter.displayName = 'Resize Font';
	}*/
	else if(filter.displayName!=null && (filter.displayName == 'ShowGaugeCircle' || filter.displayName == 'Enable Full Dial'))
	{
		filter.displayName = 'Enable Full Dial';
		if(!isHighchartForGauge)
		{
			isHidden=true;
		}
	}
	else if(filter.displayName!=null && (filter.displayName == 'UseStateColorForGauge' || filter.displayName == 'Apply State Color For Gauge'))
	{
		filter.displayName = 'Apply State Color For Gauge';
		if(!isHighchartForGauge)
		{
			isHidden=true;
		}
	}
	else if(filter.displayName!=null && filter.displayName == 'ShowIcon')
	{
		filter.displayName = 'Show Icon';
		if(filter.HistoricalSelValue!=null && filter.HistoricalSelValue == 'false')
		{
			 isDisabled=true;
		}			
	}
	else if(filter.displayName!=null && filter.displayName =='showChartSummary')
	{
			widthValue=220;
		marginValue='10 10 5 10';
	}
	else if(filter.displayName!=null && filter.displayName == 'EnableMeasureStateColor')
	{
		//filter.displayName = 'Apply Measure State Color';
		filter.displayName = 'Apply State Color';
		widthValue=220;
		marginValue='10 0 5 0';
	}
	if(filter.selectedValue!=null && filter.selectedValue == 'yes')
	{
		 isEnabled = true;
	}
	var SwitchfieldVal = {
			xtype : 'switchfield',
			disabled : isDisabled,
			name: filter.internalName,
			id: filter.internalName,
			fieldLabel:filter.displayName,
			inputValue: 'Yes',
			uncheckedValue:'No',
			labelSeparator :"",
			flex:1,
			hidden:isHidden,
		//	margin:'10 0 0 10',
			//margin : marginValue,
			//width :400,
			//width :widthValue,
			labelAlign : 'left',
			//labelWidth:120,
			vertical: false,
			checked:filter.checked,
			widgetID : widgetID,
			listeners : {
				'change' : function(switchFldObj)
				{
					if(myDashApp.getController("WidgetConfigurationController").validateWidgetConfiguration(switchFldObj.widgetID)==false)
					{
						return false;
					}
					else
					{
						if(switchFldObj.id=='UseStateColorForGauge')
						{
							if(switchFldObj.getValue()==true)
							{
								var colPickObj=Ext.getCmp('ColorPicker');
								colPickObj.hide();
								colPickObj.up('container').hide();
							}
							else
							{
								var colPickObj=Ext.getCmp('ColorPicker');
								colPickObj.show();								
								colPickObj.up('container').show();
							}
						}
						else if(switchFldObj.id=='Stacked')
						{
							myDashApp.getController("WidgetConfigurationController").showStackedChart(switchFldObj);
						}
						else if(switchFldObj.id=='ShowValues')
						{
							var enableChartSummaryObj = Ext.getCmp('enableChartSummary');
							var SummaryGraphTypeObj = Ext.getCmp('SummaryGraphType');
							var stateColorOnValue=Ext.getCmp('SetStateColorOn').getValue();
							if(switchFldObj.getValue()==true)
							{
								if(!Ext.isEmpty(enableChartSummaryObj) && !Ext.isEmpty(SummaryGraphTypeObj))
								{
									if(stateColorOnValue=='none')
									{
										enableChartSummaryObj.setDisabled(false);
										SummaryGraphTypeObj.setDisabled(false);
									}
								}
							}
							else
							{
								if(!Ext.isEmpty(enableChartSummaryObj) && !Ext.isEmpty(SummaryGraphTypeObj))
								{
									enableChartSummaryObj.setDisabled(true);
									SummaryGraphTypeObj.setDisabled(true);
								}
							}
						}
						Ext.getCmp('doneButton').enable();
						myDashApp.getController("WidgetConfigurationController").showWidgetPreview(switchFldObj.widgetID);
					}
				}
			}
	};
return SwitchfieldVal;
},
createColorCombo : function(filter)
{
	var widgetID=this.widgetID;
	if(filter.selectedValue!=null && filter.selectedValue == 'default')
	{
		filter.selectedValue = filter.filOptions[0].valueField;
	}
	if(filter.displayName!=null && filter.displayName == "ColorPalette")
	{
		filter.displayName="Color Picker";
	}
	var colorComboStore = Ext.create('Ext.data.Store',{
			fields:['displayColor','displayField','valueField'],
			proxy:{
				type: 'memory',
				reader: {
					type: 'json',
					root:'filOptions'
				}
			},
			data:filter
		});
	var colorCombo = {
					xtype:'combo',
					editable : false,
					//width:180,
					flex:1,
					store:colorComboStore,
					cls: 'dropdown colorPalette',
					displayField:'displayField',
					valueField:'valueField',
					displayColor: 'displayColor',
					trigerAction:'all',
					labelAlign:'left',
					labelSeparator:'',
					//margin : '10 10 10 10',
					typeAhead: false,
					fieldLabel:filter.displayName,
					//value:filter.selectedValue,
					//itemId:filter.internalName,
					queryMode:'local',
					id:'colorPlt',
					name:'colorPlt',
					widgetID : widgetID,
					listeners:
						{
							afterrender: function()
							{
								this.setValue(filter.selectedValue);
							},
							'beforeselect' : function(cmbObj)
							{
								myDashApp.getController("WidgetConfigurationController").validateWidgetConfiguration(cmbObj.widgetID);
							},
							'select' : function(cmbObj)
							{
									Ext.getCmp('doneButton').enable();
									myDashApp.getController("WidgetConfigurationController").showWidgetPreview(cmbObj.widgetID);
							}
						},
					displayTpl: Ext.create('Ext.XTemplate', [
									'<tpl for=".">',
										'<div>',
											'<tpl for="displayColor">',
												'<tpl for="colorCode">',
													'<span style="padding:4px 4px;background:{value};margin:3px 1px 0px 0px;border:1px solid #2c2c2c;"></span>',
												'</tpl>',
											'</tpl>',
											//'<span style="margin-left:10px;padding:0px">{displayField}</span>',
											'<input type="text" id="palleteID" style="display:none" value={valueField} />',
										'</div>',
									'</tpl>'
							]),
						listConfig: {
									// Custom rendering template for each item
									itemTpl:new Ext.XTemplate(
										'<tpl for=".">',
											'<tpl for="displayColor">',
												'<tpl for="colorCode">',
													'<span style="padding:4px 4px;background:{value};margin:3px 1px 0px 0px;float:left;border:1px solid #2c2c2c"></span>',
												'</tpl>',
											'</tpl>',
											//'<span style="margin-left:10px;padding:0px;display:none">{displayField}</span>',
										'</tpl>'
									)
								},
						fieldSubTpl: [
									'<div class="{hiddenDataCls}" role="presentation"></div>',
										'<ul><li id="{id}" type="{type}" ',
											'<tpl if="size">size="{size}" </tpl>',
											'<tpl if="tabIdx">tabIndex="{tabIdx}" </tpl>',
											'<div class="{fieldCls} {typeCls}" autocomplete="off"></div>',
											'<div class="{clearCls}" role="presentation"></div>',
										'</li></ul>',
									{
										compiled: true,
										disableFormats: true
									}
								],
						setRawValue: function(value) {
									var me = this;
									value = Ext.value(value, '');
									me.rawValue = value;
									if (me.inputEl) {
										me.inputEl.dom.innerHTML = value;
									}
									return value;
								}
				}
	return colorCombo;
},
createCheckBoxfield : function(filter)
{
	var widgetID=this.widgetID;
	/*if(filoptions == 'default')
	{
		var labelAlign = 'left';
	}
	else
	{
		labelAlign = 'top';
	}
	var filoptions = filter.filOptions;
	var selectedOption = filter.selectedValue;
	selectedOption = selectedOption.split('$');
	var tmpNames = filoptions.split(',');
	var itemArray =new Array();
	for(var i=0; i<tmpNames.length;i++)
	{
		var isChecked = false;
		if(selectedOption.indexOf(tmpNames[i]) > -1)
		{
			isChecked = true;
		}
		var boxlable = tmpNames[i];
		var tmpId = tmpNames[i]+'Opt';
		if(tmpNames[i] == 'default')
		{
			boxlable = '';
			tmpId = filter.displayName+'Opt';
		}
		var itemtmp = { boxLabel: boxlable,
						name: tmpId,
						id:tmpId,
						inputValue: 'yes',
						checked : isChecked,
						margin : '0 5 0 0',
						columnWidth:100,
						};
			itemArray.push(itemtmp);
	}
	if(filter.displayName!=null && filter.displayName == 'showChartSummary')
	{
		filter.displayName = 'Show Summary';
	}*/
	var checkBoxGrpfield = {
			xtype: 'checkboxgroup',
			//columns: tmpNames.length,
			columns:3,
			vertical: true,
			//labelAlign:'left',
			//labelWidth : 60,
			labelSeparator:'',
			margin: '5 15 0 0',
			//bodyPadding: 0,
			padding:0,
			border:0,
			name: filter.internalName,
			id: filter.internalName,
			width:280,
			//flex:1,
			labelAlign:"top",
			fieldLabel:filter.displayName,
			defaults:{
				allowBlank:false,
				labelSeparator:'',
				cls:'checkbt'
			},
			items:filter.filOptions,
			widgetID : widgetID,
			listeners : {
				'change' : function(chkBoxObj)
				{
					if(myDashApp.getController("WidgetConfigurationController").validateWidgetConfiguration(chkBoxObj.widgetID)==false)
					{
						return false;
					}
					else
					{
						Ext.getCmp('doneButton').enable();
						myDashApp.getController("WidgetConfigurationController").showWidgetPreview(chkBoxObj.widgetID);
					}
				}
			}
	};
return checkBoxGrpfield;
},
createCombo : function(filter)
{
	var widgetID=this.widgetID;
	var marginValue= '10 10 10 10';
	var isHidden=false;
	var comboWidth = 195,	lblWidth = 100;
	if(filter.selectedValue!=null && filter.selectedValue == 'default')
	{
		filter.selectedValue = filter.filOptions[0].value;
	}
	var comboStore = Ext.create('Ext.data.Store',{
			fields:['displayField','valueField'],
			proxy:{
				type: 'memory',
				reader: {
					type: 'json',
					root:'optsArr'
				}
			},
			data:filter['filOptions']
		});
	/* CODE FOR CHECKING GRAPH OF WIDGET CHANGE */
	if(filter.internalName!=null && filter.internalName == "GraphicalType")
	{
		comboWidth=195;
		isTopNWidget = true;
		topNVal =filter.selectedValue;
	}
	/* END OF CHECKING GRAPH OF WIDGET CHANGE */
	var isDisabled=false;
	if(filter.internalName!=null && filter.internalName == "SummaryGraphType")
	{
		comboWidth=195;
		lblWidth = 100;
		//filter.displayName = "Chart Type:";
		if(filter.selHistoricalView!=null && filter.selHistoricalView == "false")
		{
			isDisabled=true;
		}else{
			isDisabled=false;
		}
	}
	else if(filter.internalName!=null && (filter.internalName == "chartType" || filter.internalName == "Statistics"))
	{
		comboWidth=160;
		lblWidth = 80;
		//filter.displayName = "Chart Type";
	}
	else if(filter.internalName!=null && filter.internalName == "Aggregation_Function")
	{
		//filter.displayName="Aggregation Function";
		comboWidth=150;
	}
	else if(filter.internalName!=null && filter.internalName == "SetStateColorOn")
	{
		//filter.displayName="Apply State Color On";
		//filter.displayName="Apply State Color";
		comboWidth=195;
		marginValue=  '10 0 10 0';
		if(filter.ShowSetColorASValue!=null && filter.ShowSetColorASValue == "false")
		{
			isHidden=true;
			isDisabled=true;
		}else{
			isHidden=false;
			isDisabled=false;
		}
	}		
	else if(filter.internalName!=null && filter.internalName == "ViewType")
	{
		comboWidth=160;
		lblWidth = 70;
	}
	var combObj ={
			xtype:'scrollcombo',
				//flex:1,
				editable : false,
				//disabled : isDisabled,
				store:comboStore,
				
				cls : 'dropdown',
				displayField:'displayField',
				valueField:'valueField',
				trigerAction:'all',
				fieldLabel:filter.displayName,
				value:filter.selectedValue,
				itemId:filter.internalName,
				labelAlign:'left',
				//labelWidth: lblWidth,
	           // labelWidth:'auto',
				width:comboWidth,
				//labelStyle: 'white-space: pre;',
				width:comboWidth,
				labelWidth:lblWidth,
				labelSeparator:'',
				margin :  '10 20 10 0',
				queryMode:'local',
				id:filter.internalName,
				name:filter.internalName,
				disabled : isDisabled,
				hidden : isHidden,
				widgetID : widgetID,
				listeners:
				{
					'beforeselect' : function(cmbObj)
					{
						myDashApp.getController("WidgetConfigurationController").validateWidgetConfiguration(cmbObj.widgetID);
					},
					'select' : function(cmbObj)
					{
						Ext.getCmp('doneButton').enable();
						myDashApp.getController("WidgetConfigurationController").showWidgetPreview(cmbObj.widgetID);

						if(cmbObj.id=='SetStateColorOn')
						{
							var enableChartSummaryObj = Ext.getCmp('enableChartSummary');
							var SummaryGraphTypeObj = Ext.getCmp('SummaryGraphType');
							var stateColorOnValue=cmbObj.getValue();
							var showValuesOpt=Ext.getCmp('ShowValues').getValue();
							
							if(stateColorOnValue=='none')
							{
								if(!Ext.isEmpty(enableChartSummaryObj) && !Ext.isEmpty(SummaryGraphTypeObj))
								{
									if(showValuesOpt==true)
									{
										enableChartSummaryObj.setDisabled(false);
										SummaryGraphTypeObj.setDisabled(false);
									}
								}
							}
							else
							{
								if(!Ext.isEmpty(enableChartSummaryObj) && !Ext.isEmpty(SummaryGraphTypeObj))
								{
									enableChartSummaryObj.setDisabled(true);
									SummaryGraphTypeObj.setDisabled(true);
								}
							}
						}
					}
				}
	}
	return combObj;
},
createConfigurationWindowLayout : function()
{
	return createConfigurationWindowLayout(false);
},
createConfigurationWindowLayout : function(reCreateLayout)
{
	var meWidgetConfigObj=this;
	var widgetType = '';
	var meItemsArr=[];
	var thisWidgetID = this.widgetID;
	var isCombinationChart=true;
	if (thisWidgetID != null)
	{
		widgetType = thisWidgetID.substr(0, thisWidgetID.indexOf("_"));
	}
	var widgetCtrlsArr=[];
	if(widgetType!=null && (widgetType == 'CombinedTimelineChart' || widgetType == 'TimelineChart' || widgetType == 'combinationChart' || widgetType == 'BarChart' || widgetType == 'table' || widgetType=='areaChart' || widgetType == 'TrendGraph' || widgetType == 'pieChart' || widgetType == 'activityChart' || widgetType == 'heatMapChart' || widgetType == 'health'))
	{
		meWidgetConfigObj.showConfigurationTab=true;
	}

	var miscPanelCtrlsArr=[];
	var miscBottomPanlObj={};

	if(meWidgetConfigObj.showConfigurationTab)
	{
			
		var isAggregationDisabled = true;
		var isCombinationChart = true;
		if (this.widgetType != null && (this.widgetType == 'table' || this.widgetType == 'BarChart' || this.widgetType == 'pieChart' || this.widgetType == 'activityChart')) {
		    isAggregationDisabled = false;
        }
		else if (this.widgetType != null && widgetType=='combinationChart')
		{
			isCombinationChart=false;
		}

		var ctrlsOptsMap={};
		meWidgetConfigObj.configOptsMap={};
		meWidgetConfigObj.configOptsMap['test']={id : 'test',ctrlType : 'dropdown',Label  : 'Test',emptyText : 'Select a Test'};
		meWidgetConfigObj.configOptsMap['measure']={id : 'measure',ctrlType : 'multiselect',Label  : screenLabelsObj['Measures'],searchText : screenLabelsObj['SearchMeasures']};
		meWidgetConfigObj.configOptsMap['componentType']={id : 'componentType',ctrlType : 'dropdown',Label  : 'Component Type',emptyText : 'Select a Component Type'};
		if(widgetType!=null && (widgetType=='pieChart' || widgetType=='activityChart' || widgetType=='health'))
		{
			meWidgetConfigObj.configOptsMap['component']={id : 'component',ctrlType : 'dropdown',Label  : 'Component',emptyText : 'Please select a Component'};
		}
		else
		{
			meWidgetConfigObj.configOptsMap['component']={id : 'component',ctrlType : 'multiselect',Label  : 'Component',searchText : screenLabelsObj['SearchComponents']};
		}		
		meWidgetConfigObj.configOptsMap['descriptor']={id : 'descriptor',ctrlType : 'multiselect',Label  : 'Descriptor',searchText : screenLabelsObj['SearchDescriptors']};
		if(widgetType!=null && widgetType=='health')
		{
			meWidgetConfigObj.configOptsMap['descriptor']['ctrlType']='dropdown';
			meWidgetConfigObj.configOptsMap['descriptor']['emptyText']='Please select a descriptor';
		}

		var configTabItemsArr=[];

		var isTimelineOptionToBeShown=false;
		if(widgetType == 'CombinedTimelineChart' || widgetType == 'TimelineChart' || widgetType == 'combinationChart' || widgetType=='areaChart' || widgetType == 'TrendGraph') {
			isTimelineOptionToBeShown=true;
		}
		var showYmax=false;
		if (widgetType != null && (widgetType == 'areaChart' || widgetType == 'TimelineChart')) {
			showYmax=true;
		 }
		 var showCompAutoAssociatioOption=false;
		if(widgetType == 'BarChart' || widgetType == 'table' || widgetType == 'TimelineChart' || widgetType == 'areaChart' || widgetType == 'TrendGraph' || widgetType == 'CombinedTimelineChart' || widgetType == 'combinationChart' || widgetType == 'TopNAnalysis') {
			showCompAutoAssociatioOption=true;
		}
		var aggCtrlOptions=[];
		var addAggOptions=false;
		if(widgetType == 'BarChart' || widgetType == 'table' || widgetType == 'pieChart' || widgetType == 'activityChart' || widgetType == 'heatMapChart')
		{
			var isEnabled=false;
			aggCtrlOptions.push( {
						xtype : 'switchfield',
						//disabled : isDisabled,
						name: 'showAggOpt',
						id: 'showAggOpt',
						fieldLabel:'Aggregate Descriptors',
						inputValue: 'Yes',
						labelSeparator:'',
						uncheckedValue:'No',
						margin:'10 0 5 0',
						//margin : marginValue,
						//width :400,
						width :130,
						labelAlign : 'top',
						labelWidth:80,
						vertical: false,
						checked:isEnabled
				});

				aggCtrlOptions.push({
                                xtype: 'scrollcombo',
                                cls: 'dropdown',
                                fieldLabel: 'Aggregate Function',
                                id: 'aggOptions',
                                name: 'aggOptions',
								labelAlign: 'top',
								labelSeparator:'',
                                //labelWidth: 140,
                                hidden: true,
                                width:120,
								margin: '10 0 0 5',
                                store: Ext.create('Ext.data.Store', {
                                    fields: ['displayField', 'valueField'],
                                    data: []
                                }),
                                editable: false,
                                displayField: 'displayField',
                                valueField: 'valueField',
                                queryMode: 'local'
                 });

			/*configTabItemsArr.push({
					xtype: 'container',
					layout: 'hbox',
					width: '80%',
					defaults: {
					labelAlign: 'top',					
					},				
					margin:'10 0 0 0',
					padding:'10 5 5 5',
					items: aggCtrlOptions
				});*/
			addAggOptions=true;
		}
		
		if(isTimelineOptionToBeShown)
		{
			var timelineXTypeObj=[];
			if(showYmax)
			{
				timelineXTypeObj.push({
					
						xtype: 'textfield',
						id : 'yMax',
						name: 'name',
						fieldLabel: 'Y Axis Maximum Limit',
						labelSeparator:'',
						cls:'textbox',
						width : 150,
						labelWidth: 55,
						emptyText:'',
						labelPad : 0,
						margin:'5 15 0 0',
						allowBlank: true,  // requires a non-empty value
						layout: 'hbox'
				
				});
			}
			timelineXTypeObj.push({
				xtype: 'mydashboardtimeline',
//				cls:'timeline_center',				
				id: 'timelineMyObj',					
				name: 'timelineMyObj',
				//margin:'0 0 0 10',
				margin:'0 0 0 0',
				flex : 1,
			//	hidden: true,					
				addDurationCombo : widgetType!=null && (widgetType =="TrendGraph")? true :false,
				gtype : widgetType!=null && (widgetType =="TrendGraph")? 'trend' :'',
				hideMinutes : false,
				layout: 'hbox'

			});
			
			configTabItemsArr.push({
					xtype: 'container',
					layout: 'hbox',
					width: '90%',
					//cls: 'timeline_box',
					//id: 'timeline_box',
					//hidden: true,
					//flex : 1,
					defaults: {
					labelAlign: 'top',					
					},				
					margin:'0 0 0 0',
					padding:'0 0 0 0',
					items: timelineXTypeObj
				});
		}
		var columnCtrsMap = [];
		if(widgetType == 'health')
		{
			columnCtrsMap=[{ 'columns' : ['componentType','measure']} , { 'columns' : ['component','descriptor'] } , {'columns' : ['test'] }];
		}
		else
		{
			columnCtrsMap=[{ 'columns' : ['test','measure']} , { 'columns' : ['componentType','component'] } , {'columns' : ['descriptor'] }];
		}
		var ctrlArr = [];
		for(var colmn in columnCtrsMap)
		{
			var columnObj = columnCtrsMap[colmn];
			var colsArr=columnObj['columns'];
			var topMargin=10;
			var colCtrlArr=[];
			if(colsArr.length==1)
			{
				if(addAggOptions)
				{
					colCtrlArr.push({
					xtype: 'container',
					layout: 'hbox',
					width: '90%',
					defaults: {
					labelAlign: 'top',					
					},				
					margin:'0 0 3 0',
					padding:'0 0 0 0',
					items: aggCtrlOptions
				});
					topMargin=10;
				}
				else
				{
					topMargin=60;
				}
				
			}
				for(var cl in colsArr)
				{
					var colName=colsArr[cl];
					var configForCol=meWidgetConfigObj.configOptsMap[colName];
					if(configForCol['ctrlType']=='multiselect')
					{
						var innerContArr=[];
						innerContArr.push({
									xtype: 'label',
									id: configForCol.id+'ComboLbl',
									name: configForCol.id+'ComboLbl',
									//width: 60,
									margin:'0px 0px 0px 0px',
									text:configForCol.Label,
									labelClsExtra: 'icon-properties item-label-icon',
								});
							
								innerContArr.push({
									xtype:'button',
									cls:'iconButtonClass iconMultiselectExpand',
									margin:'0 0 8 8',
									style: {'border':'none' },
									id: configForCol.id+"ExpandSelector",									
									name: configForCol.id+"ExpandSelector",									
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: configForCol.Label
											});
										}
									},
								});
							
								var hideMultiSelect=false;
								if(showCompAutoAssociatioOption && meWidgetConfigObj.autoAssociateComponents && ((colName!=null && colName=='component') || (colName!=null && colName=='descriptor')))
								{
									hideMultiSelect=true;
									colCtrlArr.push({
										xtype: 'container',
										layout:{type:'vbox',align:'stretch'},
										width: 280,
										margin:topMargin+'px 0px 0px 0px',
										items : [{
													xtype :'label',
													margin:'0px 0px 0px 0px',
													id : colName+'LblObj',
													cls:'x-form-item-label',
													text : colName
												},
												{
													xtype :'label',
													margin:'0px 0px 0px 0px',
													cls:'x-form-item-label',
													id : 'all'+colName+'LblObj',
													text : 'All '+colName+'s'
												}]
									});
								}
						colCtrlArr.push({
								xtype: 'container',
								layout:{type:'hbox',align:'stretch'},
								width: 280,
								margin:topMargin+'px 0px 0px 0px',
								//height:145,
								hidden : hideMultiSelect,
								id:configForCol.id+'_OuterContainer',
								defaults: {
									labelAlign: 'top',
									labelSeparator:'',
									align:'top',
								},
								items : innerContArr
							});
						colCtrlArr.push(meWidgetConfigObj.createMultiSelectbox(configForCol.id,configForCol.searchText));
					}
					else
					{
						colCtrlArr.push(meWidgetConfigObj.createSingleSelectBox(configForCol.id,configForCol.Label,configForCol.emptyText));
					}
				}
				ctrlArr.push({
								xtype: 'panel',
								flex:1,
								layout : {
									type : 'vbox'
								},
								//width: 280,
								//height: 100,
								cls: '',
								id: '',
								defaults: {
									labelAlign: 'top',
									labelSeparator:''
								},
								items : colCtrlArr
				
				});
		/*	}
			else
			{
				var colName=colsArr[0];
				var configForCol=configOptsMap[colName];
				console.log("ctrl Config object 1111",configForCol['ctrlType']);
				if(configForCol['ctrlType']=='multiselect')
				{
					ctrlArr.push(meWidgetConfigObj.createMultiSelectbox(configForCol.id,configForCol.Label,configForCol.Label,configForCol.searchText));
				}
				else
				{
					ctrlArr.push(meWidgetConfigObj.createSingleSelectBox(configForCol.id,configForCol.Label,configForCol.emptyText));
				}
			}*/
		}

		 configTabItemsArr.push({
									xtype: 'container',
									layout : {
										type : 'hbox',
										align:'stretch',
										pack:'center'
									},
									//style:{'border':'yellow 1px solid'},
									width: '100%',
									//height: 300,
									cls:'editWidgetWindowInner',
									//hidden: true,
									items: ctrlArr			
				});


			
	//	var column1CtrlsArr=[];
	//	column1CtrlsArr.push(createSingleSelectBox('testCombo','Test','Select a Test'));
	//	column1CtrlsArr.push(createMultiSelectbox('measureCombo','Measures','Measures',screenLabelsObj['SearchMeasures']));
		
		configTabItemsArr.push({
			xtype: 'toolbar',
			dock: 'bottom',
			//cls:'egFooterNewConfigWin',
			height: 40,
			width:'100%',
			layout: {
				align: 'middle',
				pack: 'center',
				type: 'hbox'
			},
			items: [
			{
				xtype : 'button',
				//buttonAlign:'right',
				id : 'addNewGridData',
				text : screenLabelsObj['AddBtnLbl'],
				margin:'0 10 0 0',
				padding:'4 15',
				cls : 'editWidgetWinBtn'
			},
			{
				xtype : 'button',
				//buttonAlign:'right',
				text : screenLabelsObj['FinishBtnLbl'],
				id: 'finishButton',
				margin:'0 0 0 0',
				padding:'4 15',
				cls : 'editWidgetWinBtn',
				handler: function() {
					var configButton = Ext.getCmp('configureBtn');
					

					if(configButton.pressed){

						//alert("buttonpressed")
						
						Ext.getCmp('configFormFields').hide();
						Ext.getCmp('configSettings').show();
						configButton.pressed = false;
					}
					else{
						//alert("notpressed");
						Ext.getCmp('configFormFields').show();
						Ext.getCmp('configSettings').hide();
					}
					var clickFinish =  Ext.getCmp('doneButton');
					clickFinish.enable();
					clickFinish.show();
				}
			}]
		});
		meItemsArr.push({
					xtype: 'container',
					layout : {
						type : 'vbox'
					},
					width: '100%',
					height: 400,
					cls: '',
					modal:true,
					//id: 'timeline_box',
					id: 'configFormFields',
					cls:'editWidgetWindow',
					hidden: true,
					defaults: {
						labelAlign: 'left',
						labelSeparator:''
					},				
					margin:'0 10 0 10',
					padding:'10 10 0 10',
					items : configTabItemsArr
			});

			miscPanelCtrlsArr.push({
				xtype: 'container',
				layout : {
					type : 'vbox'
				},
				width: '100%',
				//height: 10,
				id: 'configureButtonId',
				cls:'',
				//hidden: true,
				defaults: {
					labelAlign: 'left',
					labelSeparator:''
				},				
				margin:'0 10 0 10',
				padding:'0',
				items: [
					{
						xtype:'panel',
						cls:'configureBtnPanel',
						width: '100%',
						height: 7,
					},
					{
						xtype:'button',
						text: screenLabelsObj['ConfigureBtnLbl'],
						id: 'configureBtn',
						cls:'configureBtn',
						margin:'0 0 0 15',
						enableToggle:true,
						padding:'4 10',
						listeners:{
						toggle: function(btn, pressed, eOpts) {
							if(pressed){
								$("#configFormFields").slideDown(300);
								Ext.getCmp('configFormFields').show();						
								Ext.getCmp('configSettings').hide();
								$("#configFormFields").slideDown(300);
								Ext.getCmp('doneButton').hide();
							}else{
								Ext.getCmp('configFormFields').hide();
								$("#configFormFields").slideUp(300);
								Ext.getCmp('configSettings').show();
								Ext.getCmp('doneButton').show();
							}

						}}
					}
				]
			});
			miscBottomPanlObj={
				xtype:'panel',
				width: '100%',
				id: '',
				cls:'',
				items:
				{

					xtype: 'comparisontable',
					isAggregationDisabled: isAggregationDisabled,
					isCombinationChart: isCombinationChart,
					hidden : false
				}
			};
	}
	else
	{
		var ctrlsOptsMap={};
		meWidgetConfigObj.configOptsMap={};
		meWidgetConfigObj.configOptsMap['test']={id : 'test',ctrlType : 'dropdown',Label  : 'Test',emptyText : 'Select a Test'};
		var isLiveBoxOrDDWidget=false;
		var isDD=false;
		if(widgetType!=null && widgetType=='liveMeasuresBox')
		{
			isLiveBoxOrDDWidget=true;
			meWidgetConfigObj.configOptsMap['measure']={id : 'measure',ctrlType : 'multiselect',Label  : 'Measures',searchText : screenLabelsObj['SearchMeasures']};
		}
		else
		{
			meWidgetConfigObj.configOptsMap['measure']={id : 'measure',ctrlType : 'dropdown',Label  : 'Measures',searchText : 'Please select a measure'};
		}
		meWidgetConfigObj.configOptsMap['componentType']={id : 'componentType',ctrlType : 'dropdown',Label  : 'Component Type',emptyText : 'Select a Component Type'};

		if(meWidgetConfigObj.isTopNWidget)
		{
			meWidgetConfigObj.configOptsMap['component']={id : 'component',ctrlType : 'multiselect',Label  : 'Component',searchText : screenLabelsObj['SearchComponents']};
		}
		else
		{
			meWidgetConfigObj.configOptsMap['component']={id : 'component',ctrlType : 'dropdown',Label  : 'Component',emptyText : 'Please select a component'};
		}

		if(widgetType!=null && widgetType=='ddTable')
		{
			isDD=true;
			isLiveBoxOrDDWidget=true;
			meWidgetConfigObj.configOptsMap['ddColumns']={id : 'ddColumns',ctrlType : 'multiselect',Label  : 'DD Columns',searchText : 'search DD Column(s)'};

			meWidgetConfigObj.configOptsMap['chartType']={id : 'chartType',ctrlType : 'dropdown',Label  : 'Graphical Type',emptyText : 'Select a graphical type'};

			//meWidgetConfigObj.configOptsMap['summarizeDDColumn']={id : 'summarizeDDColumn',ctrlType : 'multiselect',Label  : 'Summarize DD Data By',searchText : 'search DD column(s)'};
			
			meWidgetConfigObj.configOptsMap['summarizeDDColumn']={id : 'summarizeDDColumn',ctrlType : 'dropdown',Label  : 'Summarize DD Data By (Y axis)',searchText : 'search DD column(s)'};
		}
		else
		{
			if(meWidgetConfigObj.isTopNWidget)
			{
				meWidgetConfigObj.configOptsMap['descriptor']={id : 'descriptor',ctrlType : 'multiselect',Label  : 'Descriptor',searchText : screenLabelsObj['SearchDescriptors']};
			}
			else
			{
				meWidgetConfigObj.configOptsMap['descriptor']={id : 'descriptor',ctrlType : 'dropdown',Label  : 'Descriptor',searchText : 'Please select a descriptor'};
			}
		}

		var columnCtrsMap = [];
		if(widgetType == 'ddTable')
		{
			//columnCtrsMap=[{ 'columns' : ['componentType','measure']} , { 'columns' : ['component','ddColumns'] } , {'columns' : ['test'] }];
			columnCtrsMap=[{ 'columns' : ['chartType']},{ 'columns' : ['componentType']},{ 'columns' : ['component']},{ 'columns' : ['test']} , { 'columns' : ['measure']},{ 'columns' : ['summarizeDDColumn']},{ 'columns' : ['ddColumns']}];
		}
		else if(meWidgetConfigObj.isTopNWidget)
		{
			columnCtrsMap=[{ 'columns' : ['test','measure','componentType']} , { 'columns' : ['component'] } , {'columns' : ['descriptor'] }];
		}
		else if(widgetType == 'liveMeasuresBox')
		{
			columnCtrsMap=[{ 'columns' : ['componentType']},{ 'columns' : ['component']},{ 'columns' : ['test']} , { 'columns' : ['measure']},{ 'columns' : ['descriptor']}];
		}
		else
		{
			columnCtrsMap=[{ 'columns' : ['componentType','measure']} , { 'columns' : ['component','descriptor'] } , {'columns' : ['test'] }];
		}

		var ctrlArr = [];
		var subsetArr1=[];
		var subsetArr2=[];
		for(var colmn in columnCtrsMap)
		{
			var columnObj = columnCtrsMap[colmn];
			var colsArr=columnObj['columns'];
			var colCtrlArr=[];
			
			for(var cl in colsArr)
			{
				var colName=colsArr[cl];
				var configForCol=meWidgetConfigObj.configOptsMap[colName];
				if(configForCol['ctrlType']=='multiselect')
				{	
					var multiSelectContWidth=280;
					if(isLiveBoxOrDDWidget)
					{
						multiSelectContWidth=220;
					}

					
					if(isLiveBoxOrDDWidget)
					{
						if(configForCol.id!=null && configForCol.id=="measure" || configForCol.id=="ddColumns")
						{
							var settingsObj={};
							settingsObj['labelAlign']='top';
							settingsObj['width']=multiSelectContWidth;
							subsetArr2.push({
							xtype: 'container',
							layout:{type:'hbox',align:'stretch'},
							width: multiSelectContWidth,
							margin:'10px 0px 0px 0px',
							//height:145,
							id:configForCol.id+'_OuterContainer',
							defaults: {
								labelAlign: 'top',
								labelSeparator:'',
								align:'top',
							},
							items : [
							{
								xtype: 'label',
								cls:'x-form-item',
								id: configForCol.id+'ComboLbl',
								name: configForCol.id+'ComboLbl',
							//	width: 60,
								margin:'0px 0px 0px 0px',
								text:configForCol.Label,
								labelClsExtra: 'icon-properties item-label-icon',
							},		
							{
								xtype:'button',
								cls:'iconButtonClass iconMultiselectExpand',
								margin:'0 0 0 8',
								style: {'border':'none'},
								id: configForCol.id+"ExpandSelector",									
								name: configForCol.id+"ExpandSelector",									
								listeners: {
									afterrender: function () {
										Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: configForCol.Label
										});
									}
								},
							}
							]
						});
							subsetArr2.push(meWidgetConfigObj.createMultiSelectbox(configForCol.id,configForCol.searchText,settingsObj));
						}
						else
						{
							subsetArr1.push(meWidgetConfigObj.createMultiSelectbox(configForCol.id,configForCol.searchText));
						}
					}
					else
					{
						var  innerContArr=[];
						innerContArr.push({
								xtype: 'label',
								cls:'x-form-item',
								id: configForCol.id+'ComboLbl',
								name: configForCol.id+'ComboLbl',
						//		width: 60,
								margin:'0px 0px 0px 0px',
								text:configForCol.Label,
								labelClsExtra: 'icon-properties item-label-icon',
							});
						innerContArr.push({
								xtype:'button',
								cls:'iconButtonClass iconMultiselectExpand',
								margin:'0 0 8 8',
								style: {'border':'none'},
								id: configForCol.id+"ExpandSelector",									
								name: configForCol.id+"ExpandSelector",									
								listeners: {
									afterrender: function () {
										Ext.create('Ext.tip.ToolTip', {
											target: this.id,
											anchor: 'top',
											cls: 'yellowTip',
											trackMouse: true,
											html: configForCol.Label
										});
									}
								},
							});
					
						var hideMultiSelect=false;
						if(showCompAutoAssociatioOption && meWidgetConfigObj.autoAssociateComponents && ((colName!=null && colName=='component') || (colName!=null && colName=='descriptor')))
						{
							hideMultiSelect=true;
							colCtrlArr.push({
								xtype: 'container',
								layout:{type:'hbox',align:'stretch'},
								width: multiSelectContWidth,
								margin:'10px 0px 0px 0px',
								items : [{
											xtype :'label',
											margin:'0px 0px 0px 0px',
											cls:'x-form-item-label',
											id : colName+'LblObj',
											text : colName
										},
										{
											xtype :'label',
											margin:'0px 0px 0px 0px',
											cls:'x-form-item-label',
											id : 'all'+colName+'LblObj',
											text : 'All '+colName+'s'
										}]
							});
						}
						colCtrlArr.push({
							xtype: 'container',
							layout:{type:'hbox',align:'stretch'},
							width: multiSelectContWidth,
							margin:'10px 0px 0px 0px',
							//height:145,
							hidden : hideMultiSelect,
							id:configForCol.id+'_OuterContainer',
							defaults: {
								labelAlign: 'top',
								labelSeparator:'',
								align:'top',
							},
							items : innerContArr
						});
						colCtrlArr.push(meWidgetConfigObj.createMultiSelectbox(configForCol.id,configForCol.searchText));
					}
				}
				else
				{
					if(isLiveBoxOrDDWidget)
					{
						var settingsObj={};
						settingsObj['labelAlign']='top';
						settingsObj['width']=220;
						if(configForCol.id!=null && (configForCol.id!="descriptor" && configForCol.id!="measure"))
						{
							if(configForCol.id!=null && configForCol.id=="summarizeDDColumn")
							{
								subsetArr2.push(meWidgetConfigObj.createSingleSelectBox(configForCol.id,configForCol.Label,configForCol.emptyText,settingsObj));				
							}
							else
							{
								subsetArr1.push(meWidgetConfigObj.createSingleSelectBox(configForCol.id,configForCol.Label,configForCol.emptyText,settingsObj));
							}
						}
						else
						{
							if(isDD)
							{
								subsetArr1.push(meWidgetConfigObj.createSingleSelectBox(configForCol.id,configForCol.Label,configForCol.emptyText,settingsObj));
							}
							else
							{
								subsetArr2.push(meWidgetConfigObj.createSingleSelectBox(configForCol.id,configForCol.Label,configForCol.emptyText,settingsObj));
							}
						}
					}
					else
					{
						colCtrlArr.push(meWidgetConfigObj.createSingleSelectBox(configForCol.id,configForCol.Label,configForCol.emptyText));
					}
				}
			}
			if(!isLiveBoxOrDDWidget)
			{
				ctrlArr.push({
					xtype: 'panel',
					layout : {
						type : 'vbox',
						align:'stretch',
						pack:'start'
					},
					flex:1,
					margin : '0 10px 0 10px',
					defaults: {
						labelAlign: 'top',
						labelSeparator:''
					},
					items : colCtrlArr
				});
			}
		}

		if(this.widgetID.startsWith('ScatterPlot'))
		{
			 miscBottomPanlObj={
				xtype: 'tabpanel', 
				id:'scatterTab',
				ui:'newTabPanel4',
				items: [{
						title: 'Configure X Axis',
						itemId: 'x_Axis',
						id: 'x_Axis',
						style:{"box-shadow":"none","background":"none"},
						layout : {
							type : 'hbox',
							align:'stretch'
						},
						padding:'7 10 26 10',
						bodyPadding:'0 0 0 0',
						margin:'0 0  0  0',
						defaults: {
							labelAlign: 'top',
							labelSeparator:''
						},
						items:ctrlArr
				}, {
						title: 'Configure Y Axis',
						itemId: 'y_Axis',
						id: 'y_Axis',
						style:{"box-shadow":"none","background":"none"},
						layout : {
							type : 'hbox',
							align:'stretch'
						},
						padding:'7 10 26 10',
						bodyPadding:'0 0 0 0',
						margin:'0 0  0  0',
						defaults: {
							labelAlign: 'top',
							labelSeparator:''
						},
						items:[]
				}],

				 listeners: {
					'tabchange': function(tabPanel, tab){
						if(tab.id=='y_Axis')
						{
							var scatterTab_Obj=Ext.getCmp('scatterTab');
							scatterTab_Obj.isYAxisTabLoaded=true;

							var x_Axis_Obj=Ext.getCmp('x_Axis');
							x_Axis_Obj.removeAll();

							var y_Axis_Obj=Ext.getCmp('y_Axis');
							y_Axis_Obj.add(ctrlArr);

							 x_Axis_Obj.setDisabled(true);

							meWidgetConfigObj.loadDefaultDataforScatterPlotConfigurationTab('yAxis');
						}
						else
						{
							var y_Axis_Obj=Ext.getCmp('y_Axis');
							y_Axis_Obj.removeAll();

							var x_Axis_Obj=Ext.getCmp('x_Axis');
							x_Axis_Obj.add(ctrlArr);

							y_Axis_Obj.setDisabled(true);
							
							meWidgetConfigObj.loadDefaultDataforScatterPlotConfigurationTab('xAxis');
						}
					}
				}										
			};
		}
		else 
		{
			if(!Ext.isEmpty(widgetType) && (widgetType!='liveMeasuresBox' && widgetType!='ddTable'))
			{
				miscBottomPanlObj={
					xtype:'fieldset',
					title: 'Configure Metrics',
					cls:'configWinFieldsetNew',
					ui:'newFieldSetHeader',
					collapsible: false,
					style:{"box-shadow":"none","background":"none"},
					layout : {
						type : 'hbox',
						align:'stretch'
					},
					padding:'0 10 20 10',
					bodyPadding:'0 0 0 0',
					margin:'0 0  0  0',
					defaults: {
						labelAlign: 'top',
						labelSeparator:''
					},
					items:ctrlArr
				};
			}
			else
			{
				miscBottomPanlObj={
					xtype:'container',
					id : 'settingsContObj',
					layout : {
										type : 'hbox',
										align:'stretch'
									},
					padding:'0 10 10 15',
					bodyPadding:'0 0 0 0',
					margin:'0 0  0  0',
					defaults: {
						labelAlign: 'top',
						labelSeparator:''
					}
				};
			}
		}
	}
	var isChart=false;
	var isTopNChart=false;
	var widgetPreviewTitle='';
	var widgetPnlObj=Ext.getCmp(thisWidgetID);
	if(!Ext.isEmpty(widgetPnlObj))
	{
		isChart=widgetPnlObj.isChart;
		isTopNChart=widgetPnlObj.isTopNChart;
		widgetPreviewTitle=widgetPnlObj.title;
	}

	if(this.isKpi)
	{
		if(widgetType!=null && widgetType == 'digitalChart')
		{
			widgetPreviewTitle='Digital Chart';
		}
		if(widgetType!=null && widgetType == 'dialChart')
		{
			widgetPreviewTitle='Gauge Meter';
		}
	}
	var previewContainerHeight=280;
	if(widgetType!=null && (widgetType=='dialChart' || widgetType=='digitalChart'))
	{
		previewContainerHeight=200;
	}
	var isWidgetConfigured=false;
	if(meWidgetConfigObj!=null && meWidgetConfigObj.action=='editWidget')
	{
			isWidgetConfigured=true;
	}
	var portletWidth=400;
	var portletHeight=250;
	var portletDims=this.widgetPreviewDimensions[widgetType];
	if(!Ext.isEmpty(portletDims))
	{
		portletWidth=portletDims[0];
		portletHeight=portletDims[1];
	}
	var widgetSettingsPnlObj={};
	if(isDD)
	{
		var liveorddfldset={
			xtype:'fieldset',
			//title: 'Configure Metrics',
			title: 'Metrics Configuration',
			cls:'configWinFieldsetNew',
			ui:'newFieldSetHeader',
			collapsible: false,
			style:{"box-shadow":"none","background":"none"},
			layout: {
				type: 'column'
			},
			defaults: {
				labelAlign: 'top',
				columnWidth : 1,
				labelSeparator:''
				
			},				
			margin:'0 0 0 0',
			padding:'0 10 20 10',
			items:[{ 
						xtype : 'container', 
						columnWidth : 0.5, 
						//flex:1,
						margin:'0 10 0 10',
						items : subsetArr1
					},
					{ 
						xtype : 'container', 
						columnWidth : 0.5, 
						//flex:1,
						margin:'0 10 0 10',
						items : subsetArr2
					}]			
		};
		
		widgetSettingsPnlObj={
			//TODO
			xtype: 'container',
			width: 500,
			//flex:1,
			//height: 280,
			cls:'widget_config_form',
			layout: {
				type: 'column'
			},
			id: 'controllerSetting',
			//disabledCls:'my-disabled-panel',
			//disabled : (meWidgetConfigObj.action=='addWidget'?true:false),
			//hidden: true,
			defaults: {
				labelAlign: 'top',
				columnWidth : 1,
				labelSeparator:''
				
			},				
			margin:'0 0 0 0',
			padding:'0 0 0 0',
			items : liveorddfldset
		};
	}
	else if(isLiveBoxOrDDWidget)
	{
		var liveorddfldset={
			xtype:'fieldset',
			//title: 'Configure Metrics',
			title: 'Metrics Configuration',
			cls:'configWinFieldsetNew',
			ui:'newFieldSetHeader',
			collapsible: false,
			style:{"box-shadow":"none","background":"none"},
			layout: {
				type: 'column'
			},
			defaults: {
				labelAlign: 'top',
				columnWidth : 1,
				labelSeparator:''
				
			},				
			margin:'0 0 0 0',
			padding:'0 10 20 10',
			items:[{ 
						xtype : 'container', 
						columnWidth : 0.5, 
						//flex:1,
						margin:'0 10 0 10',
						items : subsetArr1
					},
					{ 
						xtype : 'container', 
						columnWidth : 0.5, 
						//flex:1,
						margin:'0 10 0 10',
						items : subsetArr2
					}]
		};
		
		widgetSettingsPnlObj={
			//TODO
			xtype: 'container',
			width: 500,
			//flex:1,
			//height: 280,
			cls:'widget_config_form',
			layout: {
				type: 'column'
			},
			id: 'controllerSetting',
			//disabledCls:'my-disabled-panel',
			//disabled : (meWidgetConfigObj.action=='addWidget'?true:false),
			//hidden: true,
			defaults: {
				labelAlign: 'top',
				columnWidth : 1,
				labelSeparator:''
				
			},				
			margin:'0 0 0 0',
			padding:'0 0 0 0',
			items : liveorddfldset
		};
	}
	else
	{
		widgetSettingsPnlObj={
			//TODO
			xtype: 'container',
			width: 380,
			//flex:1,
			//height: 280,
			cls:'widget_config_form',
			layout: {
				type: 'column'
			},
			id: 'controllerSetting',
			disabledCls:'my-disabled-panel',
			disabled : (meWidgetConfigObj.action=='addWidget'?true:false),
			//hidden: true,
			defaults: {
				labelAlign: 'top',
				columnWidth : 1,
				labelSeparator:''
				
			},				
			margin:'0 0 0 0',
			padding:'0 0 0 0'
		};
	}
	miscPanelCtrlsArr.push({
				xtype: 'panel', 
				id: 'configSettings',
				cls:'configSettingsWindow',
				flex:1,
				//style:{'border':'red 1px solid'},
				border:true,
				padding:'10 0 10 0',
				bodyPadding:'0 10 0 10',
				scroll:true,
				autoScroll:true,
				layout : {
					type : 'vbox',
					align:'stretch'
				},
				//hidden: true,
				defaults: {
					labelAlign: 'top',
					labelSeparator:''
				},				
				margin:'0 0 0 0',
				items: [
					{
						xtype:'panel',
						//height:230,
						//style:{'border':'#000 1px solid'},
						margin:'0 0 0 0',
						padding:'0 0 10 0',
						layout : {
							type : 'hbox',
							pack:'center',
						},
						items: [
							{
								xtype:'previewcontiner',
								margin:'4 20 4 10',
								width: portletWidth,
								height  : portletHeight,
								isConfigured : isWidgetConfigured,
								items:[{
								xtype: 'portlet',
								width: portletWidth - 23,
								height  : portletHeight - 23,
								id: thisWidgetID+'_previewImage',
								title : widgetPreviewTitle,
								ui : 'newGraphPanel',
								cls:'previewImage',	
								margin:'0 0 0 0',
								isChart : isChart,
								isTopNChart : isTopNChart,
								showMoreDataOption : false,
								isPreviewMode : true
							}]
							},
							widgetSettingsPnlObj
						]
					},
					miscBottomPanlObj
				]
			});


	meItemsArr.push({
			xtype:'panel', 
			cls:'outer',
			// style:{'border':'yellow 1px solid'},
			flex:1,
			layout : {
				type : 'vbox',
				align:'stretch'
			},
			border:false,
			padding:'0 0',
			items:miscPanelCtrlsArr
			});


	return {
	 xtype: 'form',
	 layout:{
		type:'vbox',
		align:'stretch'
	 },
	 id : 'widgetConfigForm',
	 name : 'widgetConfigForm',
     itemId: 'configForm',
	 cls:'form',
	 //height:250,
	 flex:1,
	 //style:{'border':'blue 1px solid'},
	 fullscreen: true, 
	 scroll:true,
	 autoScroll:true,
	 border:false,
	 padding:'0 0',
	 items : meItemsArr,
	  listeners : {
		'afterrender': function()
		 {
			if(reCreateLayout)
			{
				meWidgetConfigObj.loadPopupData(true);
			}
		 }
	 }
	};
},
createConfiguartionForServiceHealthWidget : function()
{
	return createConfiguartionForServiceHealthWidget(false);
},

createConfiguartionForServiceHealthWidget : function(reCreateLayout)
{
	var thisWidgetID=this.widgetID;
	var isChart=false;
	var isTopNChart=false;
	var widgetPreviewTitle='';
	var widgetPnlObj=Ext.getCmp(thisWidgetID);
	if(!Ext.isEmpty(widgetPnlObj))
	{
		isChart=widgetPnlObj.isChart;
		isTopNChart=widgetPnlObj.isTopNChart;
		widgetPreviewTitle=widgetPnlObj.title;
	}
	var portletWidth=400;
	var portletHeight=250;
	var portletDims=this.widgetPreviewDimensions[this.widgetType];
	if(!Ext.isEmpty(portletDims))
	{
		portletWidth=portletDims[0];
		portletHeight=portletDims[1];
	}
			var componentarr = new Array();

		var compmultiselectLable ={
			xtype: 'label',
			id: 'healthCenterComponentComboLbl',
			name: 'healthCenterComponentComboLbl',
			margin:'0px 10px 0px 0px',
			style: {
				'font-family':'Roboto',
				'padding': '0 0 4px 0'
			},
			text:'Components',
			
		};

		var compmultiselectcont ={
			xtype:'container',
			layout:{type:'vbox',align:'stretch'},
			width : 230,
			cls:'darkbox',
			height:125,
			id:'compTypeBOX',
			items:[{
				xtype:'trigger',
				margin : '10',
				id : 'healthCenterComponentSearchTextBox',
				name : 'healthCenterComponentSearchTextBox',
				width : 178,
				cls: 'whitedropdown_search',
				emptyText : 'Search',
				componentStore : null,
				hidden : true,
				listeners :
				{
					'change' : function(triggerField, newValue, oldValue, eOpts) {
						var me = this;
						var compntStore = me.componentStore;
						if(compntStore==null)
						{
							me.componentStore = this.up('form').getForm().findField('healthCenterComponentCombo').getStore();
							compntStore = me.componentStore;
						}
						if(newValue=="*")
						{
							compntStore.clearFilter();
						}
						else
						{
							if(newValue.lastIndexOf("*")==(newValue.length-1))
							{
								newValue = newValue.substr(0,(newValue.length-1));
							}
							compntStore.clearFilter();
							if (newValue) {
								var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
								compntStore.filter({
									filterFn: function(record) {
										return matcher.test(record.get('displayField')) ;
									}
								});
							}
						 triggerField.focus();
						}
					 }
				}
			},{
				xtype: 'multiselect',
				id: 'healthCenterComponentCombo',
				baseCls: 'egmultiselect',
				name: 'healthCenterComponentCombo',
				multiSelect: true,
				height:82,
				hidden: true,
				store: Ext.create('Ext.data.Store', {
					fields: ['displayField', 'valueField','editedCompName'],
					data: []
				}),
				editable: false,
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				listConfig: {
					id: 'componentListC',
					itemTpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<div id="{valueField}"  style="text-align:left">{displayField}</div>',
						'</tpl>'
					),
					listeners: {
					}
				}
			}]
		};

		var VMmultiselectLable ={
			xtype: 'label',
			id: 'healthCenterVMComboLbl',
			name: 'healthCenterVMComboLbl',
			hidden : true,
			margin:'10px 10px 0px 0px',
			style: {
				'font-family':'Roboto',
				'padding': '0 0 4px 0'
			},
			text:'VM:',
			
		};

		var vmMultiselectcont ={
			xtype:'container',
			layout:{type:'vbox',align:'stretch'},
			width : 230,
			cls:'darkbox',
			height:125,
			id:'compVmBOX',
			hidden : true,
			items:[{
				xtype:'trigger',
				margin : '10',
				id : 'healthCenterVMSearchTextBox',
				name : 'healthCenterVMSearchTextBox',
				width : 178,
				cls: 'whitedropdown_search',
				emptyText : 'Search',
				componentStore : null,
				hidden : false,
				listeners :
				{
					'change' : function(triggerField, newValue, oldValue, eOpts) {
						var me = this;
						var compntStore = me.componentStore;
						if(compntStore==null)
						{
							me.componentStore = this.up('form').getForm().findField('vmListCombo').getStore();
							compntStore = me.componentStore;
						}
						if(newValue=="*")
						{
							compntStore.clearFilter();
						}
						else
						{
							if(newValue.lastIndexOf("*")==(newValue.length-1))
							{
								newValue = newValue.substr(0,(newValue.length-1));
							}
							compntStore.clearFilter();
							if (newValue) {
								var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
								compntStore.filter({
									filterFn: function(record) {
										return matcher.test(record.get('displayField')) ;
									}
								});
							}
						 triggerField.focus();
						}
					 }
				}
			},{
				xtype: 'multiselect',
				id: 'vmListCombo',
				baseCls: 'egmultiselect',
				name: 'vmListCombo',
				multiSelect: true,
				height:82,
				//hidden: true,
				store: Ext.create('Ext.data.Store', {
					fields: ['displayField', 'valueField','editedCompName'],
					data: []
				}),
				editable: false,
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				listConfig: {
					id: 'vmsList',
					itemTpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<div id="{valueField}"  style="text-align:left">{displayField}</div>',
						'</tpl>'
					),
					listeners: {
					}
				}
			}]
		};

		componentarr.push(compmultiselectLable);
		componentarr.push(compmultiselectcont);
		componentarr.push(VMmultiselectLable);
		componentarr.push(vmMultiselectcont);
		     
	var infraHealthForm = {
				xtype: 'container',
				layout : {
					type : 'vbox'
				},
				width: 540,
				height: 310,
				cls:'',
				margin:'0 0 0 0',
				padding:'0 0 0 0',
					items: [{
						xtype:'container',
						layout : {
								type : 'hbox'
							},
						padding:0,
						defaults:{
							margin: '10 0 10 20 ',
							labelWidth:'auto',
							labelSeparator:'',
							labelStyle: 'white-space: pre;'
						},
						items: [
							{
							xtype:'container',
							padding:0,
							defaults:{
								margin: '0 10 10 20 ',
								labelWidth:'auto',
								labelSeparator:'',
								labelStyle: 'white-space: pre;'
							},
							items: [{
									xtype: 'scrollcombo',
									id: 'categoryOpts',
									name: 'categoryOpts',
									hidden : false,
									selectOnTab: true,
									editable : false,
									labelAlign: 'top',
									width: 220,
									margin:'-5 0 10 0',
									fieldLabel :'Category',
									displayField: 'displayField',
									valueField: 'valueField',
									store: Ext.create('Ext.data.Store', {
										fields: ['displayField', 'valueField'],
										data: []
									}),
									lazyRender: true,
									editable:false,
									queryMode: 'local'
								},
									{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								labelAlign: 'top',
								fieldLabel: 'Component Type',
								id: 'healthCenterCompTypeCombo',
								name: 'healthCenterCompTypeCombo',
								hidden: true,
								width: 220,
								margin:'5 0 10 0',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: []
								}),
								editable: false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							},
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: 'Component',
								labelAlign: 'top',
								id: 'healthCenterCompScrollCombo',
								name: 'healthCenterCompScrollCombo',
								hidden: true,
								width: 220,
								margin:'5 0 10 0',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: []
								}),
								editable: false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							},
							{
								xtype: 'scrollcombo',
								cls: 'dropdown',
								fieldLabel: 'Test',
								labelAlign: 'top',
								id: 'healthCenterTestScrollCombo',
								name: 'healthCenterTestScrollCombo',
								hidden: true,
								width: 220,
								margin:'5 0 10 0',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField', 'valueField'],
									data: []
								}),
								editable: false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local'
							},		
							{
								xtype: 'checkboxgroup',
								width:220,
								id:'legandCheckBox',
								margin: '0 0 20 0',
								defaults:{
									margin:'5 0 0 0',
								},
								labelWidth:220,
								labelAlign: 'top',
								labelStyle: 'margin: 4px 0 0 0px; padding: 0;',
								labelSeparator:'',
								fieldLabel : legendDisplayLbl,
								columns:2,
								widgetID:thisWidgetID,
								hidden: true,
								items: [{
									boxLabel: 'Descriptors',
									id: 'showDescOpt',
									name: 'showDescOpt',
									hidden : false,
									inputValue: 'yes',
									cls : 'checkbt',
									//checked:true
								},
								{
									boxLabel: 'Servers',
									id: 'showServersOpt',
									name: 'showServersOpt',
									hidden : false,
									inputValue: 'yes',
									cls : 'checkbt',
									//checked:true
								}
								],
								listeners : {
									'change' : function(chkBoxObj)
									{
										if(myDashApp.getController("WidgetConfigurationController").validateWidgetConfiguration(chkBoxObj.widgetID)==false)
										{
											return false;
										}
										else
										{
											Ext.getCmp('doneButton').enable();
											myDashApp.getController("WidgetConfigurationController").showWidgetPreview(chkBoxObj.widgetID);
										}
									}
								}
							},
						{
							xtype : 'switchfield',
							name: 'Enable Legend',
							id: 'enableLegendOpt',
							widgetID:thisWidgetID,
							defaults:{
								margin:'5 0 20 10',
							},
							labelWidth:100,
							//labelStyle: 'margin: 4px 0 10px 15px; padding: 0;font-family:LucidaGrandeBold',
						//	labelSeparator:'',
							fieldLabel: 'Enable Legend :',
							inputValue: 'Yes',
							uncheckedValue:'No',
							margin:'4 0 0 0',
							width :200,
							vertical: false,
							checked:false,
							listeners : {
								'change' : function(switchFldObj)
								{
									if(!switchFldObj.isDefault)
									{
										switchFldObj.isDefault=false;
										Ext.getCmp('doneButton').enable();
										myDashApp.getController("WidgetConfigurationController").showWidgetPreview(switchFldObj.widgetID);
									}
								}
							}
						}]	
					},
					{
						xtype:'container',
						padding:0,
						margin: '5 0 10 20 ',
						defaults:{
							margin: '0 20 10 0 ',
							labelWidth:'auto',
							labelSeparator:'',
							labelStyle: 'white-space: pre;'
						},
						items: [
							{
								xtype: 'container',
								layout:{type:'column',align:'left'},
								width: 260,
								flex:1,
								id:'healthCenterCompContiner',
								hidden:true,
								margin: '0 0 10 20',	
								items: componentarr
						   },
						   {
								xtype : 'button',
								width:80,
								text: addDispBtn,
								hidden:true,
								margin: '5 0 0 20',	
								id: 'addHealthCenter',
								name: 'addHealthCenter',
								cls: 'button20'
						}]
					}]
				}]
			};
			
		return {
				xtype: 'form', 
				id : 'configForm',
				width: '100%',
				flex:1,
				modal: true,
				autoScroll:true,
				layout : {
					type : 'vbox'
				},
				defaults: {
					labelAlign: 'top',
					labelSeparator:''
				},	
				bodyPadding:10,
				margin:'0 0 0 0',
				items: [
					{
						xtype:'panel',
						width: '100%',
						items:[{
							xtype:'container',
							width: '100%',
							layout : {
								type : 'hbox'
							},
							items: [
								{
										xtype:'previewcontiner',
										margin:'4 20 4 10',
										width: portletWidth,
										height  : portletHeight,
										items:[{
											xtype: 'portlet',
											width: portletWidth - 23,
											height  : portletHeight - 23,
											id: thisWidgetID+'_previewImage',
											title : widgetPreviewTitle,
											ui : 'newGraphPanel',
											cls:'previewImage',	
											margin:'0 0 0 0',
											padding:'0',
											isChart : isChart,
											isTopNChart : isTopNChart,
											showMoreDataOption : false,
											isPreviewMode : true
										}]			
								},infraHealthForm]
						}]
					},
					{
						xtype:'panel',
						width: '100%',
						id: 'gridContainer',
						cls:'',
						hidden: true,
						items:
						{

							xtype: 'comparisontable',
							isAggregationDisabled: true,
							isCombinationChart: true,
							needToHideMeasure: true,
							hidden: false
						}
					}]
			};

},

loadDefaultDataforWidgetConfigurationWindow : function()
{
	var mePopup = this;
	 var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
     var thisWind = new Ext.LoadMask(this.getEl(), {
            msg: "Loading .."
        });
     thisWind.show();
	  var metricsFormPanelObj = this.getComponent('configForm');

	var isHealthWidget=false;
	var isDDWidget=false;
	var isScatterPlotWidget=false;
	var isTopNAnalysisWidget=false;
	var isGaugeOrDigitalOrLiveBoxWidget=false;
	if(!Ext.isEmpty(this.widgetType))
	{
		if(this.widgetType=='dialChart' || this.widgetType=='digitalChart' || this.widgetType=='liveMeasuresBox')
		{
			isGaugeOrDigitalOrLiveBoxWidget=true;
		}
		else if(this.widgetType=='health')
		{
			isHealthWidget=true;
		}
		else if(this.widgetType=='TopNAnalysis')
		{
			isTopNAnalysisWidget=true;
		}
		else if(this.widgetType=='ddTable')
		{
			isDDWidget=true;
		}
		else if(this.widgetType=='ScatterPlot')
		{
			isScatterPlotWidget=true;
		}
	}
	var metricsForm = metricsFormPanelObj.getForm();

	var thisWidgetID = mePopup.widgetID;
	if(mePopup.isKpi)
	{
		thisWidgetID = mePopup.kpiBlckId+'_'+thisWidgetID;
	}
	else
	{
		thisWidgetID = mePopup.widgetID;
	}

	 Ext.Ajax.request({
            url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
            method: 'POST',
            params: 'comesFrom=myDashboard&action=loadConfigPopup&profileName=' + profileName + '&blockId=' + thisWidgetID +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
            scope: this,
            success: function (response) {
				var jsonText = response.responseText;
				if (jsonText != null && jsonText != '') {
						thisWind.hide();
						var jsonData = Ext.decode(jsonText);
						mePopup.setWidgetPopupTitle(configTitle[mePopup.widgetType]+" "+addMetricsTitle);
						this.suspendEvents(true);
						Ext.suspendLayouts();

						if(isScatterPlotWidget)
						{
							var isWidgetConfigured=false;
							if(jsonData['configuredDetails']!=null && jsonData['configuredDetails'].hasOwnProperty('isWidgetConfigured'))
							{
								isWidgetConfigured=jsonData['configuredDetails']['isWidgetConfigured'];
							}
							var scatterTab_Obj=Ext.getCmp('scatterTab');
							scatterTab_Obj.isWidgetConfigured=isWidgetConfigured;
							scatterTab_Obj.isYAxisTabLoaded=false;

							if(isWidgetConfigured)
							{
								var x_Axis_Obj=Ext.getCmp('x_Axis');

								x_Axis_Obj.setIconCls('checkBoxTick');
								x_Axis_Obj.setTitle('Y Axis Configured');
								
								var y_Axis_Obj=Ext.getCmp('y_Axis');
								y_Axis_Obj.setIconCls('checkBoxTick');
								y_Axis_Obj.setTitle('Y Axis Configured');
							}
						}	
						var settingPnlId='controllerSetting';
						if(mePopup.widgetType!=null && (mePopup.widgetType=='liveMeasuresBox' || mePopup.widgetType=='ddTable'))
						{
							settingPnlId='settingsContObj';
						}
						var controllerSettingObj=Ext.getCmp(settingPnlId);
						if(!Ext.isEmpty(controllerSettingObj))
						{
							var isMultipleSettingsArr=false;
							if(jsonData['configuredDetails']!=null && jsonData['configuredDetails'].hasOwnProperty('isMultipleSettingsArr'))
							{
								isMultipleSettingsArr=jsonData['configuredDetails']['isMultipleSettingsArr'];
							}
							if(isMultipleSettingsArr)
							{
								var settingsSubArr1=jsonData['configuredDetails']['settingsSubArr1'];
								var settingsSubArr2=jsonData['configuredDetails']['settingsSubArr2'];
								//controllerSettingObj.setWidth(540);
								controllerSettingObj.setWidth(590);
								var subsettingsObjArr=[];
								//TODO
								 subsettingsObjArr.push({ 
															xtype : 'container', 
															columnWidth : 0.5, 
															flex:1,
															margin:'0 10 0 0',
															items : mePopup.createSettingsCtrls(settingsSubArr1) 
								});
								subsettingsObjArr.push({ 
															xtype : 'container', 
															columnWidth : 0.5, 
															margin:'0 0 0 10',
															flex:1,
															items : mePopup.createSettingsCtrls(settingsSubArr2) 
								});
								controllerSettingObj.add(subsettingsObjArr);
								controllerSettingObj.doComponentLayout();
							}
							else
							{
								var settingsJsonArr=jsonData['configuredDetails']['settingsArr'];
								if(!Ext.isEmpty(settingsJsonArr))
								{
									mePopup.widgetSettingsJsonArr=settingsJsonArr;
									
									
									controllerSettingObj.add(mePopup.createSettingsCtrls(settingsJsonArr));
									controllerSettingObj.doComponentLayout();
								}
							}
						}

						if(!isGaugeOrDigitalOrLiveBoxWidget && !isScatterPlotWidget)
						{
							controllerSettingObj.add({
								xtype:'container',
								cls:'b-container',
								padding:0,
								margin: '0 0 0 0 ',
								defaults:{
									margin: '10 0 10 0 '
								},
								items:[{
								xtype:'textareafield',
								//width: 150,
								width: 265,
								fieldLabel:screenLabelsObj['ExcludeDescriptors'],
								cls: 'excludeDesc text-area  min-height-textbox',
								labelSeparator :"",
								labelWidth:100,
								labelAlign: 'left',
								id:'excludeDesc',
								emptyText:'',
								enableKeyEvents : true,
								minHeight:25,
								//margin:'8 0 8 20',
								autoScroll:true,
								minHeight:25,
								rows:1,
								isEnableDoneButton : false,
								listeners : {
									'keyup' : function(txtAreaObj)
									{
										if(!txtAreaObj.isEnableDoneButton)
										{
											var clickFinish =  Ext.getCmp('doneButton');
											clickFinish.enable();
										}
									}
								}
							}]
							});
						}
						var configuredDetailsObj = jsonData['configuredDetails'];
						var selectedCompType = '';
						var selectedComp = '';
						var selectedTest = '';
						var selectedMeasure = '';
						var selectedDescriptor = '';
						var selectedGraphType='';
						var useStateColorForFonts='';
						var selectedDDColumns='';
						var summarizeDdCols='';
						var selectedChartType='';
						//var resizeFont='';
						var showGaugeCircle='';
						var showStateColorForGauge='';
						
						var compTypeCombo = metricsForm.findField('componentTypeCombo');
						var testCombo = metricsForm.findField('testCombo');
						var componentCombo = metricsForm.findField('componentCombo');

						if(isGaugeOrDigitalOrLiveBoxWidget ||  isHealthWidget || isDDWidget || isScatterPlotWidget)
						{
							if(isGaugeOrDigitalOrLiveBoxWidget && !Ext.isEmpty(configuredDetailsObj))
							{
								selectedCompType = configuredDetailsObj['selectedCompType'];
								selectedComp = configuredDetailsObj['selectedComp'];
								if((selectedCompType!=null && selectedCompType!="undefined" && selectedCompType!="" && selectedCompType!="-1") && (selectedComp!=null && selectedComp!="undefined" && selectedComp!='' && selectedComp!="-1"))
								{
									selectedComp = selectedCompType+":"+selectedComp;
								}
								selectedTest = configuredDetailsObj['selectedTest'];
								selectedMeasure = configuredDetailsObj['selectedMeasure'];
								selectedDescriptor = configuredDetailsObj['selectedDescriptor'];
								selectedGraphType = configuredDetailsObj['selectedGraphType'];
								useStateColorForFonts = configuredDetailsObj['useStateColorForFonts'];
								//resizeFont = configuredDetailsObj['resizeFont'];
								showGaugeCircle = configuredDetailsObj['gaugeCircleEnabled'];
								showStateColorForGauge = configuredDetailsObj['stateColorForGaugeEnabled'];
							}
							else if(isScatterPlotWidget)
							{
								var xAxisConfigJson = jsonData['configuredDetails']['xAxisConfigJson'];
								selectedCompType = xAxisConfigJson['selectedCompType'];
								selectedComp = xAxisConfigJson['selectedComp'];
								selectedTest = xAxisConfigJson['selectedTest'];
								selectedMeasure = xAxisConfigJson['selectedMeasure'];
								selectedDescriptor = xAxisConfigJson['selectedDescriptor'];
							}
							else if(isDDWidget)
							{
								if(!Ext.isEmpty(configuredDetailsObj))
								{
									selectedCompType = configuredDetailsObj['selectedCompType'];
									selectedComp = configuredDetailsObj['selectedComp'];
									if((selectedCompType!=null && selectedCompType!="undefined" && selectedCompType!="" && selectedCompType!="-1") && (selectedComp!=null && selectedComp!="undefined" && selectedComp!='' && selectedComp!="-1"))
									{
										selectedComp = selectedCompType+":"+selectedComp;
									}
									selectedTest = configuredDetailsObj['selectedTest'];
									selectedMeasure = configuredDetailsObj['selectedMeasure'];
									selectedDDColumns = configuredDetailsObj['ddColumns'];
									summarizeDdCols = configuredDetailsObj['summarizeDdCols'];
									selectedChartType = configuredDetailsObj['selectedChartType'];
								}
							}
							compTypeCombo.suspendEvents(true);
							compTypeCombo.getStore().removeAll();
							compTypeCombo.getStore().loadRawData(jsonData['comptypes']);
							compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
							compTypeCombo.getStore().insert(0,{
									displayField:compTypAlertMsg,
									valueField: '-1'
								});
							compTypeCombo.setValue('-1');
							compTypeCombo.resumeEvents();
							if((isGaugeOrDigitalOrLiveBoxWidget || isDDWidget || isScatterPlotWidget) && (selectedCompType!=null && selectedCompType!=''))
							{
								compTypeCombo.setValue(selectedCompType);
								compTypeCombo.fireEvent('select',compTypeCombo);
							}
							else
							{
								compTypeCombo.setValue('-1');
							}

							testCombo.suspendEvents(true);
							testCombo.getStore().removeAll();
							testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
							if((isGaugeOrDigitalOrLiveBoxWidget || isDDWidget || isScatterPlotWidget) && (selectedTest!=null && selectedTest!=''))
							{
									testCombo.getStore().on('load', function(){ mePopup.fireComboSelection(testCombo,selectedTest);  }, this, {
										single: true,
										delay: 100
									});
							}
							else
							{
								testCombo.getStore().insert(0,{
									displayField:notApplicable,
									valueField: '-1'
								});
								testCombo.setValue('-1');
							}
							testCombo.resumeEvents();

							var measureCombo = metricsForm.findField('measureCombo');
							if(this.widgetType!='liveMeasuresBox'&& !isHealthWidget)
							{
								measureCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Measures']);
							}
							if((isGaugeOrDigitalOrLiveBoxWidget || isDDWidget || isScatterPlotWidget) && (selectedMeasure!=null && selectedMeasure!=''))
							{
								measureCombo.getStore().on('load', function(){ mePopup.fireComboSelection(measureCombo,selectedMeasure);  }, this, {
										single: true,
										delay: 100
								});
							}
							else
							{
								var measureComboStore = measureCombo.getStore();
								measureCombo.suspendEvents(true);
								measureComboStore.removeAll();
								measureComboStore.insert(0, {
									displayField: notApplicable,
									valueField: '-1',
									editedFieldName : notApplicable
								});
								measureCombo.setValue('-1');
								
							}

							componentCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);

							var componentComboStore = componentCombo.getStore();
							componentCombo.suspendEvents(true);
							componentComboStore.removeAll();
							if((isGaugeOrDigitalOrLiveBoxWidget || isDDWidget || isScatterPlotWidget) && (selectedComp!=null && selectedComp!=''))
							{
								componentComboStore.on('load', function(){ mePopup.fireComboSelection(componentCombo,selectedComp);  }, this, {
										single: true,
										delay: 100
									});
							}
							else
							{	
								componentComboStore.insert(0, {
									displayField: notApplicable,
									valueField: '-1',
									editedFieldName : notApplicable
								});
								componentCombo.setValue('-1');
							}
							componentCombo.resumeEvents();
						}
						else
						{
							if(isTopNAnalysisWidget)
							{
								selectedCompType = configuredDetailsObj['selectedCompType'];
								selectedComp = configuredDetailsObj['selectedComps'];
								selectedDescriptor = configuredDetailsObj['selectedDescriptors'];
								selectedTest = configuredDetailsObj['selectedTest'];
								selectedMeasure = configuredDetailsObj['selectedMeasure'];
							}
							testCombo.suspendEvents(true);
							testCombo.getStore().loadRawData(jsonData['tests']);
							
							testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
							if(mePopup.isTopNWidget)
							{
								if(selectedTest!=null && selectedTest!='')
								{
									testCombo.setValue(selectedTest);
								}
							}
							else
							{
								testCombo.setValue('-1');
							}
							testCombo.resumeEvents();

							if(mePopup.isTopNWidget)
							{
								var measureCombo = metricsForm.findField('measureCombo')
								measureCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Measures']);

								if(selectedMeasure!=null && selectedMeasure!='')
								{
									measureCombo.getStore().loadRawData(jsonData['configuredDetails']['measureListJson']['measureOpts']);
									measureCombo.setValue(selectedMeasure);
								}
								else
								{
									var measureComboStore = measureCombo.getStore();
									measureCombo.suspendEvents(true);
									measureComboStore.removeAll();
									measureComboStore.insert(0, {
										displayField: notApplicable,
										valueField: '-1',
										editedFieldName : notApplicable
									});
									measureCombo.setValue('-1');
								}

								if(selectedCompType!=null && selectedCompType!='')
								{
									compTypeCombo.getStore().loadRawData(jsonData['configuredDetails']['measureListJson']['compTypeOpts']);
									compTypeCombo.setValue(selectedCompType);
								}
								else
								{
									compTypeCombo.suspendEvents(true);
									compTypeCombo.getStore().removeAll();
									compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
									compTypeCombo.getStore().insert(0, {
										displayField: notApplicable,
										valueField: '-1'
									});
									compTypeCombo.setValue('-1');
									compTypeCombo.resumeEvents();
								}
							}
							else
							{
								compTypeCombo.suspendEvents(true);
								compTypeCombo.getStore().removeAll();
								compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
								compTypeCombo.getStore().insert(0, {
									displayField: notApplicable,
									valueField: '-1'
								});
								compTypeCombo.setValue('-1');
								compTypeCombo.resumeEvents();

								var measureCombo = metricsForm.findField('measureCombo');
								//measureCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Measures']);
								var measureComboStore = measureCombo.getStore();
								measureCombo.suspendEvents(true);
								measureComboStore.removeAll();
								measureComboStore.insert(0, {
									displayField: notApplicable,
									valueField: '-1',
									editedFieldName : notApplicable
								});
								measureCombo.setValue('-1');
								measureCombo.resumeEvents();
							}

							if(this.widgetType!=null && (this.widgetType=='pieChart' || this.widgetType=='activityChart' || isHealthWidget))
							{
								componentCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
							}
							else
							{
								Ext.getCmp('componentComboLbl').setText(jsonData['screenLabels']['monitor.common.Component']);
							}
							if(mePopup.isTopNWidget)
							{
								if(selectedComp!=null && selectedComp!='')
								{
									componentCombo.getStore().loadRawData(jsonData['configuredDetails']['compsJson']['compOptsJson']);
									componentCombo.setValue(selectedComp);
								}
								else
								{
									var componentComboStore = componentCombo.getStore();
									componentCombo.suspendEvents(true);
									componentComboStore.removeAll();
									componentComboStore.insert(0, {
										displayField: notApplicable,
										valueField: '-1',
										editedFieldName : notApplicable
									});
									componentCombo.setValue('-1');
									componentCombo.resumeEvents();
								}
							}
							else
							{
								var componentComboStore = componentCombo.getStore();
								componentCombo.suspendEvents(true);
								componentComboStore.removeAll();
								componentComboStore.insert(0, {
									displayField: notApplicable,
									valueField: '-1',
									editedFieldName : notApplicable
								});
								componentCombo.setValue('-1');
								componentCombo.resumeEvents();
							}
						}

						if(isDDWidget)
						{
							var chartTypeCombo = metricsForm.findField('chartTypeCombo');
							chartTypeCombo.suspendEvents(true);
							chartTypeCombo.getStore().removeAll();
							chartTypeCombo.getStore().loadRawData(jsonData['configuredDetails']['chartDataCombo']);
							chartTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Graphical Type']);
							chartTypeCombo.resumeEvents();
							if(selectedChartType!=null && selectedChartType!='')
							{
								chartTypeCombo.setValue(selectedChartType);
								chartTypeCombo.fireEvent('select',chartTypeCombo);
							}
							else
							{
								selectedChartType = 'Table';
								chartTypeCombo.setValue('Table');
							}

							var summarizeDDColumnCombo = metricsForm.findField('summarizeDDColumnCombo');
							var summarizeDDColumnComboStore = summarizeDDColumnCombo.getStore();
							summarizeDDColumnComboStore.removeAll();
							if(selectedMeasure!=null && selectedMeasure!='')
							{
								summarizeDDColumnCombo.getStore().on('load', function(){ mePopup.fireComboSelection(summarizeDDColumnCombo,summarizeDdCols);  }, this, {
										single: true,
										delay: 100
									});
							}
							else
							{
								summarizeDDColumnComboStore.insert(0,{
									displayField:notApplicable,
									valueField: '-1'
								});
								summarizeDDColumnCombo.setValue('-1');
							}
												
							var summarizeDDColumnObj = metricsForm.findField('summarizeDDColumnCombo');
							var ddColumnsComboLbl = Ext.getCmp('ddColumnsComboLbl');
							var viewTypeOpt = metricsForm.findField('ViewType');
							var viewTypeVal='';
							if(viewTypeOpt != null && !Ext.isEmpty(viewTypeOpt))
							{
								if(selectedChartType != null && selectedChartType !='Bar Chart')
								{
									viewTypeOpt.hide();
								}
								else
								{
									viewTypeOpt.show();
								}
								viewTypeVal = viewTypeOpt.getValue();
							}
							if(!Ext.isEmpty(ddColumnsComboLbl) && !Ext.isEmpty(summarizeDDColumnObj))
							{
								if(selectedChartType!=null && selectedChartType=='Bar Chart')
								{
									if(viewTypeVal!=null && viewTypeVal == 'Vertical')
									{
										summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (X axis)');
										ddColumnsComboLbl.setText('DD Columns (Y axis)');
									}
									else if(viewTypeVal!=null && viewTypeVal == 'Horizontal')
									{
										summarizeDDColumnObj.setFieldLabel('Summarize DD Data By (Y axis)');
										ddColumnsComboLbl.setText('DD Columns (X axis)');
									}
								}
								else
								{
									summarizeDDColumnObj.setFieldLabel('Summarize DD Data By');
									ddColumnsComboLbl.setText('DD Columns');
								}
							}

							var timeLineObj = Ext.getCmp('Timeline');
							if(timeLineObj != null && !Ext.isEmpty(timeLineObj))
							{
								if(selectedChartType!=null && (selectedChartType=='Time Line' || selectedChartType=='Area'))
								{
									timeLineObj.show();
								}
								else
								{
									timeLineObj.hide();
								}
							}

							var showChartSummarySwitchVal = Ext.getCmp('showChartSummary');

							if(showChartSummarySwitchVal!=null &&  !Ext.isEmpty(showChartSummarySwitchVal))
							{
								if(selectedChartType!=null && (selectedChartType=='Time Line' || selectedChartType=='Area'))
								{
									showChartSummarySwitchVal.show();
								}
								else
								{
									showChartSummarySwitchVal.hide();
								}
							}
							var ddColumnsCombo = metricsForm.findField('ddColumnsCombo');
							var ddMeasureColsComboStore = ddColumnsCombo.getStore();
							ddMeasureColsComboStore.removeAll();
							if(selectedMeasure!=null && selectedMeasure!='')
							{
								ddColumnsCombo.getStore().on('load', function(){ mePopup.fireComboSelection(ddColumnsCombo,selectedDDColumns);  }, this, {
										single: true,
										delay: 100
									});
							}
							else
							{
								ddMeasureColsComboStore.insert(0,{
									displayField:notApplicable,
									valueField: '-1'
								});
								ddColumnsCombo.setValue('-1');
							}
							var ddColumnsCombo = metricsForm.findField('ddColumnsCombo')
							ddColumnsCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Measures']);
							var ddColumnsComboStore = ddColumnsCombo.getStore();
							ddColumnsCombo.suspendEvents(true);
							ddColumnsComboStore.removeAll();
							ddColumnsComboStore.insert(0, {
								displayField: notApplicable,
								valueField: '-1',
								editedFieldName : notApplicable
							});
							ddColumnsCombo.setValue('-1');
							ddColumnsCombo.resumeEvents();
						}
						else
						{
							var descriptorCombo = metricsForm.findField('descriptorCombo');
							descriptorCombo.suspendEvents(true);
							if(mePopup.widgetType!=null && (isHealthWidget || isGaugeOrDigitalOrLiveBoxWidget || isDDWidget || isScatterPlotWidget))
							{
								descriptorCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
							}
							else
							{
								Ext.getCmp('descriptorComboLbl').setText(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
							}

							if((isGaugeOrDigitalOrLiveBoxWidget || isDDWidget || isScatterPlotWidget) && (selectedDescriptor!=null && selectedDescriptor!=''))
							{
								descriptorCombo.getStore().on('load', function(){ mePopup.fireComboSelection(descriptorCombo,selectedDescriptor);  }, this, {
										single: true,
										delay: 100
									});
							}
							else
							{
								if(mePopup.isTopNWidget)
								{
									if(selectedDescriptor!=null && selectedDescriptor!='' && selectedDescriptor!='AllInfos')
									{
										descriptorCombo.setValue(selectedDescriptor);
										descriptorCombo.getStore().on('load', function(){ mePopup.fireComboSelection(descriptorCombo,selectedDescriptor);  }, this, {
										single: true,
										delay: 100
										});
									}
									else
									{
										var descriptorComboStore = descriptorCombo.getStore();
										descriptorCombo.suspendEvents(true);
										descriptorComboStore.removeAll();
										descriptorComboStore.insert(0, {
											displayField: notApplicable,
											valueField: '-1',
											editedFieldName : notApplicable
										});
										descriptorCombo.setValue('-1');
										descriptorCombo.resumeEvents();
									}
								}
								else
								{
									var descriptorComboStore = descriptorCombo.getStore();
									descriptorCombo.suspendEvents(true);
									descriptorComboStore.removeAll();
									descriptorComboStore.insert(0, {
										displayField: notApplicable,
										valueField: '-1',
										editedFieldName : notApplicable
									});
									descriptorCombo.setValue('-1');
									descriptorCombo.resumeEvents();
								}
							}
						}

						if(mePopup.showConfigurationTab)
						{
							if(mePopup.widgetType == 'BarChart' || mePopup.widgetType == 'table' || mePopup.widgetType == 'pieChart' || mePopup.widgetType == 'activityChart' || mePopup.widgetType == 'heatMapChart')
							{
								var aggOptions = metricsForm.findField('aggOptions');
								aggOptions.suspendEvents(true);
								metricsForm.findField('showAggOpt').setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Aggregate Descriptors']);
								aggOptions.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Aggrgeate Function']);
								aggOptions.getStore().loadRawData(jsonData['configuredDetails']['aggFunctionOptions']);
								aggOptions.setValue('avg');
								aggOptions.resumeEvents();
							}

							var gridData = jsonData['configuredDetails']['gridData'];
							if (!Ext.isEmpty(gridData)) 
							{
								mePopup.modified=true;
								var configTableGrid = Ext.getCmp('configTableGrid');
								configTableGrid.suspendEvents(true);
								if(mePopup.widgetType == 'table')
								{
									mePopup.tableGridDataObj=gridData;
								}
								var gridStore = configTableGrid.getStore();
								gridStore.add(gridData);
								configTableGrid.show();
								configTableGrid.resumeEvents();
								configTableGrid.doComponentLayout();
							}
							else
							{
								Ext.getCmp('configTableGrid').show();
							}
						}

						if(mePopup.widgetType == 'CombinedTimelineChart' || mePopup.widgetType == 'TimelineChart' || mePopup.widgetType=='areaChart' || mePopup.widgetType=='table' || mePopup.widgetType == 'combinationChart'|| mePopup.widgetType == 'BarChart' || mePopup.widgetType == 'TrendGraph' || mePopup.widgetType == 'ddTable' || mePopup.widgetType == 'pieChart' || mePopup.widgetType == 'activityChart'  || mePopup.widgetType == 'heatMapChart' || mePopup.isTopNWidget) {
							var excludeDescVal = '';
							if(mePopup.widgetType == 'ddTable')
							{
								if(configuredDetailsObj.hasOwnProperty('excludedDescriptors'))
								{
									excludeDescVal=configuredDetailsObj['excludedDescriptors'];
								}
							}
							else
							{
								excludeDescVal=jsonData['configuredDetails']['excludedDescriptors'];
							}
							var excludeDesc = metricsForm.findField('excludeDesc');
							if (!Ext.isEmpty(excludeDescVal)) {	
								excludeDesc.setValue(excludeDescVal);
							}else{
								excludeDesc.setValue("");
							}
						}                   
						
						if(mePopup.widgetType == 'CombinedTimelineChart' || mePopup.widgetType == 'TimelineChart' || mePopup.widgetType == 'combinationChart' || mePopup.widgetType=='areaChart' || mePopup.widgetType == 'TrendGraph') {
							Ext.getCmp("er_mode").hide();
							var timelineComboObj = metricsForm.findField('er_timeline');
							if(mePopup.widgetType == 'TrendGraph')
							{
								timelineComboObj.getStore().loadRawData(jsonData['timelinedetails']['timeline']);
								var selectedTimeline = jsonData['configuredDetails']['timeline'];
								timelineComboObj.setValue(selectedTimeline);

								var trendGrpDuration = jsonData['configuredDetails']['trendGrpDuration'];
								if (trendGrpDuration!=null && trendGrpDuration!='' && !Ext.isEmpty(trendGrpDuration))
								{
									var durationLabel = trendGrpDuration['monitor.dashboard.Duration'];
									var selectedDuration = trendGrpDuration['selectedDuration'];
									var durationObj = Ext.getCmp('period');
									durationObj.setFieldLabel(durationLabel);
									durationObj.getStore().loadRawData(jsonData['timelinedetails']['period']);
									durationObj.setValue(selectedDuration);
								}
							}
							else
							{
								timelineComboObj.getStore().loadRawData(jsonData['timelineJson']);
								var selectedTimeline = jsonData['configuredDetails']['timeline'];
								timelineComboObj.setValue(selectedTimeline);
							}

							var startdateObj = metricsForm.findField('er_stdate');
							var enddateObj = metricsForm.findField('er_enddate');
							var startHourObj = metricsForm.findField('er_sthr');
							var endHourObj = metricsForm.findField('er_endhr');
							var startMinObj = metricsForm.findField('er_stmin');
							var endMinObj = metricsForm.findField('er_endmin');
							//var timeLineSwitchObj = Ext.getCmp('timeLineSwitch');
							if(mePopup.widgetType == 'TimelineChart' || mePopup.widgetType == 'areaChart')
							{
								 var yMaxObj = Ext.getCmp("yMax");
								 var yMaxValue = jsonData['configuredDetails']['yMaxValue'];
								 if(yMaxValue!=null && yMaxValue!='')
								 {
									 yMaxObj.setValue(yMaxValue);
								 }
							}
							if(mePopup.widgetType == 'TrendGraph')
							{
								startdateObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartDate']);
								startdateObj.dataArray = jsonData['timelinedetails']['timelineSelections']['startDateInMgrDateFormat'];
								enddateObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndDate']);
								enddateObj.dataArray = jsonData['timelinedetails']['timelineSelections']['endDateInMgrDateFormat'];
								startHourObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartHour']);
								startHourObj.dataArray = jsonData['timelinedetails']['timelineSelections']['startHrInMgrDate'];
								endHourObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndHour']);
								endHourObj.dataArray = jsonData['timelinedetails']['timelineSelections']['endHourInMgrDate'];
								stmin = jsonData['timelinedetails']['timelineSelections'].startMinInMgrDate;
								enmin = jsonData['timelinedetails']['timelineSelections'].endMinInMgrDate;
								startMinObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedStartMin']);
								endMinObj.setValue(jsonData['timelinedetails']['timelineSelections']['selectedEndMin']);
								mgr_stmin = jsonData['timelinedetails']['timelineSelections'].startMinInMgrDate;
								mgr_enmin = jsonData['timelinedetails']['timelineSelections'].endMinInMgrDate;
								if (displayTimeline) {
									var timelineContObj=Ext.getCmp('timelineMyObj');
									if(mePopup.widgetType!='table' && mePopup.widgetType!='BarChart')
									{
										//timeLineSwitchObj.show();
										timelineContObj.show();
									}
									else if(isTopNChart)
									{
										//timeLineSwitchObj.show();
										timelineContObj.show();
									}
									if (selectedTimeline != null && selectedTimeline == 'Any') {
										timelineContObj.selectedMgrStMin=mgr_stmin;
										timelineContObj.selectedMgrEndMin=mgr_enmin;
										timelineContObj.selectedStMinForDisplay=jsonData['timelinedetails']['timelineSelections']['selectedStartMin'];
										timelineContObj.selectedEndminForDisplay=jsonData['timelinedetails']['timelineSelections']['selectedEndMin'];
										
										timelineComboObj.fireEvent('select', timelineComboObj);
									}
									Ext.getCmp('er_stmin').show();
									Ext.getCmp('er_endmin').show();
								}
							}
							else
							{
								startdateObj.setValue(jsonData['configuredDetails']['startDateForDisplay']);
								startdateObj.dataArray = jsonData['configuredDetails']['startDate'];
								enddateObj.setValue(jsonData['configuredDetails']['endDateForDisplay']);
								enddateObj.dataArray = jsonData['configuredDetails']['endDate'];
								startHourObj.setValue(jsonData['configuredDetails']['startHourForDisplay']);
								startHourObj.dataArray = jsonData['configuredDetails']['startHour'];
								endHourObj.setValue(jsonData['configuredDetails']['endHourForDisplay']);
								endHourObj.dataArray = jsonData['configuredDetails']['endHour'];
								stmin = jsonData['configuredDetails'].startMinForDisplay;
								enmin = jsonData['configuredDetails'].endMinForDisplay;
								startMinObj.setValue(jsonData['configuredDetails']['startMinForDisplay']);
								endMinObj.setValue(jsonData['configuredDetails']['endMinForDisplay']);
								mgr_stmin = jsonData['configuredDetails'].strMin;
								mgr_enmin = jsonData['configuredDetails'].endMin;
								if (displayTimeline) {
									var timelineContObj=Ext.getCmp('timelineMyObj');
									if(mePopup.widgetType!='table' && mePopup.widgetType!='BarChart')
									{
										//timeLineSwitchObj.show();
										timelineContObj.show();
									}
									else if(isTopNChart)
									{
										//timeLineSwitchObj.show();
										timelineContObj.show();
									}
									if (selectedTimeline != null && selectedTimeline == 'Any') {
										timelineContObj.selectedMgrStMin=mgr_stmin;
										timelineContObj.selectedMgrEndMin=mgr_enmin;
										timelineContObj.selectedStMinForDisplay=jsonData['configuredDetails']['startMinForDisplay'];
										timelineContObj.selectedEndminForDisplay=jsonData['configuredDetails']['endMinForDisplay'];
										
										timelineComboObj.fireEvent('select', timelineComboObj);
									}
									Ext.getCmp('er_stmin').show();
									Ext.getCmp('er_endmin').show();
								}
							}
						}
						if(mePopup.action=='editWidget')
						{
							//Ext.defer(function(){
						//	myDashApp.getController("WidgetConfigurationController").showWidgetPreviewAtPopupStartUp(mePopup.widgetID);
							//},100);
						}
						if(mePopup.widgetType == 'digitalChart')
						{
							var templateIcon = '/final/images/'+strSkin+'/listViewWidgetDefault.png';
							var showChartSummaryObj=Ext.getCmp('ChartSummaryEnabled');
							if(!Ext.isEmpty(showChartSummaryObj))
							{
								var enableChartSummary=configuredDetailsObj['ChartSummaryEnabled'];
								if(enableChartSummary!=null && enableChartSummary=="yes")
								{
									showChartSummaryObj.setValue(true);
									var summaryGraphType=configuredDetailsObj['summaryGraphType'];
									var chartSummaryGraphTypeObj=Ext.getCmp('SummaryGraphType');
									if(Ext.isEmpty(summaryGraphType) || summaryGraphType=='none')
										summaryGraphType="-1";

									chartSummaryGraphTypeObj.setValue(summaryGraphType);
									var enableChartIcon=configuredDetailsObj['enableChartIcon'];
									if(enableChartIcon!=null && enableChartIcon=="yes")
									{
										var showIconObj=Ext.getCmp('ShowIcon');
										showIconObj.setValue(true);
										templateIcon=configuredDetailsObj['imgIcon'];
										if(Ext.isEmpty(templateIcon))
										{
											templateIcon = '/final/images/'+strSkin+'/listViewWidgetDefault.png';
										}
										Ext.getCmp('ShowIcon').setDisabled(false);
									}
									else
									{
										Ext.getCmp('ShowIcon').setDisabled(false);
									}
								}
								else
								{
									Ext.getCmp('ShowIcon').setDisabled(true);
								}
							}
							if(templateIcon!=null && templateIcon!="")
							{
								if(templateIcon.indexOf(":")>0 && templateIcon.startsWith("Default"))
								{
									templateIcon = templateIcon.substring(templateIcon.indexOf(":")+1);
									var digitalChartImgCont=Ext.getCmp('digitalChartImgCont');
									
									digitalChartImgCont.iconClass=templateIcon;
									if(templateIcon.indexOf('_')>-1)
									{
										templateIcon = templateIcon.substring(0,templateIcon.lastIndexOf('_')+1)+'32';
									}
									digitalChartImgCont.update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><div id="dashboardImageIcon"  class= "'+templateIcon+'" width="32px" height="32px" border="0px"/><div class="settingOver"></div></div>');
									digitalChartImgCont.doComponentLayout();
									Ext.defer(function(){

										digitalChartImgCont.setImageTriggerEvents(digitalChartImgCont);
										},100);
									//digitalChartImgCont.setImageTriggerEvents(digitalChartImgCont);
								}
								else
								{
									var digitalChartImgCont=Ext.getCmp('digitalChartImgCont');
									if(!Ext.isEmpty(digitalChartImgCont))
									{
										digitalChartImgCont.update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault" style="padding:5px"><img id="dashboardImageIcon"  src="'+templateIcon+'" width="100%" height="100%" border="0px"/><div class="settingOver"></div></div>');
										digitalChartImgCont.doComponentLayout();
										//Ext.getCmp('customImgcont').update('<div id="customUserDefinedImgDefault" class="userDefinedImgDefault"><div style="width:32px;height:32px;overflow:hidden;position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;"><img id="dashboardImageIcon"  src="'+templateIcon+'"  style="position: absolute;top:0%;left: 0%;right: 0%;margin: auto;bottom: 0%;" border="0px"/><div class="settingOver"></div></div>');
										Ext.defer(function(){

										digitalChartImgCont.setImageTriggerEvents(digitalChartImgCont);
										},100);
									}
								}
							}
						}
						else if(mePopup.widgetType == 'dialChart')
						{
							if(metricsForm.findField('UseStateColorForGauge').getValue()==true)
							{
								Ext.getCmp('ColorPicker').hide();
							}
							else
							{
								if(isHighchartForGauge)
								{
									Ext.getCmp('ColorPicker').show();
								}
							}
						}
						else if(mePopup.isTopNWidget)
						{
							if(metricsForm.findField('displayType').getValue()=="bar")
							{
								metricsForm.findField('ViewType').show();
								metricsForm.findField('ColorPalette').show();
							}
							else
							{
								metricsForm.findField('ViewType').hide();
								metricsForm.findField('ColorPalette').hide();
							}
						}
						else if(mePopup.widgetType == 'table')
						{
							var showChartSummaryObj=Ext.getCmp('enableChartSummary');
							var chartSummaryGraphTypeObj=Ext.getCmp('SummaryGraphType');
							if(!Ext.isEmpty(showChartSummaryObj))
							{
								var enableChartSummary=configuredDetailsObj['enableChartSummary'];
								if(enableChartSummary!=null && enableChartSummary=="yes")
								{
									showChartSummaryObj.setValue(true);
									var summaryGraphType=configuredDetailsObj['summaryGraphType'];
									
									if(Ext.isEmpty(summaryGraphType) || summaryGraphType=='none')
										summaryGraphType="-1";

									chartSummaryGraphTypeObj.setValue(summaryGraphType);

									chartSummaryGraphTypeObj.setValue(summaryGraphType);
									Ext.getCmp('SummaryGraphType').setDisabled(false);
								}
							}
					
							if(!Ext.isEmpty(configuredDetailsObj) && configuredDetailsObj.hasOwnProperty('showValues') && configuredDetailsObj.hasOwnProperty('SetStateColorOn')) 
							{
								var showValues=configuredDetailsObj['showValues'];
								var stateColorOnValue=configuredDetailsObj['SetStateColorOn'];
								if(!Ext.isEmpty(showChartSummaryObj) && !Ext.isEmpty(chartSummaryGraphTypeObj))
								{
									if(stateColorOnValue=='none' && showValues=='yes')
									{
										showChartSummaryObj.setDisabled(false);
										chartSummaryGraphTypeObj.setDisabled(false);
									}
									else
									{ 										
										showChartSummaryObj.setDisabled(true);
										chartSummaryGraphTypeObj.setDisabled(true);
									}
								}
							}
						}
						this.resumeEvents();
						Ext.resumeLayouts(true);
				}
				if(isGaugeOrDigitalOrLiveBoxWidget || isDDWidget || isScatterPlotWidget)
				{
					var clickFinish =  Ext.getCmp('doneButton');
					clickFinish.enable();
				}

				if(mePopup.isKpi)
				{

					Ext.defer(function(){

						var useExternalDataObj=Ext.getCmp('useExternalData');
						if(!Ext.isEmpty(useExternalDataObj))
						{
							useExternalDataObj.setValue(false);
						}

						var prevButtonObj = Ext.getCmp('prevButton');
						var nextButtonObj = Ext.getCmp('nextButton');

						if(mePopup.Kpicount==1)
						{
							prevButtonObj.needToDisable = true;
							prevButtonObj.setDisabled(true);
						}

						if(mePopup.Kpicount==mePopup.totalKpiCount)
						{
							nextButtonObj.needToDisable = true;
							nextButtonObj.setDisabled(true);
						}			

						if(!prevButtonObj.needToDisable)
						{
							prevButtonObj.setDisabled(false);
						}

						if(!nextButtonObj.needToDisable)
						{	
							nextButtonObj.setDisabled(false);
						}
												
					},1000);
				}
				if(mePopup.widgetType == 'CombinedTimelineChart' || mePopup.widgetType == 'TimelineChart' || mePopup.widgetType=='areaChart' || mePopup.widgetType=='table' || mePopup.widgetType == 'combinationChart'|| mePopup.widgetType == 'BarChart' || mePopup.widgetType == 'TrendGraph' || mePopup.isTopNWidget) {
						console.log("jsonData['configuredDetails']",jsonData['configuredDetails']);
						if(jsonData['configuredDetails']!=null && jsonData['configuredDetails'].hasOwnProperty('autoAssociateComponents'))
						{
							var autoAssociateComponentsStr=jsonData['configuredDetails']['autoAssociateComponents'];
							if(Ext.isEmpty(autoAssociateComponentsStr))
								autoAssociateComponentsStr='no';

							if(autoAssociateComponentsStr!=null && autoAssociateComponentsStr.toLowerCase()=='yes')
							{
								mePopup.autoAssociateComponents=true;
								var complblObj=Ext.getCmp('componentLblObj');
								complblObj.setText(jsonData['screenLabels']['monitor.common.Component']);
								var allcomplblObj=Ext.getCmp('allcomponentLblObj');
								allcomplblObj.setText(jsonData['screenLabels']['monitor.common.All Components']);

								var desclblObj=Ext.getCmp('descriptorLblObj');
								desclblObj.setText(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
								var alldesclblObj=Ext.getCmp('alldescriptorLblObj');
								alldesclblObj.setText(jsonData['screenLabels']['monitor.common.All Descriptors']);
								var descriptormainCont=Ext.getCmp('descriptorMultiSelectOuterBox');
								var compcontner=Ext.getCmp('componentMultiSelectOuterBox');

								if(!Ext.isEmpty(compcontner))
								{
									compcontner.hide();
								}
								 if(!Ext.isEmpty(descriptormainCont))
								 {
									descriptormainCont.hide();
								 }
							}
						}
					}
		},
		failure : function()
		{

		}
	 });
},
createSingleSelectBox : function(combId,comboLbl,comboEmptyText)
{
	return createSingleSelectBox(combId,comboLbl,comboEmptyTex,null);
},
createSingleSelectBox : function(combId,comboLbl,comboEmptyText,comboSettings)
{
	var hidden = false;
	if(combId !=null && combId == 'summarizeDDColumn')
	{
		hidden = true;
	}
	var comboObj = {
		xtype: 'scrollcombo',
		id: combId+"Combo",
		name: combId+"Combo",
		hidden: hidden,
		fieldLabel: comboLbl,
		emptyText:comboEmptyText,
		width: 280,
		margin:'10 0 0 0',
		store: Ext.create('Ext.data.Store', {
			fields: ['displayField','valueField'],
			data: [	]
		}),
		editable:false,
		displayField: 'displayField',
		valueField: 'valueField',
		queryMode: 'local'
	};
	if(!Ext.isEmpty(comboSettings))
	{
		for(var cs in comboSettings)
		{
			var settingVal = comboSettings[cs];
			comboObj[cs]=settingVal;
		}
	}
	return comboObj;
},
createMultiSelectbox : function(controlID,searchBoxEmptyText)
{
	return createMultiSelectbox(controlID,searchBoxEmptyText,null);
},
createMultiSelectbox : function(controlID,searchBoxEmptyText,multiSelectSettings)
{
	var defaltMultiSelectHeight=160;
	var defaltMultiSelectOuterContHeight=190;
	if(!Ext.isEmpty(this.widgetType) && (this.widgetType=="liveMeasuresBox" || this.widgetType=="ddTable" || this.widgetType=="TopNAnalysis"))
	{
		defaltMultiSelectHeight=95;
		defaltMultiSelectOuterContHeight=125;
	}

	var multiSelectCombo = {
				xtype: 'multiselect',
				id: controlID+"Combo",
				baseCls: 'egmultiselect',
				name: controlID+"Combo",
				multiSelect: true,
				height:defaltMultiSelectHeight,
				store: Ext.create('Ext.data.Store', {
					fields: ['displayField', 'valueField','editedFieldName'],
					data: []
				}),
				listConfig: {
					id: controlID+'ListC1',
					simpleSelect: true
				},
				editable: false,
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			};
	 
		var outerContainerWidth=290;
	
		if(!Ext.isEmpty(multiSelectSettings))
		{
			for(var cs in multiSelectSettings)
			{
				var settingVal = multiSelectSettings[cs];
				
				if(cs!=null && cs=="width")
				{
					outerContainerWidth=settingVal;
				}
				multiSelectCombo[cs]=settingVal;
			}
		}
		return {	
			xtype:'container',
			layout:{type:'vbox',align:'stretch'},
			//width : 290,
			width : outerContainerWidth,
			cls:'darkbox',
			margin: '5 5 0 0',
			//height:145,
			//height:180,
			height:defaltMultiSelectOuterContHeight,
			id:controlID+'MultiSelectOuterBox',
			items:[{
				xtype:'trigger',
				margin : '5',
				id : controlID+'SearchTextBox',
				name : controlID+'SearchTextBox',
				width : 228,
				cls: 'whitedropdown_search',
				emptyText : searchBoxEmptyText,
				controltStoreObj : null,
				listeners :
				{
					'change' : function(triggerField, newValue, oldValue, eOpts) {
						var me = this;
						var controlObjStore = me.controltStoreObj;
						if(controlObjStore==null)
						{
							me.controltStoreObj = this.up('form').getForm().findField(controlID+'Combo').getStore();
							controlObjStore=me.controltStoreObj;
						}
						if(newValue=="*")
						{
							controlObjStore.clearFilter();
						}
						else
						{
							if(newValue.lastIndexOf("*")==(newValue.length-1))
							{
								newValue = newValue.substr(0,(newValue.length-1));
							}
							controlObjStore.clearFilter();
							if (newValue) {
								var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
								controlObjStore.filter({
									filterFn: function(record) {
										return matcher.test(record.get('displayField')) ;
									}
								});
							}
						 triggerField.focus();
						}
					 }
				}
			},multiSelectCombo]
		};
},
fireComboSelection : function(comboObj,selectedValue)
{
	comboObj.setValue(selectedValue);
	comboObj.fireEvent('select',comboObj);
},

loadDefaultDataforScatterPlotConfigurationTab : function(selectedTab)
{
	var mePopup = this;
	var profileName = Ext.getCmp('dashboardLayoutObj').profileName;
	var metricsFormPanelObj = this.getComponent('configForm');
	var metricsForm = metricsFormPanelObj.getForm();

	 Ext.Ajax.request({
		url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
		method: 'POST',
		params: 'comesFrom=myDashboard&action=loadConfigPopup&profileName=' + profileName + '&blockId=' + mePopup.widgetID +'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height),
		scope: this,
		success: function (response) {
			var jsonText = response.responseText;
			if (jsonText != null && jsonText != '') {
				var jsonData = Ext.decode(jsonText);
				var configuredDetailsObj = jsonData['configuredDetails'];
				var selectedCompType = '';
				var selectedComp = '';
				var selectedTest = '';
				var selectedMeasure = '';
				var selectedDescriptor = '';

				var scatterTab_Obj=Ext.getCmp('scatterTab');
				
				if(selectedTab=='xAxis')
				{	
					configuredDetailsObj = jsonData['configuredDetails']['xAxisConfigJson'];
				}
				else if (selectedTab=='yAxis')
				{
					configuredDetailsObj = jsonData['configuredDetails']['yAxisConfigJson'];
				}

				if(scatterTab_Obj.xAxisConfigured && selectedTab == 'xAxis')
				{
					selectedCompType = scatterTab_Obj.xAxisCompType;
					selectedComp = scatterTab_Obj.xAxisComp;
					selectedTest = scatterTab_Obj.xAxisTest;
					selectedMeasure = scatterTab_Obj.xAxisMeas;
					selectedDescriptor = scatterTab_Obj.xAxisDesc;
				}
				else if(scatterTab_Obj.yAxisConfigured && selectedTab == 'yAxis')
				{
					selectedCompType = scatterTab_Obj.yAxisCompType;
					selectedComp = scatterTab_Obj.yAxisComp;
					selectedTest = scatterTab_Obj.yAxisTest;
					selectedMeasure = scatterTab_Obj.yAxisMeas;
					selectedDescriptor = scatterTab_Obj.yAxisDesc;
				}
				else
				{
					selectedCompType = configuredDetailsObj['selectedCompType'];
					selectedComp = configuredDetailsObj['selectedComp'];
					selectedTest = configuredDetailsObj['selectedTest'];
					selectedMeasure = configuredDetailsObj['selectedMeasure'];
					selectedDescriptor = configuredDetailsObj['selectedDescriptor'];
				}

				var compTypeCombo = metricsForm.findField('componentTypeCombo');
				var testCombo = metricsForm.findField('testCombo');
				var componentCombo = metricsForm.findField('componentCombo');

				compTypeCombo.suspendEvents(true);
				compTypeCombo.getStore().removeAll();
				compTypeCombo.getStore().loadRawData(jsonData['comptypes']);
				compTypeCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component Type']);
				compTypeCombo.resumeEvents();
				if(selectedCompType!=null && selectedCompType!='')
				{
					compTypeCombo.setValue(selectedCompType);
					compTypeCombo.fireEvent('select',compTypeCombo);
				}
				else
				{
					compTypeCombo.setValue('-1');
				}

				componentCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Component']);
				var componentComboStore = componentCombo.getStore();
				componentCombo.suspendEvents(true);
				componentComboStore.removeAll();
				if(selectedComp!=null && selectedComp!='')
				{
					componentComboStore.on('load', function(){ mePopup.fireComboSelection(componentCombo,selectedComp);  }, this, {
							single: true,
							delay: 100
						});
				}
				else
				{	
					componentComboStore.insert(0, {
						displayField: notApplicable,
						valueField: '-1',
						editedFieldName : notApplicable
					});
					componentCombo.setValue('-1');
				}
				componentCombo.resumeEvents();
				
				testCombo.suspendEvents(true);
				testCombo.getStore().removeAll();
				testCombo.setFieldLabel(jsonData['screenLabels']['monitor.common.Test']);
				if(selectedTest!=null && selectedTest!='')
				{
						testCombo.getStore().on('load', function(){ mePopup.fireComboSelection(testCombo,selectedTest);  }, this, {
							single: true,
							delay: 100
						});
				}
				else
				{
					testCombo.getStore().insert(0,{
						displayField:notApplicable,
						valueField: '-1'
					});
					testCombo.setValue('-1');
				}
				testCombo.resumeEvents();

				var measureCombo = metricsForm.findField('measureCombo');
				measureCombo.setFieldLabel(jsonData['screenLabels']['monitor.measures.Measures']);
		
				if(selectedMeasure!=null && selectedMeasure!='')
				{
					measureCombo.getStore().on('load', function(){ mePopup.fireComboSelection(measureCombo,selectedMeasure);  }, this, {
							single: true,
							delay: 100
					});
				}
				else
				{
					var measureComboStore = measureCombo.getStore();
					measureCombo.suspendEvents(true);
					measureComboStore.removeAll();
					measureComboStore.insert(0, {
						displayField: notApplicable,
						valueField: '-1',
						editedFieldName : notApplicable
					});
					measureCombo.setValue('-1');
				}

				var descriptorCombo = metricsForm.findField('descriptorCombo');
				descriptorCombo.suspendEvents(true);
				descriptorCombo.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Descriptor']);
		
				if(selectedDescriptor!=null && selectedDescriptor!='' && selectedDescriptor!='-1')
				{
					descriptorCombo.getStore().on('load', function(){ mePopup.fireComboSelection(descriptorCombo,selectedDescriptor);  }, this, {
							single: true,
							delay: 100
						});
				}
				else
				{
					var descriptorComboStore = descriptorCombo.getStore();
					descriptorCombo.suspendEvents(true);
					descriptorComboStore.removeAll();
					descriptorComboStore.insert(0, {
						displayField: notApplicable,
						valueField: '-1',
						editedFieldName : notApplicable
					});
					descriptorCombo.setValue('-1');
					descriptorCombo.resumeEvents();
				}
				Ext.defer(function(){
				var x_Axis_Obj=Ext.getCmp('x_Axis');
				var y_Axis_Obj=Ext.getCmp('y_Axis');
				x_Axis_Obj.setDisabled(false);
				y_Axis_Obj.setDisabled(false);
				},1000);
			}
		},
		failure : function()
		{

		}
	 });
},


loadPrevNextScreen : function(selectedButton)
{
	var mePopup = this;
	var nextPrevObj = null;
	var afterNextObj = 'empty';
	var beforePrevObj = 'empty';
	if(mePopup.needToUpdateCount)
	{
		mePopup.currentCount = mePopup.Kpicount;
		mePopup.needToUpdateCount=false;
	}

	var count = mePopup.currentCount;
	var dataArray = mePopup.KpiDataArray;
	var dataLength = dataArray.length;

	for ( i=0; i<dataLength; i++){

		var dataObj = dataArray[i];
		if(dataObj.innerWidgetId==count && selectedButton=='Previous')
		{
			if(i > 0)
			{
				mePopup.currentCount =  i;
				nextPrevObj = dataArray[i-1];
				beforePrevObj = dataArray[i-2];
				break;
			}
		}

		if(dataObj.innerWidgetId==count && selectedButton=='Next')
		{
			if(i < dataLength-1)
			{
				mePopup.currentCount =  count+1;
				nextPrevObj = dataArray[i+1];
				afterNextObj = dataArray[i+2];
				break;
			}
		}

	}

	var prevButtonObj = Ext.getCmp('prevButton');
	var nextButtonObj = Ext.getCmp('nextButton');

	if(nextPrevObj.isConfigured==true)
	{
		if(beforePrevObj == undefined)
		{		
			prevButtonObj.needToDisable=true;
		}
		else if(beforePrevObj == 'empty')
		{ 
			prevButtonObj.needToDisable=false;
		}
		else {
			prevButtonObj.needToDisable=false;
		}
		
		if(afterNextObj == undefined)
		{	
			nextButtonObj.needToDisable=true;
		}
		else if(nextButtonObj == 'empty')
		{ 
			nextButtonObj.needToDisable=false;
		}
		else {
			nextButtonObj.needToDisable=false;
		}
	}
	else if(nextPrevObj.isConfigured==false)
	{
		mePopup.setWidgetPopupTitle(addMetricsTitle);
	
		if(beforePrevObj == undefined)
		{		
			prevButtonObj.setDisabled(true);
		}
		else if(beforePrevObj == 'empty')
		{ 
			prevButtonObj.setDisabled(false);
		}
		else {
			prevButtonObj.setDisabled(false);
		}
		
		
		if(afterNextObj == undefined)
		{	
			nextButtonObj.setDisabled(true);
		}
		else if(nextButtonObj == 'empty')
		{ 
			nextButtonObj.setDisabled(false);
		}
		else {
			nextButtonObj.setDisabled(false);
		}
	}

	if(nextPrevObj != null)
	{
		var configSettingsObj = Ext.getCmp('configSettings');
		configSettingsObj.removeAll();

		var doneButtonObj = Ext.getCmp('doneButton');

		if(nextPrevObj.isConfigured==false)
		{
			mePopup.action = 'addWidget';
			configSettingsObj.add(nextPrevObj);
			doneButtonObj.setDisabled(true);
		}
		else if(nextPrevObj.isConfigured==true)
		{
			mePopup.action = 'editWidget';
			var chart = nextPrevObj.data.chartType;
			var chartId = nextPrevObj.data.chartId;
			var innerId = nextPrevObj.innerWidgetId;
			var isExternalDataSourceWidget = nextPrevObj.isExternalDataSourceWidget;
			var prevButtonObj = Ext.getCmp('prevButton');
			var nextButtonObj = Ext.getCmp('nextButton');

			prevButtonObj.setDisabled(true);
			nextButtonObj.setDisabled(true);

			mePopup.reLoadConfigurationWindow(chart,chartId,innerId,isExternalDataSourceWidget);
			doneButtonObj.setDisabled(false);
		}
	}
},


reLoadConfigurationWindow : function(chart,chartId,innerId,isExternalDataSourceWidget)
{
	var mePopup=this;
	mePopup.widgetID = chartId;
	mePopup.widgetType = chart;
	mePopup.Kpicount = innerId;
	mePopup.isKpi = true;
	mePopup.isExternalDataSourceWidget = isExternalDataSourceWidget;	

	if(isExternalDataSourceWidget)
	{
		var useExternalDataObj=Ext.getCmp('useExternalData');
		mePopup.removeAll();

		mePopup.add({
					xtype : 'addexternalmetrics',
					id : 'widgetChartAttrs',
					name : 'widgetChartAttrs',
					margin:'5 0 10 5',
					widgetID : mePopup.widgetID,
					widgetType : mePopup.widgetType,
					isKpi : mePopup.isKpi,
					Kpicount : mePopup.Kpicount,
					totalKpiCount : mePopup.totalKpiCount,
					kpiBlckId : mePopup.kpiBlckId
		});
						
		if(!Ext.isEmpty(useExternalDataObj))
		{
			var externalValue = useExternalDataObj.getValue();
			if(externalValue)
			{
				myDashApp.getController("WidgetConfigurationController").showWidgetPreviewAtPopupStartUp(chartId,isExternalDataSourceWidget);
			}
		}

		if(mePopup.isKpi)
		{
			Ext.defer(function(){

				if(!Ext.isEmpty(useExternalDataObj))
				{
					useExternalDataObj.setValue(true);
				}

				var prevButtonObj = Ext.getCmp('prevButton');
				var nextButtonObj = Ext.getCmp('nextButton');
				if(mePopup.Kpicount==1)
				{
					prevButtonObj.needToDisable = true;
					prevButtonObj.setDisabled(true);
				}

				if(mePopup.Kpicount==mePopup.totalKpiCount)
				{
					nextButtonObj.needToDisable = true;
					nextButtonObj.setDisabled(true);
				}			

				if(!prevButtonObj.needToDisable)
				{
					prevButtonObj.setDisabled(false);
				}

				if(!nextButtonObj.needToDisable)
				{	
					nextButtonObj.setDisabled(false);
				}
				
			},1000);
		}
		mePopup.doLayout();
	}
	else
	{
		mePopup.removeAll();
		mePopup.add(mePopup.createConfigurationWindowLayout(false));
		mePopup.loadDefaultDataforWidgetConfigurationWindow();
		
		var useExternalDataObj=Ext.getCmp('useExternalData');
		if(!Ext.isEmpty(useExternalDataObj))
		{
			var externalValue = useExternalDataObj.getValue();
			if(!externalValue)
			{
				mePopup.loadSampleSnippet(false);
			}
		}
		mePopup.doLayout();
	}
},

listeners : {
	show : function (win) {
		var showNextPrevButton =true;
		if(win.isKpi)
		{
			showNextPrevButton =false;
		}
		
		var prevBtn = Ext.create('Ext.Button', {
			width: 36,
			height: 36,
			x: -18,
			y: -179,
			padding:0,
			margin:0,
			id:'prevButton',
			iconCls : 'kpiWidgetPrevButton',
			renderTo: win.id,
			style: {
				'background': 'none !important',
				 'border': '0px solid green !important'
			},
			hidden : showNextPrevButton,
			listeners: {
				click: function(){
					win.loadPrevNextScreen('Previous');
				}
			}
			
		});
		var popnextBut = Ext.create('Ext.Button', {
			width: 36,	
			height: 36,
			padding:0,
			id:'nextButton',
			margin:0,
			x : Ext.get(win.id).getWidth()-55,
			y : -179,
			iconCls : 'kpiWidgetNextButton',
			renderTo: win.id,
			hidden : showNextPrevButton,
			style: {
				'background': 'none !important',
				 'border': '0px solid green !important'
			},
			listeners: {
				click: function(){
					win.loadPrevNextScreen('Next');
				}
			}
			
		});
	}
}
});
