Ext.define('MyDashBoard.view.fluidWindow', {
	extend:'Ext.window.Window',
	alias:'widget.fluidwindow',
	shrinkWrap:true,
	shadow:false,
	containerScroll : true,
	constrain: true,
	constrainHeader: true,
	autoDestroy:true,
	bodyPadding:'0',
	needToDeleteWindow : false,
	ghost:false,
	bodyCls:'getMypro',
	margin:0,
	blkType : '',
	highChartObj : null,
	hideMaxmizeIcon : false,
	isRequestTimeoutHappened : false,
	layout:{
		type:'vbox',
		align:'stretch'
	},
	defaults:{
		flex:1	
	},
	draggable : true,
	padding:0,
	resizeHandles:'se',
	resizable:{
		
		heightIncrement:1,
		widthIncrement:1
    },
	cls:'fluidwindow',
	closeAction:'destroy',
	isInitialResizeCompleted : false,
	layerModelUrl : null, // this is used for dial,digital, and pie charts
	selectedGraphPalette : null,
	initComponent : function()
	{
		var thisBlkId = this.id;
		var toolsArr = new Array();
		var includeSettingsIcon=false;
		if(thisBlkId!=null && thisBlkId.indexOf("_")>0)
		{
			var blockType = thisBlkId.substr(0,thisBlkId.indexOf("_"));
			if(blockType!=null && (blockType=='BarChart' || blockType=='TimelineChart' || blockType=='CombinedTimelineChart' || blockType=='areaChart'))
			{
				toolsArr.push({
					xtype : 'button',
					cls:'dragTools',
					height:16,
					width:16,
					margin:'0 3 0 0',
					iconCls:'colorTool',
					blockId : thisBlkId,
					handler : function()
					{
						this.selectedGraphPalette=this.up('window').selectedGraphPalette;
						myDashApp.getController("Main").showPaletteWindow(this);
					}
				});
			}
			includeSettingsIcon=true;

		}
		else if(thisBlkId!=null && thisBlkId=='news')
		{
			includeSettingsIcon=true;
		}
		if(includeSettingsIcon)
		{
			toolsArr.push({
				type: 'gear',
				margin:'0 3 0 0',
				handler : function()
				{
					myDashApp.getController("Main").fluidWindowModifyClick(this);
				}
			});
		}
		this.tools = toolsArr;
		this.addListener("beforeclose",this.beforeclosefn);
		this.addListener("afterrender",this.changeTitle);
		this.callParent();
	},
	'changeTitle':function(){
		var me =this;
		var dragedColHeader =Ext.get(me.header.id+'_hd-textEl');
		Ext.get(me.header.id).on('dblclick', function(e,target){

						var edtrText=dragedColHeader.dom.innerHTML;
						var editedblck=me.id;	
						var timelineTxt='';
						if(editedblck!=null && editedblck.lastIndexOf("_")>0)
						{
							editedblck=editedblck.substring(0,editedblck.lastIndexOf("_"));
							if(editedblck!=null && (editedblck=="TimelineChart" || editedblck=="CombinedTimelineChart"))
							{
								if(edtrText!=null && edtrText.lastIndexOf("-")>0)
								{
									timelineTxt=edtrText.substring(edtrText.lastIndexOf("-")+1);
									timelineTxt=Ext.util.Format.trim(timelineTxt);
									edtrText=edtrText.substring(0,edtrText.lastIndexOf("-"));
									edtrText=Ext.util.Format.trim(edtrText);
								}
							}
						}
						var editor = new Ext.Editor({
						width: 150,
                        alignment: 'tl',
                        floating: false,
                        shadow: false,
                        updateEl: true,
						ignoreNOChange: true,
                        completeOnEnter: true,
                        cancelOnEsc: true,
						field: {
							xtype: 'textfield',
							cls: 'headerTextEdit'
						},
                        listeners: {
                            'beforecomplete': function (meEdtr, value, startValue, eOpts) {
                                if (value == null || value == '') {
                                    meEdtr.setValue(startValue);
                                    Ext.Msg.show({
                                        title: myDashboardAlertLbl,
                                        msg: emptyHeadrMsg,
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.WARNING
                                    });
                                    return false;
                                }
                            },
                            'complete': function (meEdtr, value, startValue, eOpts) {
                                var profileName = Ext.getCmp('fluidDashLayout').profileName;
                                Ext.Ajax.request({
                                    url: '/final/servlet/com.eg.egMyDashboardController',
                                    method: 'POST',
                                    params: '&action=rename&profileName=' + encodeURIComponent(profileName) + '&key=' + me.id + '_Title&value=' + encodeURIComponent(value),
                                    success: function (response) {
                                        var jsonText = response.responseText;
                                        if (jsonText != null && jsonText != '') {
                                            var jsonData = Ext.decode(jsonText);
										if(editedblck!=null && (editedblck=="TimelineChart" || editedblck=="CombinedTimelineChart"))
										{
											if(timelineTxt!=null && timelineTxt!="")
											{
												dragedColHeader.dom.innerHTML=value+" - "+timelineTxt;
                                        }
                                    }
									}
								}
                                });

                            }
                        }
					});
					var el = Ext.get(me.header.id+'_hd-textEl');
					editor.startEdit(el,edtrText);
					
			}, me, {
				 delegate: '#'+me.header.id+'_hd-textEl'
			});
			editor = null;
	},
	'beforeclosefn' : function(winObj)
	{
		
		var blockTitle = winObj.title;
				var blockId = winObj.id;
		if(!winObj.needToDeleteWindow)
		{
				Ext.Msg.show({
				title:myDashboardAlertLbl,
				msg:deleteBlockMsg+'?',
				buttons: Ext.Msg.YESNO,
				icon: Ext.Msg.QUESTION,
				fn:function(buttonId)
				{
					if(buttonId =="yes")
					{						
						if(blockId=='news'){
                                                    Ext.getCmp('newsView').hide();
						}else if(blockId=='weather'){
						    Ext.getCmp('weatherView').hide();  
						}
						var paramsForDeleteBlock = 'action=deleteTable&profileName='+Ext.getCmp('fluidDashLayout').profileName+'&key='+blockId;
						Ext.Ajax.request({
									url: '/final/servlet/com.eg.egMyDashboardController',
									method: 'POST',
									params: paramsForDeleteBlock,
									scope: this,
									success: function (response) {
										var configIds = publicJson['myDashboardConfigDetails']['configIds'];
										if(configIds!=null && configIds.indexOf(blockId)>-1)
										{
											var tempConfgIdArr=new Array();
											for(var t=0;t<configIds.length;t++)
											{
												var blkItm=configIds[t];
												if(blkItm!=null && blkItm!=blockId)
												{
													tempConfgIdArr.push(blkItm)
												}
											}
										//	configIds=tempConfgIdArr;
											publicJson['myDashboardConfigDetails']['configIds']=tempConfgIdArr;
										}
										winObj.needToDeleteWindow=true;
										winObj.close();
									},
									failure : function(response, opts) {
										winObj.needToDeleteWindow=false;
									}
						});
					}
				}
				});	
		}
		return winObj.needToDeleteWindow;
	}
});