Ext.define('MyDashBoard.view.freeWindow', {
    alias: 'widget.freeWindow',
    extend: 'Ext.panel.Panel',
    padding: 0,
    bodyPadding: 0,
    margin: 0,
    //cls: 'fluidPanel',
    overlapHeader: false,
   // bodyCls: 'fluidPanelBody',
	ui:'x-panel-newGraphPanel',
    border: false,
    frame: false,
    closeAction: 'destroy',
	isPreview : false,
	//shadow:false,
	//draggable:false,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
	panlCntr : 0,
	nextRefreshTime : new Date().getTime(),
	lastRefreshedTime : new Date().getTime(),
    defaults: {
        flex: 1
    },
   // resizeHandles: 'se',
  /*  resizable: {

        heightIncrement: 4,
        widthIncrement: 4
    },*/
    initComponent: function() {
        var thisBlkId = this.id;
        var toolsArr = [];
        var includeSettingsIcon = false;
		this.suspendEvents(false);
		if(this.isPreview)
		{
			if (thisBlkId != null && thisBlkId.indexOf("_") > 0) {
				var blockType = thisBlkId.substr(0, thisBlkId.indexOf("_"));
				if(blockType!=null && (blockType=='BarChart' || blockType=='table'))
				{
					toolsArr.push({
								xtype: 'scrollcombo',
								fieldLabel : showLbl,
						//		id : 'showCombo_'+new Date().getTime(),
								itemId : thisBlkId+'_combo',
								hidden : true,
								height:20,
								labelStyle:'margin:-5px 0px 0px 0px',
								cls: 'dropdown',
								labelSeparator : '',
								labelWidth : 35,
								width: 120,
								margin:'0 0 0 0',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: []
								}),
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								listeners :  
								{
									'select' : function(combo) {
									myDashApp.getController("Main").showTopNGraph(combo.getValue(),combo.up('panel'));
									}
								}

							});
				
				}
				else if(blockType!=null && blockType=='ddTable')
				{
					toolsArr.push({
								xtype: 'scrollcombo',
								fieldLabel : descLbl,
						//		id : 'showCombo_'+new Date().getTime(),
								itemId : thisBlkId+'_combo',
								hidden : true,
								cls: 'dropdown',
								labelSeparator : '',
								labelWidth : 60,
								width: 220,
								height:20,
								labelStyle:'margin:-5px 0px 0px 0px',
								margin:'0 0 0 0',
								store: Ext.create('Ext.data.Store', {
									fields: ['displayField','valueField'],
									data: []
								}),
								editable:false,
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								listeners :  
								{
									'select' : function(combo) {
									myDashApp.getController("Main").showDDForSelectedDescptr(combo.getValue(),combo.up('panel'));
									}
								}

							});
				}
				else if(blockType!=null && blockType=='vmAlarmsWidget')
				{
					toolsArr.push({
						xtype:'trigger',
						id : 'searchVms_'+thisBlkId,
						name : 'searchVms_'+thisBlkId,
						labelWidth:40,
						fieldLabel:'',
						cls: 'whitedropdown_search',
						emptyText:'Search',
						//hidden : true,
						listeners: {
							 change: {
								 fn: this.onTextFieldChange,
								 scope: this,
								 buffer: 100
							 }
						 }
					});
				}
			}
		}
		else
		{
			if(thisBlkId!=null && thisBlkId.indexOf("_")>0)
			{
				var blockType = thisBlkId.substr(0,thisBlkId.indexOf("_"));
				if(blockType!=null && (blockType=='BarChart' || blockType=='TimelineChart' || blockType=='CombinedTimelineChart' || blockType=='areaChart' || blockType=='combinationChart' || blockType=='heatMapChart'))
				{
					toolsArr.push({
						xtype : 'button',
						cls:'dragTools',
						height:16,
						width:16,
						margin:'-3 3 0 0',
						iconCls:'colorTool',
						tooltip : changeGraphColorPaletteLbl,
						blockId : thisBlkId,
						handler : function()
						{
							this.selectedGraphPalette=this.up('panel').selectedGraphPalette;
							myDashApp.getController("Main").showPaletteWindow(this);
						}
					});
				}
				includeSettingsIcon=true;

			}
		else if(thisBlkId!=null && thisBlkId=='news')
			{
				includeSettingsIcon=true;
			}
			if(includeSettingsIcon)
			{
				toolsArr.push({
					type: 'gear',
				 	margin: '0px 3px 0px 0px',
					tooltip : editWidgetLbl,
					handler : function()
					{
						myDashApp.getController("Main").fluidWindowModifyClick(this);
					}
				});
			}
			toolsArr.push({
				type: 'close',
				margin: '0px 0px 0px 0px',
				tooltip : rmvBlkLbl,
				handler: function() {
					var freePnlObj=this.up('panel');
					Ext.Msg.show({
						title: myDashboardAlertLbl,
						msg: deleteBlockMsg + '?',
						buttons: Ext.Msg.YESNO,
						width:300,
						icon:'iconConfirmation',
						fn: function(buttonId) {
							if (buttonId == "yes") {
								
								var blockTitle = freePnlObj.title;
								var blockId = freePnlObj.id;
								var paramsForDeleteBlock = 'action=deleteTable&profileName=' + Ext.getCmp('fluidDashLayout').profileName + '&key=' + blockId;
								if(blockId=='news'){
									var newsViewObj= Ext.getCmp('newsView');
									if(!Ext.isEmpty(newsViewObj))
		                                                    		newsViewObj.hide();
									newsViewObj=null;
									delete newsViewObj;
								}else if(blockId=='weather'){								    
								    	var weatherViewObj= Ext.getCmp('weatherView');
									if(!Ext.isEmpty(weatherViewObj))
		                                                    		weatherViewObj.hide();
									weatherViewObj=null;
									delete weatherViewObj;
								}
								Ext.Ajax.request({
									url: '/final/servlet/com.eg.egMyDashboardController',
									method: 'POST',
									params: paramsForDeleteBlock,
									scope: this,
									success: function(response) {
										freePnlObj.close();
										freePnlObj=null;
										delete freePnlObj;
										var configIds = publicJson['myDashboardConfigDetails']['configIds'];
										if (configIds != null && configIds.indexOf(blockId) > -1) {
											var tempConfgIdArr = new Array();
											for (var t = 0; t < configIds.length; t++) {
												var blkItm = configIds[t];
												if (blkItm != null && blkItm != blockId) {
													tempConfgIdArr.push(blkItm)
												}
											}
											//	configIds=tempConfgIdArr;
											publicJson['myDashboardConfigDetails']['configIds'] = tempConfgIdArr;
											Ext.destroy(Ext.getCmp(blockId));
										}
									}
								});
								
							}
							else
							{
								freePnlObj=null;
								delete freePnlObj;
							}
						}
					});
				}
			});
	        this.addListener("afterrender",this.changeTitle);
		}
        this.tools = toolsArr;
        //this.addListener("beforeclose",this.beforeclosefn);
		this.resumeEvents();
        this.callParent();

    },
    blkType: '',
    highChartObj: null,
    hideMaxmizeIcon: false,
    isRequestTimeoutHappened: false,
    isInitialResizeCompleted: false,
    layerModelUrl: null, // this is used for dial,digital, and pie charts
    selectedGraphPalette: null,
	changeTitle:function(){
		var me =this;
		var dragedColHeader =Ext.get(me.header.id+'_hd-textEl');
		Ext.get(me.header.id).on('dblclick', function(e,target){

						var edtrText=dragedColHeader.dom.innerHTML;
						var editedblck=me.id;	
						var timelineTxt='';
						if(editedblck!=null && editedblck.lastIndexOf("_")>0)
						{
							editedblck=editedblck.substring(0,editedblck.lastIndexOf("_"));
							if(editedblck!=null && (editedblck=="TimelineChart" || editedblck=="CombinedTimelineChart" || editedblck=="areaChart" || editedblck=="combinationChart"))
							{
								if(edtrText!=null && edtrText.lastIndexOf("-")>0)
								{
									timelineTxt=edtrText.substring(edtrText.lastIndexOf("-")+1);
									timelineTxt=Ext.util.Format.trim(timelineTxt);
									edtrText=edtrText.substring(0,edtrText.lastIndexOf("-"));
									edtrText=Ext.util.Format.trim(edtrText);
								}
							}
						}
						var editor = new Ext.Editor({
						width: 150,
                        alignment: 'tl',
                        floating: false,
                        shadow: false,
                        updateEl: true,
						ignoreNOChange: true,
                        completeOnEnter: true,
                        cancelOnEsc: true,
						field: {
							xtype: 'textfield',
							cls: 'headerTextEdit'
						},
                        listeners: {
                            'beforecomplete': function (meEdtr, value, startValue, eOpts) {
                                if (value == null || value == '') {
                                    meEdtr.setValue(startValue);
                                    Ext.Msg.show({
                                        title: myDashboardAlertLbl,
                                        msg: emptyHeadrMsg,
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.WARNING
                                    });
                                    return false;
                                }
                            },
                            'complete': function (meEdtr, value, startValue, eOpts) {
                                var profileName = Ext.getCmp('fluidDashLayout').profileName;
                                Ext.Ajax.request({
                                    url: '/final/servlet/com.eg.egMyDashboardController',
                                    method: 'POST',
                                    params: '&action=rename&profileName=' + encodeURIComponent(profileName) + '&key=' + me.id + '_Title&value=' + encodeURIComponent(value),
                                    success: function (response) {
                                        var jsonText = response.responseText;
                                        if (jsonText != null && jsonText != '') {
                                            var jsonData = Ext.decode(jsonText);
										if(editedblck!=null && (editedblck=="TimelineChart" || editedblck=="CombinedTimelineChart"))
										{
											if(timelineTxt!=null && timelineTxt!="")
											{
												dragedColHeader.dom.innerHTML=value+" - "+timelineTxt;
                                        }
                                    }
									}
								}
                                });

                            }
                        }
					});
					var el = Ext.get(me.header.id+'_hd-textEl');
					editor.startEdit(el,edtrText);
					
			}, me, {
				 delegate: '#'+me.header.id+'_hd-textEl'
			});
			editor = null;
	},
	onTextFieldChange: function(triggerField, newValue, oldValue, eOpts) {
        var me = this;
		var thisBlkId = this.id;
		var grid = Ext.getCmp(thisBlkId+'_Grid');
		if(newValue=="*")
		{
			grid.store.clearFilter();
		}
		else
		{
			if(newValue.lastIndexOf("*")==(newValue.length-1))
			{
				newValue = newValue.substr(0,(newValue.length-1));
			}
			grid.store.clearFilter();
			if (newValue) {
				var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
				grid.store.filter({
					filterFn: function(record) {
						var stateNameArray = record.get('vmName').split("!*!");
						var match= matcher.test(stateNameArray[1]) ;
						if(!match)
							match= matcher.test(record.get('CompName')) ;
						
						return match;
					}
				});
			}
		triggerField.focus();
		}
     }

});