Ext.define('netscaler.view.gaugeChart', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.gaugechart',
	ui: 'newGraphPanel',
	height: 300,
	//margin: '5 5 10 10',
	margin: '5 6 0 0',
	padding: '0 0 0 0',
	columnWidth: .6,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	items: [{
		xtype: 'container',
		margin: '10 0 5 10',
		flex: .7,
		layout: {
			type: 'hbox',
			align: 'stretch'
		},
		listeners:
		{
			afterrender: function(dialObj)
			{
				var dialData = jsonData['DialMetrics'];		
				for(var i=0; i< dialData.length; i++)
				{
					var dialMetrics = dialData[i];
					var errorMsg = dialMetrics['ErrorMsg'];
					if(errorMsg!=null && errorMsg == '-')
					{
						dialObj.add({
							xtype: 'fieldset',
							id:'dialchart_'+i,
							title: dialMetrics['Title'],
							ui:'gaugeChartFieldSet',
							dialMetricsdata : dialMetrics,
							height: 200,
							margin: '0 10 5 0',
							flex: 1,
							listeners: {
								'resize': function (e) {
									Ext.select('legend').set({ align: "center" }); //Fix - Legent Center for firefox browser.
									if (strSkin=="Light")
									{
										highchartBgColor="#e2e2e2";
									}
									else if (strSkin=="Dark")
									{
										highchartBgColor="#616161";
									}

									if ($('#' + e.body.id)) {
										$('#' + e.body.id).highcharts({
											chart: {
												type: 'solidgauge',
												backgroundColor:'transparent',
												events: {
													// render: renderIcons
												}
											},
											title: {
												text: ''
											},

											tooltip: {
												enabled: false
											},
											exporting: {
												enabled: false
											},
											credits: {
												enabled: false
											},
											pane: {
												startAngle: 0,
												endAngle: 360,
												background: [{ // Track for Move
													outerRadius: '110%',
													innerRadius: '96%',
													backgroundColor: Highcharts.Color(highchartBgColor)
														.setOpacity(0.8)
														.get(),
													borderWidth: 0
												},]
											},

											yAxis: {
												stops:e.dialMetricsdata['stopsArr'],
												min: 0,
												max: e.dialMetricsdata['maxValueForDial'],
												lineWidth: 0,
												tickPositions: []
											},

											plotOptions: {
												solidgauge: {
													dataLabels: {
														enabled: false
													},
													linecap: 'round',
													stickyTracking: false,
													rounded: true
												}
											},

											series: [{
												name: 'Move',
												data: [{
													color:e.dialMetricsdata['guageData']['color'],
													radius: '110%',
													innerRadius: '96%',
													y: e.dialMetricsdata['guageData']['data'][0]
												}]
											}]
										}, function () {
											
											if (Ext.isGecko) //Fix - Value Center for firefox browser.
											{
												var valueDiv = '<div onclick="javascript:wayToLayerModel(\''+e.dialMetricsdata['LayerURL']+'\');" class="data_center" style="width:80px;height:80px;background:transparent;"><div class="labelRobotonormalCls" style="font-size:24px;margin-top:35px">' + e.dialMetricsdata['guageData']['data'][0] + '<span class="newFont_normal17">%</span></div></div>';
											}
											else
											{
												var valueDiv = '<div onclick="javascript:wayToLayerModel(\''+e.dialMetricsdata['LayerURL']+'\');" class="data_center" style="width:80px;height:80px;background:transparent;"><div class="labelRobotonormalCls" style="font-size:24px;margin-top:54px">' + e.dialMetricsdata['guageData']['data'][0] + '<span class="newFont_normal17">%</span></div></div>';
											}
											//var valueDiv = '<div onclick="javascript:wayToLayerModel(\''+e.dialMetricsdata['LayerURL']+'\');" class="data_center" style="width:80px;height:80px;background:transparent;"><div class="labelRobotonormalCls" style="font-size:24px;margin-top:54px">' + e.dialMetricsdata['guageData']['data'][0] + '<span class="newFont_normal17">%</span></div></div>';
											$("#" + e.body.id).append(valueDiv);

										});
									}
								}
							}
						});
					}
					else
					{
						dialObj.add({
							xtype: 'fieldset',
							id:'dialchart_'+i,
							title: dialMetrics['Title'],
							ui:'gaugeChartFieldSet',
							height: 200,
							margin: '0 10 5 0',
							flex: 1,
							
								html:'<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" ><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>' + errorMsg	+ '!</div></td></tr></table>'
						});
					}
				}	
			}
		}	
	}, {
		xtype: 'container',
		border: true,
		margin: '5 10 10 10',
		id:'textId',
		listeners: {
			afterrender: function()
			{
				var textdata = Ext.getCmp('mainId').data;
				var textHtml = '<div class="newTable">'
								+'<table  width="100%">'
									+'<thead>'
										+'<tr>';											
										textHtml = textHtml+'<th>'+textdata[0]['Title']+'</th>';
										textHtml = textHtml+'<th>'+textdata[2]['Title']+'</th>';
											
										textHtml = textHtml+'</tr>';
										textHtml = textHtml+'</thead>';						
										textHtml = textHtml+'<tbody>';
										textHtml = textHtml+'<tr>';
										textHtml = textHtml+'<td width="50%" style="padding:0px;" class="newLineRight">';

											if(textdata[0]['ErrorMsg']=='-')
											{
												textHtml = textHtml+'<div onclick="javascript:wayToLayerModel(\''+textdata[0]['LayerURL']+'\');" style="float:left;width:50%;padding:10px;cursor:pointer" class="newLineRight">'+inLbl+' <span class="newFont_normal21">'+textdata[0]['Value']+'</span></div>';
											}
											else
											{
												textHtml = textHtml+'<div style="float:left;width:50%;padding:10px;" class="newLineRight">'+inLbl+' <span style="margin-left:20px">-</span></div>';
											}

											if(textdata[1]['ErrorMsg']=='-')
											{
												textHtml = textHtml+'<div onclick="javascript:wayToLayerModel(\''+textdata[1]['LayerURL']+'\');" style="float:right;width:50%;padding:10px;cursor:pointer">'+outLbl+' <span class="newFont_normal21">'+textdata[1]['Value']+'</span></div>';
											}
											else
											{
												textHtml = textHtml+'<div style="float:left;width:50%;padding:10px;" class="newLineRight">'+outLbl+' <span style="margin-left:20px">-</span></div>';
											}

											textHtml = textHtml+'</td>';
											textHtml = textHtml+'<td width="50%" style="padding:0px" >';

												if(textdata[2]['ErrorMsg']=='-')
												{
													textHtml = textHtml+'<div onclick="javascript:wayToLayerModel(\''+textdata[2]['LayerURL']+'\');" style="float:left;width:50%;padding:10px;cursor:pointer" ><span class="newFont_normal21">'+textdata[2]['Value']+'</span></div>';
												}
												else
												{
													textHtml = textHtml+'<div style="float:left;width:50%;padding:10px;"><span class="newFont_normal21" style="margin-left:20px">-</span></div>';
												}
											textHtml = textHtml+'</td>';
										textHtml = textHtml+'</tr>';
									textHtml = textHtml+'</tbody>';
								textHtml = textHtml+'</table>';
							textHtml = textHtml+'</div>';
				this.update(textHtml);
			}
		},
		flex: .3
	}]
});