Ext.define('netscaler.view.lineChart', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.linechart',
	height: 300,
	ui: 'newGraphPanel',
	margin: '5 10 10 5',
	bodyPadding: 10,
	columnWidth: .4,
	id:'LineChartId',
	listeners: {
		'resize': function (lineObj) {
			if ($('#' + lineObj.body.id)) {
				Ext.getCmp('LineChartId').setTitle(jsonData['LineChartTitle']);
				Ext.Ajax.request({
					url: jsonData['measureGraphUrl'] ,
					scope: this,
					async: false,
					success: function (response)
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;

							if ( jsonText.indexOf('png') == -1 && jsonText.indexOf('PNG') == -1 && jsonText.indexOf('gif') == -1 && jsonText.indexOf('GIF') == -1 && (jsonText.indexOf('iconExclamation') == -1 || jsonText.indexOf('iconInformation') == -1))
							{
								var jsonData = Ext.decode(jsonText);
								try
								{	
									var width = lineObj.getWidth();
									var height = lineObj.getHeight();
									jsonData["isNetscalerTopology"]=true;
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, getHighCharts(lineObj.body.id, (height-50),(width-50),''), lineChart);
									lineChart.setData(jsonData,currentDateFormat,'',true,'right');
									lineChart.drawChart();
								}
								catch (e)
								{
									alert("e::"+e)
								}
							}
							else
							{	
								lineObj.add({
									xtype:'container', 
									height:'100%',
									html:'<table border="0px" cellspacing="0" cellpadding="0" width="100%" height="100%" ><tr><td  align="center" valign="middle" class="msgFont"><div class="iconInformation"></div><div>No Measure Available!</div></td></tr></table>',
								});
							}
						}
					}
				});	
			}
		}
	}
});