/*var dataSampleFinal = {
	"paper": {
		"skin": "Light"
	},
	"nodes": [
            {
                "0": {
                    "serverType": "USER",
                    "componentName": "none",
                    "displayName": "Client",
                    "drillDownUrl": "none"
                },
                "1": {
                    "serverType": "WEB",
                    "displayName": "Internet",
                    "drillDownUrl": "none",
                    "componentName": "none"
                },
                "2": {
                    "serverType": "VIRTUAL_SERVERS",
                    "Tooltip": "Virtual Server : _XM_LB_MDM_XenMobileMDM_192.168.10.119_443",
                    "displayName": "_XM_LB_MDM_XenMobileMDM_192.168.10.119_443",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsLBTest-_XM_LB_MDM_XenMobileMDM_192.168.10.119_443&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_LOW"
                },
                "3": {
                    "serverType": "SERVICE_GROUP",
                    "Tooltip": "Service Group : _XM_SVC_GRP_MDM_443",
                    "displayName": "_XM_SVC_GRP_MDM_443",
                    "componentName": "none",
                    "state": "state_LOW",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsSvcGMemTest-_XM_SVC_GRP_MDM_443%3A192.168.10.89%3A443&tstate=&compName=Netscaler240%3ANULL&msmt_host="
                },
                "4": {
                    "serverType": "NODES",
                    "displayName": "none",
                    "Tooltip": "Service Type : SSL_BRIDGE",
                    "componentName": "192.168.10.89:443 (SSL_BRIDGE)",
                    "drillDownUrl": "none",
                    "state": "state_LOW",
                    "serviceTypeforGrps": "SSL_BRIDGE"
                },
                "5": {
                    "serverType": "VIRTUAL_SERVERS",
                    "Tooltip": "Virtual Server : _XM_LB_MDM_XenMobileMDM_192.168.10.119_8443",
                    "displayName": "_XM_LB_MDM_XenMobileMDM_192.168.10.119_8443",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsLBTest-_XM_LB_MDM_XenMobileMDM_192.168.10.119_8443&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_LOW"
                },
                "6": {
                    "serverType": "SERVICE_GROUP",
                    "Tooltip": "Service Group : _XM_SVC_GRP_MDM_8443",
                    "displayName": "_XM_SVC_GRP_MDM_8443",
                    "componentName": "none",
                    "state": "state_LOW",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsSvcGMemTest-_XM_SVC_GRP_MDM_8443%3A192.168.10.89%3A8443&tstate=&compName=Netscaler240%3ANULL&msmt_host="
                },
                "7": {
                    "serverType": "NODES",
                    "displayName": "none",
                    "Tooltip": "Service Type : SSL_BRIDGE",
                    "componentName": "192.168.10.89:8443 (SSL_BRIDGE)",
                    "drillDownUrl": "none",
                    "state": "state_LOW",
                    "serviceTypeforGrps": "SSL_BRIDGE"
                },
                "8": {
                    "serverType": "VIRTUAL_SERVERS",
                    "Tooltip": "Virtual Server : _XM_MAM_LB_192.168.10.118_8443",
                    "displayName": "_XM_MAM_LB_192.168.10.118_8443",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsLBTest-_XM_MAM_LB_192.168.10.118_8443&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_LOW"
                },
                "9": {
                    "serverType": "SERVICE_GROUP",
                    "Tooltip": "Service Group : _XM_SVC_GRP_MAM_",
                    "displayName": "_XM_SVC_GRP_MAM_",
                    "componentName": "none",
                    "state": "state_LOW",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsSvcGMemTest-_XM_SVC_GRP_MAM_%3A192.168.10.89%3A8443&tstate=&compName=Netscaler240%3ANULL&msmt_host="
                },
                "10": {
                    "serverType": "NODES",
                    "displayName": "none",
                    "Tooltip": "Service Type : SSL",
                    "componentName": "192.168.10.89:8443 (SSL)",
                    "drillDownUrl": "none",
                    "state": "state_LOW",
                    "serviceTypeforGrps": "SSL"
                },
                "11": {
                    "serverType": "VIRTUAL_SERVERS",
                    "Tooltip": "Virtual Server : EG-HTTP",
                    "displayName": "EG-HTTP",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsLBTest-EG-HTTP&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_GOOD"
                },
                "12": {
                    "serverType": "SERVICE_GROUP",
                    "Tooltip": "Service Group : Test-Group",
                    "displayName": "Test-Group",
                    "componentName": "none",
                    "state": "state_LOW",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsSvcGMemTest-Test-Group%3A192.168.9.38%3A80&tstate=&compName=Netscaler240%3ANULL&msmt_host="
                },
                "13": {
                    "serverType": "NODES",
                    "displayName": "none",
                    "Tooltip": "Service Type : HTTP",
                    "componentName": "192.168.8.67:80 (HTTP)",
                    "drillDownUrl": "none",
                    "state": "state_GOOD",
                    "serviceTypeforGrps": "HTTP"
                },
                "14": {
                    "serverType": "NODES",
                    "displayName": "none",
                    "Tooltip": "Service Type : HTTP",
                    "componentName": "192.168.9.38:80 (HTTP)",
                    "drillDownUrl": "none",
                    "state": "state_LOW",
                    "serviceTypeforGrps": "HTTP"
                },
                "15": {
                    "serverType": "SERVICE_GROUP",
                    "Tooltip": "Service Group : Tes-Group2",
                    "displayName": "Tes-Group2",
                    "componentName": "none",
                    "state": "state_GOOD",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsSvcGMemTest-Tes-Group2%3A192.168.9.98%3A80&tstate=&compName=Netscaler240%3ANULL&msmt_host="
                },
                "16": {
                    "serverType": "NODES",
                    "displayName": "none",
                    "Tooltip": "Service Type : HTTP",
                    "componentName": "192.168.9.98:80 (HTTP)",
                    "drillDownUrl": "none",
                    "state": "state_GOOD",
                    "serviceTypeforGrps": "HTTP"
                },
                "17": {
                    "serverType": "SERVICE",
                    "Tooltip": "Service : Tomcat",
                    "displayName": "Tomcat",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsServiceTest-Tomcat&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_GOOD"
                },
                "18": {
                    "serverType": "NODES",
                    "drillDownUrl": "none",
                    "Tooltip": "Service Type : HTTP",
                    "displayName": "192.168.8.246:8787 (HTTP)",
                    "componentName": "none",
                    "state": "state_GOOD"
                },
                "19": {
                    "serverType": "SERVICE",
                    "Tooltip": "Service : Bugtracker",
                    "displayName": "Bugtracker",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsServiceTest-Bugtracker&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_GOOD"
                },
                "20": {
                    "serverType": "NODES",
                    "drillDownUrl": "none",
                    "Tooltip": "Service Type : HTTP",
                    "displayName": "192.168.10.110:80 (HTTP)",
                    "componentName": "none",
                    "state": "state_GOOD"
                },
                "21": {
                    "serverType": "VIRTUAL_SERVERS",
                    "Tooltip": "Virtual Server : Helpdesk",
                    "displayName": "Helpdesk",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsLBTest-Helpdesk&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_LOW"
                },
                "22": {
                    "serverType": "SERVICE",
                    "Tooltip": "Service : eGontap",
                    "displayName": "eGontap",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsServiceTest-eGontap&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_GOOD"
                },
                "23": {
                    "serverType": "NODES",
                    "drillDownUrl": "none",
                    "Tooltip": "Service Type : HTTP",
                    "displayName": "192.168.9.129:80 (HTTP)",
                    "componentName": "none",
                    "state": "state_GOOD"
                },
                "24": {
                    "serverType": "SERVICE",
                    "Tooltip": "Service : Infra-Manager",
                    "displayName": "Infra-Manager",
                    "drillDownUrl": "/final/servlet/com.eg.EgDashboardController?from=list&tab=LayerModel&toDashBoardLayer=true&qctr=2&fromPage=netscaler&fromalarm=null&host=Netscaler240%3ANULL&comptype=Citrix_NetScaler&layer=CTX_NS_LB&site=NULL&test=CtxNsServiceTest-Infra-Manager&tstate=&compName=Netscaler240%3ANULL&msmt_host=",
                    "componentName": "none",
                    "state": "state_GOOD"
                },
                "25": {
                    "serverType": "NODES",
                    "drillDownUrl": "none",
                    "Tooltip": "Service Type : HTTP",
                    "displayName": "192.168.10.233:80 (HTTP)",
                    "componentName": "none",
                    "state": "state_GOOD"
                }
            }
        ],
        "links": [
            {
                "source": 0,
                "target": 1
            },
            {
                "source": 1,
                "target": 2
            },
            {
                "source": 2,
                "target": 3
            },
            {
                "source": 3,
                "target": 4
            },
            {
                "source": 1,
                "target": 5
            },
            {
                "source": 5,
                "target": 6
            },
            {
                "source": 6,
                "target": 7
            },
            {
                "source": 1,
                "target": 8
            },
            {
                "source": 8,
                "target": 9
            },
            {
                "source": 9,
                "target": 10
            },
            {
                "source": 1,
                "target": 11
            },
            {
                "source": 11,
                "target": 12
            },
            {
                "source": 12,
                "target": 13
            },
            {
                "source": 12,
                "target": 14
            },
            {
                "source": 11,
                "target": 15
            },
            {
                "source": 15,
                "target": 16
            },
            {
                "source": 11,
                "target": 17
            },
            {
                "source": 17,
                "target": 18
            },
            {
                "source": 11,
                "target": 19
            },
            {
                "source": 19,
                "target": 20
            },
            {
                "source": 1,
                "target": 21
            },
            {
                "source": 21,
                "target": 22
            },
            {
                "source": 22,
                "target": 23
            },
            {
                "source": 21,
                "target": 17
            },
            {
                "source": 21,
                "target": 24
            },
            {
                "source": 24,
                "target": 25
            },
            {
                "source": 21,
                "target": 19
            }
        ]

}
*/
Ext.define('netscaler.view.netscalerTopology', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.netscalertopology',
	title: topologyTitle,
	tools:[
	{
		xtype : 'button',
		id:'autofit',
		tooltip: autofitLbl,
		margin:'4 10 0 8',
		cls:'iconAutofit',
		style:{"border":"none"},
	}],
	ui: 'newGraphPanel',
	//margin: '10 10 5 10',
	margin: '0 6 5 10',
	padding: '0 10 5 10',
	columnWidth: 1,
	items: [{
		xtype: 'container',
		id: 'netscalerTopo',
		listeners: {
			afterrender: function (c) {
				var graphObjTools = {};

				(function (selector, graphD) {

					var graphDataNetscaler = graphD['TopologyData'];
					if(graphDataNetscaler!=null && graphDataNetscaler!='-')
					{
						var drawGraph = function () {
							graphObjTools = {
								graphRender: new dagreD3.render(),
								zoom: d3.behavior.zoom(),
								minZoom: 0.2,
								maxZoom: 2,
								initialScale: 1.1,
								d3Translate: d3.behavior.zoom().translate(),
								d3Scale: d3.behavior.zoom().scale(),
								assets: {},
								fontSize: 10,
								//  graphWidth: window.innerWidth,
								//  graphHeight: window.innerHeight,
								graphWidth: window.innerWidth - 60,
								graphHeight:600,
								//graphHeight:window.innerHeight - 20,
								getWidth: function () {
									return this.graphWidth;
								},
								getHeight: function () {
									return this.graphHeight;
								},
								lineInterpolate: "monotone",
								//lineInterpolate: "cardinal",
								//lineInterpolate: "bundle",
								//lineInterpolate: "cardinal-open",
								//lineInterpolate: "basis-open",
								//lineInterpolate: "basis-closed",
								//lineInterpolate: "cardinal-closed",
								//lineInterpolate: "basis",
								graphAlign: "LR",
								nodeData: [],
								linkData: [],
								textTruncateLength: 128,
								textTruncate: function (fullStr, strLen, separator) {
									if (!Ext.isEmpty(fullStr)) {
										if (fullStr.length <= strLen) return fullStr;
										separator = separator || '...';
										var sepLen = separator.length,
											charsToShow = strLen - sepLen,
											frontChars = Math.ceil(charsToShow / 2),
											backChars = Math.floor(charsToShow / 2);
										return fullStr.substr(0, frontChars) + separator + fullStr.substr(fullStr.length - backChars);
									}
								},
								highLightNodeCheck: 0,
								hightLightCheckType: 'all',

								highLightNode: function (el, width, height, x, y) {
									d3.select(el).selectAll('rect')
										.attr('class', 'highlight').transition()
										.attr({
											'width': width + 20,
											'height': height,
											'x': x - 10,
											'y': y
										}).style({
											'fill': '#40b5c5'
										})
									d3.select(this).selectAll('.highlight').attr("width", d3.select(this).node().getBBox().width).attr("height", 35);
								}
							}

							// Removing All child nodes
							d3.select(selector[0]).selectAll("*").remove();

							var rootSVG = d3.select(selector[0]).append("svg").attr("width", graphObjTools.graphWidth).attr("height", graphObjTools.graphHeight).attr("class", "graph-attach").attr("id", "graph-attach");
							rootSVG.attr('viewBox', "0 0 " + graphObjTools.graphWidth + " " + graphObjTools.graphHeight + "").attr('preserveAspectRatio', 'xMinYMin meet');
							rootSVG.attr('xmlns', "http://www.w3.org/2000/svg");
							var innerGroupNode = rootSVG.append('g').attr("class", "graphinnergrp");

							graphObjTools.baseSvg = d3.select("svg.graph-attach");
							graphObjTools.innerGrp = d3.select("g.graphinnergrp");

							// Adding cursor
							$('.graph-attach').mousedown(function () {
								$(this).css("cursor", "url('../images/closedhand.cur'),default");
							}).mouseover(function () {
								$(this).css("cursor", "url('../images/openhand.cur'),default");
							}).mouseup(function () {
								$(this).css("cursor", "url('../images/openhand.cur'),default");
							});
							// Adding zoom slider width jquery UI

							var slider_tooltip = $('<span id="tooltip" class="slider_tooltip" />').css({
								position: 'absolute',
								top: -1,
								left: 20
							}).hide();

							// Slider UI destroy
							if ($(".slider").slider()) {
								$(".slider").slider("destroy");
								$(".slider").remove();
							}
							var addSlider = function () {
								if ($('.slider')) {
									$('.slider').remove();
								}
								var slider = $('<div class="slider topologySlider"></div>');
								var sliderFake = $('<div class="slider_buttons"></div>');
								var slider_buttons = slider.append(sliderFake);
								var zoomslider_in = slider_buttons.append('<button style="top:-27px;left: -7px;z-index:99" data-qtip="ZoomIn" id="zoom_in" class="button_zoom zoomInbt zoomtop"></button>');
								var zoomslider_out = slider_buttons.append('<button style="bottom: -17px;left: -7px;z-index:99" data-qtip="ZoomOut" id="zoom_out" class="button_zoom zoomOutbt zoombottom"></button>');
								cssObj = {
									'left': '35px',
									'top': graphObjTools.graphHeight - 300 + 'px',
									'position': 'absolute'
								};
								slider.css(cssObj);
								// sliderFake.css(cssObj);
								slider.appendTo(selector[0]);
							}

							addSlider();

							// Slider function

							var sliderUI = $(".slider").slider({
								animate: "slow",
								orientation: "vertical",
								min: graphObjTools.minZoom,
								max: graphObjTools.maxZoom,
								height: 83,
								value: graphObjTools.initialScale,
								step: ((graphObjTools.maxZoom - graphObjTools.minZoom) / 100),
								slide: function (event, ui) {
									cal.sliderFn(ui.value);
									slider_tooltip.text(Math.round(ui.value * 100) + '%');

								}
							});
							// Slider tooltip remove
							if (slider_tooltip) {
								$(slider_tooltip).remove();
							}
							sliderUI.find(".ui-slider-handle").append(slider_tooltip).hover(function () {
								slider_tooltip.text(Math.round(zoom.scale() * 100) + '%');
								slider_tooltip.fadeIn('fast');
							}, function () {
								slider_tooltip.fadeOut('slow');
							});
							// Finding the total number of nodes and links
							Object.size = function (obj) {
								var size = 0;
								for (var key in obj) {
									if (obj.hasOwnProperty(key)) {
										size++;
									}
								}
								return size;
							}

							var graphObj = new dagreD3.graphlib.Graph().setGraph({
								//ranksep: (graphObjTools.graphWidth /Object.size(graphData.nodes[0])) /Object.size(graphData.nodes[0]) * Object.size(graphData.nodes[0]),
								ranksep: 200,
								//edgesep: graphObjTools.graphHeight /Object.size(graphData.links[0]),
								edgesep: 10,
								nodesep: 30,
								width: graphObjTools.graphWidth,
								height: graphObjTools.graphHeight,
								rankdir: graphObjTools.graphAlign,
								marginx: 0,
								marginy: 0
							});

							var creatingNodeAndLinks = function () {
								for (var n = 0; n < graphDataNetscaler.nodes.length; n++) {
									graphObjTools.assets.nodeObject = graphDataNetscaler.nodes[n];
									graphObjTools.nodeData.push(graphObjTools.assets.nodeObject);

								}
								for (var l = 0; l < graphDataNetscaler.links.length; l++) {
									graphObjTools.assets.linkObject = graphDataNetscaler.links[l];
									graphObjTools.linkData.push(graphObjTools.assets.linkObject);

								}
							}

							//  Rendering the edgeData
							var labelRect = "";
							function creatingEdgesLabels(data) {
								this.group = d3.select(document.createElementNS(d3.ns.prefix.svg, 'g'));
								if (data) {
									group.classed("labelgrp", true);
									group.style('cursor', 'pointer');
									labelRect = group.append('rect').classed("labelpatch", true);
								}

								this.group.attr('transform', 'translate(0,5)');
								return this.group.node();
							}
							
							if (strSkin=="Light")
							{
								markerColor="#cdcdcd";
								sepLineColor = "#d2d2d2";
								titleColor = "#000000";
								borderBoxColor = "#cdcdcd";
							}
							else if (strSkin=="Dark")
							{
								markerColor="#909090";
								sepLineColor = "#636364";
								titleColor = "#ffffff";
								borderBoxColor = "#858687";
							}

							var marker = function () {
								var marker = d3.select('g.graphinnergrp')
									.selectAll("marker")
									.data([{
										"name": "default",
										//"color": "#918f8f"
										//"color": "#d2d2d2"
										"color": markerColor
									}]).enter();

								marker.append("svg:marker")
									.attr("id", function (d) {
										return d.name
									})
									.attr("fill", function (d) {
										return d.color;
									})
									.attr("viewBox", "0 0 13 13")
									.attr("markerWidth", 7)
									.attr("markerUnits", "strokeWidth")
									.attr("stroke-width", 1)
									.attr("stroke-dash", function (l) {
										return 0 + " " + 0
									})
									.attr("stroke-dashoffset", function (l) {
										return 0

									})
									.attr("markerHeight", 16)
									.attr("refX", function (d) {
										return 10
									})
									.attr("refY", 8)
									.attr("orient", "auto")
									.append("svg:path").attr('d', function (d) {
										return d.path
									})
									// .attr("d", "M2,2 L2,13 L8,7 L2,2");
									.attr("d", "M0,0 L0,16 L12,7 Z");

							}

							var markerOver = function () {
								var marker = d3.select('g.graphinnergrp')
									.selectAll("marker.overmarker")
									.data([{
										"name": "defaultover",
										//"color": "#918f8f"
										//"color": "#d2d2d2"
										"color": markerColor
									}]).enter();

								marker.append("marker")
									.attr("id", function (d) {
										return d.name
									})
									.attr("fill", function (d) {
										return d.color;
									})
									.attr("viewBox", "0 0 13 13")
									.attr("markerWidth", 4)
									.attr("markerHeight", 16)
									.attr("markerUnits", "strokeWidth")
									.attr("stroke-width", 1)
									//.attr("stroke-dasharray", function(l) {
									.attr("stroke-dash", function (l) {
										return 0 + " " + 0;

									}).attr("stroke-dashoffset", function (l) {
										return 0;
									})
									.attr("refX", function (d) {
										return 10
									})
									.attr("refY", 8)
									.attr("orient", "auto")
									.append("svg:path").attr('d', function (d) {
										return d.path
									})
									//.attr("d", "M2,2 L2,13 L8,7 L2,2");
									.attr("d", "M0,0 L0,16 L12,7 Z");

							}

							marker();
							markerOver();

							var renderingNodeLinks = function () {
								creatingNodeAndLinks();

								for (var keys in graphObjTools.nodeData[0]) {
									graphObj.setNode(keys, {
										label: "",
										//width: 30,
										//height: 30
										width: 40,
										height: 30
									});
								}

								graphObjTools.linkData.forEach(function (d, i) {

									// Static node user to start component
									graphObj.setEdge(0, 1, {
										label: '',
										width: -80,
										labelpos: "c",
										lineInterpolate: graphObjTools.lineInterpolate
									});

									// Rest of others
									if (d.source === d.target) {
										graphObjTools.lineInterpolate = "basis";
									}
									graphObj.setEdge(d.source, d.target, {
										labelType: 'svg',
										label: creatingEdgesLabels(d),
										labelpos: "c",
										lineInterpolate: graphObjTools.lineInterpolate
									});
									// });
								});
								graphObjTools.graphRender(graphObjTools.innerGrp, graphObj);
							}

							renderingNodeLinks();

							var zoom = graphObjTools.zoom.scaleExtent([graphObjTools.minZoom, graphObjTools.maxZoom])
								.size([graphObjTools.graphWidth / 2, graphObjTools.graphHeight / 2]);


							// Indexing the link source & target coz for line animation
							var connectedIndex = [];
							var count = 0;
							for (var i in graphObj._edgeObjs) {
								count = count + 1;
								if (graphObj._edgeObjs.hasOwnProperty(i)) {
									connectedIndex.push({
										'index': count,
										'target': graphObj._edgeObjs[i].w,
										'source': graphObj._edgeObjs[i].v
									})
								}
							};
							var pathLine = graphObjTools.innerGrp.selectAll('.path').data(connectedIndex);
							var edgePath = graphObjTools.innerGrp.selectAll('.edgePath').data(graphObjTools.linkData);

							//pathLine.attr("stroke-line", "round").attr('marker-mid', 'url(#default)').attr('marker-end', '');
							pathLine.attr("stroke-line", "round").attr('marker-mid', '').attr('marker-end', 'url(#default)').style('stroke', markerColor);

							var cal = {
								fontSize: graphObjTools.fontSize,
								getScale: function (scale) {
									return scale;
								},
								getFontSize: function (scale) {
									return this.fontSize / scale;
								},
								interpolateZoom: function (translate, scale, duration) {
									var self = this;
									return d3.transition().duration(duration).tween("zoom", function () {
										var iTranslate = d3.interpolate(zoom.translate(), translate),
											iScale = d3.interpolate(zoom.scale(), scale);
										return function (t) {
											zoom.scale(iScale(t)).translate(iTranslate(t)).event(rootSVG);
										};
									});
								},
								sliderFn: function (value) {
									var scale = zoom.scale();
									var extent = zoom.scaleExtent();
									var newScale = value;
									if (extent[0] <= newScale && newScale <= extent[1]) {
										var t = zoom.translate();
										var c = [graphObjTools.graphWidth / 2, graphObjTools.graphHeight / 2];
										zoom.scale(newScale)
											.translate([c[0] + (t[0] - c[0]) / scale * newScale, c[1] + (t[1] - c[1]) / scale * newScale])
											.event(rootSVG);
									}
								},
								zoomBtFn: function () {
									var clicked = d3.event.target,
										direction = 1,
										factor = 0.2,
										target_zoom = ((graphObjTools.maxZoom - graphObjTools.minZoom) / 100),
										center = [graphObjTools.graphWidth / 2, graphObjTools.graphHeight / 2],
										extent = zoom.scaleExtent([graphObjTools.minZoom, graphObjTools.maxZoom]),
										translate = zoom.translate(),
										translate0 = [],
										l = [],
										view = {
											x: translate[0],
											y: translate[1],
											k: zoom.scale()
										};

									d3.event.preventDefault();
									direction = (this.id === 'zoom_in') ? 1 : -1;
									target_zoom = zoom.scale() * (1 + factor * direction);
									if (target_zoom < extent[0] || target_zoom > extent[1]) {
										return false;
									}
									translate0 = [(center[0] - view.x) / view.k, (center[1] - view.y) / view.k];
									view.k = target_zoom;
									l = [translate0[0] * view.k + view.x, translate0[1] * view.k + view.y];
									view.x += center[0] - l[0];
									view.y += center[1] - l[1];
									if (view.k <= graphObjTools.minZoom || view.k >= graphObjTools.maxZoom) {
										$(".slider").slider("value", view.k);
										return false;
									} else {
										cal.interpolateZoom([view.x, view.y], view.k, 200);
									}
								}
							}

							if (navigator.appVersion.indexOf("MSIE 10") != -1) {
								pathLine.each(function () { this.parentNode.insertBefore(this, this); });
							}
							var serverType, displayName, displayName_stroke, compName, componentTranValue, componentBoxBorder, stateIconType;
							var renderNode = function (scale) {
								graphObj.nodes().forEach(function (i) {

									var node = graphObj.node(i);

									var parentNode = d3.select(node.elem).data(graphObjTools.nodeData);
									parentNode.attr('id', function (d) {
										return d[i].componentName;
									}).style('opacity', function (d) {
										if (!d[i].activeNode) return '1';
									}).attr('class', function (d) {
										if (d[i].drillDownUrl != 'none') {
											return 'pointer';
										}
									});

									parentNode.classed('parentNode', true);
									d3.select(node.elem).selectAll("*").remove();
									parentNode.selectAll("*").remove();
									
									
									d3.select(node.elem).attr('class', function(d){
										if(d[i].serverType == "VIRTUAL_SERVERS"){
											return 'parentNode virtualServerClass'
										}else if(d[i].serverType == "SERVICE_GROUP" || d[i].serverType == "SERVICE"){
											return 'parentNode serviceGroupClass'
										}else if(d[i].serverType == "NODES"){
											return 'parentNode nodesClass'
										}
									})

										.on('click', function (d) {
											d3.event.stopPropagation();
											
											if (d[i].drillDownUrl != "none") {
												wayToLayerModel(d[i].drillDownUrl);
												//window.parent.location = d[i].drillDownUrl;
											}
										})

										.on('mouseenter', function (d) {
											//@ hightLight
											if (d[i].highlight) {
												var compName = d3.select(this).selectAll('.compName');
												var dispName = d3.select(this).selectAll('.displayName');
												var hightLightHeight = graphObjTools.highLightNodeCheck == 1 ? 20 : 35;
												compName.text(d[i]['componentName']);
												dispName.text(d[i]['displayName']);

												if (dispName.node().getBBox().width >= compName.node().getBBox().width) {
													graphObjTools.highLightNode(this, dispName.node().getBBox().width, hightLightHeight, dispName.node().getBBox().x, 23);
												} else {
													graphObjTools.highLightNode(this, compName.node().getBBox().width, hightLightHeight, compName.node().getBBox().x, 23);
												}
												if (graphObjTools.highLightNodeCheck == 1) {
													graphObjTools.highLightNode(this, d3.select(this).node().getBBox().width, 20, d3.select(this).node().getBBox().x, 23);
												} else {
													graphObjTools.highLightNode(this, d3.select(this).node().getBBox().width, 35, d3.select(this).node().getBBox().x, 23);
												}
											} else {
												// function if any
											}
											animateFn = function () {
												pathLine
													/*.attr('marker-mid', function (l) {
														if (i === l.source || i === l.target) {
															return 'url(#defaultover)';
														}
														else {
															return 'url(#default)';
														}
													})*/
													.attr('marker-end', function (l) {
														if (i === l.source || i === l.target) {
															return 'url(#defaultover)';
														}
														else {
															return 'url(#default)';
														}
													})
													.style('stroke', function () {
														//return '#918f8f';
														//return '#d2d2d2';
														return markerColor;
													})
													.style("stroke-width", function (l) {
														if (i === l.source || i === l.target) {
															return 2;
														} else {
															return 1;
														}
													})
													.transition()
													//.duration(200)
													.duration(0)
													.ease("linear")
													.attr("stroke-dasharray",function(l){ 
														if (i === l.source || i === l.target) {
															return 6 + " " + 6
															}
													})
													.attr("stroke-dashoffset", 0).each("end", animateFn);
											}
											animateFn();

										}).on('mouseleave', function (d) {
											//@ hightLight
											if (d[i].highlight) {
												var compName = d3.select(this).selectAll('.compName');
												var dispName = d3.select(this).selectAll('.displayName');
												var hightLightHeight = graphObjTools.highLightNodeCheck == 1 ? 20 : 35;
												compName.text(graphObjTools.textTruncate(d[i]['componentName'], graphObjTools.textTruncateLength));
												dispName.text(graphObjTools.textTruncate(d[i]['displayName'], graphObjTools.textTruncateLength));

												if (dispName.node().getBBox().width >= compName.node().getBBox().width) {
													graphObjTools.highLightNode(this, dispName.node().getBBox().width, hightLightHeight, dispName.node().getBBox().x, 23);
												} else {
													graphObjTools.highLightNode(this, compName.node().getBBox().width, hightLightHeight, compName.node().getBBox().x, 23);
												}
											} else {
												// function if any
											}
											animateFn = function () {
												pathLine
													/*.attr('marker-mid', function (l) {
														if (i === l.source || i === l.target) {
															return 'url(#default)';
														}
														else {
															return 'url(#default)';
														}
													})*/
													.attr('marker-end', function (l) {
														if (i === l.source || i === l.target) {
															return 'url(#default)';
														}
														else {
															return 'url(#default)';
														}
													})
													.style('stroke', function () {
														//return '#918f8f';
														//return '#d2d2d2';
														return markerColor;
													})
													.style("stroke-width", function (l) {
														if (i === l.source || i === l.target) {
															return 1;
														}
													})
													.transition()
													//.duration(200)
													.duration(0)
													.ease("linear")
													.attr("stroke-dasharray",function(l){ 
														if (i === l.source || i === l.target) {
															return 0 + " " + 0
															}
													})
													.attr("stroke-dashoffset", 0).each("end", animateFn);
											}
											animateFn();
										});


									//isHighlight =  parentNode.filter(function(d){return d[i].highlight == true}).append('rect').attr('class', 'isHighlight');
									
									componentBoxBorder = parentNode.filter(function(d){
										
										return d[i].serverType == "SERVICE_GROUP" || d[i].serverType == "SERVICE";
										}).append('rect').attr('width', '48px').attr("height", "48px").attr("rx", 3).attr("ry",3).attr("stroke",borderBoxColor).attr("stroke-width","1px").attr("fill-opacity", 0).attr("x", function(d){return -24 }).attr("y", function(d){return -26 });


									/*stateIconType = parentNode.filter(function(d){
										
										return d[i].serverType == "VIRTUAL_SERVERS" || d[i].serverType == "SERVICE_GROUP"|| d[i].serverType == "SERVICE"|| d[i].serverType == "NODES";
										}).append('image').attr('xlink:href', function (d) {
										return "../images/component_icons/svg/" + d[i].state + ".svg";
									}).attr('width', '22px').attr("height", "22px").attr("x", function(d){return 5 }).attr("y", function(d){return 4 });*/
									

									/*stateIconType = parentNode.append('image').attr('xlink:href', function (d) {
										return "../images/component_icons/svg/" + d[i].state + ".svg";
									}).attr('width', '22px').attr("height", "22px").attr("x", function(d){return 5 }).attr("y", function(d){return 4 });*/


									serverType = parentNode.append('image').attr('xlink:href', function (d) {
										return "../images/component_icons/svg/" + graphDataNetscaler.paper.skin + "/" + d[i].serverType + ".svg";
									}).attr({
										'width': function (d) {
											if (0.4 >= scale >= 0.2) {
												return 44;
											}
											return 44 / cal.getScale(scale);
										},
										'data-qtip':function(d){
											return d[i].Tooltip
										},
										'height': function (d) {
											if (0.4 >= scale >= 0.2) {
												return 44;
											}
											return 44 / cal.getScale(scale);
										}
									})
										.attr('x', function (d) {
											if (0.4 >= scale >= 0.2) {
												return Math.round(-100 * cal.getScale(scale));
											}
											return Math.round(-24 / cal.getScale(scale));
										})
										.attr('y', function (d) {
											if (0.4 >= scale >= 0.2) {
												return Math.round(-95 * cal.getScale(scale));
											}
											return Math.round(-24 / cal.getScale(scale));
										});
									
									stateIconType = parentNode.filter(function(d){
										
										return d[i].serverType == "VIRTUAL_SERVERS" || d[i].serverType == "SERVICE_GROUP"|| d[i].serverType == "SERVICE"|| d[i].serverType == "NODES";
										}).append('image').attr('xlink:href', function (d) {
										return "../images/component_icons/svg/" + d[i].state + ".svg";
									}).attr('width', '22px').attr("height", "22px").attr("x", function(d){return 8}).attr("y", function(d){return 2});
										

									// @textTruncate
									displayName_stroke = parentNode.filter(function (d) {
										return d[i].displayName != "none" && !d[i].highlight;
									})
										.append('text').text(function (d) {
											if (d[i].highlight) {
												return graphObjTools.textTruncate(d[i].displayName, graphObjTools.textTruncateLength);
											} else {
												return d[i].displayName;
											}
										})
										.attr('title', function (d) {
											return d[i].displayName;
										})
										.attr('text-anchor', 'middle')
										
										.attr('class', 'displayName')
										.attr('x', function (d) {
											return 0 / cal.getScale(scale);
										})
										.attr('y', function (d) {
											return 36 / cal.getScale(scale);
										})
										.style("font-size", cal.getFontSize(scale) + "px")
										.classed('commonsize_strokeTopo', true);

									// @textTruncate
									displayName = parentNode.filter(function (d) {
										return d[i].displayName != "none";
									})
										.append('text').text(function (d) {
											if (d[i].highlight) {
										 		return graphObjTools.textTruncate(d[i].displayName, graphObjTools.textTruncateLength);
											} else {
												if(d[i].displayName.length > 25)
													//return d[i].displayName.substring(0,25)+'...';
													return graphObjTools.textTruncate(d[i].displayName, 25);
												else
													return d[i].displayName;
											}
										})
										.attr('title', function (d) {
											return d[i].displayName
										})
										.attr('data-qtip',function(d){
											if(d[i].displayName.length > 25)
												return d[i].displayName
										})
										.attr('text-anchor', 'middle')
										.attr('class', function (d) {
											if (d[i].highlight) {
												return 'displayName highlight';
											} else {
												return 'displayName';
											}
										})

										.attr('x', function (d) {
											if (d[i].displayName == "Client" || d[i].serverType === "CUSTOM") {
												return -5;
											} else {
												return 0 / cal.getScale(scale);
											}
										})
										.attr('y', function (d) {
											return 36 / cal.getScale(scale);
										})
										.style("font-size", cal.getFontSize(scale) + "px")
										.style("fill", function (d) {
											if (d[i].highlight) {
												//return  "#ffffff"
												return "#000000"
											}
										})
									//.classed('commonsizeTopo', true);

									// @textTruncate
									compName_stroke = parentNode.append('text').text(function (d) {
										if (!d[i].highlight && d[i].componentName != 'none') {
											if (d[i].highlight) {
												return d[i].componentName;
											} else {
												return graphObjTools.textTruncate(d[i].componentName, graphObjTools.textTruncateLength);
											}
										} else {
											return "";
										}
									})
										.attr('title', function (d) {
											return d[i].componentName
										})
										.attr('text-anchor', 'middle')
										.attr('class', function (d) {
											return 'commonsize_stroke_highlightTopo compName'
										})
										.attr('x', function (d) {
											if (d[i].componentName == "Client" || d[i].serverType === "USER") {
												return -5;
											} else {
												return 0;
											}
										}).attr('y', function (d) {
											return 50 / cal.getScale(scale);
										}).style("font-size", cal.getFontSize(scale) + "px");

									// @textTruncate
									compName = parentNode.append('text').text(function (d) {
										if (d[i].componentName != 'none') {
											if (d[i].highlight) {
												return graphObjTools.textTruncate(d[i].componentName, graphObjTools.textTruncateLength);
											} else {
												if(d[i].componentName.length > 25)
													//return d[i].componentName.substring(0,25)+'...';
													return graphObjTools.textTruncate(d[i].componentName, 25);
												else
													return d[i].componentName;
											}
										} else {
											return "";
										}
									})
										.attr('title', function (d) {
											return d[i].componentName;
										})
										.attr('data-qtip',function(d){
											if(d[i].componentName.length > 25)
												return d[i].componentName
										})
										.attr('text-anchor', 'middle')
										.attr('class', function (d) {
											return 'commonsizeTopo compName'
										})
										.attr('x', function (d) {
											if (d[i].componentName == "Client" || d[i].serverType === "CUSTOM") {
												return -5;
											} else {
												return 0;
											}
										})
										.attr('y', function (d) {
											if (d[i].componentName == "Client" || d[i].serverType === "CUSTOM" || d[i].displayName === "none") {
												return 35 / cal.getScale(scale);
											}
											else {
												return 50 / cal.getScale(scale);
											}
										}).style("fill", function (d) {
											if (d[i].highlight) {
												return "#000000"
											}
										}).style("font-size", cal.getFontSize(scale) + "px");

									/*
									*@ setting the highlight rectangle node
									*/

									parentNode.filter(function (d) {
										if (d[i].highlight) {
											var compName = d3.select(this).selectAll('.compName').text(graphObjTools.textTruncate(d[i]['componentName'], graphObjTools.textTruncateLength));
											var dispName = d3.select(this).selectAll('.displayName').text(graphObjTools.textTruncate(d[i]['displayName'], graphObjTools.textTruncateLength));
											var hightLightHeight = graphObjTools.highLightNodeCheck == 1 ? 20 : 35;
											compName.text(graphObjTools.textTruncate(d[i]['componentName'], graphObjTools.textTruncateLength));
											dispName.text(graphObjTools.textTruncate(d[i]['displayName'], graphObjTools.textTruncateLength));

										}
									});


									componentTranValue_stroke = parentNode.filter(function (d) {
										//  return (d[i].nodeTime !== "none") && !d[i].isAsync;
									})
										.append('text')
										.attr('text-anchor', 'start')
										.attr('class', 'commonsize_strokeTopo componentTranValue')
										.attr('x', -6 / cal.getScale(scale))
										.attr('y', function (d) {
											return -24 / cal.getScale(scale);
										})
										.style("font-size", cal.getFontSize(scale) + "px");

									componentTranValue_stroke.append('tspan').attr('class', 'nodeTime').text(function (d) {
										// return d[i].nodeTime + " ";
									});
									componentTranValue_stroke.append('tspan').attr('class', 'nodePercent').text(function (d) {
										// return d[i].nodePercent + "  ";
									}).style('opacity', '0').style('display', 'none');


									componentTranValue = parentNode.filter(function (d) {
										// return (d[i].nodeTime != "none") && !d[i].isAsync;
									})
										.append('text')
										.attr('text-anchor', 'start')
										
										.attr('class', 'commonsizeTopo componentTranValue')
										.attr('x', -6 / cal.getScale(scale))
										.attr('y', function (d) {
											return -24 / cal.getScale(scale);
										})
										.style("font-size", cal.getFontSize(scale) + "px");

									componentTranValue.append('tspan').attr('class', 'nodeTime').text(function (d) {
										// return d[i].nodeTime + " ";
									});
									componentTranValue.append('tspan').attr('class', 'nodePercent').text(function (d) {
										// return d[i].nodePercent + "  ";
									}).style('opacity', '0').style('display', 'none');


								});
								// For performance TODO
								serverType = null;
								displayName = null;
								displayName_stroke = null;
								compName = null;
								componentTranValue = null;
								componentBoxBorder = null;
								stateIconType = null;
								

								delete serverType;
								delete displayName;
								delete displayName_stroke;
								delete compName;
								delete componentTranValue;
								delete componentBoxBorder;
								delete stateIconType;
							}

							// Rendering the nodeData
							renderNode(graphObjTools.d3Scale);

							// Taking the bound of the graph
							var allparentnodes = graphObjTools.innerGrp.selectAll('.parentNode');
							var graphBounds = function () {
								var x = Number.POSITIVE_INFINITY,
									X = Number.NEGATIVE_INFINITY,
									y = Number.POSITIVE_INFINITY,
									Y = Number.NEGATIVE_INFINITY;
								allparentnodes.each(function (v, i) {
									for (keys in v) {
										if (v.hasOwnProperty(keys)) {
											x = Math.min(x, graphObj.node(keys).x - this.getBBox().width * zoom.scale());
											X = Math.max(X, graphObj.node(keys).x + this.getBBox().width * zoom.scale());
											y = Math.min(y, graphObj.node(keys).y - this.getBBox().height * zoom.scale());
											Y = Math.max(Y, graphObj.node(keys).y + this.getBBox().height * zoom.scale());
										}
									}


								});
								return {
									x: x,
									X: X,
									y: y,
									Y: Y
								};
							}

							var graph_bound = graphBounds();
							var zoomToFit = function () {

								var graph_width = graph_bound.X - graph_bound.x,
									graph_height = graph_bound.Y - graph_bound.y,
									total_width = graphObjTools.graphWidth - graphObj.graph().marginx,
									total_height = graphObjTools.graphHeight - graphObj.graph().marginy,
									fit_scale = Math.min(total_width / graph_width, total_height / graph_height);

								graphObjTools.d3Translate[0] = (-graph_bound.x * fit_scale + (total_width / fit_scale - graph_width) * fit_scale / 2),
									graphObjTools.d3Translate[1] = (-graph_bound.y * fit_scale + (total_height / fit_scale - graph_height) * fit_scale / 2);
								cal.interpolateZoom(graphObjTools.d3Translate, fit_scale, 200);
								//innerGroupNode.attr("transform", "translate(" + xPrime + ", " + yPrime + ") scale(" + scale + ")");

								delete fit_scale, total_width, total_height;
							}
							// setting the graph position on load
							var xCenterOffset = (rootSVG.attr("width") - graphObj.graph().width);

							//var bbox = d3.select('g.graphinnergrp')[0][0].getBBox(),

								var graphWidth = graphObj.graph().width,
								graphHeight = graphObj.graph().height
							graph_width = graph_bound.X - graph_bound.x,
								graph_height = graph_bound.Y - graph_bound.y,
								total_width = graphObjTools.graphWidth - graphObj.graph().marginx - 15,
								total_height = graphObjTools.graphHeight - graphObj.graph().marginy - 15,
								// fit_scale = Math.min(graphWidth - graphObj.graph().marginx, graphHeight - graphObj.graph().marginy);
								fit_scale = Math.min(total_width / graph_width, total_height / graph_height);
							graphObjTools.d3Translate[0] = (-graph_bound.x * fit_scale + (total_width / fit_scale - graph_width) * fit_scale / 2),
								graphObjTools.d3Translate[1] = (-graph_bound.y * fit_scale + (total_height / fit_scale - graph_height) * fit_scale / 2);

							//console.log("bbox--->", bbox);

							// condition for signal line components
							if ((total_height / 2) > graph_height) {

								//fit_scale= Math.min(total_width / graph_width, total_height / graph_height);
								fit_scale = graphObjTools.initialScale;
								graphObjTools.d3Translate[0] = (-graph_bound.x * fit_scale + (total_width / fit_scale - graph_width) * fit_scale / 2),
									graphObjTools.d3Translate[1] = (-graph_bound.y * fit_scale + (total_height / fit_scale - graph_height) * fit_scale / 2);
							}
							cal.interpolateZoom(graphObjTools.d3Translate, fit_scale, 10);

							var zoomFunction = function () {
								translation = d3.event.translate,
									scale = d3.event.scale;

								innerGroupNode.attr("transform", "translate(" + translation + ") scale(" + scale + ")");

								//renderNode(d3.event.scale);
								$(".slider").slider("value", scale);
								if (slider_tooltip.text(Math.round(scale * 100) + '%').hide()) {
									slider_tooltip.text(Math.round(scale * 100) + '%').show();
								}
								sliderUI.slider("option", "value", scale);
								hideText(.800,scale);
								//console.log('scale---->',scale);
							}

							var zoomStartFunction = function () {

							}
							var zoomEndFunction = function () {
								slider_tooltip.delay(10).fadeOut('slow');
							}
							zoom.on("zoom", zoomFunction);
							//zoom.on("zoomstart", zoomStartFunction);
							zoom.on("zoomend", zoomEndFunction);

							d3.selectAll('button.button_zoom').on('click', cal.zoomBtFn);
							d3.select('#autofit').on('click', zoomToFit);
							rootSVG.call(zoom);

							/*-- Grouping Start --*/
							Ext.defer(function(){
								//var svgHeight = 200;
								var svgHeight = d3.select(".graphinnergrp").node().getBBox().height;
								
								d3.selectAll('.virtualServerClass').each(function(d,i){
									
									var t = d3.transform(d3.select(this).attr("transform")),
									//x = t.translate[0],
									//y = t.translate[1];
									x = 530,
									y = 30;
									//console.log('data==>',d3.select(d).node())
									//console.log('data==>',x,y,i)
									//d3.selectAll('.sepLine').removeAll();
									if(i == 0){
										//d3.selectAll('.sepLine').removeAll();
										//if(d3.selectAll('.line_g').length == 1){ d3.select('.line_g').removeAll()}
										d3.select("g.graphinnergrp").append("line")
											.attr("x1", x - 100)
											.attr("x2", x - 100)
											.attr("y1", -y -20)
											.attr("y2", svgHeight - 5)
											.attr("class","sepLine")
											.style("stroke-dasharray","5,5")
											.style("stroke", sepLineColor);
										var titlt_g = d3.select("g.graphinnergrp").append("g").attr("transform", "translate("+(x-45)+","+(-y-20)+")");
											
										titlt_g.append('image')
											.attr('xlink:href', function (d) {
												return "../images/component_icons/svg/"+strSkin+"/header_small.svg";
											})
											.attr('width', '125px')
											.attr('height', '40px');
										titlt_g.append('text')
											.attr('text-anchor', 'middle')
											.attr('class', 'headerTitle')
											.style("font-size", "13px")
											.style("font-family", "Roboto")
											.style("fill", titleColor)
											.text(function () {
												return virtualServersLbl;
											})
											.attr("x", 125/2)
											.attr("y", 19);
									}
								});
								d3.selectAll('.serviceGroupClass').each(function(d,i){
									var t = d3.transform(d3.select(this).attr("transform")),
									//x = t.translate[0],
									//y = t.translate[1];
									x = 770,
									y = 30;
									//console.log('data==>',d3.select(d).node())
									//console.log('data==>',x,y,i)

									if(i == 0){
										d3.select("g.graphinnergrp").append("line")
											.attr("x1", x - 100)
											.attr("x2", x - 100)
											.attr("y1", -y -20)
											.attr("y2", svgHeight - 5)
											.style("stroke-dasharray","5,5")
											.style("stroke", sepLineColor);
										var titlt_g = d3.select("g.graphinnergrp").append("g").attr("transform", "translate("+(x-60)+","+(-y-20)+")");

										titlt_g.append('image')
											.attr('xlink:href', function (d) {
												return "../images/component_icons/svg/"+strSkin+"/header_big.svg";
											})
											.attr('width', '195px')
											.attr('height', '40px');
										titlt_g.append('text')
											.attr('text-anchor', 'middle')
											.attr('class', 'headerTitle')
											.style("font-size", "13px")
											.style("font-family", "Roboto")
											.style("fill", titleColor)
											.text(function () {
												return serviceLbl+"/"+serviceGrpLbl;
											})
											.attr("x", 195/2)
											.attr("y", 19);
									}
								});
								d3.selectAll('.nodesClass').each(function(d,i){
									var t = d3.transform(d3.select(this).attr("transform")),
									//x = t.translate[0],
									//y = t.translate[1];
									x = 1030,
									y = 30;
									//console.log('data==>',d3.select(d).node())
									//console.log('data==>',x,y,i)

									if(i == 0){
										d3.select("g.graphinnergrp").append("line")
											.attr("x1", x - 85)
											.attr("x2", x - 85)
											.attr("y1", -y -20)
											.attr("y2", svgHeight - 5)
											.style("stroke-dasharray","5,5")
											.style("stroke", sepLineColor);
										var titlt_g = d3.select("g.graphinnergrp").append("g").attr("transform", "translate("+(x-15)+","+(-y-20)+")");
										
										titlt_g.append('image')
											.attr('xlink:href', function (d) {
												return "../images/component_icons/svg/"+strSkin+"/header_small.svg";
											})
											.attr('width', '103px')
											.attr('height', '40px')
										titlt_g.append('text')
											.attr('text-anchor', 'middle')
											.attr('class', 'headerTitle')
											.style("font-size", "13px")
											.style("font-family", "Roboto")
											.style("fill", titleColor)
											.text(function () {
												return nodesLbl;
											})
											.attr("x", 103/2)
											.attr("y", 19);
									}
								});
							},500);
							/*-- Grouping End --*/

						}
						drawGraph();

						// window resize event
						$(window).resize(function () {
							selector.empty();
							selector.unbind();
							drawGraph();
							
						});
				}
				else{
					var topologyWidth = window.innerWidth - 120;
					var topologyHeight = 200;

					selector.html('<table width="100%" height="100%" style="height:'+topologyHeight+'px;width:'+topologyWidth+'px"><tr><td align="center" valign="middle"><div class="iconInformation"></div>'+graphD['errorMsg']+'!</td></tr></table>');
					//selector.html('<table width="100%" height="100%" ><tr><td>'+graphD['errorMsg']+'</td></tr></table>');
				}

				//})($('#' + c.id), dataSampleFinal);
				})($('#' + c.id), jsonData);

				/**-- Hide Text --**/
				var hideText = function(value, scale) {
					if (value > scale) {
						d3.selectAll('text').transition().style("opacity", 0);
						d3.selectAll('.headerTitle').transition().style("opacity", 1);
					} else {
						d3.selectAll('text').transition().style("opacity", 1);
						d3.selectAll('.headerTitle').transition().style("opacity", 1);
					}
				}
				/**---------------**/

			}
		}
	}],
});