Ext.define('segments.controller.SegmentsDashboard', {
    extend: 'Ext.app.Controller',
    views:['SegmentsDashboard','ConfigWindow','SegmentsTopology'],
	stores:['SortRetain'],

    refs:[{
			ref:'systemPanel',
			selector:'dashboardgeneralmeasuresgridpanel[itemId="system"]'
		},{
			ref:'componentsPanel',
			selector:'dashboardgeneralmeasuresgridpanel[itemId="components"]'
		},{
			ref:'topologyPanel',
			selector:'segmentstopology',
			autoCreate:true,
			xtype:'segmentstopology'
		},{
			ref:'dashboardMaintainanceButton',
			selector:'tabbar > button[action="maintainance"]'
		},{
			ref:'dashboardBackButton',
			selector:'tabbar > button[action="back"]'
		},{
			ref:'configWindowRadio',
			selector:'configwindow > form > radio'
		},{
			ref:'configWindow',
			selector:'configwindow'
		},{
			ref:'configWindowForm',
			selector:'configwindow > form'
		},{
			ref : 'segmentsDashboard',
			selector : 'segmentsdashboard'
		},{
			ref:'componentsPanelCombo',
			selector : 'dashboardgeneralmeasuresgridpanel[itemId="components"] > panel > toolbar > combobox',
		},{
			ref:'aggregatesPanelCombo',
			selector : 'dashboardgeneralmeasuresgridpanel[itemId="aggregates"] > panel > toolbar > combobox',
		},{
			ref: 'aggregateTab',
			//selector:'dashboardgeneralmeasuresgridpanel[itemId="aggregates"]'
			selector:'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"]'
		}],
		init: function() {
		this.control({
			'segmentsdashboard': {
				scope:this,
				tabchange: function(tabpanel){
					tabSettingRef=tabpanel;
					showDashboard = null;
					this.loadActiveTabData(tabpanel);
					parent.parent.closeDiv();
				},
				afterrender: this.zonesDashboardAfterRenderHandler,
				beforetabchange: this.renewSortState							// Prem
			},
			'dashboardgeneralmeasuresgridpanel[itemId="components"] > panel > toolbar > combobox':{
				change:this.componentsComboChange
			},
			'dashboardgeneralmeasuresgridpanel[itemId="components"] > toolbar > combobox':{
				change:this.componentsComboChange
			},
			'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"] > panel > toolbar > combobox':{
				change:this.aggregatesComboChange
			},
			'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"] > toolbar > combobox':{
				change:this.aggregatesComboChange
			},
			'dashboardgeneralmeasuresgridpanel[itemId="system"] > panel > toolbar > combobox':{
       			change:this.systemsComboChange
       		},
			'dashboardgeneralmeasuresgridpanel[itemId="system"] > toolbar > combobox':{
       			change:this.systemsComboChange
       		},
			'dashboardgeneralmeasuresgrid':{									// Prem
				sortchange : this.getSortDetails,
				render : this.retainColumnSort
			},																	// Prem
			'segmentsdashboard > tabbar > button[action="maintainance"]':{
				scope : this,
				click : this.openServiceConfigWindow
			},
			'segmentsdashboard > tabbar > button[action="back"]':{
				click : this.backButtonHandler
			},
			'configwindow':{
				'render' : this.itemset,
				'close' : this.refreshcall
			},
			'configwindow > form > combo':{
				'select' : this.combo
			},
			'configwindow > form > radiogroup':{
				'change' : this.radio
			},
			'configwindow > toolbar > button[action="submit"]':{
				click : this.buttonclick
			}
		});
	},

	renewSortState:function(thisObj,opts){									// Prem
		this.getSortRetainStore().getProxy().clear();
	},																		// Prem

	retainColumnSort:function(thisObj,opts){								// Prem
		var store = this.getSortRetainStore();
		store.load();
		var panelId = null;
		if(!Ext.isEmpty(thisObj.up('dashboardgeneralmeasuresaggregatepanel')) && !Ext.isEmpty(thisObj.up('dashboardgeneralmeasuresaggregatepanel').itemId)){
			panelId = thisObj.up('dashboardgeneralmeasuresaggregatepanel').itemId;
		}
		if(Ext.isEmpty(panelId)){
			panelId = thisObj.up('dashboardgeneralmeasuresgridpanel').itemId;
		}

		var record = store.findRecord('panelId',panelId);
		if(!Ext.isEmpty(record)){
			thisObj.store.sort(record.get('dataIndex'),record.get('direction'));
		}
	},																		// Prem

	getSortDetails:function(ct, column, direction, eOpts){					// Prem
		var objFlag = true;
		//var panelId = ct.up('dashboardgeneralmeasuresgridpanel').itemId;
		var panelId = null;
		if(!Ext.isEmpty(ct.up('dashboardgeneralmeasuresgridpanel')) && !Ext.isEmpty(ct.up('dashboardgeneralmeasuresgridpanel').itemId)){
			panelId = ct.up('dashboardgeneralmeasuresgridpanel').itemId;
		}
		if(Ext.isEmpty(panelId)){
			panelId = ct.up('dashboardgeneralmeasuresaggregatepanel').itemId;
		}
		var object = {
			panelId:panelId,
			dataIndex:column.dataIndex,
			direction:direction
		}
		var store = this.getSortRetainStore();
		if(store.getCount() != 0){
			store.each(function(record){
				if(record.get('panelId') == object.panelId){
					record.set(object);
					objFlag = false;
					return false;
				}
			},this);
		}
		if(objFlag)
			store.add(object);
		store.sync();
		store.commitChanges();
	},																		// Prem

	refreshcall:function(configwindow,opts){
		var segmentChosen = this.getSegmentsDashboard().currentSegment;
		var param = "&selectNode=Segment$cap$"+segmentChosen+"&selectedParam="+segmentChosen;

		var systemObj = this.getSegmentsDashboard().child('dashboardgeneralmeasuresgridpanel#system');					// Prem
		var componentObj = this.getSegmentsDashboard().child('dashboardgeneralmeasuresgridpanel#components');			// Prem
		var aggregateObj = this.getSegmentsDashboard().child('dashboardgeneralmeasuresaggregatepanel#aggregates');			// Prem
		systemObj.loadTab(systemObj.url+param,'segmentsSys',Reftot,RefpageVal,ReftotalPageno);
		if(!Ext.isEmpty(this.getComponentsPanelCombo()))
			param += '&appCurrentHost='+this.getComponentsPanelCombo().getValue();
		componentObj.loadTab(componentObj.url+param,'segmentsComp',Reftot,RefpageVal,ReftotalPageno);
		if(!Ext.isEmpty(this.getSegmentsDashboard().aggregateTab) && this.getSegmentsDashboard().aggregateTab == true){
			if(!Ext.isEmpty(this.getAggregatesPanelCombo()))
				param += '&aggregateComp='+this.getAggregatesPanelCombo().getValue();
		aggregateObj.loadTab(aggregateObj.url+param,'segmentsAgg');
		}
	},
	backButtonHandler:function(btn){
		var titleTextFrom = requestParams.titleTextFrom;
		var values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		if(this.getSegmentsDashboard().items.getCount()==4){
			var activeTab = this.getSegmentsDashboard().getActiveTab();
			var treeSession=requestParams.treeSession;
			var backButtonFunction="";
			treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
			if(treeSession.indexOf("showDashboard")>0)
			{
				backButtonFunction=treeSession;
			}
			if(backButtonFunction.length>0)
			{
				window.history.go(-2);
			}
			else
			{
				if(!Ext.isEmpty(values))
				{
					//window.history.go(-3);
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
				}
				else if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh==true)
				{
					window.history.go(-2);
				}
				else
				{
					//window.history.go(-1);
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=segmentList&from=MainDashboard&action=segment&isFromMenu=true';
					
				}
			}
		}
		else{
			var treeSession=requestParams.treeSession;
			var backButtonFunction="";
			treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
			var isFromServ = false;
			if(treeSession.indexOf("showDashboard")>0)
			{
				backButtonFunction=treeSession;
			}
			else if((!Ext.isEmpty(treeSession)) && treeSession.indexOf("zoneDash.jsp")>-1)
			{
				if(!Ext.isEmpty(values))
				{
					if(!Ext.isEmpty(iszoneName) && iszoneName!='' && iszoneName!='null')
					{
						document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+"&parentZone="+parentZone;
						return false;
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
						return false;
					}
				}
				else
				{
					document.location=treeSession;
					return false;
				}
			}
			else if((!Ext.isEmpty(treeSession)) && treeSession.indexOf("isFromService=true")>-1)
			{
				isFromServ = true;
			}
			if(backButtonFunction.length>0)
			{
				window.history.go(-2);
			}
			else
			{
				if(!Ext.isEmpty(values))
				{
					if(!Ext.isEmpty(iszoneName) && iszoneName!='' && iszoneName!='null')
					{
						document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+"&parentZone="+parentZone;
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
					}
				}
				else if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
				{
					window.history.go(-2);
				}
				else if(values)							// Changes start here ===Kaliraj
				{
					window.history.go(-1);
				}
				else if(!Ext.isEmpty(isFromZone) && isFromZone=='true' && Ext.isEmpty(values))
				{
					//var searchType = parent.getSearchComboObj().getValue();	
					//var searchValue = parent.getSearchBoxObj().getValue();	
					var searchType = '';
					var searchValue = '';
					try{
						searchType = parent.getSearchComboObj().getValue();
						searchValue = parent.getSearchBoxObj().getValue();
					}
					catch(e)
					{
						searchType = parent.parent.getSearchComboObj().getValue();
						searchValue = parent.parent.getSearchBoxObj().getValue();
					}
					if (searchType!=null && searchType=='zone' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=zoneList&action=globalsearch&searchString='+encodeURIComponent(searchValue);
					}					
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
					}
				}
				else if(!Ext.isEmpty(iszoneName) && iszoneName!='null' && iszoneName!='' && Ext.isEmpty(values))
				{
					document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+'&parentZone='+parentZone;
				}
				else
				{
					//window.history.go(-2);
					if((!Ext.isEmpty(treeSession)) && treeSession.indexOf("zoneDash.jsp")>-1)
					{
						document.location=treeSession;
						return false;
					}
					else
					{
						if (titleTextFrom=='segment')
						{
							window.history.go(-1);
						}
						else
						{
							//var searchType = parent.getSearchComboObj().getValue();	
							//var searchValue = parent.getSearchBoxObj().getValue();	
							var searchType = '';
							var searchValue = '';
							try{
								searchType = parent.getSearchComboObj().getValue();
								searchValue = parent.getSearchBoxObj().getValue();
							}
							catch(e)
							{
								searchType = parent.parent.getSearchComboObj().getValue();
								searchValue = parent.parent.getSearchBoxObj().getValue();
							}
							if (searchType!=null && searchType=='segment' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
							{
								document.location='/final/servlet/com.eg.EgMonitorController?monCmd=segmentList&from=segmentList&action=globalsearch&searchString='+encodeURIComponent(searchValue);
							}
							else if(isFromServ)
							{
								if (searchType!=null && searchType=='service' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
								{
									document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceList&action=globalsearch&searchString='+searchValue;
								}
								else
								{
									document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true';
								}
							}
							else
							{
								document.location='/final/servlet/com.eg.EgMonitorController?monCmd=segmentList&from=MainDashboard&action=segment&isFromMenu=true';
							}
						}
					}
				}
			}
		}
		parent.parent.closeDiv();
	},
	zonesDashboardAfterRenderHandler:function(tabpanel){
		this.loadActiveTabData(tabpanel);
	},
	itemset:function(window,e){
		window.add(window.setData("",""));
	},
	combo:function(combo,newvalue,opt){
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
		var testfun='';
		//if(descMeasureUnit=='Yes')
		testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		var name=combo.getName();
		var val=combo.getValue();
		var componentType;
		if(selectedTab=='Component' || selectedTab=='Aggregate')
			componentType=this.getConfigWindowForm().getForm().getValues()['serviceComp'];
		if(name=='serviceComp')
			this.getConfigWindow().setData(selectedTab,perform,componentType,"","","",descMeasureUnit,testfun,"", name, val);
		if(name=='compLayer')
		{
			var compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,"","",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceTest')
			{
				var compname;
				if(perform=='Add')
					compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
				else
					compname='';
				var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
				this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,"",descMeasureUnit,testfun,"", name, val);

			}
		else if(name=='serviceMeasure')
			{
				var compname;
				if(perform=='Add')
					compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
				else
					compname='';
				var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
				var measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
				var dispName=newvalue[0].data.name;
				this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName, name, val);
			}
		else{}
	},
	radio:function(radio,newvalue,oldvalue,opts){
		var name='';
		var componentType='';
		var compname='';
		var testName='';
		var measureName='';
		var dispName='';
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit='';
		var testfun='';
		if(perform=='Add')
		{
			//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
			//if(descMeasureUnit=='Yes')
			testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		}
		if(radio.getName()=='Does the Test have Descriptors ?'||radio.getName()=='Function')
		{
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			if(selectedTab=='Component' || selectedTab=='Aggregate')
				componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
			testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
			name=radio.name;
		}
		this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
	},
	buttonclick:function(button,e,opts)
	{
		var flag=false;
		var me=this;
		var url='/final/monitor/serviceDashboardConfigP.jsp';
		var params='selectType=Update';
		var json=this.getConfigWindow().jsonData.Window.fields;
		var labels=this.getConfigWindow().jsonData.Window.screenlabels[0];
		for(var i=0;i<json.length;i++)
		{
			if(json[i].type=='combo')
			{
				var name=json[i].name;
				if(this.getConfigWindowForm().getForm().findField(name).getValue()==-1)
				{
					Ext.Msg.alert("",labels[name]);
					flag=true;
					break;
				}
				else
				{
					if(name=='serviceTest')
						name='testName';
					params+='&'+name+'='+json[i].selected;
				}
			}
			else
			{
				if(json[i].type=='textfield')
				{
					var dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
					flag=true;
					// Changes For ?,',- and Numbers charcters Support - Starts Here
					while(true){
						if(dispName.indexOf("?") != -1)
							dispName = dispName.replace('?','qqsstt');
						if(dispName.indexOf("'") != -1)
							dispName = dispName.replace("'","sinCour");
						if(dispName.indexOf("-") != -1)
							dispName = dispName.replace("-","minSym");

						if(dispName.indexOf("?") == -1 && dispName.indexOf("'") == -1 && dispName.indexOf("'") == -1)
							break;
					}

					if(dispName.length<1)
						Ext.Msg.alert("","Please enter display name");
					//else if(this.hasNumbers(dispName))
					//	Ext.Msg.alert("","Number not allowed");
					else if( this.hasSpecialCharacters(dispName) )
					{
						if(this.hasNumbers(dispName))
						{
							params+='&'+json[i].name+'='+dispName;
							flag=false;
						}
						else
							Ext.Msg.alert("","Special characters not allowed");
					}
					else
					{
						params+='&'+json[i].name+'='+dispName;
						flag=false;
					}
					// Changes For ?,',- and Numbers charcters Support - Ends Here
				}
				else
				{
					if(json[i].selected=='Component')
						json[i].selected='Application';
					params+='&'+json[i].name+'='+json[i].selected;
				}
			}
		}
		if(flag==false)
		{
			Ext.Ajax.request({
	       	    url: url,
	       	    params:params,
	       	    method : 'POST',
	       	    scope:this,
				      timeout:280000,
	       	    success: function(response) {
	       	    	//Ext.Msg.alert("Success","Done");
	       	    	var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
	       			var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
	       	    	var dispName="";
	       	    	var measureName=-1;
	       	    	var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
	       	    	var compname='';
	       	    	var componentType='';
	       	    	var descMeasureUnit='';
	       			var testfun='';
	       	    	if(perform=='Add')
	       			{
	       				//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
	       				//if(descMeasureUnit=='Yes')
	       				testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
	       				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
						Ext.Msg.alert("","Measure Added Successfully");
	       			}
					else if(perform=='Delete')
					{
						Ext.Msg.alert("","Measure Deleted Successfully");
					}
	       	    	if(selectedTab=='Component' || selectedTab=='Aggregate')
	       	    		componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
	       	    	this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
	       	    },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		if(flag==false)
		{
			Ext.Function.defer(function(){
				me.setValues(flag);
			},350);
		}
	},
	setValues:function(flag){
		if(flag==false)
		{
			var json1=this.getConfigWindow().jsonData.Window.fields;
			var f=false;
			for(var i=0;i<json1.length;i++)
			{
				if(json1[i].type=='combo')
				{
					if(json1[i].selected!='Not Applicable!')
							f=true;
					if(!f && this.getConfigWindowForm().getForm().getValues()['perform']=='Delete')
						this.getConfigWindowForm().getForm().findField(json1[i].name).setValue(-1);
				}
				f=false;
			}
		}
	},
	hasNumbers:function(t)
	{
		var regex = /\d/g;
		return regex.test(t);
	},
	hasSpecialCharacters:function(t)
	{
		return  /[^a-zA-Z ]/g.test(t);
	},
	loadActiveTabData:function(tabpanel){
		var activeTab = tabpanel.getActiveTab();
		tabpanel.currentTab = activeTab.itemId;

		var url = activeTab.url;
		url += "&selectNode=Segment$cap$"+tabpanel.currentSegment+"&selectedParam="+tabpanel.currentSegment+"&currentTab="+tabpanel.currentTab+"&aggregateTab="+tabpanel.aggregateTab;
		if(isFromServc)
			url += "&isFromService="+isFromServc;
		if(tabpanel.currentTab == 'components' && !Ext.isEmpty(requestParams.appCurrentHost)){
			url += '&appCurrentHost='+requestParams.appCurrentHost;
		}
		if(tabpanel.currentTab == 'aggregates' && !Ext.isEmpty(requestParams.aggregateComp)){
			url += '&aggregateComp='+requestParams.aggregateComp;
		}
		else if(tabpanel.currentTab == 'topology'){
		}		
		
		var fh_values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		url= url+"&fromHomepage="+fh_values;

		if(!Ext.isEmpty(parentZone) || !Ext.isEmpty(iszoneName) || !Ext.isEmpty(isFromZone))
			url = url+"&parentZone="+parentZone+"&iszoneName="+iszoneName+"&isFromZone="+isFromZone;
		
		if(selectedSystemCompType !=null && selectedSystemCompType != 'null' && selectedSystemCompType !='')
			url = url + "&appCurrentHost="+selectedSystemCompType;
		url += tabpanel.treeUrl;
		if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
			url = url+"&com.eg.CSRF_NONCE="+csrfToken;
		var maintainanceBtn = this.getDashboardMaintainanceButton();
		maintainanceBtn.setVisible(false);
		var segmentDashboardCombo = this.getSegmentsDashboard().tabBar.child('combo');
		if(segmentDashboardCombo != null)
		  segmentDashboardCombo.destroy();
		switch(activeTab.itemId){
			case "system":{
				activeTab.loadTab(url,'segmentsSys');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "components":{
				activeTab.loadTab(url,'segmentsComp');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "aggregates":{
				activeTab.loadTab(url,'segmentsAgg');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "topology":{
				url += "&segment="+tabpanel.currentSegment;
				this.getController('SegmentsTopology').segmentstopologyRender(url);
				maintainanceBtn.setVisible(false);
				break;
			}
		}
	},
	componentsComboChange:function(combo){
		var currentSegment = this.getSegmentsDashboard().currentSegment;
		var hostType=combo.getValue();
		var componentsUrl=this.getComponentsPanel().url;
		var url = componentsUrl+'&selectedNode=Segment$cap$'+currentSegment+'&selectedParam='+currentSegment+'&appCurrentHost='+hostType;
		
		var fh_values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		url= url+"&fromHomepage="+fh_values;

		if(!Ext.isEmpty(parentZone) || !Ext.isEmpty(iszoneName) || !Ext.isEmpty(isFromZone))
			url = url+"&parentZone="+parentZone+"&iszoneName="+iszoneName+"&isFromZone="+isFromZone;

		this.getComponentsPanel().loadTab(url,'segmentsComp');
	},
	aggregatesComboChange:function(combo){
		var currentSegment = this.getSegmentsDashboard().currentSegment;
		var hostType=combo.getValue();
		var aggregatesUrl=this.getAggregateTab().url;
		var url = aggregatesUrl+'&selectedNode=Segment$cap$'+currentSegment+'&selectedParam='+currentSegment+'&aggregateComp='+hostType;
		this.getAggregateTab().loadTab(url,'segmentsAgg');
	},
	systemsComboChange:function(combo){
		var hostType = combo.getValue();
		var systemsUrl = this.getSystemPanel().url;
		var currentSegment = this.getSegmentsDashboard().currentSegment;
		var url = systemsUrl+'&selectedNode=Segment$cap$'+currentSegment+'&selectedParam='+currentSegment+'&appCurrentHost='+hostType;

		var fh_values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		url= url+"&fromHomepage="+fh_values;

		if(!Ext.isEmpty(parentZone) || !Ext.isEmpty(iszoneName) || !Ext.isEmpty(isFromZone))
			url = url+"&parentZone="+parentZone+"&iszoneName="+iszoneName+"&isFromZone="+isFromZone;

		this.getSystemPanel().loadTab(url,'segmentsSys');
	},
	setDashboard:function(thisObj,opts){
		var aggTabFlag = thisObj.up('segmentsdashboard').aggregateTab;
		if(aggTabFlag == true){
			this.getSegmentsDashboard().child('[itemId=aggregates]').tab.show();
		}
		else{
			this.getSegmentsDashboard().child('[itemId=aggregates]').tab.hide();
		}
	},
	openServiceConfigWindow : function(button, evt)
	{
		var VWidth = Ext.Element.getViewportWidth( );
		if(!this.getConfigWindow())
		{
			var win=Ext.create('segments.view.ConfigWindow');
			win.show();
			container = Ext.create('Ext.container.Container',{
				padding:'10px 10px 0px 10px',
				floating:true,
				frame:true,
				width:515,
				hidden:true,
				//height:500,
				floatable:true,
				//id:'configMod',
				cls:'configMode_popup',
				items:[
					{
						xtype:'container',
						cls:'alarmTooltipArrow1',
						style:{'top':'-17px','left':'415px'}
					},
					{
						xtype:'container',
						margin:'-4px 0px 0px 4px',
						html:'<div class="settingsfont" style="float:left;color:#f7f7f7;text-transform:uppercase;margin-top:-5px;">Settings</div><div style="text-align:right;float:right;margin-top:-7px;"><div class="iconClose3"></div></div>',
					},
					win
				]
			});

			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
				   top:40,
					left: VWidth -615
				}
			});

			container.showAt(VWidth -615,5000);
			Ext.select('.iconClose3').on('click',function(){
				Ext.create('Ext.fx.Anim', {
					target: container,
					duration: 500,
					from: {
						left: VWidth -615,
						top:40
					},
					to: {
					   top:-500,
						left: VWidth -615
					},
					callback: function(){
						container.hide();
						segments.app.getController("SegmentsDashboard").loadActiveTabData(tabSettingRef);
					}
				});
			},this);

			Ext.getBody().on('click',function(event){
				var tarid = event.target.id;
				if(tarid != undefined && tarid != null && ((tarid.toLowerCase().indexOf("gridview") != -1) || (tarid.toLowerCase().indexOf("tabbar") != -1) || (tarid.toLowerCase().indexOf("toolbar") != -1) || (tarid.toLowerCase().indexOf("filter") != -1)))
				{
					container.hide();
				}
			});
		}
		else if(container.isHidden())
		{
			var win=this.getConfigWindow();
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
				   top:40,
					left: VWidth -615
				}
			});

			container.showAt(VWidth -615,5000);
		}
		else
		{
			container.hide();
			segments.app.getController("SegmentsDashboard").loadActiveTabData(tabSettingRef);
		}
	}
});