Ext.define('segments.controller.SegmentsTopology',{
	extend: 'Ext.app.Controller',
	views:['segments.view.SegmentsTopology'],
	stores : [],
	jsonData:null,
	refs:[{
	  ref:'segmentsTopology',
	  selector:'segmentstopology'
	},{
	  ref:'segmentsTopologyLabel',
	  selector:'segmentstopology label'
	},{
	  ref:'segmentsTopologyToolbar',
	  selector:'segmentstopology toolbar'
	},{
	  ref:'segmentsDashboard',
	  selector:'segmentsdashboard'
	},{
	  ref:'TransactionsMainPanel',
	  selector:'transactionsmainpanel'
	}],

	segmentstopologyRender:function(url){
		var me = this;
		urlForRefresh1=url;
		Ext.Ajax.request({
			url : url,
			timeout:280000,
			success: function(response){
				me.updatePanel(response);
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},

	updatePanel:function(response){
		var segmentTopology = this.getSegmentsTopology();
		segmentTopology.removeAll();
		var mytopologyid=Ext.getCmp('segmentstopologymain');
		var segmentDashboard = this.getSegmentsDashboard();
		var segmentDashboardCombo = segmentDashboard.tabBar.child('combo')
		if(segmentDashboardCombo != null){
		  segmentDashboardCombo.destroy();
		}
		var jsonText = response.responseText;
		var jsonData = Ext.decode(jsonText);
		this.getSegmentsDashboard().aggregateTab = jsonData.aggregateTab;
		this.jsonData = null;
		this.jsonData = jsonData;

		if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.segmentName)){
			var segment_state='<div style="float:left;margin-right:5px;" class="'+jsonData.segmentClass+'"></div><div style="float:left;font-size:13px;margin-top:3px;">'+jsonData.segmentName+'</div><div style="clear:both"></div>';
			//this.getSegmentsTopologyLabel().update(segment_state);

			if(!Ext.isEmpty(jsonData.selectFieldData)){
				var combo = new Ext.form.ComboBox({
					fieldLabel: jsonData.selectFieldData.selectLabel,
					store: Ext.create('Ext.data.Store',{
						fields:['value','name','url'],
						proxy:{
							type: 'memory',
							reader: {
							type: 'json',
							root:'selectOptions'
							}
						},
						data:jsonData.selectFieldData.selectOptions
					}),
					labelWidth:110,
					cls : 'dropdown',
					displayField:'name',
					labelSeparator:'',
					margin:'0 5 0 0',

					valueField:'value',
					value: jsonData.selectFieldData.selectedValue,
					editable:false,
					listeners:{
						scope : this,
						'select': this.comboItemSelected
					}
				});
				segmentDashboard.tabBar.insert(5,combo);
				 segmentTopology.add({
				xtype : 'panel',
				layout: {
						type: 'vbox',
						align: 'stretch'
				},
				flex:1,
				id:'myZoomdiv',
				items:[
				{
					xtype : 'panel',
//					width: 950,
					flex:1,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					//layout:'fit',
//					height: 920,
					id:'updateUrl'
					}
				]
				});
				//this.showZoombtn();
				//mytopologyid.doLayout();
			}
			if(jsonData.applet != 'true')
			{
				if(!Ext.isEmpty(Ext.getCmp('updateUrl')))
				{
					Ext.getCmp('updateUrl').update(jsonData.graphData);
				}
				else if(!Ext.isEmpty(segmentTopology))
				{
					segmentTopology.update(jsonData.graphData);
				}
			}
			else{
				var appletObject;
				appletObject = '<applet code="com.egurkha.EgTopology.class" codebase="/final/topology" align="center" id="my_applet" class="topoGraphAppDiv" width="600" height="480">'
				+'<param name="sessionId" value="1446C9E3FCC460E5B7AA9CC9ECA8D5E2" />'
				+'<param name="physical_topology" value="1" />'
				+'<param name="urlPrefix" value="http:" />'
				+'<param name="segment" value="seg_1" />'
				+'<param name="fromPage" value="serviceDashboard" />'

				if(!Ext.isEmpty(jsonData.appletParams.service))
				{
					+'<param name="service" value="'+jsonData.appletParams.service+'" />'
				}

				//+'<param name="site" value="'+jsonData.appletParams.site+'" />'
				+'<param name="r_uri" value="/final/monitor/segmentTopology.jsp" />'
				+'<param name="r_port" value="9999" />'
				+'<param name="r_host" value="192.168.8.175" />'
				+'<param name="r_protocol" value="HTTP/1.1" />'
				+'<param name="canvasType" value="segment" />'
				+'<param name="urlFinal" value = "http://192.168.8.175:9999/final" />'
				+'</applet>';
				segmentTopology.update(appletObject);
				console.log(appletObject);
			}
			segmentTopology.doLayout();
		}
	},
	comboItemSelected:function(comboItem){
		var comurl="";
		var segValue = comboItem.getValue();
		var store_data=comboItem.getStore();
		for(var k=0;k<store_data.getCount();k++)
		{
			var comValue=store_data.getAt(k).data.value;
			if(comValue==segValue)
			{
				comurl=store_data.getAt(k).data.url;
				break;
			}
		}
		 
	
	  segValue = encodeURI(segValue);
	  urlForRefresh1=comurl;
	  window.location.href=comurl;
	
	  
	  //var newUrl=this.getSegmentsTopology().url+'&segment='+segValue;
	  //urlForRefresh1=newUrl;
	 /*  Ext.Ajax.request({
		  url: newUrl,
		  scope:this,
		  success: function(response){
			  this.getSegmentsDashboard().currentSegment = segValue;
			  this.updatePanel(response);
		  },
		failure:function(){
			window.parent.location.href="/final/servlet/com.egurkha.Logout";
		}
	  });*/
	}
});