var noListData = false;
Ext.define('segments.view.OptionalListPanel', {
	extend : 'utilities.ScrollPanel',
	requires : ['segments.view.OptionalListComponent'],
	alias : 'widget.optionallistpanel',
	scroll:true,
	autoScroll:true,
	margin:'8 8 0 0',
	cls:'outerpanel',
	frame:true,
	border:true,
	style:{'border':'1px solid green'},
	showDashboard:false,
	autoDestroy:true,
	url : null,
	mask: null,
	header:{
		padding:'0 5 0 5',
		margin:0
	},
	layout: {
        type: 'vbox',
        align: 'stretch'
    },
	tools:[
	{
		xtype : 'button',
		cls:'iconAutomaticScrollRun',
		id:'iconAutomaticScrollRun',
		margin: '0px 4px 0px 4px',
		ui: 'action',
		hidden:true,
		style: {
			border: '1px'
		},
		handler:function(){
			scrollFlag=true;
			pageScroll();
			Ext.getCmp('iconAutomaticScrollRun').hide();
			//Ext.getCmp('iconAutomaticScrollStop').show();
		},
		listeners: {
			afterrender: function () {
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					autoDestroy:true,		//
					html: 'Auto Scroll'
				});
			}
		}
	},{
		xtype : 'button',
		cls:'iconAutomaticScrollStop',
		id:'iconAutomaticScrollStop',
		margin: '0px 4px 0px 4px',
		ui: 'action',
		hidden:true,
		style: {
			border: '1px'
		},
		handler:function(){
			scrollFlag=false;
			stopScroll();
			Ext.getCmp('iconAutomaticScrollStop').hide();
			//Ext.getCmp('iconAutomaticScrollRun').show();
		},
		listeners: {
			afterrender: function () {
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					autoDestroy:true,		//
					html: 'Pause'
				});
			}
		}
	},{
		xtype: 'tbseparator',
		cls:'removeLineForTvMode',
		hidden:true,
	},{
		xtype : 'button',
		cls:'iconAutomaticScrollJumpToTop',
		id:'iconAutomaticScrollJumpToTop',
		margin: '0px 5px 0px 5px',
		ui: 'action',
		hidden:true,
		style: {
			border: '1px'
		},
		handler:function(){
			scrollFlag=false;
			jumpScroll();
			Ext.getCmp('iconAutomaticScrollStop').hide();
			//Ext.getCmp('iconAutomaticScrollRun').show();
		},
		listeners: {
			afterrender: function () {
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					autoDestroy:true,		//
					html: 'Jump to top'
				});
			}
		}
	},{
		xtype: 'tbseparator',
		cls:'removeLineForTvMode',
		hidden:true,
	},{
		xtype : 'trigger',
		cls : 'whitedropdown_search',
		margin:'0 5 0 5',
		id:'segmentlistpanelsearch',
		name:'segmentlistpanelsearch',
		hidden:true,
		//emptyText : jsonData.screenLabels["searchDefaultText"] ? jsonData.screenLabels["searchDefaultText"] : "",
		//value : jsonData.screenLabels["searchText"] ? jsonData.screenLabels["searchText"] : "",
		onTriggerClick : function(e){
			this.fireEvent('click',this);
		}
	},
	{
		xtype: 'tbseparator',
		id:'segmentlistpanelsearch-tb',
	},
	{
		xtype : 'button',
		cls:'iconAssociation',
		action: 'association',
		margin: '0px 5px 0px 5px',
		hidden:true,
		id:'associationBtnId',
		name:'associationBtnId',
		style: {
				border: '0px'
		},
	},{
		xtype:'button',
		action:'back',
		hidden:true,
		id:'segmentlistpanelbackbtn',
		name:'segmentlistpanelbackbtn',
		cls:'backbutton',
		margin: '0px 5px 0px 5px',
		iconCls:'iconBack'
		//iconCls:'back-btn-icon'
	}],
	listeners:{
		afterrender:function(p){
			p.body.on('scroll',function(){
				var d = Ext.getCmp('optionallistpanel').body.dom;
				var listView = 'segments.view.OptionalListComponent';
				if(isScroll == true && d.scrollTop == d.scrollHeight - d.offsetHeight)
				{
					var stcnt = (startcount == null || startcount == '')?splitLen:startcount;
					var endcnt = stcnt+splitLen;
					endcnt = (endcnt>compLength)?compLength:endcnt;
					segments.app.getController("Main").bulkDataLoad(stcnt,endcnt,listView);
				}
			});
		}
	},

	initComponent : function(){
		var me = this;

		Ext.Ajax.request({
			url : me.url,
			//method : 'POST',
			success : function(response, opts){
				if(me.showDashboard){
					me.removeAll();
					var docked = me.getDockedItems();
					if(!Ext.isEmpty(docked)){
						for(i = 0; i < docked.length; i++){
							docked[i].hide();
						}
					}

					var treeUrl = '&treeOpen='+requestParams.treeOpen;
					if(!Ext.isEmpty(requestParams.selectedTreeNode))
						treeUrl += '&openNode='+requestParams.selectedTreeNode;

					me.hide();
					me.up('main').add({
						xtype:'segmentsdashboard',
						treeUrl:treeUrl,
						aggregateTab:requestParams.aggregateTab,
						currentTab:requestParams.selectedTab,
						currentSegment:requestParams.topoSegment,
						region:'center'
					});
				}
				else{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					/*if(!Ext.isEmpty(me.getEl())){
						me.getEl().mask("Loading...","maskDash");
					}*/

					var SearchString = jsonData["searchString"];
					if(!Ext.isEmpty(SearchString) && SearchString=='Search')
						SearchString = "";
					me.down('trigger[id=segmentlistpanelsearch]').emptyText = jsonData.screenLabels["searchDefaultText"] ? jsonData.screenLabels["searchDefaultText"] : "";
					me.down('trigger[id=segmentlistpanelsearch]').setValue(SearchString ? SearchString : "");
					noListData = false;
					if(jsonData["SearchNoListFound"] || !jsonData["showAssociations"]){
						noListData = true;
						me.down('button[action=association]').hide();
					}
					else{
						me.down('button[action=association]').show();
					}

					me.down('button[id=segmentlistpanelbackbtn]').setText(jsonData.screenLabels["backButtonText"] ? jsonData.screenLabels["backButtonText"] : "Back");

					/*me.addDocked({
						xtype : 'toolbar',
						height : 35,
						cls : 'component-list-right-panel-header component-list-right-panel-header-right',
						hidden : jsonData["NoListFound"],
						layout : 'hbox',
						flex : 1,
						items : [ '->', {
							xtype : 'trigger',
							cls : 'whitedropdown_search component-list-right-panel-header-right',
                            id:'segmentlistpanelsearch',
                        	name:'segmentlistpanelsearch',
							emptyText : jsonData.screenLabels["searchDefaultText"] ? jsonData.screenLabels["searchDefaultText"] : "",
							value : jsonData.screenLabels["searchText"] ? jsonData.screenLabels["searchText"] : "",
							onTriggerClick : function(e){
								this.fireEvent('click',this);
							}
						}, {
							xtype : 'button',
							cls : 'component-list-right-panel-header-button',
							hidden : jsonData["SearchNoListFound"] || !jsonData["showAssociations"],
							text : jsonData.screenLabels["Associations"] ? jsonData.screenLabels["Associations"] : "",
							action: 'association'
						}]
					});*/

					if(jsonData["SearchNoListFound"]) {
						var searchNoList = Ext.create('utilities.ErrorPanel',{
							border:false,
							flex:1,
							layout:'fit',
							errorMsg : '<div style="text-align:center;margin:17% auto 17% auto"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">'+jsonData["SearchNoListFoundText"]+'</div></div>',
							listeners:{
								boxready:function(){
									var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
									if (!Ext.isEmpty(scrollRun) )
									{
										scrollRun.hide();
									}
									ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
									if (!Ext.isEmpty(ScrollJumpToTop) )
									{
										ScrollJumpToTop.hide();
									}
									Ext.Element.select('.removeLineForTvMode').hide();
								}
							}
						});
						me.add(searchNoList);
					} else if(jsonData["NoListFound"]) {
						var noList = Ext.create('utilities.ErrorPanel',{
							border:false,
							flex:1,
							layout:'fit',
							errorMsg : '<div style="text-align:center;margin:17% auto 17% auto"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">'+jsonData["NoListFoundText"]+'</div></div>',
							listeners:{
								boxready:function(){
									var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
									if (!Ext.isEmpty(scrollRun) )
									{
										scrollRun.hide();
									}
									ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
									if (!Ext.isEmpty(ScrollJumpToTop) )
									{
										ScrollJumpToTop.hide();
									}
									Ext.Element.select('.removeLineForTvMode').hide();
								}
							}
						});
						me.add(noList);
					} else {
						var componentPanel =  Ext.create('Ext.container.Container',{
										layout:'column',
										margin:0,
										id:'componentPanel',
										//bodyCls:'service-testing services-borderzero',
										//autoScroll:true,
										//style:{'border':'1px solid blue'},
										border:false,
										//autoDestory:true,
									});

						rootComponentArray = jsonData["RootItem"];
						compLength = rootComponentArray.length;
						if(compLength > splitLen)
						{
							for(var componentCounter = 0 ; componentCounter < splitLen ; componentCounter++){
								var listComponent = Ext.create('segments.view.OptionalListComponent',{
									rootComponent : rootComponentArray[componentCounter]
								});
								componentPanel.add(listComponent);
							}
							me.add(componentPanel);
							isScroll = true;
						}
						else
						{
							for(var componentCounter = 0 ; componentCounter < rootComponentArray.length ; componentCounter++){
								var listComponent = Ext.create('segments.view.OptionalListComponent',{
									rootComponent : rootComponentArray[componentCounter]
								});
								componentPanel.add(listComponent);
							}
							me.add(componentPanel);
						}

					}
				}
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
				if(window.parent.globalsearch==true)
				{
					Ext.getCmp('segmentlistpanelbackbtn').hide();
					Ext.getCmp('segmentlistpanelsearch').hide();
					if(Ext.getCmp('segmentlistpanelsearch-tb')!=null){
					Ext.getCmp('segmentlistpanelsearch-tb').hide();
					}
					Ext.getCmp('associationBtnId').hide();
					if((!isFromServc) && !Ext.isEmpty(jsonData.screenLabels["searchResultText"]) && jsonData.screenLabels["searchResultText"]!='' && jsonData.screenLabels["searchResultText"]!=undefined)
					{
						if(window.parent.segmentSearchval!=null && window.parent.segmentSearchval!=undefined && window.parent.segmentSearchval!="")
						{
							me.setTitle(jsonData.screenLabels["searchResultText"]+'  \"'+window.parent.segmentSearchval +'\"');
						}
					}
				}
				else
				{
					Ext.getCmp('segmentlistpanelbackbtn').show();
					Ext.getCmp('segmentlistpanelsearch').show();
					Ext.getCmp('segmentlistpanelsearch-tb').show();
					Ext.getCmp('associationBtnId').show();
					var zoneView='';
					if (requestParams.fromHomepage=='true')
						zoneView='';
					else if(isFromZone!=null && isFromZone!=undefined && isFromZone!='undefined' && (isFromZone==true || isFromZone=='true'))
						zoneView='';
					else
						zoneView='zoneView';
					/* For Grid and list View Added New*/
						var zoneGroupZoneListBtn ="";
						if(!me.showDashboard)
						{
							Ext.defer(function(){
							zoneGroupZoneListBtn = Ext.create('Ext.container.Container',{
							layout: {
								type: 'hbox'
							},
							width: 100,
							padding:'2 0 0 0',
							margin:'0 0 0 10',
							//text:'Group View',
							renderTo:zoneView,
							items: [
								{
									xtype: 'button',
									cls:'iconGroupViewDisable removeButtonCurve',
									margin:0,
									padding:0
								},{
									xtype: 'button',
									cls:'iconListView removeButtonCurve',
									margin:0,
									padding:0,
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: listViewTxt
											});
										}
									},
									handler: me.segmentonListviewChange
								}]
						});
						},500);
						if(!Ext.isEmpty(jsonData))
						{
							if(jsonData.screenLabels["ListTitle"]){
								var htm = '<div style="float:left;">'+jsonData.screenLabels["ListTitle"]+'</div><div style="float:left" id="zoneView"></div>';
								me.setTitle(htm)
							}else{
								me.setTitle('&nbsp;')
							}
						}
						delete zoneGroupZoneListBtn;
					}
				}
				if(hideBackButton){
					Ext.getCmp('segmentlistpanelbackbtn').hide();
				}
		
				if(noListData && Ext.isEmpty(segmentSearchText))
				{
					Ext.getCmp('associationBtnId')!=null?Ext.getCmp('associationBtnId').hide():Ext.getCmp('associationBtnId').show();
					Ext.getCmp('segmentlistpanelbackbtn')!=null?Ext.getCmp('segmentlistpanelbackbtn').show():Ext.getCmp('segmentlistpanelbackbtn').show();
					Ext.getCmp('segmentlistpanelbackbtn')!=null?Ext.getCmp('segmentlistpanelsearch-tb').show():Ext.getCmp('segmentlistpanelsearch-tb').show();
					Ext.getCmp('associationBtnId')!=null?Ext.getCmp('associationBtnId').hide():Ext.getCmp('associationBtnId').show();
					Ext.getCmp('segmentlistpanelsearch')!=null?Ext.getCmp('segmentlistpanelsearch').hide():Ext.getCmp('segmentlistpanelsearch').show();
				}
			},
			failure : function(){alert("failure");}
		});

		this.callParent();
	},
	segmentonListviewChange: function()
	{

		//localStorage.setItem('segmentoptionallistpanel', '2');

		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	var segmentmain=Ext.getCmp('segmentmain');

	var contentPanel={
				xtype:'listpanel',
				id:'listpanel',
				region:'center',
				flex:4,
				mask: mask,
				url:'/final/monitor/segments.jsp'
			};
			var Mainpanel=[{
			xtype:'segmentstreepanel',
			id:'segmentstreepanel',
			border : false,
			header : false,
			region:'west',
			cls:'removeTreeLeftBorder',
			collapsed: !requestParams.treeOpen,
			url : "/final/monitor/segmentTree.jsp?tree=SegmentTreeModel&width=208&str=sessionID&node=Segment&treeTitle=Segments",
			split: true,
			collapseMode :'mini',
			collapsible: true,
			flex:1,
			//width: 250,
			maxWidth:350,
			minWidth : 150
		},contentPanel];
	segmentmain.removeAll();
	segmentmain.add(Mainpanel);
	segmentmain.doLayout();
	//Ext.widget('optionallistpanel',{region:'center',flex:4,url : '/final/monitor/zones.jsp'}).show();
	}
});
