Ext.define('segments.view.SegmentsTreePanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.segmentstreepanel',
	layout : 'fit',
	bodyCls:'top-left-radius bottom-left-radius',
	autoDestroy:true,
//	requires:['Ext.data.TreeModel'],
//	cls : 'tree-panel',
	url : null,
	nodeId:null,
	id:'segmentstreepanel',
	treePanelTitle : treePanelTitle,
	currentNode:null,
	initComponent : function(){
		this.loadTree();
		this.callParent();
	},

	loadTree:function(){
		var me = this;
		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				jsonData["expanded"] = true;
				jsonData["cls"] = "list-tree-root-expand-collapse";
				var treePanelStore = Ext.create('Ext.data.TreeStore', {
					id:'treestore',
					//clearOnLoad : true,
					root : jsonData
				});

				var treePanel = Ext.create('utilities.TreeScrollPanel',{
					store : treePanelStore,
					cls:'treePanelDesign',
					margin:'8 0 0 8',
					border : true,
					frame:true,
					iconCls:'segment20_GRAY',
					//selModel: Ext.create("Ext.selection.TreeModel", { mode : 'MULTI'}),
					title : me.treePanelTitle,
					useArrows: true,
					rootVisible : true,
					stateId:'services-tree-panel-stateId',
					id:'select',
				});
				me.add(treePanel);
			},
			failure : function(response, opts){
				alert("Failure");
			}
		});
	}
});
