Ext.define('serviceHealth.controller.Main',{
	extend: 'Ext.app.Controller',
	views:['serviceHealth.view.Main','serviceHealth.view.ServiceHealth','serviceHealth.view.ServiceHealthComponent'],
	
	refs : [{
		ref : 'servicehealth',
		selector : 'servicehealth'
	}
	],
	jsonData:null,
	
	init : function() {
		
		setInterval("execute()",refreshFrequency);
		
		this.control({
			'servicehealth' : {
	
				render : function(){
					Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceHealth&action=serviceHealth',
						method : 'POST',
						scope:this,
						success : function(response, opts){
						
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							this.jsonData=jsonData;
							this.getServicehealth().createcom(jsonData);
						},
	
						failure : function(){alert("failure");}
					});
				}
			},
			'servicehealth > header > button[action=back]': {
       			click:this.backButtonHandler
			}
		});
	},
	
	backButtonHandler:function(btn){
		var treeSession=requestParams.treeSession;
		var backButtonFunction="";
		treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
		if(treeSession.indexOf("showDashboard")>0 )
		{
			backButtonFunction=treeSession;
		}
		if(backButtonFunction.length>0)
		{
			document.location=backButtonFunction;
		}
		else
		{
			if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
			{
				window.history.go(-2);
			}
			else
			{
				window.history.go(-1);
			}
		}
	},

	graphClickHandler:function(serviceName){
		
		var URL = this.jsonData.HiddenFields.serviceTopoUrl;
		
		var Newurl = URL.replace(/SERVICE_NAME/g , serviceName);
		
		document.location = Newurl;
	
	},
	
	refresh:function(refreshURL){
		document.location = refreshURL;
	}
});