Ext.define('serviceHealth.view.ServiceHealthComponent', {
	extend : 'Ext.panel.Panel',
	requires:['Ext.layout.container.VBox'],
	alias : 'widget.servicehealthcomponent',
	//bodyCls:'top-right-radius bottom-right-radius top-left-radius bottom-left-radius servicegroupblock-bg shadow-widget',
	autoScroll : false,
	url : null,
	cls:'block1',
	height :276,
	//padding : 10,
	margin:10,
	//style:{'border':'1px solid green'},
	width:230,
	//columnWidth:.25,
	frame : false,
	border : true,
	jsonData : null,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },

	initComponent : function(){


		var jsonData=this.jsonData;

		var myArray=new Array();
		var chartHealthService = [];
		for(var j=0;j<jsonData.Components.length;j++){

			var childText='<a class="component-list-right-link" data-qclass="yellowTip" href="'
				+ jsonData.Components[j].URL
				+ '" data-qtip="'
				+ jsonData.Components[j].tooltip
				+ '" href="">'+jsonData.Components[j].NameText+'</a>';

			myArray.push({

				 text: childText,
				 leaf: true,
				 iconCls : "state_" + jsonData.Components[j].StateName,
				 href : jsonData.Components[j].URL,
				 cls:'blockgroup-bgwhitepad'

			});
		}

		var treestore = Ext.create('Ext.data.TreeStore', {
		    root: {
		        expanded: true,
		        children: myArray
		    }
		});

		var tree = Ext.create('utilities.ScrollableTreePanel', {
			store: treestore,
			autoScroll:true,
		    border : true,
		   // flex :1,
		    height :126,
			//style:{'border':'1px solid #ff0000'},
		    rootVisible: false,
		    bodyCls:'blockTree ',
		    cls:'serviceHealthHeader'
		    });
		    var legend_html="";
			for(var i=0 ; i < jsonData.Count.length ; i++)
			{
				legend_html = legend_html +  '<div class="legend-outer" style="float:left;margin:2px;display:inline-block;"><div class="legend'+jsonData.Count[i].State+' legend-state"></div> <span class="legend-state-per">'+ jsonData.Count[i].State_Per_Value +'%</span></div>';
			}
			 //jsonData.XMLInfo.XMLData
			 //jsonData.XMLInfo.chartFile
			 //legend_html

		if(jsonData.isSite === true)
		{
			var name = jsonData.NameText + '(' + jsonData.isSiteText + ')';
		}
		else
		{
			var name = jsonData.NameText;
		}

		this.title = '<a href="'+jsonData.URL+'">'+name+'</a>';

		var chartXmlObject = parseXml(jsonData.XMLInfo.XMLData);

		if(chartXmlObject)
			chartXmlObject.documentElement.setAttribute('clickURL',jsonData.URL);

		var chartXmlString = parseString(chartXmlObject);

		var chartDivId = 'serviceHealthBlock'+jsonData.NameText;
		var htmlstring = "";
		//alert("jsonData.legendPos-->"+jsonData.legendPos);
		if(jsonData.legendPos=='right')
		{
			htmlstring = '<div style="height:90%;width:70%;margin:5px;float:left" id="serviceHealthBlock'+jsonData.NameText+'" >'
			+'</div>'
			+'<div style="height:90%;margin:auto">'+legend_html+'</div>'
		}
		else
		{
			htmlstring = '<div style="height:75%;width:90%;margin:5px" id="serviceHealthBlock'+jsonData.NameText+'" >'
			+'</div>'
			+'<div style="height:25%;margin:auto">'+legend_html+'</div>'
		}

		this.items =[{
			xtype : 'panel',
			html : htmlstring,
			chartXml:chartXmlString,
			swfFile:jsonData.XMLInfo.chartFile,
			divId:chartDivId,
			height: 120,
			border:true,
			cls : 'component-list-top',
			listeners:{
				afterrender:function(panel){
					if (FusionCharts("serviceHealthChartId"+jsonData.NameText))
						FusionCharts("serviceHealthChartId"+jsonData.NameText).dispose();

					chartHealthService[j] = new FusionCharts('/final/FusionCharts/swf/'+panel.swfFile+'.swf', 'serviceHealthChartId'+jsonData.NameText, '100%', '95', '0', '1' );
					chartHealthService[j].setXMLData(panel.chartXml);
					chartHealthService[j].setTransparent(true);
					chartHealthService[j].render(panel.divId);
				}
			}
		},

		/*{
			xtype:'panel',
			border:false,
			height:8,
			html:'<img class="serviceimage" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7"/>'
		},*/tree];

		this.callParent();
	}

});