

var container="";
var tabSetting="";
Ext.define('services.controller.ServicesDashboard', {
	extend: 'Ext.app.Controller',
	requires:['services.view.ServicesDashboard','services.view.ConfigWindow','services.view.ServiceTransactionPanel'],
	stores:['SortRetain'],

	refs:[{
		ref:'systemPanel',
		selector:'dashboardgeneralmeasuresgridpanel[itemId="system"]'
	},{
		ref:'componentsPanel',
		selector:'dashboardgeneralmeasuresgridpanel[itemId="components"]'
	},{
		ref:'aggregateTab',
		selector:'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"]'
	},{
		ref:'topologyPanel',
		selector:'servicesdashboard servicestopology'
	},{
		ref:'transactionPanel',
		selector:'servicesdashboard transactionsmainpanel'
	},{
		ref:'dashboardMaintainanceButton',
		selector:'servicesdashboard > tabbar > button[action="maintainance"]'
	},{
		ref:'dashboardBackButton',
		selector:'servicesdashboard > tabbar > button[action="back"]'
	},{
		ref:'configWindowRadio',
		selector:'configwindow > form > radio'
	},{
		ref:'configWindow',
		selector:'configwindow'
	},{
		ref:'configureTransactions',
		selector:'configuretransactions'
	},{
		ref:'configWindowForm',
		selector:'configwindow > form'
	},{
		ref:'componentsPanelCombo',
		selector : 'dashboardgeneralmeasuresgridpanel[itemId="components"] > panel > toolbar > combobox',
	},{
		ref:'aggregatesPanelCombo',
		selector : 'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"] > panel > toolbar > combobox',
	},{
		ref : 'serviceTransactionPanel',
		selector : 'servicetransactionpanel'
	},{
		ref : 'servicesDashboard',
		selector : 'servicesdashboard'
	}],

	init: function() {
		this.control({
			'servicesdashboard': {
				scope:this,
				tabchange: function(tabpanel){
					tabSettingRef=tabpanel;
					showDashboard = null;
					tabSetting = tabpanel.getActiveTab();
					var tabId = tabpanel.getActiveTab().itemId;
					if(!Ext.isEmpty(this.getConfigureTransactions()))
						this.getConfigureTransactions().destroy();
					this.loadActiveTabData(tabpanel);
					if(container!='' && container!='undefined') 	
						container.hide();
					parent.parent.closeDiv();
				},
				afterrender: this.zonesDashboardAfterRenderHandler,
				beforetabchange: this.renewSortState
			},
			'dashboardgeneralmeasuresgridpanel[itemId="components"] > panel > toolbar > combobox':{
				change:this.componentsComboChange
			},
			'dashboardgeneralmeasuresgridpanel[itemId="components"] > toolbar > combobox':{
				change:this.componentsComboChange
			},
			'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"] > panel > toolbar > combobox':{
				change:this.aggregatesComboChange
			},
			'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"] > toolbar > combobox':{
				change:this.aggregatesComboChange
			},
			'dashboardgeneralmeasuresgrid':{
				sortchange : this.getSortDetails,
				render : this.retainColumnSort
			},
			'servicesdashboard > tabbar > button[action="maintainance"]':{
				scope : this,
				click : this.openServiceConfigWindow
			},
			'servicesdashboard > tabbar > button[action="back"]':{
				click:this.backButtonHandler
			},
			'configwindow':{
				'render': this.itemset,
				'close':this.refreshcall
			},
			'configwindow > form > combo':{
				'select':this.combo
			},
			'configwindow > form > radiogroup':{
				'change':this.radio
			},
			'configwindow > toolbar > button[action="submit"]':{
				click:this.buttonclick
			}
		});
	},

	renewSortState:function(thisObj,opts){
		this.getSortRetainStore().getProxy().clear();
	},

	retainColumnSort:function(thisObj,opts){
		var store = this.getSortRetainStore();
		store.load();
		var panelId = null;
		if(!Ext.isEmpty(thisObj.up('dashboardgeneralmeasuresaggregatepanel')) && !Ext.isEmpty(thisObj.up('dashboardgeneralmeasuresaggregatepanel').itemId)){
			panelId = thisObj.up('dashboardgeneralmeasuresaggregatepanel').itemId;
		}
		if(Ext.isEmpty(panelId)){
			panelId = thisObj.up('dashboardgeneralmeasuresgridpanel').itemId;
		}
		var record = store.findRecord('panelId',panelId);
		if(!Ext.isEmpty(record)){
			thisObj.store.sort(record.get('dataIndex'),record.get('direction'));
		}
	},

	getSortDetails:function(ct, column, direction, eOpts){
		var objFlag = true;
		var panelId = null;
		if(!Ext.isEmpty(ct.up('dashboardgeneralmeasuresgridpanel')) && !Ext.isEmpty(ct.up('dashboardgeneralmeasuresgridpanel').itemId)){
			panelId = ct.up('dashboardgeneralmeasuresgridpanel').itemId;
		}
		if(Ext.isEmpty(panelId)){
			panelId = ct.up('dashboardgeneralmeasuresaggregatepanel').itemId;
		}
		var object = {
			panelId:panelId,
			dataIndex:column.dataIndex,
			direction:direction
		}
		var store = this.getSortRetainStore();
		if(store.getCount() != 0){
			store.each(function(record){
				if(record.get('panelId') == object.panelId){
					record.set(object);
					objFlag = false;
					return false;
				}
			},this);
		}
		if(objFlag)
			store.add(object);
		store.sync();
		store.commitChanges();
	},

	refreshcall:function(configwindow,opts){
		var serviceChosen = this.getServicesDashboard().currentService;
		var param = "&selectNode=Service$cap$"+serviceChosen+"&selectedParam="+serviceChosen;

		var systemObj = this.getServicesDashboard().child('dashboardgeneralmeasuresgridpanel#system');
		var componentObj = this.getServicesDashboard().child('dashboardgeneralmeasuresgridpanel#components');
		var aggregateObj = this.getServicesDashboard().child('dashboardgeneralmeasuresaggregatepanel#aggregates');
		systemObj.loadTab(systemObj.url+param,'servicesSys');
		if(!Ext.isEmpty(this.getComponentsPanelCombo()))
			param += '&appCurrentHost='+this.getComponentsPanelCombo().getValue();
		componentObj.loadTab(componentObj.url+param,'servicesComp');
		if(!Ext.isEmpty(aggregateObj)){			// Premkumar
			if(!Ext.isEmpty(this.getAggregatesPanelCombo()))
				param += '&aggregateComp='+this.getAggregatesPanelCombo().getValue();
			aggregateObj.loadTab(aggregateObj.url+param,'servicesAgg');
		}
	},

	backButtonHandler:function(btn)
	{					//Back button
		var me = this;
		var values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";		//Kaliraj
	
		if(me.getServicesDashboard().hasTransactions == 'true' || me.getServicesDashboard().hasEmulatedTransactions == 'true')		// Prem
		{
			var transactionActivePanel = me.getServiceTransactionPanel().getLayout().getActiveItem();
			var transactionActivePanel = me.getServiceTransactionPanel();
			var activeTab = me.getServicesDashboard().getActiveTab();
			if(activeTab.xtype=="servicetransactionpanel" && transactionActivePanel.xtype=="zoomgraphpanel"){
				me.getServiceTransactionPanel().getLayout().setActiveItem(0);
			}
			else{

				var treeSession=requestParams.treeSession;
				var backButtonFunction="";
				treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
				if(treeSession.indexOf("showDashboard")>0)
				{
					backButtonFunction=treeSession;
				}
				if(me.getConfigureTransactions())
				{
					window.history.go(0);
					return;
				}
				if(backButtonFunction.length>0)
				{
					window.history.go(-2);
				}
				else if(requestParams.from=="ServiceGroup")
				{
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=serviceGroup';
				}
				else
				{
					if(!Ext.isEmpty(values))					//	Kaliraj Changes start here
					{
						if(this.getServicesDashboard().currentTab=='topology')
						{	
							document.location="/final/monitor/serviceDashboard.jsp?action=service&treeFlag=treeFlag&treeTitle=services&outsideService=true&selectNode=Service$cap$&selectedParam="+requestParams.topoSegment+"&topoSegment="+requestParams.topoSegment+"&currentTab=transactions&isSite="+requestParams.isSite+"&aggregateTab="+requestParams.aggregateTab+"&hasTransactions="+requestParams.hasTransactions+"&hasEmulatedTransactions="+requestParams.hasEmulatedTransactions+"&treeOpen=false&openNode=Services&fromPage=serviceTree&fromHomepage="+requestParams.fromHomepage+"&zoneName="+iszoneName+"&iszoneName="+iszoneName+"&parentZone="+requestParams.parentZone;
						}
						else if(this.getServicesDashboard().currentTab=='transactions')
						{	
							if(!Ext.isEmpty(iszoneName) && iszoneName!='' && iszoneName!='null')
							{
								document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+"&parentZone="+requestParams.parentZone;
							}
							else if(requestParams.fromHomepage==undefined || requestParams.fromHomepage=='undefined')
							{
								document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&parentZone='+requestParams.parentZone;
							}
							else
							{
								document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
							}
							//window.history.go(-3);
						}
						else{
							document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
						}
					}
					else if(Ext.isEmpty(values))					//	Kaliraj Changes start here
					{
						if(this.getServicesDashboard().currentTab=='topology')
						{		
							document.location="/final/monitor/serviceDashboard.jsp?action=service&treeFlag=treeFlag&treeTitle=services&outsideService=true&selectNode=Service$cap$&selectedParam="+requestParams.topoSegment+"&topoSegment="+requestParams.topoSegment+"&currentTab=transactions&isSite="+requestParams.isSite+"&aggregateTab="+requestParams.aggregateTab+"&hasTransactions="+requestParams.hasTransactions+"&hasEmulatedTransactions="+requestParams.hasEmulatedTransactions+"&treeOpen=false&openNode=Services&fromPage=serviceTree&fromHomepage="+requestParams.fromHomepage+"&zoneName="+iszoneName+"&iszoneName="+iszoneName+"&isFromZone="+isFromZone+"&parentZone="+requestParams.parentZone;
						}
						else if(this.getServicesDashboard().currentTab=='transactions')
						{	
							//var searchType = parent.getSearchComboObj().getValue();
							//var searchValue = parent.getSearchBoxObj().getValue();

							var searchType = '';
							var searchValue = '';
							try{
								searchType = parent.getSearchComboObj().getValue();
								searchValue = parent.getSearchBoxObj().getValue();
							}
							catch(e)
							{
								searchType = parent.parent.getSearchComboObj().getValue();
								searchValue = parent.parent.getSearchBoxObj().getValue();
							}
							if(!Ext.isEmpty(iszoneName) && iszoneName!='' && iszoneName!='null' && iszoneName!='undefined')
							{
								document.location='/final/monitor/zoneDash.jsp?&selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+"&parentZone="+requestParams.parentZone;
							}
							else if(!Ext.isEmpty(isFromZone) && isFromZone=="true")
							{								
								if (searchType!=null && searchType=='zone' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
								{
									document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=zoneList&action=globalsearch&searchString='+encodeURIComponent(searchValue);
								}					
								else
								{
									document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
								}								
							}	
							else
							{
								if (searchType!=null && searchType=='service' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
								{
									document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceList&action=globalsearch&searchString='+searchValue;
								}
								else
								{
									document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true';
								}
							}
							//window.history.go(-3);
						}
					}
					else if(requestParams.from=="ServiceGroup" || requestParams.from=="MainDashboard")
					{
						if(!Ext.isEmpty(iszoneName) && iszoneName!='' && iszoneName!='null' && Ext.isEmpty(values))
						{
							document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+"&parentZone="+requestParams.parentZone;
						}
						else if(this.getServicesDashboard().currentTab=='topology')
						{
							document.location="/final/monitor/serviceDashboard.jsp?action=service&treeFlag=treeFlag&treeTitle=services&outsideService=true&selectNode=Service$cap$&selectedParam="+requestParams.topoSegment+"&topoSegment="+requestParams.topoSegment+"&currentTab=transactions&isSite="+requestParams.isSite+"&aggregateTab="+requestParams.aggregateTab+"&hasTransactions="+requestParams.hasTransactions+"&hasEmulatedTransactions="+requestParams.hasEmulatedTransactions+"&treeOpen=false&openNode=Services&fromPage=serviceTree&fromHomepage="+requestParams.fromHomepage;
						}
						else
						{
							document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
							
						}
					}
					else if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh==true)
					{
						window.history.go(-2);
					}
					else if(values)						//	Kaliraj Changes start here
					{
						window.history.go(-1);
					}
					else
					{
						//window.history.go(-2);
						//var searchType = parent.getSearchComboObj().getValue();	
						//var searchValue = parent.getSearchBoxObj().getValue();	
						var searchType = '';
						var searchValue = '';
						try{
							searchType = parent.getSearchComboObj().getValue();
							searchValue = parent.getSearchBoxObj().getValue();
						}
						catch(e)
						{
							searchType = parent.parent.getSearchComboObj().getValue();
							searchValue = parent.parent.getSearchBoxObj().getValue();
						}
						if (searchType!=null && searchType=='service' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
						{
							document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceList&action=globalsearch&searchString='+searchValue;
						}
						else
						{
							document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true';
						}
						//window.history.go(0);
					}										//	Kaliraj Changes end here
				}
			}
		}
		else
		{
			var treeSession=requestParams.treeSession;
			var backButtonFunction="";
			treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
			if(treeSession.indexOf("showDashboard")>0)
			{
				backButtonFunction=treeSession;
			}
			if(me.getConfigureTransactions())
			{
				window.history.go(0);
				return;
			}
			if(backButtonFunction.length>0)
			{
				window.history.go(-2);
			}
			else if((!Ext.isEmpty(treeSession)) && treeSession.indexOf("zoneDash.jsp")>-1 && treeSession.indexOf("zoneDash.jsp?") == -1)
			{
				document.location=treeSession;
			}
			else
			{				
				if(!Ext.isEmpty(values))					//	Kaliraj Changes start here
				{	
					if(!Ext.isEmpty(iszoneName) && iszoneName!='' && iszoneName!='null')
					{	
						document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+"&parentZone="+requestParams.parentZone;
					}
					else if( requestParams.topoSegment != null && requestParams.topoSegment != '' && requestParams.topoSegment != 'null' && rumHost != null && rumHost != '' && rumHost != 'null' ){
						
						document.location='/final/monitor/realUserMonitorsDashboard.jsp?fromDashboard=true&from=serviceDash&layersTitle='+rumHost+'&corsopndsSite='+requestParams.topoSegment;
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
					}
					//window.history.go(-1);
					//window.history.go(-3);
				}
				else if(!Ext.isEmpty(iszoneName) && iszoneName!='' && iszoneName!='null' && Ext.isEmpty(values))
				{
						document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&iszoneName='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+"&parentZone="+requestParams.parentZone;
				}
				else if(!Ext.isEmpty(isFromZone) && isFromZone=='true' && Ext.isEmpty(values))
				{					
					//var searchType = parent.getSearchComboObj().getValue();	
					//var searchValue = parent.getSearchBoxObj().getValue();	
					var searchType = '';
					var searchValue = '';
					try{
						searchType = parent.getSearchComboObj().getValue();
						searchValue = parent.getSearchBoxObj().getValue();
					}
					catch(e)
					{
						searchType = parent.parent.getSearchComboObj().getValue();
						searchValue = parent.parent.getSearchBoxObj().getValue();
					}
					if (searchType!=null && searchType=='zone' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=zoneList&action=globalsearch&searchString='+encodeURIComponent(searchValue);
					}					
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
					}					
				}
				/*else if(requestParams.from=="MainDashboard")
				{	
					var tabs = this.getServicesDashboard().getTabBar().query('tab');
					this.getServicesDashboard().setActiveTab(tabs.length-2);
					var tabpanel = this.getServicesDashboard().getActiveTab();
					var isSite = tabpanel.isSite;
					var hasEmulatedTransactions = tabpanel.hasEmulatedTransactions;
					var hasTransactions = tabpanel.hasTransactions;
					this.loadActiveTabData(tabpanel);
					/*if(isSite=='true' && (hasTransactions=='true' || hasEmulatedTransactions=='true'))
					{
						this.loadActiveTabData(tabpanel);
					}else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true';
					}
				}*/
				else if(requestParams.pageComesfrom=="serviceHealth")
				{
					document.location='/final/monitor/serviceHealthMain.jsp?isFromMenu=true';
				}
				else if(requestParams.pageComesfrom=="DispSiteSeg")
				{
					document.location="/final/monitor/EgPhysicalTopInfra.jsp?site="+requestParams.topoSegment+"&segment="+requestParams.seglist+"&ptype=topology&showsitesegments=true";
				}
				else if(requestParams.from=="ServiceGroup")
				{
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=serviceGroup';
				}
				else if(requestParams.from=="MainDashboard")
				{	
					var searchType = '';
					var searchValue = '';
					try{
						searchType = parent.getSearchComboObj().getValue();
						searchValue = parent.getSearchBoxObj().getValue();
					}
					catch(e)
					{
						searchType = parent.parent.getSearchComboObj().getValue();
						searchValue = parent.parent.getSearchBoxObj().getValue();
					}
					if(requestParams.fromHomepage==undefined || requestParams.fromHomepage=='undefined')
					{
						if(requestParams.actionLink=='undefined' || requestParams.actionLink==undefined)
						{							
							if (searchType!=null && searchType=='service' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
							{
								document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceList&action=globalsearch&searchString='+searchValue;
							}
							else
							{
								document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true';
							}
						}
						else
						{
							if (searchType!=null && searchType=='service' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
							{
								document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceList&action=globalsearch&searchString='+searchValue;
							}
							else
							{
								document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=serviceGroup';
							}
						}
					}
					else
					{
						if (searchType!=null && searchType=='service' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
						{
							document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceList&action=globalsearch&searchString='+searchValue;
						}
						else
						{
							document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true';
						}
					}
				}				
				else if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
				{
					window.history.go(-2);
				}
				else if(values)							// Changes start here ===Kaliraj
				{
					window.history.go(-1);
				}
				else
				{
					//window.history.go(0);
					var searchType = '';
					var searchValue = '';
					try{
						searchType = parent.getSearchComboObj().getValue();
						searchValue = parent.getSearchBoxObj().getValue();
					}
					catch(e)
					{
						searchType = parent.parent.getSearchComboObj().getValue();
						searchValue = parent.parent.getSearchBoxObj().getValue();
					}
					if (searchType!=null && searchType=='service' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceList&action=globalsearch&searchString='+searchValue;
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true';
					}
				}					// Changes end here ====Kaliraj
			}
		}
		parent.parent.closeDiv();
	},

	zonesDashboardAfterRenderHandler:function(tabpanel){
		this.loadActiveTabData(tabpanel);
	},

	itemset:function(window,e){
		window.add(window.setData("",""));
	},

	combo:function(combo,newvalue,opt){
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
		var testfun='';
		//if(descMeasureUnit=='Yes')
		testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		var name=combo.getName();
		var val=combo.getValue();
		var componentType;
		if(selectedTab=='Component' || selectedTab=='Aggregate')
			componentType=this.getConfigWindowForm().getForm().getValues()['serviceComp'];
		if(name=='serviceComp')
			this.getConfigWindow().setData(selectedTab,perform,componentType,"","","",descMeasureUnit,testfun,"", name, val);
		if(name=='compLayer')
		{
			var compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,"","",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceTest')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,"",descMeasureUnit,testfun,"", name, val);

		}
		else if(name=='serviceMeasure')
		{
			var compname;
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			else
				compname='';
			var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			var measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			var dispName=newvalue[0].data.name;
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName, name, val);
		}
		else{}
	},

	radio:function(radio,newvalue,oldvalue,opts){
		var name='';
		var componentType='';
		var compname='';
		var testName='';
		var measureName='';
		var dispName='';
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit='';
		var testfun='';
		if(perform=='Add')
		{
			//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
			//if(descMeasureUnit=='Yes')
			testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		}
		if(radio.getName()=='Does the Test have Descriptors ?'||radio.getName()=='Function')
		{
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			if(selectedTab=='Component' || selectedTab=='Aggregate')
				componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
			testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
			name=radio.name;
		}
		this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
	},

	buttonclick:function(button,e,opts)
	{
		var flag=false;
		var me=this;
		var url='/final/monitor/serviceDashboardConfigP.jsp';
		var params='selectType=Update';
		var json=this.getConfigWindow().jsonData.Window.fields;
		var labels=this.getConfigWindow().jsonData.Window.screenlabels[0];
		for(var i=0;i<json.length;i++)
		{
			if(json[i].type=='combo')
			{
				var name=json[i].name;
				if(this.getConfigWindowForm().getForm().findField(name).getValue()==-1)
				{
					Ext.Msg.alert("",labels[name]);
					flag=true;
					break;
				}
				else
				{
					if(name=='serviceTest')
						name='testName';
					params+='&'+name+'='+json[i].selected;
				}
			}
			else
			{
				if(json[i].type=='textfield')
				{
					var dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
					flag=true;

					// Changes For ?,',- and Numbers charcters Support - Starts Here
					while(true){
						if(dispName.indexOf("?") != -1)
							dispName = dispName.replace('?','qqsstt');
						if(dispName.indexOf("'") != -1)
							dispName = dispName.replace("'","sinCour");
						if(dispName.indexOf("-") != -1)
							dispName = dispName.replace("-","minSym");

						if(dispName.indexOf("?") == -1 && dispName.indexOf("'") == -1 && dispName.indexOf("'") == -1)
							break;
					}

					if(dispName.length<1)
						Ext.Msg.alert("","Please enter display name");
					//else if(this.hasNumbers(dispName))
					//	Ext.Msg.alert("","Number not allowed");
					else if(this.hasSpecialCharacters(dispName))
					{
						if(this.hasNumbers(dispName)){
							params+='&'+json[i].name+'='+dispName;
							flag=false;
						}
						else
							Ext.Msg.alert("","Special characters not allowed");
					}
					else
					{
						params+='&'+json[i].name+'='+dispName;
						flag=false;
					}

					// Changes For ?,',- and Numbers charcters Support - Ends Here
				}
				else
				{
					if(json[i].selected=='Component')
						json[i].selected='Application';
					params+='&'+json[i].name+'='+json[i].selected;
				}
			}
		}
		if(flag==false)
		{
			Ext.Ajax.request({
				url: url,
				params:params,
				method : 'POST',
				timeout:280000,
				scope:this,
				success: function(response){
					var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
					var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
					var dispName="";
					var measureName=-1;
					var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
					var compname='';
					var componentType='';
					var descMeasureUnit='';
					var testfun='';
					if(perform=='Add')
					{
						//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
						//if(descMeasureUnit=='Yes')
						testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
						compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
						Ext.Msg.alert("","Measure Added Successfully");
					}
					else if(perform=='Delete')
					{
						Ext.Msg.alert("","Measure Deleted Successfully");
					}
					if(selectedTab=='Component' || selectedTab=='Aggregate')
						componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
					this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		if(flag==false)
		{
			Ext.Function.defer(function(){
				me.setValues(flag);
			},350);
		}
	},

	setValues:function(flag){
		if(flag==false)
		{
			var json1=this.getConfigWindow().jsonData.Window.fields;
			var f=false;
			for(var i=0;i<json1.length;i++)
			{
				if(json1[i].type=='combo')
				{
					if(json1[i].selected!='Not Applicable!')
							f=true;
					if(!f && this.getConfigWindowForm().getForm().getValues()['perform']=='Delete')
						this.getConfigWindowForm().getForm().findField(json1[i].name).setValue(-1);
				}
				f=false;
			}
		}
	},

	hasNumbers:function(t)
	{
		var regex = /\d/g;
		return regex.test(t);
	},
	hasSpecialCharacters:function(t)
	{
		return  /[^a-zA-Z/ ]/g.test(t);
	},

	loadActiveTabData:function(tabpanel){
		var activeTab = tabpanel.getActiveTab();
		tabpanel.currentTab = activeTab.itemId;

		var url = activeTab.url;
		if(tabpanel.currentService.indexOf('(Site)') > -1){
			var serviceName = tabpanel.currentService;
			serviceName = serviceName.substring(0,serviceName.indexOf('(Site)'));
			tabpanel.currentService = serviceName;
		}

		var fh_values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		var tmpSelectNode = 'Service^'+tabpanel.currentService;
		if(!Ext.isEmpty(tmpSelectNode) && (tmpSelectNode.indexOf("^") != -1 || tmpSelectNode.indexOf("|") != -1))
		{
			tmpSelectNode = tmpSelectNode.replace('^','$cap$');
			tmpSelectNode = tmpSelectNode.replace('|','$pipe$');
		}
		url += "&selectNode="+tmpSelectNode+"&selectedParam="+tabpanel.currentService+"&currentTab="+tabpanel.currentTab+"&isSite="+tabpanel.isSite+"&aggregateTab="+tabpanel.aggregateTab+"&hasTransactions="+tabpanel.hasTransactions+"&hasEmulatedTransactions="+tabpanel.hasEmulatedTransactions+"&fromHomepage="+fh_values+"&hasLogonSimulations="+tabpanel.hasLogonSimulations;
		
		if(tabpanel.currentTab == 'components' && !Ext.isEmpty(requestParams.appCurrentHost)){
			url += '&appCurrentHost='+requestParams.appCurrentHost;
		}
		if(tabpanel.currentTab == 'aggregates' && !Ext.isEmpty(requestParams.aggregateComp)){
			url += '&aggregateComp='+requestParams.aggregateComp;
		}
		else if(tabpanel.currentTab == 'transactions' || tabpanel.currentTab == 'logon'){
			url += '&site='+tabpanel.currentService+'&isSite=true&serviceName='+tabpanel.currentService+'&fromLayer=false&selectNode='+tabpanel.currentService+'&selectedParam='+tabpanel.currentService+'&currentTab='+tabpanel.currentTab+'&transTab=true&from=null';
		}
		else if(tabpanel.currentTab == 'topology'){
			url += '&serviceName='+tabpanel.currentService+'&site='+tabpanel.currentService;
		}
		curServiceName = tabpanel.currentService;

		url += tabpanel.treeUrl+'&refresh=true&action='+requestParams.action+'&topoSegment='+tabpanel.currentService;
		if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
			url = url+"&com.eg.CSRF_NONCE="+csrfToken;
		var maintainanceBtn = this.getDashboardMaintainanceButton();
		maintainanceBtn.setVisible(false);
		var servicesDashboardCombo = this.getServicesDashboard().tabBar.child('combo');
		if(servicesDashboardCombo != null)
		  servicesDashboardCombo.destroy();
		switch(activeTab.itemId){
			case "system":{
				activeTab.loadTab(url,'servicesSys');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "components":{
				activeTab.loadTab(url,'servicesComp');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "aggregates":{
				activeTab.loadTab(url,'servicesAgg');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "transactions":{
				var compCombo = Ext.getCmp('componentCombo');
				if(!Ext.isEmpty(compCombo))
					compCombo.setVisible(false);
				compUrl = '';
				this.getController('ServicesTransactions').servicesTransactionRender(url);
				maintainanceBtn.setVisible(false);
				break;
			}
			case "logon":{
				compUrl = url;
				this.getController('ServicesTransactions').servicesTransactionRender(url);
				maintainanceBtn.setVisible(false);
				break;
			}
			case "topology":{
				compUrl = '';
				this.getController('ServicesTopology').servicestopologyRender(url);
				maintainanceBtn.setVisible(false);
				break;
			}
		}
	},

	componentsComboChange:function(combo){
		var currentService = this.getServicesDashboard().currentService;
		var hostType=combo.getValue();
		var componentsUrl=this.getComponentsPanel().url;
		var url = componentsUrl+'&selectedNode=Service$cap$'+currentService+'&selectedParam='+currentService+'&appCurrentHost='+hostType;
		this.getComponentsPanel().loadTab(url,'servicesComp');
	},

	aggregatesComboChange:function(combo){
		var currentService = this.getServicesDashboard().currentService;
		var hostType=combo.getValue();
		var aggregatesUrl=this.getAggregateTab().url;
		var url = aggregatesUrl+'&selectedNode=Service$cap$'+currentService+'&selectedParam='+currentService+'&aggregateComp='+hostType;
		this.getAggregateTab().loadTab(url,'servicesAgg');
	},

	openServiceConfigWindow : function(button, evt){
		
		var VWidth = Ext.Element.getViewportWidth( );
		if(!this.getConfigWindow())
		{
			var win=Ext.create('services.view.ConfigWindow');
			win.show();
			container = Ext.create('Ext.container.Container',{
				padding:'10px 10px 0px 10px',
				floating:true,
				frame:true,
				width:515,
				hidden:true,
				//height:500,
				floatable:true,
				//id:'configMod',
				cls:'configMode_popup',
				items:[
					{
						xtype:'container',
						cls:'alarmTooltipArrow1',
						style:{'top':'-17px','left':'420px'}
					},
					{
						xtype:'container',
						margin:'-4px 0px 0px 4px',
						html:'<div class="settingsfont" style="float:left;margin-top:-5px;">Settings</div><div style="text-align:right;float:right;margin-top:-7px;"><div class="iconClose3"></div></div>',
					},
						win
				]
			});
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
				   top:40,
					left: VWidth -615
				}
			});

			container.showAt(VWidth -615,5000);
			Ext.select('.iconClose3').on('click',function(){
					Ext.create('Ext.fx.Anim', {
						target: container,
						duration: 500,
						from: {
						left: VWidth -615,
							top:40
						},
						to: {
						   top:-500,
						left: VWidth -615
						},
						callback: function(){
							container.hide();
							services.app.getController("ServicesDashboard").loadActiveTabData(tabSettingRef);
						}
					});
			},this);
			
			Ext.getBody().on('click',function(event){
					var tarid = event.target.id;
					if(tarid != undefined && tarid != null && ((tarid.toLowerCase().indexOf("gridview") != -1) || (tarid.toLowerCase().indexOf("tabbar") != -1) || (tarid.toLowerCase().indexOf("toolbar") != -1) || (tarid.toLowerCase().indexOf("filter") != -1)))
					{
						container.hide();
					}
			});
		}
		else if(container.isHidden())
		{
			var win=this.getConfigWindow();
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
					top:40,
					left: VWidth -615
				}
			});
			container.showAt(VWidth -615,5000);
		}
		else
		{
			container.hide();
			services.app.getController("ServicesDashboard").loadActiveTabData(tabSettingRef);
		}
	}
});