var urlForRefresh1=null;
Ext.define('services.controller.ServicesTopology',{
	extend: 'Ext.app.Controller',
	requires:['services.view.ServicesTopology','services.view.ConfigureTransactions',
	       'services.view.TransactionImagesPanel','services.view.TransactionImagesGenericPanel'],
//	stores : ['services.store.TransactionsStore'],
	jsonData:null,
	refs:[{
		ref:'servicesTopology',
		selector:'servicestopology'
	},{
		ref:'servicesTopologyLabel',
		selector:'servicestopology label'
	},{
		ref:'servicesTopologyToolbar',
		selector:'servicestopology toolbar'
	},{
		ref:'servicesTransactionName',
		selector:'configuretransactions toolbar'
	},{
		ref:'servicesTransactionPages',
		selector:'configuretransactions toolbar textfield[action="tpage"]'
	},{
		ref:'servicesDashboard',
		selector:'servicesdashboard'
	},{
		ref:'TransactionsMainPanel',
		selector:'transactionsmainpanel'
	},{
		ref:'configuretransactions',
		selector:'configuretransactions'
	}],

	init: function() {
		this.control({
			'servicestopology toolbar button[action="configure"]' :{
				'click' : this.configureTransactionsWindow
			},
			'servicestopology configuretransactions transactionimagesgenericpanel radio' :{
				'change' : this.setTransactionName
			}
		});
	},

	servicestopologyRender:function(url){
		url += '&fromPage=serviceTree&fromTab=topology';
		var transFlag = this.getServicesDashboard().hasTransactions;
		if(transFlag == true || transFlag == 'true'){
			url+="&transactionsFlag=true";
		}
		urlForRefresh1 = url;
		Ext.Ajax.request({
			url : url,
			scope :this,
			timeout:280000,
			success : function(response){
				this.updatePanel(response);
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},

	updatePanel:function(response){
		var servicesPanel=this.getServicesTopology();
		servicesPanel.removeAll();
		var servicesDashboard=this.getServicesDashboard();
		var servicesDashboardCombo=servicesDashboard.tabBar.child('combo')
		if(servicesDashboardCombo != null){
			servicesDashboardCombo.destroy();
		}
		var jsonText = response.responseText;
		var jsonData=Ext.decode(jsonText);
		this.jsonData=null;
		this.jsonData=jsonData;
		this.siteName = jsonData.site;
		if(!Ext.isEmpty(jsonData.transactionLink)){
			var toolbar = this.getServicesTopologyToolbar();
			toolbar.getComponent('serviceToolbarButton').setVisible(true);
			toolbar.getComponent('serviceToolbarButton').setText(jsonData.transactionConfigLabel);
			//toolbar.getComponent('serviceToolbarForwardImage').setVisible(true);
		}
		if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.serviceName)){
			var service_state='<div style="float:left;margin-top: 10px;margin-left: 30px;" class="'+jsonData.serviceClass+'"></div><div style="padding: 2px;float: left;margin-top: 10px;margin-left: 3px;">'+jsonData.serviceName+'</div>';
			//this.getServicesTopologyLabel().update(service_state);

			if(!Ext.isEmpty(jsonData.selectFieldData) && !Ext.isEmpty(jsonData.selectFieldData.selectOptions))
			{
				var combo=new Ext.form.ComboBox({
					fieldLabel: jsonData.selectFieldData.selectLabel,
					store: Ext.create('Ext.data.Store',{
						fields:['value','name'],
						proxy:{
							type: 'memory',
							reader: {
								type: 'json',
								root:'selectOptions'
							}
						},
						data:jsonData.selectFieldData.selectOptions
					}),
					labelWidth:110,
					cls : 'dropdown',
					displayField:'name',
					labelSeparator:'',
					margin:'0 5 0 0',
					valueField:'value',
					id:'topoTopCombo',
					value: jsonData.selectFieldData.selectedValue,
					serviceName: jsonData.selectFieldData.serviceName,
					editable:false,
					listeners:{
						scope : this,
						'select': this.comboItemSelected
					}
				});
			
				if(servicesDashboard.aggregateTab)
				{
					servicesDashboard.tabBar.insert(6,combo);
				}
				else
				{
					servicesDashboard.tabBar.insert(5,combo);
				}
				
				servicesPanel.add({
					xtype : 'panel',
					layout: {
							type: 'vbox',
							align: 'stretch'
					},
					flex:1,
					id:'myZoomdiv',
					items:[
						{
							xtype : 'panel',
							flex:1,
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							//width: 950,
							//height: 920,
							id:'updateUrl'
						}
					]
				});
			}

			if(!Ext.isEmpty(Ext.getCmp('updateUrl')))
			{
				Ext.getCmp('updateUrl').update(jsonData.graphData);
			}
			else
			{
				servicesPanel.body.update(jsonData.graphData);
			}
			servicesPanel.doLayout();
		}
	},

	comboItemSelected:function(comboItem){
		var servName = comboItem.serviceName;
		servName = encodeURI(servName);
		var selValue = comboItem.getValue();
		selValue = encodeURI(selValue);
		var newUrl=this.getServicesTopology().url+'&service='+servName+'&segment='+selValue+"&site="+servName;
		Ext.Ajax.request({
			url: newUrl,
			scope:this,
			timeout:280000,
			success: function(response){
				this.updatePanel(response);
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
		parent.parent.closeDiv();
	},

	configureTransactionsWindow : function(button){
		if(button.text !='Back'){
			/*var newUrl=loadTransConfigOnTopo(this.siteName);
			Ext.Ajax.request({
				url: newUrl,
				scope:this,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					this.jsonData = jsonData;*/
					//var toolbar = this.getServicesTopologyToolbar();
					//toolbar.getComponent('serviceToolbarLabel').setText(jsonData.upperGridLabels.Header);
					//toolbar.getComponent('serviceToolbarButton').setText(jsonData.upperGridLabels.backBtnLabel);
					//toolbar.getComponent('serviceToolbarButton').setVisible(false);
					//toolbar.getComponent('serviceToolbarForwardImage').setVisible(false);
					/*this.getServicesTopology().body.update('');
					this.getServicesTopology().add({
						xtype : 'transactionsmainpanel'
					});
					//this.getController('ServicesTransactions').configureTransactionsHandler(true,this.siteName);*/
					this.configureTransactionsHandler(true,this.siteName);
				//}
			//});
		}
	},
	configureTransactionsHandler:function(fromTopo,site){
		if(!Ext.isEmpty(fromTopo) && fromTopo == true)
			this.siteName = site;
		var newUrl = loadTransConfigOnTopo(this.siteName);
		Ext.Ajax.request({
			url: newUrl,
			scope:this,
			timeout:280000,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				this.jsonData = jsonData;
				if(!Ext.isEmpty(fromTopo) && fromTopo == true)
					this.getController('ServicesTopology').jsonData = jsonData;
				//this.getTransactionsMainPanel().removeAll();
				var topToolbar=null;//this.getTransactionsMainPanel().getDockedItems('toolbar[dock="top"]');
				if(!Ext.isEmpty(topToolbar))
					topToolbar[0].setVisible(false);
				var items = this.getServicesTopology().ConfigurePanels(jsonData);
				//var selectButtonFlag = this.getTransactionsMainPanel().enableSelectAll;
				//Ext.getCmp('imagecombo').getStore().loadRawData(publicJSON['imageArray']);
				/*this.getTransactionsMainPanel().add({
					xtype : 'configuretransactions',
					items : items,
					flex : 1
				});*/
					var configWindow = Ext.create('Ext.window.Window',{
						cls:'alarmsbg lightbox',
						width:810,
						closeAction:'destroy',
						autoDestroy:true,
						frame:true,
						doClose: function() {
								var me = this;
								// Being called as callback after going through the hide call below
								if (me.hidden) {
									
									me.fireEvent('close', me);
									refreshURL = '../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service';
									services.app.getController("Main").refresh(refreshURL);
									if (me.closeAction == 'destroy') {
										this.destroy();
										if(!Ext.isEmpty(urlForRefresh1) && urlForRefresh1.indexOf(".jsp")>-1)
											services.app.getController('ServicesTopology').servicestopologyRender(urlForRefresh1);
									}
								} else {
									// close after hiding
									me.destroy();
									me.hide(me.animateTarget, me.doClose, me);
								}
						},
						modal:false,
						title:'CONFIGURE TRANSACTION DETAILS',
						height:510,
						margin:10,
						items : items,
						flex : 1
						//id:'w1'
				});
					configWindow.show();
				/*if((jsonData.upperGridLabels.transHeaders.length > 0) && selectButtonFlag)
					this.getSelectAllButton().show();
				if(!this.getDeselectAllButton().isHidden())
					this.getDeselectAllButton().hide();
				if(!this.getDeleteTransactionsButton().isHidden())
					this.getDeleteTransactionsButton().hide();*/
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	addTransaction : function(button){
		var tName= this.getServicesTransactionName().getComponent('tname').getValue();
		var tPages=this.getServicesTransactionName().getComponent('tpage').getValue();
		var transcount = this.jsonData.HiddenFields.trancount;
		var transList = this.jsonData.HiddenFields.translist;
		var site = this.jsonData.HiddenFields.site;
		var validationMessages = this.jsonData.validationsMessages;
		if(Ext.isEmpty(this.jsonData.HiddenFields.webTransactions)){
			webTransactions = null;
		}
		if(Ext.isEmpty(this.jsonData.HiddenFields.emulTransactions)){
			emulTransactions = null;
		} if(Ext.isEmpty(this.jsonData.HiddenFields.currentuser)){
			currentuser = null;
		}
		var mode= this.jsonData.HiddenFields.mode;

		if(Ext.isEmpty(this.tImage))
		{
			alert(validationMessages["Please select transaction image"]);
			return;
		}
		var url = valform(tName,tPages, this.tImage,transcount,transList,site,webTransactions,emulTransactions,currentuser,mode,validationMessages);
		var serviceDashboard = this.getServicesDashboard();

		Ext.Ajax.request({
			url: url,
			scope:this,
			timeout:280000,
			success: function(response){
				this.getServicesDashboard().currentTab = 'transactions';
				var dashboardController = this.getController('Main');
				var button = Ext.create('Ext.button.Button',{
					name:serviceDashboard.currentService,
					isSite:'true',
					aggregateTab:(serviceDashboard.aggregateTab == true)?'true':'false',
					hasTransactions:'true',
					hasEmulatedTransactions:(serviceDashboard.hasEmulatedTransactions == true)?'true':'false'
				});
				dashboardController.displayServiceDetails(button);

				/*if(serviceDashboard.aggregateTab){
					serviceDashboard.setActiveTab(3);
				}
				else{
					serviceDashboard.setActiveTab(2);
				}
				dashboardController.loadActiveTabData(serviceDashboard);
				serviceDashboard.getComponent('transactions').setVisible(true);*/
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},

	setTransactionName : function(ths, newValue, oldValue, eOpts){
		this.tImage = ths.initialConfig.value;
	},

	ConfigurePanels : function(jsonData){
		/*var itemsArray =new Array();
		var upperPanel= "";
		if(!Ext.isEmpty(jsonData.Message)){
			upperPanel = {
				xtype : 'errorpanel',
				cls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
				bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
				height : '50%',
				width : '100%',
				border : true,
				autoScroll:true,
				margin : 5,
				errorMsg : '<img src="'
				+ jsonData.errorImage + '"/><br/><b>' + jsonData.Message
				+ '</b>',
				flex : 4
			}
			itemsArray.push(upperPanel);
		}
		var topToolbar = {
			xtype : 'toolbar',
			docked : 'top',
			cls : 'component-list-right-panel-header',
			height : '30px',
			items : [{
				xtype : 'label',
				text : jsonData.DownGridLabels.newTransName,
				cls : 'configure-transaction-label',
				action : 'tname'
			},{
				xtype : 'textfield',
				cls : 'configure-transaction-textfield',
				fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
				labelCls :'config-window-font',
				width : '200px',
				itemId : 'tname'
			},'->',{
				xtype : 'label',
				text : jsonData.DownGridLabels.pagesToInclude,
				cls : 'configure-transaction-label'
			},{
				xtype : 'textfield',
				cls : 'configure-transaction-textfield',
				fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
				labelCls :'config-window-font',
				width : '250px',
				action : 'tpage',
				itemId : 'tpage'
			},'->',{
				xtype : 'button',
				text : jsonData.DownGridLabels.addBtnLabel,
				cls : 'delete-service-transaction-button',
				action :'add'
			}]
		}
		var lowerPanel = {
			xtype : 'scrollpanel',
			height : '40%',
			width : '100%',
			autoScroll:true,
			title : jsonData.DownGridLabels.header,
			cls : 'new-transaction-panel',
			bodyCls:'bottom-left-radius bottom-right-radius',
			flex : 3,
			items : [{
				xtype : 'panel',
				width : '100%',
				height : 25,
				border : false,
				html : '<div class="configure-transaction-info-text">* '+jsonData.DownGridLabels.info+'</div>'
			},{
				xtype : 'panel',
				height : 200,
				width : 1000,
				border : false,
				cls : 'transaction-group-images-panel',
				layout : 'column',
				items : [{
					xtype : 'transactionimagespanel',
					cls : 'transaction-image-panel-middle',
					columnWidth : 0.33,
					imageSrc1 : jsonData.IconsInfo[0].image,
					transactionText1 : jsonData.IconsInfo[0].name,
					transactionValue1 : jsonData.IconsInfo[0].value,

					imageSrc2 :jsonData.IconsInfo[1].image,
					transactionText2 : jsonData.IconsInfo[1].name,
					transactionValue2 : jsonData.IconsInfo[1].value,

					imageSrc3 :jsonData.IconsInfo[2].image,
					transactionText3 :jsonData.IconsInfo[2].name,
					transactionValue3 : jsonData.IconsInfo[2].value,

					imageSrc4 :jsonData.IconsInfo[3].image,
					transactionText4 : jsonData.IconsInfo[3].name,
					transactionValue4 : jsonData.IconsInfo[3].value,

					imageSrc5 :jsonData.IconsInfo[4].image,
					transactionText5 :jsonData.IconsInfo[4].name,
					transactionValue5 : jsonData.IconsInfo[4].value
				},{
					xtype : 'transactionimagespanel',
					flex : 1,
					columnWidth : 0.33,
					cls : 'transaction-image-panel-middle',
					imageSrc1 : jsonData.IconsInfo[5].image,
					transactionText1 : jsonData.IconsInfo[5].name,
					transactionValue1 : jsonData.IconsInfo[5].value,
					imageSrc2 :jsonData.IconsInfo[6].image,
					transactionText2 : jsonData.IconsInfo[6].name,
					transactionValue2 : jsonData.IconsInfo[6].value,
					imageSrc3 :jsonData.IconsInfo[7].image,
					transactionText3 :jsonData.IconsInfo[7].name,
					transactionValue3 : jsonData.IconsInfo[7].value,
					imageSrc4 :jsonData.IconsInfo[8].image,
					transactionText4 : jsonData.IconsInfo[8].name,
					transactionValue4 : jsonData.IconsInfo[8].value,
					imageSrc5 :jsonData.IconsInfo[9].image,
					transactionText5 :jsonData.IconsInfo[9].name,
					transactionValue5 : jsonData.IconsInfo[9].value
				},{
					xtype : 'transactionimagespanel',
					flex : 1,
					columnWidth : 0.33,
					cls : 'transaction-image-panel-middle',
					imageSrc1 : jsonData.IconsInfo[10].image,
					transactionText1 : jsonData.IconsInfo[10].name,
					transactionValue1 : jsonData.IconsInfo[10].value,

					imageSrc2 :jsonData.IconsInfo[11].image,
					transactionText2 : jsonData.IconsInfo[11].name,
					transactionValue2 : jsonData.IconsInfo[11].value,

					imageSrc3 :jsonData.IconsInfo[12].image,
					transactionText3 :jsonData.IconsInfo[12].name,
					transactionValue3 : jsonData.IconsInfo[12].value,

					imageSrc4 :jsonData.IconsInfo[13].image,
					transactionText4 : jsonData.IconsInfo[13].name,
					transactionValue4 : jsonData.IconsInfo[13].value,

					imageSrc5 :jsonData.IconsInfo[14].image,
					transactionText5 :jsonData.IconsInfo[14].name,
					transactionValue5: jsonData.IconsInfo[14].value
				}]
			}]
		};
		lowerPanel.dockedItems=topToolbar;
		itemsArray.push(lowerPanel);
		return itemsArray;*/
	}
});