var errorPanel = false;
var sHeight = screen.height+810;
Ext.define('services.controller.ServicesTransactions',{
	extend: 'Ext.app.Controller',
	requires:['services.view.ServiceTransactionPanel','services.view.TransactionsMainPanel','services.view.GraphPanel','Ext.data.Store','services.view.ConfigureTransactions','services.view.TransactionsChartPanel','services.view.TransactionsMainTabPanelAll','sessionSimulation.view.SessionSimulation'],
	stores : ['services.store.TransactionsStore'],
	jsonData:null,
	tab:"web",
	transactionMeasuresChartURL:"/final/servlet/com.egurkha.TransactionMeasures",
	time_line_obj:null,
	chart_url:null,
	siteName:null,
	id:'st',
	refs:[{
		ref:'servicesTopology',
		selector:'servicestopology'
	},{
		ref:'transactionsMainPanel',
		selector:'transactionsmainpanel'
	},{
		ref:'transactionsMainPanel',
		selector:'transactionsmainpanel'
	},{
		ref:'transactionsMainTabPanelAll',
		selector:'transactionsmaintabpanelall'
	},{
		ref:'servicesDashboard',
		selector:'servicesdashboard'
	},{
		ref:'configureTransactions',
		selector:'configuretransactions'
	},{
		ref:'servicesTransactionName',
		selector:'transactionsmainpanel configuretransactions toolbar textfield[action="tname"]'
	},{
		ref:'servicesTransactionPages',
		selector:'transactionsmainpanel configuretransactions toolbar textfield[action="tpage"]'
	},{
		ref:'transactionsmaintabpanelallCompCombo',
		selector:'transactionsmaintabpanelall > toolbar > combo'
	},{
		ref:'transactionCompCombo',
		selector:'transactionsmainpanel > toolbar > combo'
	},{
		ref:'transactionsChartPanel',
		selector:'transactionschartpanel'
	},{
		ref:'transactionsChartPanelToolbar',
		selector:'transactionschartpanel > toolbar'
	},{
		ref : 'transactionChartComboMode',
		selector : 'transactionschartpanel > toolbar > combo[itemId= "mode"]'
	},{
		ref : 'transactionChartComboTimeline',
		selector : 'transactionschartpanel > toolbar > combo[itemId= "timeline"]'
	},{
		ref : 'transactionChartComboFromhr',
		selector : 'transactionschartpanel > toolbar > combo[itemId= "fromhr"]'
	},{
		ref : 'transactionChartComboTohr',
		selector : 'transactionschartpanel > toolbar > combo[itemId= "tohr"]'
	},{
		ref : 'transactionChartComboFrommin',
		selector : 'transactionschartpanel > toolbar > combo[itemId= "frommin"]'
	},{
		ref : 'transactionChartComboTomin',
		selector : 'transactionschartpanel > toolbar > combo[itemId= "tomin"]'
	},{
		ref : 'transactionChartFromDate',
		selector : 'transactionschartpanel > toolbar > datefield[itemId= "from"]'
	},{
		ref : 'transactionChartToDate',
		selector : 'transactionschartpanel > toolbar > datefield[itemId= "to"]'
	},{
		ref : 'zoomGraphComboMode',
		selector : 'zoomgraphpanel  combo[itemId= "mode"]'
	},{
		ref : 'zoomGraphComboTimeline',
		selector : 'zoomgraphpanel  combo[itemId= "timeline"]'
	},{
		ref : 'zoomGraphComboFromhr',
		selector : 'zoomgraphpanel combo[itemId= "fromhr"]'
	},{
		ref : 'zoomGraphComboTohr',
		selector : 'zoomgraphpanel combo[itemId= "tohr"]'
	},{
		ref : 'zoomGraphComboFrommin',
		selector : 'zoomgraphpanel combo[itemId= "frommin"]'
	},{
		ref : 'zoomGraphComboTomin',
		selector : 'zoomgraphpanel combo[itemId= "tomin"]'
	},{
		ref : 'zoomGraphFromDate',
		selector : 'zoomgraphpanel datefield[itemId= "from"]'
	},{
		ref : 'zoomGraphToDate',
		selector : 'zoomgraphpanel datefield[itemId= "to"]'
	},{
		ref : 'zoomGraphPanel',
		selector : 'zoomgraphpanel'
	},{
		ref : 'serviceTransactionPanel',
		selector : 'servicetransactionpanel'
	},{
		ref : 'zoomGraphImgPanel',
		selector : 'zoomgraphpanel > scrollpanel'
	},{
		ref:'up',
		selector:'transactionsmainpanel toolbar > tool[action=up]'
	},{
		ref:'down',
		selector:'transactionsmainpanel toolbar > tool[action=down]'
	},{
		ref:'deleteTransactionsButton',
		selector:'tabbar > button[action="deleteTransactions"]'
	},{
		ref:'selectAllButton',
		selector:'tabbar > button[action="selectTransactions"]'
	},{
		ref:'deselectAllButton',
		selector:'tabbar > button[action="deselectTransactions"]'
	},{
		ref:'myTimeWindow',
		selector:'floatingContainer'
	},{
		ref:'myTimelinePanel',
		selector:'floatingContainer > panel'
	},{
		ref : 'transactionComboMode',
		selector : 'floatingContainer > panel > combo[itemId= "mode"]'
	},{
		ref : 'transactionComboTimeline',
		selector : 'floatingContainer > panel > combo[itemId= "timeline"]'
	},{
		ref : 'transactionComboFromhr',
		selector : 'floatingContainer > panel > combo[itemId= "fromhr"]'
	},{
		ref : 'transactionComboTohr',
		selector : 'floatingContainer > panel > combo[itemId= "tohr"]'
	},{
		ref : 'transactionComboFrommin',
		selector : 'floatingContainer > panel > combo[itemId= "frommin"]'
	},{
		ref : 'transactionComboTomin',
		selector : 'floatingContainer > panel > combo[itemId= "tomin"]'
	},{
		ref : 'transactionFromDate',
		selector : 'floatingContainer > panel > datefield[itemId= "from"]'
	},{
		ref : 'transactionToDate',
		selector : 'floatingContainer > panel > datefield[itemId= "to"]'
	},{
		ref:'transactionsPanelToolbar',
		selector:'floatingContainer > panel'
	}],

	init: function() {
		this.control({
			  'transactionsmainpanel > toolbar > button[itemId = "serviceToolbarWebButton"]':{
				  'click':this.transactionBtnHandler
			  },
			  
			  'transactionsmainpanel > toolbar > button[itemId = "serviceToolbarEmulatedButton"]':{
				  'click':this.transactionBtnHandler
			  },
			  
			  'transactiongridpanel button[action = "transactionsGridConfigureBtn"]':{
				  'click':this.configureTransactionsHandler
			  },
			  'configuretransactions toolbar button[action="add"]':{
				  'click':this.addTransaction
			  },
			  'transactionsMainTabPanel toolbar button[action = "transactionsGridConfigureBtn"]':{
				  'click':this.configureTransactionsHandler
				},
			  'tabbar > button[action="deleteTransactions"]':{
				  'click':this.deleteTransaction
			  },
			  'transactionsmainpanel configuretransactions radio' :{
				  'change' : this.setTransactionName
			  },
			  
			  'transactionschartpanel':{
				  'afterrender':this.onChartsPanelRender
			  },
			  
			  'transactionschartpanel > toolbar > combo[itemId= "mode"]':{
				  select:this.displayGraph
			  },
			  
			  'transactionschartpanel > toolbar > combo[itemId= "timeline"]':{
				  select:this.timelineChangeHandler					// Date 
			  },
			  
			  'transactionschartpanel > toolbar > button[action = "transactionGraphBtn"]':{
				  click:this.displayGraph
			  },
			  
			  'transactionsmainpanel > toolbar > combo[itemId="componentCombo"]':{
				  'select': this.onComponentChange
			  },
			  'transactionsmaintabpanelall > tabBar > toolbar > combo[itemId="componentCombo"]':{
				  'select': this.onComponentChange
			  },
				'transactionsmaintabpanelall  combo[itemId="componentCombo"]':{
				  'change': this.onComponentChange
			  },
				'transactionsmaintabpanelall  combo[itemId="simulationCombo"]':{
				  'change': this.onSimulationChange
			  },
				'transactionsmaintabpanelall  combo[itemId="compTypeCombo"]':{
				  'change': this.onCompTypeChange
			  },
			  'transactiongridpanel' : {
					cellclick :{
						fn : function( thisss, td, cellIndex, record, tr, rowIndex, e, eOpts ){
							var tabs = this.getServicesDashboard().getTabBar().query('tab');
							if(cellIndex==0 &&(e.target.outerHTML.substring(0,2)=='<a' ||e.target.outerHTML.substring(0,29) == '<div class="columnIcon trans_')){
								this.getServicesDashboard().setActiveTab(tabs.length-1);
							}
							if(cellIndex!=0 && e.target.outerHTML.substring(0,2)=='<a' || e.target.outerHTML.substring(0,3)=='<sp' || e.target.outerHTML.substring(0,3)=='<im'){
								this.getServicesDashboard().setActiveTab(tabs.length-1);
							}
						}
					}
				},
			'zoomgraphpanel combo[itemId= "mode"]':{
				select:this.displayZoomGraph
			},

			'zoomgraphpanel combo[itemId= "timeline"]':{
				select:this.displayZoomGraph
			},

			'zoomgraphpanel button[itemId="timelineAny"]':{
				render: function(component){
					var me=this;
					component.getEl().on('click', function(e){
						me.displayZoomGraph();
					});    
				}
			},
			'zoomgraphpanel panel[itemId="minimizePanelDiv"]':{
				render: function(component){
					var me=this;
					component.getEl().on('click', function(e){
						me.bigGraphOnClick();
					});    
				}
			},
			'zoomgraphpanel tool[itemId=minimizePanelDiv]':{
				click:this.bigGraphOnClick
			},
			'transactionsmainpanel tool[action=up]':{
				click:this.up
			},
			'transactionsmainpanel tool[action=down]':{
				click:this.down
			},
			'tabbar > button[action="selectTransactions"]':{
				click:this.selectAll
			},
			'tabbar > button[action="deselectTransactions"]':{
				click:this.deselectAll
			},
			'transactionsmaintabpanelall':{
				tabchange:this.changeTabAll
			},
			'transactionsMainTabPanel':{
				tabchange:this.changeTab	
			},
			'transactionschartpanel button[id= "settingBt"]':{
				click:this.settingClick
			},
			'floatingContainer > panel > combo[itemId= "timeline"]':{
				  select:this.timelineChangeHandler // Date 
			},
			'floatingContainer > panel > button[action = "transactionGraphBtn"]':{
				  click:this.displayGraph
			},
		});
	},
	changeTabAll:function(){
		var tabPanelAll = this.getTransactionsMainTabPanelAll();
		var activeTab = tabPanelAll.getActiveTab();
		if(activeTab.itemId != null && activeTab.itemId == 'webtrans')
		{
			innerActiveTab = activeTab.itemId;
			curViewTab = activeTab.itemId;
			selectedParam = curServiceName;
			logonChartType = '';

			var compCombo = Ext.getCmp('componentCombo');
			if(!Ext.isEmpty(compCombo))
				compCombo.setVisible(false);
			var simulationCombo = Ext.getCmp('simulationCombo');
			if(!Ext.isEmpty(simulationCombo))
				simulationCombo.setVisible(false);
			var compTypecombo = Ext.getCmp('compTypeCombo');
			if(!Ext.isEmpty(compTypecombo))
				compTypecombo.setVisible(false);

			var url =  '/final/monitor/transactions.jsp?treeTitle=services&selectNode=Service$cap$'+selectedParam+'&selectedParam='+selectedParam+'&currentTab=transactions&isSite='+this.getServicesDashboard().isSite+'&aggregateTab=false&hasTransactions='+this.getServicesDashboard().hasTransactions+'&hasEmulatedTransactions='+this.getServicesDashboard().hasEmulatedTransactions+'&fromHomepage=true&site='+selectedParam+'&serviceName='+selectedParam+'&fromLayer=false&selectNode='+selectedParam+'&selectedParam='+selectedParam+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+selectedParam;
			urlForRefresh = url;
			Ext.Ajax.request({
				url : url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						/*this.siteName = jsonData.HiddenFields.siteName;
						  if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
							  if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){
								  this.tab="emulated";
							  }else{
								  this.tab="web";
							  }
						  }*/
						
						this.getTransactionsMainPanel().showTransactionGridPanelData(jsonData.GridScreenLabels,jsonData);
				   }
				  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		else if(activeTab.itemId != null && activeTab.itemId == 'emultrans')
		{
			innerActiveTab = activeTab.itemId;
			curViewTab = activeTab.itemId;
			selectedParam = curServiceName;
			logonChartType = '';
			var compCombo = Ext.getCmp('componentCombo');
			if(!Ext.isEmpty(compCombo))
				compCombo.setVisible(false);
			var simulationCombo = Ext.getCmp('simulationCombo');
			if(!Ext.isEmpty(simulationCombo))
				simulationCombo.setVisible(false);
			var compTypecombo = Ext.getCmp('compTypeCombo');
			if(!Ext.isEmpty(compTypecombo))
				compTypecombo.setVisible(false);
			var url =  '/final/monitor/transactions.jsp?treeTitle=services&selectNode=Service$cap$'+selectedParam+'&selectedParam='+selectedParam+'&currentTab=transactions&isSite='+this.getServicesDashboard().isSite+'&aggregateTab=false&hasTransactions='+this.getServicesDashboard().hasTransactions+'&hasEmulatedTransactions='+this.getServicesDashboard().hasEmulatedTransactions+'&fromHomepage=true&site='+selectedParam+'&serviceName='+selectedParam+'&fromLayer=false&selectNode='+selectedParam+'&selectedParam='+selectedParam+'&currentTab=transactions&transTab=true&from=emulated&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+selectedParam+"&selectedTab=EmulatedClients";
			urlForRefresh = url;
			Ext.Ajax.request({
				url : url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						/*this.siteName = jsonData.HiddenFields.siteName;
						  if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
							  if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){
								  this.tab="emulated";
							  }else{
								  this.tab="web";
							  }
						  }*/
						this.getTransactionsMainPanel().showEmulTransactionGridPanelData(jsonData.GridScreenLabels,jsonData);
				   }
				  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		else if(activeTab.itemId != null && activeTab.itemId == 'rumTrans') {
			innerActiveTab = activeTab.itemId;
			curViewTab = activeTab.itemId;
			var rumSize = Object.keys(rumServiceListObject).length;
			logonChartType = '';

			var compCombo = Ext.getCmp('componentCombo');
			if(!Ext.isEmpty(compCombo))
				compCombo.setVisible(false);
			var simulationCombo = Ext.getCmp('simulationCombo');
			if(!Ext.isEmpty(simulationCombo))
				simulationCombo.setVisible(false);
			var compTypecombo = Ext.getCmp('compTypeCombo');
			if(!Ext.isEmpty(compTypecombo))
				compTypecombo.setVisible(false);

			if(rumServiceListObject != null && rumServiceListObject != 'undefined' && rumServiceListObject != undefined && rumSize > 0){
				
				var serviceName;
				var servicestate;
				var compName;
				
				for(var a=0;a<rumServiceListObject.length;a++){
					var serObject = rumServiceListObject[a];
					if(serObject.name == selectedParam)
					{	
						serviceName = serObject.name;
						servicestate = serObject.servicestate;
						compName = serObject.value+":"+serObject.port;
						break;
					}
				}
				if(compName == null || compName == undefined || compName == 'undefined' ||compName =='' ){
					serviceName = rumServiceListObject[0].name;
					servicestate = rumServiceListObject[0].servicestate;
					compName = rumServiceListObject[0].value;
					port = rumServiceListObject[0].port;
					compName = compName+':'+port;
				}


				url = '/final/monitor/realUserMonitorsDashboard.jsp?drilldown=true&from=serviceDash&compName='+compName;
				urlForRefresh = url;
				Ext.Ajax.request({
					url : '/final/monitor/transactions.jsp?site='+serviceName+'&checkTransComp=true&currentTab='+curViewTab,
					scope:this,
					timeout:280000,
					success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsonData = Ext.decode(jsonText);
							this.getTransactionsMainPanel().removeAll();
							this.getTransactionsMainPanel().displayRum(url,serviceName,false,servicestate,jsonData);
							return;
						}
						else
						{
							this.getTransactionsMainPanel().removeAll();
							this.getTransactionsMainPanel().displayRum(url,serviceName,false,servicestate,"");
							return;
						}
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
				
				return;
			}
		}
		else if(activeTab.itemId != null && activeTab.itemId == 'logonSim'){
			innerActiveTab = activeTab.itemId;
			curViewTab = activeTab.itemId;
			selectedParam = curServiceName;
			url = '/final/monitor/transactions.jsp?treeTitle=services&selectNode=Service$cap$'+selectedParam+'&selectedParam='+selectedParam+'&currentTab=logon&isSite='+this.getServicesDashboard().isSite+'&aggregateTab=false&hasTransactions='+this.getServicesDashboard().hasTransactions+'&hasEmulatedTransactions='+this.getServicesDashboard().hasEmulatedTransactions+'&fromHomepage=&hasLogonSimulations=true&site='+selectedParam+'&serviceName='+selectedParam+'&fromLayer=false&selectNode='+selectedParam+'&selectedParam='+selectedParam+'&currentTab=logon&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+selectedParam+'&fromLogonTab=true&checkTransComp=true';
			urlForRefresh = url;
			Ext.Ajax.request({
				//url : '/final/monitor/transactions.jsp?site='+selectedParam+'&fromLogonTab=true',
				url:urlForRefresh,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						var externalAgentList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var componentListObj = jsonData.componentListObj;
						var compCombo = Ext.getCmp('componentCombo');
						if(!Ext.isEmpty(compCombo))
							compCombo.setVisible(true);

						var simulationCombo = Ext.getCmp('simulationCombo');
						if(!Ext.isEmpty(simulationCombo))
							simulationCombo.setVisible(true);

						var compTypecombo = Ext.getCmp('compTypeCombo');
						if(!Ext.isEmpty(compTypecombo))
							compTypecombo.setVisible(true);
						
						if(!Ext.isEmpty(compTypecombo) && componentListObj!=null && componentListObj!=undefined)
						{
							compTypecombo.suspendEvents(true);
							simulationCombo.suspendEvents(true);

							if(!Ext.isEmpty(compTypecombo.getValue()))
							{
								compTypecombo.getStore().removeAll();
								compTypecombo.getStore().loadRawData('');
								compTypecombo.getStore().loadRawData(componentListObj);
								compTypecombo.setFieldLabel(componentListObj.label);
								compTypecombo.setValue(componentListObj.selectedValue);
							}
							else
							{
								var comboTypeStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'url'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:componentListObj
								});

								compTypecombo.bindStore(comboTypeStore);
								compTypecombo.setFieldLabel(componentListObj.label);
								compTypecombo.isSuspend=true;
								compTypecombo.setValue(componentListObj.selectedValue);
								compTypecombo.isSuspend=false;
							}
						}

						if(!Ext.isEmpty(compCombo) && externalAgentList!=null && externalAgentList!=undefined)
						{
							compCombo.suspendEvents(true);
							selectedExtAgent = externalAgentList.selectedValue;

							//simulation combo data set start
							if(!Ext.isEmpty(simulationCombo) && logonComponentList!=null && logonComponentList!=undefined)
							{
								extSimData = logonComponentList;
								logonComponentList = logonComponentList[selectedExtAgent];

								if(!Ext.isEmpty(simulationCombo.getValue()))
								{
									simulationCombo.getStore().removeAll();
									simulationCombo.getStore().loadRawData('');
									simulationCombo.getStore().loadRawData(logonComponentList);
									simulationCombo.setFieldLabel(logonComponentList.label);
									simulationCombo.setValue(logonComponentList.selectedValue);
								}
								else
								{
									var simcomboStore = Ext.create('Ext.data.Store',{
										fields:['value', 'name', 'comptype'],
										proxy:{
											type: 'memory',
											reader: {
												type: 'json',
												root:'options'
											}
										},
										data:logonComponentList
									});
									simulationCombo.bindStore(simcomboStore);
									simulationCombo.setFieldLabel(logonComponentList.label);
									simulationCombo.setValue(logonComponentList.selectedValue);
								}
							}
							//simulation combo data set end

							if(!Ext.isEmpty(compCombo.getValue()))
							{
								compCombo.getStore().removeAll();
								compCombo.getStore().loadRawData('');
								compCombo.getStore().loadRawData(externalAgentList);
								compCombo.setFieldLabel(externalAgentList.label);
								compCombo.setValue(externalAgentList.selectedValue);
							}
							else
							{
								var comboAgentStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:externalAgentList
								});
								compCombo.bindStore(comboAgentStore);
								compCombo.setFieldLabel(externalAgentList.label);
								compCombo.setValue(externalAgentList.selectedValue);
							}
						}
					/*	if(!Ext.isEmpty(compCombo) && !Ext.isEmpty(externalAgentList) && externalAgentList!=null && externalAgentList!=undefined)
						{
							extAgentData = externalAgentList;
							externalAgentList = externalAgentList[logonComponentList.selectedValue];
							compCombo.setVisible(true);
							compCombo.suspendEvents(true);
							if(!Ext.isEmpty(compCombo.getValue()))
							{
								compCombo.getStore().removeAll();
								compCombo.getStore().loadRawData('');
								compCombo.getStore().loadRawData(externalAgentList);
								compCombo.setValue(externalAgentList.selectedValue);
								compCombo.setFieldLabel(extAgentData.label);

								simulationCombo.getStore().removeAll();
								simulationCombo.getStore().loadRawData('');
								simulationCombo.getStore().loadRawData(logonComponentList);
								simulationCombo.setValue(logonComponentList.selectedOrgValue);
								simulationCombo.setFieldLabel(logonComponentList.label);
							}
							else
							{
								var tmpcomboStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'comptype'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:externalAgentList
								});
								compCombo.bindStore(tmpcomboStore);
								compCombo.setValue(externalAgentList.selectedValue);
								compCombo.setFieldLabel(extAgentData.label);

								var simcomboStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name', 'comptype'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:logonComponentList
								});
								simulationCombo.bindStore(simcomboStore);
								simulationCombo.setValue(logonComponentList.selectedOrgValue);
								simulationCombo.setFieldLabel(logonComponentList.label);
							}
						}
						else
							compCombo.setVisible(false);*/
						
					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
	},
	onSimulationChange:function(combo){
		var tabPanelAll = this.getTransactionsMainTabPanelAll();
		var activeTab = tabPanelAll.getActiveTab();
		var comboVal = combo.getValue();
		if(activeTab.itemId != null && activeTab.itemId == 'logonSim')
		{
			var servicename = this.siteName;
			if(Ext.isEmpty(servicename) || servicename == null || servicename == undefined)
				servicename = curServiceName;

			var componentVal = comboVal;
			if(!Ext.isEmpty(componentVal) && componentVal != null && componentVal.indexOf(":") > 0)
			{
				componentVal = componentVal.substring(0,componentVal.indexOf(":"));
			}

			//var externalAgentList = extAgentData[componentVal];
			var compCombo = Ext.getCmp('componentCombo').getValue();
			/*compCombo.getStore().removeAll();
			compCombo.getStore().loadRawData('');
			compCombo.getStore().loadRawData(externalAgentList);
			compCombo.setValue(externalAgentList.selectedValue);
			compCombo.setFieldLabel(extAgentData.label);*/
			//selectedExtAgent = externalAgentList.selectedValue; 
			selectedExtAgent = compCombo; 
			selectedSimulation = comboVal;
			if(gLogonParam != null && gLogonParam != '' && gLogonParam != undefined)
				Ext.get('logonSimCompId').dom.src='/final/monitor/comparisonDashboard.jsp?'+gLogonParam+'&isFromMenu=true&showGraph=true&isLogonFromService=true&servicename='+servicename+'&externalAgent='+selectedExtAgent+'&subFilter=&componentNameSearch='+componentVal+'&componentNameService='+comboVal;
			else
				Ext.get('logonSimCompId').dom.src='/final/monitor/comparisonDashboard.jsp?treeTitle=logonSimualtion&isFromMenu=true&showGraph=true&isLogonFromService=true&servicename='+servicename+'&externalAgent='+selectedExtAgent+'&subFilter=&componentNameSearch='+componentVal+'&componentNameService='+comboVal;
			return;
		}
	},
	onCompTypeChange:function(combo){
		
		try
		{
			if(combo.isSuspend)
				return;
		}
		catch (e)
		{
		}

		var tabPanelAll = this.getTransactionsMainTabPanelAll();
		var activeTab = tabPanelAll.getActiveTab();
		var comboVal = combo.getValue();
		var simVal = Ext.getCmp('simulationCombo').getValue();
		if(activeTab.itemId != null && activeTab.itemId == 'logonSim')
		{
			var servicename = this.siteName;
			if(Ext.isEmpty(servicename) || servicename == null || servicename == undefined)
				servicename = curServiceName;

			var componentVal = comboVal;
			if(!Ext.isEmpty(componentVal) && componentVal != null && componentVal.indexOf(":") > 0)
			{
				componentVal = componentVal.substring(0,componentVal.indexOf(":"));
			}

			selectedCompType = comboVal;
			var compCombo = Ext.getCmp('componentCombo').getValue();
			if(compUrl =='')
			{
				var url = '/final/monitor/transactions.jsp?treeTitle=services&selectNode=Service$cap$'+selectedParam+'&selectedParam='+selectedParam+'&currentTab=logon&&isSite='+this.getServicesDashboard().isSite+'&aggregateTab=false&hasTransactions='+this.getServicesDashboard().hasTransactions+'&hasEmulatedTransactions='+this.getServicesDashboard().hasEmulatedTransactions+'&fromHomepage=&hasLogonSimulations=true&site='+selectedParam+'&serviceName='+selectedParam+'&fromLayer=false&selectNode='+selectedParam+'&selectedParam='+selectedParam+'&currentTab=logon&transTab=true&from=null&innerActiveTab='+activeTab.itemId+'&Refreshing=true&fromLogonTab=true&checkTransComp=true';
				compUrl = url;
			}
			if(compUrl !='' && compUrl != null && compUrl != undefined)
			{
				var tempCompUrl = compUrl;

				if(tempCompUrl.indexOf("componentType=") > -1)
				{
					if(tempCompUrl.indexOf("componentType=") > -1)
					{
						tempCompUrl=tempCompUrl.replace(/(componentType=).*?(&)/,'$1' + comboVal + '$2');
					}
				}
				else
				{
					var urlData = tempCompUrl.split("?");
					var secUrl = urlData[0]+"?"+"componentType="+comboVal+"&"+urlData[1];
					tempCompUrl = secUrl;
				}
				compUrl = tempCompUrl;
				refreshSimulation = '';
				this.getController('ServicesTransactions').servicesTransactionRender(compUrl)
			}
			return;
		}
	},
	onComponentChange:function(combo){
		var tabPanelAll = this.getTransactionsMainTabPanelAll();
		var activeTab = tabPanelAll.getActiveTab();
		//added because when component changes the chart was not being displayed properly
		var comboVal = combo.getValue();
		if(comboVal.indexOf('Real_user_monitor') != -1)
		{
			var compType = comboVal.substring(0,comboVal.indexOf(':'));
			var compName = comboVal.substring(comboVal.indexOf(':')+1);
			rumComboChange = compName;
			var rumTrans = Ext.getCmp('rumTrans');
			Ext.getCmp('geoMapPanel').destroy();
			var rumUrl =  '/final/monitor/realUserMonitorsDashboard.jsp?drilldown=true&from=serviceDash&compName='+compName;
			rumRefresh.url = rumUrl;
			rumTrans.add({
				xtype:'panel',
				border:false,
				layout:{type:'fit'},
				//cls:'rumDataInnerpanel',
				//height:370,
				//title:'Geo Performance',
				//columnWidth:.50,
				//layout:{type:'vbox',align:'stretch'},
				//layout:'fit',
				//width:540,
				//minWidth:520,
				padding:'0 0 0 0',
				//margin:'0 15 0 0',
				//cls:'content-frame',
				scroll:false,
				autoScroll:false,
				id:'geoMapPanel',
				//id:'asaa',
				style:{'top':'-3px !important','background':'transparent !important','text-align':'center'},
				html:"<iframe id='asa'  width='100%' height='"+sHeight+"' src='"+rumUrl+"' border='0' scrolling='no' marginwidth='0px' marginheight='0px' frameborder='0' allowtransparency='true' style='border:0px solid red' ></iframe>"
			});
			//rumTrans.insert(rumWin);
			return;
		}
		else if(activeTab.itemId != null && activeTab.itemId == 'logonSim')
		{
			var logonComponentList = extSimData[comboVal];
			var compCombo = Ext.getCmp('simulationCombo');
			compCombo.getStore().removeAll();
			compCombo.getStore().loadRawData('');
			compCombo.getStore().loadRawData(logonComponentList);
			compCombo.setValue(logonComponentList.selectedValue);
			compCombo.setFieldLabel(logonComponentList.label);

			//selectedExtAgent = logonComponentList.selectedValue; 
			var servicename = this.siteName;
			if(Ext.isEmpty(servicename) || servicename == null || servicename == undefined)
				servicename = curServiceName;

			Ext.get('logonSimCompId').dom.src='/final/monitor/comparisonDashboard.jsp?treeTitle=logonSimualtion&isFromMenu=true&showGraph=true&isLogonFromService=true&servicename='+servicename+'&externalAgent='+comboVal+'&subFilter=&componentNameSearch='+selectedSimulation;
			selectedExtAgent = comboVal;
			return;
		}
		var service = this.siteName;
		if(service==null || service==undefined || service=='null')
			return;
		var fromLayer = false;
		var url= '/final/monitor/serviceDashHelper.jsp?&site='+encodeURI(service)+'&isSite=true&serviceName='+encodeURI(service)+'&fromLayer='+fromLayer;
		
    	  
	    	/*  var timeLineCombo=this.getTransactionChartComboTimeline();
	    	  var fromHrCombo=this.getTransactionChartComboFromhr();
	    	  var toHrCombo=this.getTransactionChartComboTohr();
	    	  var modeCombo=this.getTransactionChartComboMode();
	    	  var fromDateCombo=this.getTransactionChartFromDate();
	    	  var toDateCombo=this.getTransactionChartToDate();*/

		  var timeLineCombo=this.getTransactionComboTimeline();
	    	  var fromHrCombo=this.getTransactionComboFromhr();
	    	  var toHrCombo=this.getTransactionComboTohr();
	    	  var modeCombo=this.getTransactionComboMode();
	    	  var fromDateCombo=this.getTransactionFromDate();
	    	  var toDateCombo=this.getTransactionToDate();
	    	  
	    	  if(!Ext.isEmpty(combo)){
	    		  url+="&transComp="+combo.getValue();
	    	  }
			  if(this.tab=="emulated"){
				  url+="&selectedTab=EmulatedClients&from=emulated";
			  }
			  else
			  {
				  url+="&selectedTab="+this.tab;
			  }
	    	  if(!Ext.isEmpty(timeLineCombo)){
	    		  url+="&time_line="+timeLineCombo.getValue();
				  if(timeLineCombo.getValue()=='Any')
				  {
						 if(!Ext.isEmpty(fromHrCombo)){
	    					 url+="&starthr="+fromHrCombo.getValue();
						  }
						  if(!Ext.isEmpty(toHrCombo)){
							  url+="&endhr="+toHrCombo.getValue();
						  }
						  if(!Ext.isEmpty(modeCombo)){
							  url+="&mode="+modeCombo.getValue();
						  }
						  if(!Ext.isEmpty(fromDateCombo)){
							  tempstarttime=Ext.Date.format(fromDateCombo.getValue(),mgr_dateFormat);
							  url+="&starttime="+tempstarttime;
						  }
						  if(!Ext.isEmpty(toDateCombo)){
							  tempendtime=Ext.Date.format(toDateCombo.getValue(),mgr_dateFormat);
							  url+="&endtime="+tempendtime;
						  }
				  }
	    	  }
	    	 
			  
		
		// url=this.getTransactionsMainPanel().url;
		Ext.Ajax.request({
			url :url,
			scope:this,
			timeout:280000,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(jsonData.HiddenFields!=null && jsonData.HiddenFields.siteName!=undefined)
				{
					this.siteName = jsonData.HiddenFields.siteName;
				}
				this.getTransactionsMainPanel().showEmulTransactionGridPanelData(jsonData.GridScreenLabels,jsonData);
				//this.loadTransaction(jsonData);
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	      
	servicesTransactionRender : function(url){
	  //if its refresf then params will be set in request param
	  if(!Ext.isEmpty(urlForRefresh) && urlForRefresh.indexOf('Refreshing=true') < 0)
		{
			if(!Ext.isEmpty(requestParams.transComp) && requestParams.transComp!="null"){
				url+="&transComp="+requestParams.transComp;
			}
			if(!Ext.isEmpty(requestParams.selectedTab) && requestParams.selectedTab!="null"){
				url+="&selectedTab="+requestParams.selectedTab;
			}
			if(!Ext.isEmpty(requestParams.time_line) && requestParams.time_line!="null"){
				url+="&time_line="+requestParams.time_line;
			}
			if(!Ext.isEmpty(requestParams.mode) && requestParams.mode!="null"){
				url+="&mode="+requestParams.mode;
			}
			if(!Ext.isEmpty(requestParams.starthr) && requestParams.starthr!="null"){
				url+="&starthr="+requestParams.starthr;
			
			}
			if(!Ext.isEmpty(requestParams.endhr) && requestParams.endhr!="null"){
				url+="&endhr="+requestParams.endhr;
			}
			if(!Ext.isEmpty(requestParams.starttime) && requestParams.starttime!="null"){
				url+="&starttime="+requestParams.starttime;
			}
			if(!Ext.isEmpty(requestParams.endtime) && requestParams.endtime!="null"){
				url+="&endtime="+requestParams.endtime;
			}
		}
		urlForRefresh = url;
		var rumSize = Object.keys(rumServiceListObject).length;
		var findsHost = "";
		var rumCompFlag = false;
		var servicestate="GOOD";
		if(!Ext.isEmpty(urlForRefresh) && urlForRefresh.indexOf('componentType=') < 0)
		{
			if(rumServiceList != null && rumServiceList.indexOf(curServiceName) > -1 ){
				for(var a=0;a<rumServiceListObject.length;a++){
					var serObject = rumServiceListObject[a];
					if(serObject.name == curServiceName)
					{	
						serviceName = serObject.name;
						servicestate = serObject.servicestate;
						findsHost = serObject.value+":"+serObject.port;
						if(findsHost != null && findsHost != 'undefined' && findsHost != undefined)
						{
							rumCompFlag = true;
							break;
						}
					}
				}
			}
		}
	
		var trasFlag = false;
		if(url.indexOf('1=1') != -1)
			trasFlag = true;

		var tempUrl=url;
		//console.log(trasFlag);
		//if(rumServiceListObject != null && rumServiceListObject != 'undefined' && rumServiceListObject != undefined && rumSize > 0 && false ){
		if(rumCompFlag ){
			//var serviceName = rumServiceListObject[0].name;
			//var compName = rumServiceListObject[0].value;
			//var port = rumServiceListObject[0].port;
			//findsHost = compName+':'+port;
			url = '/final/monitor/realUserMonitorsDashboard.jsp?drilldown=true&from=serviceDash&compName='+findsHost+'&serviceUrl='+encodeURIComponent(parent.filterEncode(tempUrl));
			urlForRefresh = url;
			this.getTransactionsMainPanel().removeAll();
			rumRefresh = new Object();
			rumRefresh.url=url;
			rumRefresh.service=serviceName;
			rumRefresh.trasFlag=trasFlag;
			rumRefresh.state=servicestate;
			

			Ext.Ajax.request({
				url : '/final/monitor/transactions.jsp?site='+serviceName+'&checkTransComp=true&isSite='+this.getServicesDashboard().isSite,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						console.log('jsonData--checkTransComp-->',jsonData);
						this.getTransactionsMainPanel().displayRum(url,serviceName,trasFlag,servicestate,jsonData);
						return;
					}
					else
					{
						this.getTransactionsMainPanel().displayRum(url,serviceName,trasFlag,servicestate,"");
						return;
					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		else
		{

			  Ext.Ajax.request({
				  url : url,
				  scope:this,
				  timeout:280000,
				  success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						this.siteName = jsonData.HiddenFields.siteName;
						  //after refresh the tab value needs to be retained for layout of graphs
						 // if(!Ext.isEmpty(requestParams.selectedTab)){
						  if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
							  if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){
								 
								  this.tab="emulated";
							  }else{
								  this.tab="web";
							  }
						  }
						this.loadTransaction(jsonData);
				   }
				  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			  });
		}
	},
	  
	loadTransaction:function(jsonData){
	  this.getTransactionsMainPanel().removeAll();
	  if(!Ext.isEmpty(jsonData.GridScreenLabels.TransactionHeaders)){
			this.getTransactionsMainPanel().displayGrid(jsonData);
			
			this.getTransactionsMainPanel().showGrid(jsonData);
		}
		if(jsonData.HiddenFields.selectedTab != "EmulatedClients")
			this.getTransactionsMainPanel().updateLabels(jsonData.GridScreenLabels,jsonData.ComponentList);
		this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
		this.siteName = jsonData.HiddenFields.siteName;
		if(!Ext.isEmpty(requestParams.zoomGraph) && (requestParams.zoomGraph == true || requestParams.zoomGraph == 'true'))
		{
			this.getTransactionsMainPanel().hide();
			this.showGraph('event',requestParams.graphId);
		}
	},

	transactionBtnHandler:function(btn){
	  if(btn.itemId == "serviceToolbarEmulatedButton"){
		  this.tab="emulated";
	  }else{
		  this.tab="web";
	  }
	  var url=btn.dataUrl;
	  
	  var transCombo=this.getTransactionCompCombo();
	  if(!Ext.isEmpty(transCombo)){
		  var comp=transCombo.getValue();
		  url+="&transComp="+comp;
	  }
	  if(!Ext.isEmpty(url)){
		  Ext.Ajax.request({
			  url : url,
			  scope:this,
			  timeout:280000,
			  success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					
					this.loadTransaction(jsonData);
			  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
		  });
	  }
	},
	      
	configureTransactionsHandler:function(fromTopo,site){
		if(!Ext.isEmpty(fromTopo) && fromTopo == true)
			this.siteName = site;
		var newUrl = loadTransConfigOnTopo(this.siteName);
		Ext.Ajax.request({
			url: newUrl,
			scope:this,
			timeout:280000,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				this.jsonData = jsonData;
				if(!Ext.isEmpty(fromTopo) && fromTopo == true)
					this.getController('ServicesTopology').jsonData = jsonData;
				//this.getTransactionsMainPanel().removeAll();
				var topToolbar=this.getTransactionsMainPanel().getDockedItems('toolbar[dock="top"]');
				if(!Ext.isEmpty(topToolbar))
					topToolbar[0].setVisible(false);
				var items = this.getTransactionsMainPanel().ConfigurePanels(jsonData);
				var selectButtonFlag = this.getTransactionsMainPanel().enableSelectAll;
				//Ext.getCmp('imagecombo').getStore().loadRawData(publicJSON['imageArray']);
				/*this.getTransactionsMainPanel().add({
					xtype : 'configuretransactions',
					items : items,
					flex : 1
				});*/
					var configWindow = Ext.create('Ext.window.Window',{
						cls:'alarmsbg lightbox',
						width:810,
						closeAction:'destroy',
						autoDestroy:true,
						frame:true,
						doClose: function() {
								var me = this;

								// Being called as callback after going through the hide call below
								if (me.hidden) {
									
									me.fireEvent('close', me);
									refreshURL = '../servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service';
									services.app.getController("Main").refresh(refreshURL);
									if (me.closeAction == 'destroy') {
										this.destroy();
										if(!Ext.isEmpty(urlForRefresh1) && urlForRefresh1.indexOf(".jsp")>-1)
											services.app.getController('ServicesTopology').servicestopologyRender(urlForRefresh1);
									}
								} else {
									// close after hiding
									me.destroy();
									me.hide(me.animateTarget, me.doClose, me);
									
								}
						},
						modal:false,
						title:'CONFIGURE TRANSACTION DETAILS',
						height:510,
						margin:10,
						items : items,
						flex : 1
						//id:'w1'
				});
					configWindow.show();
				/*if((jsonData.upperGridLabels.transHeaders.length > 0) && selectButtonFlag)
					this.getSelectAllButton().show();
				if(!this.getDeselectAllButton().isHidden())
					this.getDeselectAllButton().hide();
				if(!this.getDeleteTransactionsButton().isHidden())
					this.getDeleteTransactionsButton().hide();*/
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	
	addTransaction : function(button){
		var tName= this.getServicesTransactionName().getValue();
		var tPages=this.getServicesTransactionPages().getValue();
		var transcount = this.jsonData.HiddenFields.trancount;
		var transList = this.jsonData.HiddenFields.translist;
		var site = this.siteName;
		var validationMessages = this.jsonData.validationsMessages;
		if(Ext.isEmpty(this.jsonData.HiddenFields.webTransactions)){
			webTransactions = null;
		}else{
			webTransactions = this.jsonData.HiddenFields.webTransactions;
		}
		if(Ext.isEmpty(this.jsonData.HiddenFields.emulTransactions)){
			emulTransactions = null;
		}else{
			emulTransactions=this.jsonData.HiddenFields.emulTransactions;
		}

		var mode=this.jsonData.HiddenFields.mode;
		if(Ext.isEmpty(this.tImage)){
			alert(validationMessages["Please select transaction image"]);
		}else{
			var url = valform(tName,tPages, this.tImage,transcount,transList,site,webTransactions,emulTransactions,user,mode,validationMessages);
			if(url !=null){
				Ext.Ajax.request({
					url: url,
					scope:this,
					timeout:280000,
					success: function(response){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						this.loadTransaction(jsonData);
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
			}
		}
	},
	 setTransactionName : function(ths, newValue, oldValue, eOpts){
		 this.tImage = ths.initialConfig.value;
	 },

	 deleteTransaction : function(button){
		var checks = button.up('servicesdashboard').query('checkboxfield[name=transactions][hidden=false]');
		var trans = [];
		var transUser = checks[0].transCreator;
		if(!Ext.isEmpty(transUser) && !Ext.isEmpty(checks) && transUser != 'admin'){
			for(i=0;i<checks.length;i++){
				if(checks[i].checked){
					trans.push(checks[i].inputValue);
				}
			}
			if(!Ext.isEmpty(trans)){
				var transText = Ext.encode(trans);
				var url = '../monitor/Egaddmontransp.jsp?site='+this.siteName +'&trans='+ trans +'&user='+ user + '&mode=del';
				Ext.Ajax.request({
					  url: url,
					  scope:this,
					  timeout:280000,
					  success: function(response){
						  this.configureTransactionsHandler();
					  },
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
			}
			else
				alert('Choose Transaction(s) to Delete');
		}
		else{
			alert('No delete permission is enabled');
		}
	 },

	 checkdelete : function (trans,TransCreater,mode)
	 {
		var site = this.siteName;
		var sub = "true";

		if(user == 'admin')
		{
			var msg = this.jsonData.validationsMessages.Cannotdelete+" "+ TransCreater +".";
			alert(msg);
			sub = "false";
		}
		else if(user != TransCreater)
		{
			var msg = this.jsonData.validationsMessages.Cannotdelete+" "+ TransCreater +".";
			alert(msg);
			sub = "false";
		}

		if(sub == "true")
		{
			var url = '../monitor/Egaddmontransp.jsp?site='+this.siteName +'&trans='+ trans +'&user='+ user + '&mode=' + mode;
			Ext.Ajax.request({
				  url: url,
				  scope:this,
				  timeout:280000,
				  success: function(response){
					  this.configureTransactionsHandler();
				  },
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
			});
		}
	 },

	onChartsPanelRender:function(panel){
		this.displayGraphInitially(panel.jsonData);
	},
			/*  setTime:function(timeVal){
	    		var arrOptions = timeVal.split('\t');
	    		time_line_obj=new Object();
	    		time_line_obj.starttime=arrOptions[0];
	    		time_line_obj.endtime=arrOptions[1];
	    		time_line_obj.starthr=arrOptions[2];
	    		time_line_obj.endhr=arrOptions[3];
	      },*/
	      
	      timelineChangeHandler:function(combo){
	    	  var timelineValue=combo.getValue();
	    	  if(timelineValue=="Any"){
	    		  this.enableDisableDateFields(true);
	    	  }else{
	    		  this.enableDisableDateFields(false);
	    	  }
	    	  var chartToolbar=this.getTransactionsPanelToolbar();
	    	  
	    	  var chartPanel=this.getTransactionsChartPanel();
	    	  var remoteURL=chartPanel.jsonData.HiddenFields.remoteURL;
	    	  var format=chartPanel.jsonData.HiddenFields.currentDateFormat;
	    	  
	    	  var starttime="";
    		  var startTimeField=chartToolbar.getComponent("from");
    		  if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField.getValue())){
    			  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);

    		  }
    		  
	    	  var endtime="";
    		  var endTimeField=chartToolbar.getComponent("to");
    		  if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField.getValue())){
    			  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
    		  }
    		  
    		  var startHr="";
    		 var fromCombo=chartToolbar.getComponent("fromhr");
    		  if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo.getValue())){
    			  startHr=fromCombo.getValue();
				  				  
    		  }			  

			var endHr="";
    		  var toCombo=chartToolbar.getComponent("tohr");
    		  if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo.getValue())){
    			  endHr=toCombo.getValue();
    		  }

             //Get Minutes
			 var startMin="";
    		 var fromMinCombo=chartToolbar.getComponent("frommin");
    		  if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
    			  startMin=fromMinCombo.getValue();
				  				  
    		  }			

			  var endMin="";
    		  var toMinCombo=chartToolbar.getComponent("tomin");
    		  if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
    			  endMin=toMinCombo.getValue();
    		  }

			  //
			 // alert("startMin==="+startMin);
			 // alert("endMin:::==="+endMin);



			  var paramValues='F=getTimeJSON&P0=['+timelineValue+']&P1=['+starttime+']&P2=['+endtime+']&P3=['+startHr+']&P4=['+endHr+']&P5=['+format+']&P6=['+startMin+']&P7=['+endMin+']&C=1&calljson=true';
			  
			 // alert("Remote URL:::::"+remoteURL);
			 // alert(paramValues);
			  
			  Ext.Ajax.request({
				  url: remoteURL,
				  scope:this,
				  method: 'POST',
				  params: paramValues,
				  timeout:280000,
				  success: function( response )
				  {
						if ( response.status == 200 && !Ext.isEmpty(response.responseText))
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							this.setTime(jsonData.getTime,timelineValue);
						}
				  },
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
			});

	//jsrsExecute(remoteURL,this.setTime,"getTime",new Array(""+timelineValue,""+starttime,""+endtime,""+startHr,""+endHr,""+format));

	      },
	      
	      displayZoomGraph : function(){
	    	  var zoomGraphPanel =this.getZoomGraphPanel();
	    	  if(!Ext.isEmpty(zoomGraphPanel) && !Ext.isEmpty(zoomGraphPanel.jsonData)){
	    		  var jsonData=zoomGraphPanel.jsonData;
				  var showLegend = zoomGraphPanel.items.items[0].items.items[6];
				  var isLegendSelected = false;
				 // if( !Ext.isEmpty( showLegend.items.items[0]))
				   if( !Ext.isEmpty( showLegend.items ))
					isLegendSelected = showLegend.items.items[0].getValue();
	    		  var mode="";
	    		  var starttime="";
	    		  var endtime="";
	    		  var startHr=""
				  var startMin="";
	    		  var endHr="";
				  var endMin="";
	    		  var time_line="";
	    		  var dateError = '';
	    		  var modeCombo=this.getZoomGraphComboMode();
	    		  if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
	    			  mode=modeCombo.getValue();
	    		  }
	    		  var startTimeField=this.getZoomGraphFromDate();
	    		  if(!Ext.isEmpty(startTimeField)){
	    			  if(!Ext.isEmpty(startTimeField.getValue())){
	    				  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
					  }else{
						  if(!Ext.isEmpty(time_line_obj)){
								starttime=time_line_obj.starttime;
						  }else{
								starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
						  }
					  }
	    		  }
				  else{
						  if(!Ext.isEmpty(time_line_obj)){
								starttime=time_line_obj.starttime;
						  }
				  }
	    		  var endTimeField=this.getZoomGraphToDate();
	    		  if(!Ext.isEmpty(endTimeField)){
	    			  if(!Ext.isEmpty(endTimeField.getValue())){
	    			  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
	    			  }else{
						  if(!Ext.isEmpty(time_line_obj)){
							  endtime=time_line_obj.endtime;
						  }else{
								endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
						  }
	    			  }
	    		  }
				  else{
						  if(!Ext.isEmpty(time_line_obj)){
							  endtime=time_line_obj.endtime;
						  }
				  }
	    		  var fromCombo=this.getZoomGraphComboFromhr();
	    		  if(!Ext.isEmpty(fromCombo)){
	    			  if(!Ext.isEmpty(fromCombo.getValue())){
	    				  startHr=fromCombo.getValue();
	    			  }else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    						startHr=time_line_obj.starthr;
	    				  }else{
	    						startHr=fromCombo.getValue();
	    				  }
	    			  }
	    		  }
				  
	    		  var toCombo = this.getZoomGraphComboTohr();
	    		  if(!Ext.isEmpty(toCombo)){
	    			  if(!Ext.isEmpty(toCombo.getValue())){
	    				  endHr=toCombo.getValue();
	    			  }else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    					  endHr=time_line_obj.endhr;
	    				  }else{
	    					  endHr=toCombo.getValue();
	    				  }
	    			  }
	    		  }
				  else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    					  endHr=time_line_obj.endhr;
	    				  }
	    		 }


				// for min

				 var fromMinCombo=this.getZoomGraphComboFrommin();
	    		  if(!Ext.isEmpty(fromMinCombo)){
	    			  if(!Ext.isEmpty(fromMinCombo.getValue())){
	    				  startMin=fromMinCombo.getValue();
	    			  }else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    						startMin=time_line_obj.startmin;
	    				  }else{
	    						startMin=fromMinCombo.getValue();
	    				  }
	    			  }
	    		  }

				
				  var toMinCombo = this.getZoomGraphComboTomin();
	    		  if(!Ext.isEmpty(toMinCombo)){
	    			  if(!Ext.isEmpty(toMinCombo.getValue())){
	    				  endMin=toMinCombo.getValue();
	    			  }else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    					  endMin=time_line_obj.endmin;
	    				  }else{
	    					  endMin=toMinCombo.getValue();
	    				  }
	    			  }
	    		  }
				  else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    					  endMin=time_line_obj.endmin;
	    				  }
	    		 }

				
				//

	    		  var dateError = startTimeField.getName();
		
		


				var starttimeVal= formatDate(startTimeField.getValue(), "MM/dd/yyyy");
				var endtimeVal= formatDate(endTimeField.getValue(), "MM/dd/yyyy");


				if(dateValidation(starttimeVal,endtimeVal,parseInt(startHr),parseInt(endHr),0,0)==-1)
				{
			
					Ext.Msg.alert('Error', dateError);
					return;
				}

	    		  if(starttime > endtime){
	    				 // Ext.Msg.alert('Error', dateError);
	    				 // return;
	    		  }
	    		  if(starttime == endtime){
	    			  if(startHr >= endHr){
	    				 // Ext.Msg.alert('Error', dateError);
	    				  //return;
	    			  }
	    			
	    		  }
	    		  var timelineCombo=this.getZoomGraphComboTimeline();
	    		  if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){	
	    				time_line=timelineCombo.getValue();
	    		  }
	    		this.fromAnyButton=false;
	    		var pageUrl = "/final/monitor/egDashBoardTimeline.jsp?graphType=TransactionGraph&isZoomGraph=true&come_from=Transactions&graphId="+this.graphId; 
		    	var scrWid=documentView.getWidth();
		    	var scrHei=documentView.getHeight();
		    		pageUrl=pageUrl+"&screenWidth="+scrWid+"&screenHeight="+scrHei+"&showLegend="+isLegendSelected;
	    		  var zoomGraphPanel=this.getZoomGraphPanel();
	    		  zoomGraphPanel.getEl().mask("Loading...");
	    		  
	    		  var zoomGraphParams={
					  imgPath:"../servlet/com.egurkha.TransactionMeasuresDisplay",
					  graphType:"TransactionGraph",
					  timeline_compare:time_line,
					  duration:jsonData.hiddenFields.duration,
					  mode:'2D',
					  durationChanged:jsonData.hiddenFields.durationChanged,
					  isZoomGraph:"true",
					  come_from:"Transactions",
					  site:jsonData.hiddenFields.site,
					  comp:jsonData.hiddenFields.compName,
					  test:jsonData.hiddenFields.test,
					  measure:jsonData.hiddenFields.measure,
					  gformat:"graph",
					  GraphSize:"true",
					  monitorSkin:jsonData.hiddenFields.monitorSkin,
					  mode:'2D',
					  starttime:starttime,
					  endtime:endtime,
					  starthr:startHr,
					  endhr:endHr,
					  startmin:startMin,
					  endmin:endMin,
					  time_line:time_line,
					  all_trans_names:jsonData.hiddenFields.all_trans_names,
					  msmt_host:jsonData.hiddenFields.mHost,
					  graphId:this.graphId,
					  screenWidth:scrWid,
					  screenHeight:scrHei,
					  treeOpen:"none",
					  showLegend:isLegendSelected
				  };
		    	  Ext.Ajax.request({
		    		  url : pageUrl,
		    		  params:zoomGraphParams,
		    		  scope:this,
					  timeout:280000,
		    		  success: function(response){
		    			  var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						 zoomGraphPanel.getEl().unmask();
						this.getServiceTransactionPanel().getLayout().getActiveItem().removeAll();
						this.getServiceTransactionPanel().getLayout().getActiveItem().createItems(jsonData);
		    			},
						failure:function(){
							//window.parent.location.href="/final/servlet/com.egurkha.Logout";
						}
		    	  });
	    	  }
	      },
	      setTime:function(timeVal,timelineValue){	
	    		var arrOptions = timeVal.split('\t');
				var frHr="",toHr="";
				var frMin="",toMin="";
	    		time_line_obj=new Object();
	    		time_line_obj.starttime=arrOptions[0];
				var startdt ="",enddt="";

				if(timelineValue=="Any"){
					 startdt = Ext.Date.format(arrOptions[6],mgr_dateFormat);
					 enddt = Ext.Date.format(arrOptions[7],mgr_dateFormat);
				}
				else
			   {
					startdt = new Date(arrOptions[6]);
					enddt = new Date(arrOptions[7]);

					 startdt = Ext.Date.format(arrOptions[6],mgr_dateFormat);
					 enddt = Ext.Date.format(arrOptions[7],mgr_dateFormat);

			   }
				if(startdt == "Invalid Date" || startdt =="" )
					startdt = arrOptions[6];
					//enddt = new Date(arrOptions[7]);
				if(enddt == "Invalid Date" || enddt =="" )
					enddt = arrOptions[7];
				var tmp_start_date="",tmp_end_date="";
				tmp_start_date= Ext.Date.format(startdt,mgr_dateFormat);
				tmp_end_date = Ext.Date.format(enddt,mgr_dateFormat);
				startdt = (tmp_start_date == "")?startdt:tmp_start_date;
				enddt = (tmp_end_date == "")?enddt:tmp_end_date;
				this.getTransactionsPanelToolbar().getComponent("from").setValue(startdt);
				
	    		time_line_obj.endtime=arrOptions[1];
				this.getTransactionsPanelToolbar().getComponent("to").setValue(enddt);
	    		time_line_obj.starthr=arrOptions[2];
				 if(timelineValue=="Any"){

					//frHr = arrOptions[2];
					//toHr = arrOptions[3];
					frHr = arrOptions[8];
					toHr = arrOptions[9];
				 }
				 else
				  {
					frHr = arrOptions[8];
					toHr = arrOptions[9];
				  }

				  //set Min
				  frMin = arrOptions[10];
				  toMin = arrOptions[11];
				this.getTransactionsPanelToolbar().getComponent("frommin").setValue(frMin);
				this.getTransactionsPanelToolbar().getComponent("tomin").setValue(toMin);
					
				  //



				this.getTransactionsPanelToolbar().getComponent("fromhr").setValue(frHr);
	    		time_line_obj.endhr=arrOptions[3];
				this.getTransactionsPanelToolbar().getComponent("tohr").setValue(toHr);
				var chartToolbar=this.getTransactionsPanelToolbar();
			},
	      enableDisableDateFields:function(enable){
	    	//  var chartToolbar=this.getTransactionsChartPanelToolbar();
	    	  var chartToolbar=this.getTransactionsPanelToolbar();
	    	  var startTimeField=chartToolbar.getComponent("from");
	    	  var endTimeField=chartToolbar.getComponent("to");
	    	  var fromCombo=chartToolbar.getComponent("fromhr");
	    	  var toCombo=chartToolbar.getComponent("tohr");
	    	  
	    	  if(enable){
	    		  startTimeField.setDisabled(false);
	    		  endTimeField.setDisabled(false);
	    		  fromCombo.setDisabled(false);
	    		  toCombo.setDisabled(false);
	    	  }else{
	    		  startTimeField.setDisabled(true);
	    		  endTimeField.setDisabled(true);
	    		  fromCombo.setDisabled(true);
	    		  toCombo.setDisabled(true);
	    	  }
	      },
	      
			displayGraph:function(){
			  var cdate = this.getCurrentDateTime();
			  var chartOption = chartGraphType(cdate);
			  if(chartOption.indexOf("highchart") > -1)
			  {
				//this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
			  }
			  else
				{
					//this.getTransactionChartComboMode().hide();
					this.getTransactionComboMode().hide();
				}
	    	  var chartPanel=this.getTransactionsChartPanel();
	    	  if(!Ext.isEmpty(chartPanel) && !Ext.isEmpty(chartPanel.jsonData)){
	    		  var jsonData=chartPanel.jsonData;
	    		  var mode="";
	    		  var starttime="";
	    		  var endtime="";
	    		  var startHr="";
				  var startMin="";
	    		  var endHr="";
				  var endMin="";
	    		  var time_line="";
	    		  var dateError = '';
	    		//  var chartToolbar=this.getTransactionsChartPanelToolbar();
	    		  var chartToolbar=this.getTransactionsPanelToolbar();
	    		  var modeCombo=chartToolbar.getComponent("mode");
	    		  if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
	    			  mode=modeCombo.getValue();
	    		  }
	    		  var startTimeField=chartToolbar.getComponent("from");
	    		  if(!Ext.isEmpty(startTimeField)){
	    			  if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
	    				  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
					  }else{
						  if(!Ext.isEmpty(time_line_obj)){
							  starttime=time_line_obj.starttime;
						  }else{
							  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
						  }
					  }
	    		  }
	    		  
	    		  var endTimeField=chartToolbar.getComponent("to");
	    		  if(!Ext.isEmpty(endTimeField)){
	    			  if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
	    			  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
	    			  }else{
						  if(!Ext.isEmpty(time_line_obj)){
							  endtime=time_line_obj.endtime;
						  }else{
							  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
						  }
	    			  }
	    		  }
	    		
	    		var fromCombo=chartToolbar.getComponent("fromhr");
	    		if(!Ext.isEmpty(fromCombo)){
	    			  if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
	    				startHr=fromCombo.getValue();
						 
	    			  }else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    					  startHr=time_line_obj.starthr;
							   
	    				  }else{
	    						startHr=fromCombo.getValue();
							}
	    			}
	    		}

	    		  var toCombo=chartToolbar.getComponent("tohr");
	    		  if(!Ext.isEmpty(toCombo)){
	    			  if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
	    				  endHr=toCombo.getValue();
	    			}else{
	    				  if(!Ext.isEmpty(time_line_obj)){
	    						endHr=time_line_obj.endhr;
	    				  }else{
	    						endHr=toCombo.getValue();
	    				  }
	    			  }
	    		  }			

				   //Get Minutes
			 var startMin="";
    		 var fromMinCombo=chartToolbar.getComponent("frommin");
    		  if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
    			  startMin=fromMinCombo.getValue();
				  				  
    		  }			

			  var endMin="";
    		  var toMinCombo=chartToolbar.getComponent("tomin");
    		  if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
    			  endMin=toMinCombo.getValue();
    		  }

			  //

	    		 // var timeLineCombo=this.getTransactionChartComboTimeline();
	    		  var timeLineCombo=this.getTransactionComboTimeline();
	    		  if(timeLineCombo.getValue() =="Any"){
						var dateError = startTimeField.getName();
						var currentDateError = endTimeField.getName()
						var startTime = startTimeField.getValue();
						var endTime = endTimeField.getValue();
						var curTime = curDateTime;
						var currentMgrDate = new Date(curTime);

				var starttime= formatDate(startTime, "MM/dd/yyyy");
				var endtime= formatDate(endTime, "MM/dd/yyyy");
						
				if(dateValidation(starttime,endtime,parseInt(startHr),parseInt(endHr),0,0)==-1)
				{
					//var msg ="From date should be lesser than to date";
					Ext.Msg.alert('Error', dateError);
					return;
				}


/*if((startTime > currentMgrDate )|| (endTime > currentMgrDate)){
							Ext.Msg.alert('Error', currentDateError);
							return;
						}
						if(startTimeField.getValue() > endTimeField.getValue()){
							Ext.Msg.alert('Error', dateError);
							return;
						}
						else if(startTimeField.getValue().getDate()==endTimeField.getValue().getDate()&&startTimeField.getValue().getMonth()==endTimeField.getValue().getMonth()&&startTimeField.getValue().getFullYear()==endTimeField.getValue().getFullYear()){
							if(startHr>=endHr){
								Ext.Msg.alert('Error', dateError);
								return;
							}
						}*/
	    		}
	    		 
	    		  this.anyStartTime=starttime;
				  this.anyEndTime=endtime;
				  this.anyStartHr=startHr;
				  this.anyEndHr=endHr;
	    		  var timelineCombo=chartToolbar.getComponent("timeline");
	    		  if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
	    			  time_line=timelineCombo.getValue();
	    		  }
	    		  var chartPanel=this.getTransactionsChartPanel();
	    		 
				   var cdate = this.getCurrentDateTime();
				  var chartOption = chartGraphType(cdate);
	    		  this.transactionMeasuresParam={
							 startTrans:'',
			    		     site:jsonData.HiddenFields.siteName,
			    		     comp:jsonData.HiddenFields.compName,
			    		     test:jsonData.HiddenFields.testForTab,
			    		     measure:jsonData.HiddenFields.measurelst,
			    		     gformat:"graph",
							 chartType:chartOption,
			    		     GraphSize:"true",
			    		     monitorSkin:jsonData.HiddenFields.monitorSkin,
			    		     mode:'2D',
			    		     starttime:startTimeField.getRawValue(),
			    		     endtime:endTimeField.getRawValue(),
			    		     starthr:startHr,
			    		     endhr:endHr,
							 startmin:startMin,
							 endmin:endMin,
							 time_line:time_line,
			    		     all_trans_names:jsonData.HiddenFields.all_trans_names,
			    		     msmt_host:jsonData.HiddenFields.mHost,
							 endTrans:'',
							 isAreaChart:isAreaChart,
			    	  	  };
				
				 // this.getTransactionChartComboMode().show();
				  if(chartOption.indexOf("highchart") > -1)
				  {
					  this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
					 // this.getTransactionChartComboMode().hide();
					  this.getTransactionComboMode().hide();
				  }
				  else
				  {
					 // this.getTransactionChartComboMode().hide();
					  this.getTransactionComboMode().hide();
					  chartPanel.getEl().mask("Loading...");
					Ext.Ajax.request({
		    		  url : this.transactionMeasuresChartURL,
		    		  params: this.transactionMeasuresParam,
					  method:'get',
		    		  scope:this,
		    		  success: function(response){
		    	  		  		var chartPnl=this.getTransactionsChartPanel();
		    	  		  		chartPnl.getEl().unmask();
		    	  		  		this.createGraphs(response);
		    			  	},
		    				failure:function(){
		    			  		var chartPnl=this.getTransactionsChartPanel();
		    	  		  		chartPnl.getEl().unmask();
		    			  	}
		    	  });
	    	  }
			  }
	      },
	      
	      displayGraphInitially:function(jsonData){	    	  
	    	 var  mode=jsonData.HiddenFields.mode
	    	 var  starttime=jsonData.HiddenFields.starttime
	    	 var  endtime=jsonData.HiddenFields.endtime
	    	 var  starthr=jsonData.HiddenFields.startHr
	    	 var  endhr=jsonData.HiddenFields.endHr
	    	 var  time_line=jsonData.HiddenFields.timeline
			 var  startmin = jsonData.HiddenFields.startMin
			 var  endmin = 	 jsonData.HiddenFields.endMin
			// alert("startmin"+startmin);
			// alert("endmin"+endmin);

	    	 var cdate = this.getCurrentDateTime();
			 var chartOption = chartGraphType(cdate);

	    	 if(requestParams.refresh==true){
	    		  mode=requestParams.mode
		    	   starttime=jsonData.HiddenFields.starttime
		    	   endtime=jsonData.HiddenFields.endtime
		    	   starthr=jsonData.HiddenFields.startHr
		    	   endhr=jsonData.HiddenFields.endHr
				   startmin = jsonData.HiddenFields.startMin
				   endmin=jsonData.HiddenFields.endMin

		    	   time_line=requestParams.timeline
	    		 
	    	 }
			 if(!Ext.isEmpty(starttime) && !Ext.isEmpty(endtime))
			 {
				starttime=Ext.Date.format(new Date(starttime),mgr_dateFormat);
				endtime=Ext.Date.format(new Date(endtime),mgr_dateFormat);	
			 }
	    	 this.transactionMeasuresParam={
	    		     site:jsonData.HiddenFields.siteName,
	    		     comp:jsonData.HiddenFields.compName,
	    		     test:jsonData.HiddenFields.testForTab,
	    		     measure:jsonData.HiddenFields.measurelst,
	    		     gformat:"graph",
	    		     GraphSize:"true",
	    		     monitorSkin:jsonData.HiddenFields.monitorSkin,
	    		     mode:'2D',
	    		     starttime:starttime,
	    		     endtime:endtime,
	    		     starthr:starthr,
					 startmin:startmin,
                 
					 //starthr:startHr,
	    		     endhr:endhr,
					 endmin:endmin,
	    		     time_line:time_line,
	    		     all_trans_names:jsonData.HiddenFields.all_trans_names,
	    		     msmt_host:jsonData.HiddenFields.mHost,
					 isAreaChart:isAreaChart,
	    	  	  };
	    	  if(!Ext.isEmpty(jsonData.HiddenFields)){
				  var cdate = this.getCurrentDateTime();
				  var chartOption = chartGraphType(cdate);
				//  this.getTransactionChartComboMode().hide();
				if(chartOption != null){
					  if(chartOption.indexOf("highchart") > -1)
					  {
						 // this.getTransactionChartComboMode().hide();
						  this.getTransactionComboMode().hide();
						  this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
					  }
					  else
					  {
						//  this.getTransactionChartComboMode().hide();
						  this.getTransactionComboMode().hide();
						 var chartPnl=this.getTransactionsChartPanel();
						 chartPnl.setLoading(true,true);
						  Ext.Ajax.request({
							  url : this.transactionMeasuresChartURL,
							  params:this.transactionMeasuresParam,
							  scope:this,
							  timeout:280000,
							  success: function(response){
										this.createGraphs(response);
										chartPnl.setLoading(false);
									},
									failure:function(){
										//window.parent.location.href="/final/servlet/com.egurkha.Logout";
									}
						  });
					  }
				}
	    	  }
	      },
	      
	      bigGraphOnClick : function(){
	    	  this.getServiceTransactionPanel().getLayout().setActiveItem(0);
	      },
	     showGraph:function(event, z)
		 {
			  this.graphId=z;
			  this.showBigGraph(event,z,'TransactionGraph');
		 },
		 showGraph:function(event, z,transParam)
		 {
			  //alert(z)
			  this.graphId=z;
			  if(!Ext.isEmpty(transParam) && transParam != null && transParam !=undefined)
				this.showBigGraph(event,z,'TransactionGraph',transParam);
			  else
				  this.showBigGraph(event,z,'TransactionGraph','');

		 },
		      
		 showBigGraph:function(event,index,graphType,transParam){
		    	  var pageUrl = "/final/monitor/egDashBoardTimeline.jsp?graphType="+graphType+"&isZoomGraph=true&come_from=Transactions&graphId="+this.graphId; 
		    		var scrWid=documentView.getWidth();
		    		var scrHei=documentView.getHeight();
		    		pageUrl=pageUrl+"&screenWidth="+scrWid+"&screenHeight="+scrHei;
		    		if(event!=null && event!='undefined')
		    			event=(isIE())?window.event:event;
		    		 var zoomGraphPanel=this.getZoomGraphPanel();
		    		  zoomGraphPanel.getEl().mask("Loading...");
		    		  zoomGraphPanel.graphId = index;
					  zoomGraphPanel.urlparam = pageUrl;
					  this.chart_url=pageUrl;
					  if(!Ext.isEmpty(transParam) && transParam != null && transParam !=undefined)
						{
						  logonChartType = 'line';
						  this.transactionMeasuresParam = transParam;
						}
			    	  Ext.Ajax.request({
			    		  url : pageUrl,
			    		  params:this.transactionMeasuresParam,
			    		  scope:this,
						  timeout:280000,
			    		  success: function(response){
			    			var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							this.getServiceTransactionPanel().getLayout().setActiveItem(1);
							this.getServiceTransactionPanel().getLayout().getActiveItem().removeAll();
							this.getServiceTransactionPanel().getLayout().getActiveItem().createItems(jsonData);
							 zoomGraphPanel.getEl().unmask();
			    			},
							failure:function(){
								//window.parent.location.href="/final/servlet/com.egurkha.Logout";
							}
			    	  });
		  },
			getItems:function(size){
			   var skinBg="";

				if (strSkin=="Dark")
				{
					skinBg="#444444";
				}
				else if (strSkin=="Light")
				{
					skinBg="#ffffff";
				}
				var items=[];
				for(var i=0;i<size;i++){
					var idName ='transchart'+i; 
				    items.push({
						xtype: 'panel',
						cls:'uxGraphPanel',
						bodyStyle:{background: skinBg+'!important'},
					
					tools:[
						{
							xtype:'toolbar',
							ui:'footer',
							items:[
								{
									xtype:'button',
									border:0,
									id:'highMax'+i,
									cls:'iconMaximize showgraph',
									handler:function(){
										var idStr = this.getId();
										idStr = idStr.substring(7);
										showGraph('event',idStr);
									}
								}	
							]
						}	 
					 ],
					 margin:'5 10',
					 frame:true,
					 border:false,
					 padding:0,
				     title:'',
					 id:idName
					
				   })
				}
			
			return items;
		  },
		   createDivforHighChart:function(size){
			  var chartPanel=this.getTransactionsChartPanel();
			  var imgDiv = '';
			  if(this.tab=='emulated')
					tmp_div_size_of_td=size;
			  else
					tmp_div_size_of_td=(size/2);
				var inc = 0;
				var chartPane = '',legendPanel = '';
				/*chartPane = '<div id="chartsDiv" style="background-color:#fff;width:100%;height:100%"><table style="background-color:#fff;" width="100%"><col width="25%"><tr>';
				
				var chartPanel2 = [];
				
				for(var i=0;i<tmp_div_size_of_td;i++)
				{
						chartPane+='<td width="25%">';
						chartPane+='<div id="transchart'+i+'" style="float:left;margin:10px;border:#cdcdcd 1px solid"></div>';
						chartPane+='</td>';
						var subpanel ={xtype:'panel',id:'transchart'+i,width:200};
						chartPanel2.push(subpanel);
				}
				chartPane+='</tr>';
				chartPane+='<tr><td colspan="3" align="center"><div id="translegend" align="center" style="padding: 10px 0 0 0;"></div></td></tr>';
				chartPane+='<tr>';
				var subpanel ={xtype:'panel',id:'translegend',width:200};
				chartPanel2.push(subpanel);
				for(var z=tmp_div_size_of_td;z<size;z++)
				{
					chartPane+='<td width="30%" >';
					chartPane+='<div id="transchart'+z+'" style="float:left;margin:10px;border:#cdcdcd 1px solid"></div>';
					chartPane+='</td>';
					var subpanel ={xtype:'panel',id:'transchart'+z,width:200};
					chartPanel2.push(subpanel);
				}
				chartPane+='</tr>';
				chartPane+='</table></div>';*/
				chartPanel.removeAll();
				var scrollPanel=Ext.create('utilities.ScrollPanel',{
						layout:{type:'vbox',align:'stretch'},
						height:80,
						items:[{xtype:'container',id:'legends'},{
					xtype : 'container',
					//style:{'border':'1px solid blue'},
					//height: 20,
					height:525,
					border:true,
//					layout: 'vbox',
					layout:'column',
					id:'midid',
					defaults:{
					 columnWidth:.33,
					 height: 250
					},
					items:this.getItems(size)
					//style: {background:'#e6e6e6'},
					//html  : chartPane
				}]
				});
				chartPanel.add(scrollPanel);
					/*--Adding Legend--*/
					/* var chartToolbar=this.getTransactionsChartPanel().getDockedItems()[1];
						chartToolbar.remove(Ext.getCmp('legends'));
					chartToolbar.add('->',{xtype:'container',id:'legends'});*/
					
		  },
		  getEasyChartItems:function(size){
			  var items=[];
				for(var i=0;i<size;i++){
					var idName ='transeasychart'+i; 
				    items.push({
					 xtype: 'panel',
					 //cls:'datapanel',
					//bodyStyle:{'background':'#fff'},
					html:'',
					tools:[
						{
							xtype:'toolbar',
							ui:'footer',
							items:[
								{
									xtype:'button',
									border:0,
									id:'easyMax'+i,
									cls:'iconMaximize showgraph',
									handler:function(){
										var idStr = this.getId();
										idStr = idStr.substring(7);
										showGraph('event',idStr);
									}
								}	
							]
						}	 
					 ],
					 margin:'5 10',
					 frame:true,
					 border:true,
					 padding:0,
				     title:'',
					 id:idName
					
				   })
				}
			
			return items;
			
		  },
	      createGraphs:function(response){
			var cdate = this.getCurrentDateTime();
			  var highChartUrls = new Array();
			  var highChartParams = new Array();
			  var highChartIds = new Array();
	  		    var chartPanel=this.getTransactionsChartPanel();
			  	var resXML=response.responseXML;
			  	var tab="Web";
			  	var measures=chartPanel.jsonData.HiddenFields.measurelst;
			  	var measure_list_value=measures.split(",")
				chartPanel.update('');
			  	if(resXML!=null || response != null){
			  		var response  = resXML.documentElement;
			  	    //if measures present show graph
			  		if(response!=null){
						var chartOption = chartGraphType(cdate);
			  			var TotalTd=response.getElementsByTagName('TotalTd')[0].firstChild.data;
			  			if(TotalTd!=null && TotalTd!='' && TotalTd!='NoMeasuresFound'){
			  				var div_size_of_td;
							if(this.tab=='emulated')
								div_size_of_td=TotalTd;
							else
								div_size_of_td=(TotalTd/2);
							chartPanel.removeAll();

							var scrollPanel=Ext.create('utilities.ScrollPanel',{
								layout:{
									type:'vbox',
									align:'stretch'},
									height:80,
									items:[{xtype:'container',id:'legends'},{
										xtype : 'container',
										//height: 20,
										//style:{'border':'1px solid red'},
										border:true,
					//					layout: 'vbox',
										layout:'column',
										id:'easymidid',
										defaults:{
										 columnWidth:.33,
										 height: 230
								},
								items:this.getEasyChartItems(TotalTd)
								//style: {background:'#e6e6e6'},
								//html  : chartPane
							}]
							});
							chartPanel.add(scrollPanel);
								/*--Adding Legend--*/
								/* var chartToolbar=this.getTransactionsChartPanel().getDockedItems()[1];
								chartToolbar.remove(Ext.getCmp('legends'));
								chartToolbar.add('->',{xtype:'container',id:'legends'});*/
							var cell_count=0;
							//var htmlStr1='<div id="chartsDiv" style="width:100%;height:100%"><table><tr>';
							
							for(var z=0;z<div_size_of_td;z++){
								var htmlStr1='';
								var filename=response.getElementsByTagName('FileNameTd'+z)[0].firstChild.data;
								var chartTitleValue =response.getElementsByTagName('ChartTitleTd'+z)[0].firstChild.data;
								var imgSrc="../servlet/com.egurkha.TransactionMeasuresDisplay?&filename="+filename;
								//htmlStr1+='<td>';
								htmlStr1+='<img src="'+imgSrc+'" id="loadGraph'+z+'" hspace = "0" vspace = "0" border = "0" align = "center" valign="middle" onClick="javascript:showGraph(event,'+z+');" class="mouse"/>';
								//htmlStr1+='</td>';
								var chartObj = Ext.getCmp('transeasychart'+z);
								if(!Ext.isEmpty(chartObj))
								{
									chartObj.update(htmlStr1);
									chartObj.setTitle('<span class="font_bold11">'+chartTitleValue+'</span>');
								}
							}
							//htmlStr1+="</tr>";
							//var htmlStr2="<tr>";
							
							for(var z=div_size_of_td;z<TotalTd;z++){
								var htmlStr2="";
								var filename=response.getElementsByTagName('FileNameTd'+z)[0].firstChild.data;
								var chartTitleValue =response.getElementsByTagName('ChartTitleTd'+z)[0].firstChild.data;
								var imgSrc="../servlet/com.egurkha.TransactionMeasuresDisplay?&filename="+filename;
								//htmlStr2+='<td>';
								htmlStr2+='<img src="'+imgSrc+'" id="loadGraph'+z+'" hspace = "0" vspace = "0" border = "0" align = "center" valign="middle" onClick="javascript:showGraph(event,'+z+');" class="mouse"/>';
								//htmlStr2+='</td>';
								var chartObj = Ext.getCmp('transeasychart'+z);
								if(!Ext.isEmpty(chartObj))
								{
									chartObj.update(htmlStr2);
									chartObj.setTitle('<span class="font_bold11">'+chartTitleValue+'</span>');
								}
							}
							//htmlStr2+="</tr>";
							//htmlStr2+="</table></div>";
							
							var htmlStrMid="<table align='center'><tr>";
							var Legend_Total   =response.getElementsByTagName('LegendsTotal')[0].firstChild.data;
							var tdValues="";
							if(Legend_Total!=null && Legend_Total!='')
							{
								for(var z=0;z<Legend_Total;z++)
								{
									var LegendTdName    =response.getElementsByTagName('LegendTdName'+z)[0].firstChild.data;
									if(LegendTdName!=null && LegendTdName.indexOf("^")>-1)
									{
										
										var trans_name_temp=LegendTdName.substring(0,LegendTdName.lastIndexOf("^"));
										var color_code_temp=LegendTdName.substring(LegendTdName.lastIndexOf("^")+1);
										tdValues=tdValues+"<td width='10' height='10' align='center'>";
										tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
										tdValues=tdValues+"<tr>";
										tdValues=tdValues+"<td width = '10' style='vetical-align:top' class='linesquare_white' height='5'><div style='background:"+color_code_temp+";height:8px;width:8px' ><div></td></tr></table></td>";
										tdValues=tdValues+"<td nowrap style='padding-left:3px;padding-right:15px; height:10px' >"+trans_name_temp+"</td>";
									}
								}
							}
							var legendTable="";
							htmlStrMid+='<td colSpan="'+measure_list_value.length+'"><div>';
							if(tdValues!=null && tdValues!='')
							{
								legendTable="<table border='0' cellspacing='0' cellpadding='0' height='20' align='center'><tr id='LegendsTr'>"+tdValues+"</tr></table>";
							}
							htmlStrMid+=legendTable;
							htmlStrMid+="</div></td></tr></table>";
							var legContainer = Ext.get('legends');
							if(!Ext.isEmpty(legContainer))
							{
								Ext.getCmp('legends').update(htmlStrMid);
							}
							
							/*var htmlStr=htmlStr1+htmlStrMid+htmlStr2;
							var firstCmp = Ext.getCmp('firstid');
							var midCmp = Ext.getCmp('midid');
							var lastCmp = Ext.getCmp('lastid');
							if(!Ext.isEmpty(firstCmp))
								chartPanel.remove(firstCmp);
							if(!Ext.isEmpty(midCmp))
								chartPanel.remove(midCmp);
							if(!Ext.isEmpty(lastCmp))
								chartPanel.remove(lastCmp);
							chartPanel.update("");
							chartPanel.update(htmlStr);
							
							//after some time fire the handle scrollbars function for the scrollbars to appear.
								Ext.Function.defer(function(){
								  var chartPanel=this.getTransactionsChartPanel();
								  chartPanel.handleScrollBars(chartPanel);
								 
							  }, 500, this);*/
					
			  			}
			  			else{
			  			//show error msg
				  			this.displayErrorMsg();
			  			}
			  		}else{
			  			//show error msg
			  			this.displayErrorMsg();
			  		}
			  	}else{
		  			//show error msg
		  			this.displayErrorMsg();
		  		}
	      },
	      createHighStockChart:function(url,param){
			var seriesOptions = [],
			yAxisOptions = [],
			seriesCounter = 0;
			var title = "";
			var colors = "";
			var fmts = "";
			var axisTitle = "";
			var min = "";
			var max = "";
			var xmax = "";
			var xmin = "";
			var lineWidth = "";
			var TotalTd = 0;
			var cell_count=0;
			var itemsArray=[];
			var tdValues="";
			var chartPanel=this.getTransactionsChartPanel();
			var measures=chartPanel.jsonData.HiddenFields.measurelst;
			var measure_list_value=measures.split(",");
			var tab="Web";
			
			var firstCmp = Ext.getCmp('firstid');
			var midCmp = Ext.getCmp('midid');
			var lastCmp = Ext.getCmp('lastid');

			if(!Ext.isEmpty(errorPanel) && errorPanel==true)
			{
				chartPanel.update("");
				if(!Ext.isEmpty(firstCmp))
					chartPanel.remove(firstCmp);
				if(!Ext.isEmpty(midCmp))
					chartPanel.remove(midCmp);
				if(!Ext.isEmpty(lastCmp))
					chartPanel.remove(lastCmp);
			}
			var me = this;
			 var chartPnl=this.getTransactionsChartPanel();
			chartPnl.setLoading(true,true);
			Ext.Ajax.request(
			{
				url : url,
				params:param,
				scope:this,
				timeout:6000000,
				success: function(response) 
				{	
					if(response.status == 200 && !Ext.isEmpty(response))
					{
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var data=Ext.decode(jsonText);
							if(!Ext.isEmpty(data))
							{
								var chartData=[];
								var htmlStr1='';
								var htmlStr2='';
								var htmlStrMid='';
								var itemsArray=[];
								var highChartUrls = new Array();
								var highChartIds = new Array();
								var highChartFmts = new Array();
								var highChartXmax = new Array();
								var highChartXmin = new Array();
								var highChartMax = new Array();
								var highChartAxislabel = new Array();
								var highChartSeriesOptions = new Array();
								var highChartTotalTd = new Array();
								var highChartColor = new Array();
								var highChartTitle = new Array();
								var size = 0;
								var tmp_div_size_of_td = 0;
								var itemInc = 0;
								for(var inc in data)
								{
									if(inc.indexOf("chart") > -1)
										size = size+1;
								}
								me.createDivforHighChart(size);
								if(size > 0 )
								{
									var styleAttrbs=new Object();
									styleAttrbs['fontFamily']='Arial';
									styleAttrbs['fontSize']='10px';

									styleAttrbs['axisLabelGridColor']= ( strSkin == 'Light' )?'#dedede':'#373737';
									styleAttrbs['axisLabelColor']= ( strSkin == 'Light' )?'#606060':'#c0c0c0';
									styleAttrbs['axisLabelFontFmy']='Arial';
									styleAttrbs['axisLabelFontSize']='10px';
									styleAttrbs['axisLabelLineColor']= ( strSkin == 'Light' )?'#dedede':'#373737';
									styleAttrbs['axisLabelMinorGrid']= ( strSkin == 'Light' )?'#dedede':'#373737';
									styleAttrbs['axisLabelTickColor']= ( strSkin == 'Light' )?'#dedede':'#373737';
									styleAttrbs['axisTitleColor']= ( strSkin == 'Light' )?'#606060':'#c0c0c0';
									styleAttrbs['axisTitleFontFmy']='Arial';
									styleAttrbs['axisTitleFontSize']='11px';


									styleAttrbs['TooltipFontFmy']='Arial';
									styleAttrbs['TooltipFontSize']='11px';
									styleAttrbs['TooltipBgColor']= ( strSkin == 'Light' )?'white':'#161616';
									styleAttrbs['TooltipBorderColor']= ( strSkin == 'Light' )?'black':'#0c0c0c';

									styleAttrbs['legendFontFmy']='Arial';
									styleAttrbs['legendFontSize']='10px';
									styleAttrbs['legendColor']= ( strSkin == 'Light' )?'#2a292a':'#c0c0c0';
									styleAttrbs['titleFontClr']=( strSkin == 'Light' )?'#333333':'#c0c0c0';
									styleAttrbs['titleFontFmy']='Arial';
									styleAttrbs['titleFontSize']='12px';
									styleAttrbs['lineThickness']='2';

									var styleObj = data["styles"];
									/*if(!Ext.isEmpty(styleObj['axisLabelStyle']))
									{
										styleAttrbs['capFontClr'] = styleObj['axisLabelStyle'].COLOR;
										styleAttrbs['capFontFmy'] = styleObj['axisLabelStyle'].FAMILY;
										styleAttrbs['capFontSize'] = styleObj['axisLabelStyle'].SIZE;
										styleAttrbs['capFontWgt'] = styleObj['axisLabelStyle'].WEIGHT;
									}
									
									if(!Ext.isEmpty(styleObj['timeLabelStyle']))
									{
										styleAttrbs['xlabelfontClr'] = styleObj['timeLabelStyle'].COLOR;
										styleAttrbs['xlabelfontFmy'] = styleObj['timeLabelStyle'].FAMILY;
										styleAttrbs['xlabelfontSize'] = styleObj['timeLabelStyle'].SIZE;
										styleAttrbs['xlabelfontWgt'] = styleObj['timeLabelStyle'].WEIGHT;
									}
									if(!Ext.isEmpty(styleObj['panelLineStyle']))
									{
										styleAttrbs['plotPanelColor']=styleObj['panelLineStyle'].COLOR;
										styleAttrbs['lineThickness']=styleObj['panelLineStyle'].LINETHICKNESS;
									}*/

									for(var mainKey in data)
									{
										var dataOfKey = data[mainKey];
										if( mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") == -1)
										{
											for ( var key in dataOfKey )
											{
												if(!isNaN(key))
												{
													title = dataOfKey[key]['title'];
													fmts = dataOfKey[key]['fmts'];
													axisTitle = dataOfKey[key]['axislabel'];
													xmax = dataOfKey[key]['xmax'];
													xmin = dataOfKey[key]['xmin'];
													max = dataOfKey[key]['max'];
													colors = dataOfKey[key]['color'],
													lineWidth = dataOfKey[key]['lineWidth'],
													seriesOptions[key] =
													{
														name: dataOfKey[key]['name'],
														data: dataOfKey[key]['data'],
														color: dataOfKey[key]['color'],
														dataGrouping: {
															enabled: false
														}
													};
												}
												highChartColor.push(colors);
											}
											highChartTitle.push(title);
											highChartFmts.push(fmts);
											highChartXmax.push(xmax);
											highChartXmin.push(xmin);
											highChartMax.push(max);
											highChartAxislabel.push(axisTitle);
											highChartSeriesOptions.push(seriesOptions);
											highChartTotalTd.push(TotalTd);
											//highChartColor.push(colors);
											//if(TotalTd == 3)
											if(TotalTd == 3 || (this.tab=="emulated" && TotalTd ==1) ) //fix for emulated legends
											{
													var Legend_Total = seriesOptions.length;
													var tdValues="<table align='center'style='margin-top:10px'><tr>";
													if(Legend_Total!=null && Legend_Total!='')
													{
														for(var z=0;z<Legend_Total;z++)
														{
															var LegendTdName    =seriesOptions[z].name;
															if(LegendTdName!=null && LegendTdName.indexOf("^")>-1)
															{
																var trans_name_temp=LegendTdName.substring(0,LegendTdName.lastIndexOf("^"));
																//var color_code_temp=LegendTdName.substring(LegendTdName.lastIndexOf("^")+1);
																tdValues=tdValues+"<td width='10' height='10' align='center'>";
																tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
																tdValues=tdValues+"<tr>";
																//tdValues=tdValues+"<td width = '10' style='background:#"+color_code_temp+"' class='linesquare_white' height='10'><img src = '/final/monitor/eg_images/spacer.gif' width = '10' height = '10' border = '0'></td></tr></table></td>";
																tdValues=tdValues+"<td nowrap style='width:40px;padding-right:10px; height:10px' >"+trans_name_temp+"</td>";
															}
															else
															{
																tdValues=tdValues+"<td width='10' height='10' align='center'>";
																tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
																tdValues=tdValues+"<tr>";
																tdValues=tdValues+"<td width = '10' style='vetical-align:top' class='linesquare_white' height='5'><div style='background:"+highChartColor[z]+";height:8px;width:8px' ><div></td></tr></table></td>";
																tdValues=tdValues+"<td nowrap class='font_normal11' style='padding-left:5px;padding-right:15px; height:10px' >"+LegendTdName+"</td>";
															}
														}
													}
													tdValues = tdValues+"</tr></table>";
													var legContainer = Ext.get('legends');
													if(!Ext.isEmpty(legContainer))
													{
														Ext.getCmp('legends').update(tdValues);
													}
											}
											loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,'',max,xmax,xmin,lineWidth,styleAttrbs);
											Ext.getCmp('transchart'+TotalTd).setTitle('<span class="font_bold11">'+title+'</span>');
											TotalTd = TotalTd+1;
											itemInc = itemInc+1;
											if(!Ext.isEmpty(chartPanel.getEl()) && chartPanel.getEl() != null && chartPanel.getEl() != 'undefined')
											{
												chartPanel.getEl().unmask();
												chartPnl.setLoading(false);
											}
										}
										else
										{
											if(  mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") > -1 )
											{
												var myImgHtml = '<div style="margin:12% 0 auto 25%"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" width="70%" /></div>';
												if( itemInc < size )
												{
													var timTitle = dataOfKey.substring(4);
													Ext.getCmp('transchart'+itemInc).setTitle('<span class="font_bold11">'+timTitle+'</span>');
													Ext.getCmp('transchart'+itemInc).update(myImgHtml);
													itemInc = itemInc+1;
												}
											}
											chartPnl.setLoading(false);
										}
									}
									errorPanel = false;
								}
								else
								{
									this.displayErrorMsg();
								}
								errorPanel = false;
							}
							else
							{
								this.displayErrorMsg();
							}
							errorPanel = false;
						}
						else
						{
							this.displayErrorMsg();
						}
					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		  },
	      displayErrorMsg:function(){
			  errorPanel = true;
	    	  var chartPanel=this.getTransactionsChartPanel();
			  chartPanel.setLoading(false);
	    	  var htmlStr='<table width="100%" height="100%"><tr style="text-align:center;" width="100%" height="100%"><td width="100%" height="100%">';
	    	  //htmlStr+='<img hspace = "0" vspace = "0" border = "0" align = "center" valign="middle" src="/final/monitor/eg_images/'+chartPanel.jsonData.HiddenFields.monitorSkin+'/nographformeasure.gif">';
			  htmlStr+='<div style="text-align:center"><div class="iconInformation" style="margin:0px auto"></div><div>No measure available for the current selection</div></div>'
	    	  htmlStr+='</td></tr></table>';
			  chartPanel.removeAll();
			  chartPanel.update(htmlStr);
	      },
	      
	      getRefreshParams:function(){
	    	  var paramStr="";
	    	  var compCombo=this.getTransactionCompCombo();
	    	  
	    	/*  var timeLineCombo=this.getTransactionChartComboTimeline();
	    	  var fromHrCombo=this.getTransactionChartComboFromhr();
	    	  var toHrCombo=this.getTransactionChartComboTohr();
	    	  var modeCombo=this.getTransactionChartComboMode();
	    	  var fromDateCombo=this.getTransactionChartFromDate();
	    	  var toDateCombo=this.getTransactionChartToDate();*/

		  var timeLineCombo=this.getTransactionComboTimeline();
	    	  var fromHrCombo=this.getTransactionComboFromhr();
	    	  var toHrCombo=this.getTransactionComboTohr();
	    	  var modeCombo=this.getTransactionComboMode();
	    	  var fromDateCombo=this.getTransactionFromDate();
	    	  var toDateCombo=this.getTransactionToDate();
	    	  
	    	  if(!Ext.isEmpty(compCombo)){
	    		  paramStr+="&transComp="+compCombo.getValue();
	    	  }
	    	  var selectedTab="Transactions"
	    	  if(this.tab=="emulated"){
	    		  selectedTab="EmulatedClients";
	    	  }
	    	  if(!Ext.isEmpty(selectedTab)){
	    		  paramStr+="&selectedTab="+selectedTab;
	    	  }
	    	  
	    	  if(!Ext.isEmpty(timeLineCombo)){
	    		  paramStr+="&time_line="+timeLineCombo.getValue();
	    	  }
	    	  if(!Ext.isEmpty(fromHrCombo)){
	    		  paramStr+="&starthr="+fromHrCombo.getValue();
	    	  }
	    	  if(!Ext.isEmpty(toHrCombo)){
	    		  paramStr+="&endhr="+toHrCombo.getValue();
	    	  }
	    	  if(!Ext.isEmpty(modeCombo)){
	    		  paramStr+="&mode="+modeCombo.getValue();
	    	  }
	    	  if(!Ext.isEmpty(fromDateCombo)){
	    		  tempstarttime=Ext.Date.format(fromDateCombo.getValue(),mgr_dateFormat);
	    		  paramStr+="&starttime="+tempstarttime;
	    	  }
	    	  if(!Ext.isEmpty(toDateCombo)){
	    		  tempendtime=Ext.Date.format(toDateCombo.getValue(),mgr_dateFormat);
	    		  paramStr+="&endtime="+tempendtime;
	    	  }
	    	  paramStr+="&isAreaChart="+isAreaChart;
	    	  return paramStr;
	      },
	      
	      //to handle horizontal scroll for transaction zoom panel
	      transactionsZoomLoaded:function(){
	    	  var imgPanel=this.getZoomGraphImgPanel();
	    	  if(!Ext.isEmpty(imgPanel)){
	    		  imgPanel.handleScrollBars(imgPanel);
	    	  }
	      },

			 
	up:function(thisObj, e, eOpts){
		if(this.getDown().isHidden()){
			this.getTransactionsChartPanel().show();
			this.getDown().show();
		}
		else{
			this.getTransactionGridPanel().hide();
			thisObj.hide();
		}
	},

	down:function(thisObj, e, eOpts){
		if(this.getUp().isHidden()){
			this.getTransactionGridPanel().show();
			this.getUp().show();
		}
		else{
			this.getTransactionsChartPanel().hide();
			thisObj.hide();
		}
	},
	
	onCheckClicked:function(checkbox,checked){
		var checks = checkbox.up('configuretransactions').query('checkboxfield[name=transactions]');
		var flagDel = true;
		if(!checked){
			flagDel = false;
			for(i=0;i<checks.length;i++){
				if(checks[i].checked){
					flagDel = true;
				}
			}
		}
		if(flagDel){
			this.getDeleteTransactionsButton().show();
			this.getDeselectAllButton().show();
		}
		else{
			this.getDeleteTransactionsButton().hide();
			this.getDeselectAllButton().hide();
		}
	},

	selectAll:function(button){
		var checks = button.up('servicesdashboard').query('checkboxfield[name=transactions]');
		for(i=0;i<checks.length;i++){
			if(!checks[i].isDisabled())
				checks[i].setValue(true);
		}
	},

	deselectAll:function(button){
		var checks = button.up('servicesdashboard').query('checkboxfield[name=transactions]');
		for(i=checks.length-1;i>=0;i--){
			checks[i].setValue(false);
		}
	},
	getCurrentDateTime:function(){
	var endHr="";
	var startHr="";
	var starttime="";
	var endtime="";
	var time_line ="";
	var retDate = "";
	//var chartToolbar=this.getTransactionsChartPanelToolbar();
	var chartToolbar=this.getTransactionsPanelToolbar();
	var timelineCombo=chartToolbar.getComponent("timeline");
	if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
	    			  time_line=timelineCombo.getValue();
	    		  }
	 var startTimeField=chartToolbar.getComponent("from");
	  if(!Ext.isEmpty(startTimeField)){
		  if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
			  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
		  }else{
			  if(!Ext.isEmpty(time_line_obj)){
				  starttime=time_line_obj.starttime;
			  }else{
				  starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
			  }
		  }
	  }
	  
	  var endTimeField=chartToolbar.getComponent("to");
	  if(!Ext.isEmpty(endTimeField)){
		  if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
		  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
		  }else{
			  if(!Ext.isEmpty(time_line_obj)){
				  endtime=time_line_obj.endtime;
			  }else{
				  endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
			  }
		  }
	  }
	
	var fromCombo=chartToolbar.getComponent("fromhr");
	if(!Ext.isEmpty(fromCombo))
		{
		  if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
			startHr=fromCombo.getValue();
			 
		  }else{
			  if(!Ext.isEmpty(time_line_obj)){
				  startHr=time_line_obj.starthr;
				   
			  }else{
					startHr=fromCombo.getValue();
				}
		}
	}

	  var toCombo=chartToolbar.getComponent("tohr");
	  if(!Ext.isEmpty(toCombo)){
		  if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
			  endHr=toCombo.getValue();
		}else{
			  if(!Ext.isEmpty(time_line_obj)){
					endHr=time_line_obj.endhr;
			  }else{
					endHr=toCombo.getValue();
			  }
		  }
	  }
	if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(endTimeField)){
		starttime = Ext.Date.dateFormat(startTimeField.getValue(), 'm/d/Y');
		endtime = Ext.Date.dateFormat(endTimeField.getValue(), 'm/d/Y');
		retDate = time_line+":"+starttime+":"+startHr+":"+endtime+":"+endHr;
	}
	return retDate;
},
changeTab:function( tabPanel, newCard, oldCard, eOpts){
	 var tabInx = 0;
	if(newCard.itemId == "serviceToolbarEmulatedButton"){
		  this.tabPanel="emulated";
		  tabInx = 1;
		 //  this.setActiveTab(1);
	  }else{
		  this.tabPanel="web";
		 //  this.setActiveTab(0);
	  }
	  var url=newCard.dataUrl;
	  var transCombo=this.getTransactionCompCombo();
	  if(!Ext.isEmpty(transCombo)){
		  var comp=transCombo.getValue();
		  url+="&transComp="+comp;
	  }
	  if(!Ext.isEmpty(url)){
		  Ext.Ajax.request({
			  url : url,
			  scope:this,
			  timeout:280000,
			  success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					jsonData['isTabChanged'] = true;
					jsonData['tabInx'] = tabInx;
					  this.getTransactionsMainPanel().removeAll();
					 
						this.getTransactionsMainPanel().updateLabels(jsonData.GridScreenLabels,jsonData.ComponentList);
						this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
						 if(!Ext.isEmpty(jsonData.GridScreenLabels.TransactionHeaders)){
							this.getTransactionsMainPanel().displayGrid(jsonData);
							this.getTransactionsMainPanel().showGrid(jsonData);
						}
			  },
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		  });
	  }
		
	},
	settingClick:function(image){
		var timlinePos=Ext.getCmp("settingBt").getPosition();
		var winObj = Ext.getCmp('timeWindow');
		winObj.showAt([timlinePos[0]-680,timlinePos[1]+20]);
		//winObj.show();
		//winObj.setPosition(image.x+50-winObj.getWidth(),image.y+320);

	}

});

function dateValidation(starttime,endtime,starthr,endhr,startmin,tomin)
{	
	var styear = parseInt(starttime.substring((starttime.lastIndexOf("/")+1)));		
	var stday = parseInt(starttime.substring((starttime.indexOf("/")+1),starttime.lastIndexOf("/")));
	var stmon = parseInt(starttime.substring(0,starttime.indexOf("/")));
	var endyear = parseInt(endtime.substring((endtime.lastIndexOf("/")+1)));
	var endday = parseInt(endtime.substring((endtime.indexOf("/")+1),endtime.lastIndexOf("/")));
	var endmon = parseInt(endtime.substring(0,endtime.indexOf("/")));
	var state=0;	
	if(styear > endyear)			
		state=-1;		
	else if(styear == endyear)			
		if(stmon > endmon)				
			state=-1;				
		else if(stmon == endmon)
			if(stday > endday)						
				state=-1;
			else if(stday == endday)
				if(starthr > endhr)
					state = -1;
				else if(starthr == endhr)
					if(startmin >= tomin)
						state = -1;
	
	return state;
}